/*******************************************************************************
* filereader.cpp: file reader
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: filereader.cpp,v 1.4.4.1 2003/05/16 19:43:59 nitrox Exp $
*
* Authors: Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../../core/defs.h"

#include "../../core/core.h"

#include "../../mpeg/mpeg.h"
#include "../../mpeg/ts.h"

#include "../../server/buffer.h"
#include "../../server/broadcast.h"
#include "../../server/request.h"

#include "../../mpeg/reader.h"
#include "../../mpeg/converter.h"

#include "filereader.h"


//------------------------------------------------------------------------------
// Library declaration
//------------------------------------------------------------------------------
#ifdef __PLUGIN__
GENERATE_LIB_ARGS(C_FileMpegReaderModule, handle);
#endif


//------------------------------------------------------------------------------
// Builtin declaration
//------------------------------------------------------------------------------
#ifdef __BUILTIN__
C_Module* NewBuiltin_filereader(handle hLog)
{
  return new C_FileMpegReaderModule(hLog);
}
#endif


/*******************************************************************************
* C_FileMpegReader
********************************************************************************
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
C_FileMpegReader::C_FileMpegReader(C_Module* pModule,
                                   C_Broadcast* pBroadcast) :
                        C_MpegReader(pModule, pBroadcast),
                        m_cFile(pBroadcast->GetOption("filename"))
{
  if(pBroadcast->GetOption("loop") == "1")
    m_bLoop = true;
  else
    m_bLoop = false;

  if(pBroadcast->GetOption("end") == "1")
    m_bEnd = true;
  else
    m_bEnd = false;
}


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------
void C_FileMpegReader::Init()
{
  m_cFile.Open("rb");

  // Jump to end of buffer to a distance of about 3 seconds from end
  if (m_bEnd)
  {
    if (m_cFile.Seek( (long)-(3*8*188*1024), FILE_SEEK_END)==-1)
        printf( "Option --end failed to start.\n");
    else
        printf( "Option --end started.\n" );
  }
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_FileMpegReader::Close()
{
  m_cFile.Close();
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_FileMpegReader::Read(byte* pBuff, int iSize)
{
  try 
  {
    int iRc = m_cFile.Read(pBuff, iSize);
    // Loop on stream and set the discontinuity flag
    if((iRc<0) && m_bLoop)
    {
      m_cFile.Seek(0, FILE_SEEK_BEGIN);
      m_bDiscontinuity = true;
      iRc = m_cFile.Read(pBuff, iSize);
    }
    return iRc;
  }
  catch(E_File e)
  {
    return MPEG_STREAMERROR;
  }
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_FileMpegReader::Seek(s64 iOffset, int bStartPos)
{
  return m_cFile.Seek(iOffset, bStartPos);
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
s64 C_FileMpegReader::Size()
{
  ASSERT(false);
  return 0;
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
s64 C_FileMpegReader::GetPos()
{
  return m_cFile.GetPos();
}
