/*****************************************************************************
 * send.c
 * Send a message to the server from the snmp/db/intf
 *****************************************************************************
 * Copyright (C) 1998, 1999, 2000, 2001 VideoLAN
 * $Id: send.c,v 1.4 2001/04/29 03:41:49 nitrox Exp $
 *
 * Authors: Laurent Rossier <gunther@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <arpa/inet.h>                                            /* types.h */
#include <sys/socket.h>                                            /* sendto */
#include <unistd.h>                                                 /* close */
#include <string.h>                                                 /* bzero */

#include "../types.h"
#include "../logger.h"

#include "send.h"

/*****************************************************************************
 * VS_send
 *****************************************************************************
 * Send a message to the server (useful for the snmp, the interface and
 * the db)
 *****************************************************************************/
ERR_CODE VS_send(unsigned short int port, union VS_send_info * info)
{
  struct sockaddr_in server;
  int socket_se;
  int rc;

  bzero(&server,sizeof(struct sockaddr_in));
  server.sin_family=AF_INET;
  server.sin_port=port;
  server.sin_addr.s_addr=inet_addr("127.0.0.1");

  socket_se=socket(AF_INET,SOCK_DGRAM,0);
  rc=sendto(socket_se, info, sizeof(union VS_send_info), 0,
            (struct sockaddr *)(&server), sizeof(struct sockaddr));
  if(rc==-1)
  {
    VS_log(LOGERROR, SERVER, "unable to send the data to the server from the "\
                                              "snmp, the interface or the db");
    close(socket_se);
    return VS_R_SEND;
  }
  close(socket_se);
  return 0;
}
