/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.SliderBGGen;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.SliderBackgroundEditEvent;
import vlcskineditor.items.Slider;
import vlcskineditor.resources.ImageResource;

public class SliderBackground
extends Item
implements ActionListener {
    public final int NBHORIZ_DEFAULT = 1;
    public final int NBVERT_DEFAULT = 1;
    public final int PADHORIZ_DEFAULT = 0;
    public final int PADVERT_DEFAULT = 0;
    public String image;
    public int nbhoriz = 1;
    public int nbvert = 1;
    public int padhoriz = 0;
    public int padvert = 0;
    JFrame frame;
    public JTextField id_tf;
    public JTextField image_tf;
    public JTextField nbhoriz_tf;
    public JTextField nbvert_tf;
    public JTextField padhoriz_tf;
    public JTextField padvert_tf;
    JButton gen_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    ImageResource image_res;
    BufferedImage bi = null;
    String bitmap_str = "";
    Slider sl;
    private float sliderVal = 0.5f;

    public SliderBackground(Node node, Skin skin) {
        this.type = Language.get("SLIDERBG");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.image = XML.getStringAttributeValue(node, "image", this.image);
        this.nbhoriz = XML.getIntAttributeValue(node, "nbhoriz", this.nbhoriz);
        this.nbvert = XML.getIntAttributeValue(node, "nbvert", this.nbvert);
        this.padhoriz = XML.getIntAttributeValue(node, "padhoriz", this.padhoriz);
        this.padvert = XML.getIntAttributeValue(node, "padvert", this.padvert);
        this.image_res = this.s.getImageResource(this.image);
        this.created = true;
    }

    public SliderBackground(String string, Skin skin) {
        this.type = Language.get("SLIDERBG");
        this.s = skin;
        this.image = XML.getValue(string, "image");
        this.image_res = this.s.getImageResource(this.image);
        if (string.indexOf("nbhoriz=\"") != -1) {
            this.nbhoriz = XML.getIntValue(string, "nbhoriz");
        }
        if (string.indexOf("nbvert=\"") != -1) {
            this.nbvert = XML.getIntValue(string, "nbvert");
        }
        if (string.indexOf("padhoriz=\"") != -1) {
            this.padhoriz = XML.getIntValue(string, "padhoriz");
        }
        if (string.indexOf("padvert=\"") != -1) {
            this.padvert = XML.getIntValue(string, "padvert");
        }
        this.id = string.indexOf("id=\"") != -1 ? XML.getValue(string, "id") : Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.created = true;
    }

    public SliderBackground(Skin skin, Slider slider) {
        this.type = Language.get("SLIDERBG");
        this.s = skin;
        this.sl = slider;
        this.image = "none";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.image = this.image_tf.getText();
            this.nbhoriz = Integer.parseInt(this.nbhoriz_tf.getText());
            this.nbvert = Integer.parseInt(this.nbvert_tf.getText());
            this.padhoriz = Integer.parseInt(this.padhoriz_tf.getText());
            this.padvert = Integer.parseInt(this.padvert_tf.getText());
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            SliderBackgroundEditEvent sliderBackgroundEditEvent = new SliderBackgroundEditEvent(this);
            this.id = this.id_tf.getText();
            this.image = this.image_tf.getText();
            this.nbhoriz = Integer.parseInt(this.nbhoriz_tf.getText());
            this.nbvert = Integer.parseInt(this.nbvert_tf.getText());
            this.padhoriz = Integer.parseInt(this.padhoriz_tf.getText());
            this.padvert = Integer.parseInt(this.padvert_tf.getText());
            sliderBackgroundEditEvent.setNew();
            this.s.m.hist.addEvent(sliderBackgroundEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_SBG_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            this.gen_btn = new JButton(Language.get("WIN_SBG_WIZARD"));
            this.gen_btn.addActionListener(this);
            JLabel jLabel2 = new JLabel(Language.get("WIN_SBG_IMAGE"));
            this.image_tf = new JTextField();
            JLabel jLabel3 = new JLabel(Language.get("WIN_SBG_NBHORIZ"));
            this.nbhoriz_tf = new JTextField();
            this.nbhoriz_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel4 = new JLabel(Language.get("WIN_SBG_NBVERT"));
            this.nbvert_tf = new JTextField();
            this.nbvert_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel5 = new JLabel(Language.get("WIN_SBG_PADHORIZ"));
            this.padhoriz_tf = new JTextField();
            this.padhoriz_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel6 = new JLabel(Language.get("WIN_SBG_PADVERT"));
            this.padvert_tf = new JTextField();
            this.padvert_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel7 = new JLabel(Language.get("NOTE_STARRED"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.id_tf);
            this.frame.add(jPanel);
            this.frame.add(this.gen_btn);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel2);
            jPanel2.add(this.image_tf);
            this.image_tf.setPreferredSize(new Dimension(n2, this.image_tf.getPreferredSize().height));
            jPanel2.add(jLabel3);
            jPanel2.add(this.nbhoriz_tf);
            jPanel2.add(jLabel4);
            jPanel2.add(this.nbvert_tf);
            jPanel2.add(jLabel5);
            jPanel2.add(this.padhoriz_tf);
            jPanel2.add(jLabel6);
            jPanel2.add(this.padvert_tf);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_SBG_ATTR")));
            SpringLayout springLayout2 = new SpringLayout();
            springLayout2.putConstraint("North", (Component)jLabel2, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.image_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout2.putConstraint("West", (Component)this.image_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.image_tf);
            springLayout2.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.nbhoriz_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout2.putConstraint("West", (Component)this.nbhoriz_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.nbhoriz_tf, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.nbhoriz_tf);
            springLayout2.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.nbvert_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)this.nbvert_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.nbvert_tf, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.nbvert_tf);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.padhoriz_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.padhoriz_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.padhoriz_tf, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.padhoriz_tf);
            springLayout2.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.padvert_tf, 0, "VerticalCenter", (Component)jLabel6);
            springLayout2.putConstraint("West", (Component)this.padvert_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.padvert_tf, 0, "East", (Component)this.image_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.image_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.padvert_tf);
            jPanel2.setLayout(springLayout2);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel7);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.gen_btn, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("HorizontalCenter", (Component)this.gen_btn, 0, "HorizontalCenter", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)this.gen_btn);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("East", (Component)jPanel2, 0, "East", (Component)jPanel);
            springLayout3.putConstraint("North", (Component)jLabel7, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel7, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel7);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout3);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.image_tf.setText(this.image);
        this.nbhoriz_tf.setText(String.valueOf(this.nbhoriz));
        this.nbvert_tf.setText(String.valueOf(this.nbvert));
        this.padhoriz_tf.setText(String.valueOf(this.padhoriz));
        this.padvert_tf.setText(String.valueOf(this.padvert));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.image_res = this.s.getImageResource(this.image_tf.getText());
            if (this.image_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.image_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.image_res = this.s.getImageResource(this.image);
                return;
            }
            this.update();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-sliderbg.html");
        } else if (actionEvent.getSource().equals(this.gen_btn)) {
            SliderBGGen sliderBGGen = new SliderBGGen(this, this.s);
            sliderBGGen.setDefaultCloseOperation(2);
            sliderBGGen.setVisible(true);
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
            if (!this.created) {
                this.sl.removeBG();
            }
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<SliderBackground";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        string2 = string2 + " image=\"" + this.image + "\"";
        if (this.nbhoriz != 1) {
            string2 = string2 + " nbhoriz=\"" + String.valueOf(this.nbhoriz) + "\"";
        }
        if (this.nbvert != 1) {
            string2 = string2 + " nbvert=\"" + String.valueOf(this.nbvert) + "\"";
        }
        if (this.padhoriz != 0) {
            string2 = string2 + " padhoriz=\"" + String.valueOf(this.padhoriz) + "\"";
        }
        if (this.padvert != 0) {
            string2 = string2 + " padvert=\"" + String.valueOf(this.padvert) + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4;
        if (!this.created) {
            return;
        }
        this.bi = this.image_res.image;
        if (this.bi == null) {
            return;
        }
        int n5 = (this.bi.getWidth() - this.padhoriz * (this.nbhoriz - 1)) / this.nbhoriz;
        int n6 = (this.bi.getHeight() - this.padvert * (this.nbvert - 1)) / this.nbvert;
        int n7 = this.nbhoriz * this.nbvert;
        int n8 = (int)((float)n7 * this.sliderVal);
        int n9 = n8 / this.nbhoriz - 1;
        if (n9 < 0) {
            n9 = 0;
        }
        if ((n4 = n8 % this.nbhoriz) < 0) {
            n4 = 0;
        }
        this.bi = this.bi.getSubimage(n4 * n5 + n4 * this.padhoriz, n9 * n6 + n9 * this.padvert, n5, n6);
        graphics2D.drawImage(this.bi, (this.x + n) * n3, (this.y + n2) * n3, this.bi.getWidth() * n3, this.bi.getHeight() * n3, null);
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.bi.getWidth() * n3 - 1, this.bi.getHeight() * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.bi == null) {
            return false;
        }
        return n >= this.x + this.offsetx && n <= this.x + this.bi.getWidth() + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + this.bi.getHeight() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("SliderBackground: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.image.equals(string);
    }

    @Override
    public void updateToGlobalVariables() {
        this.sliderVal = this.s.gvars.getSliderValue();
    }
}

