/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.HistoryEvent;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.PlaytreeEditEvent;
import vlcskineditor.items.Slider;
import vlcskineditor.resources.ImageResource;
import vlcskineditor.resources.ResourceChangeListener;
import vlcskineditor.resources.ResourceChangedEvent;

public class Playtree
extends Item
implements ActionListener,
ResourceChangeListener {
    public final int WIDTH_DEFAULT = 0;
    public final int HEIGHT_DEFAULT = 0;
    public final String VAR_DEFAULT = "playlist";
    public final String BGIMAGE_DEFAULT = "none";
    public final String FGCOLOR_DEFAULT = "#000000";
    public final String PLAYCOLOR_DEFAULT = "#FF0000";
    public final String SELCOLOR_DEFAULT = "#0000FF";
    public final String BGCOLOR1_DEFAULT = "#FFFFFF";
    public final String BGCOLOR2_DEFAULT = "#FFFFFF";
    public final boolean FLAT_DEFAULT = false;
    public final String ITEMIMAGE_DEFAULT = "none";
    public final String OPENIMAGE_DEFAULT = "none";
    public final String CLOSEDIMAGE_DEFAULT = "none";
    public int width = 0;
    public int height = 0;
    public String font;
    vlcskineditor.resources.Font font_res;
    public String var = "playlist";
    public String bgimage = "none";
    public String fgcolor = "#000000";
    public String playcolor = "#FF0000";
    public String selcolor = "#0000FF";
    public String bgcolor1 = "#FFFFFF";
    public String bgcolor2 = "#FFFFFF";
    public boolean flat = false;
    public String itemimage = "none";
    public String openimage = "none";
    public String closedimage = "none";
    Slider slider = null;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField width_tf;
    JTextField height_tf;
    JTextField font_tf;
    JTextField bgimage_tf;
    JTextField itemimage_tf;
    JTextField openimage_tf;
    JTextField closedimage_tf;
    JTextField fgcolor_tf;
    JTextField playcolor_tf;
    JTextField selcolor_tf;
    JTextField bgcolor1_tf;
    JTextField bgcolor2_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox flat_cb;
    JButton visible_btn;
    JButton bgcolor1_btn;
    JButton bgcolor2_btn;
    JButton fgcolor_btn;
    JButton playcolor_btn;
    JButton selcolor_btn;
    JButton slider_btn;
    JButton ok_btn;
    JButton help_btn;
    JButton cancel_btn;
    ImageResource bgimage_res;
    ImageResource itemimage_res;
    ImageResource openimage_res;
    ImageResource closedimage_res;
    BufferedImage cache = null;

    public Playtree(Node node, Skin skin) {
        this.type = Language.get("PLAYTREE");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.width = XML.getIntAttributeValue(node, "width", this.width);
        this.height = XML.getIntAttributeValue(node, "height", this.height);
        this.font = XML.getStringAttributeValue(node, "font", this.font);
        this.bgimage = XML.getStringAttributeValue(node, "bgimage", this.bgimage);
        this.itemimage = XML.getStringAttributeValue(node, "itemimage", this.itemimage);
        this.openimage = XML.getStringAttributeValue(node, "openimage", this.openimage);
        this.closedimage = XML.getStringAttributeValue(node, "closedimage", this.closedimage);
        this.fgcolor = XML.getStringAttributeValue(node, "fgcolor", this.fgcolor);
        this.playcolor = XML.getStringAttributeValue(node, "playcolor", this.playcolor);
        this.bgcolor1 = XML.getStringAttributeValue(node, "bgcolor1", this.bgcolor1);
        this.bgcolor2 = XML.getStringAttributeValue(node, "bgcolor2", this.bgcolor2);
        this.selcolor = XML.getStringAttributeValue(node, "selcolor", this.selcolor);
        this.flat = XML.getBoolAttributeValue(node, "flat", this.flat);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.rightbottom = XML.getStringAttributeValue(node, "rightbottom", this.rightbottom);
        this.xkeepratio = XML.getBoolAttributeValue(node, "xkeepratio", this.xkeepratio);
        this.ykeepratio = XML.getBoolAttributeValue(node, "ykeepratio", this.ykeepratio);
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.help = XML.getStringAttributeValue(node, "help", this.help);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Slider")) continue;
            this.slider = new Slider(nodeList.item(i), this.s, true);
        }
        this.bgimage_res = this.s.getImageResource(this.bgimage);
        this.openimage_res = this.s.getImageResource(this.openimage);
        this.closedimage_res = this.s.getImageResource(this.closedimage);
        this.itemimage_res = this.s.getImageResource(this.itemimage);
        try {
            this.font_res = (vlcskineditor.resources.Font)this.s.getResource(this.font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.bgimage_res != null) {
            this.bgimage_res.addResourceChangeListener(this);
        }
        if (this.openimage_res != null) {
            this.openimage_res.addResourceChangeListener(this);
        }
        if (this.closedimage_res != null) {
            this.closedimage_res.addResourceChangeListener(this);
        }
        if (this.itemimage_res != null) {
            this.itemimage_res.addResourceChangeListener(this);
        }
        if (this.font_res != null) {
            this.font_res.addResourceChangeListener(this);
        }
        this.created = true;
    }

    public Playtree(Skin skin) {
        this.type = Language.get("PLAYTREE");
        this.s = skin;
        this.font = "defaultfont";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.slider = new Slider(this.s, true);
        this.showOptions();
        this.s.updateItems();
    }

    public Playtree(Playtree playtree) {
        super(playtree);
        this.type = Language.get("PLAYTREE");
        this.width = playtree.width;
        this.height = playtree.height;
        this.font = playtree.font;
        this.bgimage = playtree.bgimage;
        this.openimage = playtree.openimage;
        this.closedimage = playtree.closedimage;
        this.itemimage = playtree.itemimage;
        this.fgcolor = playtree.fgcolor;
        this.bgcolor1 = playtree.bgcolor1;
        this.bgcolor2 = playtree.bgcolor2;
        this.playcolor = playtree.playcolor;
        this.selcolor = playtree.selcolor;
        this.flat = playtree.flat;
        if (playtree.slider != null) {
            this.slider = new Slider(playtree.slider);
        }
        this.bgimage_res = this.s.getImageResource(this.bgimage);
        this.openimage_res = this.s.getImageResource(this.openimage);
        this.closedimage_res = this.s.getImageResource(this.closedimage);
        this.itemimage_res = this.s.getImageResource(this.itemimage);
        try {
            this.font_res = (vlcskineditor.resources.Font)this.s.getResource(this.font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.bgimage_res != null) {
            this.bgimage_res.addResourceChangeListener(this);
        }
        if (this.openimage_res != null) {
            this.openimage_res.addResourceChangeListener(this);
        }
        if (this.closedimage_res != null) {
            this.closedimage_res.addResourceChangeListener(this);
        }
        if (this.itemimage_res != null) {
            this.itemimage_res.addResourceChangeListener(this);
        }
        if (this.font_res != null) {
            this.font_res.addResourceChangeListener(this);
        }
    }

    @Override
    public void update() {
        HistoryEvent historyEvent;
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.font = this.font_tf.getText();
            this.bgimage = this.bgimage_tf.getText();
            this.itemimage = this.itemimage_tf.getText();
            this.openimage = this.openimage_tf.getText();
            this.closedimage = this.closedimage_tf.getText();
            this.fgcolor = this.fgcolor_tf.getText();
            this.selcolor = this.selcolor_tf.getText();
            this.playcolor = this.playcolor_tf.getText();
            this.bgcolor1 = this.bgcolor1_tf.getText();
            this.bgcolor2 = this.bgcolor2_tf.getText();
            this.flat = (Boolean)this.flat_cb.getSelectedItem();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            historyEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(historyEvent);
        } else {
            historyEvent = new PlaytreeEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.font = this.font_tf.getText();
            this.bgimage = this.bgimage_tf.getText();
            this.itemimage = this.itemimage_tf.getText();
            this.openimage = this.openimage_tf.getText();
            this.closedimage = this.closedimage_tf.getText();
            this.fgcolor = this.fgcolor_tf.getText();
            this.selcolor = this.selcolor_tf.getText();
            this.playcolor = this.playcolor_tf.getText();
            this.bgcolor1 = this.bgcolor1_tf.getText();
            this.bgcolor2 = this.bgcolor2_tf.getText();
            this.flat = (Boolean)this.flat_cb.getSelectedItem();
            this.s.updateItems();
            this.s.expandItem(this.id);
            historyEvent.setNew();
            this.s.m.hist.addEvent(historyEvent);
        }
        this.updateToGlobalVariables();
        this.updateCache();
        try {
            this.font_res = (vlcskineditor.resources.Font)this.s.getResource(this.font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.bgimage_res != null) {
            this.bgimage_res.addResourceChangeListener(this);
        }
        if (this.openimage_res != null) {
            this.openimage_res.addResourceChangeListener(this);
        }
        if (this.closedimage_res != null) {
            this.closedimage_res.addResourceChangeListener(this);
        }
        if (this.itemimage_res != null) {
            this.itemimage_res.addResourceChangeListener(this);
        }
        if (this.font_res != null) {
            this.font_res.addResourceChangeListener(this);
        }
    }

    @Override
    public void showOptions() {
        if (this.bgimage_res != null) {
            this.bgimage_res.removeResourceChangeListener(this);
        }
        if (this.openimage_res != null) {
            this.openimage_res.removeResourceChangeListener(this);
        }
        if (this.closedimage_res != null) {
            this.closedimage_res.removeResourceChangeListener(this);
        }
        if (this.itemimage_res != null) {
            this.itemimage_res.removeResourceChangeListener(this);
        }
        if (this.font_res != null) {
            this.font_res.removeResourceChangeListener(this);
        }
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_PLAYTREE_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_RIGHTBOTTOM"));
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText(Language.get("WIN_ITEM_RIGHTBOTTOM_TIP"));
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel(Language.get("WIN_ITEM_XKEEPRATIO"));
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText(Language.get("WIN_ITEM_XKEEPRATIO_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_YKEEPRATIO"));
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText(Language.get("WIN_ITEM_YKEEPRATIO_TIP"));
            JLabel jLabel8 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", Main.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel(Language.get("WIN_ITEM_HELP"));
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText(Language.get("WIN_ITEM_HELP_TIP"));
            JLabel jLabel10 = new JLabel(Language.get("WIN_ITEM_WIDTH"));
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel11 = new JLabel(Language.get("WIN_ITEM_HEIGHT"));
            this.height_tf = new JTextField();
            this.height_tf.setDocument(new NumbersOnlyDocument(false));
            JLabel jLabel12 = new JLabel(Language.get("WIN_PLAYTREE_FONT"));
            this.font_tf = new JTextField();
            JLabel jLabel13 = new JLabel(Language.get("WIN_PLAYTREE_BGIMAGE"));
            this.bgimage_tf = new JTextField();
            this.bgimage_tf.setToolTipText(Language.get("WIN_PLAYTREE_BGIMAGE_TIP"));
            JLabel jLabel14 = new JLabel(Language.get("WIN_PLAYTREE_BGCOLOR1"));
            this.bgcolor1_tf = new JTextField();
            this.bgcolor1_btn = new JButton(Language.get("WIN_PLAYTREE_CHOOSE"));
            this.bgcolor1_btn.addActionListener(this);
            JLabel jLabel15 = new JLabel(Language.get("WIN_PLAYTREE_BGCOLOR2"));
            this.bgcolor2_tf = new JTextField();
            this.bgcolor2_btn = new JButton(Language.get("WIN_PLAYTREE_CHOOSE"));
            this.bgcolor2_btn.addActionListener(this);
            JLabel jLabel16 = new JLabel(Language.get("WIN_PLAYTREE_SELCOLOR"));
            this.selcolor_tf = new JTextField();
            this.selcolor_btn = new JButton(Language.get("WIN_PLAYTREE_CHOOSE"));
            this.selcolor_btn.addActionListener(this);
            JLabel jLabel17 = new JLabel(Language.get("WIN_PLAYTREE_FGCOLOR"));
            this.fgcolor_tf = new JTextField();
            this.fgcolor_btn = new JButton(Language.get("WIN_PLAYTREE_CHOOSE"));
            this.fgcolor_btn.addActionListener(this);
            JLabel jLabel18 = new JLabel(Language.get("WIN_PLAYTREE_PLAYCOLOR"));
            this.playcolor_tf = new JTextField();
            this.playcolor_btn = new JButton(Language.get("WIN_PLAYTREE_CHOOSE"));
            this.playcolor_btn.addActionListener(this);
            JLabel jLabel19 = new JLabel(Language.get("WIN_PLAYTREE_FLAT"));
            this.flat_cb = new JComboBox<Object>(objectArray);
            this.flat_cb.setToolTipText(Language.get("WIN_PLAYTREE_FLAT_TIP"));
            JLabel jLabel20 = new JLabel(Language.get("WIN_PLAYTREE_ITEMIMAGE"));
            this.itemimage_tf = new JTextField();
            JLabel jLabel21 = new JLabel(Language.get("WIN_PLAYTREE_OPENIMAGE"));
            this.openimage_tf = new JTextField();
            JLabel jLabel22 = new JLabel(Language.get("WIN_PLAYTREE_CLOSEDIMAGE"));
            this.closedimage_tf = new JTextField();
            this.slider_btn = new JButton(Language.get("WIN_PLAYTREE_SLIDER"));
            this.slider_btn.addActionListener(this);
            JLabel jLabel23 = new JLabel(Language.get("NOTE_STARRED"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel10, jLabel11, jLabel12, jLabel13, jLabel14, jLabel15, jLabel16, jLabel17, jLabel18, jLabel19, jLabel20, jLabel21, jLabel22};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jPanel.add(jLabel10);
            jPanel.add(this.width_tf);
            jPanel.add(jLabel11);
            jPanel.add(this.height_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.lefttop_cb);
            springLayout.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.rightbottom_cb, 0, "VerticalCenter", (Component)jLabel5);
            springLayout.putConstraint("West", (Component)this.rightbottom_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.rightbottom_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.rightbottom_cb);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.xkeepratio_cb, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.xkeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.xkeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.xkeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.ykeepratio_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.ykeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.ykeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel8, 10, "South", (Component)this.ykeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel8, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, -5, "West", (Component)this.visible_btn);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_btn, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("East", (Component)this.visible_btn, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel9, 10, "South", (Component)this.visible_btn);
            springLayout.putConstraint("West", (Component)jLabel9, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.help_tf, 0, "VerticalCenter", (Component)jLabel9);
            springLayout.putConstraint("West", (Component)this.help_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.help_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel10, 10, "South", (Component)this.help_tf);
            springLayout.putConstraint("West", (Component)jLabel10, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.width_tf, 0, "VerticalCenter", (Component)jLabel10);
            springLayout.putConstraint("West", (Component)this.width_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.width_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel11, 10, "South", (Component)this.width_tf);
            springLayout.putConstraint("West", (Component)jLabel11, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.height_tf, 0, "VerticalCenter", (Component)jLabel11);
            springLayout.putConstraint("West", (Component)this.height_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.height_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.height_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jLabel12);
            jPanel2.add(this.font_tf);
            this.font_tf.setPreferredSize(new Dimension(n2, this.font_tf.getPreferredSize().height));
            jPanel2.add(jLabel13);
            jPanel2.add(this.bgimage_tf);
            jPanel2.add(jLabel14);
            jPanel2.add(this.bgcolor1_tf);
            this.bgcolor1_tf.setPreferredSize(new Dimension(n2 / 2, this.bgcolor1_tf.getPreferredSize().height));
            jPanel2.add(this.bgcolor1_btn);
            jPanel2.add(jLabel15);
            jPanel2.add(this.bgcolor2_tf);
            this.bgcolor2_tf.setPreferredSize(new Dimension(n2 / 2, this.bgcolor2_tf.getPreferredSize().height));
            jPanel2.add(this.bgcolor2_btn);
            jPanel2.add(jLabel16);
            jPanel2.add(this.selcolor_tf);
            this.selcolor_tf.setPreferredSize(new Dimension(n2 / 2, this.selcolor_tf.getPreferredSize().height));
            jPanel2.add(this.selcolor_btn);
            jPanel2.add(jLabel17);
            jPanel2.add(this.fgcolor_tf);
            this.fgcolor_tf.setPreferredSize(new Dimension(n2 / 2, this.fgcolor_tf.getPreferredSize().height));
            jPanel2.add(this.fgcolor_btn);
            jPanel2.add(jLabel18);
            jPanel2.add(this.playcolor_tf);
            this.playcolor_tf.setPreferredSize(new Dimension(n2 / 2, this.playcolor_tf.getPreferredSize().height));
            jPanel2.add(this.playcolor_btn);
            jPanel2.add(jLabel19);
            jPanel2.add(this.flat_cb);
            jPanel2.add(jLabel20);
            jPanel2.add(this.itemimage_tf);
            jPanel2.add(jLabel21);
            jPanel2.add(this.openimage_tf);
            jPanel2.add(jLabel22);
            jPanel2.add(this.closedimage_tf);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_PLAYTREE_ATTR")));
            SpringLayout springLayout2 = new SpringLayout();
            springLayout2.putConstraint("North", (Component)jLabel12, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel12, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.font_tf, 0, "VerticalCenter", (Component)jLabel12);
            springLayout2.putConstraint("West", (Component)this.font_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel13, 10, "South", (Component)this.font_tf);
            springLayout2.putConstraint("West", (Component)jLabel13, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.bgimage_tf, 0, "VerticalCenter", (Component)jLabel13);
            springLayout2.putConstraint("West", (Component)this.bgimage_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.bgimage_tf, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel14, 10, "South", (Component)this.bgimage_tf);
            springLayout2.putConstraint("West", (Component)jLabel14, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.bgcolor1_tf, 0, "VerticalCenter", (Component)jLabel14);
            springLayout2.putConstraint("West", (Component)this.bgcolor1_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.bgcolor1_btn, 0, "VerticalCenter", (Component)jLabel14);
            springLayout2.putConstraint("West", (Component)this.bgcolor1_btn, 5, "East", (Component)this.bgcolor1_tf);
            springLayout2.putConstraint("East", (Component)this.bgcolor1_btn, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel15, 10, "South", (Component)this.bgcolor1_tf);
            springLayout2.putConstraint("West", (Component)jLabel15, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.bgcolor2_tf, 0, "VerticalCenter", (Component)jLabel15);
            springLayout2.putConstraint("West", (Component)this.bgcolor2_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.bgcolor2_btn, 0, "VerticalCenter", (Component)jLabel15);
            springLayout2.putConstraint("West", (Component)this.bgcolor2_btn, 5, "East", (Component)this.bgcolor2_tf);
            springLayout2.putConstraint("East", (Component)this.bgcolor2_btn, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel16, 10, "South", (Component)this.bgcolor2_tf);
            springLayout2.putConstraint("West", (Component)jLabel16, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.selcolor_tf, 0, "VerticalCenter", (Component)jLabel16);
            springLayout2.putConstraint("West", (Component)this.selcolor_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.selcolor_btn, 0, "VerticalCenter", (Component)jLabel16);
            springLayout2.putConstraint("West", (Component)this.selcolor_btn, 5, "East", (Component)this.selcolor_tf);
            springLayout2.putConstraint("East", (Component)this.selcolor_btn, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel17, 10, "South", (Component)this.selcolor_tf);
            springLayout2.putConstraint("West", (Component)jLabel17, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.fgcolor_tf, 0, "VerticalCenter", (Component)jLabel17);
            springLayout2.putConstraint("West", (Component)this.fgcolor_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.fgcolor_btn, 0, "VerticalCenter", (Component)jLabel17);
            springLayout2.putConstraint("West", (Component)this.fgcolor_btn, 5, "East", (Component)this.fgcolor_tf);
            springLayout2.putConstraint("East", (Component)this.fgcolor_btn, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel18, 10, "South", (Component)this.fgcolor_tf);
            springLayout2.putConstraint("West", (Component)jLabel18, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.playcolor_tf, 0, "VerticalCenter", (Component)jLabel18);
            springLayout2.putConstraint("West", (Component)this.playcolor_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.playcolor_btn, 0, "VerticalCenter", (Component)jLabel18);
            springLayout2.putConstraint("West", (Component)this.playcolor_btn, 5, "East", (Component)this.playcolor_tf);
            springLayout2.putConstraint("East", (Component)this.playcolor_btn, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel19, 10, "South", (Component)this.playcolor_tf);
            springLayout2.putConstraint("West", (Component)jLabel19, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.flat_cb, 0, "VerticalCenter", (Component)jLabel19);
            springLayout2.putConstraint("West", (Component)this.flat_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.flat_cb, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel20, 10, "South", (Component)this.flat_cb);
            springLayout2.putConstraint("West", (Component)jLabel20, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.itemimage_tf, 0, "VerticalCenter", (Component)jLabel20);
            springLayout2.putConstraint("West", (Component)this.itemimage_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.itemimage_tf, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel21, 10, "South", (Component)this.itemimage_tf);
            springLayout2.putConstraint("West", (Component)jLabel21, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.openimage_tf, 0, "VerticalCenter", (Component)jLabel21);
            springLayout2.putConstraint("West", (Component)this.openimage_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.openimage_tf, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("North", (Component)jLabel22, 10, "South", (Component)this.openimage_tf);
            springLayout2.putConstraint("West", (Component)jLabel22, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.closedimage_tf, 0, "VerticalCenter", (Component)jLabel22);
            springLayout2.putConstraint("West", (Component)this.closedimage_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.closedimage_tf, 0, "East", (Component)this.font_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.font_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.closedimage_tf);
            jPanel2.setLayout(springLayout2);
            this.frame.add(jPanel2);
            this.frame.add(this.slider_btn);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel23);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.slider_btn, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("HorizontalCenter", (Component)this.slider_btn, 0, "HorizontalCenter", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel23, 10, "South", (Component)this.slider_btn);
            springLayout3.putConstraint("West", (Component)jLabel23, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel23);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout3);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.width_tf.setText(String.valueOf(this.width));
        this.height_tf.setText(String.valueOf(this.height));
        this.font_tf.setText(this.font);
        this.bgimage_tf.setText(this.bgimage);
        this.fgcolor_tf.setText(this.fgcolor);
        this.selcolor_tf.setText(this.selcolor);
        this.playcolor_tf.setText(this.playcolor);
        this.bgcolor1_tf.setText(this.bgcolor1);
        this.bgcolor2_tf.setText(this.bgcolor2);
        this.flat_cb.setSelectedItem(this.flat);
        this.openimage_tf.setText(this.openimage);
        this.closedimage_tf.setText(this.closedimage);
        this.itemimage_tf.setText(this.itemimage);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.bgimage_res = this.s.getImageResource(this.bgimage_tf.getText());
            if (!this.bgimage_tf.getText().equals("none") && this.bgimage_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.bgimage_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.bgimage_res = this.s.getImageResource(this.bgimage);
                return;
            }
            this.itemimage_res = this.s.getImageResource(this.itemimage_tf.getText());
            if (!this.itemimage_tf.getText().equals("none") && this.itemimage_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.itemimage_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.itemimage_res = this.s.getImageResource(this.itemimage);
                return;
            }
            this.openimage_res = this.s.getImageResource(this.openimage_tf.getText());
            if (!this.openimage_tf.getText().equals("none") && this.openimage_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.openimage_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.openimage_res = this.s.getImageResource(this.openimage);
                return;
            }
            this.closedimage_res = this.s.getImageResource(this.closedimage_tf.getText());
            if (!this.closedimage_tf.getText().equals("none") && this.closedimage_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.closedimage_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.closedimage_res = this.s.getImageResource(this.closedimage);
                return;
            }
            if (!this.font_tf.getText().equals("defaultfont") && this.s.getResource(this.font_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_FONT_NEXIST").replaceAll("%i", this.font_tf.getText()), Language.get("ERROR_FONT_NEXIST_TITLE"), 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.bgcolor1_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_PLAYTREE_CHOOSER_TITLE"), Color.decode(this.bgcolor1_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.bgcolor1_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.bgcolor2_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_PLAYTREE_CHOOSER_TITLE"), Color.decode(this.bgcolor2_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.bgcolor2_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.fgcolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_PLAYTREE_CHOOSER_TITLE"), Color.decode(this.fgcolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.fgcolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.selcolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_PLAYTREE_CHOOSER_TITLE"), Color.decode(this.selcolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.selcolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.playcolor_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_PLAYTREE_CHOOSER_TITLE"), Color.decode(this.playcolor_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.playcolor_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.slider_btn)) {
            this.slider.showOptions();
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-playtree.html");
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/boolexpr.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            if (this.bgimage_res != null) {
                this.bgimage_res.addResourceChangeListener(this);
            }
            if (this.openimage_res != null) {
                this.openimage_res.addResourceChangeListener(this);
            }
            if (this.closedimage_res != null) {
                this.closedimage_res.addResourceChangeListener(this);
            }
            if (this.itemimage_res != null) {
                this.itemimage_res.addResourceChangeListener(this);
            }
            if (this.font_res != null) {
                this.font_res.addResourceChangeListener(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Playtree";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        string2 = string2 + " font=\"" + this.font + "\"";
        if (!this.bgcolor1.equals("#FFFFFF")) {
            string2 = string2 + " bgcolor1=\"" + this.bgcolor1 + "\"";
        }
        if (!this.bgcolor2.equals("#FFFFFF")) {
            string2 = string2 + " bgcolor2=\"" + this.bgcolor2 + "\"";
        }
        if (!this.fgcolor.equals("#000000")) {
            string2 = string2 + " fgcolor=\"" + this.fgcolor + "\"";
        }
        if (!this.selcolor.equals("#0000FF")) {
            string2 = string2 + " selcolor=\"" + this.selcolor + "\"";
        }
        if (!this.playcolor.equals("#FF0000")) {
            string2 = string2 + " playcolor=\"" + this.playcolor + "\"";
        }
        if (!this.bgimage.equals("none")) {
            string2 = string2 + " bgimage=\"" + this.bgimage + "\"";
        }
        if (!this.itemimage.equals("none")) {
            string2 = string2 + " itemimage=\"" + this.itemimage + "\"";
        }
        if (!this.openimage.equals("none")) {
            string2 = string2 + " openimage=\"" + this.openimage + "\"";
        }
        if (!this.closedimage.equals("none")) {
            string2 = string2 + " closedimage=\"" + this.closedimage + "\"";
        }
        if (!this.var.equals("playlist")) {
            string2 = string2 + " var=\"" + this.var + "\"";
        }
        if (this.flat) {
            string2 = string2 + " flat=\"" + String.valueOf(this.flat) + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (this.width != 0) {
            string2 = string2 + " width=\"" + String.valueOf(this.width) + "\"";
        }
        if (this.height != 0) {
            string2 = string2 + " height=\"" + String.valueOf(this.height) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + ">\n";
        string2 = string2 + this.slider.returnCode(string + Skin.indentation);
        string2 = string2 + "\n" + string + "</Playtree>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        if (!this.created) {
            return;
        }
        if (this.vis) {
            if (this.cache == null) {
                this.updateCache();
            }
            graphics2D.drawImage(this.cache, (this.x + n) * n3, (this.y + n2) * n3, this.width * n3, this.height * n3, null);
            this.slider.draw(graphics2D, n, n2, n3);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.width * n3 - 1, this.height * n3 - 1);
        }
    }

    public void updateCache() {
        int n;
        this.cache = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D = (Graphics2D)this.cache.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = this.s.getFont(this.font);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (!this.bgimage.equals("none")) {
            graphics2D.drawImage((Image)this.bgimage_res.image.getSubimage(0, 0, this.width, this.height), 0, 0, null);
        } else {
            graphics2D.setColor(Color.decode(this.bgcolor1));
            graphics2D.fillRect(0, 0, this.width, this.height);
            for (n = fontMetrics.getHeight(); n < this.height; n += fontMetrics.getHeight() * 2) {
                graphics2D.setColor(Color.decode(this.bgcolor2));
                graphics2D.fillRect(this.x, 0 + n, this.width, fontMetrics.getHeight());
            }
        }
        n = 0;
        BufferedImage bufferedImage = null;
        if (this.closedimage_res != null) {
            bufferedImage = this.closedimage_res.image;
        }
        BufferedImage bufferedImage2 = null;
        if (this.openimage_res != null) {
            bufferedImage2 = this.openimage_res.image;
        }
        BufferedImage bufferedImage3 = null;
        if (this.itemimage_res != null) {
            bufferedImage3 = this.itemimage_res.image;
        }
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bufferedImage != null) {
            if (bufferedImage.getHeight() > n2) {
                n2 = bufferedImage.getHeight();
            }
            n3 = (n2 - bufferedImage.getHeight()) / 2;
        }
        if (bufferedImage2 != null) {
            if (bufferedImage2.getHeight() > n2) {
                n2 = bufferedImage2.getHeight();
            }
            n4 = (n2 - bufferedImage2.getHeight()) / 2;
        }
        if (bufferedImage3 != null) {
            if (bufferedImage3.getHeight() > n2) {
                n2 = bufferedImage3.getHeight();
            }
            n5 = (n2 - bufferedImage3.getHeight()) / 2;
        }
        int n6 = (n2 - fontMetrics.getAscent()) / 2;
        graphics2D.setColor(Color.decode(this.fgcolor));
        if (bufferedImage != null && !this.flat) {
            graphics2D.drawImage((Image)bufferedImage, 0, n + n3, null);
            graphics2D.drawString("Closed folder", 0 + bufferedImage.getWidth() + 2, (n += n2) - n6);
        }
        if (bufferedImage2 != null && !this.flat) {
            graphics2D.drawImage((Image)bufferedImage2, 0, n + n4, null);
            graphics2D.drawString("Open folder", 0 + bufferedImage2.getWidth() + 2, (n += n2) - n6);
        }
        if (bufferedImage2 != null && bufferedImage3 != null && !this.flat) {
            graphics2D.drawImage((Image)bufferedImage3, 0 + bufferedImage2.getWidth() + 2, n + n5, null);
            graphics2D.drawString("Normal item", 0 + bufferedImage2.getWidth() + bufferedImage3.getWidth() + 4, (n += n2) - n6);
        } else if (bufferedImage3 != null) {
            graphics2D.drawImage((Image)bufferedImage3, 0, n + n5, null);
            graphics2D.drawString("Normal item", 0 + bufferedImage3.getWidth() + 4, (n += fontMetrics.getHeight()) - n6);
        } else {
            graphics2D.drawString("Normal item", 0, (n += fontMetrics.getHeight()) - n6);
        }
        graphics2D.setColor(Color.decode(this.playcolor));
        if (bufferedImage2 != null && bufferedImage3 != null && !this.flat) {
            graphics2D.drawImage((Image)bufferedImage3, 0 + bufferedImage2.getWidth() + 2, n + n5, null);
            graphics2D.drawString("Playing item", 0 + bufferedImage2.getWidth() + bufferedImage3.getWidth() + 4, (n += n2) - n6);
        } else if (bufferedImage3 != null) {
            graphics2D.drawImage((Image)bufferedImage3, 0, n + n5, null);
            graphics2D.drawString("Playing item", 0 + bufferedImage3.getWidth() + 2, (n += n2) - n6);
        } else {
            graphics2D.drawString("Playing item", 0, (n += n2) - n6);
        }
        graphics2D.setColor(Color.decode(this.selcolor));
        graphics2D.fillRect(0, n, this.width, n2);
        graphics2D.setColor(Color.decode(this.fgcolor));
        if (bufferedImage2 != null && bufferedImage3 != null && !this.flat) {
            graphics2D.drawImage((Image)bufferedImage3, 0 + bufferedImage2.getWidth() + 2, n + n5, null);
            graphics2D.drawString("Selected item", 0 + bufferedImage2.getWidth() + bufferedImage3.getWidth() + 4, (n += n2) - n6);
        } else if (bufferedImage3 != null) {
            graphics2D.drawImage((Image)bufferedImage3, 0, n + n5, null);
            graphics2D.drawString("Selected item", 0 + bufferedImage3.getWidth() + 2, (n += n2) - n6);
        } else {
            graphics2D.drawString("Selected item", 0, (n += n2) - n6);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return n >= this.x + this.offsetx && n <= this.x + this.width + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + this.height + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Playtree: " + this.id);
        defaultMutableTreeNode.add(this.slider.getTreeNode());
        return defaultMutableTreeNode;
    }

    @Override
    public Item getItem(String string) {
        if (this.id.equals(string)) {
            return this;
        }
        return this.slider.getItem(string);
    }

    @Override
    public Item getParentOf(String string) {
        if (this.slider != null) {
            if (this.slider.id.equals(string)) {
                return this;
            }
            return this.slider.getParentOf(string);
        }
        return null;
    }

    @Override
    public boolean uses(String string) {
        return this.slider != null && this.slider.uses(string) || this.bgimage.equals(string) || this.openimage.equals(string) || this.closedimage.equals(string) || this.itemimage.equals(string) || this.font.equals(string);
    }

    @Override
    public void renameForCopy(String string) {
        super.renameForCopy(string);
        this.slider.renameForCopy(string);
    }

    @Override
    public void updateToGlobalVariables() {
        super.updateToGlobalVariables();
        if (this.slider != null) {
            this.slider.updateToGlobalVariables();
        }
    }

    @Override
    public void onResourceChanged(ResourceChangedEvent resourceChangedEvent) {
        if (this.bgimage.equals(resourceChangedEvent.getOldID())) {
            this.bgimage = resourceChangedEvent.getResource().id;
        }
        if (this.openimage.equals(resourceChangedEvent.getOldID())) {
            this.openimage = resourceChangedEvent.getResource().id;
        }
        if (this.closedimage.equals(resourceChangedEvent.getOldID())) {
            this.closedimage = resourceChangedEvent.getResource().id;
        }
        if (this.itemimage.equals(resourceChangedEvent.getOldID())) {
            this.itemimage = resourceChangedEvent.getResource().id;
        }
        if (this.font.equals(resourceChangedEvent.getOldID())) {
            this.font = resourceChangedEvent.getResource().id;
        }
        this.updateCache();
    }
}

