/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class Language {
    private static Hashtable<String, String> strings = new Hashtable();
    private static LinkedList<Language> langs = new LinkedList();
    private String name;
    private String code;
    private File file;

    private Language(String string, String string2, String string3) {
        this.name = string2;
        this.code = string;
        this.file = new File("lang", string3);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.name + " (" + this.code + ")";
    }

    private static void load(File file) {
        try {
            String[] stringArray;
            FileInputStream fileInputStream = new FileInputStream(file);
            String string = "";
            byte[] byArray = new byte[(int)file.length()];
            while (fileInputStream.read(byArray) != -1) {
                string = string + new String(byArray, "UTF-8");
            }
            for (String string2 : stringArray = string.split("\\n")) {
                String[] stringArray2;
                if ((string2 = string2.trim()).startsWith("@include")) {
                    stringArray2 = string2.substring(9);
                    Language.load(new File(file.getParent() + File.separator + (String)stringArray2));
                    continue;
                }
                if (string2.startsWith("#") || (stringArray2 = string2.split("\\|")).length != 2) continue;
                strings.put(stringArray2[0], stringArray2[1].replaceAll("\\\\n", "\n"));
            }
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String get(String string) {
        String string2 = strings.get(string);
        return string2 != null ? string2 : string;
    }

    public static void loadLanguage(Language language) {
        Language.load(language.getFile());
    }

    public static void loadLanguageByCode(String string) {
        for (Language language : Language.getAvailableLanguages()) {
            if (!language.getCode().equals(string)) continue;
            Language.loadLanguage(language);
        }
    }

    public static List<Language> getAvailableLanguages() {
        return langs;
    }

    public static boolean isLanguageAvailable(String string) {
        for (Language language : Language.getAvailableLanguages()) {
            if (!language.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            String[] stringArray;
            File file = new File("lang/languages.txt");
            FileInputStream fileInputStream = new FileInputStream(file);
            String string = "";
            byte[] byArray = new byte[(int)file.length()];
            while (fileInputStream.read(byArray) != -1) {
                string = string + new String(byArray, "UTF-8");
            }
            for (String string2 : stringArray = string.split("\\n")) {
                String[] stringArray2;
                if ((string2 = string2.trim()).startsWith("#") || (stringArray2 = string2.split("\\|")).length != 3) continue;
                langs.add(new Language(stringArray2[0], stringArray2[1], stringArray2[2]));
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

