/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.PanelEditEvent;
import vlcskineditor.items.Anchor;
import vlcskineditor.items.Button;
import vlcskineditor.items.Checkbox;
import vlcskineditor.items.Image;
import vlcskineditor.items.Playtree;
import vlcskineditor.items.RadialSlider;
import vlcskineditor.items.Slider;
import vlcskineditor.items.Text;
import vlcskineditor.items.Video;

public class Panel
extends Item
implements ActionListener {
    public List<Item> items = new LinkedList<Item>();
    public int width;
    public int height;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField width_tf;
    JTextField height_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;

    /*
     * WARNING - void declaration
     */
    public Panel(String string, Skin skin) {
        int n;
        this.type = "Panel";
        this.s = skin;
        String[] stringArray = string.split("\n");
        this.width = Integer.parseInt(XML.getValue(stringArray[0], "width"));
        this.width = Integer.parseInt(XML.getValue(stringArray[0], "height"));
        if (stringArray[0].indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : "Unnamed panel #" + this.s.getNewId();
        if (stringArray[0].indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(stringArray[0], "lefttop");
        }
        if (stringArray[0].indexOf("rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(stringArray[0], "rightbottom");
        }
        if (stringArray[0].indexOf("xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "xkeepratio");
        }
        if (stringArray[0].indexOf("ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(stringArray[0], "ykeepratio");
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].trim();
        }
        for (n = 1; n < stringArray.length; ++n) {
            void var5_16;
            if (stringArray[n].startsWith("<!--")) {
                while (stringArray[n].indexOf("-->") == -1) {
                    ++n;
                }
            }
            if (stringArray[n].startsWith("<Anchor")) {
                this.items.add(new Anchor(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Button")) {
                this.items.add(new Button(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Checkbox")) {
                this.items.add(new Checkbox(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Image")) {
                this.items.add(new Image(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Text")) {
                this.items.add(new Text(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Video")) {
                this.items.add(new Video(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<RadialSlider")) {
                this.items.add(new RadialSlider(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Playlist")) {
                void var5_8;
                String string2 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Playlist>")) {
                    String string3 = (String)var5_8 + "\n" + stringArray[n];
                    ++n;
                }
                String string4 = (String)var5_8 + "\n" + stringArray[n];
                this.items.add(new Playtree(string4, this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Playtree")) {
                void var5_12;
                String string5 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Playtree>")) {
                    String string6 = (String)var5_12 + "\n" + stringArray[n];
                    ++n;
                }
                String string7 = (String)var5_12 + "\n" + stringArray[n];
                this.items.add(new Playtree(string7, this.s));
                continue;
            }
            if (!stringArray[n].startsWith("<Slider")) continue;
            if (stringArray[n].indexOf("/>") != -1) {
                this.items.add(new Slider(stringArray[n], this.s));
                continue;
            }
            String string8 = stringArray[n];
            ++n;
            while (!stringArray[n].startsWith("</Slider>")) {
                String string9 = (String)var5_16 + "\n" + stringArray[n];
                ++n;
            }
            String string10 = (String)var5_16 + "\n" + stringArray[n];
            this.items.add(new Slider(string10, this.s));
        }
        for (Item item : this.items) {
            item.setOffset(this.x, this.y);
        }
        this.created = true;
    }

    public Panel(Skin skin) {
        this.type = "Panel";
        this.s = skin;
        this.width = 0;
        this.height = 0;
        this.id = "Unnamed panel #" + this.s.getNewId();
        this.showOptions();
        this.s.updateItems();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.s.updateItems();
            this.s.expandItem(this.id);
            for (Item item : this.items) {
                item.setOffset(this.x, this.y);
            }
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            PanelEditEvent panelEditEvent = new PanelEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.s.updateItems();
            this.s.expandItem(this.id);
            for (Item item : this.items) {
                item.setOffset(this.x, this.y);
            }
            panelEditEvent.setNew();
            this.s.m.hist.addEvent(panelEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Panel settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel("Lefttop:");
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this item is attached, in case of resizing.");
            JLabel jLabel5 = new JLabel("Rightbottom:");
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText("Indicate to which corner of the Layout the bottom-right-hand corner of this item is attached, in case of resizing.");
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel("Keep X Ratio:");
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText("When set to true, the behaviour of the horizontal resizing is changed. For example, if initially the space to the left of the control is twice as big as the one to its right, this will stay the same during any horizontal resizing. The width of the control stays constant.");
            JLabel jLabel7 = new JLabel("Keep Y Ratio:");
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText("When set to true, the behaviour of the vertical resizing is changed. For example, if initially the space to the top of the control is twice as big as the one to its bottom, this will stay the same during any vertical resizing. The height of the control stays constant.");
            JLabel jLabel8 = new JLabel("Visibility:");
            this.visible_tf = new JTextField();
            JLabel jLabel9 = new JLabel("Help Text:");
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText("Help text for the current control. The variable '$H' will be expanded to this value when the mouse hovers the current control.");
            JLabel jLabel10 = new JLabel("Width*:");
            this.width_tf = new JTextField();
            JLabel jLabel11 = new JLabel("Height*:");
            this.height_tf = new JTextField();
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(5, 75, 75, 24);
            this.y_tf.setBounds(85, 75, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jLabel4.setBounds(5, 105, 75, 24);
            this.lefttop_cb.setBounds(85, 105, 150, 24);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jLabel5.setBounds(5, 135, 75, 24);
            this.rightbottom_cb.setBounds(85, 135, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jLabel6.setBounds(5, 165, 75, 24);
            this.xkeepratio_cb.setBounds(85, 165, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jLabel7.setBounds(5, 195, 75, 24);
            this.ykeepratio_cb.setBounds(85, 195, 150, 24);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jLabel8.setBounds(5, 225, 75, 24);
            this.visible_tf.setBounds(85, 225, 150, 24);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jLabel9.setBounds(5, 255, 75, 24);
            this.help_tf.setBounds(85, 255, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 285));
            jPanel.setPreferredSize(new Dimension(240, 285));
            jPanel.setMaximumSize(new Dimension(240, 285));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.width_tf);
            jLabel10.setBounds(5, 15, 75, 24);
            this.width_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel11);
            jPanel2.add(this.height_tf);
            jLabel11.setBounds(5, 45, 75, 24);
            this.height_tf.setBounds(85, 45, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Dimensions"));
            jPanel2.setMinimumSize(new Dimension(240, 75));
            jPanel2.setPreferredSize(new Dimension(240, 75));
            jPanel2.setMaximumSize(new Dimension(240, 75));
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 440));
            this.frame.setPreferredSize(new Dimension(250, 440));
            this.frame.setMaximumSize(new Dimension(250, 440));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.width_tf.setText(String.valueOf(this.width));
        this.height_tf.setText(String.valueOf(this.height));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-panel.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-panel.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Panel";
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        string2 = string2 + " width=\"" + String.valueOf(this.width) + "\" height=\"" + String.valueOf(this.height) + "\"";
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        string2 = string2 + ">";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + "<!--  id=\"" + this.id + "\" -->";
        }
        for (int i = 0; i < this.items.size(); ++i) {
            string2 = string2 + "\n" + this.items.get(i).returnCode(string + Skin.indentation);
        }
        string2 = string2 + "\n" + string + "</Panel>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        for (Item item : this.items) {
            item.draw(graphics2D, this.x + this.x, this.y + n2, n3);
            item.setOffset(this.x + this.offsetx, this.y + this.offsety);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect(this.x + n, this.y + n2, this.width - 1, this.height - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return n >= this.x + this.offsetx && n <= this.x + this.width + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + this.height + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Panel: " + this.id);
        for (int i = 0; i < this.items.size(); ++i) {
            defaultMutableTreeNode.add(this.items.get(i).getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    @Override
    public Item getItem(String string) {
        if (this.id.equals(string)) {
            return this;
        }
        for (Item item : this.items) {
            if (item.getItem(string) == null) continue;
            return item.getItem(string);
        }
        return null;
    }

    @Override
    public List<Item> getParentListOf(String string) {
        for (Item item : this.items) {
            List<Item> list;
            if (item.id.equals(string)) {
                return this.items;
            }
            if (!item.type.equals("Group") && !item.type.equals("Panel") || (list = item.getParentListOf(string)) == null) continue;
            return list;
        }
        return null;
    }

    @Override
    public Item getParentOf(String string) {
        for (Item item : this.items) {
            if (item.id.equals(string)) {
                return this;
            }
            Item item2 = item.getParentOf(string);
            if (item2 == null) continue;
            return item2;
        }
        return null;
    }

    @Override
    public boolean uses(String string) {
        for (Item item : this.items) {
            if (!item.uses(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renameForCopy(String string) {
        String string2 = string;
        super.renameForCopy(string);
        for (Item item : this.items) {
            item.renameForCopy(string2);
        }
    }
}

