/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Bezier;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.AnchorEditEvent;
import vlcskineditor.history.ItemAddEvent;

public class Anchor
extends Item
implements ActionListener {
    public final String POINTS_DEFAULT = "(0,0)";
    public final int RANGE_DEFAULT = 10;
    public int priority;
    public String points = "(0,0)";
    public int range = 10;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField points_tf;
    JTextField range_tf;
    JTextField priority_tf;
    JComboBox lefttop_cb;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    Bezier b;
    int[] xpos;
    int[] ypos;

    public Anchor(String string, Skin skin) {
        this.type = "Anchor";
        this.s = skin;
        if (string.indexOf(" points=\"") != -1) {
            this.points = XML.getValue(string, "points");
        }
        this.updateBezier();
        this.priority = XML.getIntValue(string, "priority");
        if (string.indexOf(" range=\"") != -1) {
            this.range = XML.getIntValue(string, "range");
        }
        if (string.indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        this.id = string.indexOf(" id=\"") != -1 ? XML.getValue(string, "id") : "Anchor #" + this.s.getNewId();
        if (string.indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        this.created = true;
    }

    public Anchor(Skin skin) {
        this.type = "Anchor";
        this.s = skin;
        this.priority = 0;
        this.id = "Anchor #" + this.s.getNewId();
        this.updateBezier();
        this.showOptions();
    }

    public void updateBezier() {
        String[] stringArray = this.points.split("\\),\\(");
        this.xpos = new int[stringArray.length];
        this.ypos = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(",");
            this.xpos[i] = Integer.parseInt(stringArray2[0].replaceAll("\\(", ""));
            this.ypos[i] = Integer.parseInt(stringArray2[1].replaceAll("\\)", ""));
        }
        this.b = new Bezier(this.xpos, this.ypos, 0);
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.priority = Integer.parseInt(this.priority_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.points = this.points_tf.getText();
            this.range = Integer.parseInt(this.range_tf.getText());
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(1);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            AnchorEditEvent anchorEditEvent = new AnchorEditEvent(this);
            this.id = this.id_tf.getText();
            this.priority = Integer.parseInt(this.priority_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.points = this.points_tf.getText();
            this.range = Integer.parseInt(this.range_tf.getText());
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            anchorEditEvent.setNew();
            this.s.m.hist.addEvent(anchorEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Anchor settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel4 = new JLabel("Points:");
            this.points_tf = new JTextField();
            this.points_tf.setToolTipText("Points defining the Bezier curve followed by the anchor. You don't need to change this parameter if all you want is a punctual anchor.");
            JLabel jLabel5 = new JLabel("Range:");
            this.range_tf = new JTextField();
            this.range_tf.setToolTipText("Range of action of the anchor, in pixels.");
            this.range_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel6 = new JLabel("Priority*:");
            this.priority_tf = new JTextField();
            this.priority_tf.setToolTipText("Each anchor has a priority (priority attribute), and the anchor with the highest priority is the winner, which means that when moving its window all the other anchored windows will move too. To break the effect of 2 anchored windows, you need to move the window whose anchor has the lower priority.");
            this.priority_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel7 = new JLabel("Lefttop:");
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this anchor is attached, in case of resizing.");
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.priority_tf);
            jLabel6.setBounds(5, 45, 75, 24);
            this.priority_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.lefttop_cb);
            jLabel7.setBounds(5, 75, 75, 24);
            this.lefttop_cb.setBounds(85, 75, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 110));
            jPanel.setPreferredSize(new Dimension(240, 110));
            jPanel.setMaximumSize(new Dimension(240, 110));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel2);
            jPanel2.add(this.x_tf);
            jLabel2.setBounds(5, 15, 75, 24);
            this.x_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel3);
            jPanel2.add(this.y_tf);
            jLabel3.setBounds(5, 45, 75, 24);
            this.y_tf.setBounds(85, 45, 150, 24);
            jPanel2.add(jLabel4);
            jPanel2.add(this.points_tf);
            jLabel4.setBounds(5, 75, 75, 24);
            this.points_tf.setBounds(85, 75, 150, 24);
            jPanel2.add(jLabel5);
            jPanel2.add(this.range_tf);
            jLabel5.setBounds(5, 105, 75, 24);
            this.range_tf.setBounds(85, 105, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Boundaries"));
            jPanel2.setMinimumSize(new Dimension(240, 140));
            jPanel2.setPreferredSize(new Dimension(240, 140));
            jPanel2.setMaximumSize(new Dimension(240, 140));
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 345));
            this.frame.setPreferredSize(new Dimension(250, 345));
            this.frame.setMaximumSize(new Dimension(250, 345));
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.priority_tf.setText(String.valueOf(this.priority));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.points_tf.setText(this.points);
        this.range_tf.setText(String.valueOf(this.range));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-anchor.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skins2-create.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Anchor";
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        string2 = string2 + " priority=\"" + String.valueOf(this.priority) + "\"";
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            for (float f = 0.0f; f <= 1.0f; f += 0.1f) {
                Point2D.Float float_ = this.b.getPoint(f);
                Point2D.Float float_2 = this.b.getPoint(f + 0.1f);
                graphics2D.drawLine((int)(float_.getX() + (double)this.x + (double)n) * n3, (int)(float_.getY() + (double)this.y + (double)n2) * n3, (int)(float_2.getX() + (double)this.x + (double)n) * n3, (int)(float_2.getY() + (double)this.y + (double)n2) * n3);
            }
            graphics2D.setColor(Color.YELLOW);
            for (int i = 0; i < this.xpos.length; ++i) {
                graphics2D.fillOval((this.xpos[i] + this.x + n - 1) * n3, (this.ypos[i] + this.y + n2 - 1) * n3, 3, 3);
            }
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return true;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Anchor: " + this.id);
        return defaultMutableTreeNode;
    }
}

