/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.TarEntry;
import com.ice.tar.TarOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class TarGzOutputStream
extends TarOutputStream {
    private TarOutputStream tos = null;
    private GZIPOutputStream gzip = null;
    private ByteArrayOutputStream bos = null;
    private TarEntry currentEntry = null;

    public TarGzOutputStream(OutputStream outputStream) throws IOException {
        super(null);
        this.gzip = new GZIPOutputStream(outputStream);
        this.tos = new TarOutputStream(this.gzip);
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public void setDebug(boolean bl) {
        this.tos.setDebug(bl);
    }

    @Override
    public void setBufferDebug(boolean bl) {
        this.tos.setBufferDebug(bl);
    }

    @Override
    public void finish() throws IOException {
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        this.tos.finish();
    }

    @Override
    public void close() throws IOException {
        this.tos.close();
        this.gzip.finish();
    }

    @Override
    public int getRecordSize() {
        return this.tos.getRecordSize();
    }

    @Override
    public void putNextEntry(TarEntry tarEntry) throws IOException {
        if (tarEntry.getSize() != 0L) {
            this.tos.putNextEntry(tarEntry);
        } else {
            this.currentEntry = tarEntry;
        }
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.currentEntry == null) {
            this.tos.closeEntry();
        } else {
            this.currentEntry.setSize(this.bos.size());
            this.tos.putNextEntry(this.currentEntry);
            this.bos.writeTo(this.tos);
            this.tos.closeEntry();
            this.currentEntry = null;
            this.bos = new ByteArrayOutputStream();
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.currentEntry == null) {
            this.tos.write(n);
        } else {
            this.bos.write(n);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.currentEntry == null) {
            this.tos.write(byArray);
        } else {
            this.bos.write(byArray);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.currentEntry == null) {
            this.tos.write(byArray, n, n2);
        } else {
            this.bos.write(byArray, n, n2);
        }
    }
}

