/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.InvalidHeaderException;
import com.ice.tar.TarHeader;
import java.io.File;
import java.util.Date;

public class TarEntry
implements Cloneable {
    protected File file;
    protected TarHeader header;
    protected boolean unixFormat;
    protected boolean ustarFormat;
    protected boolean gnuFormat;

    protected TarEntry() {
    }

    public TarEntry(String string) {
        this.initialize();
        this.nameTarHeader(this.header, string);
    }

    public TarEntry(File file) throws InvalidHeaderException {
        this.initialize();
        this.getFileTarHeader(this.header, file);
    }

    public TarEntry(byte[] byArray) throws InvalidHeaderException {
        this.initialize();
        this.parseTarHeader(this.header, byArray);
    }

    private void initialize() {
        this.file = null;
        this.header = new TarHeader();
        this.gnuFormat = false;
        this.ustarFormat = true;
        this.unixFormat = false;
    }

    public Object clone() {
        TarEntry tarEntry = null;
        try {
            tarEntry = (TarEntry)super.clone();
            if (this.header != null) {
                tarEntry.header = (TarHeader)this.header.clone();
            }
            if (this.file != null) {
                tarEntry.file = new File(this.file.getAbsolutePath());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return tarEntry;
    }

    public boolean isUSTarFormat() {
        return this.ustarFormat;
    }

    public void setUSTarFormat() {
        this.ustarFormat = true;
        this.gnuFormat = false;
        this.unixFormat = false;
    }

    public boolean isGNUTarFormat() {
        return this.gnuFormat;
    }

    public void setGNUTarFormat() {
        this.gnuFormat = true;
        this.ustarFormat = false;
        this.unixFormat = false;
    }

    public boolean isUnixTarFormat() {
        return this.unixFormat;
    }

    public void setUnixTarFormat() {
        this.unixFormat = true;
        this.ustarFormat = false;
        this.gnuFormat = false;
    }

    public boolean equals(TarEntry tarEntry) {
        return this.header.name.toString().equals(tarEntry.header.name.toString());
    }

    public boolean isDescendent(TarEntry tarEntry) {
        return tarEntry.header.name.toString().startsWith(this.header.name.toString());
    }

    public TarHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.header.name.toString();
    }

    public void setName(String string) {
        this.header.name = new StringBuffer(string);
    }

    public int getUserId() {
        return this.header.userId;
    }

    public void setUserId(int n) {
        this.header.userId = n;
    }

    public int getGroupId() {
        return this.header.groupId;
    }

    public void setGroupId(int n) {
        this.header.groupId = n;
    }

    public String getUserName() {
        return this.header.userName.toString();
    }

    public void setUserName(String string) {
        this.header.userName = new StringBuffer(string);
    }

    public String getGroupName() {
        return this.header.groupName.toString();
    }

    public void setGroupName(String string) {
        this.header.groupName = new StringBuffer(string);
    }

    public void setIds(int n, int n2) {
        this.setUserId(n);
        this.setGroupId(n2);
    }

    public void setNames(String string, String string2) {
        this.setUserName(string);
        this.setGroupName(string2);
    }

    public void setModTime(long l) {
        this.header.modTime = l / 1000L;
    }

    public void setModTime(Date date) {
        this.header.modTime = date.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.header.modTime * 1000L);
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.header.size;
    }

    public void setSize(long l) {
        this.header.size = l;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            if (this.header.name.toString().endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    public void getFileTarHeader(TarHeader tarHeader, File file) throws InvalidHeaderException {
        this.file = file;
        String string = file.getPath();
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            String string3 = "windows";
            if (string2.toLowerCase().startsWith(string3) && string.length() > 2) {
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                if (c2 == ':' && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    string = string.substring(2);
                }
            }
        }
        string = string.replace(File.separatorChar, '/');
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        tarHeader.linkName = new StringBuffer("");
        tarHeader.name = new StringBuffer(string);
        if (file.isDirectory()) {
            tarHeader.size = 0L;
            tarHeader.mode = 16877;
            tarHeader.linkFlag = (byte)53;
            if (tarHeader.name.charAt(tarHeader.name.length() - 1) != '/') {
                tarHeader.name.append("/");
            }
        } else {
            tarHeader.size = file.length();
            tarHeader.mode = 33188;
            tarHeader.linkFlag = (byte)48;
        }
        tarHeader.modTime = file.lastModified() / 1000L;
        tarHeader.checkSum = 0;
        tarHeader.devMajor = 0;
        tarHeader.devMinor = 0;
    }

    public TarEntry[] getDirectoryEntries() throws InvalidHeaderException {
        if (this.file == null || !this.file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] stringArray = this.file.list();
        TarEntry[] tarEntryArray = new TarEntry[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            tarEntryArray[i] = new TarEntry(new File(this.file, stringArray[i]));
        }
        return tarEntryArray;
    }

    public long computeCheckSum(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l += (long)(0xFF & byArray[i]);
        }
        return l;
    }

    public void writeEntryHeader(byte[] byArray) throws InvalidHeaderException {
        int n;
        int n2 = 0;
        if (this.isUnixTarFormat() && this.header.name.length() > 100) {
            throw new InvalidHeaderException("file path is greater than 100 characters, " + this.header.name);
        }
        n2 = TarHeader.getFileNameBytes(this.header.name.toString(), byArray);
        n2 = TarHeader.getOctalBytes(this.header.mode, byArray, n2, 8);
        n2 = TarHeader.getOctalBytes(this.header.userId, byArray, n2, 8);
        n2 = TarHeader.getOctalBytes(this.header.groupId, byArray, n2, 8);
        long l = this.header.size;
        n2 = TarHeader.getLongOctalBytes(l, byArray, n2, 12);
        int n3 = n2 = TarHeader.getLongOctalBytes(this.header.modTime, byArray, n2, 12);
        for (n = 0; n < 8; ++n) {
            byArray[n2++] = 32;
        }
        byArray[n2++] = this.header.linkFlag;
        n2 = TarHeader.getNameBytes(this.header.linkName, byArray, n2, 100);
        if (this.unixFormat) {
            for (n = 0; n < 8; ++n) {
                byArray[n2++] = 0;
            }
        } else {
            n2 = TarHeader.getNameBytes(this.header.magic, byArray, n2, 8);
        }
        n2 = TarHeader.getNameBytes(this.header.userName, byArray, n2, 32);
        n2 = TarHeader.getNameBytes(this.header.groupName, byArray, n2, 32);
        n2 = TarHeader.getOctalBytes(this.header.devMajor, byArray, n2, 8);
        n2 = TarHeader.getOctalBytes(this.header.devMinor, byArray, n2, 8);
        while (n2 < byArray.length) {
            byArray[n2++] = 0;
        }
        long l2 = this.computeCheckSum(byArray);
        TarHeader.getCheckSumOctalBytes(l2, byArray, n3, 8);
    }

    public void parseTarHeader(TarHeader tarHeader, byte[] byArray) throws InvalidHeaderException {
        int n = 0;
        if (byArray[257] == 0 && byArray[258] == 0 && byArray[259] == 0 && byArray[260] == 0 && byArray[261] == 0) {
            this.unixFormat = true;
            this.ustarFormat = false;
            this.gnuFormat = false;
        } else if (byArray[257] == 117 && byArray[258] == 115 && byArray[259] == 116 && byArray[260] == 97 && byArray[261] == 114 && byArray[262] == 0) {
            this.ustarFormat = true;
            this.gnuFormat = false;
            this.unixFormat = false;
        } else if (byArray[257] == 117 && byArray[258] == 115 && byArray[259] == 116 && byArray[260] == 97 && byArray[261] == 114 && byArray[262] != 0 && byArray[263] != 0) {
            this.gnuFormat = true;
            this.unixFormat = false;
            this.ustarFormat = false;
        } else {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("header magic is not 'ustar' or unix-style zeros, it is '");
            stringBuffer.append(byArray[257]);
            stringBuffer.append(byArray[258]);
            stringBuffer.append(byArray[259]);
            stringBuffer.append(byArray[260]);
            stringBuffer.append(byArray[261]);
            stringBuffer.append(byArray[262]);
            stringBuffer.append(byArray[263]);
            stringBuffer.append("', or (dec) ");
            stringBuffer.append(byArray[257]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[258]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[259]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[260]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[261]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[262]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[263]);
            throw new InvalidHeaderException(stringBuffer.toString());
        }
        tarHeader.name = TarHeader.parseFileName(byArray);
        n = 100;
        tarHeader.mode = (int)TarHeader.parseOctal(byArray, n, 8);
        tarHeader.userId = (int)TarHeader.parseOctal(byArray, n += 8, 8);
        tarHeader.groupId = (int)TarHeader.parseOctal(byArray, n += 8, 8);
        tarHeader.size = TarHeader.parseOctal(byArray, n += 8, 12);
        tarHeader.modTime = TarHeader.parseOctal(byArray, n += 12, 12);
        tarHeader.checkSum = (int)TarHeader.parseOctal(byArray, n += 12, 8);
        n += 8;
        tarHeader.linkFlag = byArray[n++];
        tarHeader.linkName = TarHeader.parseName(byArray, n, 100);
        n += 100;
        if (this.ustarFormat) {
            tarHeader.magic = TarHeader.parseName(byArray, n, 8);
            tarHeader.userName = TarHeader.parseName(byArray, n += 8, 32);
            tarHeader.groupName = TarHeader.parseName(byArray, n += 32, 32);
            tarHeader.devMajor = (int)TarHeader.parseOctal(byArray, n += 32, 8);
            tarHeader.devMinor = (int)TarHeader.parseOctal(byArray, n += 8, 8);
        } else {
            tarHeader.devMajor = 0;
            tarHeader.devMinor = 0;
            tarHeader.magic = new StringBuffer("");
            tarHeader.userName = new StringBuffer("");
            tarHeader.groupName = new StringBuffer("");
        }
    }

    public void nameTarHeader(TarHeader tarHeader, String string) {
        boolean bl = string.endsWith("/");
        this.gnuFormat = false;
        this.ustarFormat = true;
        this.unixFormat = false;
        tarHeader.checkSum = 0;
        tarHeader.devMajor = 0;
        tarHeader.devMinor = 0;
        tarHeader.name = new StringBuffer(string);
        tarHeader.mode = bl ? 16877 : 33188;
        tarHeader.userId = 0;
        tarHeader.groupId = 0;
        tarHeader.size = 0L;
        tarHeader.checkSum = 0;
        tarHeader.modTime = new Date().getTime() / 1000L;
        tarHeader.linkFlag = (byte)(bl ? 53 : 48);
        tarHeader.linkName = new StringBuffer("");
        tarHeader.userName = new StringBuffer("");
        tarHeader.groupName = new StringBuffer("");
        tarHeader.devMajor = 0;
        tarHeader.devMinor = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        return stringBuffer.append("[TarEntry name=").append(this.getName()).append(", isDir=").append(this.isDirectory()).append(", size=").append(this.getSize()).append(", userId=").append(this.getUserId()).append(", user=").append(this.getUserName()).append(", groupId=").append(this.getGroupId()).append(", group=").append(this.getGroupName()).append("]").toString();
    }
}

