/*****************************************************************************
 * broacast.h : SAP Broadcast Class definition
 ****************************************************************************
 * Copyright (C) 1998-2003 VideoLAN
 * $Id: broadcast.h,v 1.3 2003/06/16 10:26:47 zorglub Exp $
 *
 * Authors: Damien Lucas <nitrox@videolan.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#define HELLO_PORT 9875
#define SAP_IPV4_ADDR "224.2.127.254"
#define SAP_IPV6_ADDR_1 "FF0"    /* You must put the scope after */
#define SAP_IPV6_ADDR_2 ":0:0:0:0:0:2:7FFE"


class Broadcast {
  public:
    Broadcast(unsigned int t);
    ~Broadcast();
    int Initv4(void);
    int Initv6(char scope);
    int Send(Message*,int);

  private:
    int fd;                   /* File descriptor on the socket */
    struct sockaddr_in addr;    /* IP Address to broadcast to */
    struct sockaddr_in6 addr_v6; /* IPv6 Address to broadcast to */
    char* group;
    uint16_t port;
    unsigned int ttl;
};
