<?php

/**
 * This file is part of CodeIgniter 4 framework.
 *
 * (c) CodeIgniter Foundation <admin@codeigniter.com>
 *
 * For the full copyright and license information, please view
 * the LICENSE file that was distributed with this source code.
 */

namespace Tests\Support\View;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

/**
 * Class SampleClassWithInitController
 *
 * This class is only used to provide a reference point
 * during tests to make sure that things work as expected.
 */
class SampleClassWithInitController
{
    private ResponseInterface $response;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger): void
    {
        $this->response = $response;
    }

    public function index()
    {
        return get_class($this->response);
    }
}
