# Running System Tests

This is the quick-start to CodeIgniter testing. Its intent is to describe what
it takes to set up your system and get it ready to run unit tests.
It is not intended to be a full description of the test features that you can
use to test your application. Those details can be found in the documentation.

## Resources

* [CodeIgniter 4 User Guide on Testing](https://codeigniter4.github.io/userguide/testing/index.html)
* [PHPUnit docs](https://phpunit.de/documentation.html)
* [Any tutorials on Unit testing in CI4?](https://forum.codeigniter.com/showthread.php?tid=81830)

## Requirements

It is recommended to use the latest version of PHPUnit. At the time of this
writing we are running version 9.x. Support for this has been built into the
**composer.json** file that ships with CodeIgniter and can easily be installed
via [Composer](https://getcomposer.org/) if you don't already have it installed globally.

```console
composer install
```

If running under macOS or Linux, you can create a symbolic link to make running tests a touch nicer.

```console
ln -s ./vendor/bin/phpunit ./phpunit
```

You also need to install [Xdebug](https://xdebug.org/docs/install) in order
for code coverage to be calculated successfully. After installing `Xdebug`, you must
add `xdebug.mode=coverage` in the **php.ini** file to enable code coverage.

## Setting Up

A number of the tests use a running database.
The default configuration uses SQLite3 transient in-memory database, so it works if you can use SQLite3.

In order to change the database for testing, edit the details for the `tests` group in
**app/Config/Database.php** or **phpunit.xml** or use **.env** file.

E.g.:
```
database.tests.hostname = localhost
database.tests.database = ci4_test
database.tests.username = root
database.tests.password = root
database.tests.DBDriver = MySQLi
database.tests.DBPrefix = db_
database.default.port   = 3306
```

Make sure that you provide a database engine that is currently running on your machine.

More details on a test database setup are in the
[Testing Your Database](https://codeigniter4.github.io/CodeIgniter4/testing/database.html) section of the documentation.

If you want to run the tests without using live database you can
exclude `@DatabaseLive` group. This will make the tests run quite a bit faster.

## Groups

Each test class that we are running should belong to at least one
[@group](https://phpunit.readthedocs.io/en/9.5/annotations.html#group) that is written at class-level
doc block.

The available groups to use are:

| Group           | Purpose                                                               |
| --------------- | --------------------------------------------------------------------- |
| AutoReview      | Used for tests that perform automatic code reviews                    |
| CacheLive       | Used for cache tests that need external services (redis, memcached)   |
| DatabaseLive    | Used for database tests that need to run on actual database drivers   |
| SeparateProcess | Used for tests that need to run on separate PHP processes             |
| Others          | Used as a "catch-all" group for tests not falling in the above groups |

## Running the tests

The entire test suite can be run by simply typing one command-line command from the main directory.

```console
./phpunit
```

If you are using Windows, use the following command.

```console
vendor\bin\phpunit
```

You can limit tests to those within a single test directory by specifying the
directory name after phpunit. All core tests are stored under **tests/system**.

```console
./phpunit tests/system/HTTP/
```

Individual tests can be run by including the relative path to the test file.

```console
./phpunit tests/system/HTTP/RequestTest.php
```

You can run the tests without running the live database and the live cache tests.

```console
./phpunit --exclude-group DatabaseLive,CacheLive
```

## Generating Code Coverage

To generate coverage information, including HTML reports you can view in your browser,
you can use the following command:

```console
./phpunit --colors --coverage-text=tests/coverage.txt --coverage-html=tests/coverage/ -d memory_limit=1024m
```

This runs all of the tests again collecting information about how many lines,
functions, and files are tested. It also reports the percentage of the code that is covered by tests.
It is collected in two formats: a simple text file that provides an overview as well
as a comprehensive collection of HTML files that show the status of every line of code in the project.

The text file can be found at **tests/coverage.txt**.
The HTML files can be viewed by opening **tests/coverage/index.html** in your favorite browser.

## PHPUnit XML Configuration

The repository has a ``phpunit.xml.dist`` file in the project root that's used for
PHPUnit configuration. This is used to provide a default configuration if you
do not have your own configuration file in the project root.

The normal practice would be to copy ``phpunit.xml.dist`` to ``phpunit.xml``
(which is git ignored), and to tailor it as you see fit.
For instance, you might wish to exclude database tests, or automatically generate
HTML code coverage reports.
