<?php
/** Adminer Editor - Compact database editor
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2009 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.1
*/function
adminer_errors($bc,$cc){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$cc);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$tc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($tc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Hg=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Hg)$$X=$Hg;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$h;return$h;}function
adminer(){global$b;return$b;}function
version(){global$ca;return$ca;}function
idf_unescape($u){if(!preg_match('~^[`\'"]~',$u))return$u;$_d=substr($u,-1);return
str_replace($_d.$_d,$_d,substr($u,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($Te,$tc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($Te)){foreach($X
as$sd=>$W){unset($Te[$y][$sd]);if(is_array($W)){$Te[$y][stripslashes($sd)]=$W;$Te[]=&$Te[$y][stripslashes($sd)];}else$Te[$y][stripslashes($sd)]=($tc?$W:stripslashes($W));}}}}function
bracket_escape($u,$Ga=false){static$ug=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($u,($Ga?array_flip($ug):$ug));}function
min_version($Tg,$Ld="",$i=null){global$h;if(!$i)$i=$h;$Bf=$i->server_info;if($Ld&&preg_match('~([\d.]+)-MariaDB~',$Bf,$A)){$Bf=$A[1];$Tg=$Ld;}return(version_compare($Bf,$Tg)>=0);}function
charset($h){return(min_version("5.5.3",0,$h)?"utf8mb4":"utf8");}function
script($Kf,$tg="\n"){return"<script".nonce().">$Kf</script>$tg";}function
script_src($Mg){return"<script src='".h($Mg)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($P){return
str_replace("\0","&#0;",htmlspecialchars($P,ENT_QUOTES,'utf-8'));}function
nl_br($P){return
str_replace("\n","<br>",$P);}function
checkbox($B,$Y,$Ua,$wd="",$me="",$Xa="",$xd=""){$H="<input type='checkbox' name='$B' value='".h($Y)."'".($Ua?" checked":"").($xd?" aria-labelledby='$xd'":"").">".($me?script("qsl('input').onclick = function () { $me };",""):"");return($wd!=""||$Xa?"<label".($Xa?" class='$Xa'":"").">$H".h($wd)."</label>":$H);}function
optionlist($C,$wf=null,$Pg=false){$H="";foreach($C
as$sd=>$W){$re=array($sd=>$W);if(is_array($W)){$H.='<optgroup label="'.h($sd).'">';$re=$W;}foreach($re
as$y=>$X)$H.='<option'.($Pg||is_string($y)?' value="'.h($y).'"':'').(($Pg||is_string($y)?(string)$y:$X)===$wf?' selected':'').'>'.h($X);if(is_array($W))$H.='</optgroup>';}return$H;}function
html_select($B,$C,$Y="",$le=true,$xd=""){if($le)return"<select name='".h($B)."'".($xd?" aria-labelledby='$xd'":"").">".optionlist($C,$Y)."</select>".(is_string($le)?script("qsl('select').onchange = function () { $le };",""):"");$H="";foreach($C
as$y=>$X)$H.="<label><input type='radio' name='".h($B)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>";return$H;}function
select_input($Ba,$C,$Y="",$le="",$Ke=""){$cg=($C?"select":"input");return"<$cg$Ba".($C?"><option value=''>$Ke".optionlist($C,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Ke'>").($le?script("qsl('$cg').onchange = $le;",""):"");}function
confirm($Td="",$xf="qsl('input')"){return
script("$xf.onclick = function () { return confirm('".($Td?js_escape($Td):lang(0))."'); };","");}function
print_fieldset($t,$Bd,$Wg=false){echo"<fieldset><legend>","<a href='#fieldset-$t'>$Bd</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$t');",""),"</legend>","<div id='fieldset-$t'".($Wg?"":" class='hidden'").">\n";}function
bold($Na,$Xa=""){return($Na?" class='active $Xa'":($Xa?" class='$Xa'":""));}function
odd($H=' class="odd"'){static$s=0;if(!$H)$s=-1;return($s++%2?$H:'');}function
js_escape($P){return
addcslashes($P,"\r\n'\\/");}function
json_row($y,$X=null){static$uc=true;if($uc)echo"{";if($y!=""){echo($uc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$uc=false;}else{echo"\n}\n";$uc=true;}}function
ini_bool($jd){$X=ini_get($jd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$H;if($H===null)$H=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$H;}function
set_password($Sg,$M,$V,$E){$_SESSION["pwds"][$Sg][$M][$V]=($_COOKIE["adminer_key"]&&is_string($E)?array(encrypt_string($E,$_COOKIE["adminer_key"])):$E);}function
get_password(){$H=get_session("pwds");if(is_array($H))$H=($_COOKIE["adminer_key"]?decrypt_string($H[0],$_COOKIE["adminer_key"]):false);return$H;}function
q($P){global$h;return$h->quote($P);}function
get_vals($F,$e=0){global$h;$H=array();$G=$h->query($F);if(is_object($G)){while($I=$G->fetch_row())$H[]=$I[$e];}return$H;}function
get_key_vals($F,$i=null,$Ef=true){global$h;if(!is_object($i))$i=$h;$H=array();$G=$i->query($F);if(is_object($G)){while($I=$G->fetch_row()){if($Ef)$H[$I[0]]=$I[1];else$H[]=$I[0];}}return$H;}function
get_rows($F,$i=null,$n="<p class='error'>"){global$h;$kb=(is_object($i)?$i:$h);$H=array();$G=$kb->query($F);if(is_object($G)){while($I=$G->fetch_assoc())$H[]=$I;}elseif(!$G&&!is_object($i)&&$n&&defined("PAGE_HEADER"))echo$n.error()."\n";return$H;}function
unique_array($I,$w){foreach($w
as$v){if(preg_match("~PRIMARY|UNIQUE~",$v["type"])){$H=array();foreach($v["columns"]as$y){if(!isset($I[$y]))continue
2;$H[$y]=$I[$y];}return$H;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($y);}function
where($Z,$p=array()){global$h,$x;$H=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,1);$e=escape_key($y);$H[]=$e.($x=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($x=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($p[$y],q($X))));if($x=="sql"&&preg_match('~char|text~',$p[$y]["type"])&&preg_match("~[^ -@]~",$X))$H[]="$e = ".q($X)." COLLATE ".charset($h)."_bin";}foreach((array)$Z["null"]as$y)$H[]=escape_key($y)." IS NULL";return
implode(" AND ",$H);}function
where_check($X,$p=array()){parse_str($X,$Sa);remove_slashes(array(&$Sa));return
where($Sa,$p);}function
where_link($s,$e,$Y,$oe="="){return"&where%5B$s%5D%5Bcol%5D=".urlencode($e)."&where%5B$s%5D%5Bop%5D=".urlencode(($Y!==null?$oe:"IS NULL"))."&where%5B$s%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($f,$p,$K=array()){$H="";foreach($f
as$y=>$X){if($K&&!in_array(idf_escape($y),$K))continue;$za=convert_field($p[$y]);if($za)$H.=", $za AS ".idf_escape($y);}return$H;}function
cookie($B,$Y,$Ed=2592000){global$aa;return
header("Set-Cookie: $B=".urlencode($Y).($Ed?"; expires=".gmdate("D, d M Y H:i:s",time()+$Ed)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($aa?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($zc=false){$Og=ini_bool("session.use_cookies");if(!$Og||$zc){session_write_close();if($Og&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Sg,$M,$V,$l=null){global$Mb;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($Mb))."|username|".($l!==null?"db|":"").session_name()),$A);return"$A[1]?".(sid()?SID."&":"").($Sg!="server"||$M!=""?urlencode($Sg)."=".urlencode($M)."&":"")."username=".urlencode($V).($l!=""?"&db=".urlencode($l):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Gd,$Td=null){if($Td!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Gd!==null?$Gd:$_SERVER["REQUEST_URI"]))][]=$Td;}if($Gd!==null){if($Gd=="")$Gd=".";header("Location: $Gd");exit;}}function
query_redirect($F,$Gd,$Td,$df=true,$gc=true,$mc=false,$jg=""){global$h,$n,$b;if($gc){$Qf=microtime(true);$mc=!$h->query($F);$jg=format_time($Qf);}$Nf="";if($F)$Nf=$b->messageQuery($F,$jg,$mc);if($mc){$n=error().$Nf.script("messagesPrint();");return
false;}if($df)redirect($Gd,$Td.$Nf);return
true;}function
queries($F){global$h;static$Xe=array();static$Qf;if(!$Qf)$Qf=microtime(true);if($F===null)return
array(implode("\n",$Xe),format_time($Qf));$Xe[]=(preg_match('~;$~',$F)?"DELIMITER ;;\n$F;\nDELIMITER ":$F).";";return$h->query($F);}function
apply_queries($F,$S,$dc='table'){foreach($S
as$Q){if(!queries("$F ".$dc($Q)))return
false;}return
true;}function
queries_redirect($Gd,$Td,$df){list($Xe,$jg)=queries(null);return
query_redirect($Xe,$Gd,$Td,$df,false,!$df,$jg);}function
format_time($Qf){return
lang(1,max(0,microtime(true)-$Qf));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Be=""){return
substr(preg_replace("~(?<=[?&])($Be".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($D,$zb){return" ".($D==$zb?$D+1:'<a href="'.h(remove_from_uri("page").($D?"&page=$D".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($D+1)."</a>");}function
get_file($y,$Cb=false){$rc=$_FILES[$y];if(!$rc)return
null;foreach($rc
as$y=>$X)$rc[$y]=(array)$X;$H='';foreach($rc["error"]as$y=>$n){if($n)return$n;$B=$rc["name"][$y];$qg=$rc["tmp_name"][$y];$qb=file_get_contents($Cb&&preg_match('~\.gz$~',$B)?"compress.zlib://$qg":$qg);if($Cb){$Qf=substr($qb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Qf,$ef))$qb=iconv("utf-16","utf-8",$qb);elseif($Qf=="\xEF\xBB\xBF")$qb=substr($qb,3);$H.=$qb."\n\n";}else$H.=$qb;}return$H;}function
upload_error($n){$Qd=($n==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($n?lang(2).($Qd?" ".lang(3,$Qd):""):lang(4));}function
repeat_pattern($He,$Cd){return
str_repeat("$He{0,65535}",$Cd/65535)."$He{0,".($Cd%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($P,$Cd=80,$Wf=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Cd).")($)?)u",$P,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Cd).")($)?)",$P,$A);return
h($A[1]).$Wf.(isset($A[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($Te,$ad=array(),$Oe=''){$H=false;foreach($Te
as$y=>$X){if(!in_array($y,$ad)){if(is_array($X))hidden_fields($X,array(),$y);else{$H=true;echo'<input type="hidden" name="'.h($Oe?$Oe."[$y]":$y).'" value="'.h($X).'">';}}}return$H;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$nc=false){$H=table_status($Q,$nc);return($H?$H:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$H=array();foreach($b->foreignKeys($Q)as$Cc){foreach($Cc["source"]as$X)$H[$X][]=$Cc;}return$H;}function
enum_input($T,$Ba,$o,$Y,$Xb=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$o["length"],$Nd);$H=($Xb!==null?"<label><input type='$T'$Ba value='$Xb'".((is_array($Y)?in_array($Xb,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Nd[1]as$s=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ua=(is_int($Y)?$Y==$s+1:(is_array($Y)?in_array($s+1,$Y):$Y===$X));$H.=" <label><input type='$T'$Ba value='".($s+1)."'".($Ua?' checked':'').'>'.h($b->editVal($X,$o)).'</label>';}return$H;}function
input($o,$Y,$r){global$U,$b,$x;$B=h(bracket_escape($o["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$xa=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$xa[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$xa);$r="json";}$jf=($x=="mssql"&&$o["auto_increment"]);if($jf&&!$_POST["save"])$r=null;$Ic=(isset($_GET["select"])||$jf?array("orig"=>lang(8)):array())+$b->editFunctions($o);$Ba=" name='fields[$B]'";if($o["type"]=="enum")echo
h($Ic[""])."<td>".$b->editInput($_GET["edit"],$o,$Ba,$Y);else{$Pc=(in_array($r,$Ic)||isset($Ic[$r]));echo(count($Ic)>1?"<select name='function[$B]'>".optionlist($Ic,$r===null||$Pc?$r:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Ic))).'<td>';$ld=$b->editInput($_GET["edit"],$o,$Ba,$Y);if($ld!="")echo$ld;elseif(preg_match('~bool~',$o["type"]))echo"<input type='hidden'$Ba value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ba value='1'>";elseif($o["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$o["length"],$Nd);foreach($Nd[1]as$s=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ua=(is_int($Y)?($Y>>$s)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$B][$s]' value='".(1<<$s)."'".($Ua?' checked':'').">".h($b->editVal($X,$o)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$o["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$B'>";elseif(($gg=preg_match('~text|lob|memo~i',$o["type"]))||preg_match("~\n~",$Y)){if($gg&&$x!="sqlite")$Ba.=" cols='50' rows='12'";else{$J=min(12,substr_count($Y,"\n")+1);$Ba.=" cols='30' rows='$J'".($J==1?" style='height: 1.2em;'":"");}echo"<textarea$Ba>".h($Y).'</textarea>';}elseif($r=="json"||preg_match('~^jsonb?$~',$o["type"]))echo"<textarea$Ba cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Sd=(!preg_match('~int~',$o["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$o["length"],$A)?((preg_match("~binary~",$o["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$o["unsigned"]?1:0)):($U[$o["type"]]?$U[$o["type"]]+($o["unsigned"]?0:1):0));if($x=='sql'&&min_version(5.6)&&preg_match('~time~',$o["type"]))$Sd+=7;echo"<input".((!$Pc||$r==="")&&preg_match('~(?<!o)int(?!er)~',$o["type"])&&!preg_match('~\[\]~',$o["full_type"])?" type='number'":"")." value='".h($Y)."'".($Sd?" data-maxlength='$Sd'":"").(preg_match('~char|binary~',$o["type"])&&$Sd>20?" size='40'":"")."$Ba>";}echo$b->editHint($_GET["edit"],$o,$Y);$uc=0;foreach($Ic
as$y=>$X){if($y===""||!$X)break;$uc++;}if($uc)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $uc), oninput: function () { this.onchange(); }});");}}function
process_input($o){global$b,$m;$u=bracket_escape($o["field"]);$r=$_POST["function"][$u];$Y=$_POST["fields"][$u];if($o["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($o["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$o["on_update"])?idf_escape($o["field"]):false);if($r=="NULL")return"NULL";if($o["type"]=="set")return
array_sum((array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$o["type"])&&ini_bool("file_uploads")){$rc=get_file("fields-$u");if(!is_string($rc))return
false;return$m->quoteBinary($rc);}return$b->processInput($o,$Y,$r);}function
fields_from_edit(){global$m;$H=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$B=bracket_escape($y,1);$H[$B]=array("field"=>$B,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($y==$m->primary),);}return$H;}function
search_tables(){global$b,$h;$_GET["where"][0]["val"]=$_POST["query"];$zf="<ul>\n";foreach(table_status('',true)as$Q=>$R){$B=$b->tableName($R);if(isset($R["Engine"])&&$B!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$G=$h->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$G||$G->fetch_row()){$Re="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$B</a>";echo"$zf<li>".($G?$Re:"<p class='error'>$Re: ".error())."\n";$zf="";}}}echo($zf?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Yc,$Xd=false){global$b;$H=$b->dumpHeaders($Yc,$Xd);$ye=$_POST["output"];if($ye!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Yc).".$H".($ye!="file"&&preg_match('~^[0-9a-z]+$~',$ye)?".$ye":""));session_write_close();ob_flush();flush();return$H;}function
dump_csv($I){foreach($I
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$I[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$I)."\r\n";}function
apply_sql_function($r,$e){return($r?($r=="unixepoch"?"DATETIME($e, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$e)"):$e);}function
get_temp_dir(){$H=ini_get("upload_tmp_dir");if(!$H){if(function_exists('sys_get_temp_dir'))$H=sys_get_temp_dir();else{$q=@tempnam("","");if(!$q)return
false;$H=dirname($q);unlink($q);}}return$H;}function
file_open_lock($q){$Gc=@fopen($q,"r+");if(!$Gc){$Gc=@fopen($q,"w");if(!$Gc)return;chmod($q,0660);}flock($Gc,LOCK_EX);return$Gc;}function
file_write_unlock($Gc,$_b){rewind($Gc);fwrite($Gc,$_b);ftruncate($Gc,strlen($_b));flock($Gc,LOCK_UN);fclose($Gc);}function
password_file($ub){$q=get_temp_dir()."/adminer.key";$H=@file_get_contents($q);if($H||!$ub)return$H;$Gc=@fopen($q,"w");if($Gc){chmod($q,0660);$H=rand_string();fwrite($Gc,$H);fclose($Gc);}return$H;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$_,$o,$hg){global$b;if(is_array($X)){$H="";foreach($X
as$sd=>$W)$H.="<tr>".($X!=array_values($X)?"<th>".h($sd):"")."<td>".select_value($W,$_,$o,$hg);return"<table cellspacing='0'>$H</table>";}if(!$_)$_=$b->selectLink($X,$o);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$H=$b->editVal($X,$o);if($H!==null){if(!is_utf8($H))$H="\0";elseif($hg!=""&&is_shortable($o))$H=shorten_utf8($H,max(0,+$hg));else$H=h($H);}return$b->selectVal($H,$_,$o,$X);}function
is_mail($Ub){$_a='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Lb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$He="$_a+(\\.$_a+)*@($Lb?\\.)+$Lb";return
is_string($Ub)&&preg_match("(^$He(,\\s*$He)*\$)i",$Ub);}function
is_url($P){$Lb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Lb?\\.)+$Lb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$P);}function
is_shortable($o){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$o["type"]);}function
count_rows($Q,$Z,$pd,$Jc){global$x;$F=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($pd&&($x=="sql"||count($Jc)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$Jc).")$F":"SELECT COUNT(*)".($pd?" FROM (SELECT 1$F GROUP BY ".implode(", ",$Jc).") x":$F));}function
slow_query($F){global$b,$sg,$m;$l=$b->database();$kg=$b->queryTimeout();$Hf=$m->slowQuery($F,$kg);if(!$Hf&&support("kill")&&is_object($i=connect())&&($l==""||$i->select_db($l))){$vd=$i->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$vd,'&token=',$sg,'\');
}, ',1000*$kg,');
</script>
';}else$i=null;ob_flush();flush();$H=@get_key_vals(($Hf?$Hf:$F),$i,false);if($i){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$H;}function
get_token(){$af=rand(1,1e6);return($af^$_SESSION["token"]).":$af";}function
verify_token(){list($sg,$af)=explode(":",$_POST["token"]);return($af^$_SESSION["token"])==$sg;}function
lzw_decompress($La){$Jb=256;$Ma=8;$Za=array();$lf=0;$mf=0;for($s=0;$s<strlen($La);$s++){$lf=($lf<<8)+ord($La[$s]);$mf+=8;if($mf>=$Ma){$mf-=$Ma;$Za[]=$lf>>$mf;$lf&=(1<<$mf)-1;$Jb++;if($Jb>>$Ma)$Ma++;}}$Ib=range("\0","\xFF");$H="";foreach($Za
as$s=>$Ya){$Tb=$Ib[$Ya];if(!isset($Tb))$Tb=$fh.$fh[0];$H.=$Tb;if($s)$Ib[]=$fh.$Tb[0];$fh=$Tb;}return$H;}function
on_help($fb,$Ff=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $fb, $Ff) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$p,$I,$Kg){global$b,$x,$sg,$n;$ag=$b->tableName(table_status1($Q,true));page_header(($Kg?lang(10):lang(11)),$n,array("select"=>array($Q,$ag)),$ag);$b->editRowPrint($Q,$p,$I,$Kg);if($I===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$p)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($p
as$B=>$o){echo"<tr><th>".$b->fieldName($o);$Db=$_GET["set"][bracket_escape($B)];if($Db===null){$Db=$o["default"];if($o["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Db,$ef))$Db=$ef[1];}$Y=($I!==null?($I[$B]!=""&&$x=="sql"&&preg_match("~enum|set~",$o["type"])?(is_array($I[$B])?array_sum($I[$B]):+$I[$B]):(is_bool($I[$B])?+$I[$B]:$I[$B])):(!$Kg&&$o["auto_increment"]?"":(isset($_GET["select"])?false:$Db)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$o);$r=($_POST["save"]?(string)$_POST["function"][$B]:($Kg&&preg_match('~^CURRENT_TIMESTAMP~i',$o["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Kg&&$Y==$o["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$o["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}input($o,$Y,$r);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($p){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Kg?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Kg?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($Kg?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$p?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$sg,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7t4yZf4iATVVf:Ϧ,:1Qݼb2`#>:7G1sLXD*bv<܌#e@:4!fot:<咾o\ni',a_:iBv|N4.5Nfivphl֚O= OFQk\$id2Tp6-Z6h:a,2#8А#6nJht4O42ok*r@p@!?6r[L:2Bj!HbP=!1V\"0\nSD7DڛC!!Gʌ +=tC.C:+=%c1MR/EȒ42䱠`8(ӹ[W=ySb=-ܹBS+ɯ@pL4Ydq63ĬAc܌Ψk[&>Zpkm]u-c:Ntδpҝ8=#[.ޯ~myPP|I֛Q9v[Q\nr'g+T2Vz48(	Ey*#j2]R)[NR\$<>:>\$;>\rHT\nwN wأ<Gw\\Y_Rt^>\r}S\rz4=\nL%J\",Z8i0u?s3#ى:㽖E]xs^8K^*0w~:iv2w^77cu+U%{P*4̼LX./!1Cqx!HFdLĠ`65fĆ=Hl V1\0a2;6_ه\0&ZSd)KE'n[X\0ZɊF[Pޘ@!Y,`\"ڷ0Ee9yF>9bF5:\0}Ĵ(\$37H MA6R{Mq7GCCm2(Ct>[-t/&C]etG̬4@r><Sq/QhmL#K|6fKP\r%tV=\"SH\$} )w,W\0Fu@b9\rr2#DXyOI>nǢ%'_t\rτz\\1hl]Q5Mp6kqh\$H~|!*4`SS tPP\\g7\n-:袪plB7Өc(wO0\\:wp4{TjO6HÊrq\n%%y']\$aZ.fcq*-FWkzjlg:\$\"N\r#dÂsc̠\"j\rՒPh1/DA)[knp76YR{MP@\n-a6[zJH,dlBho+#Dr^^eE ĜaPJGzt2XVȳB_%K=Eb弾§kU(.!ܮ8I.@Kxn:P32mH		C*:vT\nR0uҧ]P/JQd{L޳:Y2bT 34cV=L4r!BY6MeLio9< GƕЙMhm^UNTr5HiM/n흳T[-<__3/Xr(<uҖGNX20\r\$^:'9O;kfN'ab,V1HI!%6@\$EGڜ1(mUrս`iN+Ü)0lf0[UV-:I^\$sb\reugh~9߈bf+0 hXrݬ!\$e,w+3_Ak\nkrʛcuWdY\\={.čgp8t\rRZvJ:>Y|+@Ct\rjt6%?ǎ>/9F`וv~KRWzlmwL9Y*qxzSeݛ~Dxɟi72Oݻ_{53t_z3d)C\$?KӪP%T&&\0PNA^~p Ϝ\r\$b*+D6궦ψJ\$(olh&KBS>;zxoz>oZ\nʋ[vȜ2OxِV0f2Blbk6ZkhXcd0*KTH=πp0lV\rnm)( ");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	Ojr7F;B̒>ЦV\rĖ|'Jz#PBY5\0NC^\n~LrR[̟RìgeZ\0x^i<Q/)%@ʐfBHf{%P\"\"@)DE(iM2S*yS\"e̒1ט\n4`ʩ>Q*ynTu~%+WXKQ[ʔlPYy#D٬D<FL@6']Ƌ\rF`!%\n0c˩%c8WrpG.TDoUL2*|\$:r@&4H> %0*Zc(@]Q:*(&\"x'JO1`>7	#\"O4PX|B4[٘\$n1`GSAAH\")Sfɦ-\"W+ɖ\0s-[fo٧Dx=C.9fc\07?Ó95֦Z0fH?R'q>o@aDG[;GDBBdġq2|1qw<#EY^Q\\[X>?v[ I g\0)gug42jú'Tvy,uD=pH\\^bqitXFP@PTi2#gDᮙ%9@");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress('');}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo'';break;case"cross.gif":echo'';break;case"up.gif":echo'';break;case"down.gif":echo'';break;case"arrow.gif":echo'';break;}}exit;}if($_GET["script"]=="version"){$Gc=file_open_lock(get_temp_dir()."/adminer.version");if($Gc)file_write_unlock($Gc,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$h,$m,$Mb,$Rb,$Zb,$n,$Ic,$Mc,$aa,$kd,$x,$ba,$zd,$ke,$Je,$Tf,$Qc,$sg,$wg,$U,$Jg,$ca;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$aa=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Ce=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$aa);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Ce[]=true;call_user_func_array('session_set_cookie_params',$Ce);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$tc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$zd=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ba;return$ba;}function
lang($u,$fe=null){if(is_string($u)){$Me=array_search($u,get_translations("en"));if($Me!==false)$u=$Me;}global$ba,$wg;$vg=($wg[$u]?$wg[$u]:$u);if(is_array($vg)){$Me=($fe==1?0:($ba=='cs'||$ba=='sk'?($fe&&$fe<5?1:2):($ba=='fr'?(!$fe?0:1):($ba=='pl'?($fe%10>1&&$fe%10<5&&$fe/10%10!=1?1:2):($ba=='sl'?($fe%100==1?0:($fe%100==2?1:($fe%100==3||$fe%100==4?2:3))):($ba=='lt'?($fe%10==1&&$fe%100!=11?0:($fe%10>1&&$fe/10%10!=1?1:2)):($ba=='bs'||$ba=='ru'||$ba=='sr'||$ba=='uk'?($fe%10==1&&$fe%100!=11?0:($fe%10>1&&$fe%10<5&&$fe/10%10!=1?1:2)):1)))))));$vg=$vg[$Me];}$xa=func_get_args();array_shift($xa);$Ec=str_replace("%d","%s",$vg);if($Ec!=$vg)$xa[0]=format_number($fe);return
vsprintf($Ec,$xa);}function
switch_lang(){global$ba,$zd;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$zd,$ba,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ba="en";if(isset($zd[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(isset($zd[$_SESSION["lang"]]))$ba=$_SESSION["lang"];else{$ra=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Nd,PREG_SET_ORDER);foreach($Nd
as$A)$ra[$A[1]]=(isset($A[3])?$A[3]:1);arsort($ra);foreach($ra
as$y=>$We){if(isset($zd[$y])){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ra[$y])&&isset($zd[$y])){$ba=$y;break;}}}$wg=$_SESSION["translations"];if($_SESSION["translations_version"]!=4240734095){$wg=array();$_SESSION["translations_version"]=4240734095;}function
get_translations($yd){switch($yd){case"en":$g="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qB742Lt.\nHh\n|Z29Cz7IH\nj=)(/\nC:\$0ʖZsj84N`;P9Ikl m_<\"H\"L2qa	r4Ԉ1OAH<M	U\$V%\$	К&Bc͜<KF⧭~,r( J\0Ap9P&'h6B;0\"ƎR΂\"ލJp򍯃1#:݅P[3\rOb8+!:0)`>x(\n[ɝ/]G@\$cB3Ot\$|7}x!ݰX4;<y9%	R\n,q	]ñ.ϴ{jֿۆ]P#_\"6A?zBJZxŁ<p~=×DZJ0<(b09ih#3;ez&Y0Ɓ\0K20=mآy\\_ɨ \n (  \0\"H&4D!~Ni#FD42.eIAbLP\$0{7~\$7xdq\n\0004vZ[31hѺ9Gd!0\rmRvI90fȒZKBHIN8d'=W5-o.SH ܐue !ٕHSthG'ǸʴL\n	L*C5a.S֣>}s5rJs}yE܀JAd@H\0gL(H#RtXixY&\0JI&,+q\\1%VPʬHڝSsNHM~3QT&ƫ3r}I8Ѹ+C`+5sH⑳N	'G=@BFqsIB0i~{Nb[\nҵ0FzMo\"q\\Û5J.`.*3j]x5ɠAFb?ᴳcITIF@o'/DNý:jt(j7<<BPN\nyQm6AR4UVW_YOSA\r-Z;HHm0.";break;case"ar":$g="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o|7LQi\\ H\"#1ŋ#܇Jr >Jsޜ:?P]<T(\"'?npSJSZɻ\"\"T(<@SN^v8bWV#3hD>T&LeSx|'ȍ@Iw[Il~!TltK=덮)uۄ83Q_@	ht)`P5hcT0COhH\"7^pL\n7gM*g<7cp4Rg:`BC6L@0M(3c2Q[!*j=A@bO!B\r<:cd9è\rxach9o0A\"Ck:a@c\rO5/jf*4Pf3gî\r71X0z\r8a^\\0x7:iD{3x)!3pNZS~^(\$HWsjt)URfPyF\"\0䮚8p\r-u<+y/-ޛw/\\9=Cim4\"Hm6_[<ކtmaa\rf4]n< ̩)?jƋ\\	!.4PM80iCvRo7\n\$d7.\rA\0c46G%RJ:av\0jC@pSD4CEJH6kTk\rq\r5cfoЪ;8!xa\$\rD\r@c74CH ҆0!4\$4Y\0FJ+EFmHh_y\r-PU2\\ i\nز~'R\0HFAE((B!ZFj'	I#Aς\0UѧB@7C|lqd]\"x%7\n#Cŧؚ'\n<)BDY/,U{8BlN\$ĺOrs꺻ȪMULDh[S\n (K7!pP<05\0S\n!0ib\rkP(XZZ䡒rT֛iSR\$XF~B.uH-:\$5MP֭\"lY0	C6|Ckhi\rLl;37L5\rͷ\"BF៻Nz)}f1{Žx#Ò5\n[5w*PnalֶD\\#\0ZaШ@r[\0DuRD-.aH!\0STXf}\r%&@\$rq3Tիl_)&d]զ!\$YsuFUQIQ+ߌ Pd";break;case"bg":$g="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLH,/\r/SYF.Rc[?IL6M)V5԰КRferhiʍW4&+Œد\\A#\"-(U⭣?	ZwjK\0+@\"M*EV\nCbMr+)YNJbBX6#',}́C2R*ZWE*˲xםN}[4{^a\nhR8th(΀ PۈvʚVD\"\r#b6FpAw\\g27cH.(?P:TFO27W;;k=˓6)RL\$pRM֨kήv<y?}ELjޣhJfw\n73T5w:omz~]Q`{ŉ-v,\\PѫB`4rA1'3*Qfq̆d\r7\"ۙ@r p`paPV{G4x\"1@xat!*j`^I=x_@xa	`\$N5<DayAjٓ]a|1pØwaw1ȏbrb'\$G,EQѦUOye>GM=un^9!rdB\rg%nY=Kϲ8f^tNS\\@ЍCclv^\0bFAC*!\$|9a:\0<\$:A?Q\01(Vpa\r64JQ)B#xVZ;Jw:\n (&-DS+?R^d	Y5l\0,ڊ7\0Hve3Κ|ӅGaЩLE֥B' TREHwpCakWa>d1>L(*\"Hle\"8HvM\$OF&eRuhtݧTQ;QТDR2g4]j%fY\\K-6 )/l2K.'LӛMd|Hׇ4KK8S\\&Z¥\$&OK\$x0NxϬ^Mj;^p+אB4K L[.Y wsί_\$E1dgNJ..I!!\nٖ@L,еC-\0F\nLKZRYє^ݓ*\n/cy?0J8rF>L6Sb<uڹ	Y\nL]j/yF\\12_MqDn6tɊ;\\Sizo\nZ;!MӬɖosZN*@AŁɖ2r0]1(c(mnk]ڥ֭2b.WWN1TU<饛Qy.2vi24=CpJ?yeҪWZ[¥{gW\0\rHR_vy2~\0.	m*U.D7ʹq\n&̈́v!\0Ea+N&g7RNrcn/H+&rz*JDCjfvM_n	*'԰:3<}+J+i2#";break;case"bn":$g="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9.#\0#2\r78M:c2@L S6\\4Gʂ\0/n:&.Htļ/02TgPEt̥L,L5HLGj%Rt-I04=XK\$GfJzR\$a`(+b0z5qL/\nS5\"P(]xW}YTW5e޵}*P9/Vu*RbXeݔ^5hO!.[8\n@< S\\bѶr8ȊE(xm+Ď+^,@'nE)\\tWZ\$z·+/\$D\$8ZqdZCڷFLONC	Yda!sAAB19~+g*\rY(աIkMՉW\$Srj_Fs6.ڟG4@\$Bh\nb:h\\-^h.MMѳTmGǺЈ@/rMXN7cHQ>T:@Swr<3`ؓ**+JH\\\0%\08m!<\0cg9`\0l\r&0X|Ô!0A\r`mI\nTKN\n5*q\n:;cL3>PRh !~!6\0xOs@x\\	7p^Cp/O:?)?)03^A\n6mv\n*D\$8!n](	=f oqvSGB(`_hp\r0	DFh#Tl9GHz9Gt~/\"Hm6\0#tZ}'a\rg4\$nyX)VTW;zolD5bI:͔P\r09\n\0w=1@\"r0id\$ТBDd0@\r!65tڎEL%J;GDٝ@C.ʣZh{IPe)\r#='T\0r'M!Pw(|@sPp;pp9UDOc\r4x(*<0xSڡ \0FXj-ꞪqhG2}b%,+RgT	՟M@Eн&I?]T9BkDl6fS!s\0dL)W7T\nV3Hy;2Zyv\rӜ(CO7ص2-MA'jU]TQ+!(h0@'0Cxa7sR#_D2@-\rMm7G*`d\$b}˯qRJĮ|l7ǐAL(@h =#JhiJHaN\r7hL1!@;̕Q (LjQ:,@3((=JZ)²:4εlgg8\"*ɭs\rZ#N+ʕ5p;YW\no6(CkB4jikL3A]B6a\r]>٘lBFFKRK-g5a/>:Z':'H^xZ,;JPH3)\\GٯQmzW疝u*% (&=Q5]mx>gfx^>{jvIܧW8X4]ep䋤V6U8&eVZSzwN`+ǙrK&0meۖDQ[il,u@:/{uo+>qP/\nA}#*ˊ>J\\LUZ{1&xR";break;case"bs":$g="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,	+-+;2tpɘHǋ'ʊBB5(L{,SKI\"5/ԥ!IQR<*PH gR)tƭ<14h2#&2ڇr5l</\"thP2%\"X;OX=1\"#ìXJŘ2h9\\HEe1ͫ?4\rdޑ\nM|ih96\$Bh\nb2Bhc4<bB#hkVn)(?7cHߜ%c\r0'27/f9Yե@hڍ)>p:cT9è؁\r:9嬌5rt78P93RR2*4MC:c6X(8@ yra42c0z\r8a^(]Ð\\{	靅}أHx!\\+6\nXQhC97Ҹ'pR#'\n检,s<;=J;jc[׌	#hӱp4K@B95rs_h6PMQ+9fg\$qݙ晱D\\4\r23vf_l-6hTA}\r!@>9_	H)'s( ,\\DGD	TAa%\rhP`14Ԯ\rYA(@e!+GDw~͔\rpùqw:Cᄔ&^;!0&YIuE`Ȉz56UTdڹ96raR1&rzsLA+0@ٽ;IDECD蜸!\n9FL8ST1Cn1)vbQ86<	 @'0ȣ\"C!q4h!	2W\r*Cpf!D2QS>}436O%%bQ	2J@B0T\$i4O94rH	&\r!rQ,F+EC4\$]Uu*rRX=4`u`+ݢB_QJʮ0CK܊;YButAkEso\nP#p\\<dJy4 n]v+NL\rhVA(.L0rR\0eCfؕSaI\rԏ.wڍ16✏/pB|fUIRPCam\0_U0ڰ4dA#~E\r2vߗiUf7V0j1Hfjb5\0";break;case"ca":$g="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.̀(p4h*; pB+09˰!S,7\r3:hŠ2ao4эZ0˴@ʡ9(CpE1^uxc=(20؃zR6\rx		ZR3єr9g+ͧ0e	a Pqq\$	I(2N;WRvmoPpy0o4^_q%9[@	ht)`P2hcL0uPu&EꓯY\$K7bb&C6L\0SFҤ3+t997R *\r|70\$:P\nC30\n>*l7Cc(P9.R#b*`Z\n3f#&:2\$h420z\r8a^h\\3_\0OdTAp;^0hf+9?떺69Bk\$Z1Xo2<t=K=_Z;ݟj7v3_\"* !e6f>a\rdt) Բ8/`\\҆{I(\\a\nBQ/%#GC\nZ;R#r]3i#\r_\r	`h1f\"M\n\rv~Q0FdhT@Z(A\$MRP8E{pg6f֚cJj ,\0CPW>I\$\"\0001Ģl*710¡C~C|>) `M6\0\$Њ&1_ARVT'BTaH-\n1E8Ia1	\$D<H!\r<݂)H	*?39ʻv?)a'(2>@\nO:>͑\\/3V5Q_<2Ȅ͢VB^yeDM\n}#yPp@L)p/\0@gR|ƓC4Q!0AグMMyftWHy9S9:dUPOST\$\$VaXI'e*Yk9*\n~4\"\r0VcꍬVCmpPb5B7@BF/jy\"֮9B`7kFk3֥&MFYZlhbL[ݮ5T1l&zm|7,\00:vԊ[aI0ad]d^>wZ=	PqI*ej\r\0eT~}	``#JZ#\nˣ\\@/UDiZ\n";break;case"cs":$g="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4ƈ65n\r#D8je)Kb9FnBDB5\$Cz9Ƃ;A.sVM# @10N}Q,C7PpHV55@2DI;<c*,0P2\"ÀkʌB}9\$q@@1t3nͳmP<'?CtIOM67z5%k^p]`0pGϢ@t&Ц)C \\6哎Bi-4ă8	ٚ+0=)D+0w<	J3<3^uЅ\r\rrjm^4#H:k3&\045pR\r`754Ӳ;Fղ	ޚ;њ6;^;oWÿGp\r8M4V;)%vP҉7M\$ԍ.ljnM%\n73x2o@2D4xGHc^2\r4!xDQ84xat1zNCSTj~dn/ԑS:Fɺ[	70V(!2\"jJF@P@r{i=|E><\0|Cjct7\"/\0 aEL`\nc5`bd`TC)p[BoPtI+YOU#8ipBPQۻ0ӃQ4&,Pi4^2Gi+	rC3+a30HH\n\0MIZM0 @DR2F(gA\\В1BA9tn3xǂyȤA	%ր@0xS\nA	;fƇT&\\y%k\"\$q'%pYy;L\$BS*Dz h\$PK|	FkܩF\$3\rP\\xBO\naPBGbfXߴ6Hil7:C0irjak~tPQ\naD&RNU௛ЏEGhoM#Ifoɂ6(7r8KA6ׁg=/SlᏳЛC	BSY4JLOC\rYB4QZQB\"^3FiX* ܢ2ΌB=`IXC6P}yTtVBkU@)DF6aGbe¨TP,ζ4rIXaZND9Y6.=bDuD+e&n2*\"Q ;G/e49ZƫBЉ9Eh6ZvN6?.,8x^lRv]h\nez`azB\"!\ny\0֪x@g֫{G2֠x@*\$i0UV<lH\n\nq&¬9&~";break;case"da":$g="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑#j\"<<cr߯K;~r&7O&8@(!L.7422	B\"l1M(s\rC@PH h)N;,'pH4C\$2@\r)(#SN'P\r QU,t\$\nn6:B@	ht)`PنRvJ.U#j2=Lr\n7B08\r2	܃\rOLPBނ-(3\nEP\$U06b*\rl<1o3{#=jMêjaMp<P42I[mv2#&`d\$Hx0Bz3ˎt\$:[γz@4!xDmbbxCX3\$6'KBt7@<\$#,BNߡh.oζ:kñZmCvzWd(6͂[zƑhw۠-\0@3M*Dģl5h|!Kͳ>~#c|d.9L{<e:`f(a91~Khs\$9Py@0͜*I:2l\0kd\n\\z8}<\"Ӫ`x.I\$#rFO3f)O31ӍkHw\r1e6fM`1ªAHeЄ00-,d\$^:y'<֒TK	qM3\r@oa~8sD.\rqС2DC P` ,R':B/i-,Gl>'99	BxS\n9\$BX 6:@Ciw(J4vOP,]NY|@UkL砂>GH!(%,.B`-A\0.#.K\",@L8pHo /UC\\z Wy FۂȄ\"Nla\"9р4>hMd\nB *@#e}.\$JLP1qMDW)}a1PHGI8K2Df%JF&5(acH1mg:JhX~U\r>yCJF&#H31E6ar=hNC@|F	_#xbMi+aYKAb[]TZ6PT.)O\$U_k0D";break;case"de":$g="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº\03#dr5\rZ\$4)h\"CHќ(C\0:B`3 U9d:Fib!-SUP0K*pHWA:b6+CI+¨s7Bz4F+H(Z#`+Z(57\r6#\\4!-3Wezj}7݌W&cT=R@	ht)`R6ՏBŷc>Jl`zIݖцc\$f&G\\/4C76\"ϡx-7C!V6\r%J\rhB@\\D8A624 bj \" ):=߭6[%J\rs8>|nKI\r&z\0002?Yh 2\r\rB{DA\0x07@z+9Ax^;r5ܯp\\3߲\$vA46\rsL7!^0ggP:\0000@kV3juEѡ\"` Zʏ|;x3<wkz/M=`9goy|Chp- ɚy5Y	`NVQO7 fNN2/Г@PL137^T!f1:\n1?Dp@f:`8;k蘧B#ZM@16I>2|#ba4V{6*dL\$h\"c&WyD2GQ|!Hg\n9F[aCJ=0t*n\nĦL#\"m\nT az7rr1BfR*sӀNEȢXv2&ٲC`)~_{GlNI~uDd;E #@K̺6]؅0GöA;c\n髗t J#nѿF\nJnِh&	P	L*.A	e7j]@z8U.`QIKPOZ*Q߇R\$	d%p}qv5\\D(ʬ4FP(.JѤ<\$\ripl\"rN`̺3F`\nB,R*kXlHe]ȦڕLplAQDA\rsV%S+BĒI2-d#T*`Z\r,AGQ5o]eU/3&lv-1[t;љFuKeĠ00d||PLC \n5\$f7b/HVآL\"-&a4RR6d\"f%6BXsU\nf!FkEm\n	niT0_&Gp0@+8{hf2ѝ`\0";break;case"el":$g="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0sOjC;3TA]ҺaOr4vOxB-wJ`#k4L[_\"h-2_ɡUk]ôu*\"Mn?O3)\\̮(R\nB\\\nhg6ʣp7kZ~A@ٝL&.WB\"@I1H@&tg:0Z'1vgʃCB5x7(9\r㒌\"#1#x929(Ȼ[yJx[ʇ+\\FOz\n]&,Cv,[WBk4F9~lD//!D((H@KC╖=APXJPHF[(eHBܚ;\\tC%%%%*d72PBPoD@gFuӼ4ȤdӇnQתKq8\$􌄗cn4c霦;I	\0<(湾r\ns8(%xHA	^ R^5ֶЦB2]JEP6D1@LenAB	=o򊠯\rQR]/X)yQiz'&qR[:\$Ahz^^ڄwJa|;\ng變\"\r#6MA2#wΞ29#D`9\$؅Ŀ;Q	>6vB_YÑ 7*K'|u_KQ+dR+\$Gc/\$\",	s;LS<CmEb!:6\\jQ\$( S	<!tJ ^rO*BT\nfab:\r	rVTŃ<EԌb)((x@RtP:\0\0A4\n|1\0xA\0hA3Dt^\0.2B \\C8/@W&\n/ xE^2B!\n b>%(KMJ%pR@\" z%+D;Qo\$\$bMI=(3JU+|\"`gJ!F%̻Sܥ7|^<`)mzveD\$jEETR[\rRg\n88#C	<Lj!\$X@GPЛcvCo	= Ya9'ӘsȆ-E\r!4\nțuOI,lj֒C)[0&%<8:AquP%A_d9j|\0\0(.%p}S%%)^PC|RKz\0pA;7pꅱOPޝ^B&\$odsO`VsCpp?Ch\r!@&o0]R\"PqC:Jp aL)`\\IIhM+;PgMa)M[iʽ\nCl<ޮpX伈PܧB2Qa,\"SQ~{	/D؆Q3CCFb5/al-f\n|W18ZHxS\nݏAu	TTԪ%V`0&H@bP:o\$_2*1Vf3^5\" _\rQT L;Cf%X0(m' #K12Hђ,A>uene]g+DCMAIKD뒅يJEy,#!l\rޖjEڊbJ-Ƽ]ʇ&̫n07s\rPSQM `+a톸dNτ9a	I3<T_-&Y``:Er:-	ζDE0-3[&SȦ[9mĄo76?A)ٔJ\\2q.U\ni1)AFs%130jO!1M7Fg0MiEnԔp6߹Î´s1dWqLhtDiwqͬzAش{,vKʖ\$TggAUWsl3ٌNq&֜/PjV!e)|FX:'\n4WX8Tϯzb4|a\n";break;case"es":$g="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[**.<41h.o)ZHL!ʢ`޸΃|8n(A2:<xJ24;O PR jXT\r&gDjDJxc3k[L,L+\"8x2\rC9sJTC-/6T404ƈh0tx\$	К&B ^6x0\nуpM.u?@X#*<3Cd̳ik37+.ҹ؆QRVH7R\$c0\r:90bt@3cQ4-sRn>(AkyQD49Ax^;ti¾r3_\\(AP-A^0NעQõд	NH1\nMCJ&L%PH4pAƳ%r5?=KOՄJP|\$]6IC '!}882#\$FIA*3@dhQhn@ynFϳI)N+OzmI5b	Wa%'wl3<ډ)<+i!2t#A@\$<#@A1dprcv2biI#e:`-\rT;=wC0p! ~0%9E:H\"0ax^S\nAb\ny8 \nP6d8%MU:d*\rM?7nHܜV* ?\$6MCu\n!\\b!Ta\"Hyf3\n<Bi08B`mpoht^YȍrxS\nt&rG 1m(@ uF!tO-gpLCc#Q17Rld^cUr\nFBb\0o\0\"\$d:4gn)t`IYCkC 0xJe{jؔUEޮVIqx`+Mf+&fIdjDJZ4]NTpj&UtQvGkAYWu)̏FjHV17%S`0y`e8:9UQ)Dp6գ\naU8ǒCX-p^Q0t d+ob*2AKREff\0fOP !*\\PjDe\$TS6ZVuldV-U\rO=1	\\Wqzp*1W7~";break;case"et":$g="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\"Z9D\$H2p\\\r2( &\rb*0`P෎/d7H5*@HKK#<S:\\8b	R\r,0LFB4KP4|B(ZB\\ʙRK:n7(j7)%d!:P7#X\$	К&B*h\\-7.y6H6IJOpܹ Op\r߈dEʲjR726{7'P\\R\r7k<Z1l 3b@CXY3/jq8S2Rc|6hR\nDҁb\07%1i4D49Ax^;rIAr3^&A ^0+4n&I<hpcI81#*jzUK8W0\\nop\r'Oƍn\nb^DH8 :s\\/zӸR%O~d|%4 OTl\$07\${Cg&{ƱvrbY>k i)|4Ci&A̚RSx#(P2\0ɑ!%l%28iՔ @\$dЫ0P50ؙ=͠h\r 5\r`;\"SD^ F96si}8gvb] 1N mz4fEL03AGd)ñi\r;rpN<%H <4iB(ѣ(XI&XRL}4c1mB)	ZpZPTYe ]LdI]\$+V\$.ZBH9.&4N^Àh\0e%c1oѣi\naD&\0hL**Ddd+J>kjM`AUJS-oV0u1sJlK[IJ\"¦ڡ:tosdja\r57faK%ƖBF7Jv@O4_9r!pJP0\$X&\n1m!%kGR֩ũ\n oa0LZI>@FП*\rrbu¡Bdn7µQb×HB[XbkֲZ9gU(;;#v42Xu/4B@";break;case"fa":$g="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&Y[MkLn 3Xnv%;Cl4B:ʓ2sC'I1\nIBi^\"#!HK[>T!hHADB:3S\n@R+;	r됉C_C ~XqRL=Oj[2l_&\r\$|[\\	U<b0J;Ѱ\$	К&Bcl<h6 -GMT%o\"\r# 6BA@v:27cH߮E),C6I)D&&Fx䴵21Tk.,C@KFFlxI<e\"JRBstp.\\3?(]%V|D\\y!f^ɜdI-╉.K\n@\0C#6:h@ k\0ǯ\$@4C(C@:t>ϷC8^zjAѯ^Aǰ3^A[FYEpQi+腸@ʻ,-|4Rrt	P8d+cL+zwm9GS}?G\r?Zk0|R8\$`r6gZ!!UH.(VS\"*B!ݱbf_4D<(Ck;\0bB C*!\$:a:\09쑁:A+PJy lI>4nYSI\\BVzB/ä\n (#8N:ql\n^{Tuc/\0Ck.D^\0pA&g!C-%\r9.e8w%C>A?0sDrYaCCuDH%l@irw\$PaYF᭭UXyI(w,eh̬7\0AS6Y%7 ,LvoQt	\$h<CJCdmi[?Hqad^J|r9N}C({XZfhчZE-D:8%`Z)(L@Ն\$8\\bIT1FkyWZcFxY?EلWS\n!1֨V)mw\$RզF<\"cvاBs0\nUJ ^QjU#&l,ulC˶Hl^^A!;y0_5!Ruj.§gI6FZW/OP)*@A·nqkm!EOc0/a#u<Wq+HGq6	;f}I3LZ;>%UxU&K)ݶgE?E^-S]	.bid̺TqRVHDm0&\$\n(ɆO)64pi1i\$x̞\\FR\rO0\n8~y%m]t&X'iUOYUMvKwil";break;case"fi":$g="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1eţxo}Z:L9-fS\\5\rJv)jL0M5nKf(ږ390`KPR2i<\r8'\n\r+9\0ϱvԧN+D #zd:'L@4*fŠA\0,0\rr䨰jj\"8ޝEL_#JlDp+06 		cd<0.\n2P25SK1X1pH0Sc&B;B(\$Ih4l\n&-#Kč5:16j5e\r-0r5e(]L[ p\\VUt5WU KBj7=S	ht)`P8(\\-؈.V~	CCR]pMr׳iN=75BpwGBd\0%`*H72`\$BXho<:AڃL\n\rfL2b79/sEC.7PDAKFBR򐏳łjΰ˴Pz(\rjI#vƎNѧ.FO^s;(qy|*r@#JjMC6dQH:.cJٸ#@2D4(x?9Xz0ۨ`^π2]#\nBdm^0ɨFr Oj.|%`@ 4f.椐FA9='{Oqg n|2NQR1L7\$]e4Z%(ñlC?F\n_CaMC)\"aijޖhvh}@9;GW(-MDړPty3Z\n	6nXP	A	v]!+&8BWa4ȐP(yX/\0C?\r=d&py.\"~PL!7fB\\+A\$M\$#h =Q+\0C\naH#x(f/i\n4%`˹@\"\nr]Ɉm.΅Ej_FA1y\$tPg_K8zh P31q\nIJPʖfV5tO\naP[(|\n4GYt`Ѣ8[n3E8!S(hg>	9r\$0*e(#@;dW!8P\r,^JO̵@+\$իȢfP\"wbJedgDK.y{vAMY%xK)\0Xlͧ(!@\nͻvT9QN\raC*!¨S)e`̅P;AC07\"m]YrcU_l7&A҂A!0fgyD&X p)Mߐ(5\r#\\Z:bO15З,QH4aJ]sō9<_@SkI>k͊6\\աKrfwH@TGA@l2\nJCKtޫ{/l;܀\\r|o@#G7@";break;case"fr":$g="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P0rP2\rTBp;#D2NՎ\$;	C(2#K+\0P4&\\£8)QjC'\rhʣD2B4ˀP윲ɬIN2ɦ;'\"dK+@Qp*\0S1\nG20#SJM32䡰,H2cc&\r:!-gZ4P[xH2ed?/r\n)[OPVُº\"md%2\nc݁BaZ,(ƃ,}t7I3	ɫv\0ɅgxB8YSH(w0@	ht)`P5hcl0&\rR*,Z+.GvRIFUV0z§BѢ%F\r7\n(XT#+6շTͣSGb;~H>ۻPET{Ec3wPi46đ#6\"8@ j oHz420z\r\r9Ax^;p\\3P_dw0^xl!EmST KiTĂ]G7PkT 'Ru^2ay/-G^ztCsj(2pU¥Xɉ=\r)IR\$ʆeb~٩F(9J; ;@\0rvʌ28p@k9c<LCy}31UKG	!FTΔ#jfd5RrFeI#BBH\np:\\ Pbc!\rĔfظ>\rmrN!'@XPPd]'AQ1RBI?dFx-RHBnM!|y\\F>B(T\r᭥\0F<C5p3ҲKi!V-E!@Sy)2p @A8\"*+A3ҺWisRjC\rTeCzk`yl\$ z-:EH\0¡>,m3&HRX Mb2\"ja='B3\$H=QҳrhC\0˙HhaFɁԑLQ	`\"3RE)})L\nM5&&ЄB`'U\$=*aZjielMD''LY*lOlA7{2Xڴl6fǉC,A4F_+nUn!1 o\r&6-Qq\00-YPalݰ䴆6\"rLVv1}\\x\$4U#?I<RrW@HtW6}Tv嶀ҝ?&\$PESF+B_ऀXlkE4V֔2&MFpvlaߕO2\nR5f]iKΎY=2a͂3)ЭT\rtB\"";break;case"gl":$g="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$V60\0Q!X@1*JD7DS S\"<#Qp1ₔ;A#\rI#p @1-(V8#R7A jǢ\r3\0jc sTG^\nc*Ajȫ*\"-T2B;U<<C5XCP[+Zذ1Vuu6\r\0T(3@P\$Bh\nb2x6Í\"lsR*8wt(B%IMDnbD+BMϲnOkSR2^ \"_?r1}jN\$*L*r7X':Zk:In5PðV>%R.lET0Ui>PR#8AulVR0C63:xمѧ:#8^\"xDw}F;q,7k,'\n-<K}lH;5A72yӨ\\tO}o_cj2vwrsC@DUI\$P '¥UbOBS׋*C)k!\$#Tc&\0ؼ,Ru˔\r199O gA`C	3=%;v	,3WDZ0MEP	@#((*2;#āU:S	7%a;pC\nĂ2)G]Q:86\\iƉA Z\$1=xkl) PfU\0	ToĩJm3ŇS)^I	*	V9\$GlGބIHfBJW*J{|fnINZ14BVk\\r/2cF£WmstLK/HՓ4Gs6lHvCm`z'PD0JE%\0BcݡǈrNZL#Hu&.A&HEPm:A4	ƔZHjnDș4ڬKEV\\@TK~VՃfm&\nq1#H	)ԴPV9+:Tn]%Ƃ\00-5WaIo8uҚjKɠAQhs	d+tb@U[K=DRK65 q=uApTAWIE:ŐX%\$PJѝ<GH(P#~fAKp*5A*ӯ-h\r #yXEb;Ekd7wK~o5]69";break;case"he":$g="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;.!Rc1)!+h,V%2֝#I4'\rbkz{	140\$M\n6A bnkTl9-ð) D妨 #htI d5;-r^\"	< *TRlwZ/b@	ht)`P<ۃȺhZ2FA(Hj<Nx^Oy2Ø70(k:\r{&(\"\\MpJVzMԺk%i>m֝Z[ebLXXp|b5\n6J1N)zӢk6#s2_Ja\r3:xﷅږ<o{{A`dx!:pgfH>3-됓N3_*6h:vsNfŲlFնmۆ媻voM+:'e	_rO{ѰרS]0P:4=Ǿ\04`@1=3<Ch?#5cg9``oU=\0؃#\0o64]3 \n (\0PRIRX!Fڨg!\0C|q\r@#;\$  J-O??pCj3a2C!5*1LYb\\c(ZPS)i*p%ԏr!fMVI\$E,%dhrlĽ@ZZqbzKTo'iY@5CD\\i>II8īƠxS\ndRb%3a%Ld;՛RxkTHl0i`&&gUpW-@#HZIM\$d)c;`cq\$vr`FyiA -v(Ľ`sIKOOST#ĵ)NmIid TM!k3b,A0-\nDs:TE#FQDv()dz\\	\\n,%09\"-|F%<@KjT\$rGD~]TVdCIeFI-ycG}NNXdKizHTzUyrf-	!6\$@";break;case"hu":$g="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;9ʻF@ޠqFr6H\$`P0K*モkC@9\"M\rI\n:!\"HKQU%MTTSPH iZ Pt}RPCCb\r˛pbPX%o;Z6-?S`!؟4u6}Nr\rw]p6~~_\06\$C\r<Ⱥ\rp#6\$6`A3v`֩²7cHߠ&bIK5KZ720WMG{_p4a\0c0:9<=.]D6㪲aK\0W\\QZn*5PIp@ +5zab4)0z\r8a^h];Tz\rxDw-|cX!JSl5KΣ)K !t5KF\r=Uz8\r*DDsOC?S_Awiw~Z)\$m`tx#4E:04J6\r%吂P\$ ;VB9r*dJa\r6Lh`;TrHr0* \nl͡6ېD=3G\0֝\$9!0Mqw/.da2}tbL/lQ7LH\nFs\n\nb+d|6B˒ fCm\nUeD!b``w.N,͔(AIsC\n 4kKNCÂA\r!Ҟ\nO8'#e@C\naH#\0!%B\0{-3P5'dJѝQ)H7Q	7&gpDCɧ-.B8E 8S\nR2\$Qؑ,g\0!Rb9\"G¡0O\0.V!qK'sQAz@;ՈȃfNiXb`)L6#HVLn\nP\$WAn<-,bD沣PUbL涞ci7^7r\r{S⒍X|(P|]\r!CcMCe,R~fɸF\$I'BT3W3?pgJ3{\$l,\nիp\rG\"\$'~3쾥cEMEҔ`aE0a[j\rzQz#A84Eg1AQ&,%q/jP C}Hby<m;\0007㰯T(S@hդ;x\$o1>&=fZ%tUJ@<[mH\"^2cuxkXBw\rᬵ;X9";break;case"id":$g="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87 ڠ&#BZ\"HBM9\n&cK-CjrB(!\$ɐꅌ4)A bBq&5ۯκh(H6O[) L	V4MhR5Sb!JůcbvjZ\"@t&Ц)Ba\"Z6h2RJJ9\"ӱ@@\n靬2X̸@PL;1x3-#pʺ%m%d\r	1i3S\07@)\$h@Ahڄ6(P9*ZQX2\0~Ihż)l:@ 9bȊ%\0xC@:t㾤(yP=8^,xDkz}|BXĽb@pÈBOlH2iVjg(Fcvp,)ճ\rmV4\rl@x`hKI\nFK5&3eC0{;N%(W>/Ya'\$\0K,!qwR:L_3\n@'Rm<'AB\nJyl0\$!UY2fT˙}Ðt& ûx\$R	ceB3~I[~I;@IXgiDЧ'N`04INX)>(aPP P91!UKIP\r!!RZHxy16PGQ&X8R`F1\rȳjG7xtzˀ \n<)BJ\n(l1\$QsZ'	;R0i\$	\n\r3<\$Q	2,@0T~6d\"嫦Tes(VI4ŝG5țDSҒ֜Dӈ_\n-cfpIpQIIVHc\"Ŗ_du.Z,NB0эPh8&L&Xz@PGni\\a<rI\n\nJ^v\0΁@Ѵɨ\"<(%-LL%\r\\09PL\r6{*[V4)Պ%)p\\%)=B}0HEEL-'^R#`";break;case"it":$g="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCΤ&C~~Fthts;#Cbl7\r*(椩j\n4QP%\r(*\r##Cv`N::MпN\\)P2.cʍ\rҶ)J:HZ\"H0Р#1B*ݯ2n\rRJ80I/Br;#ʙ(CʨC\0A jcp:B|%ΜT S[_9S(^	;<:,2732ԃ\n>-uOqR쎪%\n4P\$Bh\nb2x6o\"+5M=PLSZШ-xw<@I*469@S \"	3Δ\nL\"ތMCˎc32Ac@9cC׉,6P9/	dr:7rՌךPɘMcM!D4UxﳅV@{ض7i ^۝7^0؂w)M90/\"Ȑ䚦)7ҩܳaֹlŲlFԵv7n+v	#hNм5/0hZ&p<0ðI\n揥m2\r!\01(2i#);#7.Bds0ACPH!n}/pze93#L1;?WIHP	@|@b(\$!Da3A<t5fJúChe!+VL!;8\$İX?OԆ7;`O&p oy!0` I@10\r`ҁr ytcpP0Dtʖ	AE\$\"LS!U;x#6֞M\$3Qh\"DFA\0P	L*FECy>)ETs&)	VCDI!0<^\$Ğ` \naD&,0T1;(rfL91\$q:M@9C<eE7ItS^'G!\$aN%\$'_:%UD\0\n3\\ !x[d3jᴼhFAT/Cr^-ONczK1B	΂DLQ%\0^0yZJ&#0Ҵ#v\"-tSbL\r5/*L20\$3\rZDSKYBe=+bB~0\\P0SLX&.,\"C!̌OS\rGVCv=~&V";break;case"ja":$g="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99##X2\rZ7\0\\28B#bB >h1\\se	^1ReLr?h1FzP B**;@1.%[,;L)K2Aɂ\0MRrZzJzK12#eRiYD#|έN(\\#R8U8NOYsI%`trA~A,[(sD%G'u)XME9^EJt)MtxNA EHd! b!8s]g1G[^\"Et%E?4rU%\\r]/J	Xg1n]0I2\$6AҘIey~Mzy},EҔ=u10cΤ<p6 ȪU7?V3I!XÖ29#~P59p4\095x3\rH2]smuP7h7!\0빎܎c06`3CXݎ\\3<PAP9;řɐ\\*50t3l7\02w|X׌{2A\0x0 C@:t>Xp_\nm#>px>qnG\nhpO H 5ȫHXV:3 R H&ۑ\0sDH\\\"%{π4>'C};r~7/ED\rm! o[9kJAiņhb|\"O2YLxS\nS51uZ[3B4]2tΡ:\r\"N!\r99a0s2F#A,\0*1FhrCAQ![([ۓ\$		VL4a\r8Mٯ6&ڛpʷPr!t3+]Pw2A8Gnn\0sD۠cppw0Ca2F1hSjt\nF-xA(c5GREDW&9DxUPBbds'BL:Q	P	0D A,L!E2H,\\d\r+t!\$7N8SrC2\n\rJ#BRvpsO\naP5bA& Dr[3>SpUDXBt	`EEQ*jk5\$_k*fToSpTF\0B` ӔGPpUt<rCH ՠVBHrHd]i-H&Šʎ2\"TVBHsc1vޛ~/p\nm6Ckli[[eA39s5\r9'lBF=clA'UK,W@8_0%b	612:,PtaDsp2H)b9)&FDɐ>Bgܗ~:1hUf\\ϚH0=g\"H.	?QĀqXxpLKʥ#,%oYsc,v^K*Z;bn(X";break;case"ka":$g="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-;.JAJK ZmO1Kӿ2mpvK^(.䯴O!FLڪRkjA/9+e|#w/\n❓K+!Ln=,J\0ͭu4AݥN:<Y.\nJMxݯΓ,H00Եm(V/VwY<X5QU:K=@k;YOd@GuKM̬C\"K-?4] pHAVM'6͐ťY%E#P6I?;mrֽď4\$Tob!Ҁ'0f[傻4HTB,ֹӉ>r\0JOZ*R7[HdmKTW-?I<Ī˓ө86لډj>5M|uMZ*\\w䊩_ Eo)n;_^5ֹYꭢZd	zUyFB9=n>rǍR%4PP8ύ0# 4(*kɂ3ZucXG<9\$@es@x<~xe\r2Ciԩ#)S.xa|ݸl˱)/]S#SyH1[@BZSR<riD=+Pzp	3r<D\rF	X/`	a<)a<HT+E~7MCK*}M+w,:Ĥ+w7꧉)7|ɕ*F\$υJĨ\nz'%:!e둕۪7u➋o5^-Ǹae:SL77e&	'Rp5*\\qRQpXǾ q,3g<\n-\0p |uw',5=;T\\StkQzQĜ뚗C6Vk(K!mB<iR/)QeLV}':t^T69zݢ@R/I6L`)zGvIQR\\Nds!Oc\rQ',֣4rGKpJow:Vws4.j]|,~ؙTt0'!~Yq|>x^\r1?\n<)I@YƩSWPj̧q(hʎZcvߛTUV℧%bRg%ʥwzr@w9KFN;n*i[weDg]%}suKSnG+-:cN.% YLMTRIxB\"f =e 337lIHdRPn46 IAa\nʘpTdpסv}WExSp*84ԺĩeQs<q6v9xM/oR`ӌ65]zyILS}SP;5Lp͝IVe[){sQ'Z;\"	<eNH0,dazMՊJ/dGm*}FYJFql#C4y\\2d:]d%\0>mc}&7 =\0Ϟl7j2";break;case"ko":$g="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠈0C2 2a:8H8CC	2JʜBvhLdxR@\0n)0*#Leyp0.CXu<H4\r\rA\0<\nDj /q֫<uz8jrLRX,SǅQvu	\\:Ž'Y(J!a\0eLӚuYdDETjMH	ZEv%MŠiU/1NF&%\$1`O:PP!hHY9EBbP9dP[Jb0!@vdTYvHgY<?IWl\$jߥu|Iͫ~d2eJXMPtu t\"\"Z6h2/MwKr=y^ET\"\r#06CA	Av:27cH߰(5R^`90YJZGM[ve95Q*d*\rx@6#p\01q\03`@6\r;9Ō#8&)þaN˾{A:bꖨ>2`4q#\\B3j6:1{\r3:xp|=A>8x>(-͈RkkH.۱@<+;I,4ד\n,h KF/U뽗^|owrϹ?vכPmkl(t\rdGZ\r(rC\0H*4l선8Cl`;L(CfǹFsH6>\$N@1¨Clh#j]\n (dfsAT&:r i~+e|B<YұmǗ0pA5\0VJ)AD\$shGY0*!z9JbZ\rE	40;K^0ebyBuS\nAe MО%	H*^d64(\"&e 0LiY8h)Qx*fyR<\n>PBI!:ҲQ%kVz\"C DדA!/5d(!@'0yRaZa\"n)<p_Mp\"(D*\"\0)As)*\n~;D3!VZKF7%y1m	TБ	U|\0?'2zf.3fvX%#(^(h\r͕')1biqZWXluz^v5fd8xC3e#G8^2\$*@AUz,	7N\n&L5;&&N)	D-Md͙nĕH.qH:I;uaS2CS0fY#DĘe{\0l,Lx(O\nu8ʺ5ozPū/BǱ-#-cCddO6źP2&oasmU*a\0";break;case"lt":$g="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)ht2:H:RdpK5+\"\\Fl-B8?)|7h43[\nB;%DG,Z	i{0PJ2K5J%SRTâ,ˁA bx*:S4(TȔS@P:<s\"tP1˓U4FἮu5\$Ipy.ׅ균	}_0ƁKd@t&Ц)B\"Z6h2ZĮ*XD-\rk*fMp2ܔH)lZ#K̨3b2o4T3ދ%sA6Xώc06-z͟8<B\rPڳP9) bi{;*7)(b2|*2o^3fit#&[Ǡ##@D49Ax^;pjc\\zB;}⿳0x!5rA[)IRUbSo]|D,Ìf5\$i-%t |[K%u݇evw6xϚ\0ny\$q=jAl }	qMF\"XySFd!S*C>6e`rs/*@lHx bR gBX9maA\\b2ɐ!.߅	u\0eDHA(P͚,fzAh\$.a\"c1\"-EW}[5%HHc\r\0w`L2ه6e;l!0- qD7\"KJ]esAY\$\n/BVJ-%4EXj;E\$vv6|rsӠI!aj\$y.*CAA9\0]<>Khj\$AӗhO\naR2cA\0SsIf'D5JߟP+ aFWä*CDOh}M\"wmRZRBa3TͰ#T#t7BmM\\#J&.E%ȉ(WeB\rk\".9^zS})QԮvbU%1@-\niaVe	RD=r 'BT3GFMN\$5鑢8Syhx\\b:Gw4\$HaK \\{ĖKl\rIڀSy+EHqc-S_M %p6̅|ʾʴ͹,ROd (&d,8VzKUA\rYlyM.+_MUؾ͝6az<ĉJ+*(V!)ļ.d2d_t8";break;case"ms":$g="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0PA#BJ\"c\\'7E%a6\"7.JLs*\n	.zhX.xI%A bBr'q0Ц2`PHz(\r+k\"{\"2sCz8\r#oM&a;ʏzt4`\rd	@t&Ц)Bi\"(6 TtB#\r=01\\Kt(ɂĤ`Cd?# ('#x3-pʒLS#/]K#r1Lv6bS27')\nF\"\n/RD(k3,Ӊ\n.J*:	\nC1clq,2gxPc7sD90z\r8a^\\k.\\z|J*4!xDjC#x6O-^baS62ڒ˕eclXr0spA>ӵ~5;\r^(D0qx@1wp@дzV#c\06Cz̜(OaS~!31H@;({{8f9ȈPsԏRHt)H8ClE6/\\|\"BnH\n\0PRJ-U\n:0A,':@;'\"!C\"w\"  Hc)3ֆ'IO\0C\naH#\$TMNЃb͊7(ЌǣG)eK\0,KF=N\nt9`4@ɹ9GmYV-yn\$:.^U7fРTu\0KP鏚!Þ1Lȡ#h*BdB'\$EK3LF\nH=JTdj'd؛AɤW`䚃UADDkӕ	r\rUEla6;\rQF2`Ʋ@3obh)fFT*`Z	-0Ȓ2\n`#Xk=Mu:&\$(z	yZ5gRp޻b{5NrS3Jc(zI,@o(3J|t`bI\"f`:1\\T\"TImK\rPNE(s_5&]RkN\"%ʪT";break;case"nl":$g="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	X2'@m` c9ȚOc.Nc(j*%\n2Jc2DbO[چJPʙahl8:#H\$#\"::01p@,	,' NKjܠX3; \rш4Ck	G0P0c@P7M\rH7LC`	;)\\#4EO̎A jXB~宮 ¾pBȫ23#B]\"l09#5(TS9!KQMᡣę&\nSnM2\\Vj7P\$Bh\nb2HcV58aWn`6J.~\"*\0ұF\"b>#`;3(+\r0̏/iP4K̦P<1i 3`A6/C*(ҨꕅR6#x3c8c6*:38@ 9:#@4\0xpTAx^;rc!r3_\0:A0^00q\nXٸ|<僂25lo8WS8J]p	qW;۪|?J|\$p1\rçEbsb7-Vz0DɘhzO#eP\$\"G0T @x!F~ɷ\$JCf%gFSL(ؒ,hr,5nKcy2P \n (<f<IR=pPUZ\ne#O4@p\n@p0`R*%L4]&ua85D!)@𠠑ASpx) O[Z:SA'nl6''(\$h?@AM蔚(Lo-RlM.!ԣ\0S	tr=PK&6h(PTF2TK\nYM\\5&%K#YCW\0r\$l1ރr=9G1,C5E Q	)0u0TlTaa!J5:Oj8ͤ\$uGPiOA5TLOH\\eJ^i	5l68A\"\$LT9(˄j\nN,jT*`Z{zM)+1bErqAu32\r!*Y\"+HQ>HLG0\\sk\r!<_%\nDvzbF7,EcP\"bʈu#5`Lv?ZrbwPPjILH.IU\nɑa~\"+Ra}C@PEx꿨j̊!g\noa#()\\cRQS(";break;case"no":$g="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2\n86/˓69k[BC\"9C{f/23ą-\n.|Ѕ2(J'.#`!,1O5 R.4A l@,\nv\r΍ʀ:0/\0)lS2BC\$2A+z>P*\r)W0MLְZԎu>J@c%E4H	ht)`P\"Ms0`V(D1h{^(\r4\r7*HF2	#z0C0V\n :d:7cc06#Z9+c\nOjْ@\":M؏(CC\$\0Iɡ\"r1q!\0ПD4&Àxﻅ^-8^ڙAxDpO|ddbv89hAHx@88ctkjZMC򼽚mVٷnno_7p(|\$hWBzk7ܪc8ԝlc82J]ajt\\WK;GMXR\$3|\"ɢ#9=^CfZd:`̙ug\0:dØaE1WKs.%̦2@ِE	֯P	@hP((Ysst!.S2el4u_]4E@\"lOA}EH&/gT@npChA@(.Faklu\$oBS\nASO?0L#1-Kɉ>&ĒJ`od96RRd\"XFT7`T':sa1kҁAQ\02iwH(kE٥@f073P['e3QAhkKD3S~'N&3AY#x\"H]&\naD&L!;iP(#3z^j|%`E>TR1eС3H\"9ً_tJTz~\"V}:(oRlaiˣ /dz6I}Ɲ#TᆆPyC|	:3FM05:ָKERS0|MAԛ!b\\'y,qK<\"M#l\n}\riAJJQ&1	(X3pgT-(&pKU.QʻTFM|:Po&H2";break;case"pl":$g="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#H{80\"S4H6\r,Oc \$@[w804nhºkY\0cU'> ȓ1coS\r:ʎRPH iX P=[ bpc\n	J:H2]& PH#,P1ȱ{f6IIBS`+D]R)l6\\7^Ŵ߃A^\$I@	ht)`T&6P7څ&6@J@\0ŖE^9f88ߞJ\rʂN^3>\nq:i<ݔ%4PVSr1XʌA;X3#r)K:9wް2kJˮNö{.9X[~>@në(;c|.8qۊZ<*:&گI9pXv{_i\"	@BɻDS7Nc\r2D49Ax^;u?O`^Ѩӟ|ѯQ2|(j(!<uZSj=D=6	\$h 9AT!BP,Q=|O˾ts}2 σs*\0,K\rO%rrD.TY}G4(A	aA{ ̼10p5!\0	T\r07\rISa30a:ǵtl2I5fDD([|\$L\rm`f]pD,%Δ P\\@Ă\r'bQ/1 4r9EP!̰5:YvA#-4o47F@- oqsൠLB\r9@|R`0\"1\r)@CT aL)hFA0\0l'^:tȑ@k?	IǹBrN?D)\$.h;ӞIJ!W\\iF&&~@}))MaNe7IIIz\$A̖m+u7%\$&Jr)U^l\r'Fغ!A:CUj\"bHS\n!1\nQù*0. #@إ\"Jp:R\0PR2(HJP#4<kt-[N5B|Cɲr&ćjԺoV/u㻯)dA6i6UH\"uEN@Q)t`bm}*rLQl/9(BF^{u˶aۤL}	*q%Nl!)1j\"ޙPMdbGP|כ\ny)e!7ےH \nK*XӉ!4Ƣz_o0PxzgwWb'.DFxګ\0=GR#-`uU&G[0cq=G=\\\"i	&\"VE&";break;case"pt":$g="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%ln1/=mp\"m1A8#2J%\r;J0딂2ir'\r3.2!-1M!(؁OxHA(&BC6V8@6\rr'S;&=H ͈\0׌kjx4b\$ #r(JVS=%	TlӴ0ڍҕI3Ȑ\$Bh\nb2x6Å\"2ٮkHR2\\C8ҹvsX\rѴd73o'II6k&;ޠ'@êM^.XَZUx?Lht2S).[loirӿ\rp#&% A430z\r8a^]pp\n3@^/.{AHܼ^0F˫k|5c\$TmA\nX+lq#2;|B7t#Igu\n|\$_'9wap\r0p8HjzJ8[M!6&¡3 a	1#Ө@3m55ڨ ݠs꓈+̀62r,eB1dd Q	7ClH\n5(AP\$#@\$ս95fj1M?H0+u	 (H0 k2B']@<co'!0)N	º.I\0\0((49A(e! sHmNDBbר C\r#eS'\$H\ndgU^CD؁8;OcW}XP	L*\"4%]`3i\$]ԅ|O	9MSi-`՚k:]cW؁Q	j20TdLX`f9D~ĔN)ɠ~&)4N:\rhJ_ٛ!1\\i<Uzx`+A\\bb3+[ұ'NXkߊAiPh8\$ṸN)RfH,MI4\\\rNG-EX 'F6#b0y`l@·2s]BjQ\n=35v^]C:^a,'07Ze6P9b閔TlZ9שk#bŊDQ,*Y<De`b6*ً).Kɲf`;KR,Y\\\$&";break;case"pt-br":$g="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR43Ґ 30\nD%\r:kCj=p3C!0J\nC,|+/╪r\00e;\nت,><\ni[\\͉zz7M*07JA(C4ہC@A jPBN10I\r	|Њ2G3j`Pjz4o` c4`(P)k)N\r\rJT%H]NR\rysK#=	@t&Ц)C h^-8h.\r:#&)W5DXec>\"c5Mb^\r09ю2.U͊z1.:hRF3MsCab\n9h\r.h0P9.4VC#LzsxC83ɮ!zd`-kF3:xǅ!ar3X^*A8=!^0F¬5:!\ré:l@.s2\"k&'\n7\\G/|o;<̏FOτJ|\$k7QpR㦆5ʔE'Cnp&aբzM=ŭ&h;1ց)1xfx9prk0a}q	yFLhFlˬ0D\"@PA@D0PVI*,2BXI1('!(*zM 6k@)xnA	\\t ;bw!8TR0\ngp:\r04xN\"9@Iq\\)bTi9\n'PD}\"\nEDr5JS^#0CܘH׸I\"բB+~5lY٧!\rټD<`\$BO\naQ%\$|OY;#*d85P	2DJ6LFT˲\$;7\$\0άSbn3LڹrT1@LCq-@J'\\DþC4ښ!ȓ5y>\r#+4s#kI7RT/os!@'Ӆ&iF!:ER'y.u{3\\\r*؋vW/dj'!>`Y\nP#pْnuYK:QW)ߖ2ENM2CΖ\r)\$ERf:ؕho2A<Ps!N.ՍUw=ԩԦh\0k:N%YlJj:(W\"NT-(ޘvlQ\n\rCa.qF/Iu#sM?R6)K-c!OH@&GсLBC鬘1d`Mŭ1Ř{cȸEjU@";break;case"ro":$g="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2l1	C0LK0q6%3̎AA2Sbn,93`3pʁ3@+ﴡ(\r\0CʰA@PH gh P5j,;[O:@CZ	a:\"ޘMw]\r)CJ\"'(VtHO\"8ȦTp(lت+x\"\n63ab/px*h\$	К&B86\"y=舦i¥`+՞VhK9أum3bgcw4	(\"bBV#d9c26UoYm\rY8RšeKO+	A\nv0K*^9onzëX4<0z\r8a^\\)/8_Y/xDxLR3xrJD(|GC'1[3C,0,]l*J9WDLu/TsvN;>\r<#ƝR%7T@ki@ޯ	\rdpW+#Cu&O\\^qlL%W`C&N9tf~97FMgF1\0NJO~\r2:jof(¤2FÐALG`.ARpX+\$S|r8䡲8w<.J+#K\"*(xH!~HsAD!N<Ta')  azH4&&)BtIIC(%Jj\\)~rKY`g  .M\r*GAN<:\"Zw\$++79(>ҰCQC\n<)Hb=nF@K#\$.YLĨ贿%-*\"A,	o)KL+h5\0)7V4'-\0ly\"YJ\nl1hÐs,XUVS=U5gUٴ|	l.lI.%qbW4LbfH,)WY\n^a\0@okJS=cl\n2V\"1\nP#p=>b)܊1LRCS\$I d=(I2rv	\0003`V\reFm<)Z@Q3Kh+ZGhY.(rGwG(Jc(p\0\0v.ڍWUJS_m:j+j+G=asMHL,LEd]WLEi\"CQg݅L@ރ1\$";break;case"ru":$g="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$ٶj4y>N:D.1ܧ\r=T>+h<F.\"]-1d\nþ\\,3:Mbd5N(+2JUC%G#\nT,`#HkΖŵJLjm})TʣU%cĻ7\$qNˀ8N\$@#\$_̓W(mԌlq/8u\\Y(\\75-Zt9DY.Bh5C%A jpB8GexZ,rhA	7<2AM-XaΖȲ<|VAuhHj)hc*dR7yKZH})YWkVR_O¯p(c%,\"q!A;jr6+Če8th)\$w\0(>Zwd-E.șfH0C`ʸa\09(zǵ.^:{Ø7ÛШ5\06WPoxhГG4qQP\r4^:b&&NB> ]?,m/+\\\$da9\$bø-t>=KaZaiah@T6jb8py	%T`yНt1XTxaaE!fa	%XxSyDH,UDe,@bHMИĮh\rK\\#̡%T d1.\rlv`&0hi\r9`ZGDY=8@r p`3paV{p/@H)6JW|T*#`\"vM	^u+E3)bURRT*!`p?A^8m_L	1&4șS2gM	*eXrlMLEr/2SS}]w@iĮl)#2<bAr5IDy`4eO>REēAQUq=8)J)bvJj;\n%qWԊTީK[bTI:ՙxȀ>iƪVnSuI h6\n\$PP\\Iu\$~Q݃覭<EQ\0~BbF@B84&hsd59s.Njyn\")GYCCS@U2R%%Xk=*rIHe%H(BWY	>*AHJYA>mBKd\n_+bbŞ67w<.a(6Qa1vL't}ID*	)DMЃr\$DhCPv4\r{m@((²&< >LEC<\"XԦcw`V>OTUlZ`a!\rKP!n+sؑ\$\n͠rnH/XQ	Ry\0F\nA]v/zt\$\nA!Q.K]'%1䡵Eo;z+s,MRrFB=+	/AWMw?{qQe{Z_W[&\rV4MXqDrE\\L#eu	\rQ>&C苾\r\n3XB00 \nSUiC^R rdt9{d^8q.w_j:2uKűB*.}o~VeoA}oԏs.ҪW)^(ڗ'aeyujxڹƒh,((%\0@0_,!w		/wD{e\\L=GZ_@fˌ4ɐ1]9\\gvE*3\0*16&žCD{%)b7lU\nm/\0/hK^LD<dN%Ked[Ɗ܊Eԕ:))颚jRjZ  `{`Ȧ`服j͏\"6^9M@x";break;case"sk":$g="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"iH0{TףC8@ØH\0oڞ>dz=\n1H5*j+P2`2I5eKX<b6 P+P,@P)`2h:3 Pʃu%4D999 ֎@PHElP\$2=;&9ʢ䍒HA:ӥ7EsM* @1 VYՀ֎PMpHX4'\rc\$^7-AJBb]AB=ʢ)Y(ZP,FRQ,:RO@4Iz*1n#wm\\2c\n>849Onಞa3]\0씶I(G	К&BC#h\\-B2Kڰ	c\"Β)fCu,7M=&cl6MS:`3ؚ0wҕ*\r7!\0~9c06	`弌#>.ںP9)NPs2C,쐎H?\rX̪3ɣjMH2D49Ax^;r?r&3_cӬ}@8x!{&O05+9JIYY?}\npp\r!@Ax伷ދ.U뽐CUj||Chp'	7GZZ\rl7`bSb^xy(ԛALOOy\0G#aׇ\$ԫfe=(opYAYHj-(Z^b22쾙xOT\0''Z`bdB)2d\0\0G@PCk`1g\r_Ѧ#Ԫ\"\rYA8\0@S?Ց` r!8P`#ʸ;FL;U̦0C))M0kC\naH#@xX#PGrIKGj؜OY-%ż:c16'V7*\nq)	\$,<陵'*bK(CA\0!l'1̐ x,CEV3ObHIA@'0\"-ApI*f[iIEAS=U:\$6D[גpUysL(AUQ\"*q.\nZ4ުcAUnvC e\rX2ET85p:00\"vMN\$Z*dQ}\$;B%!\r6Vؙ)ZqMO\$~,2D#JAӘG*@AEdl^dl%ZXb	Yyo8akץ(Sxl%PrQ0E\01\$HtVnfI`\$i8גSc܏\$+CSto\$h:tFFZ(ç8m\"h!%\\n_9M%R4++ɒIIVg(1&Vʅ^5e*%A,3c,	 *JHC4(NF\r*,>8𦲂";break;case"sl":$g="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!\"l;*1~25P4L2R@P()ϐ*5R<|h'\r2Xb:!-C4M5\$pACR<@R\\b:J5Òx8K:BdF (Γ/(Z6#J'PK<@-ghZ-`M6!i\r[6݄[l[V4M\rx\\\0엏I@	@t&Ц)Po[.K(â[/\r3h5\n>B9d8ߖN<6d1Ld2t5Rh#;\$MXpe,c:@T0h]:!@ᡔ(^*1+63d[4\nAC_P@&`3:xͅͶ{\$x^:Rxf)%\0\\@7Vdik\0V/]Ơ%r5sЎ]J2p~\\7uj@|\$/%çc4	`Q	!=M5Da\\J܌&I	2J\r7Uh A1Y.97Рa05&՚ZfE\rs),2CId!Sz}\r\n\"I(x!\$\$!tH\n\0RGI2w^yPΐs,f?lҟp@G\0wP\r\rSffKѐ\"A?A\nsH4MI(qCqK)D%8JiaL)gvκ4P6Ab`L(P%dc7<40ݹ>DgxOCb^Hy1d4B~zԂff=qQ@c\$Sf[j\\.EC7\n<)Gvhj:V^K@\"LW#4v9H,!q63Gx\0S\n!0e@7R-(?3%4Lm/J	}e!n*&;rzʔéU	@(\"F?Br%O2\0WP}_\\E}5+93.PbՠEXkUI3\nY:\rfԜOu7,KPh8dn^#NƘjBBq	kձ\$6*m*Xʿ/lan\n#lw^gvM5	K!&0TF]ohY%\0x9\$ W\\**vy\$Rg)'IH~4(cqiX@]M`;kn!I\\p0A\0Y !4Kn(ITv!{d=\r	į8\0";break;case"sr":$g="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\ne3jڱt6]*Ъ_>\rR)Jt@.)!?W35PhLSNk@[J2 Ά7=Ң̷m^	{̒K\"\\wbo\\3ϲJ	%OjC6mֹ 83j¬c:ϵHJt*HOKu擶֔11v(Cj˫ (\"]45,/+ j^Y~yĈ\"֨ƋBlȎ(I:ZB@	ht)`P&\rh\\-<h.Y5dPX@^7sAt(Ø7Z+-P:Mv#70	\nNHg-7h7!\0֎c06`3CX^30A]l\$:@׉|Cj-i(AP\"uuLr0|:Ȍ\0<&`z@t9^ü)Dh8/H|4@d\$/ t4ȉ\",qDL[#U|o-d2RIꄬQG\$\$Pp\r.&A6 0xR\\-09Cg\\3u\"Hm,60b94tA\rg4d`n5by\"̘,E:d8O\"ciP )#R5t{y>'ȋ:0#A\0c84YC10:FD)lť֞aTtP@@PѫNޡqP%҄݄CrQ\" s?H3z7\0}>\r4z.;2p7IIs0&CHg cM\nxȱDBS\nA)K\\ȸTHbEJiJ#)dֆAQ ƹt=t]%Piӊ 8dJ¶]m5\0HC˻t4t;G=sfFAǨ1Lpc|Hmsk1)ADO¤rpAUvѨ\"e&k&ORY5JUJp5JȢڷ&?\$7!7D )5&\r`@\r2)\"Ch08ܢZ*Wn	.NDCiEaqnڹ]kaQ0?uXVdw#hqŨ'c݌mw\$.ovb-y~l\nH5Ph8tpRɡ2l!9*bڱ^T\r:%j|&J+s-eR*1l&OȬ_3][k,h3LZYXG\"L++SlI3tzƮDj=\\Zu)nrhoacUX<ZMh;FUz	QvHf*ۉogauV!L2FԝJ\0\r,=0f4s->[PI\"OAAWWD!~";break;case"sv":$g="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5Nu)ɝH'o2&60#rB\"0ʚ~R<9(A02^7*Z0nH9<<P9Bp6mv֍/8Cb*ҋ3B6'R:608܎-\"343N+EL6P*((!cl@\"+/\0JC>a\n`P(Ztjo#1Ԅ)!<Isd(茔e&\"ɀ#D,ҀM-N#:cH5tH^\$P#4vmЅDjZ̝m\r6h>:@t&Ц)C<ZUtJ`@h4,aH@0D\"`Ң:)5r3%\"!uߍ##3\0ڍ2>9;t̘XÒ[)+r6 ڎWiy}v\$։,hFN柨W| eޕ\0;\r8h	0 \"9h	ïBHD44Cxх(8^ ޡ'x^w0xeܨ84|@Ai۴@:è͵-ऩ+ks8:sEtP9u]`<#~7vj`|\$cr؛@Դ@\\347|7cpE)4V*̥tJ54	@v|Z\\3Iݕs6/<pZ\r0Ⱦ{1\$@@P!6ZH0t>XRHHVņhx21 s2fIh.cX~Q|:\"Խ\"xJ?gLQZ@LC\"6)8%@RL7f%&9*yc8vz43R=XHr-(5UBiƬ[&M{Pon\00fX%\r,9 I2AO1PkQ4\n<)E|1ӈ@H݁])3b\r'5ԍ[DY6\n!0fHF\nAMD\r%x2B*joQ&@O17@@C!Ē̶cy3\$ OL?mUCM#\r5EXxOP%)\"a8iT*J0qGJ*v\n&Iau^Օa㥉A̚#)WEד!*	!_3p(rB	Cָ3|5zY: F*uSRJN,AJTHa:Xp\n\nȚs/*\nmH]A[͝iXZ\nOp";break;case"ta":$g="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-@Z6|YL\"#s*M/YC)JiWPj_P*#D\$c)IJ6a+%].Im|\"ڣGZh]XlTґqUhJ2FWfF;~`-sdO xH[;d园#y=0_\rͱP!^ YqR˫_o-\\Pšklx\$1s+ů5u/=}mnB7vGmw]Rząۯ)~Cܷq۞,nC6zP5ts@PH	\0&t\nyA.\"mq'|Rf\rд)b*R*#ȋs`,mݭز\0Q;9 0lI0\"-% k3g5a1x(m!<\0ꨃcg9`C 9ha\$	\n݃jH0S]%\$W9qH3EB\$oDFcOf!Q@C\$\rɞ?5J\"g\00\"\r:\0x/,Ydrjä=Ms8< b-,,uȬrbM_9}˰\\K{Jhٮ@UÔJ+58pyM\0T_1f<əaf\rRCK6\0>	&1P'<!TNRm{,}PA^\n6U( <#<LUCr<GZ񬄀0P@;!69 B`nr{D!SfTo	h\n\n (%*dL؁\\ޛ,SzOY= |vO0{X\$M^42e?57	DPU0OHg`X#) R\rUxNhiZ03>Ty4s8JjVJ+CcfדU̕!@PilD#\nBx;F+R)\r,@;8yb9ap(Ә/]9x:vSq\"-Ȳaق&+\$ in<'P:HmYCCN6\np!gdxh%(\n<)Lm|aG#NQ+bJ@&|U1gD@3H\n%nפ:)ZsMgΠE(ІX§k/PJE1^@Lzm4t!~q\$vh%&F]m:_D_=DE`fl1&hf5;fXypFmu}m@(psޒ*Ͼ8^_M5^cUC˕JN;(@ly40+L36yOHfkO%bx*@A2م\$;75Wihpzq'bO-qViASmRzA];;([s3@X\0ݣ0oAZD	JDLA7u'fhy٢w/=CfTM\r%n@y(^07ۍ^B? -n/uUL@U\n	Ԝwi,lLH6g \n4f2JGOZD\$ʣZӋ^y\0\0ʬIh>{bfnL2Mo  \"1`{&/|<D't00eg0";break;case"th":$g="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NTE^m0A\rnB,]*;\\IwB9X\\5o}aS{X,B ֈg%'幋\"PӃ,Ŋg(+v\$#\"LCIr/A j(bw;D4`Zb`\\il|ʙ[:,d0jvʫ8gN\\gNuTq1ij]GՠeSU_tSH\$	К&BxI)cP^-ej.yz%vxıB\$?5@Shn?(x@9yTAQ=A90lJPH֚pi\0ih܅@|ha\rXCc?3P`oT9a*	[PmJ\nP{IN3~	Y(i27yX\n4\0\rJ HtNp>Da=pt3Dt^.1\$xe\r=@ \"ҕ%Pxa`)9P[;LEdHlE:.HƦЋSE1ae\rE0SnJMN`Rm4\"\$Ph:HI))%wRr@I(%R^@>	!8(Opڏ !\ǹ\rsPsVʝ*\\ A-fA)x ##twT7@S~\"xe3@(\0A\0c 4دݩ:G=\r<p\\RS꬝ef*`[+2A\0P	@\nUK.\nw&zqˤRW}?A(0	ODe)ZnE5\rl@T7|:M;(i@Sj{a0MapVr03kcI\"GM^</Y4XAo\\.tc܉]e&K[oqŅNa]-Y;n~a6NVD.iu|VI%'@ڏO Cu?3'\0'i1ĔS,҆?h>\"ۼ!eq)V=e\$\\cL0\nU\$|\0mi!BQ.y\n¦:ciũ\\UfP|)pSb2lHn8Q	3Y @}PF\n6A\$VĘ@&ܜH8ϥ[\$!6@tqY	|l2I7FTVYYivM`{K45-1WWCHc\ryL3**emҰm)EP0-AdV\"k;i5LiRNn=ֻ W_	A[zpA3(&η.!8(Ȝ8WD7LqˍYS<dKf9̾i>9\":X	:S\nrnWv\r,l1X_\r#W՛&yk꾔)PG#	͈+7jrWwA6.	G	]85򮼡9^2P[%\n";break;case"tr":$g="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`H<4m @3m1Q<,EE(AC|#BJĦ.83X8qbԄ\"lL?-Jlb鄁\\xc!`P#떠&\r(R2kZld#b8#b=htWc 	PSXu	xeK-Jbt\"戋c<h08\nz!VƵJ\rp<Cri=IX6I`QC2'*|9иc:\rx͉\00PH@7c܌,x\rÄ6e\"8H֋nC[M\$~k,9;z\"N {MFGL%2c\\ZY-x3:xǅ~ԏ(!zg~KA׸+*0ח+\"ȇxk:r9Ź5X\r3CڎM6Amwv2(sTy,6o?x()sw1&8?(>@E0F]Bm\0Y#0s>qYlG|XBLI\"w	5JxlK'l\$]AE;Ce14.CN9%ΑBd\\E\$UK>\rD@P9Uj@AE/L)S\nqP*EP66pleq?4-ϑ1%F'г\" H9n\r\n̟~̙ aE T??u.(ku=&tB\0(aL)h{9\$;D! luBOLxO(GAQ>>s#P\rɇ NV:Pӌh<^嗺~xn\$*^P	L*>AjM:ʉ@F	EhG)BA<vEPQt\nk6RB0TS\n3 ABSaL(vR\$%dde=50k!8uR\"I1\"@)HEUVS95u\0斢,+-f3Y[rxġlTהkM~\"wg%4\\O/\$4T!0Kc6}jyyUc5-uY~UGI{_9[#h=%).)|[n 3n/40D\nseL=PYTTc?c-۫Z{Uް*XoY5FUg]:d'[rR2pU.r";break;case"uk":$g="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвH)Lxݦ(kfBK{))ƯFHm\\F \$jH!d*B郴՗.C\$.)D\nlb9kjķ\\̐ʾD\rZ\rqd隅1#D&?l&@1M1\\`hr@:,΢[\nC*(m,rLJ4\"윴GUN/;s?Ks3BcH(Ȃ4^~r}Mt%İpH\r^2[\$CkJVGA\\D[sPבBXƍh65҄ԩ\$cїW(WF-^&+BX{71pR:ڒ;-(lNɳmNzŷUGH-r4iV&/#d\n4s^v@sm1	\$X4c6@7A\07u݇evC(:v7MMtZ6lrt^y=`=˖:Z7_>Vh\\T2b`\$+jx\\dfA\$;5`B&)a|J/GLڋ&/'KYЧ%p^m}' %@L`[jaA93t]8'\$9l%>\0TI`3yHSN6.Y7E\0Q|mJMkԪqQL2(rL t<\$0\0(f4@:;P\\cw p^xdx:<0>!eĺx>zxhq.2EM1G(`ke2esPJSYb_T,D֣Ձ\\7ʎJmi`Ēx\"v7BHi\"dJJIi1rOJ|,UbQNry\"W	O5>Q9X,8DCGaԩzeY͓2X\rRA1b1^/Ľ VPrlϬ=G|@oNf`GJ|[>q|dzrXEUcUKZ73a<fJ97-:->S\"Ag4QT\\\":e[PnEĵeJ5͐QsMv)%>^}k\"vKX-ɦBEBY'.Dc\$^3\"JlT:6r:iAuIJ01iV]\n1tWI覩MQrqb0.nC<Y7ީYbcr	!u&GêUd5aBUK8%=۶XaѦ+Sg{nCDCxA/N|G{l!<6gQw6hp*rėQ@xS\n_˪t.ck>xU%|&̗2#8JC%2TC9<GDab<H	8KbH6Eo)z.\0S\n!0Bd!\0B0T\n=HeP>ڑ\nq{/u=oXP:J\r˚dG>!%Uj[#XPiNɼkX1XT-r\rul<CyX3P3lڻ<-҂,+Oo̵.,@@BFD@nк֤GG@`g\\.;peoi7qˎfV{	OAh7_&sri/!t7DT),89JN\$BaJ-3v1Τ;'xj}ɱs	a\0Clgz!q5wTg-M:6qPZu-n%peaԳS#B5>Ҳ*i'uR4#4jPq&ъ3e0";break;case"vi":$g="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤH(\";mh#CJV %h>%*l΢m)	RܘA,\rE*iH\$@70C:@LpѪ PH gdXn	~/E,1LaM]@u*pM	\n,<ĎS'HAycdGtJpSS5eC#ur܄8(Bv	К&Bc\\<h6 ʲ\"\r16@j@@csGz8妌x7cLQgf9C@6-\0P7C06;c*]635]Pe'AA?8xV\rhX\"̎\\jUAe72\n]H@Υ@몮61H4l0z\r8a^\\0\\x7\$PD{P^0p!@Jjw HP~:q̪TD\nЭSuM uPR%W^[yD;7Oeڪ(z0&O6Ihga0-sht.D4)%@ 6Áv!6UrC2i:0C0u7	4@h.Vs!BBEThw=nH\ni<%3HD7.!O}rN\0NDy͠PB\nq;X}(ap@v㔿\r:\$~bh6ڴI:e03\r/ dJs\$(34Ыi ,jHh*p 0F9]-I\0'K'{JEI? 6gy@\$[!w\$.;g5ctݳ\r<@FUx!CTp!Ɠ&\\g8\"hf	9'gb- Ra+x(qD@dwIѡPԨY #D#I&sL9t1aBD1=Zimu'}ٙ7:'<	u6R	sE?h_zbU#:)H C-Z-W_ӈ-	^Y2>5-7б1)M@0-!Z	OY2uYxDH ɳ,zn8\nEKXuVp<\0r\"/u_򆕫&\\p؋3eڳuiguY4li-0w-Hr2I:av#UرaE.n[ւ'tF**ʼD\$o45{lN";break;case"zh":$g="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3Wq*'Os%dbʯC9Mnr;NP)Z'1T*J;)nY59XS#%Ans%O-30*\\OĹlt0]6r^-8\0J|r\nÑ)Vl)2@Q)nK+)3'<(M]Qsš ARLI SA b8sN]\"^9zW%s]AɱEtIE1jIW)i:R9TQ5L	^y#XM!,5xBm@?G\n\$	К&Bc<p6 Vi==)M80DWXDTAK`P:Ijs]!tC1E29D6I!btX1HdzW5DI\$qCey*ƑVOtƐXP# 4(?A\0A\"DyvV@4C(C@:t;ɳx3(x0O,ADYb%	jtDxxM:mD/F{F6U3peNǲ\\oc(:rC5ɄJ8|ai+xq,\\ř*Aqs.D(Y\r\nQPat^'O>4VA\$j(\"q\"V\"^@CM#	ȄJ`ż4PP.0ƙ8[.\nA\0P	AC`Xte׼R4`73xsJ/qV+h1	3\nO?g,pxK8GP^,hr@cL2.\0!0'jZr֞^@0(M:CWTyJ?ÔQ	V(s	8c鐇\$2ړm\0sh,AWRiW\n<)FzY1DY4#_--e\n\"N\$H^I wC`!BaL'ƾbNR|8(mlE\$16% TpY`PH-)#^,%b9`^a0C>\$\r_fiq(LaD\";T*`Zh*4`q#Y\"P\\2T!iC@CL\\\nKfmb*!^wB\r@:y3Lu	oh_%\"\\LI-\"\0'/R=l\"0urH*	3ƭqN	i*6)%(()ү0=WR,";break;case"zh-tw":$g="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ]EJ4\$yhr2^?[eCr^[#k֑g1')T'9jB)#,%')n䪪hVd=Oa@IBOs¦KJ12A\$&8mQdlYr%\0JԀD&Hi8)^r*\\gA2@1Dvi`\\>-1IACer2:@ĶHPH gRi N(k]g1Gʇ9{Iq\$Rzq|@_sZH\$kWα|C9T.'%!CItW\\BJ(d\rieGʲ\$	К&Bc<p6 c\$(L@(@sJʕ5CDB6\r˕I6Q0D]̱^K8tR2.#r	@4Dwt\n|F\$9t%4ND'VC]9Oa:F@2\rH2ZƴאB6D-i\"!\090z\r8a^\\0\0\rp^2\rp:\r=^1H4ED^K<G(a|B9}ݮz\$pPVFE[^Ԑr)s9tIQupnz|8\"U<L%W	2F	c,k([d'Hi\0UC8DxAM! q	LhM4&Ć{)D(^.@\"2\0u1S|H!bj@XqMJT+OhV+\09g^5Tk\r\0bs)#=D[(d0M\0C\naH#\0[0\r2/\rQ1/ÔK\n-T%ę`9pHᲔX'\$9A5 839DPDS!'3,͗Q/{>ˁ\0LPP\"	%M#<'E\n<)@@\n\0(ap&h/Ŏ	dod؛L2!ZAAiϊ^|\0{A*vHG,)N\r9'\nH,?x+@@\r)1*9HKITIͪm@J\ru[R&}	/cxF\0#2\r.9?5M)C+DrETa\nP#pqP9]g@5ț)#M:y\0J|&J@51=CڜptN<:=WD\$\"ׯ*Vb(*\0)Bsâ\nhrW8:#bYE{Sz%^̪ifL+2(#";break;}$wg=array();foreach(explode("\n",lzw_decompress($g))as$X)$wg[]=(strpos($X,"\t")?explode("\t",$X):$X);return$wg;}if(!$wg){$wg=get_translations($ba);$_SESSION["translations"]=$wg;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$Me=array_search("SQL",$b->operators);if($Me!==false)unset($b->operators[$Me]);}function
dsn($Pb,$V,$E,$C=array()){$C[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$C[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($Pb,$V,$E,$C);}catch(Exception$ec){auth_error(h($ec->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($P){return$this->pdo->quote($P);}function
query($F,$Dg=false){$G=$this->pdo->query($F);$this->error="";if(!$G){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($G);return$G;}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result($G=null){if(!$G){$G=$this->_result;if(!$G)return
false;}if($G->columnCount()){$G->num_rows=$G->rowCount();return$G;}$this->affected_rows=$G->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($F,$o=0){$G=$this->query($F);if(!$G)return
false;$I=$G->fetch();return$I[$o];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$I=(object)$this->getColumnMeta($this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=(in_array("blob",(array)$I->flags)?63:0);return$I;}}}$Mb=array();function
add_driver($t,$B){global$Mb;$Mb[$t]=$B;}class
Min_SQL{var$_conn;function
__construct($h){$this->_conn=$h;}function
select($Q,$K,$Z,$Jc,$se=array(),$z=1,$D=0,$Re=false){global$b,$x;$pd=(count($Jc)<count($K));$F=$b->selectQueryBuild($K,$Z,$Jc,$se,$z,$D);if(!$F)$F="SELECT".limit(($_GET["page"]!="last"&&$z!=""&&$Jc&&$pd&&$x=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$K)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($Jc&&$pd?"\nGROUP BY ".implode(", ",$Jc):"").($se?"\nORDER BY ".implode(", ",$se):""),($z!=""?+$z:null),($D?$z*$D:0),"\n");$Qf=microtime(true);$H=$this->_conn->query($F);if($Re)echo$b->selectQuery($F,$Qf,!$H);return$H;}function
delete($Q,$Ye,$z=0){$F="FROM ".table($Q);return
queries("DELETE".($z?limit1($Q,$F,$Ye):" $F$Ye"));}function
update($Q,$N,$Ye,$z=0,$L="\n"){$Rg=array();foreach($N
as$y=>$X)$Rg[]="$y = $X";$F=table($Q)." SET$L".implode(",$L",$Rg);return
queries("UPDATE".($z?limit1($Q,$F,$Ye,$L):" $F$Ye"));}function
insert($Q,$N){return
queries("INSERT INTO ".table($Q).($N?" (".implode(", ",array_keys($N)).")\nVALUES (".implode(", ",$N).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$J,$Pe){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($F,$kg){}function
convertSearch($u,$X,$o){return$u;}function
value($X,$o){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$o):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($rf){return
q($rf);}function
warnings(){return'';}function
tableHelp($B){}}$Mb["sqlite"]="SQLite 3";$Mb["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($q){$this->_link=new
SQLite3($q);$Tg=$this->_link->version();$this->server_info=$Tg["versionString"];}function
query($F){$G=@$this->_link->query($F);$this->error="";if(!$G){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($G->numColumns())return
new
Min_Result($G);$this->affected_rows=$this->_link->changes();return
true;}function
quote($P){return(is_utf8($P)?"'".$this->_link->escapeString($P)."'":"x'".reset(unpack('H*',$P))."'");}function
store_result(){return$this->_result;}function
result($F,$o=0){$G=$this->query($F);if(!is_object($G))return
false;$I=$G->_result->fetchArray();return$I[$o];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($G){$this->_result=$G;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$e=$this->_offset++;$T=$this->_result->columnType($e);return(object)array("name"=>$this->_result->columnName($e),"type"=>$T,"charsetnr"=>($T==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($q){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($q);}function
query($F,$Dg=false){$Vd=($Dg?"unbufferedQuery":"query");$G=@$this->_link->$Vd($F,SQLITE_BOTH,$n);$this->error="";if(!$G){$this->error=$n;return
false;}elseif($G===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($G);}function
quote($P){return"'".sqlite_escape_string($P)."'";}function
store_result(){return$this->_result;}function
result($F,$o=0){$G=$this->query($F);if(!is_object($G))return
false;$I=$G->_result->fetch();return$I[$o];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($G){$this->_result=$G;if(method_exists($G,'numRows'))$this->num_rows=$G->numRows();}function
fetch_assoc(){$I=$this->_result->fetch(SQLITE_ASSOC);if(!$I)return
false;$H=array();foreach($I
as$y=>$X)$H[idf_unescape($y)]=$X;return$H;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$B=$this->_result->fieldName($this->_offset++);$He='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($He\\.)?$He\$~",$B,$A)){$Q=($A[3]!=""?$A[3]:idf_unescape($A[2]));$B=($A[5]!=""?$A[5]:idf_unescape($A[4]));}return(object)array("name"=>$B,"orgname"=>$B,"orgtable"=>$Q,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($q){$this->dsn(DRIVER.":$q","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($q){if(is_readable($q)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$q)?$q:dirname($_SERVER["SCRIPT_FILENAME"])."/$q")." AS a")){parent::__construct($q);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($F){return$this->_result=$this->query($F);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$J,$Pe){$Rg=array();foreach($J
as$N)$Rg[]="(".implode(", ",$N).")";return
queries("REPLACE INTO ".table($Q)." (".implode(", ",array_keys(reset($J))).") VALUES\n".implode(",\n",$Rg));}function
tableHelp($B){if($B=="sqlite_sequence")return"fileformat2.html#seqtab";if($B=="sqlite_master")return"fileformat2.html#$B";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;list(,,$E)=$b->credentials();if($E!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($F,$Z,$z,$he=0,$L=" "){return" $F$Z".($z!==null?$L."LIMIT $z".($he?" OFFSET $he":""):"");}function
limit1($Q,$F,$Z,$L="\n"){global$h;return(preg_match('~^INTO~',$F)||$h->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($F,$Z,1,0,$L):" $F WHERE rowid = (SELECT rowid FROM ".table($Q).$Z.$L."LIMIT 1)");}function
db_collation($l,$bb){global$h;return$h->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($k){return
array();}function
table_status($B=""){global$h;$H=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$I){$I["Rows"]=$h->result("SELECT COUNT(*) FROM ".idf_escape($I["Name"]));$H[$I["Name"]]=$I;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$I)$H[$I["name"]]["Auto_increment"]=$I["seq"];return($B!=""?$H[$B]:$H);}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){global$h;return!$h->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($Q){global$h;$H=array();$Pe="";foreach(get_rows("PRAGMA table_info(".table($Q).")")as$I){$B=$I["name"];$T=strtolower($I["type"]);$Db=$I["dflt_value"];$H[$B]=array("field"=>$B,"type"=>(preg_match('~int~i',$T)?"integer":(preg_match('~char|clob|text~i',$T)?"text":(preg_match('~blob~i',$T)?"blob":(preg_match('~real|floa|doub~i',$T)?"real":"numeric")))),"full_type"=>$T,"default"=>(preg_match("~'(.*)'~",$Db,$A)?str_replace("''","'",$A[1]):($Db=="NULL"?null:$Db)),"null"=>!$I["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$I["pk"],);if($I["pk"]){if($Pe!="")$H[$Pe]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$T))$H[$B]["auto_increment"]=true;$Pe=$B;}}$Nf=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Nf,$Nd,PREG_SET_ORDER);foreach($Nd
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($H[$B])$H[$B]["collation"]=trim($A[3],"'");}return$H;}function
indexes($Q,$i=null){global$h;if(!is_object($i))$i=$h;$H=array();$Nf=$i->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Nf,$A)){$H[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$Nd,PREG_SET_ORDER);foreach($Nd
as$A){$H[""]["columns"][]=idf_unescape($A[2]).$A[4];$H[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$H){foreach(fields($Q)as$B=>$o){if($o["primary"])$H[""]=array("type"=>"PRIMARY","columns"=>array($B),"lengths"=>array(),"descs"=>array(null));}}$Of=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($Q),$i);foreach(get_rows("PRAGMA index_list(".table($Q).")",$i)as$I){$B=$I["name"];$v=array("type"=>($I["unique"]?"UNIQUE":"INDEX"));$v["lengths"]=array();$v["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($B).")",$i)as$qf){$v["columns"][]=$qf["name"];$v["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($B).' ON '.idf_escape($Q),'~').' \((.*)\)$~i',$Of[$B],$ef)){preg_match_all('/("[^"]*+")+( DESC)?/',$ef[2],$Nd);foreach($Nd[2]as$y=>$X){if($X)$v["descs"][$y]='1';}}if(!$H[""]||$v["type"]!="UNIQUE"||$v["columns"]!=$H[""]["columns"]||$v["descs"]!=$H[""]["descs"]||!preg_match("~^sqlite_~",$B))$H[$B]=$v;}return$H;}function
foreign_keys($Q){$H=array();foreach(get_rows("PRAGMA foreign_key_list(".table($Q).")")as$I){$Cc=&$H[$I["id"]];if(!$Cc)$Cc=$I;$Cc["source"][]=$I["from"];$Cc["target"][]=$I["to"];}return$H;}function
view($B){global$h;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$h->result("SELECT sql FROM sqlite_master WHERE name = ".q($B))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($l){return
false;}function
error(){global$h;return
h($h->error);}function
check_sqlite_name($B){global$h;$kc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($kc)\$~",$B)){$h->error=lang(23,str_replace("|",", ",$kc));return
false;}return
true;}function
create_database($l,$d){global$h;if(file_exists($l)){$h->error=lang(24);return
false;}if(!check_sqlite_name($l))return
false;try{$_=new
Min_SQLite($l);}catch(Exception$ec){$h->error=$ec->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($k){global$h;$h->__construct(":memory:");foreach($k
as$l){if(!@unlink($l)){$h->error=lang(24);return
false;}}return
true;}function
rename_database($B,$d){global$h;if(!check_sqlite_name($B))return
false;$h->__construct(":memory:");$h->error=lang(24);return@rename(DB,$B);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){global$h;$Ng=($Q==""||$_c);foreach($p
as$o){if($o[0]!=""||!$o[1]||$o[2]){$Ng=true;break;}}$c=array();$xe=array();foreach($p
as$o){if($o[1]){$c[]=($Ng?$o[1]:"ADD ".implode($o[1]));if($o[0]!="")$xe[$o[0]]=$o[1][0];}}if(!$Ng){foreach($c
as$X){if(!queries("ALTER TABLE ".table($Q)." $X"))return
false;}if($Q!=$B&&!queries("ALTER TABLE ".table($Q)." RENAME TO ".table($B)))return
false;}elseif(!recreate_table($Q,$B,$c,$xe,$_c,$Ea))return
false;if($Ea){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ea WHERE name = ".q($B));if(!$h->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($B).", $Ea)");queries("COMMIT");}return
true;}function
recreate_table($Q,$B,$p,$xe,$_c,$Ea,$w=array()){global$h;if($Q!=""){if(!$p){foreach(fields($Q)as$y=>$o){if($w)$o["auto_increment"]=0;$p[]=process_field($o,$o);$xe[$y]=idf_escape($y);}}$Qe=false;foreach($p
as$o){if($o[6])$Qe=true;}$Ob=array();foreach($w
as$y=>$X){if($X[2]=="DROP"){$Ob[$X[1]]=true;unset($w[$y]);}}foreach(indexes($Q)as$td=>$v){$f=array();foreach($v["columns"]as$y=>$e){if(!$xe[$e])continue
2;$f[]=$xe[$e].($v["descs"][$y]?" DESC":"");}if(!$Ob[$td]){if($v["type"]!="PRIMARY"||!$Qe)$w[]=array($v["type"],$td,$f);}}foreach($w
as$y=>$X){if($X[0]=="PRIMARY"){unset($w[$y]);$_c[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($Q)as$td=>$Cc){foreach($Cc["source"]as$y=>$e){if(!$xe[$e])continue
2;$Cc["source"][$y]=idf_unescape($xe[$e]);}if(!isset($_c[" $td"]))$_c[]=" ".format_foreign_key($Cc);}queries("BEGIN");}foreach($p
as$y=>$o)$p[$y]="  ".implode($o);$p=array_merge($p,array_filter($_c));$eg=($Q==$B?"adminer_$B":$B);if(!queries("CREATE TABLE ".table($eg)." (\n".implode(",\n",$p)."\n)"))return
false;if($Q!=""){if($xe&&!queries("INSERT INTO ".table($eg)." (".implode(", ",$xe).") SELECT ".implode(", ",array_map('idf_escape',array_keys($xe)))." FROM ".table($Q)))return
false;$Bg=array();foreach(triggers($Q)as$_g=>$lg){$zg=trigger($_g);$Bg[]="CREATE TRIGGER ".idf_escape($_g)." ".implode(" ",$lg)." ON ".table($B)."\n$zg[Statement]";}$Ea=$Ea?0:$h->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($Q));if(!queries("DROP TABLE ".table($Q))||($Q==$B&&!queries("ALTER TABLE ".table($eg)." RENAME TO ".table($B)))||!alter_indexes($B,$w))return
false;if($Ea)queries("UPDATE sqlite_sequence SET seq = $Ea WHERE name = ".q($B));foreach($Bg
as$zg){if(!queries($zg))return
false;}queries("COMMIT");}return
true;}function
index_sql($Q,$T,$B,$f){return"CREATE $T ".($T!="INDEX"?"INDEX ":"").idf_escape($B!=""?$B:uniqid($Q."_"))." ON ".table($Q)." $f";}function
alter_indexes($Q,$c){foreach($c
as$Pe){if($Pe[0]=="PRIMARY")return
recreate_table($Q,$Q,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($Q,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($S){return
apply_queries("DELETE FROM",$S);}function
drop_views($Vg){return
apply_queries("DROP VIEW",$Vg);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
move_tables($S,$Vg,$dg){return
false;}function
trigger($B){global$h;if($B=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$u='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Ag=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$u\\s*(".implode("|",$Ag["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($u))?\\s+ON\\s*$u\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$h->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($B)),$A);$ge=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($ge?" OF":""),"Of"=>idf_unescape($ge),"Trigger"=>$B,"Statement"=>$A[4],);}function
triggers($Q){$H=array();$Ag=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q))as$I){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Ag["Timing"]).')\s*(.*?)\s+ON\b~i',$I["sql"],$A);$H[$I["name"]]=array($A[1],$A[2]);}return$H;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$h;return$h->result("SELECT LAST_INSERT_ROWID()");}function
explain($h,$F){return$h->query("EXPLAIN QUERY PLAN $F");}function
found_rows($R,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($tf){return
true;}function
create_sql($Q,$Ea,$Uf){global$h;$H=$h->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($Q));foreach(indexes($Q)as$B=>$v){if($B=='')continue;$H.=";\n\n".index_sql($Q,$v['type'],$B,"(".implode(", ",array_map('idf_escape',$v['columns'])).")");}return$H;}function
truncate_sql($Q){return"DELETE FROM ".table($Q);}function
use_sql($j){}function
trigger_sql($Q){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q)));}function
show_variables(){global$h;$H=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$y)$H[$y]=$h->result("PRAGMA $y");return$H;}function
show_status(){$H=array();foreach(get_vals("PRAGMA compile_options")as$qe){list($y,$X)=explode("=",$qe,2);$H[$y]=$X;}return$H;}function
convert_field($o){}function
unconvert_field($o,$H){return$H;}function
support($oc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$oc);}function
driver_config(){$U=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);return
array('possible_drivers'=>array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite"),'jush'=>"sqlite",'types'=>$U,'structured_types'=>array_keys($U),'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL"),'functions'=>array("hex","length","lower","round","unixepoch","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",)),);}}$Mb["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($bc,$n){if(ini_bool("html_errors"))$n=html_entity_decode(strip_tags($n));$n=preg_replace('~^[^:]*: ~','',$n);$this->error=$n;}function
connect($M,$V,$E){global$b;$l=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($E,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$l!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$Tg=pg_version($this->_link);$this->server_info=$Tg["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($P){return"'".pg_escape_string($this->_link,$P)."'";}function
value($X,$o){return($o["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
quoteBinary($P){return"'".pg_escape_bytea($this->_link,$P)."'";}function
select_db($j){global$b;if($j==$b->database())return$this->_database;$H=@pg_connect("$this->_string dbname='".addcslashes($j,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($H)$this->_link=$H;return$H;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($F,$Dg=false){$G=@pg_query($this->_link,$F);$this->error="";if(!$G){$this->error=pg_last_error($this->_link);$H=false;}elseif(!pg_num_fields($G)){$this->affected_rows=pg_affected_rows($G);$H=true;}else$H=new
Min_Result($G);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$H;}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$o=0){$G=$this->query($F);if(!$G||!$G->num_rows)return
false;return
pg_fetch_result($G->_result,0,$o);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($G){$this->_result=$G;$this->num_rows=pg_num_rows($G);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$e=$this->_offset++;$H=new
stdClass;if(function_exists('pg_field_table'))$H->orgtable=pg_field_table($this->_result,$e);$H->name=pg_field_name($this->_result,$e);$H->orgname=$H->name;$H->type=pg_field_type($this->_result,$e);$H->charsetnr=($H->type=="bytea"?63:0);return$H;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($M,$V,$E){global$b;$l=$b->database();$this->dsn("pgsql:host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' client_encoding=utf8 dbname='".($l!=""?addcslashes($l,"'\\"):"postgres")."'",$V,$E);return
true;}function
select_db($j){global$b;return($b->database()==$j);}function
quoteBinary($rf){return
q($rf);}function
query($F,$Dg=false){$H=parent::query($F,$Dg);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$H;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$J,$Pe){global$h;foreach($J
as$N){$Kg=array();$Z=array();foreach($N
as$y=>$X){$Kg[]="$y = $X";if(isset($Pe[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Kg)." WHERE ".implode(" AND ",$Z))&&$h->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}function
slowQuery($F,$kg){$this->_conn->query("SET statement_timeout = ".(1000*$kg));$this->_conn->timeout=1000*$kg;return$F;}function
convertSearch($u,$X,$o){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$o["type"])?$u:"CAST($u AS text)");}function
quoteBinary($rf){return$this->_conn->quoteBinary($rf);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($B){$Fd=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$_=$Fd[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$B).".html";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b,$U,$Tf;$h=new
Min_DB;$wb=$b->credentials();if($h->connect($wb[0],$wb[1],$wb[2])){if(min_version(9,0,$h)){$h->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$h)){$Tf[lang(25)][]="json";$U["json"]=4294967295;if(min_version(9.4,0,$h)){$Tf[lang(25)][]="jsonb";$U["jsonb"]=4294967295;}}}return$h;}return$h->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($F,$Z,$z,$he=0,$L=" "){return" $F$Z".($z!==null?$L."LIMIT $z".($he?" OFFSET $he":""):"");}function
limit1($Q,$F,$Z,$L="\n"){return(preg_match('~^INTO~',$F)?limit($F,$Z,1,0,$L):" $F".(is_view(table_status1($Q))?$Z:" WHERE ctid = (SELECT ctid FROM ".table($Q).$Z.$L."LIMIT 1)"));}function
db_collation($l,$bb){global$h;return$h->result("SELECT datcollate FROM pg_database WHERE datname = ".q($l));}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT user");}function
tables_list(){$F="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$F.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$F.="
ORDER BY 1";return
get_key_vals($F);}function
count_tables($k){return
array();}function
table_status($B=""){$H=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", ".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($B!=""?"AND relname = ".q($B):"ORDER BY relname"))as$I)$H[$I["Name"]]=$I;return($B!=""?$H[$B]:$H);}function
is_view($R){return
in_array($R["Engine"],array("view","materialized view"));}function
fk_support($R){return
true;}function
fields($Q){$H=array();$wa=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment".(min_version(10)?", a.attidentity":"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($Q)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$I){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$I["full_type"],$A);list(,$T,$Cd,$I["length"],$sa,$ya)=$A;$I["length"].=$ya;$Ta=$T.$sa;if(isset($wa[$Ta])){$I["type"]=$wa[$Ta];$I["full_type"]=$I["type"].$Cd.$ya;}else{$I["type"]=$T;$I["full_type"]=$I["type"].$Cd.$sa.$ya;}if(in_array($I['attidentity'],array('a','d')))$I['default']='GENERATED '.($I['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$I["null"]=!$I["attnotnull"];$I["auto_increment"]=$I['attidentity']||preg_match('~^nextval\(~i',$I["default"]);$I["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$I["default"],$A))$I["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$H[$I["field"]]=$I;}return$H;}function
indexes($Q,$i=null){global$h;if(!is_object($i))$i=$h;$H=array();$bg=$i->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($Q));$f=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $bg AND attnum > 0",$i);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $bg AND ci.oid = i.indexrelid",$i)as$I){$ff=$I["relname"];$H[$ff]["type"]=($I["indispartial"]?"INDEX":($I["indisprimary"]?"PRIMARY":($I["indisunique"]?"UNIQUE":"INDEX")));$H[$ff]["columns"]=array();foreach(explode(" ",$I["indkey"])as$gd)$H[$ff]["columns"][]=$f[$gd];$H[$ff]["descs"]=array();foreach(explode(" ",$I["indoption"])as$hd)$H[$ff]["descs"][]=($hd&1?'1':null);$H[$ff]["lengths"]=array();}return$H;}function
foreign_keys($Q){global$ke;$H=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($Q)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$I){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$I['definition'],$A)){$I['source']=array_map('idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$Md)){$I['ns']=idf_unescape($Md[2]);$I['table']=idf_unescape($Md[4]);}$I['target']=array_map('idf_unescape',array_map('trim',explode(',',$A[3])));$I['on_delete']=(preg_match("~ON DELETE ($ke)~",$A[4],$Md)?$Md[1]:'NO ACTION');$I['on_update']=(preg_match("~ON UPDATE ($ke)~",$A[4],$Md)?$Md[1]:'NO ACTION');$H[$I['conname']]=$I;}}return$H;}function
constraints($Q){global$ke;$H=array();foreach(get_rows("SELECT conname, consrc
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($Q)."
ORDER BY connamespace, conname")as$I)$H[$I['conname']]=$I['consrc'];return$H;}function
view($B){global$h;return
array("select"=>trim($h->result("SELECT pg_get_viewdef(".$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($B)).")")));}function
collations(){return
array();}function
information_schema($l){return($l=="information_schema");}function
error(){global$h;$H=h($h->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$H,$A))$H=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($H);}function
create_database($l,$d){return
queries("CREATE DATABASE ".idf_escape($l).($d?" ENCODING ".idf_escape($d):""));}function
drop_databases($k){global$h;$h->close();return
apply_queries("DROP DATABASE",$k,'idf_escape');}function
rename_database($B,$d){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($B));}function
auto_increment(){return"";}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){$c=array();$Xe=array();if($Q!=""&&$Q!=$B)$Xe[]="ALTER TABLE ".table($Q)." RENAME TO ".table($B);foreach($p
as$o){$e=idf_escape($o[0]);$X=$o[1];if(!$X)$c[]="DROP $e";else{$Qg=$X[5];unset($X[5]);if($o[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$c[]=($Q!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$c[]=($Q!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($e!=$X[0])$Xe[]="ALTER TABLE ".table($B)." RENAME $e TO $X[0]";$c[]="ALTER $e TYPE$X[1]";if(!$X[6]){$c[]="ALTER $e ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $e ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($o[0]!=""||$Qg!="")$Xe[]="COMMENT ON COLUMN ".table($B).".$X[0] IS ".($Qg!=""?substr($Qg,9):"''");}}$c=array_merge($c,$_c);if($Q=="")array_unshift($Xe,"CREATE TABLE ".table($B)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($Xe,"ALTER TABLE ".table($Q)."\n".implode(",\n",$c));if($Q!=""||$gb!="")$Xe[]="COMMENT ON TABLE ".table($B)." IS ".q($gb);if($Ea!=""){}foreach($Xe
as$F){if(!queries($F))return
false;}return
true;}function
alter_indexes($Q,$c){$ub=array();$Nb=array();$Xe=array();foreach($c
as$X){if($X[0]!="INDEX")$ub[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$Nb[]=idf_escape($X[1]);else$Xe[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($ub)array_unshift($Xe,"ALTER TABLE ".table($Q).implode(",",$ub));if($Nb)array_unshift($Xe,"DROP INDEX ".implode(", ",$Nb));foreach($Xe
as$F){if(!queries($F))return
false;}return
true;}function
truncate_tables($S){return
queries("TRUNCATE ".implode(", ",array_map('table',$S)));return
true;}function
drop_views($Vg){return
drop_tables($Vg);}function
drop_tables($S){foreach($S
as$Q){$O=table_status($Q);if(!queries("DROP ".strtoupper($O["Engine"])." ".table($Q)))return
false;}return
true;}function
move_tables($S,$Vg,$dg){foreach(array_merge($S,$Vg)as$Q){$O=table_status($Q);if(!queries("ALTER ".strtoupper($O["Engine"])." ".table($Q)." SET SCHEMA ".idf_escape($dg)))return
false;}return
true;}function
trigger($B,$Q){if($B=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$f=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q)." AND trigger_name = ".q($B);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$I)$f[]=$I["event_object_column"];$H=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement" FROM information_schema.triggers '."$Z ORDER BY event_manipulation DESC")as$I){if($f&&$I["Event"]=="UPDATE")$I["Event"].=" OF";$I["Of"]=implode(", ",$f);if($H)$I["Event"].=" OR $H[Event]";$H=$I;}return$H;}function
triggers($Q){$H=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q))as$I){$zg=trigger($I["trigger_name"],$Q);$H[$zg["Trigger"]]=array($zg["Timing"],$zg["Event"]);}return$H;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($B,$T){$J=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($B));$H=$J[0];$H["returns"]=array("type"=>$H["type_udt_name"]);$H["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($B).'
ORDER BY ordinal_position');return$H;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($B,$I){$H=array();foreach($I["fields"]as$o)$H[]=$o["type"];return
idf_escape($B)."(".implode(", ",$H).")";}function
last_id(){return
0;}function
explain($h,$F){return$h->query("EXPLAIN $F");}function
found_rows($R,$Z){global$h;if(preg_match("~ rows=([0-9]+)~",$h->result("EXPLAIN SELECT * FROM ".idf_escape($R["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$ef))return$ef[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$h;return$h->result("SELECT current_schema()");}function
set_schema($sf,$i=null){global$h,$U,$Tf;if(!$i)$i=$h;$H=$i->query("SET search_path TO ".idf_escape($sf));foreach(types()as$T){if(!isset($U[$T])){$U[$T]=0;$Tf[lang(26)][]=$T;}}return$H;}function
foreign_keys_sql($Q){$H="";$O=table_status($Q);$xc=foreign_keys($Q);ksort($xc);foreach($xc
as$wc=>$vc)$H.="ALTER TABLE ONLY ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." ADD CONSTRAINT ".idf_escape($wc)." $vc[definition] ".($vc['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($H?"$H\n":$H);}function
create_sql($Q,$Ea,$Uf){global$h;$H='';$of=array();$Af=array();$O=table_status($Q);if(is_view($O)){$Ug=view($Q);return
rtrim("CREATE VIEW ".idf_escape($Q)." AS $Ug[select]",";");}$p=fields($Q);$w=indexes($Q);ksort($w);$pb=constraints($Q);if(!$O||empty($p))return
false;$H="CREATE TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." (\n    ";foreach($p
as$pc=>$o){$De=idf_escape($o['field']).' '.$o['full_type'].default_value($o).($o['attnotnull']?" NOT NULL":"");$of[]=$De;if(preg_match('~nextval\(\'([^\']+)\'\)~',$o['default'],$Nd)){$_f=$Nd[1];$Mf=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($_f):"SELECT * FROM $_f"));$Af[]=($Uf=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $_f;\n":"")."CREATE SEQUENCE $_f INCREMENT $Mf[increment_by] MINVALUE $Mf[min_value] MAXVALUE $Mf[max_value]".($Ea&&$Mf['last_value']?" START $Mf[last_value]":"")." CACHE $Mf[cache_value];";}}if(!empty($Af))$H=implode("\n\n",$Af)."\n\n$H";foreach($w
as$bd=>$v){switch($v['type']){case'UNIQUE':$of[]="CONSTRAINT ".idf_escape($bd)." UNIQUE (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;case'PRIMARY':$of[]="CONSTRAINT ".idf_escape($bd)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;}}foreach($pb
as$lb=>$nb)$of[]="CONSTRAINT ".idf_escape($lb)." CHECK $nb";$H.=implode(",\n    ",$of)."\n) WITH (oids = ".($O['Oid']?'true':'false').");";foreach($w
as$bd=>$v){if($v['type']=='INDEX'){$f=array();foreach($v['columns']as$y=>$X)$f[]=idf_escape($X).($v['descs'][$y]?" DESC":"");$H.="\n\nCREATE INDEX ".idf_escape($bd)." ON ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." USING btree (".implode(', ',$f).");";}}if($O['Comment'])$H.="\n\nCOMMENT ON TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." IS ".q($O['Comment']).";";foreach($p
as$pc=>$o){if($o['comment'])$H.="\n\nCOMMENT ON COLUMN ".idf_escape($O['nspname']).".".idf_escape($O['Name']).".".idf_escape($pc)." IS ".q($o['comment']).";";}return
rtrim($H,';');}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
trigger_sql($Q){$O=table_status($Q);$H="";foreach(triggers($Q)as$yg=>$xg){$zg=trigger($yg,$O['Name']);$H.="\nCREATE TRIGGER ".idf_escape($zg['Trigger'])." $zg[Timing] $zg[Event] ON ".idf_escape($O["nspname"]).".".idf_escape($O['Name'])." $zg[Type] $zg[Statement];;\n";}return$H;}function
use_sql($j){return"\connect ".idf_escape($j);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($o){}function
unconvert_field($o,$H){return$H;}function
support($oc){return
preg_match('~^(database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$oc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$h;return$h->result("SHOW max_connections");}function
driver_config(){$U=array();$Tf=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$y=>$X){$U+=$X;$Tf[$y]=array_keys($X);}return
array('possible_drivers'=>array("PgSQL","PDO_PgSQL"),'jush'=>"pgsql",'types'=>$U,'structured_types'=>$Tf,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("char_length","lower","round","to_hex","to_timestamp","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",)),);}}$Mb["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;var$_current_db;function
_error($bc,$n){if(ini_bool("html_errors"))$n=html_entity_decode(strip_tags($n));$n=preg_replace('~^[^:]*: ~','',$n);$this->error=$n;}function
connect($M,$V,$E){$this->_link=@oci_new_connect($V,$E,$M,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$n=oci_error();$this->error=$n["message"];return
false;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($j){$this->_current_db=$j;return
true;}function
query($F,$Dg=false){$G=oci_parse($this->_link,$F);$this->error="";if(!$G){$n=oci_error($this->_link);$this->errno=$n["code"];$this->error=$n["message"];return
false;}set_error_handler(array($this,'_error'));$H=@oci_execute($G);restore_error_handler();if($H){if(oci_num_fields($G))return
new
Min_Result($G);$this->affected_rows=oci_num_rows($G);oci_free_statement($G);}return$H;}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$o=1){$G=$this->query($F);if(!is_object($G)||!oci_fetch($G->_result))return
false;return
oci_result($G->_result,$o);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($G){$this->_result=$G;}function
_convert($I){foreach((array)$I
as$y=>$X){if(is_a($X,'OCI-Lob'))$I[$y]=$X->load();}return$I;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$e=$this->_offset++;$H=new
stdClass;$H->name=oci_field_name($this->_result,$e);$H->orgname=$H->name;$H->type=oci_field_type($this->_result,$e);$H->charsetnr=(preg_match("~raw|blob|bfile~",$H->type)?63:0);return$H;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";var$_current_db;function
connect($M,$V,$E){$this->dsn("oci:dbname=//$M;charset=AL32UTF8",$V,$E);return
true;}function
select_db($j){$this->_current_db=$j;return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}function
insertUpdate($Q,$J,$Pe){global$h;foreach($J
as$N){$Kg=array();$Z=array();foreach($N
as$y=>$X){$Kg[]="$y = $X";if(isset($Pe[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Kg)." WHERE ".implode(" AND ",$Z))&&$h->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;$h=new
Min_DB;$wb=$b->credentials();if($h->connect($wb[0],$wb[1],$wb[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces ORDER BY 1");}function
limit($F,$Z,$z,$he=0,$L=" "){return($he?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $F$Z) t WHERE rownum <= ".($z+$he).") WHERE rnum > $he":($z!==null?" * FROM (SELECT $F$Z) WHERE rownum <= ".($z+$he):" $F$Z"));}function
limit1($Q,$F,$Z,$L="\n"){return" $F$Z";}function
db_collation($l,$bb){global$h;return$h->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT USER FROM DUAL");}function
get_current_db(){global$h;$l=$h->_current_db?$h->_current_db:DB;unset($h->_current_db);return$l;}function
where_owner($Oe,$ze="owner"){if(!$_GET["ns"])return'';return"$Oe$ze = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($f){$ze=where_owner('');return"(SELECT $f FROM all_views WHERE ".($ze?$ze:"rownum < 0").")";}function
tables_list(){$Ug=views_table("view_name");$ze=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$ze
UNION SELECT view_name, 'view' FROM $Ug
ORDER BY 1");}function
count_tables($k){global$h;$H=array();foreach($k
as$l)$H[$l]=$h->result("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($l));return$H;}function
table_status($B=""){$H=array();$uf=q($B);$l=get_current_db();$Ug=views_table("view_name");$ze=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($l).$ze.($B!=""?" AND table_name = $uf":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Ug".($B!=""?" WHERE view_name = $uf":"")."
ORDER BY 1")as$I){if($B!="")return$I;$H[$I["Name"]]=$I;}return$H;}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){return
true;}function
fields($Q){$H=array();$ze=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($Q)."$ze ORDER BY column_id")as$I){$T=$I["DATA_TYPE"];$Cd="$I[DATA_PRECISION],$I[DATA_SCALE]";if($Cd==",")$Cd=$I["CHAR_COL_DECL_LENGTH"];$H[$I["COLUMN_NAME"]]=array("field"=>$I["COLUMN_NAME"],"full_type"=>$T.($Cd?"($Cd)":""),"type"=>strtolower($T),"length"=>$Cd,"default"=>$I["DATA_DEFAULT"],"null"=>($I["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$H;}function
indexes($Q,$i=null){$H=array();$ze=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($Q)."$ze
ORDER BY ac.constraint_type, aic.column_position",$i)as$I){$bd=$I["INDEX_NAME"];$eb=$I["DATA_DEFAULT"];$eb=($eb?trim($eb,'"'):$I["COLUMN_NAME"]);$H[$bd]["type"]=($I["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($I["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$H[$bd]["columns"][]=$eb;$H[$bd]["lengths"][]=($I["CHAR_LENGTH"]&&$I["CHAR_LENGTH"]!=$I["COLUMN_LENGTH"]?$I["CHAR_LENGTH"]:null);$H[$bd]["descs"][]=($I["DESCEND"]&&$I["DESCEND"]=="DESC"?'1':null);}return$H;}function
view($B){$Ug=views_table("view_name, text");$J=get_rows('SELECT text "select" FROM '.$Ug.' WHERE view_name = '.q($B));return
reset($J);}function
collations(){return
array();}function
information_schema($l){return
false;}function
error(){global$h;return
h($h->error);}function
explain($h,$F){$h->query("EXPLAIN PLAN FOR $F");return$h->query("SELECT * FROM plan_table");}function
found_rows($R,$Z){}function
auto_increment(){return"";}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){$c=$Nb=array();$ve=($Q?fields($Q):array());foreach($p
as$o){$X=$o[1];if($X&&$o[0]!=""&&idf_escape($o[0])!=$X[0])queries("ALTER TABLE ".table($Q)." RENAME COLUMN ".idf_escape($o[0])." TO $X[0]");$ue=$ve[$o[0]];if($X&&$ue){$je=process_field($ue,$ue);if($X[2]==$je[2])$X[2]="";}if($X)$c[]=($Q!=""?($o[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($Q!=""?")":"");else$Nb[]=idf_escape($o[0]);}if($Q=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($Q)."\n".implode("\n",$c)))&&(!$Nb||queries("ALTER TABLE ".table($Q)." DROP (".implode(", ",$Nb).")"))&&($Q==$B||queries("ALTER TABLE ".table($Q)." RENAME TO ".table($B)));}function
alter_indexes($Q,$c){$Nb=array();$Xe=array();foreach($c
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$ub=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Xe,"ALTER TABLE ".table($Q).$ub);}elseif($X[2]=="DROP")$Nb[]=idf_escape($X[1]);else$Xe[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($Nb)array_unshift($Xe,"DROP INDEX ".implode(", ",$Nb));foreach($Xe
as$F){if(!queries($F))return
false;}return
true;}function
foreign_keys($Q){$H=array();$F="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($Q);foreach(get_rows($F)as$I)$H[$I['NAME']]=array("db"=>$I['DEST_DB'],"table"=>$I['DEST_TABLE'],"source"=>array($I['SRC_COLUMN']),"target"=>array($I['DEST_COLUMN']),"on_delete"=>$I['ON_DELETE'],"on_update"=>null,);return$H;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($Vg){return
apply_queries("DROP VIEW",$Vg);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
last_id(){return
0;}function
schemas(){$H=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($H?$H:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){global$h;return$h->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($tf,$i=null){global$h;if(!$i)$i=$h;return$i->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($tf));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$J=get_rows('SELECT * FROM v$instance');return
reset($J);}function
convert_field($o){}function
unconvert_field($o,$H){return$H;}function
support($oc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$oc);}function
driver_config(){$U=array();$Tf=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$y=>$X){$U+=$X;$Tf[$y]=array_keys($X);}return
array('possible_drivers'=>array("OCI8","PDO_OCI"),'jush'=>"oracle",'types'=>$U,'structured_types'=>$Tf,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("length","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",)),);}}$Mb["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$n){$this->errno=$n["code"];$this->error.="$n[message]\n";}$this->error=rtrim($this->error);}function
connect($M,$V,$E){global$b;$l=$b->database();$mb=array("UID"=>$V,"PWD"=>$E,"CharacterSet"=>"UTF-8");if($l!="")$mb["Database"]=$l;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$M),$mb);if($this->_link){$id=sqlsrv_server_info($this->_link);$this->server_info=$id['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($j){return$this->query("USE ".idf_escape($j));}function
query($F,$Dg=false){$G=sqlsrv_query($this->_link,$F);$this->error="";if(!$G){$this->_get_error();return
false;}return$this->store_result($G);}function
multi_query($F){$this->_result=sqlsrv_query($this->_link,$F);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($G=null){if(!$G)$G=$this->_result;if(!$G)return
false;if(sqlsrv_field_metadata($G))return
new
Min_Result($G);$this->affected_rows=sqlsrv_rows_affected($G);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($F,$o=0){$G=$this->query($F);if(!is_object($G))return
false;$I=$G->fetch_row();return$I[$o];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($G){$this->_result=$G;}function
_convert($I){foreach((array)$I
as$y=>$X){if(is_a($X,'DateTime'))$I[$y]=$X->format("Y-m-d H:i:s");}return$I;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$o=$this->_fields[$this->_offset++];$H=new
stdClass;$H->name=$o["Name"];$H->orgname=$o["Name"];$H->type=($o["Type"]==1?254:0);return$H;}function
seek($he){for($s=0;$s<$he;$s++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($M,$V,$E){$this->_link=@mssql_connect($M,$V,$E);if($this->_link){$G=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($G){$I=$G->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$I[0]] $I[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($j){return
mssql_select_db($j);}function
query($F,$Dg=false){$G=@mssql_query($F,$this->_link);$this->error="";if(!$G){$this->error=mssql_get_last_message();return
false;}if($G===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($G);}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($F,$o=0){$G=$this->query($F);if(!is_object($G))return
false;return
mssql_result($G->_result,0,$o);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($G){$this->_result=$G;$this->num_rows=mssql_num_rows($G);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$H=mssql_fetch_field($this->_result);$H->orgtable=$H->table;$H->orgname=$H->name;return$H;}function
seek($he){mssql_data_seek($this->_result,$he);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($M,$V,$E){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$E);return
true;}function
select_db($j){return$this->query("USE ".idf_escape($j));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$J,$Pe){foreach($J
as$N){$Kg=array();$Z=array();foreach($N
as$y=>$X){$Kg[]="$y = $X";if(isset($Pe[idf_unescape($y)]))$Z[]="$y = $X";}if(!queries("MERGE ".table($Q)." USING (VALUES(".implode(", ",$N).")) AS source (c".implode(", c",range(1,count($N))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Kg)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($u){return"[".str_replace("]","]]",$u)."]";}function
table($u){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($u);}function
connect(){global$b;$h=new
Min_DB;$wb=$b->credentials();if($h->connect($wb[0],$wb[1],$wb[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($F,$Z,$z,$he=0,$L=" "){return($z!==null?" TOP (".($z+$he).")":"")." $F$Z";}function
limit1($Q,$F,$Z,$L="\n"){return
limit($F,$Z,1,0,$L);}function
db_collation($l,$bb){global$h;return$h->result("SELECT collation_name FROM sys.databases WHERE name = ".q($l));}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($k){global$h;$H=array();foreach($k
as$l){$h->select_db($l);$H[$l]=$h->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$H;}function
table_status($B=""){$H=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$I){if($B!="")return$I;$H[$I["Name"]]=$I;}return$H;}function
is_view($R){return$R["Engine"]=="VIEW";}function
fk_support($R){return
true;}function
fields($Q){$hb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($Q).", 'column', NULL)");$H=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($Q))as$I){$T=$I["type"];$Cd=(preg_match("~char|binary~",$T)?$I["max_length"]:($T=="decimal"?"$I[precision],$I[scale]":""));$H[$I["name"]]=array("field"=>$I["name"],"full_type"=>$T.($Cd?"($Cd)":""),"type"=>$T,"length"=>$Cd,"default"=>$I["default"],"null"=>$I["is_nullable"],"auto_increment"=>$I["is_identity"],"collation"=>$I["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$I["is_identity"],"comment"=>$hb[$I["name"]],);}return$H;}function
indexes($Q,$i=null){$H=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($Q),$i)as$I){$B=$I["name"];$H[$B]["type"]=($I["is_primary_key"]?"PRIMARY":($I["is_unique"]?"UNIQUE":"INDEX"));$H[$B]["lengths"]=array();$H[$B]["columns"][$I["key_ordinal"]]=$I["column_name"];$H[$B]["descs"][$I["key_ordinal"]]=($I["is_descending_key"]?'1':null);}return$H;}function
view($B){global$h;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$h->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($B))));}function
collations(){$H=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$d)$H[preg_replace('~_.*~','',$d)][]=$d;return$H;}function
information_schema($l){return
false;}function
error(){global$h;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$h->error)));}function
create_database($l,$d){return
queries("CREATE DATABASE ".idf_escape($l).(preg_match('~^[a-z0-9_]+$~i',$d)?" COLLATE $d":""));}function
drop_databases($k){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$k)));}function
rename_database($B,$d){if(preg_match('~^[a-z0-9_]+$~i',$d))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $d");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($B));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){$c=array();$hb=array();foreach($p
as$o){$e=idf_escape($o[0]);$X=$o[1];if(!$X)$c["DROP"][]=" COLUMN $e";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$hb[$o[0]]=$X[5];unset($X[5]);if($o[0]=="")$c["ADD"][]="\n  ".implode("",$X).($Q==""?substr($_c[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($e!=$X[0])queries("EXEC sp_rename ".q(table($Q).".$e").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($Q=="")return
queries("CREATE TABLE ".table($B)." (".implode(",",(array)$c["ADD"])."\n)");if($Q!=$B)queries("EXEC sp_rename ".q(table($Q)).", ".q($B));if($_c)$c[""]=$_c;foreach($c
as$y=>$X){if(!queries("ALTER TABLE ".idf_escape($B)." $y".implode(",",$X)))return
false;}foreach($hb
as$y=>$X){$gb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$gb.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));}return
true;}function
alter_indexes($Q,$c){$v=array();$Nb=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$Nb[]=idf_escape($X[1]);else$v[]=idf_escape($X[1])." ON ".table($Q);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q):"ALTER TABLE ".table($Q)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$v||queries("DROP INDEX ".implode(", ",$v)))&&(!$Nb||queries("ALTER TABLE ".table($Q)." DROP ".implode(", ",$Nb)));}function
last_id(){global$h;return$h->result("SELECT SCOPE_IDENTITY()");}function
explain($h,$F){$h->query("SET SHOWPLAN_ALL ON");$H=$h->query($F);$h->query("SET SHOWPLAN_ALL OFF");return$H;}function
found_rows($R,$Z){}function
foreign_keys($Q){$H=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($Q))as$I){$Cc=&$H[$I["FK_NAME"]];$Cc["db"]=$I["PKTABLE_QUALIFIER"];$Cc["table"]=$I["PKTABLE_NAME"];$Cc["source"][]=$I["FKCOLUMN_NAME"];$Cc["target"][]=$I["PKCOLUMN_NAME"];}return$H;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($Vg){return
queries("DROP VIEW ".implode(", ",array_map('table',$Vg)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$Vg,$dg){return
apply_queries("ALTER SCHEMA ".idf_escape($dg)." TRANSFER",array_merge($S,$Vg));}function
trigger($B){if($B=="")return
array();$J=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($B));$H=reset($J);if($H)$H["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$H["text"]);return$H;}function
triggers($Q){$H=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($Q))as$I)$H[$I["name"]]=array($I["Timing"],$I["Event"]);return$H;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$h;if($_GET["ns"]!="")return$_GET["ns"];return$h->result("SELECT SCHEMA_NAME()");}function
set_schema($sf){return
true;}function
use_sql($j){return"USE ".idf_escape($j);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($o){}function
unconvert_field($o,$H){return$H;}function
support($oc){return
preg_match('~^(comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$oc);}function
driver_config(){$U=array();$Tf=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$y=>$X){$U+=$X;$Tf[$y]=array_keys($X);}return
array('possible_drivers'=>array("SQLSRV","MSSQL","PDO_DBLIB"),'jush'=>"mssql",'types'=>$U,'structured_types'=>$Tf,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("len","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",)),);}}$Mb["mongo"]="MongoDB (alpha)";if(isset($_GET["mongo"])){define("DRIVER","mongo");if(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Lg,$C){try{$this->_link=new
MongoClient($Lg,$C);if($C["password"]!=""){$C["password"]="";try{new
MongoClient($Lg,$C);$this->error=lang(22);}catch(Exception$Qb){}}}catch(Exception$Qb){$this->error=$Qb->getMessage();}}function
query($F){return
false;}function
select_db($j){try{$this->_db=$this->_link->selectDB($j);return
true;}catch(Exception$ec){$this->error=$ec->getMessage();return
false;}}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($G){foreach($G
as$rd){$I=array();foreach($rd
as$y=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$y]=63;$I[$y]=(is_a($X,'MongoId')?"ObjectId(\"$X\")":(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?"$X":(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$I;foreach($I
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);if(!$I)return$I;$H=array();foreach($this->_rows[0]as$y=>$X)$H[$y]=$I[$y];next($this->_rows);return$H;}function
fetch_row(){$H=$this->fetch_assoc();if(!$H)return$H;return
array_values($H);}function
fetch_field(){$ud=array_keys($this->_rows[0]);$B=$ud[$this->_offset++];return(object)array('name'=>$B,'charsetnr'=>$this->_charset[$B],);}}class
Min_Driver
extends
Min_SQL{public$Pe="_id";function
select($Q,$K,$Z,$Jc,$se=array(),$z=1,$D=0,$Re=false){$K=($K==array("*")?array():array_fill_keys($K,true));$Jf=array();foreach($se
as$X){$X=preg_replace('~ DESC$~','',$X,1,$sb);$Jf[$X]=($sb?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($Q)->find(array(),$K)->sort($Jf)->limit($z!=""?+$z:0)->skip($D*$z));}function
insert($Q,$N){try{$H=$this->_conn->_db->selectCollection($Q)->insert($N);$this->_conn->errno=$H['code'];$this->_conn->error=$H['err'];$this->_conn->last_id=$N['_id'];return!$H['err'];}catch(Exception$ec){$this->_conn->error=$ec->getMessage();return
false;}}}function
get_databases($yc){global$h;$H=array();$Bb=$h->_link->listDBs();foreach($Bb['databases']as$l)$H[]=$l['name'];return$H;}function
count_tables($k){global$h;$H=array();foreach($k
as$l)$H[$l]=count($h->_link->selectDB($l)->getCollectionNames(true));return$H;}function
tables_list(){global$h;return
array_fill_keys($h->_db->getCollectionNames(true),'table');}function
drop_databases($k){global$h;foreach($k
as$l){$kf=$h->_link->selectDB($l)->drop();if(!$kf['ok'])return
false;}return
true;}function
indexes($Q,$i=null){global$h;$H=array();foreach($h->_db->selectCollection($Q)->getIndexInfo()as$v){$Hb=array();foreach($v["key"]as$e=>$T)$Hb[]=($T==-1?'1':null);$H[$v["name"]]=array("type"=>($v["name"]=="_id_"?"PRIMARY":($v["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($v["key"]),"lengths"=>array(),"descs"=>$Hb,);}return$H;}function
fields($Q){return
fields_from_edit();}function
found_rows($R,$Z){global$h;return$h->_db->selectCollection($_GET["select"])->count($Z);}$pe=array("=");}elseif(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$affected_rows,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Lg,$C){$Xa='MongoDB\Driver\Manager';$this->_link=new$Xa($Lg,$C);$this->executeCommand('admin',array('ping'=>1));}function
executeCommand($l,$fb){$Xa='MongoDB\Driver\Command';try{return$this->_link->executeCommand($l,new$Xa($fb));}catch(Exception$Qb){$this->error=$Qb->getMessage();return
array();}}function
executeBulkWrite($be,$Qa,$tb){try{$nf=$this->_link->executeBulkWrite($be,$Qa);$this->affected_rows=$nf->$tb();return
true;}catch(Exception$Qb){$this->error=$Qb->getMessage();return
false;}}function
query($F){return
false;}function
select_db($j){$this->_db_name=$j;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($G){foreach($G
as$rd){$I=array();foreach($rd
as$y=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$y]=63;$I[$y]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'."$X\")":(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->getData():(is_a($X,'MongoDB\BSON\Regex')?"$X":(is_object($X)||is_array($X)?json_encode($X,256):$X)))));}$this->_rows[]=$I;foreach($I
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);if(!$I)return$I;$H=array();foreach($this->_rows[0]as$y=>$X)$H[$y]=$I[$y];next($this->_rows);return$H;}function
fetch_row(){$H=$this->fetch_assoc();if(!$H)return$H;return
array_values($H);}function
fetch_field(){$ud=array_keys($this->_rows[0]);$B=$ud[$this->_offset++];return(object)array('name'=>$B,'charsetnr'=>$this->_charset[$B],);}}class
Min_Driver
extends
Min_SQL{public$Pe="_id";function
select($Q,$K,$Z,$Jc,$se=array(),$z=1,$D=0,$Re=false){global$h;$K=($K==array("*")?array():array_fill_keys($K,1));if(count($K)&&!isset($K['_id']))$K['_id']=0;$Z=where_to_query($Z);$Jf=array();foreach($se
as$X){$X=preg_replace('~ DESC$~','',$X,1,$sb);$Jf[$X]=($sb?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$z=$_GET['limit'];$z=min(200,max(1,(int)$z));$Gf=$D*$z;$Xa='MongoDB\Driver\Query';try{return
new
Min_Result($h->_link->executeQuery("$h->_db_name.$Q",new$Xa($Z,array('projection'=>$K,'limit'=>$z,'skip'=>$Gf,'sort'=>$Jf))));}catch(Exception$Qb){$h->error=$Qb->getMessage();return
false;}}function
update($Q,$N,$Ye,$z=0,$L="\n"){global$h;$l=$h->_db_name;$Z=sql_query_where_parser($Ye);$Xa='MongoDB\Driver\BulkWrite';$Qa=new$Xa(array());if(isset($N['_id']))unset($N['_id']);$gf=array();foreach($N
as$y=>$Y){if($Y=='NULL'){$gf[$y]=1;unset($N[$y]);}}$Kg=array('$set'=>$N);if(count($gf))$Kg['$unset']=$gf;$Qa->update($Z,$Kg,array('upsert'=>false));return$h->executeBulkWrite("$l.$Q",$Qa,'getModifiedCount');}function
delete($Q,$Ye,$z=0){global$h;$l=$h->_db_name;$Z=sql_query_where_parser($Ye);$Xa='MongoDB\Driver\BulkWrite';$Qa=new$Xa(array());$Qa->delete($Z,array('limit'=>$z));return$h->executeBulkWrite("$l.$Q",$Qa,'getDeletedCount');}function
insert($Q,$N){global$h;$l=$h->_db_name;$Xa='MongoDB\Driver\BulkWrite';$Qa=new$Xa(array());if($N['_id']=='')unset($N['_id']);$Qa->insert($N);return$h->executeBulkWrite("$l.$Q",$Qa,'getInsertedCount');}}function
get_databases($yc){global$h;$H=array();foreach($h->executeCommand('admin',array('listDatabases'=>1))as$Bb){foreach($Bb->databases
as$l)$H[]=$l->name;}return$H;}function
count_tables($k){$H=array();return$H;}function
tables_list(){global$h;$cb=array();foreach($h->executeCommand($h->_db_name,array('listCollections'=>1))as$G)$cb[$G->name]='table';return$cb;}function
drop_databases($k){return
false;}function
indexes($Q,$i=null){global$h;$H=array();foreach($h->executeCommand($h->_db_name,array('listIndexes'=>$Q))as$v){$Hb=array();$f=array();foreach(get_object_vars($v->key)as$e=>$T){$Hb[]=($T==-1?'1':null);$f[]=$e;}$H[$v->name]=array("type"=>($v->name=="_id_"?"PRIMARY":(isset($v->unique)?"UNIQUE":"INDEX")),"columns"=>$f,"lengths"=>array(),"descs"=>$Hb,);}return$H;}function
fields($Q){global$m;$p=fields_from_edit();if(!$p){$G=$m->select($Q,array("*"),null,null,array(),10);if($G){while($I=$G->fetch_assoc()){foreach($I
as$y=>$X){$I[$y]=null;$p[$y]=array("field"=>$y,"type"=>"string","null"=>($y!=$m->primary),"auto_increment"=>($y==$m->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}}return$p;}function
found_rows($R,$Z){global$h;$Z=where_to_query($Z);$rg=$h->executeCommand($h->_db_name,array('count'=>$R['Name'],'query'=>$Z))->toArray();return$rg[0]->n;}function
sql_query_where_parser($Ye){$Ye=preg_replace('~^\sWHERE \(?\(?(.+?)\)?\)?$~','\1',$Ye);$dh=explode(' AND ',$Ye);$eh=explode(') OR (',$Ye);$Z=array();foreach($dh
as$bh)$Z[]=trim($bh);if(count($eh)==1)$eh=array();elseif(count($eh)>1)$Z=array();return
where_to_query($Z,$eh);}function
where_to_query($Zg=array(),$ah=array()){global$b;$_b=array();foreach(array('and'=>$Zg,'or'=>$ah)as$T=>$Z){if(is_array($Z)){foreach($Z
as$hc){list($ab,$ne,$X)=explode(" ",$hc,3);if($ab=="_id"&&preg_match('~^(MongoDB\\\\BSON\\\\ObjectID)\("(.+)"\)$~',$X,$A)){list(,$Xa,$X)=$A;$X=new$Xa($X);}if(!in_array($ne,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$ne,$A)){$X=(float)$X;$ne=$A[1];}elseif(preg_match('~^\(date\)(.+)~',$ne,$A)){$Ab=new
DateTime($X);$Xa='MongoDB\BSON\UTCDatetime';$X=new$Xa($Ab->getTimestamp()*1000);$ne=$A[1];}switch($ne){case'=':$ne='$eq';break;case'!=':$ne='$ne';break;case'>':$ne='$gt';break;case'<':$ne='$lt';break;case'>=':$ne='$gte';break;case'<=':$ne='$lte';break;case'regex':$ne='$regex';break;default:continue
2;}if($T=='and')$_b['$and'][]=array($ab=>array($ne=>$X));elseif($T=='or')$_b['$or'][]=array($ab=>array($ne=>$X));}}}return$_b;}$pe=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);}function
table($u){return$u;}function
idf_escape($u){return$u;}function
table_status($B="",$nc=false){$H=array();foreach(tables_list()as$Q=>$T){$H[$Q]=array("Name"=>$Q);if($B==$Q)return$H[$Q];}return$H;}function
create_database($l,$d){return
true;}function
last_id(){global$h;return$h->last_id;}function
error(){global$h;return
h($h->error);}function
collations(){return
array();}function
logged_user(){global$b;$wb=$b->credentials();return$wb[1];}function
connect(){global$b;$h=new
Min_DB;list($M,$V,$E)=$b->credentials();$C=array();if($V.$E!=""){$C["username"]=$V;$C["password"]=$E;}$l=$b->database();if($l!="")$C["db"]=$l;if(($Da=getenv("MONGO_AUTH_SOURCE")))$C["authSource"]=$Da;$h->connect("mongodb://$M",$C);if($h->error)return$h->error;return$h;}function
alter_indexes($Q,$c){global$h;foreach($c
as$X){list($T,$B,$N)=$X;if($N=="DROP")$H=$h->_db->command(array("deleteIndexes"=>$Q,"index"=>$B));else{$f=array();foreach($N
as$e){$e=preg_replace('~ DESC$~','',$e,1,$sb);$f[$e]=($sb?-1:1);}$H=$h->_db->selectCollection($Q)->ensureIndex($f,array("unique"=>($T=="UNIQUE"),"name"=>$B,));}if($H['errmsg']){$h->error=$H['errmsg'];return
false;}}return
true;}function
support($oc){return
preg_match("~database|indexes|descidx~",$oc);}function
db_collation($l,$bb){}function
information_schema(){}function
is_view($R){}function
convert_field($o){}function
unconvert_field($o,$H){return$H;}function
foreign_keys($Q){return
array();}function
fk_support($R){}function
engines(){return
array();}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){global$h;if($Q==""){$h->_db->createCollection($B);return
true;}}function
drop_tables($S){global$h;foreach($S
as$Q){$kf=$h->_db->selectCollection($Q)->drop();if(!$kf['ok'])return
false;}return
true;}function
truncate_tables($S){global$h;foreach($S
as$Q){$kf=$h->_db->selectCollection($Q)->remove();if(!$kf['ok'])return
false;}return
true;}function
driver_config(){global$pe;return
array('possible_drivers'=>array("mongo","mongodb"),'jush'=>"mongo",'operators'=>$pe,'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),);}}$Mb["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url,$_db;function
rootQuery($Ge,$qb=array(),$Vd='GET'){@ini_set('track_errors',1);$rc=@file_get_contents("$this->_url/".ltrim($Ge,'/'),false,stream_context_create(array('http'=>array('method'=>$Vd,'content'=>$qb===null?$qb:json_encode($qb),'header'=>'Content-Type: application/json','ignore_errors'=>1,))));if(!$rc){$this->error=$php_errormsg;return$rc;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$H=json_decode($rc,true);if($H===null){$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$ob=get_defined_constants(true);foreach($ob['json']as$B=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$B)){$this->error=$B;break;}}}}return$H;}function
query($Ge,$qb=array(),$Vd='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($Ge,'/'),$qb,$Vd);}function
connect($M,$V,$E){preg_match('~^(https?://)?(.*)~',$M,$A);$this->_url=($A[1]?$A[1]:"http://")."$V:$E@$A[2]";$H=$this->query('');if($H)$this->server_info=$H['version']['number'];return(bool)$H;}function
select_db($j){$this->_db=$j;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows;function
__construct($J){$this->num_rows=count($J);$this->_rows=$J;reset($this->_rows);}function
fetch_assoc(){$H=current($this->_rows);next($this->_rows);return$H;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($Q,$K,$Z,$Jc,$se=array(),$z=1,$D=0,$Re=false){global$b;$_b=array();$F="$Q/_search";if($K!=array("*"))$_b["fields"]=$K;if($se){$Jf=array();foreach($se
as$ab){$ab=preg_replace('~ DESC$~','',$ab,1,$sb);$Jf[]=($sb?array($ab=>"desc"):$ab);}$_b["sort"]=$Jf;}if($z){$_b["size"]=+$z;if($D)$_b["from"]=($D*$z);}foreach($Z
as$X){list($ab,$ne,$X)=explode(" ",$X,3);if($ab=="_id")$_b["query"]["ids"]["values"][]=$X;elseif($ab.$X!=""){$fg=array("term"=>array(($ab!=""?$ab:"_all")=>$X));if($ne=="=")$_b["query"]["filtered"]["filter"]["and"][]=$fg;else$_b["query"]["filtered"]["query"]["bool"]["must"][]=$fg;}}if($_b["query"]&&!$_b["query"]["filtered"]["query"]&&!$_b["query"]["ids"])$_b["query"]["filtered"]["query"]=array("match_all"=>array());$Qf=microtime(true);$uf=$this->_conn->query($F,$_b);if($Re)echo$b->selectQuery("$F: ".json_encode($_b),$Qf,!$uf);if(!$uf)return
false;$H=array();foreach($uf['hits']['hits']as$Vc){$I=array();if($K==array("*"))$I["_id"]=$Vc["_id"];$p=$Vc['_source'];if($K!=array("*")){$p=array();foreach($K
as$y)$p[$y]=$Vc['fields'][$y];}foreach($p
as$y=>$X){if($_b["fields"])$X=$X[0];$I[$y]=(is_array($X)?json_encode($X):$X);}$H[]=$I;}return
new
Min_Result($H);}function
update($T,$cf,$Ye,$z=0,$L="\n"){$Fe=preg_split('~ *= *~',$Ye);if(count($Fe)==2){$t=trim($Fe[1]);$F="$T/$t";return$this->_conn->query($F,$cf,'POST');}return
false;}function
insert($T,$cf){$t="";$F="$T/$t";$kf=$this->_conn->query($F,$cf,'POST');$this->_conn->last_id=$kf['_id'];return$kf['created'];}function
delete($T,$Ye,$z=0){$Zc=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$Zc[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$Sa){$Fe=preg_split('~ *= *~',$Sa);if(count($Fe)==2)$Zc[]=trim($Fe[1]);}}$this->_conn->affected_rows=0;foreach($Zc
as$t){$F="{$T}/{$t}";$kf=$this->_conn->query($F,'{}','DELETE');if(is_array($kf)&&$kf['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$h=new
Min_DB;list($M,$V,$E)=$b->credentials();if($E!=""&&$h->connect($M,$V,""))return
lang(22);if($h->connect($M,$V,$E))return$h;return$h->error;}function
support($oc){return
preg_match("~database|table|columns~",$oc);}function
logged_user(){global$b;$wb=$b->credentials();return$wb[1];}function
get_databases(){global$h;$H=$h->rootQuery('_aliases');if($H){$H=array_keys($H);sort($H,SORT_STRING);}return$H;}function
collations(){return
array();}function
db_collation($l,$bb){}function
engines(){return
array();}function
count_tables($k){global$h;$H=array();$G=$h->query('_stats');if($G&&$G['indices']){$fd=$G['indices'];foreach($fd
as$ed=>$Rf){$dd=$Rf['total']['indexing'];$H[$ed]=$dd['index_total'];}}return$H;}function
tables_list(){global$h;if(min_version(6))return
array('_doc'=>'table');$H=$h->query('_mapping');if($H)$H=array_fill_keys(array_keys($H[$h->_db]["mappings"]),'table');return$H;}function
table_status($B="",$nc=false){global$h;$uf=$h->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$H=array();if($uf){$S=$uf["aggregations"]["count_by_type"]["buckets"];foreach($S
as$Q){$H[$Q["key"]]=array("Name"=>$Q["key"],"Engine"=>"table","Rows"=>$Q["doc_count"],);if($B!=""&&$B==$Q["key"])return$H[$B];}}return$H;}function
error(){global$h;return
h($h->error);}function
information_schema(){}function
is_view($R){}function
indexes($Q,$i=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($Q){global$h;$Jd=array();if(min_version(6)){$G=$h->query("_mapping");if($G)$Jd=$G[$h->_db]['mappings']['properties'];}else{$G=$h->query("$Q/_mapping");if($G){$Jd=$G[$Q]['properties'];if(!$Jd)$Jd=$G[$h->_db]['mappings'][$Q]['properties'];}}$H=array();if($Jd){foreach($Jd
as$B=>$o){$H[$B]=array("field"=>$B,"full_type"=>$o["type"],"type"=>$o["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($o["properties"]){unset($H[$B]["privileges"]["insert"]);unset($H[$B]["privileges"]["update"]);}}}return$H;}function
foreign_keys($Q){return
array();}function
table($u){return$u;}function
idf_escape($u){return$u;}function
convert_field($o){}function
unconvert_field($o,$H){return$H;}function
fk_support($R){}function
found_rows($R,$Z){return
null;}function
create_database($l){global$h;return$h->rootQuery(urlencode($l),null,'PUT');}function
drop_databases($k){global$h;return$h->rootQuery(urlencode(implode(',',$k)),array(),'DELETE');}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){global$h;$Ue=array();foreach($p
as$lc){$pc=trim($lc[1][0]);$qc=trim($lc[1][1]?$lc[1][1]:"text");$Ue[$pc]=array('type'=>$qc);}if(!empty($Ue))$Ue=array('properties'=>$Ue);return$h->query("_mapping/{$B}",$Ue,'PUT');}function
drop_tables($S){global$h;$H=true;foreach($S
as$Q)$H=$H&&$h->query(urlencode($Q),array(),'DELETE');return$H;}function
last_id(){global$h;return$h->last_id;}function
driver_config(){$U=array();$Tf=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$y=>$X){$U+=$X;$Tf[$y]=array_keys($X);}return
array('possible_drivers'=>array("json + allow_url_fopen"),'jush'=>"elastic",'operators'=>array("=","query"),'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),'types'=>$U,'structured_types'=>$Tf,);}}class
Adminer{var$operators=array("<=",">=");var$_values=array();function
name(){return"<a href='https://www.adminer.org/editor/'".target_blank()." id='h1'>".lang(33)."</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($ub=false){return
password_file($ub);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($M){}function
database(){global$h;if($h){$k=$this->databases(false);return(!$k?$h->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1)"):$k[(information_schema($k[0])?1:0)]);}}function
schemas(){return
schemas();}function
databases($yc=true){return
get_databases($yc);}function
queryTimeout(){return
5;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$H=array();$q="adminer.css";if(file_exists($q))$H[]=$q;return$H;}function
loginForm(){echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('username','<tr><th>'.lang(34).'<td>','<input type="hidden" name="auth[driver]" value="server"><input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username'));")),$this->loginFormField('password','<tr><th>'.lang(35).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),"</table>\n","<p><input type='submit' value='".lang(36)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(37))."\n";}function
loginFormField($B,$Tc,$Y){return$Tc.$Y;}function
login($Hd,$E){return
true;}function
tableName($Zf){return
h($Zf["Comment"]!=""?$Zf["Comment"]:$Zf["Name"]);}function
fieldName($o,$se=0){return
h(preg_replace('~\s+\[.*\]$~','',($o["comment"]!=""?$o["comment"]:$o["field"])));}function
selectLinks($Zf,$N=""){$a=$Zf["Name"];if($N!==null)echo'<p class="tabs"><a href="'.h(ME.'edit='.urlencode($a).$N).'">'.lang(38)."</a>\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$Yf){$H=array();foreach(get_rows("SELECT TABLE_NAME, CONSTRAINT_NAME, COLUMN_NAME, REFERENCED_COLUMN_NAME
FROM information_schema.KEY_COLUMN_USAGE
WHERE TABLE_SCHEMA = ".q($this->database())."
AND REFERENCED_TABLE_SCHEMA = ".q($this->database())."
AND REFERENCED_TABLE_NAME = ".q($Q)."
ORDER BY ORDINAL_POSITION",null,"")as$I)$H[$I["TABLE_NAME"]]["keys"][$I["CONSTRAINT_NAME"]][$I["COLUMN_NAME"]]=$I["REFERENCED_COLUMN_NAME"];foreach($H
as$y=>$X){$B=$this->tableName(table_status($y,true));if($B!=""){$uf=preg_quote($Yf);$L="(:|\\s*-)?\\s+";$H[$y]["name"]=(preg_match("(^$uf$L(.+)|^(.+?)$L$uf\$)iu",$B,$A)?$A[2].$A[3]:$B);}else
unset($H[$y]);}return$H;}function
backwardKeysPrint($Ia,$I){foreach($Ia
as$Q=>$Ha){foreach($Ha["keys"]as$db){$_=ME.'select='.urlencode($Q);$s=0;foreach($db
as$e=>$X)$_.=where_link($s++,$e,$I[$X]);echo"<a href='".h($_)."'>".h($Ha["name"])."</a>";$_=ME.'edit='.urlencode($Q);foreach($db
as$e=>$X)$_.="&set".urlencode("[".bracket_escape($e)."]")."=".urlencode($I[$X]);echo"<a href='".h($_)."' title='".lang(38)."'>+</a> ";}}}function
selectQuery($F,$Qf,$mc=false){return"<!--\n".str_replace("--","--><!-- ",$F)."\n(".format_time($Qf).")\n-->\n";}function
rowDescription($Q){foreach(fields($Q)as$o){if(preg_match("~varchar|character varying~",$o["type"]))return
idf_escape($o["field"]);}return"";}function
rowDescriptions($J,$Bc){$H=$J;foreach($J[0]as$y=>$X){if(list($Q,$t,$B)=$this->_foreignColumn($Bc,$y)){$Zc=array();foreach($J
as$I)$Zc[$I[$y]]=q($I[$y]);$Gb=$this->_values[$Q];if(!$Gb)$Gb=get_key_vals("SELECT $t, $B FROM ".table($Q)." WHERE $t IN (".implode(", ",$Zc).")");foreach($J
as$Zd=>$I){if(isset($I[$y]))$H[$Zd][$y]=(string)$Gb[$I[$y]];}}}return$H;}function
selectLink($X,$o){}function
selectVal($X,$_,$o,$we){$H=$X;$_=h($_);if(preg_match('~blob|bytea~',$o["type"])&&!is_utf8($X)){$H=lang(39,strlen($we));if(preg_match("~^(GIF|\xFF\xD8\xFF|\x89PNG\x0D\x0A\x1A\x0A)~",$we))$H="<img src='$_' alt='$H'>";}if(like_bool($o)&&$H!="")$H=(preg_match('~^(1|t|true|y|yes|on)$~i',$X)?lang(40):lang(41));if($_)$H="<a href='$_'".(is_url($_)?target_blank():"").">$H</a>";if(!$_&&!like_bool($o)&&preg_match(number_type(),$o["type"]))$H="<div class='number'>$H</div>";elseif(preg_match('~date~',$o["type"]))$H="<div class='datetime'>$H</div>";return$H;}function
editVal($X,$o){if(preg_match('~date|timestamp~',$o["type"])&&$X!==null)return
preg_replace('~^(\d{2}(\d+))-(0?(\d+))-(0?(\d+))~',lang(42),$X);return$X;}function
selectColumnsPrint($K,$f){}function
selectSearchPrint($Z,$f,$w){$Z=(array)$_GET["where"];echo'<fieldset id="fieldset-search"><legend>'.lang(43)."</legend><div>\n";$ud=array();foreach($Z
as$y=>$X)$ud[$X["col"]]=$y;$s=0;$p=fields($_GET["select"]);foreach($f
as$B=>$Fb){$o=$p[$B];if(preg_match("~enum~",$o["type"])||like_bool($o)){$y=$ud[$B];$s--;echo"<div>".h($Fb)."<input type='hidden' name='where[$s][col]' value='".h($B)."'>:",(like_bool($o)?" <select name='where[$s][val]'>".optionlist(array(""=>"",lang(41),lang(40)),$Z[$y]["val"],true)."</select>":enum_input("checkbox"," name='where[$s][val][]'",$o,(array)$Z[$y]["val"],($o["null"]?0:null))),"</div>\n";unset($f[$B]);}elseif(is_array($C=$this->_foreignKeyOptions($_GET["select"],$B))){if($p[$B]["null"])$C[0]='('.lang(7).')';$y=$ud[$B];$s--;echo"<div>".h($Fb)."<input type='hidden' name='where[$s][col]' value='".h($B)."'><input type='hidden' name='where[$s][op]' value='='>: <select name='where[$s][val]'>".optionlist($C,$Z[$y]["val"],true)."</select></div>\n";unset($f[$B]);}}$s=0;foreach($Z
as$X){if(($X["col"]==""||$f[$X["col"]])&&"$X[col]$X[val]"!=""){echo"<div><select name='where[$s][col]'><option value=''>(".lang(44).")".optionlist($f,$X["col"],true)."</select>",html_select("where[$s][op]",array(-1=>"")+$this->operators,$X["op"]),"<input type='search' name='where[$s][val]' value='".h($X["val"])."'>".script("mixin(qsl('input'), {onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});","")."</div>\n";$s++;}}echo"<div><select name='where[$s][col]'><option value=''>(".lang(44).")".optionlist($f,null,true)."</select>",script("qsl('select').onchange = selectAddRow;",""),html_select("where[$s][op]",array(-1=>"")+$this->operators),"<input type='search' name='where[$s][val]'></div>",script("mixin(qsl('input'), {onchange: function () { this.parentNode.firstChild.onchange(); }, onsearch: selectSearchSearch});"),"</div></fieldset>\n";}function
selectOrderPrint($se,$f,$w){$te=array();foreach($w
as$y=>$v){$se=array();foreach($v["columns"]as$X)$se[]=$f[$X];if(count(array_filter($se,'strlen'))>1&&$y!="PRIMARY")$te[$y]=implode(", ",$se);}if($te){echo'<fieldset><legend>'.lang(45)."</legend><div>","<select name='index_order'>".optionlist(array(""=>"")+$te,($_GET["order"][0]!=""?"":$_GET["index_order"]),true)."</select>","</div></fieldset>\n";}if($_GET["order"])echo"<div style='display: none;'>".hidden_fields(array("order"=>array(1=>reset($_GET["order"])),"desc"=>($_GET["desc"]?array(1=>1):array()),))."</div>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(46)."</legend><div>";echo
html_select("limit",array("","50","100"),$z),"</div></fieldset>\n";}function
selectLengthPrint($hg){}function
selectActionPrint($w){echo"<fieldset><legend>".lang(47)."</legend><div>","<input type='submit' value='".lang(48)."'>","</div></fieldset>\n";}function
selectCommandPrint(){return
true;}function
selectImportPrint(){return
true;}function
selectEmailPrint($Vb,$f){if($Vb){print_fieldset("email",lang(49),$_POST["email_append"]);echo"<div>",script("qsl('div').onkeydown = partialArg(bodyKeydown, 'email');"),"<p>".lang(50).": <input name='email_from' value='".h($_POST?$_POST["email_from"]:$_COOKIE["adminer_email"])."'>\n",lang(51).": <input name='email_subject' value='".h($_POST["email_subject"])."'>\n","<p><textarea name='email_message' rows='15' cols='75'>".h($_POST["email_message"].($_POST["email_append"]?'{$'."$_POST[email_addition]}":""))."</textarea>\n","<p>".script("qsl('p').onkeydown = partialArg(bodyKeydown, 'email_append');","").html_select("email_addition",$f,$_POST["email_addition"])."<input type='submit' name='email_append' value='".lang(11)."'>\n";echo"<p>".lang(52).": <input type='file' name='email_files[]'>".script("qsl('input').onchange = emailFileChange;"),"<p>".(count($Vb)==1?'<input type="hidden" name="email_field" value="'.h(key($Vb)).'">':html_select("email_field",$Vb)),"<input type='submit' name='email' value='".lang(53)."'>".confirm(),"</div>\n","</div></fieldset>\n";}}function
selectColumnsProcess($f,$w){return
array(array(),array());}function
selectSearchProcess($p,$w){global$m;$H=array();foreach((array)$_GET["where"]as$y=>$Z){$ab=$Z["col"];$ne=$Z["op"];$X=$Z["val"];if(($y<0?"":$ab).$X!=""){$ib=array();foreach(($ab!=""?array($ab=>$p[$ab]):$p)as$B=>$o){if($ab!=""||is_numeric($X)||!preg_match(number_type(),$o["type"])){$B=idf_escape($B);if($ab!=""&&$o["type"]=="enum")$ib[]=(in_array(0,$X)?"$B IS NULL OR ":"")."$B IN (".implode(", ",array_map('intval',$X)).")";else{$ig=preg_match('~char|text|enum|set~',$o["type"]);$Y=$this->processInput($o,(!$ne&&$ig&&preg_match('~^[^%]+$~',$X)?"%$X%":$X));$ib[]=$m->convertSearch($B,$X,$o).($Y=="NULL"?" IS".($ne==">="?" NOT":"")." $Y":(in_array($ne,$this->operators)||$ne=="="?" $ne $Y":($ig?" LIKE $Y":" IN (".str_replace(",","', '",$Y).")")));if($y<0&&$X=="0")$ib[]="$B IS NULL";}}}$H[]=($ib?"(".implode(" OR ",$ib).")":"1 = 0");}}return$H;}function
selectOrderProcess($p,$w){$cd=$_GET["index_order"];if($cd!="")unset($_GET["order"][1]);if($_GET["order"])return
array(idf_escape(reset($_GET["order"])).($_GET["desc"]?" DESC":""));foreach(($cd!=""?array($w[$cd]):$w)as$v){if($cd!=""||$v["type"]=="INDEX"){$Oc=array_filter($v["descs"]);$Fb=false;foreach($v["columns"]as$X){if(preg_match('~date|timestamp~',$p[$X]["type"])){$Fb=true;break;}}$H=array();foreach($v["columns"]as$y=>$X)$H[]=idf_escape($X).(($Oc?$v["descs"][$y]:$Fb)?" DESC":"");return$H;}}return
array();}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return"100";}function
selectEmailProcess($Z,$Bc){if($_POST["email_append"])return
true;if($_POST["email"]){$yf=0;if($_POST["all"]||$_POST["check"]){$o=idf_escape($_POST["email_field"]);$Vf=$_POST["email_subject"];$Td=$_POST["email_message"];preg_match_all('~\{\$([a-z0-9_]+)\}~i',"$Vf.$Td",$Nd);$J=get_rows("SELECT DISTINCT $o".($Nd[1]?", ".implode(", ",array_map('idf_escape',array_unique($Nd[1]))):"")." FROM ".table($_GET["select"])." WHERE $o IS NOT NULL AND $o != ''".($Z?" AND ".implode(" AND ",$Z):"").($_POST["all"]?"":" AND ((".implode(") OR (",array_map('where_check',(array)$_POST["check"]))."))"));$p=fields($_GET["select"]);foreach($this->rowDescriptions($J,$Bc)as$I){$if=array('{\\'=>'{');foreach($Nd[1]as$X)$if['{$'."$X}"]=$this->editVal($I[$X],$p[$X]);$Ub=$I[$_POST["email_field"]];if(is_mail($Ub)&&send_mail($Ub,strtr($Vf,$if),strtr($Td,$if),$_POST["email_from"],$_FILES["email_files"]))$yf++;}}cookie("adminer_email",$_POST["email_from"]);redirect(remove_from_uri(),lang(54,$yf));}return
false;}function
selectQueryBuild($K,$Z,$Jc,$se,$z,$D){return"";}function
messageQuery($F,$jg,$mc=false){return" <span class='time'>".@date("H:i:s")."</span><!--\n".str_replace("--","--><!-- ",$F)."\n".($jg?"($jg)\n":"")."-->";}function
editRowPrint($Q,$p,$I,$Kg){}function
editFunctions($o){$H=array();if($o["null"]&&preg_match('~blob~',$o["type"]))$H["NULL"]=lang(7);$H[""]=($o["null"]||$o["auto_increment"]||like_bool($o)?"":"*");if(preg_match('~date|time~',$o["type"]))$H["now"]=lang(55);if(preg_match('~_(md5|sha1)$~i',$o["field"],$A))$H[]=strtolower($A[1]);return$H;}function
editInput($Q,$o,$Ba,$Y){if($o["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Ba value='-1' checked><i>".lang(8)."</i></label> ":"").enum_input("radio",$Ba,$o,($Y||isset($_GET["select"])?$Y:0),($o["null"]?"":null));$C=$this->_foreignKeyOptions($Q,$o["field"],$Y);if($C!==null)return(is_array($C)?"<select$Ba>".optionlist($C,$Y,true)."</select>":"<input value='".h($Y)."'$Ba class='hidden'>"."<input value='".h($C)."' class='jsonly'>"."<div></div>".script("qsl('input').oninput = partial(whisper, '".ME."script=complete&source=".urlencode($Q)."&field=".urlencode($o["field"])."&value=');
qsl('div').onclick = whisperClick;",""));if(like_bool($o))return'<input type="checkbox" value="1"'.(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?' checked':'')."$Ba>";$Uc="";if(preg_match('~time~',$o["type"]))$Uc=lang(56);if(preg_match('~date|timestamp~',$o["type"]))$Uc=lang(57).($Uc?" [$Uc]":"");if($Uc)return"<input value='".h($Y)."'$Ba> ($Uc)";if(preg_match('~_(md5|sha1)$~i',$o["field"]))return"<input type='password' value='".h($Y)."'$Ba>";return'';}function
editHint($Q,$o,$Y){return(preg_match('~\s+(\[.*\])$~',($o["comment"]!=""?$o["comment"]:$o["field"]),$A)?h(" $A[1]"):'');}function
processInput($o,$Y,$r=""){if($r=="now")return"$r()";$H=$Y;if(preg_match('~date|timestamp~',$o["type"])&&preg_match('(^'.str_replace('\$1','(?P<p1>\d*)',preg_replace('~(\\\\\\$([2-6]))~','(?P<p\2>\d{1,2})',preg_quote(lang(42)))).'(.*))',$Y,$A))$H=($A["p1"]!=""?$A["p1"]:($A["p2"]!=""?($A["p2"]<70?20:19).$A["p2"]:gmdate("Y")))."-$A[p3]$A[p4]-$A[p5]$A[p6]".end($A);$H=($o["type"]=="bit"&&preg_match('~^[0-9]+$~',$Y)?$H:q($H));if($Y==""&&like_bool($o))$H="'0'";elseif($Y==""&&($o["null"]||!preg_match('~char|text~',$o["type"])))$H="NULL";elseif(preg_match('~^(md5|sha1)$~',$r))$H="$r($H)";return
unconvert_field($o,$H);}function
dumpOutput(){return
array();}function
dumpFormat(){return
array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($l){}function
dumpTable($Q,$Uf,$qd=0){echo"\xef\xbb\xbf";}function
dumpData($Q,$Uf,$F){global$h;$G=$h->query($F,1);if($G){while($I=$G->fetch_assoc()){if($Uf=="table"){dump_csv(array_keys($I));$Uf="INSERT";}dump_csv($I);}}}function
dumpFilename($Yc){return
friendly_url($Yc);}function
dumpHeaders($Yc,$Xd=false){$ic="csv";header("Content-Type: text/csv; charset=utf-8");return$ic;}function
importServerPath(){}function
homepage(){return
true;}function
navigation($Wd){global$ca;echo'<h1>
',$this->name(),' <span class="version">',$ca,'</span>
<a href="https://www.adminer.org/editor/#download"',target_blank(),' id="version">',(version_compare($ca,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($Wd=="auth"){$uc=true;foreach((array)$_SESSION["pwds"]as$Sg=>$Cf){foreach($Cf[""]as$V=>$E){if($E!==null){if($uc){echo"<ul id='logins'>",script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");$uc=false;}echo"<li><a href='".h(auth_url($Sg,"",$V))."'>".($V!=""?h($V):"<i>".lang(7)."</i>")."</a>\n";}}}}else{$this->databasesPrint($Wd);if($Wd!="db"&&$Wd!="ns"){$R=table_status('',true);if(!$R)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($R);}}}function
databasesPrint($Wd){}function
tablesPrint($S){echo"<ul id='tables'>",script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$I){echo'<li>';$B=$this->tableName($I);if(isset($I["Engine"])&&$B!="")echo"<a href='".h(ME).'select='.urlencode($I["Name"])."'".bold($_GET["select"]==$I["Name"]||$_GET["edit"]==$I["Name"],"select")." title='".lang(58)."'>$B</a>\n";}echo"</ul>\n";}function
_foreignColumn($Bc,$e){foreach((array)$Bc[$e]as$Ac){if(count($Ac["source"])==1){$B=$this->rowDescription($Ac["table"]);if($B!=""){$t=idf_escape($Ac["target"][0]);return
array($Ac["table"],$t,$B);}}}}function
_foreignKeyOptions($Q,$e,$Y=null){global$h;if(list($dg,$t,$B)=$this->_foreignColumn(column_foreign_keys($Q),$e)){$H=&$this->_values[$dg];if($H===null){$R=table_status($dg);$H=($R["Rows"]>1000?"":array(""=>"")+get_key_vals("SELECT $t, $B FROM ".table($dg)." ORDER BY 2"));}if(!$H&&$Y!==null)return$h->result("SELECT $B FROM ".table($dg)." WHERE $t = ".q($Y));return$H;}}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$Mb=array("server"=>"MySQL")+$Mb;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($M="",$V="",$E="",$j=null,$Le=null,$If=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Wc,$Le)=explode(":",$M,2);$Pf=$b->connectSsl();if($Pf)$this->ssl_set($Pf['key'],$Pf['cert'],$Pf['ca'],'','');$H=@$this->real_connect(($M!=""?$Wc:ini_get("mysqli.default_host")),($M.$V!=""?$V:ini_get("mysqli.default_user")),($M.$V.$E!=""?$E:ini_get("mysqli.default_pw")),$j,(is_numeric($Le)?$Le:ini_get("mysqli.default_port")),(!is_numeric($Le)?$Le:$If),($Pf?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$H;}function
set_charset($Ra){if(parent::set_charset($Ra))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ra");}function
result($F,$o=0){$G=$this->query($F);if(!$G)return
false;$I=$G->fetch_array();return$I[$o];}function
quote($P){return"'".$this->escape_string($P)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($M,$V,$E){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(59,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($M!=""?$M:ini_get("mysql.default_host")),("$M$V"!=""?$V:ini_get("mysql.default_user")),("$M$V$E"!=""?$E:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($Ra){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ra,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $Ra");}function
quote($P){return"'".mysql_real_escape_string($P,$this->_link)."'";}function
select_db($j){return
mysql_select_db($j,$this->_link);}function
query($F,$Dg=false){$G=@($Dg?mysql_unbuffered_query($F,$this->_link):mysql_query($F,$this->_link));$this->error="";if(!$G){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($G===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($G);}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$o=0){$G=$this->query($F);if(!$G||!$G->num_rows)return
false;return
mysql_result($G->_result,0,$o);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($G){$this->_result=$G;$this->num_rows=mysql_num_rows($G);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$H=mysql_fetch_field($this->_result,$this->_offset++);$H->orgtable=$H->table;$H->orgname=$H->name;$H->charsetnr=($H->blob?63:0);return$H;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($M,$V,$E){global$b;$C=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Pf=$b->connectSsl();if($Pf){if(!empty($Pf['key']))$C[PDO::MYSQL_ATTR_SSL_KEY]=$Pf['key'];if(!empty($Pf['cert']))$C[PDO::MYSQL_ATTR_SSL_CERT]=$Pf['cert'];if(!empty($Pf['ca']))$C[PDO::MYSQL_ATTR_SSL_CA]=$Pf['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$E,$C);return
true;}function
set_charset($Ra){$this->query("SET NAMES $Ra");}function
select_db($j){return$this->query("USE ".idf_escape($j));}function
query($F,$Dg=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Dg);return
parent::query($F,$Dg);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$N){return($N?parent::insert($Q,$N):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$J,$Pe){$f=array_keys(reset($J));$Oe="INSERT INTO ".table($Q)." (".implode(", ",$f).") VALUES\n";$Rg=array();foreach($f
as$y)$Rg[$y]="$y = VALUES($y)";$Wf="\nON DUPLICATE KEY UPDATE ".implode(", ",$Rg);$Rg=array();$Cd=0;foreach($J
as$N){$Y="(".implode(", ",$N).")";if($Rg&&(strlen($Oe)+$Cd+strlen($Y)+strlen($Wf)>1e6)){if(!queries($Oe.implode(",\n",$Rg).$Wf))return
false;$Rg=array();$Cd=0;}$Rg[]=$Y;$Cd+=strlen($Y)+2;}return
queries($Oe.implode(",\n",$Rg).$Wf);}function
slowQuery($F,$kg){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$kg FOR $F";elseif(preg_match('~^(SELECT\b)(.+)~is',$F,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($kg*1000).") */ $A[2]";}}function
convertSearch($u,$X,$o){return(preg_match('~char|text|enum|set~',$o["type"])&&!preg_match("~^utf8~",$o["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($u USING ".charset($this->_conn).")":$u);}function
warnings(){$G=$this->_conn->query("SHOW WARNINGS");if($G&&$G->num_rows){ob_start();select($G);return
ob_get_clean();}}function
tableHelp($B){$Kd=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Kd?"information-schema-$B-table/":str_replace("_","-",$B)."-table.html"));if(DB=="mysql")return($Kd?"mysql$B-table/":"system-database.html");}}function
idf_escape($u){return"`".str_replace("`","``",$u)."`";}function
table($u){return
idf_escape($u);}function
connect(){global$b,$U,$Tf;$h=new
Min_DB;$wb=$b->credentials();if($h->connect($wb[0],$wb[1],$wb[2])){$h->set_charset(charset($h));$h->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$h)){$Tf[lang(25)][]="json";$U["json"]=4294967295;}return$h;}$H=$h->error;if(function_exists('iconv')&&!is_utf8($H)&&strlen($rf=iconv("windows-1250","utf-8",$H))>strlen($H))$H=$rf;return$H;}function
get_databases($yc){$H=get_session("dbs");if($H===null){$F=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$H=($yc?slow_query($F):get_vals($F));restart_session();set_session("dbs",$H);stop_session();}return$H;}function
limit($F,$Z,$z,$he=0,$L=" "){return" $F$Z".($z!==null?$L."LIMIT $z".($he?" OFFSET $he":""):"");}function
limit1($Q,$F,$Z,$L="\n"){return
limit($F,$Z,1,0,$L);}function
db_collation($l,$bb){global$h;$H=null;$ub=$h->result("SHOW CREATE DATABASE ".idf_escape($l),1);if(preg_match('~ COLLATE ([^ ]+)~',$ub,$A))$H=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$ub,$A))$H=$bb[$A[1]][-1];return$H;}function
engines(){$H=array();foreach(get_rows("SHOW ENGINES")as$I){if(preg_match("~YES|DEFAULT~",$I["Support"]))$H[]=$I["Engine"];}return$H;}function
logged_user(){global$h;return$h->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($k){$H=array();foreach($k
as$l)$H[$l]=count(get_vals("SHOW TABLES IN ".idf_escape($l)));return$H;}function
table_status($B="",$nc=false){$H=array();foreach(get_rows($nc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($B!=""?"AND TABLE_NAME = ".q($B):"ORDER BY Name"):"SHOW TABLE STATUS".($B!=""?" LIKE ".q(addcslashes($B,"%_\\")):""))as$I){if($I["Engine"]=="InnoDB")$I["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$I["Comment"]);if(!isset($I["Engine"]))$I["Comment"]="";if($B!="")return$I;$H[$I["Name"]]=$I;}return$H;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$H=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$I){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$I["Type"],$A);$H[$I["Field"]]=array("field"=>$I["Field"],"full_type"=>$I["Type"],"type"=>$A[1],"length"=>$A[2],"unsigned"=>ltrim($A[3].$A[4]),"default"=>($I["Default"]!=""||preg_match("~char|set~",$A[1])?(preg_match('~text~',$A[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$I["Default"])):$I["Default"]):null),"null"=>($I["Null"]=="YES"),"auto_increment"=>($I["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$I["Extra"],$A)?$A[1]:""),"collation"=>$I["Collation"],"privileges"=>array_flip(preg_split('~, *~',$I["Privileges"])),"comment"=>$I["Comment"],"primary"=>($I["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$I["Extra"]),);}return$H;}function
indexes($Q,$i=null){$H=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$i)as$I){$B=$I["Key_name"];$H[$B]["type"]=($B=="PRIMARY"?"PRIMARY":($I["Index_type"]=="FULLTEXT"?"FULLTEXT":($I["Non_unique"]?($I["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$H[$B]["columns"][]=$I["Column_name"];$H[$B]["lengths"][]=($I["Index_type"]=="SPATIAL"?null:$I["Sub_part"]);$H[$B]["descs"][]=null;}return$H;}function
foreign_keys($Q){global$h,$ke;static$He='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$H=array();$vb=$h->result("SHOW CREATE TABLE ".table($Q),1);if($vb){preg_match_all("~CONSTRAINT ($He) FOREIGN KEY ?\\(((?:$He,? ?)+)\\) REFERENCES ($He)(?:\\.($He))? \\(((?:$He,? ?)+)\\)(?: ON DELETE ($ke))?(?: ON UPDATE ($ke))?~",$vb,$Nd,PREG_SET_ORDER);foreach($Nd
as$A){preg_match_all("~$He~",$A[2],$Kf);preg_match_all("~$He~",$A[5],$dg);$H[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('idf_unescape',$Kf[0]),"target"=>array_map('idf_unescape',$dg[0]),"on_delete"=>($A[6]?$A[6]:"RESTRICT"),"on_update"=>($A[7]?$A[7]:"RESTRICT"),);}}return$H;}function
view($B){global$h;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$h->result("SHOW CREATE VIEW ".table($B),1)));}function
collations(){$H=array();foreach(get_rows("SHOW COLLATION")as$I){if($I["Default"])$H[$I["Charset"]][-1]=$I["Collation"];else$H[$I["Charset"]][]=$I["Collation"];}ksort($H);foreach($H
as$y=>$X)asort($H[$y]);return$H;}function
information_schema($l){return(min_version(5)&&$l=="information_schema")||(min_version(5.5)&&$l=="performance_schema");}function
error(){global$h;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$h->error));}function
create_database($l,$d){return
queries("CREATE DATABASE ".idf_escape($l).($d?" COLLATE ".q($d):""));}function
drop_databases($k){$H=apply_queries("DROP DATABASE",$k,'idf_escape');restart_session();set_session("dbs",null);return$H;}function
rename_database($B,$d){$H=false;if(create_database($B,$d)){$S=array();$Vg=array();foreach(tables_list()as$Q=>$T){if($T=='VIEW')$Vg[]=$Q;else$S[]=$Q;}$H=(!$S&&!$Vg)||move_tables($S,$Vg,$B);drop_databases($H?array(DB):array());}return$H;}function
auto_increment(){$Fa=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$v){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$v["columns"],true)){$Fa="";break;}if($v["type"]=="PRIMARY")$Fa=" UNIQUE";}}return" AUTO_INCREMENT$Fa";}function
alter_table($Q,$B,$p,$_c,$gb,$Yb,$d,$Ea,$Ee){$c=array();foreach($p
as$o)$c[]=($o[1]?($Q!=""?($o[0]!=""?"CHANGE ".idf_escape($o[0]):"ADD"):" ")." ".implode($o[1]).($Q!=""?$o[2]:""):"DROP ".idf_escape($o[0]));$c=array_merge($c,$_c);$O=($gb!==null?" COMMENT=".q($gb):"").($Yb?" ENGINE=".q($Yb):"").($d?" COLLATE ".q($d):"").($Ea!=""?" AUTO_INCREMENT=$Ea":"");if($Q=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$c)."\n)$O$Ee");if($Q!=$B)$c[]="RENAME TO ".table($B);if($O)$c[]=ltrim($O);return($c||$Ee?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$c).$Ee):true);}function
alter_indexes($Q,$c){foreach($c
as$y=>$X)$c[$y]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$c));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($Vg){return
queries("DROP VIEW ".implode(", ",array_map('table',$Vg)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$Vg,$dg){global$h;$hf=array();foreach($S
as$Q)$hf[]=table($Q)." TO ".idf_escape($dg).".".table($Q);if(!$hf||queries("RENAME TABLE ".implode(", ",$hf))){$Eb=array();foreach($Vg
as$Q)$Eb[table($Q)]=view($Q);$h->select_db($dg);$l=idf_escape(DB);foreach($Eb
as$B=>$Ug){if(!queries("CREATE VIEW $B AS ".str_replace(" $l."," ",$Ug["select"]))||!queries("DROP VIEW $l.$B"))return
false;}return
true;}return
false;}function
copy_tables($S,$Vg,$dg){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$B=($dg==DB?table("copy_$Q"):idf_escape($dg).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $B"))||!queries("CREATE TABLE $B LIKE ".table($Q))||!queries("INSERT INTO $B SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$I){$zg=$I["Trigger"];if(!queries("CREATE TRIGGER ".($dg==DB?idf_escape("copy_$zg"):idf_escape($dg).".".idf_escape($zg))." $I[Timing] $I[Event] ON $B FOR EACH ROW\n$I[Statement];"))return
false;}}foreach($Vg
as$Q){$B=($dg==DB?table("copy_$Q"):idf_escape($dg).".".table($Q));$Ug=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $B"))||!queries("CREATE VIEW $B AS $Ug[select]"))return
false;}return
true;}function
trigger($B){if($B=="")return
array();$J=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($B));return
reset($J);}function
triggers($Q){$H=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$I)$H[$I["Trigger"]]=array($I["Timing"],$I["Event"]);return$H;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($B,$T){global$h,$Zb,$kd,$U;$wa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Lf="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Cg="((".implode("|",array_merge(array_keys($U),$wa)).")\\b(?:\\s*\\(((?:[^'\")]|$Zb)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$He="$Lf*(".($T=="FUNCTION"?"":$kd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Cg";$ub=$h->result("SHOW CREATE $T ".idf_escape($B),2);preg_match("~\\(((?:$He\\s*,?)*)\\)\\s*".($T=="FUNCTION"?"RETURNS\\s+$Cg\\s+":"")."(.*)~is",$ub,$A);$p=array();preg_match_all("~$He\\s*,?~is",$A[1],$Nd,PREG_SET_ORDER);foreach($Nd
as$Be)$p[]=array("field"=>str_replace("``","`",$Be[2]).$Be[3],"type"=>strtolower($Be[5]),"length"=>preg_replace_callback("~$Zb~s",'normalize_enum',$Be[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Be[8] $Be[7]"))),"null"=>1,"full_type"=>$Be[4],"inout"=>strtoupper($Be[1]),"collation"=>strtolower($Be[9]),);if($T!="FUNCTION")return
array("fields"=>$p,"definition"=>$A[11]);return
array("fields"=>$p,"returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($B,$I){return
idf_escape($B);}function
last_id(){global$h;return$h->result("SELECT LAST_INSERT_ID()");}function
explain($h,$F){return$h->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$F);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($sf,$i=null){return
true;}function
create_sql($Q,$Ea,$Uf){global$h;$H=$h->result("SHOW CREATE TABLE ".table($Q),1);if(!$Ea)$H=preg_replace('~ AUTO_INCREMENT=\d+~','',$H);return$H;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($j){return"USE ".idf_escape($j);}function
trigger_sql($Q){$H="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$I)$H.="\nCREATE TRIGGER ".idf_escape($I["Trigger"])." $I[Timing] $I[Event] ON ".table($I["Table"])." FOR EACH ROW\n$I[Statement];;\n";return$H;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($o){if(preg_match("~binary~",$o["type"]))return"HEX(".idf_escape($o["field"]).")";if($o["type"]=="bit")return"BIN(".idf_escape($o["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$o["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($o["field"]).")";}function
unconvert_field($o,$H){if(preg_match("~binary~",$o["type"]))$H="UNHEX($H)";if($o["type"]=="bit")$H="CONV($H, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$o["type"]))$H=(min_version(8)?"ST_":"")."GeomFromText($H, SRID($o[field]))";return$H;}function
support($oc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$oc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$h;return$h->result("SELECT @@max_connections");}function
driver_config(){$U=array();$Tf=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(60)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$y=>$X){$U+=$X;$Tf[$y]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$U,'structured_types'=>$Tf,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$jb=driver_config();$Ne=$jb['possible_drivers'];$x=$jb['jush'];$U=$jb['types'];$Tf=$jb['structured_types'];$Jg=$jb['unsigned'];$pe=$jb['operators'];$Ic=$jb['functions'];$Mc=$jb['grouping'];$Rb=$jb['edit_functions'];if($b->operators===null)$b->operators=$pe;define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ca="4.8.1";function
page_header($mg,$n="",$Pa=array(),$ng=""){global$ba,$ca,$b,$Mb,$x;page_headers();if(is_ajax()&&$n){page_messages($n);exit;}$og=$mg.($ng!=""?": $ng":"");$pg=strip_tags($og.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ba,'" dir="',lang(61),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$pg,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.1"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.1");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.1"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.1"),'">
';foreach($b->css()as$yb){echo'<link rel="stylesheet" type="text/css" href="',h($yb),'">
';}}echo'
<body class="',lang(61),' nojs">
';$q=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($q)&&filemtime($q)+86400>time()){$Tg=unserialize(file_get_contents($q));$Ve="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Tg["version"],base64_decode($Tg["signature"]),$Ve)==1)$_COOKIE["adminer_version"]=$Tg["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ca', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(62)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$x,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Pa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?$_:".").'">'.$Mb[DRIVER].'</a> &raquo; ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$M=$b->serverName(SERVER);$M=($M!=""?$M:lang(63));if($Pa===false)echo"$M\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$M</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Pa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Pa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Pa
as$y=>$X){$Fb=(is_array($X)?$X[1]:h($X));if($Fb!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Fb</a> &raquo; ";}}echo"$mg\n";}}echo"<h2>$og</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($n);$k=&get_session("dbs");if(DB!=""&&$k&&!in_array(DB,$k,true))$k=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$xb){$Rc=array();foreach($xb
as$y=>$X)$Rc[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Rc));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$de;if(!$de)$de=base64_encode(rand_string());return$de;}function
page_messages($n){$Lg=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Ud=$_SESSION["messages"][$Lg];if($Ud){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Ud)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Lg]);}if($n)echo"<div class='error'>$n</div>\n";}function
page_footer($Wd=""){global$b,$sg;echo'</div>

';switch_lang();if($Wd!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(64),'" id="logout">
<input type="hidden" name="token" value="',$sg,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($Wd);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($Zd){while($Zd>=2147483648)$Zd-=4294967296;while($Zd<=-2147483649)$Zd+=4294967296;return(int)$Zd;}function
long2str($W,$Xg){$rf='';foreach($W
as$X)$rf.=pack('V',$X);if($Xg)return
substr($rf,0,end($W));return$rf;}function
str2long($rf,$Xg){$W=array_values(unpack('V*',str_pad($rf,4*ceil(strlen($rf)/4),"\0")));if($Xg)$W[]=strlen($rf);return$W;}function
xxtea_mx($hh,$gh,$Xf,$sd){return
int32((($hh>>5&0x7FFFFFF)^$gh<<2)+(($gh>>3&0x1FFFFFFF)^$hh<<4))^int32(($Xf^$gh)+($sd^$hh));}function
encrypt_string($Sf,$y){if($Sf=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Sf,true);$Zd=count($W)-1;$hh=$W[$Zd];$gh=$W[0];$We=floor(6+52/($Zd+1));$Xf=0;while($We-->0){$Xf=int32($Xf+0x9E3779B9);$Qb=$Xf>>2&3;for($_e=0;$_e<$Zd;$_e++){$gh=$W[$_e+1];$Yd=xxtea_mx($hh,$gh,$Xf,$y[$_e&3^$Qb]);$hh=int32($W[$_e]+$Yd);$W[$_e]=$hh;}$gh=$W[0];$Yd=xxtea_mx($hh,$gh,$Xf,$y[$_e&3^$Qb]);$hh=int32($W[$Zd]+$Yd);$W[$Zd]=$hh;}return
long2str($W,false);}function
decrypt_string($Sf,$y){if($Sf=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Sf,false);$Zd=count($W)-1;$hh=$W[$Zd];$gh=$W[0];$We=floor(6+52/($Zd+1));$Xf=int32($We*0x9E3779B9);while($Xf){$Qb=$Xf>>2&3;for($_e=$Zd;$_e>0;$_e--){$hh=$W[$_e-1];$Yd=xxtea_mx($hh,$gh,$Xf,$y[$_e&3^$Qb]);$gh=int32($W[$_e]-$Yd);$W[$_e]=$gh;}$hh=$W[$Zd];$Yd=xxtea_mx($hh,$gh,$Xf,$y[$_e&3^$Qb]);$gh=int32($W[0]-$Yd);$W[0]=$gh;$Xf=int32($Xf-0x9E3779B9);}return
long2str($W,true);}$h='';$Qc=$_SESSION["token"];if(!$Qc)$_SESSION["token"]=rand(1,1e6);$sg=get_token();$Je=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Je[$y]=$X;}}function
add_invalid_login(){global$b;$Gc=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$Gc)return;$nd=unserialize(stream_get_contents($Gc));$jg=time();if($nd){foreach($nd
as$od=>$X){if($X[0]<$jg)unset($nd[$od]);}}$md=&$nd[$b->bruteForceKey()];if(!$md)$md=array($jg+30*60,0);$md[1]++;file_write_unlock($Gc,serialize($nd));}function
check_invalid_login(){global$b;$nd=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$md=($nd?$nd[$b->bruteForceKey()]:array());$ce=($md[1]>29?$md[0]-time():0);if($ce>0)auth_error(lang(65,ceil($ce/60)));}$Ca=$_POST["auth"];if($Ca){session_regenerate_id();$Sg=$Ca["driver"];$M=$Ca["server"];$V=$Ca["username"];$E=(string)$Ca["password"];$l=$Ca["db"];set_password($Sg,$M,$V,$E);$_SESSION["db"][$Sg][$M][$V][$l]=true;if($Ca["permanent"]){$y=base64_encode($Sg)."-".base64_encode($M)."-".base64_encode($V)."-".base64_encode($l);$Se=$b->permanentLogin(true);$Je[$y]="$y:".base64_encode($Se?encrypt_string($E,$Se):"");cookie("adminer_permanent",implode(" ",$Je));}if(count($_POST)==1||DRIVER!=$Sg||SERVER!=$M||$_GET["username"]!==$V||DB!=$l)redirect(auth_url($Sg,$M,$V,$l));}elseif($_POST["logout"]&&(!$Qc||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(66).' '.lang(67));}elseif($Je&&!$_SESSION["pwds"]){session_regenerate_id();$Se=$b->permanentLogin();foreach($Je
as$y=>$X){list(,$Wa)=explode(":",$X);list($Sg,$M,$V,$l)=array_map('base64_decode',explode("-",$y));set_password($Sg,$M,$V,decrypt_string(base64_decode($Wa),$Se));$_SESSION["db"][$Sg][$M][$V][$l]=true;}}function
unset_permanent(){global$Je;foreach($Je
as$y=>$X){list($Sg,$M,$V,$l)=array_map('base64_decode',explode("-",$y));if($Sg==DRIVER&&$M==SERVER&&$V==$_GET["username"]&&$l==DB)unset($Je[$y]);}cookie("adminer_permanent",implode(" ",$Je));}function
auth_error($n){global$b,$Qc;$Df=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Df]||$_GET[$Df])&&!$Qc)$n=lang(68);else{restart_session();add_invalid_login();$E=get_password();if($E!==null){if($E===false)$n.=($n?'<br>':'').lang(69,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$Df]&&$_GET[$Df]&&ini_bool("session.use_only_cookies"))$n=lang(70);$Ce=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Ce["lifetime"]);page_header(lang(36),$n,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(71)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(72),lang(73,implode(", ",$Ne)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Wc,$Le)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Le,$A)&&($A[1]<1024||$A[1]>65535))auth_error(lang(74));check_invalid_login();$h=connect();$m=new
Min_Driver($h);}$Hd=null;if(!is_object($h)||($Hd=$b->login($_GET["username"],get_password()))!==true){$n=(is_string($h)?h($h):(is_string($Hd)?$Hd:lang(32)));auth_error($n.(preg_match('~^ | $~',get_password())?'<br>'.lang(75):''));}if($_POST["logout"]&&$Qc&&!verify_token()){page_header(lang(64),lang(76));page_footer("db");exit;}if($Ca&&$_POST["token"])$_POST["token"]=$sg;$n='';if($_POST){if(!verify_token()){$jd="max_input_vars";$Rd=ini_get($jd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Rd||$X<$Rd)){$jd=$y;$Rd=$X;}}}$n=(!$_POST["token"]&&$Rd?lang(77,"'$jd'"):lang(76).' '.lang(78));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$n=lang(79,"'post_max_size'");if(isset($_GET["sql"]))$n.=' '.lang(80);}function
email_header($Rc){return"=?UTF-8?B?".base64_encode($Rc)."?=";}function
send_mail($Ub,$Vf,$Td,$Hc="",$sc=array()){$ac=(DIRECTORY_SEPARATOR=="/"?"\n":"\r\n");$Td=str_replace("\n",$ac,wordwrap(str_replace("\r","","$Td\n")));$Oa=uniqid("boundary");$Aa="";foreach((array)$sc["error"]as$y=>$X){if(!$X)$Aa.="--$Oa$ac"."Content-Type: ".str_replace("\n","",$sc["type"][$y]).$ac."Content-Disposition: attachment; filename=\"".preg_replace('~["\n]~','',$sc["name"][$y])."\"$ac"."Content-Transfer-Encoding: base64$ac$ac".chunk_split(base64_encode(file_get_contents($sc["tmp_name"][$y])),76,$ac).$ac;}$Ka="";$Sc="Content-Type: text/plain; charset=utf-8$ac"."Content-Transfer-Encoding: 8bit";if($Aa){$Aa.="--$Oa--$ac";$Ka="--$Oa$ac$Sc$ac$ac";$Sc="Content-Type: multipart/mixed; boundary=\"$Oa\"";}$Sc.=$ac."MIME-Version: 1.0$ac"."X-Mailer: Adminer Editor".($Hc?$ac."From: ".str_replace("\n","",$Hc):"");return
mail($Ub,email_header($Vf),$Ka.$Td.$Aa,$Sc);}function
like_bool($o){return
preg_match("~bool|(tinyint|bit)\\(1\\)~",$o["full_type"]);}$h->select_db($b->database());$ke="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";$Mb[DRIVER]=lang(36);if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["download"])){$a=$_GET["download"];$p=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$K=array(idf_escape($_GET["field"]));$G=$m->select($a,$K,array(where($_GET,$p)),$K);$I=($G?$G->fetch_row():array());echo$m->value($I[0],$p[$_GET["field"]]);exit;}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$p=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$p):""):where($_GET,$p));$Kg=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($p
as$B=>$o){if(!isset($o["privileges"][$Kg?"update":"insert"])||$b->fieldName($o)==""||$o["generated"])unset($p[$B]);}if($_POST&&!$n&&!isset($_GET["select"])){$Gd=$_POST["referer"];if($_POST["insert"])$Gd=($Kg?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Gd))$Gd=ME."select=".urlencode($a);$w=indexes($a);$Fg=unique_array($_GET["where"],$w);$Ze="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Gd,lang(81),$m->delete($a,$Ze,!$Fg));else{$N=array();foreach($p
as$B=>$o){$X=process_input($o);if($X!==false&&$X!==null)$N[idf_escape($B)]=$X;}if($Kg){if(!$N)redirect($Gd);queries_redirect($Gd,lang(82),$m->update($a,$N,$Ze,!$Fg));if(is_ajax()){page_headers();page_messages($n);exit;}}else{$G=$m->insert($a,$N);$Ad=($G?last_id():0);queries_redirect($Gd,lang(83,($Ad?" $Ad":"")),$G);}}}$I=null;if($_POST["save"])$I=(array)$_POST["fields"];elseif($Z){$K=array();foreach($p
as$B=>$o){if(isset($o["privileges"]["select"])){$za=convert_field($o);if($_POST["clone"]&&$o["auto_increment"])$za="''";if($x=="sql"&&preg_match("~enum|set~",$o["type"]))$za="1*".idf_escape($B);$K[]=($za?"$za AS ":"").idf_escape($B);}}$I=array();if(!support("table"))$K=array("*");if($K){$G=$m->select($a,$K,array($Z),$K,array(),(isset($_GET["select"])?2:1));if(!$G)$n=error();else{$I=$G->fetch_assoc();if(!$I)$I=false;}if(isset($_GET["select"])&&(!$I||$G->fetch_assoc()))$I=null;}}if(!support("table")&&!$p){if(!$Z){$G=$m->select($a,array("*"),$Z,array("*"));$I=($G?$G->fetch_assoc():false);if(!$I)$I=array($m->primary=>"");}if($I){foreach($I
as$y=>$X){if(!$Z)$I[$y]=null;$p[$y]=array("field"=>$y,"null"=>($y!=$m->primary),"auto_increment"=>($y==$m->primary));}}}edit_form($a,$p,$I,$Kg);}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$w=indexes($a);$p=fields($a);$Dc=column_foreign_keys($a);$ie=$R["Oid"];parse_str($_COOKIE["adminer_import"],$ta);$pf=array();$f=array();$hg=null;foreach($p
as$y=>$o){$B=$b->fieldName($o);if(isset($o["privileges"]["select"])&&$B!=""){$f[$y]=html_entity_decode(strip_tags($B),ENT_QUOTES);if(is_shortable($o))$hg=$b->selectLengthProcess();}$pf+=$o["privileges"];}list($K,$Jc)=$b->selectColumnsProcess($f,$w);$pd=count($Jc)<count($K);$Z=$b->selectSearchProcess($p,$w);$se=$b->selectOrderProcess($p,$w);$z=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Gg=>$I){$za=convert_field($p[key($I)]);$K=array($za?$za:idf_escape(key($I)));$Z[]=where_check($Gg,$p);$H=$m->select($a,$K,$Z,$K);if($H)echo
reset($H->fetch_row());}exit;}$Pe=$Ig=null;foreach($w
as$v){if($v["type"]=="PRIMARY"){$Pe=array_flip($v["columns"]);$Ig=($K?$Pe:array());foreach($Ig
as$y=>$X){if(in_array(idf_escape($y),$K))unset($Ig[$y]);}break;}}if($ie&&!$Pe){$Pe=$Ig=array($ie=>0);$w[]=array("type"=>"PRIMARY","columns"=>array($ie));}if($_POST&&!$n){$ch=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Va=array();foreach($_POST["check"]as$Sa)$Va[]=where_check($Sa,$p);$ch[]="((".implode(") OR (",$Va)."))";}$ch=($ch?"\nWHERE ".implode(" AND ",$ch):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$Hc=($K?implode(", ",$K):"*").convert_fields($f,$p,$K)."\nFROM ".table($a);$Lc=($Jc&&$pd?"\nGROUP BY ".implode(", ",$Jc):"").($se?"\nORDER BY ".implode(", ",$se):"");if(!is_array($_POST["check"])||$Pe)$F="SELECT $Hc$ch$Lc";else{$Eg=array();foreach($_POST["check"]as$X)$Eg[]="(SELECT".limit($Hc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$p).$Lc,1).")";$F=implode(" UNION ALL ",$Eg);}$b->dumpData($a,"table",$F);exit;}if(!$b->selectEmailProcess($Z,$Dc)){if($_POST["save"]||$_POST["delete"]){$G=true;$ua=0;$N=array();if(!$_POST["delete"]){foreach($f
as$B=>$X){$X=process_input($p[$B]);if($X!==null&&($_POST["clone"]||$X!==false))$N[idf_escape($B)]=($X!==false?$X:idf_escape($B));}}if($_POST["delete"]||$N){if($_POST["clone"])$F="INTO ".table($a)." (".implode(", ",array_keys($N)).")\nSELECT ".implode(", ",$N)."\nFROM ".table($a);if($_POST["all"]||($Pe&&is_array($_POST["check"]))||$pd){$G=($_POST["delete"]?$m->delete($a,$ch):($_POST["clone"]?queries("INSERT $F$ch"):$m->update($a,$N,$ch)));$ua=$h->affected_rows;}else{foreach((array)$_POST["check"]as$X){$Yg="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$p);$G=($_POST["delete"]?$m->delete($a,$Yg,1):($_POST["clone"]?queries("INSERT".limit1($a,$F,$Yg)):$m->update($a,$N,$Yg,1)));if(!$G)break;$ua+=$h->affected_rows;}}}$Td=lang(84,$ua);if($_POST["clone"]&&$G&&$ua==1){$Ad=last_id();if($Ad)$Td=lang(83," $Ad");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Td,$G);if(!$_POST["delete"]){edit_form($a,$p,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$n=lang(85);else{$G=true;$ua=0;foreach($_POST["val"]as$Gg=>$I){$N=array();foreach($I
as$y=>$X){$y=bracket_escape($y,1);$N[idf_escape($y)]=(preg_match('~char|text~',$p[$y]["type"])||$X!=""?$b->processInput($p[$y],$X):"NULL");}$G=$m->update($a,$N," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Gg,$p),!$pd&&!$Pe," ");if(!$G)break;$ua+=$h->affected_rows;}queries_redirect(remove_from_uri(),lang(84,$ua),$G);}}elseif(!is_string($rc=get_file("csv_file",true)))$n=upload_error($rc);elseif(!preg_match('~~u',$rc))$n=lang(86);else{cookie("adminer_import","output=".urlencode($ta["output"])."&format=".urlencode($_POST["separator"]));$G=true;$db=array_keys($p);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$rc,$Nd);$ua=count($Nd[0]);$m->begin();$L=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$J=array();foreach($Nd[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$L]*)$L~",$X.$L,$Od);if(!$y&&!array_diff($Od[1],$db)){$db=$Od[1];$ua--;}else{$N=array();foreach($Od[1]as$s=>$ab)$N[idf_escape($db[$s])]=($ab==""&&$p[$db[$s]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$ab))));$J[]=$N;}}$G=(!$J||$m->insertUpdate($a,$J,$Pe));if($G)$G=$m->commit();queries_redirect(remove_from_uri("page"),lang(87,$ua),$G);$m->rollback();}}}$ag=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(48).": $ag",$n);$N=null;if(isset($pf["insert"])||!support("table")){$N="";foreach((array)$_GET["where"]as$X){if($Dc[$X["col"]]&&count($Dc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$N.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($R,$N);if(!$f&&support("table"))echo"<p class='error'>".lang(88).($p?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($K,$f);$b->selectSearchPrint($Z,$f,$w);$b->selectOrderPrint($se,$f,$w);$b->selectLimitPrint($z);$b->selectLengthPrint($hg);$b->selectActionPrint($w);echo"</form>\n";$D=$_GET["page"];if($D=="last"){$Fc=$h->result(count_rows($a,$Z,$pd,$Jc));$D=floor(max(0,$Fc-1)/$z);}$vf=$K;$Kc=$Jc;if(!$vf){$vf[]="*";$rb=convert_fields($f,$p,$K);if($rb)$vf[]=substr($rb,2);}foreach($K
as$y=>$X){$o=$p[idf_unescape($X)];if($o&&($za=convert_field($o)))$vf[$y]="$za AS $X";}if(!$pd&&$Ig){foreach($Ig
as$y=>$X){$vf[]=idf_escape($y);if($Kc)$Kc[]=idf_escape($y);}}$G=$m->select($a,$vf,$Z,$Kc,$se,$z,$D,true);if(!$G)echo"<p class='error'>".error()."\n";else{if($x=="mssql"&&$D)$G->seek($z*$D);$Wb=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$J=array();while($I=$G->fetch_assoc()){if($D&&$x=="oracle")unset($I["RNUM"]);$J[]=$I;}if($_GET["page"]!="last"&&$z!=""&&$Jc&&$pd&&$x=="sql")$Fc=$h->result(" SELECT FOUND_ROWS()");if(!$J)echo"<p class='message'>".lang(12)."\n";else{$Ja=$b->backwardKeys($a,$ag);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$Jc&&$K?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(89)."</a>");$ae=array();$Ic=array();reset($K);$bf=1;foreach($J[0]as$y=>$X){if(!isset($Ig[$y])){$X=$_GET["columns"][key($K)];$o=$p[$K?($X?$X["col"]:current($K)):$y];$B=($o?$b->fieldName($o,$bf):($X["fun"]?"*":$y));if($B!=""){$bf++;$ae[$y]=$B;$e=idf_escape($y);$Xc=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Fb="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Xc.($se[0]==$e||$se[0]==$y||(!$se&&$pd&&$Jc[0]==$e)?$Fb:'')).'">';echo
apply_sql_function($X["fun"],$B)."</a>";echo"<span class='column hidden'>","<a href='".h($Xc.$Fb)."' title='".lang(90)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(43).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");}echo"</span>";}$Ic[$y]=$X["fun"];next($K);}}$Dd=array();if($_GET["modify"]){foreach($J
as$I){foreach($I
as$y=>$X)$Dd[$y]=max($Dd[$y],min(40,strlen(utf8_decode($X))));}}echo($Ja?"<th>".lang(91):"")."</thead>\n";if(is_ajax()){if($z%2==1&&$D%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($J,$Dc)as$Zd=>$I){$Fg=unique_array($J[$Zd],$w);if(!$Fg){$Fg=array();foreach($J[$Zd]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Fg[$y]=$X;}}$Gg="";foreach($Fg
as$y=>$X){if(($x=="sql"||$x=="pgsql")&&preg_match('~char|text|enum|set~',$p[$y]["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".($x!='sql'||preg_match("~^utf8~",$p[$y]["collation"])?$y:"CONVERT($y USING ".charset($h).")").")";$X=md5($X);}$Gg.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X):"null%5B%5D=".urlencode($y));}echo"<tr".odd().">".(!$Jc&&$K?"":"<td>".checkbox("check[]",substr($Gg,1),in_array(substr($Gg,1),(array)$_POST["check"])).($pd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Gg)."' class='edit'>".lang(92)."</a>"));foreach($I
as$y=>$X){if(isset($ae[$y])){$o=$p[$y];$X=$m->value($X,$o);if($X!=""&&(!isset($Wb[$y])||$Wb[$y]!=""))$Wb[$y]=(is_mail($X)?$ae[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$o["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$Gg;if(!$_&&$X!==null){foreach((array)$Dc[$y]as$Cc){if(count($Dc[$y])==1||end($Cc["source"])==$y){$_="";foreach($Cc["source"]as$s=>$Kf)$_.=where_link($s,$Cc["target"][$s],$J[$Zd][$Kf]);$_=($Cc["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($Cc["db"]),ME):ME).'select='.urlencode($Cc["table"]).$_;if($Cc["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($Cc["ns"]),$_);if(count($Cc["source"])==1)break;}}}if($y=="COUNT(*)"){$_=ME."select=".urlencode($a);$s=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Fg))$_.=where_link($s++,$W["col"],$W["val"],$W["op"]);}foreach($Fg
as$sd=>$W)$_.=where_link($s++,$sd,$W);}$X=select_value($X,$_,$o,$hg);$t=h("val[$Gg][".bracket_escape($y)."]");$Y=$_POST["val"][$Gg][bracket_escape($y)];$Sb=!is_array($I[$y])&&is_utf8($X)&&$J[$Zd][$y]==$I[$y]&&!$Ic[$y];$gg=preg_match('~text|lob~',$o["type"]);echo"<td id='$t'";if(($_GET["modify"]&&$Sb)||$Y!==null){$Nc=h($Y!==null?$Y:$I[$y]);echo">".($gg?"<textarea name='$t' cols='30' rows='".(substr_count($I[$y],"\n")+1)."'>$Nc</textarea>":"<input name='$t' value='$Nc' size='$Dd[$y]'>");}else{$Id=strpos($X,"<i>…</i>");echo" data-text='".($Id?2:($gg?1:0))."'".($Sb?"":" data-warning='".h(lang(93))."'").">$X</td>";}}}if($Ja)echo"<td>";$b->backwardKeysPrint($Ja,$J[$Zd]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($J||$D){$fc=true;if($_GET["page"]!="last"){if($z==""||(count($J)<$z&&($J||!$D)))$Fc=($D?$D*$z:0)+count($J);elseif($x!="sql"||!$pd){$Fc=($pd?false:found_rows($R,$Z));if($Fc<max(1e4,2*($D+1)*$z))$Fc=reset(slow_query(count_rows($a,$Z,$pd,$Jc)));else$fc=false;}}$Ae=($z!=""&&($Fc===false||$Fc>$z||$D));if($Ae){echo(($Fc===false?count($J)+1:$Fc-$D*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($D+1)).'" class="loadmore">'.lang(94).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$z).", '".lang(95)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($J||$D){if($Ae){$Pd=($Fc===false?$D+(count($J)>=$z?2:1):floor(($Fc-1)/$z));echo"<fieldset>";if($x!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(96)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(96)."', '".($D+1)."')); return false; };"),pagination(0,$D).($D>5?" …":"");for($s=max(1,$D-4);$s<min($Pd,$D+5);$s++)echo
pagination($s,$D);if($Pd>0){echo($D+5<$Pd?" …":""),($fc&&$Fc!==false?pagination($Pd,$D):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Pd'>".lang(97)."</a>");}}else{echo"<legend>".lang(96)."</legend>",pagination(0,$D).($D>1?" …":""),($D?pagination($D,$D):""),($Pd>$D?pagination($D+1,$D).($Pd>$D+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(98)."</legend>";$Kb=($fc?"":"~ ").$Fc;echo
checkbox("all",1,0,($Fc!==false?($fc?"":"~ ").lang(99,$Fc):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Kb' : checked); selectCount('selected2', this.checked || !checked ? '$Kb' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(89),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(85).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(100),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(101),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$Ec=$b->dumpFormat();foreach((array)$_GET["columns"]as$e){if($e["fun"]){unset($Ec['sql']);break;}}if($Ec){print_fieldset("export",lang(102)." <span id='selected2'></span>");$ye=$b->dumpOutput();echo($ye?html_select("output",$ye,$ta["output"])." ":""),html_select("format",$Ec,$ta["format"])," <input type='submit' name='export' value='".lang(102)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($Wb,'strlen'),$f);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(103)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ta["format"],1);echo" <input type='submit' name='import' value='".lang(103)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$sg'>\n","</form>\n",(!$Jc&&$K?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["script"])){if($_GET["script"]=="kill")$h->query("KILL ".number($_POST["kill"]));elseif(list($Q,$t,$B)=$b->_foreignColumn(column_foreign_keys($_GET["source"]),$_GET["field"])){$z=11;$G=$h->query("SELECT $t, $B FROM ".table($Q)." WHERE ".(preg_match('~^[0-9]+$~',$_GET["value"])?"$t = $_GET[value] OR ":"")."$B LIKE ".q("$_GET[value]%")." ORDER BY 2 LIMIT $z");for($s=1;($I=$G->fetch_row())&&$s<$z;$s++)echo"<a href='".h(ME."edit=".urlencode($Q)."&where".urlencode("[".bracket_escape(idf_unescape($t))."]")."=".urlencode($I[0]))."'>".h($I[1])."</a><br>\n";if($I)echo"...\n";}exit;}else{page_header(lang(63),"",false);if($b->homepage()){echo"<form action='' method='post'>\n","<p>".lang(104).": <input type='search' name='query' value='".h($_POST["query"])."'> <input type='submit' value='".lang(43)."'>\n";if($_POST["query"]!="")search_tables();echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^tables\[/);",""),'<th>'.lang(105),'<td>'.lang(106),"</thead>\n";foreach(table_status()as$Q=>$I){$B=$b->tableName($I);if(isset($I["Engine"])&&$B!=""){echo'<tr'.odd().'><td>'.checkbox("tables[]",$Q,in_array($Q,(array)$_POST["tables"],true)),"<th><a href='".h(ME).'select='.urlencode($Q)."'>$B</a>";$X=format_number($I["Rows"]);echo"<td align='right'><a href='".h(ME."edit=").urlencode($Q)."'>".($I["Engine"]=="InnoDB"&&$X?"~ $X":$X)."</a>";}}echo"</table>\n","</div>\n","</form>\n",script("tableCheck();");}}page_footer();