#ifndef _DRIVER_H_3ac311ac_
#define _DRIVER_H_3ac311ac_

#include "pdp11.h"

struct driver_;

struct intrq_ {
  struct driver_ *driver;
  word vec;
  word pri;
  int flags;
#define IRQ_F_ACTIVE 1
  struct intrq_ *pri_link;
  } ;
typedef struct intrq_ INTRQ;

struct driver_ {
  int flags;
#define DVR_NORMW 0x00000001
  char *name;
  void (*init)();
  void (*tick)();
  int (*io)();
  void (*busreset)();
  void (*reset)();
  int (*intchk)();
  void (*intack)();
  struct driver_ *link;
  INTRQ irq[8];
  char iomask[8192];
  } ;
typedef struct driver_ DRIVER;

#define IOMASK(n) (017777&(word)(n))

#define IO_OP   0x0f
#define IO_BITS 0xf0
#define IO_R    0x01
#define IO_W    0x02
#define IO_RMW  0x03
#define IO_BYTE 0x10

#define NOFXN ((void (*)())0)

#define BR4 4
#define BR5 5
#define BR6 6
#define BR7 7

#endif
