/* ltc board driver */

#define CSR 017777546
#define LTC_IE 0100

#include "driver.h"

#include <signal.h>
#include <sys/time.h>

#include <signaltype.h>

extern DRIVER ltc_driver;

static word ltc;
static int running;
static int tickus = 1000000 / 60;

static void startticks()
{
 struct itimerval itv;

 itv.it_interval.tv_sec = 0;
 itv.it_interval.tv_usec = tickus;
 itv.it_value = itv.it_interval;
 setitimer(ITIMER_REAL,&itv,(struct itimerval *)0);
 running = 1;
}

static void stopticks()
{
 struct itimerval itv;

 itv.it_interval.tv_sec = 0;
 itv.it_interval.tv_usec = 0;
 itv.it_value = itv.it_interval;
 setitimer(ITIMER_REAL,&itv,(struct itimerval *)0);
 running = 0;
}

static signaltype ltc__sigalrm()
{
 extern int halted;

 if (halted) return;
 if (ltc & LTC_IE)
  { interrupt(&ltc_driver,0100,BR6);
  }
 else
  { stopticks();
  }
}

static void ltc_init(d,iomask)
DRIVER *d;
char *iomask;
{
 int i;

 iomask[IOMASK(CSR)] = 1;
 ltc = 0;
 signal(SIGALRM,ltc__sigalrm);
 stopticks();
}

static int ltc_io(d,loc,op,data,fxn)
DRIVER *d;
int loc;
int op;
int data;
void (*fxn)();
{
 register int rv;

 rv = reg_access(loc,&ltc,op,~LTC_IE,data);
 if (ltc & LTC_IE)
  { if (! running) startticks();
  }
 else
  { if (running) stopticks();
  }
}

static void ltc_busreset(d)
DRIVER *d;
{
 ltc = 0;
 stopticks();
}

static void ltc_reset(d)
DRIVER *d;
{
}

static int ltc_intchk()
{
 return(ltc&LTC_IE);
}

DRIVER ltc_driver = { DVR_NORMW, "line-time clock", ltc_init, 0, ltc_io, ltc_busreset, ltc_reset, ltc_intchk, 0 };
