/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: xalloc.c,v 1.3 1998/07/17 20:34:17 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include "begemot.h"

/*
 * Ok. This layer above malloc ensures, that even xalloc(0) returns a
 * pointer. Although malloc should do this, some mallocs fail to.
 */
void *
xalloc(size_t s)
{
	void *p;

	if((p = malloc(s)) == NULL && (s != 0 || (p = malloc(1)) == NULL))
		panic("out of memory: xalloc(%lu)", (unsigned long)s);

	return p;
}
