/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

# include <stdio.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <errno.h>
# include <termios.h>
# include <signal.h>
# include <fcntl.h>
# include <unistd.h>
# include <string.h>

# include "../system.h"
# include "../compat.h"

# include "tty.h"


int		cs7;
struct termios	saved;
int		issaved;
int		fd;



volatile void
Exit(int ex)
{
	if(issaved)
		tcsetattr(fd, TCSANOW | TCSASOFT, &saved);
	exit(ex);
}

/*
 * fd 0 is socket to parent
 */
int
main(int argc, char *argv[])
{
	struct termios t;
	int	eno;
	int	opt;

	while((opt = getopt(argc, argv, "7")) != EOF)
		switch(opt) {

		case '7':
			cs7 = 1;
			break;
		}
	argc -= optind;
	argv += optind;

	tty_init();

	if((fd = open(argv[0], 2)) < 0)
		return errno;
	if(setsid() < 0)
		return errno;
	if(fcntl(fd, F_SETFL, O_NONBLOCK))
		return errno;

	SIGNAL(SIGPIPE, onsig);

	tcgetattr(fd, &t);
	saved = t;
	issaved = 1;
	cfmakeraw(&t);
	tcsetattr(fd, TCSANOW | TCSASOFT, &t);

	tty_loop(fd);

	Exit(0);
}

void
process_output()
{
	if(cs7)
		makecs7();
}

void
process_input()
{
}
