/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * extra options for cpp for configuration file parsing
 * try to switch off all default includes and all default defines
 * (except __FILE__ etc.)
 * cpp must NOT include extra spaces in constructs like A/B, where A and
 * B are #defined.
 */
# define CPP_EXTRA

/*
 * option to set default include directory for cpp
 */
# define CPP_DINCL	"-nostdinc -I"		/* gcc */


/*
 * define if system has vararg.h instead of stdarg.h
 */
/* # define USE_VARARGS */


/*
 * define if system has path.h
 */
# define USE_PATHH

/*
 * define if we have and need termios.h
 */
# define USE_TERMIOSH


/*
 * define this if you have cfmakeraw there
 */
# define HAS_CFMAKERAW


/*
 * define ATEXIT to call the right library function. 'D' is NULL in any case/
 */
# define	ATEXIT(F,D)	atexit(F)


/*
 * defines for signaling on i/o posibility
 * define HAS_ASYNC_FCNTL if you get SIGIO by calling fcntl (BSDish)
 * define HAS_ASYNC_STREAMS if you get it trough sys5 streams
 *
 * if you use fcntl you must also define the flag to be used
 */
/* # define	HAS_ASYNC_FCNTL */
/* # define	VAL_FASYNC	O_ASYNC */
/* # define	HAS_ASYNC_STREAMS */
# define	HAS_POSIX_AIO


/*
 * the SOCK_LEN macro should set the socket lenght field in sockaddr
 * if needed (4.4bsd)
# define	SOCK_LEN(S,L)	((S) = (L))
 */
# define	SOCK_LEN(S,L)


/*
 * msync appears to have flags on various unices. arrange the
 * following macro so that it msync's the given spaces
 */
# define	MSYNC(A,L)	msync((A), (L), MS_SYNC)


/*
 * define this if you have already a typedef for ulong already in sys/types.h
 * or elsewhere
 */
# define	HAS_UCHAR
# define	HAS_ULONG


/*
 * we must have BSDish signals, i.e. they must not restore to SIG_DFL
 * when occured and they must restart interrupted systemcalls
 * define this one if you have the old ones (sys5) but they may
 * posixly emulated by sigaction
 */
# define HAS_S5_SIGNALS


/*
 * define the error that is returned, if a non-blocking file descriptor
 * has nothing to read
 */
# define NONBLOCK_ERROR EWOULDBLOCK


/********
 *
 * the rest constitutes pathnames and missing stuff
 *
 */

# define	TCSASOFT	0
