#include "defines.h"

char realfilename[500];		/* These 2 are used on filename translation */
char *rfn;			/* to the APOUT_ROOT */
char *progname = NULL;		/* The program's name - used in debugging */
#ifdef DEBUG
int mem_debug=0,		/* Debugging flags */
    inst_debug= 0,
    trap_debug= 0;
FILE *dbg_file = NULL;		/* Debugging output file */
char buf[100];
#endif

int
main(int argc, char **argv)
{
#ifdef INST_CMP
    char *envp[2] = {
	/* "PATH=:/bin:/usr/bin:/etc:/usr/lbin", */
	"PATH=:/bin:/usr/bin:/abcdefghrlbin",
	"HOME=/"
    };
    int envc = 2;
#else
	/* For now, we set the environment statically. Eventually */
	/* there will be code to get some environment variables */
    char *envp[3] = {
	"PATH=:/bin:/usr/bin:/usr/games",
	"HOME=/",
	"TERM=vt05"
    };
    int envc = 3;
#endif

    if (argc < 2) {
	fprintf(stderr, "Usage: apout");
#ifdef DEBUG
        fprintf(stderr, " [-mem] [-debug] [-trap]");
#endif
	fprintf(stderr, " v7_binary\n");
	exit(1);
    }
#ifdef DEBUG
    if (!strcmp(argv[1], "-mem")) { mem_debug = 1; argc--; argv++; }
    if (!strcmp(argv[1], "-debug")) { inst_debug = 1; argc--; argv++; }
    if (!strcmp(argv[1], "-trap")) { trap_debug = 1; argc--; argv++; }
    if (inst_debug|trap_debug) dbg_file = fopen("apout.dbg", "w");

    if (mem_debug) {
	sprintf(buf, "%s.dbg", argv[1]);
	dbg_file = fopen(buf, "w");
    }
#endif

    signal(SIGBUS, bus_error);	/* Catch all bus errors here */

    sim_init();			/* Initialise the CPU */

    if (load_v7_a_out(argv[1]) == -1) {
	fprintf(stderr, "Apout - couldn't load %s\n", argv[1]);
	exit(1);
    }
				/* Set the translation to a fictitious */
				/* root filesystem */
    if ((rfn = getenv("APOUT_ROOT"))) {
	strcpy(realfilename, rfn);
	rfn = realfilename;
	rfn += strlen(realfilename);
    } else {
	fprintf(stderr,
		"APOUT_ROOT env variable not set before running apout\n");
	exit(1);
    }
    argc--;
    argv++;
    set_arg_env(argc, argv, envc, envp, 0);

    run();			/* and run the binary */
    exit(0);
}


void
set_arg_env(int argc, char **argv, int envc, char **envp, int oldexec)
{
    int i, posn, len;
    int eposn[MAX_ARGS];
    int aposn[MAX_ARGS];

    /* Set up the program's name -- used for debugging */
    if (progname) free(progname);
    progname = strdup(argv[0]);

    if (argc > MAX_ARGS) argc = MAX_ARGS;
    if (envc > MAX_ARGS) envc = MAX_ARGS;

    /* Now build the arguments and pointers on the stack; see the Sixth */
    /* and Seventh Edition manuals for a description of the layout */
	
    posn = PDP_MEM_SIZE - 2;
    sl_word(posn, 0);		/* Put a NULL on top of stack */

    if (!oldexec)
	for (i = envc - 1; i != -1; i--) {	/* For each env string */
	    len = strlen(envp[i]) + 1;		/* get its length */
#ifndef INST_CMP
	    if ((len & 1) == 1) len++;		/* Make len divisible by 2 */
#endif
	    posn -= len;
	    memcpy(&dspace[posn], envp[i], len);
	    eposn[i] = posn;
	}

    for (i = argc - 1; i != -1; i--) {	/* For each arg string */
	len = strlen(argv[i]) + 1;	/* get its length */
#ifndef INST_CMP
	if ((len & 1) == 1) len++;	/* Make len divisible by 2 */
#endif
	posn -= len;
	memcpy(&dspace[posn], argv[i], len);
	aposn[i] = posn;
    }

    if (!oldexec) {			/* For each env string */
	for (i = envc - 1; i != -1; i--) {
	    posn -= 2;
	    sl_word(posn, eposn[i]);	/* put a pointer to the string */
	}
	posn -= 2;
    }
#ifdef INST_CMP
    posn -= 2;
#endif
    				/* Put a NULL or -1 before arg pointers */
    if (oldexec) sl_word(posn, -1)
    else sl_word(posn, 0);

    for (i = argc - 1; i != -1; i--) {	/* For each arg string */
	posn -= 2;
	sl_word(posn, aposn[i]);	/* put a pointer to the string */
    }
    posn -= 2;
    sl_word(posn, argc);		/* Save the count of args */
    regs[SP] = posn;			/* and initialise the PC */
}
