#include        <stdio.h>
#include        <signal.h>
#include        <sys/times.h>
#include	"defs.h"
#include	"sym.h"

#define         FORKRETRY       3

static  int     parent;
struct	sysnod  commands[];

/* ========	command execution	========*/

/*VARARGS2*/
execute(argt, execflg, pf1, pf2)
register union	node    *argt;
int     execflg;
int	*pf1, *pf2;
{
	register union	node    *t;
	int     printnam(), printflg();

	sigchk();
	if (((t = argt) != NULL) && execbrk == 0) {
		register int  treeflgs;
		int  oldexit, type;
		register char   **com;
                char    **svcom = NULL;

		treeflgs = t->comnod.type;
		type = treeflgs&COMMSK;
		oldexit = exitval;
		exitval = 0;

		switch (type) {

		case TCOM:
			{
				char	*a1;
				int  argn, internal;
				struct  argnod  *schain = gchain;
				struct  ionod   *io = t->comnod.comio;

				gchain = NULL;
				argn = getarg(t);
				svcom = com = scan(argn);
				a1 = com[1];
				gchain = schain;

				if ((internal = syslook(com[0], commands)) || argn == 0) {
					setlist(t->comnod.comset, 0);
				}

				if (argn && (flags & NOEXEC) == 0) {
                                        /* print command if EXECPR */
					if (flags & EXECPR) {
						argn=0;	
						fprintf(stderr, "%s", execpmsg);
						while (com[argn]!=NULL) { 
							fprintf(stderr, "%s ", com[argn++]);
						}
						putc('\n', stderr);
					}

					switch (internal) {

					case SYSDOT:
						if (a1) {	
                                                        FILE    *fp;
                                                        int     svprompt, svflin;
                                                        char    *svcmdadr;

							if ((fp = pathopen(getpath(a1), a1)) == NULL) {
								failed(a1, notfound);
							} 
							else { 
                                                                svcmdadr = cmdadr;
                                                                cmdadr = a1;
                                                                svflin = flin;
                                                                flin = 0;
                                                                svprompt = flags & PROMPT;
                                                                flags &= ~PROMPT;
								execexp((char *) NULL, fp);
                                                                fclose(fp);
                                                                flags |= svprompt;
                                                                flin = svflin;
                                                                cmdadr = svcmdadr;
							}
						}
						break;

					case SYSTIMES:
						{
							struct tms  t;

							times(&t);
							prt(t.tms_cutime);
							putc(' ', stderr);
							prt(t.tms_cstime);
							putc('\n', stderr);
						}
						break;

					case SYSEXIT:
						exitsh((a1 != NULL)? stoi(a1): oldexit);

					case SYSNULL:
						io = 0;
						break;

					case SYSCONT:
						if (loopcnt) {
							if (a1) {
								breakcnt = -stoi(a1);
							} else {
								breakcnt = -1;
							}
							execbrk = breakcnt;
						}
						break;

					case SYSBREAK:
						if (loopcnt) {
							if (a1) {
								breakcnt = stoi(a1);
							} else {
								breakcnt = 1;
							}
							execbrk = breakcnt;
						}
						break;

					case SYSTRAP:
						if (a1 != NULL) {
							char	clear;

							if ((clear = digit(*a1)) == 0)
								++com;
							while (*++com) { 
								int  i;

								if ((i = stoi(*com)) >= NSIG || i < 0)
									failed(*com, badtrap);
								else if (clear)
									clrsig(i);
								else {
									replace(&trapcom[i], a1);
									if (*a1)
										getsig(i);
									else
										ignsig(i);
								}
							}
						} 
						else {	/* print out current traps */
							int  i;

							for (i = 0; i < NSIG; i++) {
								if (trapcom[i]) {	
									fprintf(stderr, "%d: %s\n", i, trapcom[i]);
								}
							}
						}
						break;

					case SYSEXEC:
						com++;
						initio(io); 
						io = NULL;
						if (a1 == NULL) {
							break;
						}

					case SYSLOGIN:
						flags |= FORKED;
						oldsigs(); 
						execa(com); 
						done();

					case SYSCD:
						if (flags & RSHFLG) {
							failed(com[0], restricted);
						} else if ((a1 == NULL && (a1 = homenod.namval) == NULL) ||
                                                            chdir(a1) < 0) {
							failed(a1, baddir);
						}
						break;

					case SYSSHFT:
						if (dolc<1) {	
							error(badshift);
						} else {
							dolv++; 
							dolc--;
						}
						assnum(&dolladr, dolc);
						break;

					case SYSWAIT:
						await(-1);
						break;

					case SYSREAD:
						exitval=readvar(&com[1]);
						break;

					case SYSSET:
						if (a1) {	
							int  argc;
							argc = options(argn, com);
							if (argc>1) {	
								setargs(com+argn-argc);
							}
						} 
                                                /*scan name chain and print*/
						else if (t->comnod.comset == NULL) {
							namscan(printnam);
						}
						break;

					case SYSRDONLY:
						exitval=N_RDONLY;
					case SYSXPORT:
						if (exitval==0) { 
							exitval=N_EXPORT; 
						}

						if (a1) {	  
							while (*++com) { 
								attrib(lookup(*com), exitval);
							}
						} else {
							namscan(printflg);
						}
						exitval = 0;
						break;

					case SYSEVAL:
						if (a1) {	
                                                        char    *bp;
                                                        char    **arg, *ap;

                                                        bp = buf;
                                                        for (arg = &com[1]; *arg != NULL; arg++) {
                                                                ap = *arg;
                                                                while (*ap)
                                                                        *bp++ = *ap++;
                                                                *bp++ = SP;
                                                        }
                                                        *bp = '\0';
							execexp(buf, (FILE *) NULL);
						}
						break;

					case SYSUMASK:
						if (a1) {
							int  c, i;

							i = 0;
							while ((c = *a1++) >= '0' && c <= '7')
								i = (i << 3) + c - '0';
							umask(i);
						} else {
                                                        int i;
							umask(i = umask(0));
                                                        fprintf(stderr, "%04o\n", i);
						}
						break;

					default:
						internal = 0;

					}

					if (internal) {	     
						if (io) { 
							error(illegal);
						}
						chktrap();
						break;
					}
				} 
				else if (t->comnod.comio == NULL) {
					break;
				}
			}

		case TFORK:
			if (execflg && (treeflgs & (FAMP|FPOU)) == 0) {
				parent = 0;
			} else {
				int nfork = 0;

				while ((parent = fork()) == -1) {
                                        if (nfork++ >= FORKRETRY) {
                                                perror(cmdadr);
						if (flags & PROMPT)
                                                        longjmp(errshell, 0);
                                                else
                                                        done();
                                        }
					sigchk(); 
					alarm(10); 
					pause();
				}
			}

			if (parent) {	/* This is the parent branch of fork;    */
				/* it may or may not wait for the child. */
				if ((treeflgs & FPRS) && (flags & TTYFLG)) {
                                        fprintf(stderr, "%d\n", parent);
				}
				if (treeflgs & FPCL) {
					closepipe(pf1);
				}
				if ((treeflgs & (FAMP | FPOU)) == 0) {
					await(parent);
				} 
				else if ((treeflgs & FAMP) == 0) {
					post(parent);
				} 
				else {	
					assnum(&pcsadr, parent);
				}

				chktrap();
                                if (svcom != NULL) {
                                        com = svcom;
                                        while (*com != NULL) {
                                                free(*com++);
                                        }
                                        free((char *) svcom);
                                }
				break;


			} 
			else {	/* this is the forked branch (child) of execute */
				flags |= FORKED;
				iotemp = NULL;
				postclr();
				settmp();

				/* Turn off INTR and QUIT if `FINT'  */
				/* Reset ramaining signals to parent */
				/* except for those `lost' by trap   */
				oldsigs();
				if (treeflgs & FINT) {
					signal(SIGINT, SIG_IGN);
					signal(SIGQUIT, SIG_IGN);
				}

				/* pipe in or out */
				if (treeflgs & FPIN) {
					movefd(pf1[INPIPE], 0);
					close(pf1[OTPIPE]);
				}
				if (treeflgs & FPOU) {
					movefd(pf2[OTPIPE], 1);
					close(pf2[INPIPE]);
				}

				/* default std input for & */
				if (treeflgs & FINT) {
					movefd(fileno(chkopen(devnull, "r")), 0);
				}
				/* io redirection */
				initio(t->forknod.forkio);
				if (type != TCOM) {
					execute(t->forknod.forktre, 1);
				} 
				else if (com[0] != NULL) {
					setlist(t->comnod.comset, N_EXPORT);
					execa(com);
				}
				done();
			}

		case TPAR:
			close(NSTDERR);
                        dup2(OSTDERR, NSTDERR);
                        fileno(stderr) = NSTDERR;
			execute(t->parnod.partre, execflg);
			done();

		case TFIL:
			{
				int  pv[2]; 
				chkpipe(pv);
				if (execute(t->lstnod.lstlef, 0, pf1, pv) == NULL) {
					execute(t->lstnod.lstrit, execflg, pv, pf2);
				} 
				else {	
					closepipe(pv);
				}
			}
			break;

		case TLST:
			execute(t->lstnod.lstlef, 0);
			execute(t->lstnod.lstrit, execflg);
			break;

		case TAND:
			if (execute(t->lstnod.lstlef, 0)==0) {
				execute(t->lstnod.lstrit, execflg);
			}
			break;

		case TORF:
			if (execute(t->lstnod.lstlef, 0) != NULL) {
				execute(t->lstnod.lstrit, execflg);
			}
			break;

		case TFOR:
			{
				struct  namnod  *n = lookup(t->fornod.fornam);
				char	**args;
				struct  dolnod  *argsav = NULL;

				if (t->fornod.forlst == NULL) {
					args = dolv + 1;
					argsav = useargs();
				} else {
					struct  argnod  *schain = gchain;

					gchain = NULL;
					trim((args = scan(getarg(t->fornod.forlst)))[0]);
					gchain = schain;
				}
				loopcnt++;
				while (*args != NULL && execbrk == 0) {
					assign(n, *args++);
					execute(t->fornod.fortre, 0);
					if (breakcnt < 0) {
						breakcnt++;
					}
					execbrk = breakcnt;
				}
				if (breakcnt > 0) {
					breakcnt--;
				}
				execbrk = breakcnt;
				loopcnt--;
				argfor = freeargs(argsav);
			}
			break;

		case TWH:
		case TUN:
			{
				int  i=0;

				loopcnt++;
				while (execbrk == 0 &&
                                      (execute(t->whnod.whtre, 0) == NULL) == (type == TWH)) {
					i = execute(t->whnod.dotre, 0);
					if (breakcnt<0) { 
						breakcnt++;
					}
					execbrk = breakcnt;
				}
				if (breakcnt>0) { 
					breakcnt--;
				}
				execbrk=breakcnt; 
				loopcnt--; 
				exitval=i;
			}
			break;

		case TIF:
			if (execute(t->ifnod.iftre, 0)==0) {
				execute(t->ifnod.thtre, execflg);
			} 
			else {	
				execute(t->ifnod.eltre, execflg);
			}
			break;

		case TSW:
			{
				register char   *r = mactrim(t->swnod.swarg);
                                struct regnod *rg;

				rg = t->swnod.swlst;
				while (rg != NULL) {
					struct  argnod  *rex = rg->regptr;

					while (rex) {	
						register char	*s;

                                                s = macro(rex->argval);
						if (gmatch(r, s) || (trim(s), eq(r, s))) {
							execute(rg->regcom, 0);
							rg = NULL;
							break;
						} else {
							rex = rex->argnxt;
						}
                                                free(s);
                                        }
					if (rg != NULL) {
						rg = rg->regnxt;
					}
				}
                                free(r);
                        }
			break;
		}
		exitset();
	}
	sigchk();
	return(exitval);
}


execexp(s, fp)
register char	*s;
register FILE   *fp;
{
	register int     svflg;
	register char    *svptr;
	register FILE    *svfp;

	if (s != NULL) {
                svflg = cflg;
                svptr = cptr;
                cflg = 1;
                cptr = (s)? s: "";
                execute(cmd(NL, NLFLG|MTFLG), 0);
                cflg = svflg;
                cptr = svptr;
	} else if (fp != NULL) {
		svflg = cflg;
		svfp = cfp;
		cflg = 0;
		cfp = fp;
                execute(cmd(NL, NLFLG|MTFLG), 0);
                cflg = svflg;
                cfp = svfp;
	}
}
