
/***************************************************************************
*   Copyright (C) 2006 by Andras Mantia                                   *
*   amantia@kde.org                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "setuphelper.h"
#include "blockingtdeprocess.h"
#include "driver.h"
#include <kdebug.h>
#include "tdetempfile.h" /* defines [function] KTempDir */
#include "tdestandarddirs.h" /* defines [function] locateLocal */
#include "tqdir.h" /* defines TQDir */
#include <stdio.h>

namespace SetupHelper {
  
TQString getGccIncludePath(bool *ok)
{
  *ok = true;
  TQString processStdout; 
  BlockingTDEProcess proc;
  proc << "gcc" ;
  proc << "-print-file-name=include" ;
  if ( !proc.start(TDEProcess::NotifyOnExit, TDEProcess::Stdout) ) {
    kdWarning(9007) << "Couldn't start gcc" << endl;
    *ok = false;
    return TQString();
  }
  processStdout = proc.stdOut();    

  return processStdout;
}

TQString getVerboseGccIncludePath(bool *ok)
{
  *ok = false;
  ///Create temp file
  KTempFile tempFile(locateLocal("tmp", "tdevelop_temp"), ".cpp");
  tempFile.setAutoDelete(true);
  if( tempFile.status() != 0 ) 
    return TQString();//Failed to create temp file
  
  TQString path = tempFile.name();
  TQFileInfo pathInfo( path );

  char fileText[] = "//This source-file is empty";
  fwrite(fileText, strlen(fileText), 1, tempFile.fstream() );
  tempFile.close();
  
  BlockingTDEProcess proc;
  proc.setUseShell(true);
  proc.setWorkingDirectory(pathInfo.dir(true).path());
  proc << "gcc -v " + pathInfo.fileName() + " 2>&1";
  if ( !proc.start(TDEProcess::NotifyOnExit, TDEProcess::Stdout) ) {
    kdWarning(9007) << "Couldn't start gcc" << endl;
    *ok = false;
    return TQString();
  }
  *ok = true;
  return proc.stdOut();
}

TQStringList getGccMacros(bool *ok)
{
  *ok = true;
  TQString processStdout; 
  BlockingTDEProcess proc;
  proc << "gcc";
  proc << "-E";
  proc << "-dM";
  proc << "-ansi" ;
  proc << "-";
  if ( !proc.start(TDEProcess::NotifyOnExit, TDEProcess::Stdout) ) {
    kdWarning(9007) << "Couldn't start gcc" << endl;
    *ok = false;
    return TQStringList();
  }
  proc.closeStdin();
  processStdout = proc.stdOut(); 
  TQStringList lines = TQStringList::split('\n', processStdout);
  return lines;
}

}
