#ifndef FILEPROPSPAGE_H
#define FILEPROPSPAGE_H
#include "filepropspagebase.h"
#include <tqstring.h>
#include <tqptrlist.h>


class ClassFileProp {
 public:
  TQString m_classname;
  TQString m_implfile;
  TQString m_headerfile;
  TQString m_baseclass;
  TQString m_description; // rich text
  /** to idetify this object*/
  TQString m_key; 
  bool m_change_baseclass;
};

class FilePropsPage : public FilePropsPageBase
{ 
    TQ_OBJECT
  

public:
    FilePropsPage( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~FilePropsPage();
    void setClassFileProps(TQPtrList<ClassFileProp> props,bool different_header_impl=true);
    TQPtrList<ClassFileProp> getClassFileProps();

public slots:
    void slotSelectionChanged(); 
 virtual void slotClassnameChanged(const TQString&);
 protected:
 
 TQPtrList<ClassFileProp>* m_props;
 bool m_different_header_impl;
 uint m_current_class;
 
};


#endif // FILEPROPSPAGE_H
