/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tdeapplication.h>
#include <tdeuniqueapplication.h> 

#include "knutclient.h"

#include <stdio.h>
#include <stdlib.h>

static const char *description =
  I18N_NOOP("Client for Network UPS Tool");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static TDECmdLineOptions options[] =
{
  {"nodock",I18N_NOOP("Don't dock in Kicker"),0},
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};



int main(int argc, char *argv[])
{

  TDEAboutData aboutData( "knutclient", I18N_NOOP("KNutClient"),
    VERSION, description, TDEAboutData::License_GPL,
    "(c) 2002 - 2009 Daniel Prynych", "Zajecov, Czech Republic", 0, "Daniel@prynych.cz");
  aboutData.addAuthor("Daniel Prynych",0, "Daniel@prynych.cz","http://www.knut.noveradsl.cz/knutclient/");
  aboutData.addCredit("Arnaud Quette",0,"arnaud.quette@free.fr","http://www.networkupstools.org/");
  aboutData.addCredit("MGE",0,0,"http://opensource.mgeups.com");

  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  TDEUniqueApplication::addCmdLineOptions();

  TDECmdLineArgs* args = TDECmdLineArgs::parsedArgs();
  bool noDock = args->isSet("dock");
  args->clear();

 // main KUApp this is remark
  if (!TDEUniqueApplication::start()) {
    fprintf(stderr,"Sorry : KNutClient is already running!\n");
    exit(0);
    }
  TDEUniqueApplication a;

//  next line is for testing only.
//  I don't debug TDEUniqueApplication 

//  TDEApplication a;
//
  KNutClient *knutclient = new KNutClient(!noDock);
  int returnCode = a.exec();
  delete knutclient;
  return returnCode;
}
