/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef TEXTSTORE_H_
#define TEXTSTORE_H_

#include <gtk/gtk.h>

extern const gchar *const encoding_names[];

/* Order of fields is important. */
typedef struct {
    gshort encoding; /* index in encoding_names, -1 - undefined */
    const gchar *line_term; /* NULL - unknown. */
    gboolean bom       /*:1*/, /* not bitfields to take pointers */
             bom_known /*:1*/;
} TextFileFormat;

/* TODO: should it be remove and replaced with NULL pointer? */
extern const TextFileFormat default_text_file_format;

/* Intented to call a dialog box. */
typedef gboolean (*text_file_format_callback) (TextFileFormat *format,
                                               gpointer user_data);

gboolean text_buffer_save(GtkTextBuffer *buffer,
                          const gchar *file_name,
                          const TextFileFormat *format,
                          GError **error);

/* Following functions use autodetection of line breaks. */

/* Returns FALSE if old text is unchanged. */
/* Also resets modified flag. */
gboolean text_buffer_load(GtkTextBuffer              *buffer,
                          const gchar                *file_name,
                          /*gsize                      *size,*/
                          TextFileFormat            **format,
                          text_file_format_callback   format_callback,
                          gpointer                    user_data,
                          gboolean                    ask_user,
                          GError                    **error);

/* Returns FALSE if old text is unchanged. */
/* FIXME: **format */
gboolean text_buffer_insert_file_at_cursor(GtkWidget                 *window,
                                           GtkTextBuffer             *buffer,
                                           const gchar               *file_name,
                                           TextFileFormat            *format,
                                           text_file_format_callback  format_callback,
                                           gpointer                   user_data,
                                           gboolean                   ask_user);

gchar          *text_file_format_to_str  (const TextFileFormat *format    );
TextFileFormat *text_file_format_from_str(const gchar          *format_str);

const gchar *decode_line_term(const gchar *hex );
gchar       *encode_line_term(const gchar *term);

#endif /* TEXTSTORE_H_ */
