/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SYNTAX_H_
#define SYNTAX_H_

typedef struct {
    /*GtkTextTag *tag;*/
    gboolean highlighted :1; /* to be colorized and is shown in the UI list of tags. */
} SyntaxTagInfo;

typedef guint32 syntax_tag_mask_t; /* So currently 32 tags per highlighter maximum. */

typedef struct [
    syntax_tag_mask_t on, off;
} syntax_tags_on_off_t;

typedef enum {
    ssm_string, /* match_str is used */
    ssm_func_on_iter, /* gboolean (*match_func)(GtkTextIter *iter) - may move iter if matched */
    ssm_func_on_unichar /* gboolean (*match_func)(unichar c) */
} SyntaxStrMatchKind;

typedef struct {
    syntax_tags_on_off_t condition;
    SyntaxStrMatchKind match_kind;
    const gchar *match_str;
    gboolean (*match_func)();
    syntax_tags_on_off_t action;
    gboolean after :1, /* Start/end after the string. */
             final :1; /* if rule matched, don't continue with other rules */
} SyntaxRule;

typedef struct {
    SynataxTagInfo *tags;
    SyntaxRule *rules;
} SyntaxHighlighter;

void syntax_highlight_region(Highlighter *engine, GtkTextIter *start, GtkTextIter *end);

void syntax_highlight_buffer(Highlighter *engine, GtkTextBuffer *buffer);

/* Like syntax_highlight_region() but stops as the state compares equal to the existing state */
/* (I.e. rehighlight only until needed.) */
void syntax_rehighlight(Highlighter *engine, GtkTextIter *start, GtkTextIter *end);

#endif /* SYNTAX_H_ */
