/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MAIN_H_
#define MAIN_H_

#include <gtk/gtk.h>

#include "iniparser/dictionary.h"

GtkTooltips *file_tips;

#ifdef G_PLATFORM_WIN32
gboolean is_windows_nt(void);
#endif

GtkWidget *my_gtk_widget_get_toplevel(GtkWidget *widget);

void alarm_message(GtkWidget *window, const char *str);
#ifdef GDK_WINDOWING_WIN32
void win32_error_message(GtkWidget *window, const gchar *prefix);
#endif
void errno_or_win32_error_message(GtkWidget *window, const gchar *prefix);
void my_g_error_message(GtkWidget *window, GError *error);

void my_disable_window_resize(GtkWindow *window);

void call_text_font_dialog(GtkWidget *window);

void about_box(GtkWidget *mainwin);

gboolean check_regcode(const gchar *full_name, guint32 code);
gboolean is_registered_version();

#if defined(HAVE_GNOME) || defined(G_OS_WIN32)
void my_open_browser(const gchar *url);
#endif

#endif /* MAIN_H_ */
