#ifndef ENCODING_H_
#define ENCODING_H_

#include <gtk/gtk.h>

#include "textstore.h"

extern const gchar *const encoding_names[];
extern const int num_encodings;
extern const int num_encodings_with_bom;

struct SelectEncodingDialog_ {
    GtkWidget *dialog, *list_view, *bom_check, *crlf_check; /* bom_check and crlf_check may be NULL */
};
typedef struct SelectEncodingDialog_ SelectEncodingDialog;

void create_select_encoding_dialog(GtkWidget *mainwin,
                                   const gchar *title,
                                   SelectEncodingDialog *se_dlg,
                                   gboolean is_write,
                                   TextFileFormat *fmt);

void select_encoding_dialog_get_encoding(SelectEncodingDialog *se_dlg,
                                         TextFileFormat *fmt);

gboolean enc_has_bom(const TextFileFormat *fmt);

#endif /* ENCODING_H_ */
