#ifndef DOCUMENT_H_
#define DOCUMENT_H_

#include <gtk/gtk.h>

#define TYPE_FILE_DOCUMENT  (file_document_get_type())
#define FILE_DOCUMENT(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FILE_DOCUMENT, FileDocument))
#define FILE_DOCUMENT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FILE_DOCUMENT, FileDocumentClass))
#define IS_FILE_DOCUMENT(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FILE_DOCUMENT))
#define IS_FILE_DOCUMENT_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FILE_DOCUMENT))
#define FILE_DOCUMENT_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FILE_DOCUMENT, FileDocumentClass))

struct FileDocumentClass_;
struct FileDocument_;

typedef struct FileDocumentClass_ FileDocumentClass;
typedef struct FileDocument_      FileDocument;

/* Return FALSE only on error. */
typedef gboolean (*file_document_callback_t)      (gpointer doc_data,
                                                   gpointer *format,
                                                   GError **error);
typedef gboolean (*file_document_file_callback_t) (gpointer doc_data,
                                                   const gchar *file_name,
                                                   gpointer *format,
                                                   GError **error);

FileDocument *file_document_new(GtkWidget *parent_window,
                                gpointer doc_data,
                                file_document_callback_t clear,
                                file_document_file_callback_t save,
                                file_document_file_callback_t load,
                                void (*report_error)(gpointer data, GError *error));

typedef void (*file_document_format_destroy_t)(gpointer format);
typedef gpointer (*file_document_format_copy_t)(const gpointer format);

void file_document_set_format_operations(FileDocument *document,
                                         file_document_format_destroy_t destroy_func,
                                         file_document_format_copy_t    copy_func);

/* These functions return FALSE ONLY on error (not on user pressed Cancel). */
gboolean file_document_do_load_file(FileDocument *document,
                                    const gchar *file_name,
                                    gpointer *format);
/* File/New menu item */
gboolean file_document_new_file(FileDocument *document, gpointer *format);
gboolean file_document_save    (FileDocument *document);
gboolean file_document_save_as (FileDocument *document, gpointer *format);
gboolean file_document_open    (FileDocument *document, gpointer *format);
gboolean file_document_revert  (FileDocument *document);
/*gboolean file_document_rename_file(FileDocument *document, const gchar *file_name);*/

gboolean file_document_check_save(FileDocument *document);

const gchar *file_document_get_file_name(FileDocument *document);

gboolean file_document_get_modified(FileDocument *document);
void     file_document_set_modified(FileDocument *document, gboolean modified);

gpointer file_document_get_data(FileDocument *document);
void file_document_set_data(FileDocument *document, gpointer data);

gpointer *file_document_get_format(FileDocument *document);
gpointer file_document_get_format_copy(FileDocument *document);
void     file_document_set_format(FileDocument *document, const gpointer format);

void     file_document_format_destroy(FileDocument *document, gpointer format);
gpointer file_document_format_copy   (const FileDocument *document, gpointer format);

#endif /* DOCUMENT_H_ */
