#include <stdio.h>
#include <glib.h>

const int num_encodings_with_bom = 5;

const char *encs_list[] = {
    /* Firstly go encodings with BOM. Order of these is important. */
    "UTF-8",
    "UTF-16BE",
    "UTF-16LE",
    "UTF-32BE",
    "UTF-32LE",
    /* Now encodings without BOM. */
    "UTF-7", /* TODO: What is BOM for UTF-7? */
    "ASCII",
    "BIG-5",
    "KOI8-R",
    "KOI8-T",
    "KOI8-U",
    "MACINTOSH",
    "MACUK",
    "MACIS",
    "MACCYRILLIC",
    "MACUKRAINIAN",
    "CP1250",
    "CP1251",
    "CP1252",
    "CP1253",
    "CP1254",
    "CP1255",
    "CP1256",
    "CP1257",
    "CP1258",
    "ISO-8859-1",
    "ISO-8859-2",
    "ISO-8859-3",
    "ISO-8859-4",
    "ISO-8859-5",
    "ISO-8859-6",
    "ISO-8859-7",
    "ISO-8859-8",
    "ISO-8859-9",
    "ISO-8859-10",
    "ISO-8859-11",
    "ISO-8859-13",
    "ISO-8859-14",
    "ISO-8859-15",
    "ISO-8859-16",
    "437",
    "500",
    "850",
    "851",
    "852",
    "855",
    "856",
    "857",
    "860",
    "861",
    "862",
    "863",
    "864",
    "865",
    "866",
    "869",
    "874",
    "904"
};

const int encs_list_len = sizeof(encs_list)/sizeof(encs_list[0]);

gboolean test_encoding(const char *enc)
{
    GIConv ic;

    printf("Checking for encoding %s... ", (char*)enc);
    ic = g_iconv_open(enc, "UTF-8");
    if(ic == (GIConv)-1) goto no;
    ic = g_iconv_open("UTF-8", enc);
    if(ic == (GIConv)-1) goto no;
    goto yes;
no:
    printf("no\n");
    return FALSE;
yes:
    printf("yes\n");
    return TRUE;
}

int main(int argc, char *argv[])
{
    FILE *h_file;
    int i, found_with_bom = 0, real_num_encs = 0;

    h_file = fopen("encodings.c", "w");
    fprintf(h_file, "/* Autogenerated by configure. Do not edit. */\n"
                    /*"#ifndef ENCODINGS_H_\n"*/
                    /*"#define ENCODINGS_H_\n\n"*/
		    "#define N_(s) s\n\n"
                    "const char *const encoding_names[] = {\n");
    for(i=0; i<encs_list_len; ++i) {
        const char *enc = encs_list[i];

        if(test_encoding(enc)) {
            if(i < num_encodings_with_bom) ++found_with_bom;
            fprintf(h_file, "    N_(\"%s\")%s\n",
                    enc,
                    i == encs_list_len-1 ? "" : ",");
	    ++real_num_encs;
        }
    }
    fprintf(h_file, "};\n\n"
                    "const int num_encodings = %d;\n"
                    "const int num_encodings_with_bom = %d;\n\n"
#if 0
                    "#endif /* ENCODINGS_H_ */\n"
#endif
		    ,
                    (int)real_num_encs, (int)found_with_bom);
    fclose(h_file);
}
