// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================

/* Copyright (C) 2010 Denali Software Inc.  All rights reserved              */
/* THIS FILE IS AUTOMATICALLY GENERATED BY DENALI BLUEPRINT, DO NOT EDIT     */


#ifndef _WMAC_DMA_REG_REG_H_
#define _WMAC_DMA_REG_REG_H_


/* macros for MAC_DMA_CR */
#define MAC_DMA_CR_ADDRESS                                                                0x00000008
#define MAC_DMA_CR_OFFSET                                                                 0x00000008
#define MAC_DMA_CR_RXE_LP_MSB                                                                      2
#define MAC_DMA_CR_RXE_LP_LSB                                                                      2
#define MAC_DMA_CR_RXE_LP_MASK                                                            0x00000004
#define MAC_DMA_CR_RXE_LP_GET(x)                                           (((x) & 0x00000004) >> 2)
#define MAC_DMA_CR_RXE_HP_MSB                                                                      3
#define MAC_DMA_CR_RXE_HP_LSB                                                                      3
#define MAC_DMA_CR_RXE_HP_MASK                                                            0x00000008
#define MAC_DMA_CR_RXE_HP_GET(x)                                           (((x) & 0x00000008) >> 3)
#define MAC_DMA_CR_RXD_MSB                                                                         5
#define MAC_DMA_CR_RXD_LSB                                                                         5
#define MAC_DMA_CR_RXD_MASK                                                               0x00000020
#define MAC_DMA_CR_RXD_GET(x)                                              (((x) & 0x00000020) >> 5)
#define MAC_DMA_CR_RXD_SET(x)                                              (((x) << 5) & 0x00000020)
#define MAC_DMA_CR_SWI_MSB                                                                         6
#define MAC_DMA_CR_SWI_LSB                                                                         6
#define MAC_DMA_CR_SWI_MASK                                                               0x00000040
#define MAC_DMA_CR_SWI_GET(x)                                              (((x) & 0x00000040) >> 6)

/* macros for MAC_DMA_CFG */
#define MAC_DMA_CFG_ADDRESS                                                               0x00000014
#define MAC_DMA_CFG_OFFSET                                                                0x00000014
#define MAC_DMA_CFG_BE_MODE_XMIT_DESC_MSB                                                          0
#define MAC_DMA_CFG_BE_MODE_XMIT_DESC_LSB                                                          0
#define MAC_DMA_CFG_BE_MODE_XMIT_DESC_MASK                                                0x00000001
#define MAC_DMA_CFG_BE_MODE_XMIT_DESC_GET(x)                               (((x) & 0x00000001) >> 0)
#define MAC_DMA_CFG_BE_MODE_XMIT_DESC_SET(x)                               (((x) << 0) & 0x00000001)
#define MAC_DMA_CFG_BE_MODE_XMIT_DATA_MSB                                                          1
#define MAC_DMA_CFG_BE_MODE_XMIT_DATA_LSB                                                          1
#define MAC_DMA_CFG_BE_MODE_XMIT_DATA_MASK                                                0x00000002
#define MAC_DMA_CFG_BE_MODE_XMIT_DATA_GET(x)                               (((x) & 0x00000002) >> 1)
#define MAC_DMA_CFG_BE_MODE_XMIT_DATA_SET(x)                               (((x) << 1) & 0x00000002)
#define MAC_DMA_CFG_BE_MODE_RCV_DESC_MSB                                                           2
#define MAC_DMA_CFG_BE_MODE_RCV_DESC_LSB                                                           2
#define MAC_DMA_CFG_BE_MODE_RCV_DESC_MASK                                                 0x00000004
#define MAC_DMA_CFG_BE_MODE_RCV_DESC_GET(x)                                (((x) & 0x00000004) >> 2)
#define MAC_DMA_CFG_BE_MODE_RCV_DESC_SET(x)                                (((x) << 2) & 0x00000004)
#define MAC_DMA_CFG_BE_MODE_RCV_DATA_MSB                                                           3
#define MAC_DMA_CFG_BE_MODE_RCV_DATA_LSB                                                           3
#define MAC_DMA_CFG_BE_MODE_RCV_DATA_MASK                                                 0x00000008
#define MAC_DMA_CFG_BE_MODE_RCV_DATA_GET(x)                                (((x) & 0x00000008) >> 3)
#define MAC_DMA_CFG_BE_MODE_RCV_DATA_SET(x)                                (((x) << 3) & 0x00000008)
#define MAC_DMA_CFG_BE_MODE_MMR_MSB                                                                4
#define MAC_DMA_CFG_BE_MODE_MMR_LSB                                                                4
#define MAC_DMA_CFG_BE_MODE_MMR_MASK                                                      0x00000010
#define MAC_DMA_CFG_BE_MODE_MMR_GET(x)                                     (((x) & 0x00000010) >> 4)
#define MAC_DMA_CFG_BE_MODE_MMR_SET(x)                                     (((x) << 4) & 0x00000010)
#define MAC_DMA_CFG_ADHOC_MSB                                                                      5
#define MAC_DMA_CFG_ADHOC_LSB                                                                      5
#define MAC_DMA_CFG_ADHOC_MASK                                                            0x00000020
#define MAC_DMA_CFG_ADHOC_GET(x)                                           (((x) & 0x00000020) >> 5)
#define MAC_DMA_CFG_ADHOC_SET(x)                                           (((x) << 5) & 0x00000020)
#define MAC_DMA_CFG_PHY_OK_MSB                                                                     8
#define MAC_DMA_CFG_PHY_OK_LSB                                                                     8
#define MAC_DMA_CFG_PHY_OK_MASK                                                           0x00000100
#define MAC_DMA_CFG_PHY_OK_GET(x)                                          (((x) & 0x00000100) >> 8)
#define MAC_DMA_CFG_EEPROM_BUSY_MSB                                                                9
#define MAC_DMA_CFG_EEPROM_BUSY_LSB                                                                9
#define MAC_DMA_CFG_EEPROM_BUSY_MASK                                                      0x00000200
#define MAC_DMA_CFG_EEPROM_BUSY_GET(x)                                     (((x) & 0x00000200) >> 9)
#define MAC_DMA_CFG_CLKGATE_DIS_MSB                                                               10
#define MAC_DMA_CFG_CLKGATE_DIS_LSB                                                               10
#define MAC_DMA_CFG_CLKGATE_DIS_MASK                                                      0x00000400
#define MAC_DMA_CFG_CLKGATE_DIS_GET(x)                                    (((x) & 0x00000400) >> 10)
#define MAC_DMA_CFG_CLKGATE_DIS_SET(x)                                    (((x) << 10) & 0x00000400)
#define MAC_DMA_CFG_HALT_REQ_MSB                                                                  11
#define MAC_DMA_CFG_HALT_REQ_LSB                                                                  11
#define MAC_DMA_CFG_HALT_REQ_MASK                                                         0x00000800
#define MAC_DMA_CFG_HALT_REQ_GET(x)                                       (((x) & 0x00000800) >> 11)
#define MAC_DMA_CFG_HALT_REQ_SET(x)                                       (((x) << 11) & 0x00000800)
#define MAC_DMA_CFG_HALT_ACK_MSB                                                                  12
#define MAC_DMA_CFG_HALT_ACK_LSB                                                                  12
#define MAC_DMA_CFG_HALT_ACK_MASK                                                         0x00001000
#define MAC_DMA_CFG_HALT_ACK_GET(x)                                       (((x) & 0x00001000) >> 12)
#define MAC_DMA_CFG_REQ_Q_FULL_THRESHOLD_MSB                                                      18
#define MAC_DMA_CFG_REQ_Q_FULL_THRESHOLD_LSB                                                      17
#define MAC_DMA_CFG_REQ_Q_FULL_THRESHOLD_MASK                                             0x00060000
#define MAC_DMA_CFG_REQ_Q_FULL_THRESHOLD_GET(x)                           (((x) & 0x00060000) >> 17)
#define MAC_DMA_CFG_REQ_Q_FULL_THRESHOLD_SET(x)                           (((x) << 17) & 0x00060000)
#define MAC_DMA_CFG_MISSING_TX_INTR_FIX_ENABLE_MSB                                                19
#define MAC_DMA_CFG_MISSING_TX_INTR_FIX_ENABLE_LSB                                                19
#define MAC_DMA_CFG_MISSING_TX_INTR_FIX_ENABLE_MASK                                       0x00080000
#define MAC_DMA_CFG_MISSING_TX_INTR_FIX_ENABLE_GET(x)                     (((x) & 0x00080000) >> 19)
#define MAC_DMA_CFG_MISSING_TX_INTR_FIX_ENABLE_SET(x)                     (((x) << 19) & 0x00080000)
#define MAC_DMA_CFG_LEGACY_INT_MIT_MODE_ENABLE_MSB                                                20
#define MAC_DMA_CFG_LEGACY_INT_MIT_MODE_ENABLE_LSB                                                20
#define MAC_DMA_CFG_LEGACY_INT_MIT_MODE_ENABLE_MASK                                       0x00100000
#define MAC_DMA_CFG_LEGACY_INT_MIT_MODE_ENABLE_GET(x)                     (((x) & 0x00100000) >> 20)
#define MAC_DMA_CFG_LEGACY_INT_MIT_MODE_ENABLE_SET(x)                     (((x) << 20) & 0x00100000)
#define MAC_DMA_CFG_RESET_INT_MIT_CNTRS_MSB                                                       21
#define MAC_DMA_CFG_RESET_INT_MIT_CNTRS_LSB                                                       21
#define MAC_DMA_CFG_RESET_INT_MIT_CNTRS_MASK                                              0x00200000
#define MAC_DMA_CFG_RESET_INT_MIT_CNTRS_GET(x)                            (((x) & 0x00200000) >> 21)
#define MAC_DMA_CFG_RESET_INT_MIT_CNTRS_SET(x)                            (((x) << 21) & 0x00200000)

/* macros for MAC_DMA_RXBUFPTR_THRESH */
#define MAC_DMA_RXBUFPTR_THRESH_ADDRESS                                                   0x00000018
#define MAC_DMA_RXBUFPTR_THRESH_OFFSET                                                    0x00000018
#define MAC_DMA_RXBUFPTR_THRESH_HP_DATA_MSB                                                        3
#define MAC_DMA_RXBUFPTR_THRESH_HP_DATA_LSB                                                        0
#define MAC_DMA_RXBUFPTR_THRESH_HP_DATA_MASK                                              0x0000000f
#define MAC_DMA_RXBUFPTR_THRESH_HP_DATA_GET(x)                             (((x) & 0x0000000f) >> 0)
#define MAC_DMA_RXBUFPTR_THRESH_HP_DATA_SET(x)                             (((x) << 0) & 0x0000000f)
#define MAC_DMA_RXBUFPTR_THRESH_LP_DATA_MSB                                                       14
#define MAC_DMA_RXBUFPTR_THRESH_LP_DATA_LSB                                                        8
#define MAC_DMA_RXBUFPTR_THRESH_LP_DATA_MASK                                              0x00007f00
#define MAC_DMA_RXBUFPTR_THRESH_LP_DATA_GET(x)                             (((x) & 0x00007f00) >> 8)
#define MAC_DMA_RXBUFPTR_THRESH_LP_DATA_SET(x)                             (((x) << 8) & 0x00007f00)

/* macros for MAC_DMA_TXDPPTR_THRESH */
#define MAC_DMA_TXDPPTR_THRESH_ADDRESS                                                    0x0000001c
#define MAC_DMA_TXDPPTR_THRESH_OFFSET                                                     0x0000001c
#define MAC_DMA_TXDPPTR_THRESH_DATA_MSB                                                            3
#define MAC_DMA_TXDPPTR_THRESH_DATA_LSB                                                            0
#define MAC_DMA_TXDPPTR_THRESH_DATA_MASK                                                  0x0000000f
#define MAC_DMA_TXDPPTR_THRESH_DATA_GET(x)                                 (((x) & 0x0000000f) >> 0)
#define MAC_DMA_TXDPPTR_THRESH_DATA_SET(x)                                 (((x) << 0) & 0x0000000f)

/* macros for MAC_DMA_MIRT */
#define MAC_DMA_MIRT_ADDRESS                                                              0x00000020
#define MAC_DMA_MIRT_OFFSET                                                               0x00000020
#define MAC_DMA_MIRT_RATE_THRESH_MSB                                                              15
#define MAC_DMA_MIRT_RATE_THRESH_LSB                                                               0
#define MAC_DMA_MIRT_RATE_THRESH_MASK                                                     0x0000ffff
#define MAC_DMA_MIRT_RATE_THRESH_GET(x)                                    (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_MIRT_RATE_THRESH_SET(x)                                    (((x) << 0) & 0x0000ffff)

/* macros for MAC_DMA_GLOBAL_IER */
#define MAC_DMA_GLOBAL_IER_ADDRESS                                                        0x00000024
#define MAC_DMA_GLOBAL_IER_OFFSET                                                         0x00000024
#define MAC_DMA_GLOBAL_IER_ENABLE_MSB                                                              0
#define MAC_DMA_GLOBAL_IER_ENABLE_LSB                                                              0
#define MAC_DMA_GLOBAL_IER_ENABLE_MASK                                                    0x00000001
#define MAC_DMA_GLOBAL_IER_ENABLE_GET(x)                                   (((x) & 0x00000001) >> 0)
#define MAC_DMA_GLOBAL_IER_ENABLE_SET(x)                                   (((x) << 0) & 0x00000001)

/* macros for MAC_DMA_TIMT_0 */
#define MAC_DMA_TIMT_0_ADDRESS                                                            0x00000028
#define MAC_DMA_TIMT_0_OFFSET                                                             0x00000028
#define MAC_DMA_TIMT_0_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_0_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_0_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_0_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_0_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_0_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_0_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_0_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_0_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_0_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_RIMT */
#define MAC_DMA_RIMT_ADDRESS                                                              0x0000002c
#define MAC_DMA_RIMT_OFFSET                                                               0x0000002c
#define MAC_DMA_RIMT_RX_LAST_PKT_THRESH_MSB                                                       15
#define MAC_DMA_RIMT_RX_LAST_PKT_THRESH_LSB                                                        0
#define MAC_DMA_RIMT_RX_LAST_PKT_THRESH_MASK                                              0x0000ffff
#define MAC_DMA_RIMT_RX_LAST_PKT_THRESH_GET(x)                             (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_RIMT_RX_LAST_PKT_THRESH_SET(x)                             (((x) << 0) & 0x0000ffff)
#define MAC_DMA_RIMT_RX_FIRST_PKT_THRESH_MSB                                                      31
#define MAC_DMA_RIMT_RX_FIRST_PKT_THRESH_LSB                                                      16
#define MAC_DMA_RIMT_RX_FIRST_PKT_THRESH_MASK                                             0xffff0000
#define MAC_DMA_RIMT_RX_FIRST_PKT_THRESH_GET(x)                           (((x) & 0xffff0000) >> 16)
#define MAC_DMA_RIMT_RX_FIRST_PKT_THRESH_SET(x)                           (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TXCFG */
#define MAC_DMA_TXCFG_ADDRESS                                                             0x00000030
#define MAC_DMA_TXCFG_OFFSET                                                              0x00000030
#define MAC_DMA_TXCFG_DMA_SIZE_MSB                                                                 2
#define MAC_DMA_TXCFG_DMA_SIZE_LSB                                                                 0
#define MAC_DMA_TXCFG_DMA_SIZE_MASK                                                       0x00000007
#define MAC_DMA_TXCFG_DMA_SIZE_GET(x)                                      (((x) & 0x00000007) >> 0)
#define MAC_DMA_TXCFG_DMA_SIZE_SET(x)                                      (((x) << 0) & 0x00000007)
#define MAC_DMA_TXCFG_TRIGLVL_MSB                                                                  9
#define MAC_DMA_TXCFG_TRIGLVL_LSB                                                                  4
#define MAC_DMA_TXCFG_TRIGLVL_MASK                                                        0x000003f0
#define MAC_DMA_TXCFG_TRIGLVL_GET(x)                                       (((x) & 0x000003f0) >> 4)
#define MAC_DMA_TXCFG_TRIGLVL_SET(x)                                       (((x) << 4) & 0x000003f0)
#define MAC_DMA_TXCFG_JUMBO_EN_MSB                                                                10
#define MAC_DMA_TXCFG_JUMBO_EN_LSB                                                                10
#define MAC_DMA_TXCFG_JUMBO_EN_MASK                                                       0x00000400
#define MAC_DMA_TXCFG_JUMBO_EN_GET(x)                                     (((x) & 0x00000400) >> 10)
#define MAC_DMA_TXCFG_JUMBO_EN_SET(x)                                     (((x) << 10) & 0x00000400)
#define MAC_DMA_TXCFG_BCN_PAST_ATIM_DIS_MSB                                                       11
#define MAC_DMA_TXCFG_BCN_PAST_ATIM_DIS_LSB                                                       11
#define MAC_DMA_TXCFG_BCN_PAST_ATIM_DIS_MASK                                              0x00000800
#define MAC_DMA_TXCFG_BCN_PAST_ATIM_DIS_GET(x)                            (((x) & 0x00000800) >> 11)
#define MAC_DMA_TXCFG_BCN_PAST_ATIM_DIS_SET(x)                            (((x) << 11) & 0x00000800)
#define MAC_DMA_TXCFG_ATIM_DEFER_DIS_MSB                                                          12
#define MAC_DMA_TXCFG_ATIM_DEFER_DIS_LSB                                                          12
#define MAC_DMA_TXCFG_ATIM_DEFER_DIS_MASK                                                 0x00001000
#define MAC_DMA_TXCFG_ATIM_DEFER_DIS_GET(x)                               (((x) & 0x00001000) >> 12)
#define MAC_DMA_TXCFG_ATIM_DEFER_DIS_SET(x)                               (((x) << 12) & 0x00001000)
#define MAC_DMA_TXCFG_RTCI_DIS_MSB                                                                14
#define MAC_DMA_TXCFG_RTCI_DIS_LSB                                                                14
#define MAC_DMA_TXCFG_RTCI_DIS_MASK                                                       0x00004000
#define MAC_DMA_TXCFG_RTCI_DIS_GET(x)                                     (((x) & 0x00004000) >> 14)
#define MAC_DMA_TXCFG_RTCI_DIS_SET(x)                                     (((x) << 14) & 0x00004000)
#define MAC_DMA_TXCFG_DIS_RETRY_UNDERRUN_MSB                                                      17
#define MAC_DMA_TXCFG_DIS_RETRY_UNDERRUN_LSB                                                      17
#define MAC_DMA_TXCFG_DIS_RETRY_UNDERRUN_MASK                                             0x00020000
#define MAC_DMA_TXCFG_DIS_RETRY_UNDERRUN_GET(x)                           (((x) & 0x00020000) >> 17)
#define MAC_DMA_TXCFG_DIS_RETRY_UNDERRUN_SET(x)                           (((x) << 17) & 0x00020000)
#define MAC_DMA_TXCFG_DIS_CW_INC_QUIET_COLL_MSB                                                   18
#define MAC_DMA_TXCFG_DIS_CW_INC_QUIET_COLL_LSB                                                   18
#define MAC_DMA_TXCFG_DIS_CW_INC_QUIET_COLL_MASK                                          0x00040000
#define MAC_DMA_TXCFG_DIS_CW_INC_QUIET_COLL_GET(x)                        (((x) & 0x00040000) >> 18)
#define MAC_DMA_TXCFG_DIS_CW_INC_QUIET_COLL_SET(x)                        (((x) << 18) & 0x00040000)
#define MAC_DMA_TXCFG_RTS_FAIL_EXCESSIVE_RETRIES_MSB                                              19
#define MAC_DMA_TXCFG_RTS_FAIL_EXCESSIVE_RETRIES_LSB                                              19
#define MAC_DMA_TXCFG_RTS_FAIL_EXCESSIVE_RETRIES_MASK                                     0x00080000
#define MAC_DMA_TXCFG_RTS_FAIL_EXCESSIVE_RETRIES_GET(x)                   (((x) & 0x00080000) >> 19)
#define MAC_DMA_TXCFG_RTS_FAIL_EXCESSIVE_RETRIES_SET(x)                   (((x) << 19) & 0x00080000)

/* macros for MAC_DMA_RXCFG */
#define MAC_DMA_RXCFG_ADDRESS                                                             0x00000034
#define MAC_DMA_RXCFG_OFFSET                                                              0x00000034
#define MAC_DMA_RXCFG_DMA_SIZE_MSB                                                                 2
#define MAC_DMA_RXCFG_DMA_SIZE_LSB                                                                 0
#define MAC_DMA_RXCFG_DMA_SIZE_MASK                                                       0x00000007
#define MAC_DMA_RXCFG_DMA_SIZE_GET(x)                                      (((x) & 0x00000007) >> 0)
#define MAC_DMA_RXCFG_DMA_SIZE_SET(x)                                      (((x) << 0) & 0x00000007)
#define MAC_DMA_RXCFG_ZERO_LEN_DMA_EN_MSB                                                          4
#define MAC_DMA_RXCFG_ZERO_LEN_DMA_EN_LSB                                                          3
#define MAC_DMA_RXCFG_ZERO_LEN_DMA_EN_MASK                                                0x00000018
#define MAC_DMA_RXCFG_ZERO_LEN_DMA_EN_GET(x)                               (((x) & 0x00000018) >> 3)
#define MAC_DMA_RXCFG_ZERO_LEN_DMA_EN_SET(x)                               (((x) << 3) & 0x00000018)
#define MAC_DMA_RXCFG_JUMBO_EN_MSB                                                                 5
#define MAC_DMA_RXCFG_JUMBO_EN_LSB                                                                 5
#define MAC_DMA_RXCFG_JUMBO_EN_MASK                                                       0x00000020
#define MAC_DMA_RXCFG_JUMBO_EN_GET(x)                                      (((x) & 0x00000020) >> 5)
#define MAC_DMA_RXCFG_JUMBO_EN_SET(x)                                      (((x) << 5) & 0x00000020)
#define MAC_DMA_RXCFG_JUMBO_WRAP_EN_MSB                                                            6
#define MAC_DMA_RXCFG_JUMBO_WRAP_EN_LSB                                                            6
#define MAC_DMA_RXCFG_JUMBO_WRAP_EN_MASK                                                  0x00000040
#define MAC_DMA_RXCFG_JUMBO_WRAP_EN_GET(x)                                 (((x) & 0x00000040) >> 6)
#define MAC_DMA_RXCFG_JUMBO_WRAP_EN_SET(x)                                 (((x) << 6) & 0x00000040)
#define MAC_DMA_RXCFG_SLEEP_RX_PEND_EN_MSB                                                         7
#define MAC_DMA_RXCFG_SLEEP_RX_PEND_EN_LSB                                                         7
#define MAC_DMA_RXCFG_SLEEP_RX_PEND_EN_MASK                                               0x00000080
#define MAC_DMA_RXCFG_SLEEP_RX_PEND_EN_GET(x)                              (((x) & 0x00000080) >> 7)
#define MAC_DMA_RXCFG_SLEEP_RX_PEND_EN_SET(x)                              (((x) << 7) & 0x00000080)

/* macros for MAC_DMA_RXJLA */
#define MAC_DMA_RXJLA_ADDRESS                                                             0x00000038
#define MAC_DMA_RXJLA_OFFSET                                                              0x00000038
#define MAC_DMA_RXJLA_DATA_MSB                                                                    31
#define MAC_DMA_RXJLA_DATA_LSB                                                                     2
#define MAC_DMA_RXJLA_DATA_MASK                                                           0xfffffffc
#define MAC_DMA_RXJLA_DATA_GET(x)                                          (((x) & 0xfffffffc) >> 2)

/* macros for MAC_DMA_MIBC */
#define MAC_DMA_MIBC_ADDRESS                                                              0x00000040
#define MAC_DMA_MIBC_OFFSET                                                               0x00000040
#define MAC_DMA_MIBC_WARNING_MSB                                                                   0
#define MAC_DMA_MIBC_WARNING_LSB                                                                   0
#define MAC_DMA_MIBC_WARNING_MASK                                                         0x00000001
#define MAC_DMA_MIBC_WARNING_GET(x)                                        (((x) & 0x00000001) >> 0)
#define MAC_DMA_MIBC_FREEZE_MSB                                                                    1
#define MAC_DMA_MIBC_FREEZE_LSB                                                                    1
#define MAC_DMA_MIBC_FREEZE_MASK                                                          0x00000002
#define MAC_DMA_MIBC_FREEZE_GET(x)                                         (((x) & 0x00000002) >> 1)
#define MAC_DMA_MIBC_FREEZE_SET(x)                                         (((x) << 1) & 0x00000002)
#define MAC_DMA_MIBC_CLEAR_MSB                                                                     2
#define MAC_DMA_MIBC_CLEAR_LSB                                                                     2
#define MAC_DMA_MIBC_CLEAR_MASK                                                           0x00000004
#define MAC_DMA_MIBC_CLEAR_GET(x)                                          (((x) & 0x00000004) >> 2)
#define MAC_DMA_MIBC_CLEAR_SET(x)                                          (((x) << 2) & 0x00000004)
#define MAC_DMA_MIBC_STROBE_MSB                                                                    3
#define MAC_DMA_MIBC_STROBE_LSB                                                                    3
#define MAC_DMA_MIBC_STROBE_MASK                                                          0x00000008
#define MAC_DMA_MIBC_STROBE_GET(x)                                         (((x) & 0x00000008) >> 3)

/* macros for MAC_DMA_TOPS */
#define MAC_DMA_TOPS_ADDRESS                                                              0x00000044
#define MAC_DMA_TOPS_OFFSET                                                               0x00000044
#define MAC_DMA_TOPS_TIMEOUT_MSB                                                                  15
#define MAC_DMA_TOPS_TIMEOUT_LSB                                                                   0
#define MAC_DMA_TOPS_TIMEOUT_MASK                                                         0x0000ffff
#define MAC_DMA_TOPS_TIMEOUT_GET(x)                                        (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TOPS_TIMEOUT_SET(x)                                        (((x) << 0) & 0x0000ffff)

/* macros for MAC_DMA_RXNPTO */
#define MAC_DMA_RXNPTO_ADDRESS                                                            0x00000048
#define MAC_DMA_RXNPTO_OFFSET                                                             0x00000048
#define MAC_DMA_RXNPTO_TIMEOUT_MSB                                                                 9
#define MAC_DMA_RXNPTO_TIMEOUT_LSB                                                                 0
#define MAC_DMA_RXNPTO_TIMEOUT_MASK                                                       0x000003ff
#define MAC_DMA_RXNPTO_TIMEOUT_GET(x)                                      (((x) & 0x000003ff) >> 0)
#define MAC_DMA_RXNPTO_TIMEOUT_SET(x)                                      (((x) << 0) & 0x000003ff)

/* macros for MAC_DMA_TXNPTO */
#define MAC_DMA_TXNPTO_ADDRESS                                                            0x0000004c
#define MAC_DMA_TXNPTO_OFFSET                                                             0x0000004c
#define MAC_DMA_TXNPTO_TIMEOUT_MSB                                                                 9
#define MAC_DMA_TXNPTO_TIMEOUT_LSB                                                                 0
#define MAC_DMA_TXNPTO_TIMEOUT_MASK                                                       0x000003ff
#define MAC_DMA_TXNPTO_TIMEOUT_GET(x)                                      (((x) & 0x000003ff) >> 0)
#define MAC_DMA_TXNPTO_TIMEOUT_SET(x)                                      (((x) << 0) & 0x000003ff)
#define MAC_DMA_TXNPTO_MASK_MSB                                                                   19
#define MAC_DMA_TXNPTO_MASK_LSB                                                                   10
#define MAC_DMA_TXNPTO_MASK_MASK                                                          0x000ffc00
#define MAC_DMA_TXNPTO_MASK_GET(x)                                        (((x) & 0x000ffc00) >> 10)
#define MAC_DMA_TXNPTO_MASK_SET(x)                                        (((x) << 10) & 0x000ffc00)

/* macros for MAC_DMA_RPGTO */
#define MAC_DMA_RPGTO_ADDRESS                                                             0x00000050
#define MAC_DMA_RPGTO_OFFSET                                                              0x00000050
#define MAC_DMA_RPGTO_TIMEOUT_MSB                                                                  9
#define MAC_DMA_RPGTO_TIMEOUT_LSB                                                                  0
#define MAC_DMA_RPGTO_TIMEOUT_MASK                                                        0x000003ff
#define MAC_DMA_RPGTO_TIMEOUT_GET(x)                                       (((x) & 0x000003ff) >> 0)
#define MAC_DMA_RPGTO_TIMEOUT_SET(x)                                       (((x) << 0) & 0x000003ff)

/* macros for MAC_DMA_MACMISC */
#define MAC_DMA_MACMISC_ADDRESS                                                           0x00000058
#define MAC_DMA_MACMISC_OFFSET                                                            0x00000058
#define MAC_DMA_MACMISC_FORCE_PCI_EXT_MSB                                                          4
#define MAC_DMA_MACMISC_FORCE_PCI_EXT_LSB                                                          4
#define MAC_DMA_MACMISC_FORCE_PCI_EXT_MASK                                                0x00000010
#define MAC_DMA_MACMISC_FORCE_PCI_EXT_GET(x)                               (((x) & 0x00000010) >> 4)
#define MAC_DMA_MACMISC_FORCE_PCI_EXT_SET(x)                               (((x) << 4) & 0x00000010)
#define MAC_DMA_MACMISC_DMA_OBS_MUXSEL_MSB                                                         8
#define MAC_DMA_MACMISC_DMA_OBS_MUXSEL_LSB                                                         5
#define MAC_DMA_MACMISC_DMA_OBS_MUXSEL_MASK                                               0x000001e0
#define MAC_DMA_MACMISC_DMA_OBS_MUXSEL_GET(x)                              (((x) & 0x000001e0) >> 5)
#define MAC_DMA_MACMISC_DMA_OBS_MUXSEL_SET(x)                              (((x) << 5) & 0x000001e0)
#define MAC_DMA_MACMISC_MISC_OBS_MUXSEL_MSB                                                       11
#define MAC_DMA_MACMISC_MISC_OBS_MUXSEL_LSB                                                        9
#define MAC_DMA_MACMISC_MISC_OBS_MUXSEL_MASK                                              0x00000e00
#define MAC_DMA_MACMISC_MISC_OBS_MUXSEL_GET(x)                             (((x) & 0x00000e00) >> 9)
#define MAC_DMA_MACMISC_MISC_OBS_MUXSEL_SET(x)                             (((x) << 9) & 0x00000e00)
#define MAC_DMA_MACMISC_MISC_F2_OBS_LOW_MUXSEL_MSB                                                14
#define MAC_DMA_MACMISC_MISC_F2_OBS_LOW_MUXSEL_LSB                                                12
#define MAC_DMA_MACMISC_MISC_F2_OBS_LOW_MUXSEL_MASK                                       0x00007000
#define MAC_DMA_MACMISC_MISC_F2_OBS_LOW_MUXSEL_GET(x)                     (((x) & 0x00007000) >> 12)
#define MAC_DMA_MACMISC_MISC_F2_OBS_LOW_MUXSEL_SET(x)                     (((x) << 12) & 0x00007000)
#define MAC_DMA_MACMISC_MISC_F2_OBS_HIGH_MUXSEL_MSB                                               17
#define MAC_DMA_MACMISC_MISC_F2_OBS_HIGH_MUXSEL_LSB                                               15
#define MAC_DMA_MACMISC_MISC_F2_OBS_HIGH_MUXSEL_MASK                                      0x00038000
#define MAC_DMA_MACMISC_MISC_F2_OBS_HIGH_MUXSEL_GET(x)                    (((x) & 0x00038000) >> 15)
#define MAC_DMA_MACMISC_MISC_F2_OBS_HIGH_MUXSEL_SET(x)                    (((x) << 15) & 0x00038000)

/* macros for MAC_DMA_INTER */
#define MAC_DMA_INTER_ADDRESS                                                             0x0000005c
#define MAC_DMA_INTER_OFFSET                                                              0x0000005c
#define MAC_DMA_INTER_REQ_MSB                                                                      0
#define MAC_DMA_INTER_REQ_LSB                                                                      0
#define MAC_DMA_INTER_REQ_MASK                                                            0x00000001
#define MAC_DMA_INTER_REQ_GET(x)                                           (((x) & 0x00000001) >> 0)
#define MAC_DMA_INTER_REQ_SET(x)                                           (((x) << 0) & 0x00000001)
#define MAC_DMA_INTER_MSI_RX_SRC_MSB                                                               2
#define MAC_DMA_INTER_MSI_RX_SRC_LSB                                                               1
#define MAC_DMA_INTER_MSI_RX_SRC_MASK                                                     0x00000006
#define MAC_DMA_INTER_MSI_RX_SRC_GET(x)                                    (((x) & 0x00000006) >> 1)
#define MAC_DMA_INTER_MSI_RX_SRC_SET(x)                                    (((x) << 1) & 0x00000006)
#define MAC_DMA_INTER_MSI_TX_SRC_MSB                                                               4
#define MAC_DMA_INTER_MSI_TX_SRC_LSB                                                               3
#define MAC_DMA_INTER_MSI_TX_SRC_MASK                                                     0x00000018
#define MAC_DMA_INTER_MSI_TX_SRC_GET(x)                                    (((x) & 0x00000018) >> 3)
#define MAC_DMA_INTER_MSI_TX_SRC_SET(x)                                    (((x) << 3) & 0x00000018)

/* macros for MAC_DMA_DATABUF */
#define MAC_DMA_DATABUF_ADDRESS                                                           0x00000060
#define MAC_DMA_DATABUF_OFFSET                                                            0x00000060
#define MAC_DMA_DATABUF_LEN_MSB                                                                   11
#define MAC_DMA_DATABUF_LEN_LSB                                                                    0
#define MAC_DMA_DATABUF_LEN_MASK                                                          0x00000fff
#define MAC_DMA_DATABUF_LEN_GET(x)                                         (((x) & 0x00000fff) >> 0)
#define MAC_DMA_DATABUF_LEN_SET(x)                                         (((x) << 0) & 0x00000fff)

/* macros for MAC_DMA_GTT */
#define MAC_DMA_GTT_ADDRESS                                                               0x00000064
#define MAC_DMA_GTT_OFFSET                                                                0x00000064
#define MAC_DMA_GTT_COUNT_MSB                                                                     15
#define MAC_DMA_GTT_COUNT_LSB                                                                      0
#define MAC_DMA_GTT_COUNT_MASK                                                            0x0000ffff
#define MAC_DMA_GTT_COUNT_GET(x)                                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_GTT_COUNT_SET(x)                                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_GTT_LIMIT_MSB                                                                     31
#define MAC_DMA_GTT_LIMIT_LSB                                                                     16
#define MAC_DMA_GTT_LIMIT_MASK                                                            0xffff0000
#define MAC_DMA_GTT_LIMIT_GET(x)                                          (((x) & 0xffff0000) >> 16)
#define MAC_DMA_GTT_LIMIT_SET(x)                                          (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_GTTM */
#define MAC_DMA_GTTM_ADDRESS                                                              0x00000068
#define MAC_DMA_GTTM_OFFSET                                                               0x00000068
#define MAC_DMA_GTTM_USEC_STROBE_MSB                                                               0
#define MAC_DMA_GTTM_USEC_STROBE_LSB                                                               0
#define MAC_DMA_GTTM_USEC_STROBE_MASK                                                     0x00000001
#define MAC_DMA_GTTM_USEC_STROBE_GET(x)                                    (((x) & 0x00000001) >> 0)
#define MAC_DMA_GTTM_USEC_STROBE_SET(x)                                    (((x) << 0) & 0x00000001)
#define MAC_DMA_GTTM_IGNORE_CHAN_IDLE_MSB                                                          1
#define MAC_DMA_GTTM_IGNORE_CHAN_IDLE_LSB                                                          1
#define MAC_DMA_GTTM_IGNORE_CHAN_IDLE_MASK                                                0x00000002
#define MAC_DMA_GTTM_IGNORE_CHAN_IDLE_GET(x)                               (((x) & 0x00000002) >> 1)
#define MAC_DMA_GTTM_IGNORE_CHAN_IDLE_SET(x)                               (((x) << 1) & 0x00000002)
#define MAC_DMA_GTTM_RESET_ON_CHAN_IDLE_MSB                                                        2
#define MAC_DMA_GTTM_RESET_ON_CHAN_IDLE_LSB                                                        2
#define MAC_DMA_GTTM_RESET_ON_CHAN_IDLE_MASK                                              0x00000004
#define MAC_DMA_GTTM_RESET_ON_CHAN_IDLE_GET(x)                             (((x) & 0x00000004) >> 2)
#define MAC_DMA_GTTM_RESET_ON_CHAN_IDLE_SET(x)                             (((x) << 2) & 0x00000004)
#define MAC_DMA_GTTM_CST_USEC_STROBE_MSB                                                           3
#define MAC_DMA_GTTM_CST_USEC_STROBE_LSB                                                           3
#define MAC_DMA_GTTM_CST_USEC_STROBE_MASK                                                 0x00000008
#define MAC_DMA_GTTM_CST_USEC_STROBE_GET(x)                                (((x) & 0x00000008) >> 3)
#define MAC_DMA_GTTM_CST_USEC_STROBE_SET(x)                                (((x) << 3) & 0x00000008)
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_GTT_MSB                                                 4
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_GTT_LSB                                                 4
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_GTT_MASK                                       0x00000010
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_GTT_GET(x)                      (((x) & 0x00000010) >> 4)
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_GTT_SET(x)                      (((x) << 4) & 0x00000010)
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_BT_MSB                                                  5
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_BT_LSB                                                  5
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_BT_MASK                                        0x00000020
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_BT_GET(x)                       (((x) & 0x00000020) >> 5)
#define MAC_DMA_GTTM_DISABLE_QCU_FR_ACTIVE_BT_SET(x)                       (((x) << 5) & 0x00000020)

/* macros for MAC_DMA_CST */
#define MAC_DMA_CST_ADDRESS                                                               0x0000006c
#define MAC_DMA_CST_OFFSET                                                                0x0000006c
#define MAC_DMA_CST_COUNT_MSB                                                                     15
#define MAC_DMA_CST_COUNT_LSB                                                                      0
#define MAC_DMA_CST_COUNT_MASK                                                            0x0000ffff
#define MAC_DMA_CST_COUNT_GET(x)                                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_CST_COUNT_SET(x)                                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_CST_LIMIT_MSB                                                                     31
#define MAC_DMA_CST_LIMIT_LSB                                                                     16
#define MAC_DMA_CST_LIMIT_MASK                                                            0xffff0000
#define MAC_DMA_CST_LIMIT_GET(x)                                          (((x) & 0xffff0000) >> 16)
#define MAC_DMA_CST_LIMIT_SET(x)                                          (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_RXDP_SIZE */
#define MAC_DMA_RXDP_SIZE_ADDRESS                                                         0x00000070
#define MAC_DMA_RXDP_SIZE_OFFSET                                                          0x00000070
#define MAC_DMA_RXDP_SIZE_LP_MSB                                                                   7
#define MAC_DMA_RXDP_SIZE_LP_LSB                                                                   0
#define MAC_DMA_RXDP_SIZE_LP_MASK                                                         0x000000ff
#define MAC_DMA_RXDP_SIZE_LP_GET(x)                                        (((x) & 0x000000ff) >> 0)
#define MAC_DMA_RXDP_SIZE_HP_MSB                                                                  12
#define MAC_DMA_RXDP_SIZE_HP_LSB                                                                   8
#define MAC_DMA_RXDP_SIZE_HP_MASK                                                         0x00001f00
#define MAC_DMA_RXDP_SIZE_HP_GET(x)                                        (((x) & 0x00001f00) >> 8)

/* macros for MAC_DMA_RX_QUEUE_HP_RXDP */
#define MAC_DMA_RX_QUEUE_HP_RXDP_ADDRESS                                                  0x00000074
#define MAC_DMA_RX_QUEUE_HP_RXDP_OFFSET                                                   0x00000074
#define MAC_DMA_RX_QUEUE_HP_RXDP_ADDR_MSB                                                         31
#define MAC_DMA_RX_QUEUE_HP_RXDP_ADDR_LSB                                                          0
#define MAC_DMA_RX_QUEUE_HP_RXDP_ADDR_MASK                                                0xffffffff
#define MAC_DMA_RX_QUEUE_HP_RXDP_ADDR_GET(x)                               (((x) & 0xffffffff) >> 0)
#define MAC_DMA_RX_QUEUE_HP_RXDP_ADDR_SET(x)                               (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_RX_QUEUE_LP_RXDP */
#define MAC_DMA_RX_QUEUE_LP_RXDP_ADDRESS                                                  0x00000078
#define MAC_DMA_RX_QUEUE_LP_RXDP_OFFSET                                                   0x00000078
#define MAC_DMA_RX_QUEUE_LP_RXDP_ADDR_MSB                                                         31
#define MAC_DMA_RX_QUEUE_LP_RXDP_ADDR_LSB                                                          0
#define MAC_DMA_RX_QUEUE_LP_RXDP_ADDR_MASK                                                0xffffffff
#define MAC_DMA_RX_QUEUE_LP_RXDP_ADDR_GET(x)                               (((x) & 0xffffffff) >> 0)
#define MAC_DMA_RX_QUEUE_LP_RXDP_ADDR_SET(x)                               (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_P */
#define MAC_DMA_ISR_P_ADDRESS                                                             0x00000080
#define MAC_DMA_ISR_P_OFFSET                                                              0x00000080
#define MAC_DMA_ISR_P_DATA_MSB                                                                    31
#define MAC_DMA_ISR_P_DATA_LSB                                                                     0
#define MAC_DMA_ISR_P_DATA_MASK                                                           0xffffffff
#define MAC_DMA_ISR_P_DATA_GET(x)                                          (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_P_DATA_SET(x)                                          (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S0 */
#define MAC_DMA_ISR_S0_ADDRESS                                                            0x00000084
#define MAC_DMA_ISR_S0_OFFSET                                                             0x00000084
#define MAC_DMA_ISR_S0_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S0_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S0_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S0_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S0_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S1 */
#define MAC_DMA_ISR_S1_ADDRESS                                                            0x00000088
#define MAC_DMA_ISR_S1_OFFSET                                                             0x00000088
#define MAC_DMA_ISR_S1_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S1_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S1_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S1_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S1_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S2 */
#define MAC_DMA_ISR_S2_ADDRESS                                                            0x0000008c
#define MAC_DMA_ISR_S2_OFFSET                                                             0x0000008c
#define MAC_DMA_ISR_S2_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S2_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S2_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S2_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S2_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S3 */
#define MAC_DMA_ISR_S3_ADDRESS                                                            0x00000090
#define MAC_DMA_ISR_S3_OFFSET                                                             0x00000090
#define MAC_DMA_ISR_S3_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S3_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S3_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S3_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S3_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S4 */
#define MAC_DMA_ISR_S4_ADDRESS                                                            0x00000094
#define MAC_DMA_ISR_S4_OFFSET                                                             0x00000094
#define MAC_DMA_ISR_S4_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S4_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S4_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S4_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S4_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S5 */
#define MAC_DMA_ISR_S5_ADDRESS                                                            0x00000098
#define MAC_DMA_ISR_S5_OFFSET                                                             0x00000098
#define MAC_DMA_ISR_S5_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S5_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S5_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S5_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S5_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_S6 */
#define MAC_DMA_ISR_S6_ADDRESS                                                            0x0000009c
#define MAC_DMA_ISR_S6_OFFSET                                                             0x0000009c
#define MAC_DMA_ISR_S6_DATA_MSB                                                                   31
#define MAC_DMA_ISR_S6_DATA_LSB                                                                    0
#define MAC_DMA_ISR_S6_DATA_MASK                                                          0xffffffff
#define MAC_DMA_ISR_S6_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_ISR_S6_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_P */
#define MAC_DMA_IMR_P_ADDRESS                                                             0x000000a0
#define MAC_DMA_IMR_P_OFFSET                                                              0x000000a0
#define MAC_DMA_IMR_P_MASK_MSB                                                                    31
#define MAC_DMA_IMR_P_MASK_LSB                                                                     0
#define MAC_DMA_IMR_P_MASK_MASK                                                           0xffffffff
#define MAC_DMA_IMR_P_MASK_GET(x)                                          (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_P_MASK_SET(x)                                          (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S0 */
#define MAC_DMA_IMR_S0_ADDRESS                                                            0x000000a4
#define MAC_DMA_IMR_S0_OFFSET                                                             0x000000a4
#define MAC_DMA_IMR_S0_MASK_MSB                                                                   31
#define MAC_DMA_IMR_S0_MASK_LSB                                                                    0
#define MAC_DMA_IMR_S0_MASK_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S0_MASK_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S0_MASK_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S1 */
#define MAC_DMA_IMR_S1_ADDRESS                                                            0x000000a8
#define MAC_DMA_IMR_S1_OFFSET                                                             0x000000a8
#define MAC_DMA_IMR_S1_DATA_MSB                                                                   31
#define MAC_DMA_IMR_S1_DATA_LSB                                                                    0
#define MAC_DMA_IMR_S1_DATA_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S1_DATA_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S1_DATA_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S2 */
#define MAC_DMA_IMR_S2_ADDRESS                                                            0x000000ac
#define MAC_DMA_IMR_S2_OFFSET                                                             0x000000ac
#define MAC_DMA_IMR_S2_MASK_MSB                                                                   31
#define MAC_DMA_IMR_S2_MASK_LSB                                                                    0
#define MAC_DMA_IMR_S2_MASK_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S2_MASK_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S2_MASK_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S3 */
#define MAC_DMA_IMR_S3_ADDRESS                                                            0x000000b0
#define MAC_DMA_IMR_S3_OFFSET                                                             0x000000b0
#define MAC_DMA_IMR_S3_MASK_MSB                                                                   31
#define MAC_DMA_IMR_S3_MASK_LSB                                                                    0
#define MAC_DMA_IMR_S3_MASK_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S3_MASK_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S3_MASK_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S4 */
#define MAC_DMA_IMR_S4_ADDRESS                                                            0x000000b4
#define MAC_DMA_IMR_S4_OFFSET                                                             0x000000b4
#define MAC_DMA_IMR_S4_MASK_MSB                                                                   31
#define MAC_DMA_IMR_S4_MASK_LSB                                                                    0
#define MAC_DMA_IMR_S4_MASK_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S4_MASK_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S4_MASK_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S5 */
#define MAC_DMA_IMR_S5_ADDRESS                                                            0x000000b8
#define MAC_DMA_IMR_S5_OFFSET                                                             0x000000b8
#define MAC_DMA_IMR_S5_MASK_MSB                                                                   31
#define MAC_DMA_IMR_S5_MASK_LSB                                                                    0
#define MAC_DMA_IMR_S5_MASK_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S5_MASK_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S5_MASK_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_IMR_S6 */
#define MAC_DMA_IMR_S6_ADDRESS                                                            0x000000bc
#define MAC_DMA_IMR_S6_OFFSET                                                             0x000000bc
#define MAC_DMA_IMR_S6_MASK_MSB                                                                   31
#define MAC_DMA_IMR_S6_MASK_LSB                                                                    0
#define MAC_DMA_IMR_S6_MASK_MASK                                                          0xffffffff
#define MAC_DMA_IMR_S6_MASK_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define MAC_DMA_IMR_S6_MASK_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for MAC_DMA_ISR_P_RAC */
#define MAC_DMA_ISR_P_RAC_ADDRESS                                                         0x000000c0
#define MAC_DMA_ISR_P_RAC_OFFSET                                                          0x000000c0
#define MAC_DMA_ISR_P_RAC_DATA_MSB                                                                31
#define MAC_DMA_ISR_P_RAC_DATA_LSB                                                                 0
#define MAC_DMA_ISR_P_RAC_DATA_MASK                                                       0xffffffff
#define MAC_DMA_ISR_P_RAC_DATA_GET(x)                                      (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S0_S */
#define MAC_DMA_ISR_S0_S_ADDRESS                                                          0x000000c4
#define MAC_DMA_ISR_S0_S_OFFSET                                                           0x000000c4
#define MAC_DMA_ISR_S0_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S0_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S0_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S0_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S1_S */
#define MAC_DMA_ISR_S1_S_ADDRESS                                                          0x000000c8
#define MAC_DMA_ISR_S1_S_OFFSET                                                           0x000000c8
#define MAC_DMA_ISR_S1_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S1_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S1_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S1_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S6_S */
#define MAC_DMA_ISR_S6_S_ADDRESS                                                          0x000000cc
#define MAC_DMA_ISR_S6_S_OFFSET                                                           0x000000cc
#define MAC_DMA_ISR_S6_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S6_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S6_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S6_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S2_S */
#define MAC_DMA_ISR_S2_S_ADDRESS                                                          0x000000d0
#define MAC_DMA_ISR_S2_S_OFFSET                                                           0x000000d0
#define MAC_DMA_ISR_S2_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S2_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S2_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S2_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S3_S */
#define MAC_DMA_ISR_S3_S_ADDRESS                                                          0x000000d4
#define MAC_DMA_ISR_S3_S_OFFSET                                                           0x000000d4
#define MAC_DMA_ISR_S3_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S3_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S3_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S3_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S4_S */
#define MAC_DMA_ISR_S4_S_ADDRESS                                                          0x000000d8
#define MAC_DMA_ISR_S4_S_OFFSET                                                           0x000000d8
#define MAC_DMA_ISR_S4_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S4_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S4_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S4_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_ISR_S5_S */
#define MAC_DMA_ISR_S5_S_ADDRESS                                                          0x000000dc
#define MAC_DMA_ISR_S5_S_OFFSET                                                           0x000000dc
#define MAC_DMA_ISR_S5_S_SHADOW_MSB                                                               31
#define MAC_DMA_ISR_S5_S_SHADOW_LSB                                                                0
#define MAC_DMA_ISR_S5_S_SHADOW_MASK                                                      0xffffffff
#define MAC_DMA_ISR_S5_S_SHADOW_GET(x)                                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_0 */
#define MAC_DMA_DMADBG_0_ADDRESS                                                          0x000000e0
#define MAC_DMA_DMADBG_0_OFFSET                                                           0x000000e0
#define MAC_DMA_DMADBG_0_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_0_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_0_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_0_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_1 */
#define MAC_DMA_DMADBG_1_ADDRESS                                                          0x000000e4
#define MAC_DMA_DMADBG_1_OFFSET                                                           0x000000e4
#define MAC_DMA_DMADBG_1_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_1_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_1_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_1_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_2 */
#define MAC_DMA_DMADBG_2_ADDRESS                                                          0x000000e8
#define MAC_DMA_DMADBG_2_OFFSET                                                           0x000000e8
#define MAC_DMA_DMADBG_2_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_2_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_2_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_2_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_3 */
#define MAC_DMA_DMADBG_3_ADDRESS                                                          0x000000ec
#define MAC_DMA_DMADBG_3_OFFSET                                                           0x000000ec
#define MAC_DMA_DMADBG_3_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_3_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_3_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_3_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_4 */
#define MAC_DMA_DMADBG_4_ADDRESS                                                          0x000000f0
#define MAC_DMA_DMADBG_4_OFFSET                                                           0x000000f0
#define MAC_DMA_DMADBG_4_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_4_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_4_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_4_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_5 */
#define MAC_DMA_DMADBG_5_ADDRESS                                                          0x000000f4
#define MAC_DMA_DMADBG_5_OFFSET                                                           0x000000f4
#define MAC_DMA_DMADBG_5_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_5_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_5_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_5_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_6 */
#define MAC_DMA_DMADBG_6_ADDRESS                                                          0x000000f8
#define MAC_DMA_DMADBG_6_OFFSET                                                           0x000000f8
#define MAC_DMA_DMADBG_6_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_6_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_6_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_6_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_DMADBG_7 */
#define MAC_DMA_DMADBG_7_ADDRESS                                                          0x000000fc
#define MAC_DMA_DMADBG_7_OFFSET                                                           0x000000fc
#define MAC_DMA_DMADBG_7_DATA_MSB                                                                 31
#define MAC_DMA_DMADBG_7_DATA_LSB                                                                  0
#define MAC_DMA_DMADBG_7_DATA_MASK                                                        0xffffffff
#define MAC_DMA_DMADBG_7_DATA_GET(x)                                       (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0 */
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_ADDRESS                                        0x00000100
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_OFFSET                                         0x00000100
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_DATA_MSB                                               31
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_DATA_LSB                                                0
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_DATA_MASK                                      0xffffffff
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0_DATA_GET(x)                     (((x) & 0xffffffff) >> 0)

/* macros for MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8 */
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_ADDRESS                                        0x00000104
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_OFFSET                                         0x00000104
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_DATA_MSB                                                7
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_DATA_LSB                                                0
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_DATA_MASK                                      0x000000ff
#define MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8_DATA_GET(x)                     (((x) & 0x000000ff) >> 0)

/* macros for MAC_DMA_TIMT_1 */
#define MAC_DMA_TIMT_1_ADDRESS                                                            0x00000108
#define MAC_DMA_TIMT_1_OFFSET                                                             0x00000108
#define MAC_DMA_TIMT_1_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_1_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_1_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_1_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_1_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_1_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_1_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_1_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_1_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_1_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_2 */
#define MAC_DMA_TIMT_2_ADDRESS                                                            0x0000010c
#define MAC_DMA_TIMT_2_OFFSET                                                             0x0000010c
#define MAC_DMA_TIMT_2_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_2_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_2_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_2_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_2_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_2_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_2_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_2_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_2_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_2_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_3 */
#define MAC_DMA_TIMT_3_ADDRESS                                                            0x00000110
#define MAC_DMA_TIMT_3_OFFSET                                                             0x00000110
#define MAC_DMA_TIMT_3_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_3_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_3_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_3_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_3_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_3_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_3_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_3_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_3_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_3_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_4 */
#define MAC_DMA_TIMT_4_ADDRESS                                                            0x00000114
#define MAC_DMA_TIMT_4_OFFSET                                                             0x00000114
#define MAC_DMA_TIMT_4_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_4_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_4_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_4_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_4_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_4_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_4_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_4_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_4_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_4_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_5 */
#define MAC_DMA_TIMT_5_ADDRESS                                                            0x00000118
#define MAC_DMA_TIMT_5_OFFSET                                                             0x00000118
#define MAC_DMA_TIMT_5_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_5_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_5_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_5_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_5_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_5_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_5_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_5_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_5_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_5_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_6 */
#define MAC_DMA_TIMT_6_ADDRESS                                                            0x0000011c
#define MAC_DMA_TIMT_6_OFFSET                                                             0x0000011c
#define MAC_DMA_TIMT_6_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_6_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_6_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_6_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_6_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_6_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_6_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_6_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_6_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_6_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_7 */
#define MAC_DMA_TIMT_7_ADDRESS                                                            0x00000120
#define MAC_DMA_TIMT_7_OFFSET                                                             0x00000120
#define MAC_DMA_TIMT_7_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_7_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_7_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_7_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_7_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_7_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_7_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_7_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_7_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_7_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_8 */
#define MAC_DMA_TIMT_8_ADDRESS                                                            0x00000124
#define MAC_DMA_TIMT_8_OFFSET                                                             0x00000124
#define MAC_DMA_TIMT_8_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_8_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_8_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_8_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_8_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_8_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_8_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_8_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_8_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_8_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_TIMT_9 */
#define MAC_DMA_TIMT_9_ADDRESS                                                            0x00000128
#define MAC_DMA_TIMT_9_OFFSET                                                             0x00000128
#define MAC_DMA_TIMT_9_TX_LAST_PKT_THRESH_MSB                                                     15
#define MAC_DMA_TIMT_9_TX_LAST_PKT_THRESH_LSB                                                      0
#define MAC_DMA_TIMT_9_TX_LAST_PKT_THRESH_MASK                                            0x0000ffff
#define MAC_DMA_TIMT_9_TX_LAST_PKT_THRESH_GET(x)                           (((x) & 0x0000ffff) >> 0)
#define MAC_DMA_TIMT_9_TX_LAST_PKT_THRESH_SET(x)                           (((x) << 0) & 0x0000ffff)
#define MAC_DMA_TIMT_9_TX_FIRST_PKT_THRESH_MSB                                                    31
#define MAC_DMA_TIMT_9_TX_FIRST_PKT_THRESH_LSB                                                    16
#define MAC_DMA_TIMT_9_TX_FIRST_PKT_THRESH_MASK                                           0xffff0000
#define MAC_DMA_TIMT_9_TX_FIRST_PKT_THRESH_GET(x)                         (((x) & 0xffff0000) >> 16)
#define MAC_DMA_TIMT_9_TX_FIRST_PKT_THRESH_SET(x)                         (((x) << 16) & 0xffff0000)

/* macros for MAC_DMA_CHKACC */
#define MAC_DMA_CHKACC_ADDRESS                                                            0x0000012c
#define MAC_DMA_CHKACC_OFFSET                                                             0x0000012c
#define MAC_DMA_CHKACC_CHKSUM_SEL_MSB                                                              0
#define MAC_DMA_CHKACC_CHKSUM_SEL_LSB                                                              0
#define MAC_DMA_CHKACC_CHKSUM_SEL_MASK                                                    0x00000001
#define MAC_DMA_CHKACC_CHKSUM_SEL_GET(x)                                   (((x) & 0x00000001) >> 0)
#define MAC_DMA_CHKACC_CHKSUM_SEL_SET(x)                                   (((x) << 0) & 0x00000001)


#ifndef __ASSEMBLER__

typedef struct wmac_dma_reg_reg_s {
  volatile char pad__0[0x8];                                           /*        0x0 - 0x8        */
  volatile unsigned int MAC_DMA_CR;                                    /*        0x8 - 0xc        */
  volatile char pad__1[0x8];                                           /*        0xc - 0x14       */
  volatile unsigned int MAC_DMA_CFG;                                   /*       0x14 - 0x18       */
  volatile unsigned int MAC_DMA_RXBUFPTR_THRESH;                       /*       0x18 - 0x1c       */
  volatile unsigned int MAC_DMA_TXDPPTR_THRESH;                        /*       0x1c - 0x20       */
  volatile unsigned int MAC_DMA_MIRT;                                  /*       0x20 - 0x24       */
  volatile unsigned int MAC_DMA_GLOBAL_IER;                            /*       0x24 - 0x28       */
  volatile unsigned int MAC_DMA_TIMT_0;                                /*       0x28 - 0x2c       */
  volatile unsigned int MAC_DMA_RIMT;                                  /*       0x2c - 0x30       */
  volatile unsigned int MAC_DMA_TXCFG;                                 /*       0x30 - 0x34       */
  volatile unsigned int MAC_DMA_RXCFG;                                 /*       0x34 - 0x38       */
  volatile unsigned int MAC_DMA_RXJLA;                                 /*       0x38 - 0x3c       */
  volatile char pad__2[0x4];                                           /*       0x3c - 0x40       */
  volatile unsigned int MAC_DMA_MIBC;                                  /*       0x40 - 0x44       */
  volatile unsigned int MAC_DMA_TOPS;                                  /*       0x44 - 0x48       */
  volatile unsigned int MAC_DMA_RXNPTO;                                /*       0x48 - 0x4c       */
  volatile unsigned int MAC_DMA_TXNPTO;                                /*       0x4c - 0x50       */
  volatile unsigned int MAC_DMA_RPGTO;                                 /*       0x50 - 0x54       */
  volatile char pad__3[0x4];                                           /*       0x54 - 0x58       */
  volatile unsigned int MAC_DMA_MACMISC;                               /*       0x58 - 0x5c       */
  volatile unsigned int MAC_DMA_INTER;                                 /*       0x5c - 0x60       */
  volatile unsigned int MAC_DMA_DATABUF;                               /*       0x60 - 0x64       */
  volatile unsigned int MAC_DMA_GTT;                                   /*       0x64 - 0x68       */
  volatile unsigned int MAC_DMA_GTTM;                                  /*       0x68 - 0x6c       */
  volatile unsigned int MAC_DMA_CST;                                   /*       0x6c - 0x70       */
  volatile unsigned int MAC_DMA_RXDP_SIZE;                             /*       0x70 - 0x74       */
  volatile unsigned int MAC_DMA_RX_QUEUE_HP_RXDP;                      /*       0x74 - 0x78       */
  volatile unsigned int MAC_DMA_RX_QUEUE_LP_RXDP;                      /*       0x78 - 0x7c       */
  volatile char pad__4[0x4];                                           /*       0x7c - 0x80       */
  volatile unsigned int MAC_DMA_ISR_P;                                 /*       0x80 - 0x84       */
  volatile unsigned int MAC_DMA_ISR_S0;                                /*       0x84 - 0x88       */
  volatile unsigned int MAC_DMA_ISR_S1;                                /*       0x88 - 0x8c       */
  volatile unsigned int MAC_DMA_ISR_S2;                                /*       0x8c - 0x90       */
  volatile unsigned int MAC_DMA_ISR_S3;                                /*       0x90 - 0x94       */
  volatile unsigned int MAC_DMA_ISR_S4;                                /*       0x94 - 0x98       */
  volatile unsigned int MAC_DMA_ISR_S5;                                /*       0x98 - 0x9c       */
  volatile unsigned int MAC_DMA_ISR_S6;                                /*       0x9c - 0xa0       */
  volatile unsigned int MAC_DMA_IMR_P;                                 /*       0xa0 - 0xa4       */
  volatile unsigned int MAC_DMA_IMR_S0;                                /*       0xa4 - 0xa8       */
  volatile unsigned int MAC_DMA_IMR_S1;                                /*       0xa8 - 0xac       */
  volatile unsigned int MAC_DMA_IMR_S2;                                /*       0xac - 0xb0       */
  volatile unsigned int MAC_DMA_IMR_S3;                                /*       0xb0 - 0xb4       */
  volatile unsigned int MAC_DMA_IMR_S4;                                /*       0xb4 - 0xb8       */
  volatile unsigned int MAC_DMA_IMR_S5;                                /*       0xb8 - 0xbc       */
  volatile unsigned int MAC_DMA_IMR_S6;                                /*       0xbc - 0xc0       */
  volatile unsigned int MAC_DMA_ISR_P_RAC;                             /*       0xc0 - 0xc4       */
  volatile unsigned int MAC_DMA_ISR_S0_S;                              /*       0xc4 - 0xc8       */
  volatile unsigned int MAC_DMA_ISR_S1_S;                              /*       0xc8 - 0xcc       */
  volatile unsigned int MAC_DMA_ISR_S6_S;                              /*       0xcc - 0xd0       */
  volatile unsigned int MAC_DMA_ISR_S2_S;                              /*       0xd0 - 0xd4       */
  volatile unsigned int MAC_DMA_ISR_S3_S;                              /*       0xd4 - 0xd8       */
  volatile unsigned int MAC_DMA_ISR_S4_S;                              /*       0xd8 - 0xdc       */
  volatile unsigned int MAC_DMA_ISR_S5_S;                              /*       0xdc - 0xe0       */
  volatile unsigned int MAC_DMA_DMADBG_0;                              /*       0xe0 - 0xe4       */
  volatile unsigned int MAC_DMA_DMADBG_1;                              /*       0xe4 - 0xe8       */
  volatile unsigned int MAC_DMA_DMADBG_2;                              /*       0xe8 - 0xec       */
  volatile unsigned int MAC_DMA_DMADBG_3;                              /*       0xec - 0xf0       */
  volatile unsigned int MAC_DMA_DMADBG_4;                              /*       0xf0 - 0xf4       */
  volatile unsigned int MAC_DMA_DMADBG_5;                              /*       0xf4 - 0xf8       */
  volatile unsigned int MAC_DMA_DMADBG_6;                              /*       0xf8 - 0xfc       */
  volatile unsigned int MAC_DMA_DMADBG_7;                              /*       0xfc - 0x100      */
  volatile unsigned int MAC_DMA_QCU_TXDP_REMAINING_QCU_7_0;            /*      0x100 - 0x104      */
  volatile unsigned int MAC_DMA_QCU_TXDP_REMAINING_QCU_9_8;            /*      0x104 - 0x108      */
  volatile unsigned int MAC_DMA_TIMT_1;                                /*      0x108 - 0x10c      */
  volatile unsigned int MAC_DMA_TIMT_2;                                /*      0x10c - 0x110      */
  volatile unsigned int MAC_DMA_TIMT_3;                                /*      0x110 - 0x114      */
  volatile unsigned int MAC_DMA_TIMT_4;                                /*      0x114 - 0x118      */
  volatile unsigned int MAC_DMA_TIMT_5;                                /*      0x118 - 0x11c      */
  volatile unsigned int MAC_DMA_TIMT_6;                                /*      0x11c - 0x120      */
  volatile unsigned int MAC_DMA_TIMT_7;                                /*      0x120 - 0x124      */
  volatile unsigned int MAC_DMA_TIMT_8;                                /*      0x124 - 0x128      */
  volatile unsigned int MAC_DMA_TIMT_9;                                /*      0x128 - 0x12c      */
  volatile unsigned int MAC_DMA_CHKACC;                                /*      0x12c - 0x130      */
} wmac_dma_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _WMAC_DMA_REG_REG_H_ */
