/*
 * Copyright (C) 2016 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef B3BottomProvider_h
#define B3BottomProvider_h

#if ENABLE(B3_JIT)

#include "B3InsertionSet.h"

namespace JSC { namespace B3 {

// This exists because we cannot convert values to constants in-place.
// FIXME: https://bugs.webkit.org/show_bug.cgi?id=159119

class BottomProvider {
public:
    BottomProvider(InsertionSet& insertionSet, size_t index)
        : m_insertionSet(&insertionSet)
        , m_index(index)
    {
    }
    
    Value* operator()(Origin origin, Type type) const
    {
        return m_insertionSet->insertBottom(m_index, origin, type);
    }
    
private:
    InsertionSet* m_insertionSet;
    size_t m_index;
};

} } // namespace JSC::B3

#endif // ENABLE(B3_JIT)

#endif // B3BottomProvider_h

