/* PixbufCache.c generated by valac 0.34.7, the Vala compiler
 * generated from PixbufCache.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PIXBUF_CACHE (pixbuf_cache_get_type ())
#define PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_CACHE, PixbufCache))
#define PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_CACHE, PixbufCacheClass))
#define IS_PIXBUF_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_CACHE))
#define IS_PIXBUF_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_CACHE))
#define PIXBUF_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_CACHE, PixbufCacheClass))

typedef struct _PixbufCache PixbufCache;
typedef struct _PixbufCacheClass PixbufCacheClass;
typedef struct _PixbufCachePrivate PixbufCachePrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define PIXBUF_CACHE_TYPE_PHOTO_TYPE (pixbuf_cache_photo_type_get_type ())

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define PIXBUF_CACHE_TYPE_FETCH_JOB (pixbuf_cache_fetch_job_get_type ())
#define PIXBUF_CACHE_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob))
#define PIXBUF_CACHE_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJobClass))
#define PIXBUF_CACHE_IS_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_FETCH_JOB))
#define PIXBUF_CACHE_IS_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_FETCH_JOB))
#define PIXBUF_CACHE_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJobClass))

typedef struct _PixbufCacheFetchJob PixbufCacheFetchJob;
typedef struct _PixbufCacheFetchJobClass PixbufCacheFetchJobClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _PixbufCacheFetchJobPrivate PixbufCacheFetchJobPrivate;

#define PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB (pixbuf_cache_baseline_fetch_job_get_type ())
#define PIXBUF_CACHE_BASELINE_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJob))
#define PIXBUF_CACHE_BASELINE_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJobClass))
#define PIXBUF_CACHE_IS_BASELINE_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB))
#define PIXBUF_CACHE_IS_BASELINE_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB))
#define PIXBUF_CACHE_BASELINE_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJobClass))

typedef struct _PixbufCacheBaselineFetchJob PixbufCacheBaselineFetchJob;
typedef struct _PixbufCacheBaselineFetchJobClass PixbufCacheBaselineFetchJobClass;

#define PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB (pixbuf_cache_master_fetch_job_get_type ())
#define PIXBUF_CACHE_MASTER_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJob))
#define PIXBUF_CACHE_MASTER_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJobClass))
#define PIXBUF_CACHE_IS_MASTER_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB))
#define PIXBUF_CACHE_IS_MASTER_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB))
#define PIXBUF_CACHE_MASTER_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJobClass))

typedef struct _PixbufCacheMasterFetchJob PixbufCacheMasterFetchJob;
typedef struct _PixbufCacheMasterFetchJobClass PixbufCacheMasterFetchJobClass;

#define PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH (pixbuf_cache_pixbuf_cache_batch_get_type ())
#define PIXBUF_CACHE_PIXBUF_CACHE_BATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH, PixbufCachePixbufCacheBatch))
#define PIXBUF_CACHE_PIXBUF_CACHE_BATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH, PixbufCachePixbufCacheBatchClass))
#define PIXBUF_CACHE_IS_PIXBUF_CACHE_BATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH))
#define PIXBUF_CACHE_IS_PIXBUF_CACHE_BATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH))
#define PIXBUF_CACHE_PIXBUF_CACHE_BATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH, PixbufCachePixbufCacheBatchClass))

typedef struct _PixbufCachePixbufCacheBatch PixbufCachePixbufCacheBatch;
typedef struct _PixbufCachePixbufCacheBatchClass PixbufCachePixbufCacheBatchClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
typedef struct _PixbufCachePixbufCacheBatchPrivate PixbufCachePixbufCacheBatchPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_SEMAPHORE (semaphore_get_type ())
#define SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEMAPHORE, Semaphore))
#define SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEMAPHORE, SemaphoreClass))
#define IS_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEMAPHORE))
#define IS_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEMAPHORE))
#define SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEMAPHORE, SemaphoreClass))

typedef struct _Semaphore Semaphore;
typedef struct _SemaphoreClass SemaphoreClass;
#define _abstract_semaphore_unref0(var) ((var == NULL) ? NULL : (var = (abstract_semaphore_unref (var), NULL)))
typedef struct _PixbufCacheBaselineFetchJobPrivate PixbufCacheBaselineFetchJobPrivate;
typedef struct _PixbufCacheMasterFetchJobPrivate PixbufCacheMasterFetchJobPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PixbufCache {
	GObject parent_instance;
	PixbufCachePrivate * priv;
};

struct _PixbufCacheClass {
	GObjectClass parent_class;
};

typedef enum  {
	PIXBUF_CACHE_PHOTO_TYPE_BASELINE,
	PIXBUF_CACHE_PHOTO_TYPE_MASTER
} PixbufCachePhotoType;

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef gboolean (*PixbufCacheCacheFilter) (Photo* photo, void* user_data);
struct _PixbufCachePrivate {
	SourceCollection* sources;
	PixbufCachePhotoType type;
	gint max_count;
	Scaling scaling;
	PixbufCacheCacheFilter filter;
	gpointer filter_target;
	GeeHashMap* cache;
	GeeArrayList* lru;
	GeeHashMap* in_progress;
};

typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _PixbufCacheFetchJob {
	BackgroundJob parent_instance;
	PixbufCacheFetchJobPrivate * priv;
	BackgroundJobJobPriority priority;
	Photo* photo;
	Scaling scaling;
	GdkPixbuf* pixbuf;
	GError* err;
};

struct _PixbufCacheFetchJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
struct _PixbufCachePixbufCacheBatch {
	GeeTreeMultiMap parent_instance;
	PixbufCachePixbufCacheBatchPrivate * priv;
};

struct _PixbufCachePixbufCacheBatchClass {
	GeeTreeMultiMapClass parent_class;
};

typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);
struct _PixbufCacheBaselineFetchJob {
	PixbufCacheFetchJob parent_instance;
	PixbufCacheBaselineFetchJobPrivate * priv;
};

struct _PixbufCacheBaselineFetchJobClass {
	PixbufCacheFetchJobClass parent_class;
};

struct _PixbufCacheMasterFetchJob {
	PixbufCacheFetchJob parent_instance;
	PixbufCacheMasterFetchJobPrivate * priv;
};

struct _PixbufCacheMasterFetchJobClass {
	PixbufCacheFetchJobClass parent_class;
};


static gpointer pixbuf_cache_parent_class = NULL;
static Workers* pixbuf_cache_background_workers;
static Workers* pixbuf_cache_background_workers = NULL;
static gpointer pixbuf_cache_pixbuf_cache_batch_parent_class = NULL;
static gpointer pixbuf_cache_fetch_job_parent_class = NULL;
static gpointer pixbuf_cache_baseline_fetch_job_parent_class = NULL;
static gpointer pixbuf_cache_master_fetch_job_parent_class = NULL;

GType pixbuf_cache_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType pixbuf_cache_photo_type_get_type (void) G_GNUC_CONST;
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
static GType pixbuf_cache_fetch_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define PIXBUF_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXBUF_CACHE, PixbufCachePrivate))
enum  {
	PIXBUF_CACHE_DUMMY_PROPERTY
};
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
static void pixbuf_cache_on_sources_altered (PixbufCache* self, GeeMap* map);
static void _pixbuf_cache_on_sources_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
static void pixbuf_cache_on_sources_removed (PixbufCache* self, GeeIterable* removed);
static void _pixbuf_cache_on_sources_removed_data_collection_items_removed (DataCollection* _sender, GeeIterable* removed, gpointer self);
void background_job_cancel (BackgroundJob* self);
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
PixbufCache* pixbuf_cache_new (SourceCollection* sources, PixbufCachePhotoType type, Scaling* scaling, gint max_count, PixbufCacheCacheFilter filter, void* filter_target);
PixbufCache* pixbuf_cache_construct (GType object_type, SourceCollection* sources, PixbufCachePhotoType type, Scaling* scaling, gint max_count, PixbufCacheCacheFilter filter, void* filter_target);
guint workers_thread_per_cpu_minus_one (void);
Workers* workers_new (guint max_threads, gboolean exclusive);
Workers* workers_construct (GType object_type, guint max_threads, gboolean exclusive);
void pixbuf_cache_get_scaling (PixbufCache* self, Scaling* result);
GdkPixbuf* pixbuf_cache_get_ready_pixbuf (PixbufCache* self, Photo* photo);
static GdkPixbuf* pixbuf_cache_get_cached (PixbufCache* self, Photo* photo);
GdkPixbuf* pixbuf_cache_fetch (PixbufCache* self, Photo* photo, GError** error);
GFile* photo_get_actual_file (Photo* self);
static void pixbuf_cache_decache (PixbufCache* self, Photo* photo);
void background_job_wait_for_completion (BackgroundJob* self);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
static void pixbuf_cache_encache (PixbufCache* self, Photo* photo, GdkPixbuf* pixbuf);
void pixbuf_cache_drop (PixbufCache* self, Photo* photo);
gboolean pixbuf_cache_cancel_prefetch (PixbufCache* self, Photo* photo);
void pixbuf_cache_prefetch (PixbufCache* self, Photo* photo, BackgroundJobJobPriority priority, gboolean force);
static void pixbuf_cache_prioritize (PixbufCache* self, Photo* photo);
static void pixbuf_cache_on_fetched (PixbufCache* self, BackgroundJob* j);
static void _pixbuf_cache_on_fetched_completion_callback (BackgroundJob* job, gpointer self);
static PixbufCacheBaselineFetchJob* pixbuf_cache_baseline_fetch_job_new (PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target);
static PixbufCacheBaselineFetchJob* pixbuf_cache_baseline_fetch_job_construct (GType object_type, PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target);
static GType pixbuf_cache_baseline_fetch_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static PixbufCacheMasterFetchJob* pixbuf_cache_master_fetch_job_new (PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target);
static PixbufCacheMasterFetchJob* pixbuf_cache_master_fetch_job_construct (GType object_type, PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target);
static GType pixbuf_cache_master_fetch_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void workers_enqueue (Workers* self, BackgroundJob* job);
void pixbuf_cache_prefetch_many (PixbufCache* self, GeeCollection* photos, BackgroundJobJobPriority priority, gboolean force);
GType pixbuf_cache_pixbuf_cache_batch_get_type (void) G_GNUC_CONST;
void pixbuf_cache_prefetch_batch (PixbufCache* self, PixbufCachePixbufCacheBatch* batch, gboolean force);
void pixbuf_cache_cancel_all (PixbufCache* self);
gchar* data_object_to_string (DataObject* self);
gboolean alteration_has_subject (Alteration* self, const gchar* subject);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	PIXBUF_CACHE_PIXBUF_CACHE_BATCH_DUMMY_PROPERTY
};
PixbufCachePixbufCacheBatch* pixbuf_cache_pixbuf_cache_batch_new (void);
PixbufCachePixbufCacheBatch* pixbuf_cache_pixbuf_cache_batch_construct (GType object_type);
gint background_job_job_priority_compare_func (BackgroundJobJobPriority a, BackgroundJobJobPriority b);
enum  {
	PIXBUF_CACHE_FETCH_JOB_DUMMY_PROPERTY
};
static PixbufCacheFetchJob* pixbuf_cache_fetch_job_construct (GType object_type, PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target);
Semaphore* semaphore_new (void);
Semaphore* semaphore_construct (GType object_type);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
GType semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore);
static BackgroundJobJobPriority pixbuf_cache_fetch_job_real_get_priority (BackgroundJob* base);
static void pixbuf_cache_fetch_job_finalize (BackgroundJob* obj);
enum  {
	PIXBUF_CACHE_BASELINE_FETCH_JOB_DUMMY_PROPERTY
};
static void pixbuf_cache_baseline_fetch_job_real_execute (BackgroundJob* base);
enum  {
	PIXBUF_CACHE_MASTER_FETCH_JOB_DUMMY_PROPERTY
};
static void pixbuf_cache_master_fetch_job_real_execute (BackgroundJob* base);
GdkPixbuf* photo_get_master_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error);
static void pixbuf_cache_finalize (GObject* obj);


static void _pixbuf_cache_on_sources_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 111 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_on_sources_altered ((PixbufCache*) self, items);
#line 477 "PixbufCache.c"
}


static void _pixbuf_cache_on_sources_removed_data_collection_items_removed (DataCollection* _sender, GeeIterable* removed, gpointer self) {
#line 112 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_on_sources_removed ((PixbufCache*) self, removed);
#line 484 "PixbufCache.c"
}


GType pixbuf_cache_photo_type_get_type (void) {
	static volatile gsize pixbuf_cache_photo_type_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_cache_photo_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIXBUF_CACHE_PHOTO_TYPE_BASELINE, "PIXBUF_CACHE_PHOTO_TYPE_BASELINE", "baseline"}, {PIXBUF_CACHE_PHOTO_TYPE_MASTER, "PIXBUF_CACHE_PHOTO_TYPE_MASTER", "master"}, {0, NULL, NULL}};
		GType pixbuf_cache_photo_type_type_id;
		pixbuf_cache_photo_type_type_id = g_enum_register_static ("PixbufCachePhotoType", values);
		g_once_init_leave (&pixbuf_cache_photo_type_type_id__volatile, pixbuf_cache_photo_type_type_id);
	}
	return pixbuf_cache_photo_type_type_id__volatile;
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 87 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self ? data_collection_ref (self) : NULL;
#line 503 "PixbufCache.c"
}


PixbufCache* pixbuf_cache_construct (GType object_type, SourceCollection* sources, PixbufCachePhotoType type, Scaling* scaling, gint max_count, PixbufCacheCacheFilter filter, void* filter_target) {
	PixbufCache * self = NULL;
	SourceCollection* _tmp0_ = NULL;
	SourceCollection* _tmp1_ = NULL;
	PixbufCachePhotoType _tmp2_ = 0;
	Scaling _tmp3_ = {0};
	gint _tmp4_ = 0;
	PixbufCacheCacheFilter _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	gint _tmp6_ = 0;
	Workers* _tmp7_ = NULL;
	PixbufCachePhotoType _tmp10_ = 0;
	SourceCollection* _tmp12_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (sources), NULL);
#line 85 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 85 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = (PixbufCache*) g_object_new (object_type, NULL);
#line 87 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = sources;
#line 87 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 87 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_data_collection_unref0 (self->priv->sources);
#line 87 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->sources = _tmp1_;
#line 88 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = type;
#line 88 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->type = _tmp2_;
#line 89 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = *scaling;
#line 89 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->scaling = _tmp3_;
#line 90 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = max_count;
#line 90 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->max_count = _tmp4_;
#line 91 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp5_ = filter;
#line 91 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp5__target = filter_target;
#line 91 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->filter = _tmp5_;
#line 91 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->filter_target = _tmp5__target;
#line 93 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp6_ = max_count;
#line 93 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_vala_assert (_tmp6_ > 0, "max_count > 0");
#line 95 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp7_ = pixbuf_cache_background_workers;
#line 95 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp7_ == NULL) {
#line 562 "PixbufCache.c"
		guint _tmp8_ = 0U;
		Workers* _tmp9_ = NULL;
#line 96 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp8_ = workers_thread_per_cpu_minus_one ();
#line 96 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp9_ = workers_new (_tmp8_, FALSE);
#line 96 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_workers_unref0 (pixbuf_cache_background_workers);
#line 96 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		pixbuf_cache_background_workers = _tmp9_;
#line 573 "PixbufCache.c"
	}
#line 100 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp10_ = type;
#line 100 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp10_ != PIXBUF_CACHE_PHOTO_TYPE_MASTER) {
#line 579 "PixbufCache.c"
		SourceCollection* _tmp11_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp11_ = sources;
#line 101 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _pixbuf_cache_on_sources_altered_data_collection_items_altered, self, 0);
#line 585 "PixbufCache.c"
	}
#line 102 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp12_ = sources;
#line 102 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_COLLECTION, DataCollection), "items-removed", (GCallback) _pixbuf_cache_on_sources_removed_data_collection_items_removed, self, 0);
#line 85 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self;
#line 593 "PixbufCache.c"
}


PixbufCache* pixbuf_cache_new (SourceCollection* sources, PixbufCachePhotoType type, Scaling* scaling, gint max_count, PixbufCacheCacheFilter filter, void* filter_target) {
#line 85 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return pixbuf_cache_construct (TYPE_PIXBUF_CACHE, sources, type, scaling, max_count, filter, filter_target);
#line 600 "PixbufCache.c"
}


void pixbuf_cache_get_scaling (PixbufCache* self, Scaling* result) {
	Scaling _tmp0_ = {0};
#line 118 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 119 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priv->scaling;
#line 119 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	*result = _tmp0_;
#line 119 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return;
#line 614 "PixbufCache.c"
}


GdkPixbuf* pixbuf_cache_get_ready_pixbuf (PixbufCache* self, Photo* photo) {
	GdkPixbuf* result = NULL;
	Photo* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (self), NULL);
#line 123 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
#line 124 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = photo;
#line 124 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = pixbuf_cache_get_cached (self, _tmp0_);
#line 124 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	result = _tmp1_;
#line 124 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return result;
#line 634 "PixbufCache.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self ? g_error_copy (self) : NULL;
#line 641 "PixbufCache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self ? g_object_ref (self) : NULL;
#line 648 "PixbufCache.c"
}


GdkPixbuf* pixbuf_cache_fetch (PixbufCache* self, Photo* photo, GError** error) {
	GdkPixbuf* result = NULL;
	Photo* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GdkPixbuf* pixbuf = NULL;
	Photo* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
	PixbufCacheFetchJob* job = NULL;
	GeeHashMap* _tmp9_ = NULL;
	Photo* _tmp10_ = NULL;
	gpointer _tmp11_ = NULL;
	PixbufCacheFetchJob* _tmp12_ = NULL;
	GdkPixbuf* _tmp22_ = NULL;
	Photo* _tmp23_ = NULL;
	Scaling _tmp24_ = {0};
	GdkPixbuf* _tmp25_ = NULL;
	GdkPixbuf* _tmp26_ = NULL;
	Photo* _tmp27_ = NULL;
	GdkPixbuf* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (self), NULL);
#line 129 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = photo;
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo_get_actual_file (_tmp0_);
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = _tmp1_;
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = !_tmp3_;
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (_tmp2_);
#line 130 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp4_) {
#line 694 "PixbufCache.c"
		Photo* _tmp5_ = NULL;
#line 131 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = photo;
#line 131 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		pixbuf_cache_decache (self, _tmp5_);
#line 700 "PixbufCache.c"
	}
#line 133 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp6_ = photo;
#line 133 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp7_ = pixbuf_cache_get_cached (self, _tmp6_);
#line 133 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf = _tmp7_;
#line 134 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp8_ = pixbuf;
#line 134 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp8_ != NULL) {
#line 139 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		result = pixbuf;
#line 139 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return result;
#line 716 "PixbufCache.c"
	}
#line 142 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp9_ = self->priv->in_progress;
#line 142 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp10_ = photo;
#line 142 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp11_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_);
#line 142 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	job = (PixbufCacheFetchJob*) _tmp11_;
#line 143 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp12_ = job;
#line 143 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp12_ != NULL) {
#line 730 "PixbufCache.c"
		PixbufCacheFetchJob* _tmp13_ = NULL;
		PixbufCacheFetchJob* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		PixbufCacheFetchJob* _tmp19_ = NULL;
		GdkPixbuf* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp13_ = job;
#line 144 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		background_job_wait_for_completion (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 145 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp14_ = job;
#line 145 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp15_ = _tmp14_->err;
#line 145 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		if (_tmp15_ != NULL) {
#line 747 "PixbufCache.c"
			PixbufCacheFetchJob* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp16_ = job;
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp17_ = _tmp16_->err;
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp18_ = _g_error_copy0 (_tmp17_);
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_inner_error_ = _tmp18_;
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_background_job_unref0 (job);
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_g_object_unref0 (pixbuf);
#line 146 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			return NULL;
#line 767 "PixbufCache.c"
		}
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp19_ = job;
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp20_ = _tmp19_->pixbuf;
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		result = _tmp21_;
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_background_job_unref0 (job);
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (pixbuf);
#line 148 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return result;
#line 783 "PixbufCache.c"
	}
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp23_ = photo;
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp24_ = self->priv->scaling;
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp25_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp24_, &_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp22_ = _tmp25_;
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_background_job_unref0 (job);
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (pixbuf);
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return NULL;
#line 803 "PixbufCache.c"
	}
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp26_ = _tmp22_;
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp22_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (pixbuf);
#line 155 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf = _tmp26_;
#line 157 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp27_ = photo;
#line 157 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp28_ = pixbuf;
#line 157 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_encache (self, _tmp27_, _tmp28_);
#line 159 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	result = pixbuf;
#line 159 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (_tmp22_);
#line 159 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_background_job_unref0 (job);
#line 159 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return result;
#line 827 "PixbufCache.c"
}


void pixbuf_cache_drop (PixbufCache* self, Photo* photo) {
	Photo* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 165 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 166 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = photo;
#line 166 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_cancel_prefetch (self, _tmp0_);
#line 167 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo;
#line 167 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_decache (self, _tmp1_);
#line 846 "PixbufCache.c"
}


static void _pixbuf_cache_on_fetched_completion_callback (BackgroundJob* job, gpointer self) {
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_on_fetched ((PixbufCache*) self, job);
#line 853 "PixbufCache.c"
}


void pixbuf_cache_prefetch (PixbufCache* self, Photo* photo, BackgroundJobJobPriority priority, gboolean force) {
	Photo* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GeeHashMap* _tmp12_ = NULL;
	Photo* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	PixbufCacheCacheFilter _tmp16_ = NULL;
	void* _tmp16__target = NULL;
	PixbufCacheFetchJob* job = NULL;
	PixbufCachePhotoType _tmp20_ = 0;
	GeeHashMap* _tmp30_ = NULL;
	Photo* _tmp31_ = NULL;
	PixbufCacheFetchJob* _tmp32_ = NULL;
	Workers* _tmp33_ = NULL;
	PixbufCacheFetchJob* _tmp34_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 172 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = photo;
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo_get_actual_file (_tmp0_);
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = _tmp1_;
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = !_tmp3_;
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (_tmp2_);
#line 174 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp4_) {
#line 896 "PixbufCache.c"
		Photo* _tmp5_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = photo;
#line 175 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		pixbuf_cache_decache (self, _tmp5_);
#line 902 "PixbufCache.c"
	}
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp7_ = force;
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (!_tmp7_) {
#line 908 "PixbufCache.c"
		GeeHashMap* _tmp8_ = NULL;
		Photo* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp8_ = self->priv->cache;
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp9_ = photo;
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp10_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_);
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = _tmp10_;
#line 920 "PixbufCache.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = FALSE;
#line 924 "PixbufCache.c"
	}
#line 177 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp6_) {
#line 928 "PixbufCache.c"
		Photo* _tmp11_ = NULL;
#line 178 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp11_ = photo;
#line 178 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		pixbuf_cache_prioritize (self, _tmp11_);
#line 180 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 936 "PixbufCache.c"
	}
#line 183 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp12_ = self->priv->in_progress;
#line 183 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp13_ = photo;
#line 183 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp14_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_);
#line 183 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp14_) {
#line 184 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 948 "PixbufCache.c"
	}
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp16_ = self->priv->filter;
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp16__target = self->priv->filter_target;
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp16_ != NULL) {
#line 956 "PixbufCache.c"
		PixbufCacheCacheFilter _tmp17_ = NULL;
		void* _tmp17__target = NULL;
		Photo* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp17_ = self->priv->filter;
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp17__target = self->priv->filter_target;
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp18_ = photo;
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp19_ = _tmp17_ (_tmp18_, _tmp17__target);
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp15_ = !_tmp19_;
#line 971 "PixbufCache.c"
	} else {
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp15_ = FALSE;
#line 975 "PixbufCache.c"
	}
#line 186 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp15_) {
#line 187 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 981 "PixbufCache.c"
	}
#line 189 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	job = NULL;
#line 190 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp20_ = self->priv->type;
#line 190 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	switch (_tmp20_) {
#line 190 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		case PIXBUF_CACHE_PHOTO_TYPE_BASELINE:
#line 991 "PixbufCache.c"
		{
			BackgroundJobJobPriority _tmp21_ = 0;
			Photo* _tmp22_ = NULL;
			Scaling _tmp23_ = {0};
			PixbufCacheBaselineFetchJob* _tmp24_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp21_ = priority;
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp22_ = photo;
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp23_ = self->priv->scaling;
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp24_ = pixbuf_cache_baseline_fetch_job_new (self, _tmp21_, _tmp22_, &_tmp23_, _pixbuf_cache_on_fetched_completion_callback, self);
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_background_job_unref0 (job);
#line 192 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			job = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob);
#line 193 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			break;
#line 1011 "PixbufCache.c"
		}
#line 190 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		case PIXBUF_CACHE_PHOTO_TYPE_MASTER:
#line 1015 "PixbufCache.c"
		{
			BackgroundJobJobPriority _tmp25_ = 0;
			Photo* _tmp26_ = NULL;
			Scaling _tmp27_ = {0};
			PixbufCacheMasterFetchJob* _tmp28_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp25_ = priority;
#line 196 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp26_ = photo;
#line 196 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp27_ = self->priv->scaling;
#line 196 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp28_ = pixbuf_cache_master_fetch_job_new (self, _tmp25_, _tmp26_, &_tmp27_, _pixbuf_cache_on_fetched_completion_callback, self);
#line 196 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_background_job_unref0 (job);
#line 196 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			job = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob);
#line 197 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			break;
#line 1035 "PixbufCache.c"
		}
		default:
		{
			PixbufCachePhotoType _tmp29_ = 0;
#line 200 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp29_ = self->priv->type;
#line 200 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			g_error ("PixbufCache.vala:200: Unknown photo type: %d", (gint) _tmp29_);
#line 1044 "PixbufCache.c"
		}
	}
#line 203 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp30_ = self->priv->in_progress;
#line 203 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp31_ = photo;
#line 203 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp32_ = job;
#line 203 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp31_, _tmp32_);
#line 205 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp33_ = pixbuf_cache_background_workers;
#line 205 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp34_ = job;
#line 205 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	workers_enqueue (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 172 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_background_job_unref0 (job);
#line 1063 "PixbufCache.c"
}


void pixbuf_cache_prefetch_many (PixbufCache* self, GeeCollection* photos, BackgroundJobJobPriority priority, gboolean force) {
#line 210 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 210 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (GEE_IS_COLLECTION (photos));
#line 1072 "PixbufCache.c"
	{
		GeeIterator* _photo_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = photos;
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_photo_it = _tmp1_;
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		while (TRUE) {
#line 1085 "PixbufCache.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			Photo* photo = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			Photo* _tmp6_ = NULL;
			BackgroundJobJobPriority _tmp7_ = 0;
			gboolean _tmp8_ = FALSE;
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp2_ = _photo_it;
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (!_tmp3_) {
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				break;
#line 1102 "PixbufCache.c"
			}
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp4_ = _photo_it;
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			photo = (Photo*) _tmp5_;
#line 213 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp6_ = photo;
#line 213 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp7_ = priority;
#line 213 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp8_ = force;
#line 213 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			pixbuf_cache_prefetch (self, _tmp6_, _tmp7_, _tmp8_);
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_g_object_unref0 (photo);
#line 1120 "PixbufCache.c"
		}
#line 212 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_photo_it);
#line 1124 "PixbufCache.c"
	}
}


void pixbuf_cache_prefetch_batch (PixbufCache* self, PixbufCachePixbufCacheBatch* batch, gboolean force) {
#line 217 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 217 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (PIXBUF_CACHE_IS_PIXBUF_CACHE_BATCH (batch));
#line 1134 "PixbufCache.c"
	{
		GeeIterator* _priority_it = NULL;
		PixbufCachePixbufCacheBatch* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = batch;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp2_ = _tmp1_;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = _tmp3_;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp2_);
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_priority_it = _tmp4_;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		while (TRUE) {
#line 1158 "PixbufCache.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			BackgroundJobJobPriority priority = 0;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp5_ = _priority_it;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (!_tmp6_) {
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				break;
#line 1172 "PixbufCache.c"
			}
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp7_ = _priority_it;
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			priority = (BackgroundJobJobPriority) ((gintptr) _tmp8_);
#line 1180 "PixbufCache.c"
			{
				GeeIterator* _photo_it = NULL;
				PixbufCachePixbufCacheBatch* _tmp9_ = NULL;
				BackgroundJobJobPriority _tmp10_ = 0;
				GeeCollection* _tmp11_ = NULL;
				GeeCollection* _tmp12_ = NULL;
				GeeIterator* _tmp13_ = NULL;
				GeeIterator* _tmp14_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp9_ = batch;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp10_ = priority;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp11_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_MULTI_MAP, GeeMultiMap), (gpointer) ((gintptr) _tmp10_));
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp12_ = _tmp11_;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp14_ = _tmp13_;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_g_object_unref0 (_tmp12_);
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_photo_it = _tmp14_;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				while (TRUE) {
#line 1207 "PixbufCache.c"
					GeeIterator* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					Photo* photo = NULL;
					GeeIterator* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					Photo* _tmp19_ = NULL;
					BackgroundJobJobPriority _tmp20_ = 0;
					gboolean _tmp21_ = FALSE;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp15_ = _photo_it;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp16_ = gee_iterator_next (_tmp15_);
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					if (!_tmp16_) {
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
						break;
#line 1224 "PixbufCache.c"
					}
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp17_ = _photo_it;
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp18_ = gee_iterator_get (_tmp17_);
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					photo = (Photo*) _tmp18_;
#line 220 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp19_ = photo;
#line 220 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp20_ = priority;
#line 220 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_tmp21_ = force;
#line 220 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					pixbuf_cache_prefetch (self, _tmp19_, _tmp20_, _tmp21_);
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_g_object_unref0 (photo);
#line 1242 "PixbufCache.c"
				}
#line 219 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_g_object_unref0 (_photo_it);
#line 1246 "PixbufCache.c"
			}
		}
#line 218 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_priority_it);
#line 1251 "PixbufCache.c"
	}
}


gboolean pixbuf_cache_cancel_prefetch (PixbufCache* self, Photo* photo) {
	gboolean result = FALSE;
	PixbufCacheFetchJob* job = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	PixbufCacheFetchJob* _tmp3_ = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp4_ = NULL;
	Photo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	PixbufCacheFetchJob* _tmp8_ = NULL;
#line 224 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (self), FALSE);
#line 224 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), FALSE);
#line 225 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priv->in_progress;
#line 225 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo;
#line 225 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 225 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	job = (PixbufCacheFetchJob*) _tmp2_;
#line 226 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = job;
#line 226 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp3_ == NULL) {
#line 227 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		result = FALSE;
#line 227 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_background_job_unref0 (job);
#line 227 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return result;
#line 1291 "PixbufCache.c"
	}
#line 230 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = self->priv->in_progress;
#line 230 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp5_ = photo;
#line 230 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp6_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_, NULL);
#line 230 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	removed = _tmp6_;
#line 231 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp7_ = removed;
#line 231 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_vala_assert (_tmp7_, "removed");
#line 233 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp8_ = job;
#line 233 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 239 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	result = TRUE;
#line 239 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_background_job_unref0 (job);
#line 239 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return result;
#line 1315 "PixbufCache.c"
}


void pixbuf_cache_cancel_all (PixbufCache* self) {
	GeeHashMap* _tmp11_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 1323 "PixbufCache.c"
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = self->priv->in_progress;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp2_ = _tmp1_;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp3_ = _tmp2_;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = _tmp4_;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp3_);
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_job_it = _tmp5_;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		while (TRUE) {
#line 1350 "PixbufCache.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			PixbufCacheFetchJob* job = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PixbufCacheFetchJob* _tmp10_ = NULL;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp6_ = _job_it;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (!_tmp7_) {
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				break;
#line 1365 "PixbufCache.c"
			}
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp8_ = _job_it;
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			job = (PixbufCacheFetchJob*) _tmp9_;
#line 247 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp10_ = job;
#line 247 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_background_job_unref0 (job);
#line 1379 "PixbufCache.c"
		}
#line 246 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_job_it);
#line 1383 "PixbufCache.c"
	}
#line 249 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp11_ = self->priv->in_progress;
#line 249 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1389 "PixbufCache.c"
}


static gpointer _background_job_ref0 (gpointer self) {
#line 253 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self ? background_job_ref (self) : NULL;
#line 1396 "PixbufCache.c"
}


static void pixbuf_cache_on_fetched (PixbufCache* self, BackgroundJob* j) {
	PixbufCacheFetchJob* job = NULL;
	BackgroundJob* _tmp0_ = NULL;
	PixbufCacheFetchJob* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	PixbufCacheFetchJob* _tmp3_ = NULL;
	Photo* _tmp4_ = NULL;
	PixbufCacheFetchJob* _tmp5_ = NULL;
	GError* _tmp6_ = NULL;
	PixbufCacheFetchJob* _tmp20_ = NULL;
	Photo* _tmp21_ = NULL;
	PixbufCacheFetchJob* _tmp22_ = NULL;
	GdkPixbuf* _tmp23_ = NULL;
	PixbufCacheFetchJob* _tmp24_ = NULL;
	Photo* _tmp25_ = NULL;
	PixbufCacheFetchJob* _tmp26_ = NULL;
	GdkPixbuf* _tmp27_ = NULL;
#line 252 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 252 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 253 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = j;
#line 253 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob));
#line 253 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	job = _tmp1_;
#line 257 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = self->priv->in_progress;
#line 257 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = job;
#line 257 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = _tmp3_->photo;
#line 257 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
#line 259 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp5_ = job;
#line 259 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp6_ = _tmp5_->err;
#line 259 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp6_ != NULL) {
#line 1441 "PixbufCache.c"
		PixbufCacheFetchJob* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		PixbufCacheFetchJob* _tmp9_ = NULL;
		Photo* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		PixbufCacheFetchJob* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		PixbufCacheFetchJob* _tmp16_ = NULL;
		Photo* _tmp17_ = NULL;
		PixbufCacheFetchJob* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
#line 260 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp7_ = job;
#line 260 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp8_ = _tmp7_->pixbuf;
#line 260 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_vala_assert (_tmp8_ == NULL, "job.pixbuf == null");
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp9_ = job;
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp10_ = _tmp9_->photo;
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp12_ = _tmp11_;
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp13_ = job;
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp14_ = _tmp13_->err;
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp15_ = _tmp14_->message;
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_critical ("PixbufCache.vala:262: Unable to readahead %s: %s", _tmp12_, _tmp15_);
#line 262 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_free0 (_tmp12_);
#line 263 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp16_ = job;
#line 263 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp17_ = _tmp16_->photo;
#line 263 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp18_ = job;
#line 263 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp19_ = _tmp18_->err;
#line 263 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_signal_emit_by_name (self, "fetched", _tmp17_, NULL, _tmp19_);
#line 265 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_background_job_unref0 (job);
#line 265 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 1493 "PixbufCache.c"
	}
#line 272 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp20_ = job;
#line 272 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp21_ = _tmp20_->photo;
#line 272 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp22_ = job;
#line 272 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp23_ = _tmp22_->pixbuf;
#line 272 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_encache (self, _tmp21_, _tmp23_);
#line 275 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp24_ = job;
#line 275 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp25_ = _tmp24_->photo;
#line 275 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp26_ = job;
#line 275 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp27_ = _tmp26_->pixbuf;
#line 275 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_signal_emit_by_name (self, "fetched", _tmp25_, _tmp27_, NULL);
#line 252 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_background_job_unref0 (job);
#line 1517 "PixbufCache.c"
}


static void pixbuf_cache_on_sources_altered (PixbufCache* self, GeeMap* map) {
#line 278 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 278 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1526 "PixbufCache.c"
	{
		GeeIterator* _object_it = NULL;
		GeeMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = map;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = gee_map_get_keys (_tmp0_);
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp2_ = _tmp1_;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp3_ = _tmp2_;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = _tmp4_;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp3_);
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_object_it = _tmp5_;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		while (TRUE) {
#line 1553 "PixbufCache.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			GeeMap* _tmp10_ = NULL;
			DataObject* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			Alteration* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Photo* photo = NULL;
			DataObject* _tmp16_ = NULL;
			Photo* _tmp17_ = NULL;
			GeeHashMap* _tmp18_ = NULL;
			Photo* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			Photo* _tmp30_ = NULL;
			Photo* _tmp31_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp6_ = _object_it;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (!_tmp7_) {
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				break;
#line 1581 "PixbufCache.c"
			}
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp8_ = _object_it;
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			object = (DataObject*) _tmp9_;
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp10_ = map;
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp11_ = object;
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp13_ = (Alteration*) _tmp12_;
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp14_ = alteration_has_subject (_tmp13_, "image");
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp15_ = !_tmp14_;
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_alteration_unref0 (_tmp13_);
#line 280 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (_tmp15_) {
#line 281 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_g_object_unref0 (object);
#line 281 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				continue;
#line 1609 "PixbufCache.c"
			}
#line 283 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp16_ = object;
#line 283 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO, Photo));
#line 283 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			photo = _tmp17_;
#line 285 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp18_ = self->priv->in_progress;
#line 285 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp19_ = photo;
#line 285 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp20_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp19_);
#line 285 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (_tmp20_) {
#line 1625 "PixbufCache.c"
				GeeHashMap* _tmp21_ = NULL;
				Photo* _tmp22_ = NULL;
				gpointer _tmp23_ = NULL;
				PixbufCacheFetchJob* _tmp24_ = NULL;
				GeeHashMap* _tmp25_ = NULL;
				Photo* _tmp26_ = NULL;
#line 288 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp21_ = self->priv->in_progress;
#line 288 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp22_ = photo;
#line 288 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp23_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp22_);
#line 288 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp24_ = (PixbufCacheFetchJob*) _tmp23_;
#line 288 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 288 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_background_job_unref0 (_tmp24_);
#line 289 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp25_ = self->priv->in_progress;
#line 289 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp26_ = photo;
#line 289 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp26_, NULL);
#line 1650 "PixbufCache.c"
			} else {
				GeeHashMap* _tmp27_ = NULL;
				Photo* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
#line 290 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp27_ = self->priv->cache;
#line 290 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp28_ = photo;
#line 290 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				_tmp29_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp28_);
#line 290 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				if (!_tmp29_) {
#line 291 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_g_object_unref0 (photo);
#line 291 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					_g_object_unref0 (object);
#line 291 "/home/jens/Source/shotwell/src/PixbufCache.vala"
					continue;
#line 1669 "PixbufCache.c"
				}
			}
#line 294 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp30_ = photo;
#line 294 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			pixbuf_cache_decache (self, _tmp30_);
#line 301 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp31_ = photo;
#line 301 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			pixbuf_cache_prefetch (self, _tmp31_, BACKGROUND_JOB_JOB_PRIORITY_HIGH, FALSE);
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_g_object_unref0 (photo);
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_g_object_unref0 (object);
#line 1684 "PixbufCache.c"
		}
#line 279 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_object_it);
#line 1688 "PixbufCache.c"
	}
}


static void pixbuf_cache_on_sources_removed (PixbufCache* self, GeeIterable* removed) {
#line 305 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 305 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 1698 "PixbufCache.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = removed;
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_object_it = _tmp1_;
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		while (TRUE) {
#line 1711 "PixbufCache.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			Photo* photo = NULL;
			DataObject* _tmp6_ = NULL;
			Photo* _tmp7_ = NULL;
			Photo* _tmp8_ = NULL;
			Photo* _tmp9_ = NULL;
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp2_ = _object_it;
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (!_tmp3_) {
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				break;
#line 1730 "PixbufCache.c"
			}
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp4_ = _object_it;
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			object = (DataObject*) _tmp5_;
#line 307 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp6_ = object;
#line 307 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_PHOTO) ? ((Photo*) _tmp6_) : NULL);
#line 307 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			photo = _tmp7_;
#line 308 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp8_ = photo;
#line 308 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_vala_assert (_tmp8_ != NULL, "photo != null");
#line 310 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp9_ = photo;
#line 310 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			pixbuf_cache_decache (self, _tmp9_);
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_g_object_unref0 (photo);
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_g_object_unref0 (object);
#line 1756 "PixbufCache.c"
		}
#line 306 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_object_it);
#line 1760 "PixbufCache.c"
	}
}


static GdkPixbuf* pixbuf_cache_get_cached (PixbufCache* self, Photo* photo) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
#line 314 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (self), NULL);
#line 314 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
#line 315 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priv->cache;
#line 315 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo;
#line 315 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 315 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf = (GdkPixbuf*) _tmp2_;
#line 316 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = pixbuf;
#line 316 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp3_ != NULL) {
#line 1788 "PixbufCache.c"
		Photo* _tmp4_ = NULL;
#line 317 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = photo;
#line 317 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		pixbuf_cache_prioritize (self, _tmp4_);
#line 1794 "PixbufCache.c"
	}
#line 319 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	result = pixbuf;
#line 319 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return result;
#line 1800 "PixbufCache.c"
}


static void pixbuf_cache_prioritize (PixbufCache* self, Photo* photo) {
	gint index = 0;
	GeeArrayList* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 323 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 323 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 324 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priv->lru;
#line 324 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo;
#line 324 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = gee_abstract_list_index_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp1_);
#line 324 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	index = _tmp2_;
#line 325 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = index;
#line 325 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_vala_assert (_tmp3_ >= 0, "index >= 0");
#line 327 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = index;
#line 327 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp4_ > 0) {
#line 1831 "PixbufCache.c"
		GeeArrayList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gpointer _tmp7_ = NULL;
		Photo* _tmp8_ = NULL;
		GeeArrayList* _tmp9_ = NULL;
		Photo* _tmp10_ = NULL;
#line 328 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = self->priv->lru;
#line 328 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = index;
#line 328 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp7_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp6_);
#line 328 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp8_ = (Photo*) _tmp7_;
#line 328 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp8_);
#line 329 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp9_ = self->priv->lru;
#line 329 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp10_ = photo;
#line 329 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp10_);
#line 1854 "PixbufCache.c"
	}
}


static void pixbuf_cache_encache (PixbufCache* self, Photo* photo, GdkPixbuf* pixbuf) {
	Photo* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	Photo* _tmp5_ = NULL;
	GeeArrayList* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GeeHashMap* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
#line 333 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 333 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 333 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 335 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = photo;
#line 335 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_decache (self, _tmp0_);
#line 337 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = self->priv->cache;
#line 337 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = photo;
#line 337 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = pixbuf;
#line 337 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, _tmp3_);
#line 338 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = self->priv->lru;
#line 338 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp5_ = photo;
#line 338 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp5_);
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	while (TRUE) {
#line 1898 "PixbufCache.c"
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Photo* cached_photo = NULL;
		GeeArrayList* _tmp10_ = NULL;
		GeeArrayList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gpointer _tmp14_ = NULL;
		Photo* _tmp15_ = NULL;
		gboolean removed = FALSE;
		GeeHashMap* _tmp16_ = NULL;
		Photo* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = self->priv->lru;
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp8_ = _tmp7_;
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp9_ = self->priv->max_count;
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		if (!(_tmp8_ > _tmp9_)) {
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			break;
#line 1927 "PixbufCache.c"
		}
#line 341 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp10_ = self->priv->lru;
#line 341 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp11_ = self->priv->lru;
#line 341 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp12_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 341 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp13_ = _tmp12_;
#line 341 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp14_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp13_ - 1);
#line 341 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		cached_photo = (Photo*) _tmp14_;
#line 342 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp15_ = cached_photo;
#line 342 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_vala_assert (_tmp15_ != NULL, "cached_photo != null");
#line 344 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp16_ = self->priv->cache;
#line 344 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp17_ = cached_photo;
#line 344 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp18_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp17_, NULL);
#line 344 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		removed = _tmp18_;
#line 345 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp19_ = removed;
#line 345 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_vala_assert (_tmp19_, "removed");
#line 340 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (cached_photo);
#line 1959 "PixbufCache.c"
	}
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp20_ = self->priv->lru;
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp21_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp22_ = _tmp21_;
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp23_ = self->priv->cache;
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp24_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp25_ = _tmp24_;
#line 348 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_vala_assert (_tmp22_ == _tmp25_, "lru.size == cache.size");
#line 1975 "PixbufCache.c"
}


static void pixbuf_cache_decache (PixbufCache* self, Photo* photo) {
	GeeHashMap* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean removed = FALSE;
	GeeArrayList* _tmp6_ = NULL;
	Photo* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
#line 351 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PIXBUF_CACHE (self));
#line 351 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 352 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priv->cache;
#line 352 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = photo;
#line 352 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_, NULL);
#line 352 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (!_tmp2_) {
#line 2000 "PixbufCache.c"
		GeeArrayList* _tmp3_ = NULL;
		Photo* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 353 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp3_ = self->priv->lru;
#line 353 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = photo;
#line 353 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 353 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_vala_assert (!_tmp5_, "!lru.contains(photo)");
#line 355 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 2014 "PixbufCache.c"
	}
#line 358 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp6_ = self->priv->lru;
#line 358 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp7_ = photo;
#line 358 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp8_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
#line 358 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	removed = _tmp8_;
#line 359 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp9_ = removed;
#line 359 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_vala_assert (_tmp9_, "removed");
#line 2028 "PixbufCache.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_if_fail (n_param_values == 4);
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		data1 = closure->data;
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		data2 = param_values->data[0].v_pointer;
#line 2047 "PixbufCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		data1 = param_values->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		data2 = closure->data;
#line 2053 "PixbufCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_pointer (param_values + 3), data2);
#line 2059 "PixbufCache.c"
}


PixbufCachePixbufCacheBatch* pixbuf_cache_pixbuf_cache_batch_construct (GType object_type) {
	PixbufCachePixbufCacheBatch * self = NULL;
#line 17 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = (PixbufCachePixbufCacheBatch*) gee_tree_multi_map_construct (object_type, BACKGROUND_JOB_TYPE_JOB_PRIORITY, NULL, NULL, TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GCompareDataFunc) background_job_job_priority_compare_func, NULL, NULL, NULL, NULL, NULL);
#line 16 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self;
#line 2069 "PixbufCache.c"
}


PixbufCachePixbufCacheBatch* pixbuf_cache_pixbuf_cache_batch_new (void) {
#line 16 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return pixbuf_cache_pixbuf_cache_batch_construct (PIXBUF_CACHE_TYPE_PIXBUF_CACHE_BATCH);
#line 2076 "PixbufCache.c"
}


static void pixbuf_cache_pixbuf_cache_batch_class_init (PixbufCachePixbufCacheBatchClass * klass) {
#line 15 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_pixbuf_cache_batch_parent_class = g_type_class_peek_parent (klass);
#line 2083 "PixbufCache.c"
}


static void pixbuf_cache_pixbuf_cache_batch_instance_init (PixbufCachePixbufCacheBatch * self) {
}


GType pixbuf_cache_pixbuf_cache_batch_get_type (void) {
	static volatile gsize pixbuf_cache_pixbuf_cache_batch_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_cache_pixbuf_cache_batch_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufCachePixbufCacheBatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_pixbuf_cache_batch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCachePixbufCacheBatch), 0, (GInstanceInitFunc) pixbuf_cache_pixbuf_cache_batch_instance_init, NULL };
		GType pixbuf_cache_pixbuf_cache_batch_type_id;
		pixbuf_cache_pixbuf_cache_batch_type_id = g_type_register_static (GEE_TYPE_TREE_MULTI_MAP, "PixbufCachePixbufCacheBatch", &g_define_type_info, 0);
		g_once_init_leave (&pixbuf_cache_pixbuf_cache_batch_type_id__volatile, pixbuf_cache_pixbuf_cache_batch_type_id);
	}
	return pixbuf_cache_pixbuf_cache_batch_type_id__volatile;
}


static PixbufCacheFetchJob* pixbuf_cache_fetch_job_construct (GType object_type, PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target) {
	PixbufCacheFetchJob* self = NULL;
	PixbufCache* _tmp0_ = NULL;
	CompletionCallback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	Semaphore* _tmp4_ = NULL;
	Semaphore* _tmp5_ = NULL;
	BackgroundJobJobPriority _tmp6_ = 0;
	Photo* _tmp7_ = NULL;
	Photo* _tmp8_ = NULL;
	Scaling _tmp9_ = {0};
#line 28 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (owner), NULL);
#line 28 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
#line 28 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = owner;
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = callback;
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1__target = callback_target;
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = g_cancellable_new ();
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = _tmp2_;
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = semaphore_new ();
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp5_ = _tmp4_;
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = (PixbufCacheFetchJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _tmp1_, _tmp1__target, _tmp3_, NULL, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_abstract_semaphore_unref0 (_tmp5_);
#line 30 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (_tmp3_);
#line 32 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp6_ = priority;
#line 32 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priority = _tmp6_;
#line 33 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp7_ = photo;
#line 33 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 33 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (self->photo);
#line 33 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->photo = _tmp8_;
#line 34 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp9_ = *scaling;
#line 34 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->scaling = _tmp9_;
#line 28 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self;
#line 2160 "PixbufCache.c"
}


static BackgroundJobJobPriority pixbuf_cache_fetch_job_real_get_priority (BackgroundJob* base) {
	PixbufCacheFetchJob * self;
	BackgroundJobJobPriority result = 0;
	BackgroundJobJobPriority _tmp0_ = 0;
#line 37 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob);
#line 38 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priority;
#line 38 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return result;
#line 2176 "PixbufCache.c"
}


static void pixbuf_cache_fetch_job_class_init (PixbufCacheFetchJobClass * klass) {
#line 21 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_fetch_job_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	((BackgroundJobClass *) klass)->finalize = pixbuf_cache_fetch_job_finalize;
#line 21 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	((BackgroundJobClass *) klass)->get_priority = (BackgroundJobJobPriority (*)(BackgroundJob*)) pixbuf_cache_fetch_job_real_get_priority;
#line 2187 "PixbufCache.c"
}


static void pixbuf_cache_fetch_job_instance_init (PixbufCacheFetchJob * self) {
#line 25 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->pixbuf = NULL;
#line 26 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->err = NULL;
#line 2196 "PixbufCache.c"
}


static void pixbuf_cache_fetch_job_finalize (BackgroundJob* obj) {
	PixbufCacheFetchJob * self;
#line 21 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob);
#line 23 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (self->photo);
#line 25 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (self->pixbuf);
#line 26 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_error_free0 (self->err);
#line 21 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	BACKGROUND_JOB_CLASS (pixbuf_cache_fetch_job_parent_class)->finalize (obj);
#line 2212 "PixbufCache.c"
}


static GType pixbuf_cache_fetch_job_get_type (void) {
	static volatile gsize pixbuf_cache_fetch_job_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_cache_fetch_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCacheFetchJob), 0, (GInstanceInitFunc) pixbuf_cache_fetch_job_instance_init, NULL };
		GType pixbuf_cache_fetch_job_type_id;
		pixbuf_cache_fetch_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PixbufCacheFetchJob", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&pixbuf_cache_fetch_job_type_id__volatile, pixbuf_cache_fetch_job_type_id);
	}
	return pixbuf_cache_fetch_job_type_id__volatile;
}


static PixbufCacheBaselineFetchJob* pixbuf_cache_baseline_fetch_job_construct (GType object_type, PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target) {
	PixbufCacheBaselineFetchJob* self = NULL;
	PixbufCache* _tmp0_ = NULL;
	BackgroundJobJobPriority _tmp1_ = 0;
	Photo* _tmp2_ = NULL;
	Scaling _tmp3_ = {0};
	CompletionCallback _tmp4_ = NULL;
	void* _tmp4__target = NULL;
#line 43 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (owner), NULL);
#line 43 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
#line 43 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = owner;
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = priority;
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = photo;
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = *scaling;
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = callback;
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4__target = callback_target;
#line 45 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = (PixbufCacheBaselineFetchJob*) pixbuf_cache_fetch_job_construct (object_type, _tmp0_, _tmp1_, _tmp2_, &_tmp3_, _tmp4_, _tmp4__target);
#line 43 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self;
#line 2258 "PixbufCache.c"
}


static PixbufCacheBaselineFetchJob* pixbuf_cache_baseline_fetch_job_new (PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target) {
#line 43 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return pixbuf_cache_baseline_fetch_job_construct (PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, owner, priority, photo, scaling, callback, callback_target);
#line 2265 "PixbufCache.c"
}


static void pixbuf_cache_baseline_fetch_job_real_execute (BackgroundJob* base) {
	PixbufCacheBaselineFetchJob * self;
	GError * _inner_error_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PIXBUF_CACHE_TYPE_BASELINE_FETCH_JOB, PixbufCacheBaselineFetchJob);
#line 2274 "PixbufCache.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		Photo* _tmp1_ = NULL;
		Scaling _tmp2_ = {0};
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->photo;
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->scaling;
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp3_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp2_, &_inner_error_);
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = _tmp3_;
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2291 "PixbufCache.c"
			goto __catch453_g_error;
		}
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = NULL;
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->pixbuf);
#line 50 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->pixbuf = _tmp4_;
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp0_);
#line 2304 "PixbufCache.c"
	}
	goto __finally453;
	__catch453_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		err = _inner_error_;
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_inner_error_ = NULL;
#line 52 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = err;
#line 52 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 52 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_error_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->err);
#line 52 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->err = _tmp6_;
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_error_free0 (err);
#line 2326 "PixbufCache.c"
	}
	__finally453:
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_clear_error (&_inner_error_);
#line 49 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 2337 "PixbufCache.c"
	}
}


static void pixbuf_cache_baseline_fetch_job_class_init (PixbufCacheBaselineFetchJobClass * klass) {
#line 42 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_baseline_fetch_job_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	((BackgroundJobClass *) klass)->execute = (void (*)(BackgroundJob*)) pixbuf_cache_baseline_fetch_job_real_execute;
#line 2347 "PixbufCache.c"
}


static void pixbuf_cache_baseline_fetch_job_instance_init (PixbufCacheBaselineFetchJob * self) {
}


static GType pixbuf_cache_baseline_fetch_job_get_type (void) {
	static volatile gsize pixbuf_cache_baseline_fetch_job_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_cache_baseline_fetch_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheBaselineFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_baseline_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCacheBaselineFetchJob), 0, (GInstanceInitFunc) pixbuf_cache_baseline_fetch_job_instance_init, NULL };
		GType pixbuf_cache_baseline_fetch_job_type_id;
		pixbuf_cache_baseline_fetch_job_type_id = g_type_register_static (PIXBUF_CACHE_TYPE_FETCH_JOB, "PixbufCacheBaselineFetchJob", &g_define_type_info, 0);
		g_once_init_leave (&pixbuf_cache_baseline_fetch_job_type_id__volatile, pixbuf_cache_baseline_fetch_job_type_id);
	}
	return pixbuf_cache_baseline_fetch_job_type_id__volatile;
}


static PixbufCacheMasterFetchJob* pixbuf_cache_master_fetch_job_construct (GType object_type, PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target) {
	PixbufCacheMasterFetchJob* self = NULL;
	PixbufCache* _tmp0_ = NULL;
	BackgroundJobJobPriority _tmp1_ = 0;
	Photo* _tmp2_ = NULL;
	Scaling _tmp3_ = {0};
	CompletionCallback _tmp4_ = NULL;
	void* _tmp4__target = NULL;
#line 58 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PIXBUF_CACHE (owner), NULL);
#line 58 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
#line 58 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = owner;
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = priority;
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = photo;
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = *scaling;
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4_ = callback;
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp4__target = callback_target;
#line 60 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = (PixbufCacheMasterFetchJob*) pixbuf_cache_fetch_job_construct (object_type, _tmp0_, _tmp1_, _tmp2_, &_tmp3_, _tmp4_, _tmp4__target);
#line 58 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return self;
#line 2397 "PixbufCache.c"
}


static PixbufCacheMasterFetchJob* pixbuf_cache_master_fetch_job_new (PixbufCache* owner, BackgroundJobJobPriority priority, Photo* photo, Scaling* scaling, CompletionCallback callback, void* callback_target) {
#line 58 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	return pixbuf_cache_master_fetch_job_construct (PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, owner, priority, photo, scaling, callback, callback_target);
#line 2404 "PixbufCache.c"
}


static void pixbuf_cache_master_fetch_job_real_execute (BackgroundJob* base) {
	PixbufCacheMasterFetchJob * self;
	GError * _inner_error_ = NULL;
#line 63 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PIXBUF_CACHE_TYPE_MASTER_FETCH_JOB, PixbufCacheMasterFetchJob);
#line 2413 "PixbufCache.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		Photo* _tmp1_ = NULL;
		Scaling _tmp2_ = {0};
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->photo;
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->scaling;
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp3_ = photo_get_master_pixbuf (_tmp1_, &_tmp2_, TRUE, &_inner_error_);
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = _tmp3_;
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2430 "PixbufCache.c"
			goto __catch454_g_error;
		}
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp4_ = _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp0_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->pixbuf);
#line 65 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->pixbuf = _tmp4_;
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp0_);
#line 2443 "PixbufCache.c"
	}
	goto __finally454;
	__catch454_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		err = _inner_error_;
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_inner_error_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = err;
#line 67 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 67 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_error_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->err);
#line 67 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, PIXBUF_CACHE_TYPE_FETCH_JOB, PixbufCacheFetchJob)->err = _tmp6_;
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_error_free0 (err);
#line 2465 "PixbufCache.c"
	}
	__finally454:
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_clear_error (&_inner_error_);
#line 64 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		return;
#line 2476 "PixbufCache.c"
	}
}


static void pixbuf_cache_master_fetch_job_class_init (PixbufCacheMasterFetchJobClass * klass) {
#line 57 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_master_fetch_job_parent_class = g_type_class_peek_parent (klass);
#line 57 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	((BackgroundJobClass *) klass)->execute = (void (*)(BackgroundJob*)) pixbuf_cache_master_fetch_job_real_execute;
#line 2486 "PixbufCache.c"
}


static void pixbuf_cache_master_fetch_job_instance_init (PixbufCacheMasterFetchJob * self) {
}


static GType pixbuf_cache_master_fetch_job_get_type (void) {
	static volatile gsize pixbuf_cache_master_fetch_job_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_cache_master_fetch_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheMasterFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_master_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCacheMasterFetchJob), 0, (GInstanceInitFunc) pixbuf_cache_master_fetch_job_instance_init, NULL };
		GType pixbuf_cache_master_fetch_job_type_id;
		pixbuf_cache_master_fetch_job_type_id = g_type_register_static (PIXBUF_CACHE_TYPE_FETCH_JOB, "PixbufCacheMasterFetchJob", &g_define_type_info, 0);
		g_once_init_leave (&pixbuf_cache_master_fetch_job_type_id__volatile, pixbuf_cache_master_fetch_job_type_id);
	}
	return pixbuf_cache_master_fetch_job_type_id__volatile;
}


static void pixbuf_cache_class_init (PixbufCacheClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	pixbuf_cache_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_type_class_add_private (klass, sizeof (PixbufCachePrivate));
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	G_OBJECT_CLASS (klass)->finalize = pixbuf_cache_finalize;
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_signal_new ("fetched", TYPE_PIXBUF_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_POINTER, G_TYPE_NONE, 3, TYPE_PHOTO, gdk_pixbuf_get_type (), G_TYPE_POINTER);
#line 2515 "PixbufCache.c"
}


static void pixbuf_cache_instance_init (PixbufCache * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv = PIXBUF_CACHE_GET_PRIVATE (self);
#line 79 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 79 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->cache = _tmp0_;
#line 80 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp1_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 80 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->lru = _tmp1_;
#line 81 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp2_ = gee_hash_map_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PIXBUF_CACHE_TYPE_FETCH_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 81 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self->priv->in_progress = _tmp2_;
#line 2537 "PixbufCache.c"
}


static void pixbuf_cache_finalize (GObject* obj) {
	PixbufCache * self;
	PixbufCachePhotoType _tmp0_ = 0;
	SourceCollection* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_CACHE, PixbufCache);
#line 110 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp0_ = self->priv->type;
#line 110 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	if (_tmp0_ != PIXBUF_CACHE_PHOTO_TYPE_MASTER) {
#line 2552 "PixbufCache.c"
		SourceCollection* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
#line 111 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp1_ = self->priv->sources;
#line 111 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
#line 111 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _pixbuf_cache_on_sources_altered_data_collection_items_altered, self);
#line 2561 "PixbufCache.c"
	}
#line 112 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_tmp3_ = self->priv->sources;
#line 112 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp4_, NULL, FALSE);
#line 112 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _pixbuf_cache_on_sources_removed_data_collection_items_removed, self);
#line 2569 "PixbufCache.c"
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp5_ = NULL;
		GeeCollection* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
		GeeCollection* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp5_ = self->priv->in_progress;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp6_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp7_ = _tmp6_;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp8_ = _tmp7_;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_tmp10_ = _tmp9_;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_tmp8_);
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_job_it = _tmp10_;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		while (TRUE) {
#line 2596 "PixbufCache.c"
			GeeIterator* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			PixbufCacheFetchJob* job = NULL;
			GeeIterator* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			PixbufCacheFetchJob* _tmp15_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp11_ = _job_it;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			if (!_tmp12_) {
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
				break;
#line 2611 "PixbufCache.c"
			}
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp13_ = _job_it;
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			job = (PixbufCacheFetchJob*) _tmp14_;
#line 115 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_tmp15_ = job;
#line 115 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
			_background_job_unref0 (job);
#line 2625 "PixbufCache.c"
		}
#line 114 "/home/jens/Source/shotwell/src/PixbufCache.vala"
		_g_object_unref0 (_job_it);
#line 2629 "PixbufCache.c"
	}
#line 74 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_data_collection_unref0 (self->priv->sources);
#line 79 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (self->priv->cache);
#line 80 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (self->priv->lru);
#line 81 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	_g_object_unref0 (self->priv->in_progress);
#line 7 "/home/jens/Source/shotwell/src/PixbufCache.vala"
	G_OBJECT_CLASS (pixbuf_cache_parent_class)->finalize (obj);
#line 2641 "PixbufCache.c"
}


GType pixbuf_cache_get_type (void) {
	static volatile gsize pixbuf_cache_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufCache), 0, (GInstanceInitFunc) pixbuf_cache_instance_init, NULL };
		GType pixbuf_cache_type_id;
		pixbuf_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "PixbufCache", &g_define_type_info, 0);
		g_once_init_leave (&pixbuf_cache_type_id__volatile, pixbuf_cache_type_id);
	}
	return pixbuf_cache_type_id__volatile;
}



