/* Generated by re2c 0.15.3 on Fri Oct  7 13:19:24 2016 */
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND   1
#define TIMELIB_MINUTE   2
#define TIMELIB_HOUR     3
#define TIMELIB_DAY      4
#define TIMELIB_MONTH    5
#define TIMELIB_YEAR     6
#define TIMELIB_WEEKDAY  7
#define TIMELIB_SPECIAL  8
#define TIMELIB_MICROSEC 9

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.f += (((double) amount * (double) relunit->multiplier) / 1000000); break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 60) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	if ((YYLIMIT - YYCURSOR) < 31) YYFILL(31);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy1581;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych >= 'a') goto yy170;
		} else {
			if (yych <= 'e') goto yy1590;
			if (yych <= 'z') goto yy170;
		}
	}
yy3:
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy1581;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy1581;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy5:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1552;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1553;
				if (yych <= 'N') goto yy165;
				goto yy1551;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1568;
				goto yy170;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1569;
				goto yy170;
			} else {
				if (yych <= 'o') goto yy1567;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy6:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1552;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1553;
				if (yych <= 'N') goto yy165;
				goto yy1551;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1552;
				goto yy165;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1553;
				goto yy165;
			} else {
				if (yych <= 'o') goto yy1551;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy7:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy1521;
		} else {
			if (yych == 'I') goto yy1522;
			if (yych <= 'N') goto yy165;
			goto yy1523;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1536;
			goto yy170;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1537;
				goto yy170;
			} else {
				if (yych <= 'o') goto yy1538;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy8:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy1521;
		} else {
			if (yych == 'I') goto yy1522;
			if (yych <= 'N') goto yy165;
			goto yy1523;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1521;
			goto yy165;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1522;
				goto yy165;
			} else {
				if (yych <= 'o') goto yy1523;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy9:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy164;
	case '0':
	case '1':	goto yy1451;
	case '2':	goto yy1452;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1453;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy165;
	case 'E':	goto yy1446;
	case 'H':	goto yy1447;
	case 'O':	goto yy1448;
	case 'U':	goto yy1449;
	case 'W':	goto yy1450;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy170;
	case 'e':	goto yy1489;
	case 'h':	goto yy1490;
	case 'o':	goto yy1491;
	case 'u':	goto yy1492;
	case 'w':	goto yy1493;
	default:	goto yy3;
	}
yy10:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy164;
	case '0':
	case '1':	goto yy1451;
	case '2':	goto yy1452;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1453;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy165;
	case 'E':
	case 'e':	goto yy1446;
	case 'H':
	case 'h':	goto yy1447;
	case 'O':
	case 'o':	goto yy1448;
	case 'U':
	case 'u':	goto yy1449;
	case 'W':
	case 'w':	goto yy1450;
	default:	goto yy3;
	}
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1434;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1435;
yy12:
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy165;
				goto yy1370;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1371;
				goto yy165;
			} else {
				if (yych <= 'O') goto yy1372;
				if (yych <= 'Q') goto yy165;
				goto yy1373;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy165;
				if (yych <= '`') goto yy3;
				goto yy170;
			} else {
				if (yych <= 'e') goto yy1411;
				if (yych <= 'h') goto yy170;
				goto yy1412;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1413;
				goto yy170;
			} else {
				if (yych <= 'r') goto yy1414;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy14:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy165;
				goto yy1370;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1371;
				goto yy165;
			} else {
				if (yych <= 'O') goto yy1372;
				if (yych <= 'Q') goto yy165;
				goto yy1373;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy165;
				if (yych <= '`') goto yy3;
				goto yy165;
			} else {
				if (yych <= 'e') goto yy1370;
				if (yych <= 'h') goto yy165;
				goto yy1371;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1372;
				goto yy165;
			} else {
				if (yych <= 'r') goto yy1373;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy15:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1356;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1367;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy16:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1356;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1356;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy17:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1336;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1353;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy18:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1336;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1336;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy19:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1279;
				goto yy165;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1278;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1280;
				if (yych <= 'T') goto yy165;
				goto yy1281;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1308;
				if (yych <= 'd') goto yy170;
				goto yy1307;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1309;
				goto yy170;
			} else {
				if (yych <= 'u') goto yy1310;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1279;
				goto yy165;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1278;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1280;
				if (yych <= 'T') goto yy165;
				goto yy1281;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1279;
				if (yych <= 'd') goto yy165;
				goto yy1278;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1280;
				goto yy165;
			} else {
				if (yych <= 'u') goto yy1281;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy21:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1248;
			if (yych <= 'K') goto yy165;
			goto yy1249;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy170;
			goto yy1266;
		} else {
			if (yych == 'l') goto yy1267;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1248;
			if (yych <= 'K') goto yy165;
			goto yy1249;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy165;
			goto yy1248;
		} else {
			if (yych == 'l') goto yy1249;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy23:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy165;
			goto yy1122;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'r') goto yy1241;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy24:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy165;
			goto yy1122;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'r') goto yy1122;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy25:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1076;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy1078;
					if (yych <= ',') goto yy12;
					goto yy497;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy1088;
					if (yych <= '/') goto yy496;
					goto yy1121;
				} else {
					if (yych <= '9') goto yy1120;
					if (yych <= ':') goto yy1089;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy1078;
					if (yych <= 'C') goto yy12;
					goto yy1078;
				} else {
					if (yych == 'F') goto yy1078;
					goto yy12;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy1078;
					if (yych <= 'L') goto yy12;
					goto yy1078;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy1078;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy1078;
					if (yych <= 'c') goto yy12;
					goto yy1078;
				} else {
					if (yych == 'f') goto yy1078;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy1078;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy1078;
					goto yy494;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy1078;
					if (yych <= 'q') goto yy12;
					goto yy495;
				} else {
					if (yych <= 's') goto yy489;
					if (yych <= 't') goto yy492;
					goto yy1078;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy1078;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy1078;
					if (yych == 0xC2) goto yy1078;
					goto yy12;
				}
			}
		}
	}
yy26:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy484;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy486;
					if (yych <= ',') goto yy12;
					goto yy497;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy498;
					if (yych <= '/') goto yy496;
					goto yy1120;
				} else {
					if (yych <= '9') goto yy1087;
					if (yych <= ':') goto yy507;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy486;
					if (yych <= 'C') goto yy12;
					goto yy486;
				} else {
					if (yych == 'F') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy486;
					if (yych <= 'L') goto yy12;
					goto yy486;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy486;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy486;
					if (yych <= 'c') goto yy12;
					goto yy486;
				} else {
					if (yych == 'f') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy486;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy486;
					goto yy494;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy486;
					if (yych <= 'q') goto yy12;
					goto yy495;
				} else {
					if (yych <= 's') goto yy489;
					if (yych <= 't') goto yy492;
					goto yy486;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy486;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy486;
					if (yych == 0xC2) goto yy486;
					goto yy12;
				}
			}
		}
	}
yy27:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy484;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy486;
					if (yych <= ',') goto yy12;
					goto yy497;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy498;
					if (yych <= '/') goto yy496;
					goto yy1087;
				} else {
					if (yych <= '9') goto yy1074;
					if (yych <= ':') goto yy507;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy486;
					if (yych <= 'C') goto yy12;
					goto yy486;
				} else {
					if (yych == 'F') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy486;
					if (yych <= 'L') goto yy12;
					goto yy486;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy486;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy486;
					if (yych <= 'c') goto yy12;
					goto yy486;
				} else {
					if (yych == 'f') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy486;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy486;
					goto yy494;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy486;
					if (yych <= 'q') goto yy12;
					goto yy495;
				} else {
					if (yych <= 's') goto yy489;
					if (yych <= 't') goto yy492;
					goto yy486;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy486;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy486;
					if (yych == 0xC2) goto yy486;
					goto yy12;
				}
			}
		}
	}
yy28:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy484;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy486;
					if (yych <= ',') goto yy12;
					goto yy497;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy498;
					if (yych <= '/') goto yy496;
					goto yy1074;
				} else {
					if (yych <= '9') goto yy493;
					if (yych <= ':') goto yy507;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy486;
					if (yych <= 'C') goto yy12;
					goto yy486;
				} else {
					if (yych == 'F') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy486;
					if (yych <= 'L') goto yy12;
					goto yy486;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy486;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy486;
					if (yych <= 'c') goto yy12;
					goto yy486;
				} else {
					if (yych == 'f') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy486;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy486;
					goto yy494;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy486;
					if (yych <= 'q') goto yy12;
					goto yy495;
				} else {
					if (yych <= 's') goto yy489;
					if (yych <= 't') goto yy492;
					goto yy486;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy486;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy486;
					if (yych == 0xC2) goto yy486;
					goto yy12;
				}
			}
		}
	}
yy29:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy484;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy486;
					if (yych <= ',') goto yy12;
					goto yy497;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy498;
					if (yych <= '/') goto yy496;
					goto yy493;
				} else {
					if (yych <= ':') goto yy507;
					if (yych <= '@') goto yy12;
					goto yy486;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy486;
					goto yy12;
				} else {
					if (yych == 'G') goto yy12;
					goto yy486;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy12;
					if (yych <= 'P') goto yy486;
					goto yy12;
				} else {
					if (yych <= 'Y') goto yy486;
					if (yych <= '`') goto yy12;
					goto yy486;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy486;
					goto yy12;
				} else {
					if (yych == 'g') goto yy12;
					goto yy486;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy486;
					goto yy12;
				} else {
					if (yych == 'n') goto yy494;
					goto yy486;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy12;
					if (yych <= 'r') goto yy495;
					goto yy489;
				} else {
					if (yych <= 't') goto yy492;
					if (yych <= 'u') goto yy486;
					goto yy12;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy12;
					goto yy486;
				} else {
					if (yych == 0xC2) goto yy486;
					goto yy12;
				}
			}
		}
	}
yy30:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy464;
	case '0':
	case '1':	goto yy461;
	case '2':	goto yy462;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy463;
	default:	goto yy12;
	}
yy31:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy460;
				if (yych <= 'U') goto yy165;
				goto yy459;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy459;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy32:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy456;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy33:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy454;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy34:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy437;
			if (yych <= 'T') goto yy165;
			goto yy436;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy446;
		} else {
			if (yych == 'u') goto yy445;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy35:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy437;
			if (yych <= 'T') goto yy165;
			goto yy436;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy437;
		} else {
			if (yych == 'u') goto yy436;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy36:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy415;
				goto yy165;
			} else {
				if (yych <= 'P') goto yy414;
				if (yych <= 'T') goto yy165;
				goto yy413;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'g') goto yy427;
				goto yy170;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy426;
				goto yy170;
			} else {
				if (yych <= 'u') goto yy425;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy415;
				goto yy165;
			} else {
				if (yych <= 'P') goto yy414;
				if (yych <= 'T') goto yy165;
				goto yy413;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'g') goto yy415;
				goto yy165;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy414;
				goto yy165;
			} else {
				if (yych <= 'u') goto yy413;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy38:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy165;
			goto yy403;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'c') goto yy408;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy165;
			goto yy403;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'c') goto yy403;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy40:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy216;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'e') goto yy394;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy216;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy216;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy42:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'e') goto yy203;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy43:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy189;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy165;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy181;
			goto yy165;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy45:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy180;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy180;
	goto yy12;
yy46:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy170;
		goto yy3;
	}
yy47:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy165;
		goto yy3;
	}
yy48:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	{
		goto std;
	}
yy50:
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	++YYCURSOR;
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy53:
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy66;
				} else {
					if (yych == 'F') goto yy67;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych >= 'S') goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy70;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych >= 'f') goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy65;
				} else {
					if (yych == 'm') goto yy61;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy70;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych >= 'w') goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
				}
			}
		}
	}
yy56:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 17) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy74;
					} else {
						goto yy191;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy218;
					} else {
						goto yy223;
					}
				} else {
					if (yyaccept == 7) {
						goto yy247;
					} else {
						goto yy319;
					}
				}
			}
		} else {
			if (yyaccept <= 13) {
				if (yyaccept <= 11) {
					if (yyaccept <= 10) {
						if (yyaccept == 9) {
							goto yy417;
						} else {
							goto yy500;
						}
					} else {
						goto yy515;
					}
				} else {
					if (yyaccept == 12) {
						goto yy636;
					} else {
						goto yy681;
					}
				}
			} else {
				if (yyaccept <= 15) {
					if (yyaccept == 14) {
						goto yy691;
					} else {
						goto yy788;
					}
				} else {
					if (yyaccept == 16) {
						goto yy808;
					} else {
						goto yy839;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 26) {
			if (yyaccept <= 22) {
				if (yyaccept <= 20) {
					if (yyaccept <= 19) {
						if (yyaccept == 18) {
							goto yy846;
						} else {
							goto yy873;
						}
					} else {
						goto yy818;
					}
				} else {
					if (yyaccept == 21) {
						goto yy479;
					} else {
						goto yy998;
					}
				}
			} else {
				if (yyaccept <= 24) {
					if (yyaccept == 23) {
						goto yy867;
					} else {
						goto yy1092;
					}
				} else {
					if (yyaccept == 25) {
						goto yy1100;
					} else {
						goto yy1144;
					}
				}
			}
		} else {
			if (yyaccept <= 30) {
				if (yyaccept <= 28) {
					if (yyaccept == 27) {
						goto yy1168;
					} else {
						goto yy1344;
					}
				} else {
					if (yyaccept == 29) {
						goto yy1437;
					} else {
						goto yy1475;
					}
				}
			} else {
				if (yyaccept <= 32) {
					if (yyaccept == 31) {
						goto yy1478;
					} else {
						goto yy1558;
					}
				} else {
					if (yyaccept == 33) {
						goto yy1566;
					} else {
						goto yy1589;
					}
				}
			}
		}
	}
yy57:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy60:
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy66;
				} else {
					if (yych == 'F') goto yy67;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy56;
					goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy70;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych <= 'e') goto yy56;
					goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy65;
				} else {
					if (yych != 'm') goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy70;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych <= 'v') goto yy56;
					goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy61:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy138;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy138;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy137;
			if (yych == 's') goto yy139;
			goto yy56;
		}
	}
yy62:
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy134;
	goto yy56;
yy63:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy132;
	if (yych == 's') goto yy132;
	goto yy56;
yy64:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy120;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy120;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy65:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy116;
	if (yych == 'o') goto yy116;
	goto yy56;
yy66:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy115;
	if (yych == 'a') goto yy115;
	goto yy56;
yy67:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy100;
		if (yych <= 'Q') goto yy56;
		goto yy99;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy100;
		} else {
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy68:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy69:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy84;
	if (yych == 'e') goto yy84;
	goto yy56;
yy70:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy71;
		if (yych <= 'T') goto yy56;
		goto yy72;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy71:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy79;
	if (yych == 'u') goto yy79;
	goto yy56;
yy72:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy73;
	if (yych != 'e') goto yy56;
yy73:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy75;
	if (yych == 's') goto yy75;
yy74:
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy75:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy76;
	if (yych != 'd') goto yy56;
yy76:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy77;
	if (yych != 'a') goto yy56;
yy77:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych != 'y') goto yy56;
yy78:
	yych = *++YYCURSOR;
	goto yy74;
yy79:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy80;
	if (yych != 'r') goto yy74;
yy80:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy81;
	if (yych != 's') goto yy56;
yy81:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy82;
	if (yych != 'd') goto yy56;
yy82:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy83;
	if (yych != 'a') goto yy56;
yy83:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy84:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy86;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy86;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy92;
	if (yych == 'k') goto yy92;
	goto yy56;
yy86:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy87;
	if (yych != 'n') goto yy74;
yy87:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy88;
	if (yych != 'e') goto yy56;
yy88:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych != 's') goto yy56;
yy89:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy90;
	if (yych != 'd') goto yy56;
yy90:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy91;
	if (yych != 'a') goto yy56;
yy91:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy92:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy93;
		if (yych <= 'R') goto yy74;
		goto yy78;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy74;
		} else {
			if (yych == 's') goto yy78;
			goto yy74;
		}
	}
yy93:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy94;
	if (yych != 'a') goto yy56;
yy94:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy95;
	if (yych != 'y') goto yy56;
yy95:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy78;
	if (yych == 's') goto yy78;
	goto yy74;
yy96:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy97;
	if (yych != 'a') goto yy56;
yy97:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy98;
	if (yych != 'r') goto yy56;
yy98:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy78;
	if (yych == 's') goto yy78;
	goto yy74;
yy99:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy112;
	if (yych == 'i') goto yy112;
	goto yy56;
yy100:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy101;
	if (yych != 'r') goto yy56;
yy101:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy102;
	if (yych != 't') goto yy56;
yy102:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy104;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy104;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy109;
	if (yych == 'i') goto yy109;
	goto yy56;
yy104:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy105;
	if (yych != 'n') goto yy56;
yy105:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy106;
	if (yych != 'i') goto yy56;
yy106:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy107;
	if (yych != 'g') goto yy56;
yy107:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy108;
	if (yych != 'h') goto yy56;
yy108:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy98;
	if (yych == 't') goto yy98;
	goto yy56;
yy109:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy110;
	if (yych != 'g') goto yy56;
yy110:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy111;
	if (yych != 'h') goto yy56;
yy111:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy98;
	if (yych == 't') goto yy98;
	goto yy56;
yy112:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy113;
	if (yych != 'd') goto yy74;
yy113:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy114;
	if (yych != 'a') goto yy56;
yy114:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy115:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy98;
	if (yych == 'y') goto yy98;
	goto yy56;
yy116:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy117;
	if (yych != 'u') goto yy56;
yy117:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy98;
	if (yych == 'r') goto yy98;
	goto yy56;
yy118:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy129;
	if (yych == 'n') goto yy129;
	goto yy56;
yy119:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy124;
	if (yych == 't') goto yy124;
	goto yy56;
yy120:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy121;
	if (yych != 'c') goto yy56;
yy121:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy122;
		if (yych <= 'R') goto yy74;
		goto yy78;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy74;
		} else {
			if (yych == 's') goto yy78;
			goto yy74;
		}
	}
yy122:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy123;
	if (yych != 'n') goto yy56;
yy123:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy124:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy125;
	if (yych != 'u') goto yy74;
yy125:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy126;
	if (yych != 'r') goto yy56;
yy126:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy127;
	if (yych != 'd') goto yy56;
yy127:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy128;
	if (yych != 'a') goto yy56;
yy128:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy129:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy130;
	if (yych != 'd') goto yy74;
yy130:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy131;
	if (yych != 'a') goto yy56;
yy131:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy132:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy133;
	if (yych != 'e') goto yy56;
yy133:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy134:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy135;
	if (yych != 's') goto yy56;
yy135:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy136;
	if (yych != 'e') goto yy74;
yy136:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy137:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy160;
	if (yych == 'n') goto yy160;
	goto yy56;
yy138:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy142;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy141;
			if (yych <= 'M') goto yy56;
			goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy142;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy141;
			if (yych == 'n') goto yy143;
			goto yy56;
		}
	}
yy139:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy140;
	if (yych != 'e') goto yy74;
yy140:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy141:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy153;
	if (yych == 'l') goto yy153;
	goto yy56;
yy142:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy146;
	if (yych == 'r') goto yy146;
	goto yy56;
yy143:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy78;
		if (yych <= 'T') goto yy74;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy74;
			goto yy78;
		} else {
			if (yych != 'u') goto yy74;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy145;
	if (yych != 't') goto yy56;
yy145:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy56;
yy146:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy147;
	if (yych != 'o') goto yy56;
yy147:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy148;
	if (yych != 's') goto yy56;
yy148:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy149;
	if (yych != 'e') goto yy56;
yy149:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy150;
	if (yych != 'c') goto yy56;
yy150:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy151;
	if (yych != 'o') goto yy56;
yy151:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy152;
	if (yych != 'n') goto yy56;
yy152:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy153:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy154;
	if (yych != 'i') goto yy56;
yy154:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy155;
	if (yych != 's') goto yy56;
yy155:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy156;
	if (yych != 'e') goto yy56;
yy156:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy157;
	if (yych != 'c') goto yy56;
yy157:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy158;
	if (yych != 'o') goto yy56;
yy158:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy159;
	if (yych != 'n') goto yy56;
yy159:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy160:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy161;
		if (yych <= 'S') goto yy74;
		goto yy162;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy74;
		} else {
			if (yych == 't') goto yy162;
			goto yy74;
		}
	}
yy161:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy163;
	if (yych == 'a') goto yy163;
	goto yy56;
yy162:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy98;
	if (yych == 'h') goto yy98;
	goto yy56;
yy163:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy164:
	yych = *++YYCURSOR;
	goto yy3;
yy165:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy166;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy166:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy167:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy168;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy168:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy169;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy169:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy164;
	goto yy3;
yy170:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy166;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy171:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy167;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy172:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	goto yy56;
yy173:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy3;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy3;
	}
yy175:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy176:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy177:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy164;
		if (yych <= ',') goto yy3;
		goto yy172;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy3;
		}
	}
yy178:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy179:
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy56;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy56;
	}
yy180:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy165;
		goto yy3;
	}
yy181:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy166;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy166;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy183;
			if (yych <= '@') goto yy3;
			goto yy167;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy183:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy184;
	if (yych <= '2') goto yy185;
	if (yych <= '9') goto yy186;
	goto yy56;
yy184:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy186;
	if (yych <= ':') goto yy187;
	goto yy3;
yy185:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy188;
	} else {
		if (yych <= '9') goto yy164;
		if (yych <= ':') goto yy187;
		goto yy3;
	}
yy186:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy188;
	if (yych <= '9') goto yy164;
	if (yych >= ';') goto yy3;
yy187:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy188;
	if (yych <= '9') goto yy164;
	goto yy3;
yy188:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy164;
	goto yy3;
yy189:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy166;
			if (yych >= 'E') goto yy192;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'd') goto yy190;
			if (yych <= 'e') goto yy192;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy190:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'M') goto yy167;
			goto yy198;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych >= 'a') goto yy167;
		} else {
			if (yych <= 'n') goto yy198;
			if (yych <= 'z') goto yy167;
		}
	}
yy191:
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy192:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy167;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'k') goto yy193;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy193:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy194;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy194:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy195;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy195:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy196;
		if (yych != 'y') goto yy3;
	}
yy196:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy197;
	if (yych != 's') goto yy191;
yy197:
	yych = *++YYCURSOR;
	goto yy191;
yy198:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy199;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy199:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy169;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 's') goto yy200;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy200:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy201;
		if (yych != 'd') goto yy3;
	}
yy201:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy56;
yy202:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy203:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy172;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy166;
				goto yy190;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy192;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy171;
			} else {
				if (yych <= 'e') goto yy205;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy198;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy211;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy205:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy193;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'k') goto yy206;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy206:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy194;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy207;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy207:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy195;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy208;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy208:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy196;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy209;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy209:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy172;
			goto yy191;
		} else {
			if (yych <= '/') goto yy172;
			if (yych <= 'R') goto yy191;
			goto yy197;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy172;
			goto yy191;
		} else {
			if (yych == 's') goto yy210;
			if (yych <= 'z') goto yy178;
			goto yy191;
		}
	}
yy210:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy191;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy191;
	}
yy211:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy199;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy212;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy212:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy200;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 's') goto yy213;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy213:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy201;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'd') goto yy214;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy214:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy179;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy216:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'c') goto yy217;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy217:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy220;
			} else {
				if (yych == ' ') goto yy220;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
			} else {
				if (yych == 'E') goto yy226;
				goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy167;
			} else {
				if (yych <= 'e') goto yy226;
				if (yych <= 'z') goto yy167;
			}
		}
	}
yy218:
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy219:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy220:
	if (yybm[0+yych] & 32) {
		goto yy219;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy222;
	if (yych <= '3') goto yy224;
	if (yych <= '9') goto yy225;
	goto yy56;
yy221:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy220;
	if (yych <= '0') goto yy381;
	if (yych <= '2') goto yy382;
	if (yych <= '3') goto yy383;
	goto yy220;
yy222:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy240;
			if (yych <= '0') goto yy322;
			goto yy323;
		} else {
			if (yych <= '2') goto yy379;
			if (yych <= '9') goto yy380;
			goto yy240;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy236;
			if (yych <= 'q') goto yy240;
			goto yy237;
		} else {
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy223:
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy224:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy240;
			if (yych <= '0') goto yy322;
			goto yy323;
		} else {
			if (yych <= '2') goto yy233;
			if (yych <= '9') goto yy234;
			goto yy240;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy236;
			if (yych <= 'q') goto yy240;
			goto yy237;
		} else {
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy225:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy240;
			if (yych <= '0') goto yy231;
			goto yy232;
		} else {
			if (yych <= '2') goto yy233;
			if (yych <= '9') goto yy234;
			goto yy240;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy236;
			if (yych <= 'q') goto yy240;
			goto yy237;
		} else {
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy226:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'm') goto yy227;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy227:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'b') goto yy228;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy228:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy229;
		if (yych != 'e') goto yy3;
	}
yy229:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy230;
	if (yych != 'r') goto yy56;
yy230:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy220;
		if (yych <= 0x1F) goto yy218;
		goto yy220;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy218;
			goto yy220;
		} else {
			if (yych <= '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		}
	}
yy231:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy56;
	} else {
		if (yych <= '0') goto yy320;
		if (yych <= '9') goto yy321;
		if (yych <= ':') goto yy245;
		goto yy56;
	}
yy232:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '2') goto yy321;
		if (yych <= '9') goto yy320;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy233:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '4') goto yy320;
		if (yych <= '9') goto yy317;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy234:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '9') goto yy317;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy235:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy240;
yy236:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy240;
yy237:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy240;
yy238:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy240;
yy239:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy240:
	if (yybm[0+yych] & 64) {
		goto yy239;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy223;
		if (yych <= '0') goto yy283;
		if (yych <= '1') goto yy284;
		goto yy285;
	} else {
		if (yych <= '9') goto yy286;
		if (yych != 'T') goto yy223;
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy242;
	if (yych <= '2') goto yy243;
	if (yych <= '9') goto yy244;
	goto yy56;
yy242:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy56;
	} else {
		if (yych <= '9') goto yy244;
		if (yych <= ':') goto yy245;
		goto yy56;
	}
yy243:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy56;
	} else {
		if (yych <= '4') goto yy244;
		if (yych == ':') goto yy245;
		goto yy56;
	}
yy244:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy245;
	if (yych != ':') goto yy56;
yy245:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy246;
	if (yych <= '9') goto yy248;
	goto yy56;
yy246:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy249;
	} else {
		if (yych <= '9') goto yy248;
		if (yych <= ':') goto yy249;
	}
yy247:
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy248:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy249;
	if (yych != ':') goto yy247;
yy249:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy250;
	if (yych <= '6') goto yy251;
	if (yych <= '9') goto yy252;
	goto yy56;
yy250:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy247;
	if (yych <= '9') goto yy253;
	goto yy247;
yy251:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy253;
	goto yy247;
yy252:
	yych = *++YYCURSOR;
	goto yy247;
yy253:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy255;
			goto yy247;
		} else {
			if (yych <= ' ') goto yy255;
			if (yych == '(') goto yy255;
			goto yy247;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy247;
			if (yych <= '-') goto yy255;
			goto yy247;
		} else {
			if (yych <= 'Z') goto yy255;
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy255;
			goto yy247;
		}
	}
yy254:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy255:
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy254;
			if (yych <= 0x1F) goto yy56;
			goto yy254;
		} else {
			if (yych == '(') goto yy258;
			if (yych <= '*') goto yy56;
			goto yy257;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy257;
			if (yych <= '@') goto yy56;
			goto yy259;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'H') goto yy259;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy260;
				goto yy56;
			}
		}
	}
yy256:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy252;
		if (yych <= '@') goto yy247;
		goto yy261;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy281;
			goto yy261;
		} else {
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy266;
			goto yy247;
		}
	}
yy257:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy276;
	if (yych <= '2') goto yy277;
	if (yych <= '9') goto yy278;
	goto yy56;
yy258:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy260;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy260;
	goto yy56;
yy259:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy252;
		goto yy247;
	} else {
		if (yych <= 'Z') goto yy261;
		if (yych <= '`') goto yy247;
		if (yych <= 'z') goto yy266;
		goto yy247;
	}
yy260:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy252;
		goto yy247;
	} else {
		if (yych <= 'Z') goto yy261;
		if (yych <= '`') goto yy247;
		if (yych >= '{') goto yy247;
	}
yy261:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy252;
		goto yy247;
	} else {
		if (yych <= 'Z') goto yy262;
		if (yych <= '`') goto yy247;
		if (yych >= '{') goto yy247;
	}
yy262:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy252;
		goto yy247;
	} else {
		if (yych <= 'Z') goto yy263;
		if (yych <= '`') goto yy247;
		if (yych >= '{') goto yy247;
	}
yy263:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy252;
		goto yy247;
	} else {
		if (yych <= 'Z') goto yy264;
		if (yych <= '`') goto yy247;
		if (yych >= '{') goto yy247;
	}
yy264:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy252;
		goto yy247;
	} else {
		if (yych <= 'Z') goto yy265;
		if (yych <= '`') goto yy247;
		if (yych >= '{') goto yy247;
	}
yy265:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy252;
	goto yy247;
yy266:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych == '.') goto yy247;
			goto yy268;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy247;
			if (yych <= 'Z') goto yy262;
			goto yy247;
		} else {
			if (yych <= '_') goto yy268;
			if (yych <= '`') goto yy247;
			if (yych >= '{') goto yy247;
		}
	}
yy267:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych == '.') goto yy247;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy247;
			if (yych <= 'Z') goto yy263;
			goto yy247;
		} else {
			if (yych <= '_') goto yy268;
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy271;
			goto yy247;
		}
	}
yy268:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy269;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy269:
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy247;
			goto yy268;
		} else {
			if (yych == '/') goto yy268;
			goto yy247;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy247;
			goto yy268;
		} else {
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy269;
			goto yy247;
		}
	}
yy271:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych == '.') goto yy247;
			goto yy268;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy247;
			if (yych <= 'Z') goto yy264;
			goto yy247;
		} else {
			if (yych <= '_') goto yy268;
			if (yych <= '`') goto yy247;
			if (yych >= '{') goto yy247;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych == '.') goto yy247;
			goto yy268;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy247;
			if (yych <= 'Z') goto yy265;
			goto yy247;
		} else {
			if (yych <= '_') goto yy268;
			if (yych <= '`') goto yy247;
			if (yych >= '{') goto yy247;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy247;
			goto yy252;
		} else {
			if (yych == '-') goto yy268;
			goto yy247;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy268;
			if (yych <= '^') goto yy247;
			goto yy268;
		} else {
			if (yych <= '`') goto yy247;
			if (yych >= '{') goto yy247;
		}
	}
yy274:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy268;
		if (yych <= '.') goto yy56;
		goto yy268;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy268;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy274;
			goto yy56;
		}
	}
yy276:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy247;
	if (yych <= '9') goto yy278;
	if (yych <= ':') goto yy279;
	goto yy247;
yy277:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy247;
		if (yych >= '5') goto yy280;
	} else {
		if (yych <= '9') goto yy252;
		if (yych <= ':') goto yy279;
		goto yy247;
	}
yy278:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy247;
	if (yych <= '5') goto yy280;
	if (yych <= '9') goto yy252;
	if (yych >= ';') goto yy247;
yy279:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy247;
	if (yych <= '5') goto yy280;
	if (yych <= '9') goto yy252;
	goto yy247;
yy280:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy247;
	if (yych <= '9') goto yy252;
	goto yy247;
yy281:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy252;
		if (yych <= '@') goto yy247;
		goto yy262;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy262;
		} else {
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy262;
			goto yy247;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy247;
			goto yy252;
		} else {
			if (yych == '+') goto yy257;
			goto yy247;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy257;
			if (yych <= '@') goto yy247;
			goto yy263;
		} else {
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy263;
			goto yy247;
		}
	}
yy283:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy223;
	} else {
		if (yych <= '0') goto yy315;
		if (yych <= '9') goto yy316;
		if (yych <= ':') goto yy245;
		goto yy223;
	}
yy284:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy223;
	} else {
		if (yych <= '2') goto yy316;
		if (yych <= '9') goto yy315;
		if (yych <= ':') goto yy288;
		goto yy223;
	}
yy285:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy223;
	} else {
		if (yych <= '4') goto yy315;
		if (yych <= '9') goto yy287;
		if (yych <= ':') goto yy288;
		goto yy223;
	}
yy286:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy223;
	} else {
		if (yych <= '9') goto yy287;
		if (yych <= ':') goto yy288;
		goto yy223;
	}
yy287:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy313;
	goto yy223;
yy288:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy289;
	if (yych <= '9') goto yy290;
	goto yy56;
yy289:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy291;
		goto yy247;
	} else {
		if (yych <= '9') goto yy306;
		if (yych <= ':') goto yy291;
		goto yy247;
	}
yy290:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy291;
	if (yych != ':') goto yy247;
yy291:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy292;
	if (yych <= '6') goto yy293;
	if (yych <= '9') goto yy252;
	goto yy56;
yy292:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy247;
	if (yych <= '9') goto yy294;
	goto yy247;
yy293:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy247;
yy294:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy296;
			goto yy247;
		} else {
			if (yych <= ' ') goto yy296;
			if (yych == '(') goto yy296;
			goto yy247;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy247;
			if (yych <= '-') goto yy296;
			goto yy247;
		} else {
			if (yych <= 'Z') goto yy296;
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy296;
			goto yy247;
		}
	}
yy295:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy296:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy295;
			} else {
				if (yych == ' ') goto yy295;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy258;
				if (yych <= '*') goto yy56;
				goto yy257;
			} else {
				if (yych == '-') goto yy257;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy297;
				if (yych <= 'F') goto yy259;
				goto yy256;
			} else {
				if (yych != 'P') goto yy259;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy298;
				goto yy260;
			} else {
				if (yych <= 'p') goto yy298;
				if (yych <= 'z') goto yy260;
				goto yy56;
			}
		}
	}
yy297:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych <= '.') goto yy299;
			if (yych <= '@') goto yy247;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy300;
			if (yych <= 'Z') goto yy261;
			goto yy247;
		} else {
			if (yych == 'm') goto yy305;
			if (yych <= 'z') goto yy266;
			goto yy247;
		}
	}
yy298:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych <= '.') goto yy299;
			if (yych <= '@') goto yy247;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy300;
			if (yych <= 'Z') goto yy261;
			goto yy247;
		} else {
			if (yych == 'm') goto yy300;
			if (yych <= 'z') goto yy261;
			goto yy247;
		}
	}
yy299:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy304;
	if (yych == 'm') goto yy304;
	goto yy56;
yy300:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy302;
			if (yych <= 0x08) goto yy247;
			goto yy302;
		} else {
			if (yych == ' ') goto yy302;
			if (yych <= '(') goto yy247;
			goto yy252;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy247;
		} else {
			if (yych <= 'Z') goto yy262;
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy262;
			goto yy247;
		}
	}
yy301:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy302;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy302:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy304:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy302;
		if (yych == '\t') goto yy302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy302;
		if (yych == '.') goto yy301;
		goto yy56;
	}
yy305:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy302;
			if (yych == '\t') goto yy302;
			goto yy247;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy302;
				goto yy247;
			} else {
				if (yych <= ')') goto yy252;
				if (yych <= ',') goto yy247;
				goto yy268;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy301;
			if (yych <= '/') goto yy268;
			if (yych <= '@') goto yy247;
			goto yy262;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy247;
				goto yy268;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy267;
				goto yy247;
			}
		}
	}
yy306:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy307;
			if (yych <= 0x1F) goto yy247;
		} else {
			if (yych == '.') goto yy291;
			if (yych <= '9') goto yy247;
			goto yy291;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy309;
			if (yych <= 'O') goto yy247;
			goto yy309;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy247;
				goto yy309;
			} else {
				if (yych == 'p') goto yy309;
				goto yy247;
			}
		}
	}
yy307:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy307;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy307;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy309;
			if (yych != 'p') goto yy56;
		}
	}
yy309:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy311;
		if (yych == 'm') goto yy311;
		goto yy56;
	}
yy310:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy311;
	if (yych != 'm') goto yy56;
yy311:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy302;
		if (yych == '\t') goto yy302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy302;
		if (yych != '.') goto yy56;
	}
yy312:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy302;
		if (yych <= 0x08) goto yy56;
		goto yy302;
	} else {
		if (yych == ' ') goto yy302;
		goto yy56;
	}
yy313:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych >= ':') goto yy223;
	yych = *++YYCURSOR;
	goto yy223;
yy315:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy223;
	} else {
		if (yych <= '9') goto yy313;
		if (yych <= ':') goto yy245;
		goto yy223;
	}
yy316:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy223;
	} else {
		if (yych <= '9') goto yy313;
		if (yych <= ':') goto yy288;
		goto yy223;
	}
yy317:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy318:
	++YYCURSOR;
yy319:
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy320:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy56;
	} else {
		if (yych <= '9') goto yy318;
		if (yych <= ':') goto yy245;
		goto yy56;
	}
yy321:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '9') goto yy318;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy322:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy355;
			goto yy240;
		} else {
			if (yych <= '0') goto yy356;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy245;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy323:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych != '.') goto yy240;
		} else {
			if (yych <= '0') goto yy325;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy288;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy324:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy240;
		if (yych <= '0') goto yy330;
		goto yy331;
	} else {
		if (yych <= '2') goto yy332;
		if (yych <= '5') goto yy333;
		if (yych <= '9') goto yy334;
		goto yy240;
	}
yy325:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '0') goto yy328;
		if (yych <= '9') goto yy329;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy326:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '2') goto yy329;
		if (yych <= '9') goto yy328;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy327:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy288;
		goto yy56;
	} else {
		if (yych <= '4') goto yy328;
		if (yych <= '9') goto yy318;
		if (yych <= ':') goto yy288;
		goto yy56;
	}
yy328:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy245;
	if (yych == ':') goto yy245;
	goto yy319;
yy329:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy288;
	if (yych == ':') goto yy288;
	goto yy319;
yy330:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy350;
		goto yy223;
	} else {
		if (yych <= '0') goto yy349;
		if (yych <= '9') goto yy354;
		if (yych <= ':') goto yy350;
		goto yy223;
	}
yy331:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy223;
	} else {
		if (yych <= '2') goto yy354;
		if (yych <= '9') goto yy349;
		if (yych <= ':') goto yy335;
		goto yy223;
	}
yy332:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy223;
	} else {
		if (yych <= '4') goto yy349;
		if (yych <= '9') goto yy348;
		if (yych <= ':') goto yy335;
		goto yy223;
	}
yy333:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy223;
	} else {
		if (yych <= '9') goto yy348;
		if (yych <= ':') goto yy335;
		goto yy223;
	}
yy334:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy223;
	} else {
		if (yych <= '9') goto yy287;
		if (yych >= ';') goto yy223;
	}
yy335:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy336;
	if (yych <= '6') goto yy337;
	if (yych <= '9') goto yy290;
	goto yy56;
yy336:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy291;
		goto yy247;
	} else {
		if (yych <= '9') goto yy338;
		if (yych <= ':') goto yy291;
		goto yy247;
	}
yy337:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy291;
		goto yy247;
	} else {
		if (yych <= '0') goto yy294;
		if (yych == ':') goto yy291;
		goto yy247;
	}
yy338:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy340;
			if (yych <= 0x1F) goto yy247;
			goto yy340;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy247;
				goto yy340;
			} else {
				if (yych == '+') goto yy340;
				goto yy247;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy340;
			if (yych <= '.') goto yy291;
			if (yych <= '9') goto yy247;
			goto yy291;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy247;
				goto yy340;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy340;
				goto yy247;
			}
		}
	}
yy339:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy340:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy339;
			} else {
				if (yych == ' ') goto yy339;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy258;
				if (yych <= '*') goto yy56;
				goto yy257;
			} else {
				if (yych == '-') goto yy257;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy341;
				if (yych <= 'F') goto yy259;
				goto yy256;
			} else {
				if (yych != 'P') goto yy259;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy342;
				goto yy260;
			} else {
				if (yych <= 'p') goto yy342;
				if (yych <= 'z') goto yy260;
				goto yy56;
			}
		}
	}
yy341:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych <= '.') goto yy344;
			if (yych <= '@') goto yy247;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy343;
			if (yych <= 'Z') goto yy261;
			goto yy247;
		} else {
			if (yych == 'm') goto yy347;
			if (yych <= 'z') goto yy266;
			goto yy247;
		}
	}
yy342:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych <= '.') goto yy344;
			if (yych <= '@') goto yy247;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy343;
			if (yych <= 'Z') goto yy261;
			goto yy247;
		} else {
			if (yych == 'm') goto yy343;
			if (yych <= 'z') goto yy261;
			goto yy247;
		}
	}
yy343:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy302;
			if (yych <= 0x08) goto yy247;
			goto yy302;
		} else {
			if (yych == ' ') goto yy302;
			if (yych <= '(') goto yy247;
			goto yy252;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy346;
			goto yy247;
		} else {
			if (yych <= 'Z') goto yy262;
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy262;
			goto yy247;
		}
	}
yy344:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy345;
	if (yych != 'm') goto yy56;
yy345:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy302;
		if (yych == '\t') goto yy302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy302;
		if (yych != '.') goto yy56;
	}
yy346:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy302;
		if (yych <= 0x08) goto yy56;
		goto yy302;
	} else {
		if (yych == ' ') goto yy302;
		goto yy56;
	}
yy347:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy302;
			if (yych == '\t') goto yy302;
			goto yy247;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy302;
				goto yy247;
			} else {
				if (yych <= ')') goto yy252;
				if (yych <= ',') goto yy247;
				goto yy268;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy346;
			if (yych <= '/') goto yy268;
			if (yych <= '@') goto yy247;
			goto yy262;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy247;
				goto yy268;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy267;
				goto yy247;
			}
		}
	}
yy348:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy307;
			if (yych <= 0x1F) goto yy223;
			goto yy307;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy223;
				goto yy291;
			} else {
				if (yych <= '/') goto yy223;
				if (yych <= '9') goto yy313;
				goto yy291;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy309;
			if (yych <= 'O') goto yy223;
			goto yy309;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy223;
				goto yy309;
			} else {
				if (yych == 'p') goto yy309;
				goto yy223;
			}
		}
	}
yy349:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy307;
			if (yych <= 0x1F) goto yy223;
			goto yy307;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy223;
			} else {
				if (yych <= '/') goto yy223;
				if (yych <= '9') goto yy313;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy309;
			if (yych <= 'O') goto yy223;
			goto yy309;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy223;
				goto yy309;
			} else {
				if (yych == 'p') goto yy309;
				goto yy223;
			}
		}
	}
yy350:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy351;
	if (yych <= '6') goto yy352;
	if (yych <= '9') goto yy248;
	goto yy56;
yy351:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy249;
		goto yy247;
	} else {
		if (yych <= '9') goto yy353;
		if (yych <= ':') goto yy249;
		goto yy247;
	}
yy352:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy249;
		goto yy247;
	} else {
		if (yych <= '0') goto yy294;
		if (yych == ':') goto yy249;
		goto yy247;
	}
yy353:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy296;
			if (yych <= 0x1F) goto yy247;
			goto yy296;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy247;
				goto yy296;
			} else {
				if (yych == '+') goto yy296;
				goto yy247;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy296;
			if (yych <= '.') goto yy249;
			if (yych <= '9') goto yy247;
			goto yy249;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy247;
				goto yy296;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy296;
				goto yy247;
			}
		}
	}
yy354:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy307;
			if (yych <= 0x1F) goto yy223;
			goto yy307;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy223;
				goto yy335;
			} else {
				if (yych <= '/') goto yy223;
				if (yych <= '9') goto yy313;
				goto yy335;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy309;
			if (yych <= 'O') goto yy223;
			goto yy309;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy223;
				goto yy309;
			} else {
				if (yych == 'p') goto yy309;
				goto yy223;
			}
		}
	}
yy355:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy240;
		if (yych <= '0') goto yy357;
		goto yy358;
	} else {
		if (yych <= '2') goto yy359;
		if (yych <= '5') goto yy360;
		if (yych <= '9') goto yy361;
		goto yy240;
	}
yy356:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy245;
		goto yy56;
	} else {
		if (yych <= '0') goto yy328;
		if (yych <= '9') goto yy329;
		if (yych <= ':') goto yy245;
		goto yy56;
	}
yy357:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy223;
	} else {
		if (yych <= '0') goto yy373;
		if (yych <= '9') goto yy378;
		if (yych <= ':') goto yy374;
		goto yy223;
	}
yy358:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy362;
		goto yy223;
	} else {
		if (yych <= '2') goto yy378;
		if (yych <= '9') goto yy373;
		if (yych <= ':') goto yy362;
		goto yy223;
	}
yy359:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy362;
		goto yy223;
	} else {
		if (yych <= '4') goto yy373;
		if (yych <= '9') goto yy372;
		if (yych <= ':') goto yy362;
		goto yy223;
	}
yy360:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy362;
		goto yy223;
	} else {
		if (yych <= '9') goto yy372;
		if (yych <= ':') goto yy362;
		goto yy223;
	}
yy361:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy223;
	} else {
		if (yych <= '9') goto yy287;
		if (yych >= ';') goto yy223;
	}
yy362:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy363;
	if (yych <= '6') goto yy364;
	if (yych <= '9') goto yy290;
	goto yy56;
yy363:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy291;
		goto yy247;
	} else {
		if (yych <= '9') goto yy365;
		if (yych <= ':') goto yy291;
		goto yy247;
	}
yy364:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy291;
		goto yy247;
	} else {
		if (yych <= '0') goto yy253;
		if (yych == ':') goto yy291;
		goto yy247;
	}
yy365:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy367;
			if (yych <= 0x1F) goto yy247;
			goto yy367;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy247;
				goto yy367;
			} else {
				if (yych == '+') goto yy367;
				goto yy247;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy367;
			if (yych <= '.') goto yy291;
			if (yych <= '9') goto yy247;
			goto yy291;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy247;
				goto yy367;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy367;
				goto yy247;
			}
		}
	}
yy366:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy367:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy366;
			} else {
				if (yych == ' ') goto yy366;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy258;
				if (yych <= '*') goto yy56;
				goto yy257;
			} else {
				if (yych == '-') goto yy257;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy368;
				if (yych <= 'F') goto yy259;
				goto yy256;
			} else {
				if (yych != 'P') goto yy259;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy369;
				goto yy260;
			} else {
				if (yych <= 'p') goto yy369;
				if (yych <= 'z') goto yy260;
				goto yy56;
			}
		}
	}
yy368:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych <= '.') goto yy310;
			if (yych <= '@') goto yy247;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy370;
			if (yych <= 'Z') goto yy261;
			goto yy247;
		} else {
			if (yych == 'm') goto yy371;
			if (yych <= 'z') goto yy266;
			goto yy247;
		}
	}
yy369:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy252;
			goto yy247;
		} else {
			if (yych <= '.') goto yy310;
			if (yych <= '@') goto yy247;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy370;
			if (yych <= 'Z') goto yy261;
			goto yy247;
		} else {
			if (yych == 'm') goto yy370;
			if (yych <= 'z') goto yy261;
			goto yy247;
		}
	}
yy370:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy302;
			if (yych <= 0x08) goto yy247;
			goto yy302;
		} else {
			if (yych == ' ') goto yy302;
			if (yych <= '(') goto yy247;
			goto yy252;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy312;
			goto yy247;
		} else {
			if (yych <= 'Z') goto yy262;
			if (yych <= '`') goto yy247;
			if (yych <= 'z') goto yy262;
			goto yy247;
		}
	}
yy371:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy302;
			if (yych == '\t') goto yy302;
			goto yy247;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy302;
				goto yy247;
			} else {
				if (yych <= ')') goto yy252;
				if (yych <= ',') goto yy247;
				goto yy268;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy312;
			if (yych <= '/') goto yy268;
			if (yych <= '@') goto yy247;
			goto yy262;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy247;
				goto yy268;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy267;
				goto yy247;
			}
		}
	}
yy372:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy249;
		goto yy223;
	} else {
		if (yych <= '9') goto yy313;
		if (yych <= ':') goto yy249;
		goto yy223;
	}
yy373:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy223;
	} else {
		if (yych <= '9') goto yy313;
		if (yych >= ';') goto yy223;
	}
yy374:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy375;
	if (yych <= '6') goto yy376;
	if (yych <= '9') goto yy248;
	goto yy56;
yy375:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy249;
		goto yy247;
	} else {
		if (yych <= '9') goto yy377;
		if (yych <= ':') goto yy249;
		goto yy247;
	}
yy376:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy249;
		goto yy247;
	} else {
		if (yych <= '0') goto yy253;
		if (yych == ':') goto yy249;
		goto yy247;
	}
yy377:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy255;
			if (yych <= 0x1F) goto yy247;
			goto yy255;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy247;
				goto yy255;
			} else {
				if (yych == '+') goto yy255;
				goto yy247;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy255;
			if (yych <= '.') goto yy249;
			if (yych <= '9') goto yy247;
			goto yy249;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy247;
				goto yy255;
			} else {
				if (yych <= '`') goto yy247;
				if (yych <= 'z') goto yy255;
				goto yy247;
			}
		}
	}
yy378:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy362;
		goto yy223;
	} else {
		if (yych <= '9') goto yy313;
		if (yych <= ':') goto yy362;
		goto yy223;
	}
yy379:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy324;
			goto yy240;
		} else {
			if (yych <= '0') goto yy356;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy288;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy380:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy324;
			goto yy240;
		} else {
			if (yych <= '0') goto yy356;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy288;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy381:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy240;
			if (yych <= '0') goto yy384;
			goto yy385;
		} else {
			if (yych <= '2') goto yy392;
			if (yych <= '9') goto yy393;
			goto yy240;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy236;
			if (yych <= 'q') goto yy240;
			goto yy237;
		} else {
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy382:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy240;
			if (yych <= '0') goto yy384;
			goto yy385;
		} else {
			if (yych <= '2') goto yy392;
			if (yych <= '9') goto yy393;
			goto yy240;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy236;
			if (yych <= 'q') goto yy240;
			goto yy237;
		} else {
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy383:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy240;
			if (yych >= '1') goto yy385;
		} else {
			if (yych <= '2') goto yy233;
			if (yych <= '9') goto yy234;
			goto yy240;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy236;
			if (yych <= 'q') goto yy240;
			goto yy237;
		} else {
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy384:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy240;
			if (yych <= '-') goto yy386;
			if (yych <= '.') goto yy355;
			goto yy240;
		} else {
			if (yych <= '0') goto yy356;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy245;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy385:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy240;
			if (yych <= '-') goto yy386;
			if (yych <= '.') goto yy324;
			goto yy240;
		} else {
			if (yych <= '0') goto yy325;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy288;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy386:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy388;
	if (yych <= '9') goto yy389;
yy388:
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy389:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy388;
	if (yych >= ':') goto yy388;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy388;
	if (yych >= ':') goto yy388;
	yych = *++YYCURSOR;
	goto yy388;
yy392:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy240;
			if (yych <= '-') goto yy386;
			if (yych <= '.') goto yy324;
			goto yy240;
		} else {
			if (yych <= '0') goto yy356;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy288;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy393:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy240;
			if (yych <= '-') goto yy386;
			if (yych <= '.') goto yy324;
			goto yy240;
		} else {
			if (yych <= '0') goto yy356;
			if (yych <= '1') goto yy326;
			if (yych <= '2') goto yy327;
			goto yy321;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy288;
			if (yych == 'n') goto yy236;
			goto yy240;
		} else {
			if (yych <= 'r') goto yy237;
			if (yych <= 's') goto yy235;
			if (yych <= 't') goto yy238;
			goto yy240;
		}
	}
yy394:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy217;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'c') goto yy395;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy395:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy226;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy397;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy396:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	if (yych <= '/') goto yy220;
	if (yych <= '0') goto yy381;
	if (yych <= '2') goto yy382;
	if (yych <= '3') goto yy383;
	goto yy220;
yy397:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy227;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'm') goto yy398;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy398:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy228;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'b') goto yy399;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy399:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy229;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'e') goto yy400;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy400:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy230;
	if (yych != 'r') goto yy179;
yy401:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych <= ',') goto yy218;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy172;
			goto yy220;
		} else {
			if (yych == '_') goto yy172;
			goto yy218;
		}
	}
yy402:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	goto yy220;
yy403:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy166;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 't') goto yy404;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy404:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'O') goto yy167;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'o') goto yy405;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy405:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy168;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'b') goto yy406;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy406:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy169;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'e') goto yy407;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy407:
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy230;
		if (yych == 'r') goto yy230;
		goto yy3;
	}
yy408:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy404;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 't') goto yy409;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy409:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'O') goto yy405;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy410;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy410:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy406;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'b') goto yy411;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy411:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy407;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'e') goto yy412;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy412:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy230;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'r') goto yy401;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy413:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy166;
			goto yy421;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'g') goto yy421;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy414:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy166;
			goto yy418;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'r') goto yy418;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy415:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy166;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'o') goto yy416;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy416:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy417;
		if (yych <= 'z') goto yy167;
	}
yy417:
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy418:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'I') goto yy167;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'i') goto yy419;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy419:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy168;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'l') goto yy420;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy420:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy169;
			goto yy218;
		}
	}
yy421:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'U') goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'u') goto yy422;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy422:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 's') goto yy423;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy423:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy424;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy424:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy218;
			goto yy220;
		} else {
			if (yych == ' ') goto yy220;
			goto yy218;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy164;
			if (yych <= ',') goto yy218;
			goto yy220;
		} else {
			if (yych <= '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		}
	}
yy425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy421;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'g') goto yy432;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy426:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy418;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'r') goto yy429;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy427:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy416;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy428;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy428:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy417;
		} else {
			if (yych == '.') goto yy417;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy417;
			if (yych <= 'Z') goto yy167;
			goto yy417;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy417;
			if (yych <= 'z') goto yy175;
			goto yy417;
		}
	}
yy429:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'I') goto yy419;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'i') goto yy430;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy430:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy420;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'l') goto yy431;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy431:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy402;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy177;
				goto yy218;
			}
		}
	}
yy432:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'U') goto yy422;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy433;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy433:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy423;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 's') goto yy434;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy434:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy424;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy435;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy435:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy402;
			if (yych <= '.') goto yy220;
			goto yy172;
		} else {
			if (yych <= '9') goto yy220;
			if (yych == '_') goto yy172;
			goto yy218;
		}
	}
yy436:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'L') goto yy443;
			if (yych <= 'M') goto yy166;
			goto yy442;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy166;
			goto yy443;
		} else {
			if (yych == 'n') goto yy442;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy437:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy438;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy438:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'U') goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'u') goto yy439;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy439:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy440;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy440:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy441;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy441:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy230;
		if (yych == 'y') goto yy230;
		goto yy3;
	}
yy442:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych == 'E') goto yy444;
				goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'e') goto yy444;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy443:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'Y') goto yy167;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'y') goto yy444;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy444:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy168;
			goto yy218;
		}
	}
yy445:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'L') goto yy443;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy442;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy452;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy451;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy446:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy438;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy447;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy447:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'U') goto yy439;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy448;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy448:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy440;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy449;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy449:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy441;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy450;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy450:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy230;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy401;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy451:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy444;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy453;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy452:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'Y') goto yy444;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'y') goto yy453;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy453:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy402;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy176;
				goto yy218;
			}
		}
	}
yy454:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy455:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy456:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy167;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy167;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy459:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy460:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy455;
				goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy461:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy481;
				} else {
					if (yych <= ':') goto yy187;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy3;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy462:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy3;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy481;
					goto yy466;
				} else {
					if (yych <= '9') goto yy467;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy463:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy466;
				} else {
					if (yych <= '9') goto yy467;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy464:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy464;
		goto yy56;
	} else {
		if (yych <= '-') goto yy464;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy466:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy480;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy467:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy469:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy470:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy471;
	if (yych <= '1') goto yy472;
	goto yy56;
yy471:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy473;
	goto yy56;
yy472:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy473:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy475;
	if (yych <= '2') goto yy476;
	if (yych <= '3') goto yy477;
	goto yy56;
yy475:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy478;
	goto yy56;
yy476:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy478;
	goto yy56;
yy477:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy478:
	++YYCURSOR;
yy479:
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy480:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy469;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy481:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy480;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy3;
					goto yy470;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy484:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy486;
	if (yych <= '0') goto yy760;
	if (yych <= '1') goto yy761;
	if (yych <= '9') goto yy762;
	goto yy486;
yy485:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy486:
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy485;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy485;
					if (yych <= ',') goto yy56;
					goto yy601;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy504;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy490;
					if (yych == 'F') goto yy491;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy499;
					goto yy503;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy487;
					if (yych <= 'N') goto yy506;
					goto yy505;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy508;
					if (yych <= 'R') goto yy56;
					goto yy488;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy501;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy502;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy504;
					if (yych == 'd') goto yy490;
					goto yy56;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy491;
					if (yych <= 'g') goto yy56;
					goto yy65;
				} else {
					if (yych == 'j') goto yy503;
					if (yych <= 'l') goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy506;
					if (yych <= 'o') goto yy505;
					goto yy508;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy488;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy487:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy616;
			if (yych <= 'H') goto yy56;
			goto yy138;
		} else {
			if (yych == 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy616;
			if (yych <= 'h') goto yy56;
			goto yy138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy137;
			} else {
				if (yych == 's') goto yy139;
				goto yy56;
			}
		}
	}
yy488:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1073;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1073;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy489:
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1073;
			if (yych == 'U') goto yy118;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy119;
			if (yych <= 'd') goto yy56;
			goto yy1073;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy753;
			if (yych <= 'u') goto yy118;
			goto yy56;
		}
	}
yy490:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy115;
		if (yych <= 'D') goto yy56;
		goto yy603;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy115;
		} else {
			if (yych == 'e') goto yy603;
			goto yy56;
		}
	}
yy491:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy619;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy100;
			if (yych <= 'Q') goto yy56;
			goto yy99;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy619;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy100;
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy492:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy71;
		if (yych <= 'T') goto yy56;
		goto yy72;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1072;
		} else {
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy493:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy766;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy765;
	goto yy60;
yy494:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy554;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy753;
		if (yych == 'o') goto yy554;
		goto yy56;
	}
yy495:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy753;
	goto yy56;
yy496:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy690;
	case '3':	goto yy692;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy693;
	case 'A':
	case 'a':	goto yy697;
	case 'D':
	case 'd':	goto yy701;
	case 'F':
	case 'f':	goto yy695;
	case 'J':
	case 'j':	goto yy694;
	case 'M':
	case 'm':	goto yy696;
	case 'N':
	case 'n':	goto yy700;
	case 'O':
	case 'o':	goto yy699;
	case 'S':
	case 's':	goto yy698;
	default:	goto yy56;
	}
yy497:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy640;
	case '1':	goto yy641;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy642;
	case 'A':
	case 'a':	goto yy646;
	case 'D':
	case 'd':	goto yy650;
	case 'F':
	case 'f':	goto yy644;
	case 'J':
	case 'j':	goto yy643;
	case 'M':
	case 'm':	goto yy645;
	case 'N':
	case 'n':	goto yy649;
	case 'O':
	case 'o':	goto yy648;
	case 'S':
	case 's':	goto yy647;
	default:	goto yy602;
	}
yy498:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy602;
		if (yych <= '0') goto yy592;
		goto yy593;
	} else {
		if (yych <= '5') goto yy594;
		if (yych <= '9') goto yy595;
		goto yy602;
	}
yy499:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '.') goto yy556;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy558;
			if (yych == 'I') goto yy591;
		} else {
			if (yych == 'W') goto yy500;
			if (yych <= 'X') goto yy564;
		}
	}
yy500:
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy501:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy556;
			if (yych <= '/') goto yy500;
			goto yy558;
		} else {
			if (yych == 'I') goto yy589;
			goto yy500;
		}
	}
yy502:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy556;
			if (yych <= '/') goto yy500;
			goto yy558;
		} else {
			if (yych == 'I') goto yy588;
			goto yy500;
		}
	}
yy503:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy581;
		if (yych <= 'T') goto yy56;
		goto yy580;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy581;
		} else {
			if (yych == 'u') goto yy580;
			goto yy56;
		}
	}
yy504:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy509;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy510;
			if (yych == 'P') goto yy574;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy573;
			if (yych == 'm') goto yy510;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy574;
			if (yych == 'u') goto yy573;
			goto yy56;
		}
	}
yy505:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy568;
	if (yych == 'c') goto yy568;
	goto yy56;
yy506:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy554;
	if (yych == 'o') goto yy554;
	goto yy56;
yy507:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy514;
	if (yych <= '9') goto yy516;
	goto yy56;
yy508:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy510;
		if (yych == 'm') goto yy510;
		goto yy56;
	}
yy509:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy510;
	if (yych != 'm') goto yy56;
yy510:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy512;
		if (yych == '\t') goto yy512;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy512;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy512;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy512:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy514:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy517;
	} else {
		if (yych <= '9') goto yy531;
		if (yych <= ':') goto yy517;
	}
yy515:
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy516:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy517;
	if (yych != ':') goto yy515;
yy517:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy518;
	if (yych <= '6') goto yy519;
	if (yych <= '9') goto yy520;
	goto yy56;
yy518:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy524;
	goto yy515;
yy519:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych == '0') goto yy524;
	goto yy515;
yy520:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy515;
yy521:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy522:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy522;
	goto yy515;
yy524:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy515;
		} else {
			if (yych <= ' ') goto yy525;
			if (yych == '.') goto yy521;
			goto yy515;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy527;
			if (yych == 'P') goto yy527;
			goto yy515;
		} else {
			if (yych <= 'a') goto yy527;
			if (yych == 'p') goto yy527;
			goto yy515;
		}
	}
yy525:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy525;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy525;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy527;
			if (yych != 'p') goto yy56;
		}
	}
yy527:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy529;
		if (yych == 'm') goto yy529;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy529;
	if (yych != 'm') goto yy56;
yy529:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy512;
		if (yych == '\t') goto yy512;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy512;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy512;
		if (yych <= 0x08) goto yy56;
		goto yy512;
	} else {
		if (yych == ' ') goto yy512;
		goto yy56;
	}
yy531:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy532;
			if (yych <= 0x1F) goto yy515;
		} else {
			if (yych == '.') goto yy517;
			if (yych <= '9') goto yy515;
			goto yy535;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy534;
			if (yych <= 'O') goto yy515;
			goto yy534;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy515;
				goto yy534;
			} else {
				if (yych == 'p') goto yy534;
				goto yy515;
			}
		}
	}
yy532:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy532;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy532;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy534;
			if (yych != 'p') goto yy56;
		}
	}
yy534:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy551;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy552;
		if (yych == 'm') goto yy552;
		goto yy56;
	}
yy535:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy536;
	if (yych <= '6') goto yy537;
	if (yych <= '9') goto yy520;
	goto yy56;
yy536:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy538;
	goto yy515;
yy537:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych != '0') goto yy515;
yy538:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy525;
			if (yych <= 0x1F) goto yy515;
			goto yy525;
		} else {
			if (yych == '.') goto yy539;
			if (yych <= '9') goto yy515;
			goto yy540;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy527;
			if (yych <= 'O') goto yy515;
			goto yy527;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy515;
				goto yy527;
			} else {
				if (yych == 'p') goto yy527;
				goto yy515;
			}
		}
	}
yy539:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy549;
	goto yy56;
yy540:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy541:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy541;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy543;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy543:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy545;
		if (yych == 'm') goto yy545;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy545;
	if (yych != 'm') goto yy56;
yy545:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy547;
		if (yych == '\t') goto yy547;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy547;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy547;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy547:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy549:
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy515;
			goto yy549;
		} else {
			if (yych == 'A') goto yy543;
			goto yy515;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy543;
			if (yych <= '`') goto yy515;
			goto yy543;
		} else {
			if (yych == 'p') goto yy543;
			goto yy515;
		}
	}
yy551:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy552;
	if (yych != 'm') goto yy56;
yy552:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy512;
		if (yych == '\t') goto yy512;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy512;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy512;
		if (yych <= 0x08) goto yy56;
		goto yy512;
	} else {
		if (yych == ' ') goto yy512;
		goto yy56;
	}
yy554:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy555;
	if (yych != 'v') goto yy56;
yy555:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy560;
			if (yych == 'e') goto yy560;
			goto yy500;
		}
	}
yy556:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy557:
	if (yych <= ' ') {
		if (yych == '\t') goto yy556;
		if (yych <= 0x1F) goto yy56;
		goto yy556;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy556;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy558:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy559;
	if (yych <= '9') goto yy565;
yy559:
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy560:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy561;
	if (yych != 'm') goto yy56;
yy561:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy562;
	if (yych != 'b') goto yy56;
yy562:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy563;
	if (yych != 'e') goto yy56;
yy563:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy564;
	if (yych != 'r') goto yy56;
yy564:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy556;
		if (yych <= 0x1F) goto yy500;
		goto yy556;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy500;
			goto yy556;
		} else {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		}
	}
yy565:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy559;
	if (yych >= ':') goto yy559;
yy566:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy559;
	if (yych >= ':') goto yy559;
	yych = *++YYCURSOR;
	goto yy559;
yy568:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy569;
	if (yych != 't') goto yy56;
yy569:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'O') goto yy570;
			if (yych != 'o') goto yy500;
		}
	}
yy570:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy571;
	if (yych != 'b') goto yy56;
yy571:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy572;
	if (yych != 'e') goto yy56;
yy572:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy564;
	if (yych == 'r') goto yy564;
	goto yy56;
yy573:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy577;
	if (yych == 'g') goto yy577;
	goto yy56;
yy574:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy575;
	if (yych != 'r') goto yy56;
yy575:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'I') goto yy576;
			if (yych != 'i') goto yy500;
		}
	}
yy576:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy564;
	if (yych == 'l') goto yy564;
	goto yy56;
yy577:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'U') goto yy578;
			if (yych != 'u') goto yy500;
		}
	}
yy578:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy579;
	if (yych != 's') goto yy56;
yy579:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy564;
	if (yych == 't') goto yy564;
	goto yy56;
yy580:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy587;
		if (yych <= 'M') goto yy56;
		goto yy586;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy587;
		} else {
			if (yych == 'n') goto yy586;
			goto yy56;
		}
	}
yy581:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy582;
	if (yych != 'n') goto yy56;
yy582:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'U') goto yy583;
			if (yych != 'u') goto yy500;
		}
	}
yy583:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy584;
	if (yych != 'a') goto yy56;
yy584:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy585;
	if (yych != 'r') goto yy56;
yy585:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy564;
	if (yych == 'y') goto yy564;
	goto yy56;
yy586:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy564;
			if (yych == 'e') goto yy564;
			goto yy500;
		}
	}
yy587:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'Y') goto yy564;
			if (yych == 'y') goto yy564;
			goto yy500;
		}
	}
yy588:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy556;
			if (yych <= '/') goto yy500;
			goto yy558;
		} else {
			if (yych == 'I') goto yy564;
			goto yy500;
		}
	}
yy589:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy556;
			if (yych <= '/') goto yy500;
			goto yy558;
		} else {
			if (yych != 'I') goto yy500;
		}
	}
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy556;
			if (yych <= '/') goto yy500;
			goto yy558;
		} else {
			if (yych == 'I') goto yy564;
			goto yy500;
		}
	}
yy591:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy556;
			if (yych <= '/') goto yy500;
			goto yy558;
		} else {
			if (yych == 'I') goto yy564;
			goto yy500;
		}
	}
yy592:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		goto yy625;
	} else {
		if (yych <= '/') goto yy515;
		if (yych <= '9') goto yy639;
		if (yych <= ':') goto yy517;
		goto yy515;
	}
yy593:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		if (yych <= '.') goto yy625;
		goto yy515;
	} else {
		if (yych <= '2') goto yy639;
		if (yych <= '9') goto yy638;
		if (yych <= ':') goto yy517;
		goto yy515;
	}
yy594:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		goto yy625;
	} else {
		if (yych <= '/') goto yy515;
		if (yych <= '9') goto yy638;
		if (yych <= ':') goto yy517;
		goto yy515;
	}
yy595:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		goto yy625;
	} else {
		if (yych == ':') goto yy517;
		goto yy515;
	}
yy596:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy619;
	if (yych == 'e') goto yy619;
	goto yy56;
yy597:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy616;
	if (yych == 'a') goto yy616;
	goto yy56;
yy598:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy574;
		if (yych <= 'T') goto yy56;
		goto yy573;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy574;
		} else {
			if (yych == 'u') goto yy573;
			goto yy56;
		}
	}
yy599:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy609;
	if (yych == 'e') goto yy609;
	goto yy56;
yy600:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy603;
	if (yych == 'e') goto yy603;
	goto yy56;
yy601:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy602:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy601;
	case 'A':
	case 'a':	goto yy598;
	case 'D':
	case 'd':	goto yy600;
	case 'F':
	case 'f':	goto yy596;
	case 'I':	goto yy499;
	case 'J':
	case 'j':	goto yy503;
	case 'M':
	case 'm':	goto yy597;
	case 'N':
	case 'n':	goto yy506;
	case 'O':
	case 'o':	goto yy505;
	case 'S':
	case 's':	goto yy599;
	case 'V':	goto yy501;
	case 'X':	goto yy502;
	default:	goto yy56;
	}
yy603:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy604;
	if (yych != 'c') goto yy56;
yy604:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy605;
			if (yych != 'e') goto yy500;
		}
	}
yy605:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy606;
	if (yych != 'm') goto yy56;
yy606:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy607;
	if (yych != 'b') goto yy56;
yy607:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy608;
	if (yych != 'e') goto yy56;
yy608:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy564;
	if (yych == 'r') goto yy564;
	goto yy56;
yy609:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy610;
	if (yych != 'p') goto yy56;
yy610:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'T') goto yy611;
			if (yych != 't') goto yy500;
		}
	}
yy611:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy612;
			if (yych != 'e') goto yy500;
		}
	}
yy612:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy613;
	if (yych != 'm') goto yy56;
yy613:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy614;
	if (yych != 'b') goto yy56;
yy614:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy615;
	if (yych != 'e') goto yy56;
yy615:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy564;
	if (yych == 'r') goto yy564;
	goto yy56;
yy616:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy617;
		if (yych <= 'X') goto yy56;
		goto yy564;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy564;
			goto yy56;
		}
	}
yy617:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'C') goto yy618;
			if (yych != 'c') goto yy500;
		}
	}
yy618:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy564;
	if (yych == 'h') goto yy564;
	goto yy56;
yy619:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy620;
	if (yych != 'b') goto yy56;
yy620:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			goto yy556;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'R') goto yy621;
			if (yych != 'r') goto yy500;
		}
	}
yy621:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy622;
	if (yych != 'u') goto yy56;
yy622:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy623;
	if (yych != 'a') goto yy56;
yy623:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy624;
	if (yych != 'r') goto yy56;
yy624:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy564;
	if (yych == 'y') goto yy564;
	goto yy56;
yy625:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy632;
	if (yych <= '6') goto yy633;
	if (yych <= '9') goto yy634;
	goto yy56;
yy626:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy628:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy629:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy632:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy637;
	goto yy515;
yy633:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy521;
		goto yy515;
	} else {
		if (yych <= '0') goto yy637;
		if (yych <= '9') goto yy635;
		goto yy515;
	}
yy634:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych >= ':') goto yy515;
yy635:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy636;
	if (yych <= '9') goto yy629;
yy636:
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy637:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy525;
			if (yych <= 0x1F) goto yy515;
			goto yy525;
		} else {
			if (yych == '.') goto yy521;
			if (yych <= '/') goto yy515;
			goto yy629;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy527;
			if (yych <= 'O') goto yy515;
			goto yy527;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy515;
				goto yy527;
			} else {
				if (yych == 'p') goto yy527;
				goto yy515;
			}
		}
	}
yy638:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy532;
			if (yych <= 0x1F) goto yy515;
			goto yy532;
		} else {
			if (yych == '.') goto yy517;
			if (yych <= '9') goto yy515;
			goto yy517;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy534;
			if (yych <= 'O') goto yy515;
			goto yy534;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy515;
				goto yy534;
			} else {
				if (yych == 'p') goto yy534;
				goto yy515;
			}
		}
	}
yy639:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy532;
			if (yych <= 0x1F) goto yy515;
			goto yy532;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy515;
				goto yy626;
			} else {
				if (yych <= '.') goto yy625;
				if (yych <= '9') goto yy515;
				goto yy517;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy534;
			if (yych <= 'O') goto yy515;
			goto yy534;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy515;
				goto yy534;
			} else {
				if (yych == 'p') goto yy534;
				goto yy515;
			}
		}
	}
yy640:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy679;
		goto yy626;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy642;
		goto yy56;
	}
yy641:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy679;
		goto yy626;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy642:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy679;
	if (yych <= '.') goto yy626;
	goto yy56;
yy643:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy675;
		if (yych <= 'T') goto yy56;
		goto yy674;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy675;
		} else {
			if (yych == 'u') goto yy674;
			goto yy56;
		}
	}
yy644:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy672;
	if (yych == 'e') goto yy672;
	goto yy56;
yy645:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy669;
	if (yych == 'a') goto yy669;
	goto yy56;
yy646:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy666;
		if (yych <= 'T') goto yy56;
		goto yy665;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy666;
		} else {
			if (yych == 'u') goto yy665;
			goto yy56;
		}
	}
yy647:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy662;
	if (yych == 'e') goto yy662;
	goto yy56;
yy648:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy660;
	if (yych == 'c') goto yy660;
	goto yy56;
yy649:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy658;
	if (yych == 'o') goto yy658;
	goto yy56;
yy650:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy651;
	if (yych != 'e') goto yy56;
yy651:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy652;
	if (yych != 'c') goto yy56;
yy652:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych >= '.') goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy605;
			if (yych == 'e') goto yy605;
			goto yy500;
		}
	}
yy653:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy557;
	if (yych <= '0') goto yy654;
	if (yych <= '2') goto yy655;
	if (yych <= '3') goto yy656;
	goto yy557;
yy654:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy559;
	if (yych <= '9') goto yy657;
	goto yy559;
yy655:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy559;
	if (yych <= '9') goto yy657;
	goto yy559;
yy656:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy559;
	if (yych <= '1') goto yy657;
	if (yych <= '9') goto yy565;
	goto yy559;
yy657:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy559;
	if (yych <= '9') goto yy566;
	goto yy559;
yy658:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy659;
	if (yych != 'v') goto yy56;
yy659:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy560;
			if (yych == 'e') goto yy560;
			goto yy500;
		}
	}
yy660:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy661;
	if (yych != 't') goto yy56;
yy661:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'O') goto yy570;
			if (yych == 'o') goto yy570;
			goto yy500;
		}
	}
yy662:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy663;
	if (yych != 'p') goto yy56;
yy663:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'T') goto yy664;
			if (yych != 't') goto yy500;
		}
	}
yy664:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy612;
			if (yych == 'e') goto yy612;
			goto yy500;
		}
	}
yy665:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy668;
	if (yych == 'g') goto yy668;
	goto yy56;
yy666:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy667;
	if (yych != 'r') goto yy56;
yy667:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'I') goto yy576;
			if (yych == 'i') goto yy576;
			goto yy500;
		}
	}
yy668:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'U') goto yy578;
			if (yych == 'u') goto yy578;
			goto yy500;
		}
	}
yy669:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy670;
		if (yych <= 'X') goto yy56;
		goto yy671;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy671;
			goto yy56;
		}
	}
yy670:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'C') goto yy618;
			if (yych == 'c') goto yy618;
			goto yy500;
		}
	}
yy671:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy500;
			goto yy556;
		} else {
			if (yych == ' ') goto yy556;
			goto yy500;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy653;
			goto yy556;
		} else {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		}
	}
yy672:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy673;
	if (yych != 'b') goto yy56;
yy673:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'R') goto yy621;
			if (yych == 'r') goto yy621;
			goto yy500;
		}
	}
yy674:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy678;
		if (yych <= 'M') goto yy56;
		goto yy677;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy678;
		} else {
			if (yych == 'n') goto yy677;
			goto yy56;
		}
	}
yy675:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy676;
	if (yych != 'n') goto yy56;
yy676:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'U') goto yy583;
			if (yych == 'u') goto yy583;
			goto yy500;
		}
	}
yy677:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'E') goto yy564;
			if (yych == 'e') goto yy564;
			goto yy500;
		}
	}
yy678:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy556;
			goto yy500;
		} else {
			if (yych <= ' ') goto yy556;
			if (yych <= ',') goto yy500;
			if (yych <= '-') goto yy653;
			goto yy556;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy500;
			if (yych <= '9') goto yy558;
			goto yy500;
		} else {
			if (yych <= 'Y') goto yy564;
			if (yych == 'y') goto yy564;
			goto yy500;
		}
	}
yy679:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy680;
	if (yych <= '3') goto yy682;
	if (yych <= '9') goto yy683;
	goto yy56;
yy680:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy689;
		if (yych >= 'n') goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
		}
	}
yy681:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy682:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy681;
			goto yy689;
		} else {
			if (yych <= '9') goto yy628;
			if (yych <= 'm') goto yy681;
			goto yy685;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy683:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy628;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy684:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy688;
	goto yy56;
yy685:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy688;
	goto yy56;
yy686:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy688;
	goto yy56;
yy687:
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy688:
	yych = *++YYCURSOR;
	goto yy681;
yy689:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy629;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy690:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy747;
		} else {
			if (yych <= '9') goto yy693;
			if (yych >= 'n') goto yy744;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy745;
		} else {
			if (yych <= 's') goto yy743;
			if (yych <= 't') goto yy746;
		}
	}
yy691:
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy692:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy691;
			goto yy747;
		} else {
			if (yych <= '1') goto yy693;
			if (yych <= 'm') goto yy691;
			goto yy744;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy691;
			goto yy745;
		} else {
			if (yych <= 's') goto yy743;
			if (yych <= 't') goto yy746;
			goto yy691;
		}
	}
yy693:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy747;
		if (yych <= 'm') goto yy691;
		goto yy744;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy691;
			goto yy745;
		} else {
			if (yych <= 's') goto yy743;
			if (yych <= 't') goto yy746;
			goto yy691;
		}
	}
yy694:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy742;
		if (yych <= 'T') goto yy56;
		goto yy741;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy742;
		} else {
			if (yych == 'u') goto yy741;
			goto yy56;
		}
	}
yy695:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy740;
	if (yych == 'e') goto yy740;
	goto yy56;
yy696:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy739;
	if (yych == 'a') goto yy739;
	goto yy56;
yy697:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy738;
		if (yych <= 'T') goto yy56;
		goto yy737;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy738;
		} else {
			if (yych == 'u') goto yy737;
			goto yy56;
		}
	}
yy698:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy735;
	if (yych == 'e') goto yy735;
	goto yy56;
yy699:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy734;
	if (yych == 'c') goto yy734;
	goto yy56;
yy700:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy733;
	if (yych == 'o') goto yy733;
	goto yy56;
yy701:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy702;
	if (yych != 'e') goto yy56;
yy702:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy703;
	if (yych != 'c') goto yy56;
yy703:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy704:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy710;
	if (yych <= '2') goto yy711;
	goto yy56;
yy710:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy712;
	goto yy56;
yy711:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy712:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy717;
	if (yych <= '6') goto yy718;
	goto yy56;
yy717:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy719;
	goto yy56;
yy718:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy719:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy720;
	if (yych != ' ') goto yy56;
yy720:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy720;
		} else {
			if (yych == ' ') goto yy720;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy723;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy731;
	goto yy56;
yy723:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy724;
	if (yych <= '2') goto yy726;
	if (yych <= '9') goto yy727;
	goto yy56;
yy724:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy725;
	if (yych <= '9') goto yy727;
	if (yych <= ':') goto yy728;
yy725:
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy726:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy725;
		if (yych >= '5') goto yy729;
	} else {
		if (yych <= '9') goto yy730;
		if (yych <= ':') goto yy728;
		goto yy725;
	}
yy727:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy725;
	if (yych <= '5') goto yy729;
	if (yych <= '9') goto yy730;
	if (yych >= ';') goto yy725;
yy728:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy725;
	if (yych <= '5') goto yy729;
	if (yych <= '9') goto yy730;
	goto yy725;
yy729:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy725;
	if (yych >= ':') goto yy725;
yy730:
	yych = *++YYCURSOR;
	goto yy725;
yy731:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy723;
	if (yych == '-') goto yy723;
	goto yy56;
yy733:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy703;
	if (yych == 'v') goto yy703;
	goto yy56;
yy734:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy703;
	if (yych == 't') goto yy703;
	goto yy56;
yy735:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy736;
	if (yych != 'p') goto yy56;
yy736:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy704;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy703;
		if (yych == 't') goto yy703;
		goto yy56;
	}
yy737:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy703;
	if (yych == 'g') goto yy703;
	goto yy56;
yy738:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy703;
	if (yych == 'r') goto yy703;
	goto yy56;
yy739:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy703;
		if (yych <= 'X') goto yy56;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy703;
		} else {
			if (yych == 'y') goto yy703;
			goto yy56;
		}
	}
yy740:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy703;
	if (yych == 'b') goto yy703;
	goto yy56;
yy741:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy703;
		if (yych <= 'M') goto yy56;
		goto yy703;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy703;
		} else {
			if (yych == 'n') goto yy703;
			goto yy56;
		}
	}
yy742:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy703;
	if (yych == 'n') goto yy703;
	goto yy56;
yy743:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy752;
	goto yy56;
yy744:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy752;
	goto yy56;
yy745:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy752;
	goto yy56;
yy746:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy752;
	goto yy56;
yy747:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy691;
	if (yych >= ':') goto yy691;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy691;
	if (yych >= ':') goto yy691;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy691;
	if (yych >= ':') goto yy691;
	yych = *++YYCURSOR;
	goto yy691;
yy752:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy747;
	goto yy691;
yy753:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy755;
		goto yy602;
	} else {
		if (yych <= '-') goto yy756;
		if (yych <= '.') goto yy755;
		if (yych >= '0') goto yy602;
	}
yy754:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy697;
	case 'D':
	case 'd':	goto yy701;
	case 'F':
	case 'f':	goto yy695;
	case 'J':
	case 'j':	goto yy694;
	case 'M':
	case 'm':	goto yy696;
	case 'N':
	case 'n':	goto yy700;
	case 'O':
	case 'o':	goto yy699;
	case 'S':
	case 's':	goto yy698;
	default:	goto yy56;
	}
yy755:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy602;
	if (yych <= '0') goto yy760;
	if (yych <= '1') goto yy761;
	if (yych <= '9') goto yy762;
	goto yy602;
yy756:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy602;
	if (yych <= '0') goto yy757;
	if (yych <= '1') goto yy758;
	if (yych <= '9') goto yy759;
	goto yy602;
yy757:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy626;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy759;
	goto yy56;
yy758:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy626;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy759:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy626;
	goto yy56;
yy760:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy626;
		goto yy763;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy762;
		goto yy56;
	}
yy761:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy626;
		goto yy763;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy762:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy626;
	if (yych >= '/') goto yy56;
yy763:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy635;
	goto yy56;
yy765:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy809;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy807;
	goto yy60;
yy766:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy775;
	case '1':	goto yy776;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy777;
	case 'A':
	case 'a':	goto yy770;
	case 'D':
	case 'd':	goto yy774;
	case 'F':
	case 'f':	goto yy768;
	case 'J':
	case 'j':	goto yy767;
	case 'M':
	case 'm':	goto yy769;
	case 'N':
	case 'n':	goto yy773;
	case 'O':
	case 'o':	goto yy772;
	case 'S':
	case 's':	goto yy771;
	default:	goto yy56;
	}
yy767:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy806;
		if (yych <= 'T') goto yy56;
		goto yy805;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy806;
		} else {
			if (yych == 'u') goto yy805;
			goto yy56;
		}
	}
yy768:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy804;
	if (yych == 'e') goto yy804;
	goto yy56;
yy769:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy803;
	if (yych == 'a') goto yy803;
	goto yy56;
yy770:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy802;
		if (yych <= 'T') goto yy56;
		goto yy801;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy802;
		} else {
			if (yych == 'u') goto yy801;
			goto yy56;
		}
	}
yy771:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy799;
	if (yych == 'e') goto yy799;
	goto yy56;
yy772:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy798;
	if (yych == 'c') goto yy798;
	goto yy56;
yy773:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy797;
	if (yych == 'o') goto yy797;
	goto yy56;
yy774:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy789;
	if (yych == 'e') goto yy789;
	goto yy56;
yy775:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy778;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy782;
	goto yy56;
yy776:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy778;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy782;
	goto yy56;
yy777:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy778:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy779;
	if (yych <= '3') goto yy780;
	if (yych <= '9') goto yy781;
	goto yy56;
yy779:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy781;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy780:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '1') goto yy781;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy781:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy685;
		goto yy681;
	} else {
		if (yych <= 'r') goto yy686;
		if (yych <= 's') goto yy684;
		if (yych <= 't') goto yy687;
		goto yy681;
	}
yy782:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy785;
	} else {
		if (yych <= '3') goto yy786;
		if (yych <= '9') goto yy781;
		goto yy56;
	}
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy787;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy785:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy787;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy786:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '1') goto yy787;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy787:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy685;
	} else {
		if (yych <= 'r') goto yy686;
		if (yych <= 's') goto yy684;
		if (yych <= 't') goto yy687;
	}
yy788:
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy789:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy790;
	if (yych != 'c') goto yy56;
yy790:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy791:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy792;
	if (yych <= '2') goto yy793;
	if (yych <= '3') goto yy794;
	goto yy56;
yy792:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy795;
	goto yy56;
yy793:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy795;
	goto yy56;
yy794:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy795:
	++YYCURSOR;
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy797:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy790;
	if (yych == 'v') goto yy790;
	goto yy56;
yy798:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy790;
	if (yych == 't') goto yy790;
	goto yy56;
yy799:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy800;
	if (yych != 'p') goto yy56;
yy800:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy791;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy790;
		if (yych == 't') goto yy790;
		goto yy56;
	}
yy801:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy790;
	if (yych == 'g') goto yy790;
	goto yy56;
yy802:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy790;
	if (yych == 'r') goto yy790;
	goto yy56;
yy803:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy790;
		if (yych <= 'X') goto yy56;
		goto yy790;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy790;
		} else {
			if (yych == 'y') goto yy790;
			goto yy56;
		}
	}
yy804:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy790;
	if (yych == 'b') goto yy790;
	goto yy56;
yy805:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy790;
		if (yych <= 'M') goto yy56;
		goto yy790;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy790;
		} else {
			if (yych == 'n') goto yy790;
			goto yy56;
		}
	}
yy806:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy790;
	if (yych == 'n') goto yy790;
	goto yy56;
yy807:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy815;
				} else {
					if (yych <= ' ') goto yy815;
					if (yych >= '-') goto yy812;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy816;
					if (yych <= '/') goto yy813;
					goto yy829;
				} else {
					if (yych <= '1') goto yy830;
					if (yych <= '2') goto yy832;
					goto yy833;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy54;
					if (yych <= ':') goto yy831;
				} else {
					if (yych <= 'A') goto yy815;
					if (yych >= 'D') goto yy815;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy815;
				} else {
					if (yych <= 'J') goto yy815;
					if (yych >= 'M') goto yy815;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy808;
					if (yych <= 'V') goto yy815;
					goto yy834;
				} else {
					if (yych <= 'Y') goto yy815;
					if (yych >= 'a') goto yy815;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy815;
				} else {
					if (yych != 'g') goto yy815;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy815;
				} else {
					if (yych <= 'o') goto yy815;
					if (yych >= 's') goto yy815;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy815;
				} else {
					if (yych <= 'y') goto yy815;
					if (yych == 0xC2) goto yy815;
				}
			}
		}
	}
yy808:
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy809:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy810;
	case '1':	goto yy811;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy777;
	case 'A':
	case 'a':	goto yy770;
	case 'D':
	case 'd':	goto yy774;
	case 'F':
	case 'f':	goto yy768;
	case 'J':
	case 'j':	goto yy767;
	case 'M':
	case 'm':	goto yy769;
	case 'N':
	case 'n':	goto yy773;
	case 'O':
	case 'o':	goto yy772;
	case 'S':
	case 's':	goto yy771;
	default:	goto yy56;
	}
yy810:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy778;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy777;
	goto yy56;
yy811:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy778;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy777;
	goto yy56;
yy812:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy997;
	case '1':	goto yy999;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1000;
	case 'A':
	case 'a':	goto yy991;
	case 'D':
	case 'd':	goto yy995;
	case 'F':
	case 'f':	goto yy989;
	case 'J':
	case 'j':	goto yy988;
	case 'M':
	case 'm':	goto yy990;
	case 'N':
	case 'n':	goto yy994;
	case 'O':
	case 'o':	goto yy993;
	case 'S':
	case 's':	goto yy992;
	case 'W':	goto yy996;
	default:	goto yy963;
	}
yy813:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy971;
	if (yych <= '1') goto yy972;
	if (yych <= '9') goto yy973;
	goto yy56;
yy814:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy815:
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy814;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy814;
					if (yych <= ',') goto yy56;
					goto yy962;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy824;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy828;
					if (yych == 'F') goto yy822;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy817;
					goto yy821;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy823;
					goto yy827;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy826;
					if (yych <= 'R') goto yy56;
					goto yy825;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy819;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy820;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy824;
					if (yych <= 'c') goto yy56;
					goto yy828;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy822;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy65;
					if (yych == 'j') goto yy821;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy823;
					if (yych <= 'n') goto yy827;
					goto yy826;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy825;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy816:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy963;
	if (yych <= '0') goto yy955;
	if (yych <= '2') goto yy956;
	if (yych <= '3') goto yy957;
	goto yy963;
yy817:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy954;
	} else {
		if (yych == 'W') goto yy818;
		if (yych <= 'X') goto yy908;
	}
yy818:
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy819:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy952;
	goto yy818;
yy820:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy951;
	goto yy818;
yy821:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy944;
		if (yych <= 'T') goto yy56;
		goto yy943;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy944;
		} else {
			if (yych == 'u') goto yy943;
			goto yy56;
		}
	}
yy822:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy937;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy100;
			if (yych <= 'Q') goto yy56;
			goto yy99;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy937;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy100;
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy823:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy934;
			if (yych <= 'H') goto yy56;
			goto yy138;
		} else {
			if (yych == 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy934;
			if (yych <= 'h') goto yy56;
			goto yy138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy137;
			} else {
				if (yych == 's') goto yy139;
				goto yy56;
			}
		}
	}
yy824:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy928;
		if (yych <= 'T') goto yy56;
		goto yy927;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy928;
		} else {
			if (yych == 'u') goto yy927;
			goto yy56;
		}
	}
yy825:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy920;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy920;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy826:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy915;
	if (yych == 'c') goto yy915;
	goto yy56;
yy827:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy909;
	if (yych == 'o') goto yy909;
	goto yy56;
yy828:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy115;
		if (yych <= 'D') goto yy56;
		goto yy902;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy115;
		} else {
			if (yych == 'e') goto yy902;
			goto yy56;
		}
	}
yy829:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy899;
	if (yych <= '9') goto yy900;
	goto yy60;
yy830:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy868;
	if (yych <= '9') goto yy847;
	goto yy60;
yy831:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy848;
	if (yych <= '1') goto yy849;
	goto yy56;
yy832:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy847;
	goto yy60;
yy833:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy843;
	if (yych <= '6') goto yy844;
	if (yych <= '9') goto yy54;
	goto yy60;
yy834:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy835;
		if (yych <= '4') goto yy836;
		goto yy837;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy84;
		} else {
			if (yych == 'e') goto yy84;
			goto yy56;
		}
	}
yy835:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy838;
	goto yy56;
yy836:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy838;
	goto yy56;
yy837:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy838:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy840;
	if (yych <= '/') goto yy839;
	if (yych <= '7') goto yy841;
yy839:
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy840:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy841:
	++YYCURSOR;
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy843:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy845;
	goto yy60;
yy844:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy845;
	if (yych <= '9') goto yy54;
	goto yy60;
yy845:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy60;
				} else {
					if (yych == 'W') goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy60;
				if (yych == 'd') goto yy60;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy60;
				} else {
					if (yych <= 'h') goto yy60;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy846;
				if (yych != 'v') goto yy60;
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
				}
			}
		}
	}
yy846:
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy847:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy845;
	goto yy60;
yy848:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy850;
	goto yy56;
yy849:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy850:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy852;
	if (yych <= '2') goto yy853;
	if (yych <= '3') goto yy854;
	goto yy56;
yy852:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy855;
	goto yy56;
yy853:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy855;
	goto yy56;
yy854:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy855:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy857;
	if (yych <= '2') goto yy858;
	goto yy56;
yy857:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy859;
	goto yy56;
yy858:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy859:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy864;
	if (yych <= '6') goto yy865;
	goto yy56;
yy864:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy866;
	goto yy56;
yy865:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy866:
	++YYCURSOR;
yy867:
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy868:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy870;
	} else {
		if (yych <= '3') goto yy871;
		if (yych <= '9') goto yy845;
		goto yy60;
	}
yy869:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy846;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy846;
					goto yy872;
				} else {
					if (yych == 'D') goto yy60;
					goto yy846;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy846;
				if (yych <= 'H') goto yy60;
				goto yy846;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy846;
				} else {
					if (yych == 'V') goto yy846;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy846;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy846;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy846;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy846;
				} else {
					if (yych == 'v') goto yy846;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy846;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy846;
				}
			}
		}
	}
yy870:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy846;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy846;
					goto yy872;
				} else {
					if (yych == 'D') goto yy60;
					goto yy846;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy846;
				if (yych <= 'H') goto yy60;
				goto yy846;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy846;
				} else {
					if (yych == 'V') goto yy846;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy846;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy846;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy846;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy846;
				} else {
					if (yych == 'v') goto yy846;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy846;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy846;
				}
			}
		}
	}
yy871:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy846;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy846;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy846;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy846;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy846;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy846;
				} else {
					if (yych == 'V') goto yy846;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy846;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy846;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy846;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy846;
				} else {
					if (yych == 'v') goto yy846;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy846;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy846;
				}
			}
		}
	}
yy872:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy66;
				} else {
					if (yych == 'F') goto yy67;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych >= 'S') goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy874;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych >= 'f') goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy65;
				} else {
					if (yych == 'm') goto yy61;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy875;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych >= 'w') goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
				}
			}
		}
	}
yy873:
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy874:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy889;
			goto yy890;
		} else {
			if (yych <= '9') goto yy891;
			if (yych <= 'G') goto yy56;
			goto yy71;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy72;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy71;
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy875:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy877;
		} else {
			if (yych <= '9') goto yy878;
			if (yych <= 'G') goto yy56;
			goto yy71;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy72;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy71;
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy883;
	if (yych <= '9') goto yy878;
	goto yy56;
yy877:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy883;
	if (yych <= '5') goto yy879;
	goto yy56;
yy878:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy879:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy880:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy881;
	if (yych <= '6') goto yy882;
	goto yy56;
yy881:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy866;
	goto yy56;
yy882:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy866;
	goto yy56;
yy883:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy884;
	if (yych <= '9') goto yy880;
	goto yy56;
yy884:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy885;
	if (yych <= '6') goto yy886;
	if (yych <= '9') goto yy880;
	goto yy56;
yy885:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy887;
	if (yych <= '6') goto yy888;
	if (yych <= '9') goto yy866;
	goto yy56;
yy886:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy887;
	if (yych <= '5') goto yy881;
	if (yych <= '6') goto yy882;
	goto yy56;
yy887:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '9') goto yy866;
	goto yy867;
yy888:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy866;
	goto yy867;
yy889:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy898;
	if (yych <= '9') goto yy891;
	if (yych <= ':') goto yy892;
	goto yy56;
yy890:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy898;
		goto yy879;
	} else {
		if (yych == ':') goto yy892;
		goto yy56;
	}
yy891:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy879;
	if (yych != ':') goto yy56;
yy892:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy896;
	if (yych <= '6') goto yy897;
	goto yy56;
yy896:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy866;
	goto yy56;
yy897:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy866;
	goto yy56;
yy898:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy884;
	if (yych <= '9') goto yy880;
	if (yych <= ':') goto yy892;
	goto yy56;
yy899:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy901;
		goto yy870;
	} else {
		if (yych <= '3') goto yy871;
		if (yych <= '9') goto yy845;
		goto yy60;
	}
yy900:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy869;
		goto yy870;
	} else {
		if (yych <= '3') goto yy871;
		if (yych <= '9') goto yy845;
		goto yy60;
	}
yy901:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy872;
	goto yy60;
yy902:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy903;
	if (yych != 'c') goto yy56;
yy903:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy904;
	if (yych != 'e') goto yy818;
yy904:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy905;
	if (yych != 'm') goto yy56;
yy905:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy906;
	if (yych != 'b') goto yy56;
yy906:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy907;
	if (yych != 'e') goto yy56;
yy907:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy908;
	if (yych != 'r') goto yy56;
yy908:
	yych = *++YYCURSOR;
	goto yy818;
yy909:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy910;
	if (yych != 'v') goto yy56;
yy910:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy911;
	if (yych != 'e') goto yy818;
yy911:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy912;
	if (yych != 'm') goto yy56;
yy912:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy913;
	if (yych != 'b') goto yy56;
yy913:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy914;
	if (yych != 'e') goto yy56;
yy914:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy908;
	if (yych == 'r') goto yy908;
	goto yy56;
yy915:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy916;
	if (yych != 't') goto yy56;
yy916:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy917;
	if (yych != 'o') goto yy818;
yy917:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy918;
	if (yych != 'b') goto yy56;
yy918:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy919;
	if (yych != 'e') goto yy56;
yy919:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy908;
	if (yych == 'r') goto yy908;
	goto yy56;
yy920:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy121;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy921:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy922;
	if (yych != 't') goto yy818;
yy922:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy923;
	if (yych != 'e') goto yy818;
yy923:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy924;
	if (yych != 'm') goto yy56;
yy924:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy925;
	if (yych != 'b') goto yy56;
yy925:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy926;
	if (yych != 'e') goto yy56;
yy926:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy908;
	if (yych == 'r') goto yy908;
	goto yy56;
yy927:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy931;
	if (yych == 'g') goto yy931;
	goto yy56;
yy928:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy929;
	if (yych != 'r') goto yy56;
yy929:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy930;
	if (yych != 'i') goto yy818;
yy930:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy908;
	if (yych == 'l') goto yy908;
	goto yy56;
yy931:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy932;
	if (yych != 'u') goto yy818;
yy932:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy933;
	if (yych != 's') goto yy56;
yy933:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy908;
	if (yych == 't') goto yy908;
	goto yy56;
yy934:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy935;
		if (yych <= 'X') goto yy56;
		goto yy908;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy908;
			goto yy56;
		}
	}
yy935:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy936;
	if (yych != 'c') goto yy818;
yy936:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy908;
	if (yych == 'h') goto yy908;
	goto yy56;
yy937:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy938;
	if (yych != 'b') goto yy56;
yy938:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy939;
	if (yych != 'r') goto yy818;
yy939:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy940;
	if (yych != 'u') goto yy56;
yy940:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy941;
	if (yych != 'a') goto yy56;
yy941:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy942;
	if (yych != 'r') goto yy56;
yy942:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy908;
	if (yych == 'y') goto yy908;
	goto yy56;
yy943:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy950;
		if (yych <= 'M') goto yy56;
		goto yy949;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy950;
		} else {
			if (yych == 'n') goto yy949;
			goto yy56;
		}
	}
yy944:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy945;
	if (yych != 'n') goto yy56;
yy945:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy946;
	if (yych != 'u') goto yy818;
yy946:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy947;
	if (yych != 'a') goto yy56;
yy947:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy948;
	if (yych != 'r') goto yy56;
yy948:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy908;
	if (yych == 'y') goto yy908;
	goto yy56;
yy949:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy908;
	if (yych == 'e') goto yy908;
	goto yy818;
yy950:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy908;
	if (yych == 'y') goto yy908;
	goto yy818;
yy951:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy908;
	goto yy818;
yy952:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy818;
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy908;
	goto yy818;
yy954:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy908;
	goto yy818;
yy955:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy970;
	if (yych <= '9') goto yy969;
	goto yy56;
yy956:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy968;
	goto yy56;
yy957:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy966;
	if (yych <= '6') goto yy965;
	goto yy56;
yy958:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy937;
	if (yych == 'e') goto yy937;
	goto yy56;
yy959:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy934;
	if (yych == 'a') goto yy934;
	goto yy56;
yy960:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy964;
	if (yych == 'e') goto yy964;
	goto yy56;
yy961:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy902;
	if (yych == 'e') goto yy902;
	goto yy56;
yy962:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy963:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy962;
	case 'A':
	case 'a':	goto yy824;
	case 'D':
	case 'd':	goto yy961;
	case 'F':
	case 'f':	goto yy958;
	case 'I':	goto yy817;
	case 'J':
	case 'j':	goto yy821;
	case 'M':
	case 'm':	goto yy959;
	case 'N':
	case 'n':	goto yy827;
	case 'O':
	case 'o':	goto yy826;
	case 'S':
	case 's':	goto yy960;
	case 'V':	goto yy819;
	case 'X':	goto yy820;
	default:	goto yy56;
	}
yy964:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy921;
	if (yych == 'p') goto yy921;
	goto yy56;
yy965:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy967;
	goto yy56;
yy966:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy967:
	yych = *++YYCURSOR;
	goto yy846;
yy968:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy967;
	goto yy56;
yy969:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy967;
	goto yy56;
yy970:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy967;
	goto yy56;
yy971:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy974;
	if (yych <= '9') goto yy982;
	goto yy56;
yy972:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy974;
	if (yych <= '2') goto yy982;
	goto yy56;
yy973:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy974:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy975;
	if (yych <= '3') goto yy976;
	if (yych <= '9') goto yy977;
	goto yy56;
yy975:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy479;
		if (yych <= '9') goto yy977;
		if (yych <= 'm') goto yy479;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy980;
		} else {
			if (yych <= 's') goto yy978;
			if (yych <= 't') goto yy981;
			goto yy479;
		}
	}
yy976:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy479;
		if (yych <= '1') goto yy977;
		if (yych <= 'm') goto yy479;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy980;
		} else {
			if (yych <= 's') goto yy978;
			if (yych <= 't') goto yy981;
			goto yy479;
		}
	}
yy977:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy979;
		goto yy479;
	} else {
		if (yych <= 'r') goto yy980;
		if (yych <= 's') goto yy978;
		if (yych <= 't') goto yy981;
		goto yy479;
	}
yy978:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy478;
	goto yy56;
yy979:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy478;
	goto yy56;
yy980:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy478;
	goto yy56;
yy981:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy478;
	goto yy56;
yy982:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy985;
	} else {
		if (yych <= '3') goto yy986;
		if (yych <= '9') goto yy977;
		goto yy56;
	}
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy479;
		if (yych <= '9') goto yy987;
		if (yych <= 'm') goto yy479;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy980;
		} else {
			if (yych <= 's') goto yy978;
			if (yych <= 't') goto yy981;
			goto yy479;
		}
	}
yy985:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy479;
		if (yych <= '9') goto yy987;
		if (yych <= 'm') goto yy479;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy980;
		} else {
			if (yych <= 's') goto yy978;
			if (yych <= 't') goto yy981;
			goto yy479;
		}
	}
yy986:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy479;
		if (yych <= '1') goto yy987;
		if (yych <= 'm') goto yy479;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy980;
		} else {
			if (yych <= 's') goto yy978;
			if (yych <= 't') goto yy981;
			goto yy479;
		}
	}
yy987:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy478;
		if (yych <= 'm') goto yy479;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy980;
		} else {
			if (yych <= 's') goto yy978;
			if (yych <= 't') goto yy981;
			goto yy479;
		}
	}
yy988:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1068;
		if (yych <= 'T') goto yy56;
		goto yy1067;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy1068;
		} else {
			if (yych == 'u') goto yy1067;
			goto yy56;
		}
	}
yy989:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1065;
	if (yych == 'e') goto yy1065;
	goto yy56;
yy990:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1062;
	if (yych == 'a') goto yy1062;
	goto yy56;
yy991:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1059;
		if (yych <= 'T') goto yy56;
		goto yy1058;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy1059;
		} else {
			if (yych == 'u') goto yy1058;
			goto yy56;
		}
	}
yy992:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1055;
	if (yych == 'e') goto yy1055;
	goto yy56;
yy993:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1053;
	if (yych == 'c') goto yy1053;
	goto yy56;
yy994:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1051;
	if (yych == 'o') goto yy1051;
	goto yy56;
yy995:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1049;
	if (yych == 'e') goto yy1049;
	goto yy56;
yy996:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy835;
	if (yych <= '4') goto yy836;
	if (yych <= '5') goto yy837;
	goto yy56;
yy997:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1001;
	if (yych <= '/') goto yy998;
	if (yych <= '9') goto yy1020;
yy998:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy999:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1001;
	if (yych <= '/') goto yy998;
	if (yych <= '2') goto yy1020;
	goto yy998;
yy1000:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy998;
yy1001:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1002;
	if (yych <= '3') goto yy1003;
	if (yych <= '9') goto yy1004;
	goto yy56;
yy1002:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy681;
			goto yy1004;
		} else {
			if (yych == 'T') goto yy1009;
			goto yy681;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1006;
			if (yych <= 'q') goto yy681;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy681;
		}
	}
yy1003:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy681;
		} else {
			if (yych == 'T') goto yy1009;
			goto yy681;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1006;
			if (yych <= 'q') goto yy681;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy681;
		}
	}
yy1004:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1009;
		if (yych <= 'm') goto yy681;
		goto yy1006;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy681;
		}
	}
yy1005:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1019;
	goto yy56;
yy1006:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1019;
	goto yy56;
yy1007:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1019;
	goto yy56;
yy1008:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1019;
	goto yy56;
yy1009:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1010;
	if (yych <= '2') goto yy1011;
	if (yych <= '9') goto yy1012;
	goto yy56;
yy1010:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1012;
	if (yych <= ':') goto yy1013;
	goto yy56;
yy1011:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1012;
	if (yych == ':') goto yy1013;
	goto yy56;
yy1012:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy1013:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1014;
	if (yych <= '9') goto yy1015;
	goto yy56;
yy1014:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1015;
	if (yych <= ':') goto yy1016;
	goto yy56;
yy1015:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy1016:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1017;
	if (yych <= '6') goto yy1018;
	if (yych <= '9') goto yy866;
	goto yy56;
yy1017:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '9') goto yy866;
	goto yy867;
yy1018:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy866;
	goto yy867;
yy1019:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1009;
	goto yy681;
yy1020:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy998;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy1023;
	} else {
		if (yych <= '3') goto yy1024;
		if (yych <= '9') goto yy1004;
		goto yy56;
	}
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy681;
			goto yy1025;
		} else {
			if (yych == 'T') goto yy1009;
			goto yy681;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1006;
			if (yych <= 'q') goto yy681;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy681;
		}
	}
yy1023:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy681;
			goto yy1025;
		} else {
			if (yych == 'T') goto yy1009;
			goto yy681;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1006;
			if (yych <= 'q') goto yy681;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy681;
		}
	}
yy1024:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy681;
		} else {
			if (yych == 'T') goto yy1009;
			goto yy681;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1006;
			if (yych <= 'q') goto yy681;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy681;
		}
	}
yy1025:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1026;
		if (yych <= 'm') goto yy479;
		goto yy1006;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy479;
			goto yy1007;
		} else {
			if (yych <= 's') goto yy1005;
			if (yych <= 't') goto yy1008;
			goto yy479;
		}
	}
yy1026:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1027;
	if (yych <= '2') goto yy1028;
	if (yych <= '9') goto yy1012;
	goto yy56;
yy1027:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1029;
	if (yych <= ':') goto yy1013;
	goto yy56;
yy1028:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1029;
	if (yych == ':') goto yy1013;
	goto yy56;
yy1029:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1031;
	if (yych <= '9') goto yy1015;
	goto yy56;
yy1031:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1032;
	if (yych <= ':') goto yy1016;
	goto yy56;
yy1032:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1034;
	if (yych <= '6') goto yy1035;
	if (yych <= '9') goto yy866;
	goto yy56;
yy1034:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '9') goto yy1036;
	goto yy867;
yy1035:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy867;
yy1036:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy867;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1038:
	yyaccept = 23;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1041;
		if (yych <= ',') goto yy867;
		goto yy1041;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy867;
			goto yy1038;
		} else {
			if (yych != 'G') goto yy867;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1047;
	goto yy56;
yy1041:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1042;
	if (yych <= '2') goto yy1043;
	if (yych <= '9') goto yy1044;
	goto yy56;
yy1042:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '9') goto yy1044;
	if (yych <= ':') goto yy1045;
	goto yy867;
yy1043:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy867;
		if (yych >= '5') goto yy1046;
	} else {
		if (yych <= '9') goto yy866;
		if (yych <= ':') goto yy1045;
		goto yy867;
	}
yy1044:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '5') goto yy1046;
	if (yych <= '9') goto yy866;
	if (yych >= ';') goto yy867;
yy1045:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '5') goto yy1046;
	if (yych <= '9') goto yy866;
	goto yy867;
yy1046:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy867;
	if (yych <= '9') goto yy866;
	goto yy867;
yy1047:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1041;
	if (yych == '-') goto yy1041;
	goto yy56;
yy1049:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1050;
	if (yych != 'c') goto yy56;
yy1050:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'E') goto yy904;
		if (yych == 'e') goto yy904;
		goto yy818;
	}
yy1051:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1052;
	if (yych != 'v') goto yy56;
yy1052:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'E') goto yy911;
		if (yych == 'e') goto yy911;
		goto yy818;
	}
yy1053:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1054;
	if (yych != 't') goto yy56;
yy1054:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'O') goto yy917;
		if (yych == 'o') goto yy917;
		goto yy818;
	}
yy1055:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1056;
	if (yych != 'p') goto yy56;
yy1056:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'T') goto yy1057;
		if (yych != 't') goto yy818;
	}
yy1057:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'E') goto yy923;
		if (yych == 'e') goto yy923;
		goto yy818;
	}
yy1058:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1061;
	if (yych == 'g') goto yy1061;
	goto yy56;
yy1059:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1060;
	if (yych != 'r') goto yy56;
yy1060:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'I') goto yy930;
		if (yych == 'i') goto yy930;
		goto yy818;
	}
yy1061:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'U') goto yy932;
		if (yych == 'u') goto yy932;
		goto yy818;
	}
yy1062:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1063;
		if (yych <= 'X') goto yy56;
		goto yy1064;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy1064;
			goto yy56;
		}
	}
yy1063:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'C') goto yy936;
		if (yych == 'c') goto yy936;
		goto yy818;
	}
yy1064:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy791;
	goto yy818;
yy1065:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1066;
	if (yych != 'b') goto yy56;
yy1066:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'R') goto yy939;
		if (yych == 'r') goto yy939;
		goto yy818;
	}
yy1067:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1071;
		if (yych <= 'M') goto yy56;
		goto yy1070;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy1071;
		} else {
			if (yych == 'n') goto yy1070;
			goto yy56;
		}
	}
yy1068:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1069;
	if (yych != 'n') goto yy56;
yy1069:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'U') goto yy946;
		if (yych == 'u') goto yy946;
		goto yy818;
	}
yy1070:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'E') goto yy908;
		if (yych == 'e') goto yy908;
		goto yy818;
	}
yy1071:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy791;
		goto yy818;
	} else {
		if (yych <= 'Y') goto yy908;
		if (yych == 'y') goto yy908;
		goto yy818;
	}
yy1072:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy602;
			goto yy755;
		} else {
			if (yych <= ',') goto yy602;
			if (yych <= '-') goto yy756;
			goto yy755;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy754;
			if (yych <= 'T') goto yy602;
			goto yy79;
		} else {
			if (yych == 'u') goto yy79;
			goto yy602;
		}
	}
yy1073:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy56;
		goto yy610;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy121;
		} else {
			if (yych == 'p') goto yy610;
			goto yy56;
		}
	}
yy1074:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1076;
			goto yy1078;
		} else {
			if (yych <= '-') goto yy1075;
			if (yych <= '.') goto yy755;
			if (yych <= '/') goto yy754;
			goto yy765;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy494;
			goto yy1078;
		} else {
			if (yych <= 'r') goto yy495;
			if (yych <= 's') goto yy489;
			if (yych <= 't') goto yy492;
			goto yy1078;
		}
	}
yy1075:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1079;
	case '1':	goto yy1080;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy642;
	case 'A':
	case 'a':	goto yy646;
	case 'D':
	case 'd':	goto yy650;
	case 'F':
	case 'f':	goto yy644;
	case 'J':
	case 'j':	goto yy643;
	case 'M':
	case 'm':	goto yy645;
	case 'N':
	case 'n':	goto yy649;
	case 'O':
	case 'o':	goto yy648;
	case 'S':
	case 's':	goto yy647;
	default:	goto yy602;
	}
yy1076:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1078;
	if (yych <= '0') goto yy760;
	if (yych <= '1') goto yy761;
	if (yych <= '9') goto yy762;
	goto yy1078;
yy1077:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1078:
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1077;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy1077;
					if (yych <= ',') goto yy56;
					goto yy601;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy598;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy490;
					if (yych == 'F') goto yy491;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy499;
					goto yy503;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy487;
					goto yy506;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy505;
					if (yych <= 'R') goto yy56;
					goto yy488;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy501;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy502;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy598;
					if (yych <= 'c') goto yy56;
					goto yy490;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy491;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy65;
					if (yych == 'j') goto yy503;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy487;
					if (yych <= 'n') goto yy506;
					goto yy505;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy488;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy1079:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy679;
		goto yy626;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy1081;
		goto yy56;
	}
yy1080:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy679;
		goto yy626;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy1081:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy1082;
	if (yych <= '.') goto yy626;
	goto yy56;
yy1082:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy1084;
	} else {
		if (yych <= '3') goto yy1085;
		if (yych <= '9') goto yy683;
		goto yy56;
	}
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy1086;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy1084:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy1086;
		if (yych <= 'm') goto yy681;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy1085:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy681;
		} else {
			if (yych <= '9') goto yy628;
			if (yych <= 'm') goto yy681;
			goto yy685;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy681;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy681;
		}
	}
yy1086:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy788;
		if (yych <= '9') goto yy629;
		if (yych <= 'm') goto yy788;
		goto yy685;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy788;
			goto yy686;
		} else {
			if (yych <= 's') goto yy684;
			if (yych <= 't') goto yy687;
			goto yy788;
		}
	}
yy1087:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1076;
			if (yych <= ',') goto yy1078;
			goto yy1075;
		} else {
			if (yych <= '.') goto yy1088;
			if (yych <= '/') goto yy754;
			if (yych <= '5') goto yy1090;
			goto yy765;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1089;
			if (yych == 'n') goto yy494;
			goto yy1078;
		} else {
			if (yych <= 'r') goto yy495;
			if (yych <= 's') goto yy489;
			if (yych <= 't') goto yy492;
			goto yy1078;
		}
	}
yy1088:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy602;
		if (yych <= '0') goto yy1112;
		goto yy1113;
	} else {
		if (yych <= '5') goto yy1114;
		if (yych <= '9') goto yy1115;
		goto yy602;
	}
yy1089:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1107;
	if (yych <= '9') goto yy1108;
	goto yy56;
yy1090:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy809;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy815;
				} else {
					if (yych <= ' ') goto yy815;
					if (yych >= '-') goto yy812;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy816;
					if (yych <= '/') goto yy813;
					goto yy1093;
				} else {
					if (yych <= '1') goto yy1094;
					if (yych <= '2') goto yy1095;
					goto yy1096;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy1097;
					if (yych <= '6') goto yy1098;
					goto yy54;
				} else {
					if (yych <= ':') goto yy831;
					if (yych >= 'A') goto yy815;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy815;
				} else {
					if (yych == 'G') goto yy1092;
					if (yych <= 'J') goto yy815;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy815;
					if (yych >= 'S') goto yy815;
				} else {
					if (yych <= 'W') goto yy834;
					if (yych <= 'Y') goto yy815;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy815;
					if (yych >= 'd') goto yy815;
				} else {
					if (yych == 'f') goto yy815;
					if (yych >= 'h') goto yy815;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy815;
				} else {
					if (yych <= 'o') goto yy815;
					if (yych >= 's') goto yy815;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy815;
				} else {
					if (yych <= 'y') goto yy815;
					if (yych == 0xC2) goto yy815;
				}
			}
		}
	}
yy1092:
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1093:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1105;
	if (yych <= '9') goto yy1106;
	goto yy60;
yy1094:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1104;
	if (yych <= '9') goto yy1103;
	goto yy60;
yy1095:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1103;
	goto yy60;
yy1096:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1101;
	if (yych <= '6') goto yy1102;
	if (yych <= '9') goto yy1099;
	goto yy60;
yy1097:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1099;
	goto yy60;
yy1098:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1099;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1099:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy60;
				} else {
					if (yych == 'W') goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy60;
				if (yych == 'd') goto yy60;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy60;
				} else {
					if (yych <= 'h') goto yy60;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy1100;
				if (yych != 'v') goto yy60;
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
				}
			}
		}
	}
yy1100:
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1101:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1100;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1100;
					goto yy845;
				} else {
					if (yych == 'D') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1100;
				if (yych <= 'H') goto yy60;
				goto yy1100;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'V') goto yy1100;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1100;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'v') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1100;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1100;
				}
			}
		}
	}
yy1102:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1100;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1100;
					goto yy845;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1100;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy1100;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'V') goto yy1100;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1100;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'v') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1100;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1100;
				}
			}
		}
	}
yy1103:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1100;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1100;
					goto yy845;
				} else {
					if (yych == 'D') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1100;
				if (yych <= 'H') goto yy60;
				goto yy1100;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'V') goto yy1100;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1100;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'v') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1100;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1100;
				}
			}
		}
	}
yy1104:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1100;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1100;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy869;
					goto yy870;
				} else {
					if (yych <= '3') goto yy871;
					if (yych <= '9') goto yy845;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'G') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1100;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1100;
					if (yych <= 'U') goto yy60;
					goto yy1100;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1100;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'v') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1100;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1100;
				}
			}
		}
	}
yy1105:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1100;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1100;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy901;
					goto yy870;
				} else {
					if (yych <= '3') goto yy871;
					if (yych <= '9') goto yy845;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'G') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1100;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1100;
					if (yych <= 'U') goto yy60;
					goto yy1100;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1100;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'v') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1100;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1100;
				}
			}
		}
	}
yy1106:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1100;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1100;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy869;
					goto yy870;
				} else {
					if (yych <= '3') goto yy871;
					if (yych <= '9') goto yy845;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'G') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1100;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1100;
					if (yych <= 'U') goto yy60;
					goto yy1100;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1100;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1100;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1100;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1100;
				} else {
					if (yych == 'v') goto yy1100;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1100;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1100;
				}
			}
		}
	}
yy1107:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1109;
		goto yy515;
	} else {
		if (yych <= '9') goto yy1108;
		if (yych <= ':') goto yy1109;
		goto yy515;
	}
yy1108:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1109;
	if (yych != ':') goto yy515;
yy1109:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1110;
	if (yych <= '6') goto yy1111;
	if (yych <= '9') goto yy520;
	goto yy56;
yy1110:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy520;
	goto yy515;
yy1111:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych == '0') goto yy520;
	goto yy515;
yy1112:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		goto yy1116;
	} else {
		if (yych <= '/') goto yy515;
		if (yych <= '9') goto yy1115;
		if (yych <= ':') goto yy1109;
		goto yy515;
	}
yy1113:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		if (yych <= '.') goto yy1116;
		goto yy515;
	} else {
		if (yych <= '2') goto yy1115;
		if (yych <= '9') goto yy1108;
		if (yych <= ':') goto yy1109;
		goto yy515;
	}
yy1114:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
		goto yy1116;
	} else {
		if (yych <= '/') goto yy515;
		if (yych <= '9') goto yy1108;
		if (yych <= ':') goto yy1109;
		goto yy515;
	}
yy1115:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy515;
		if (yych <= '-') goto yy626;
	} else {
		if (yych == ':') goto yy1109;
		goto yy515;
	}
yy1116:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1117;
	if (yych <= '6') goto yy1118;
	if (yych <= '9') goto yy634;
	goto yy56;
yy1117:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy1119;
	goto yy515;
yy1118:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy521;
		goto yy515;
	} else {
		if (yych <= '0') goto yy1119;
		if (yych <= '9') goto yy635;
		goto yy515;
	}
yy1119:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy521;
	if (yych <= '/') goto yy515;
	if (yych <= '9') goto yy629;
	goto yy515;
yy1120:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy484;
			if (yych <= ',') goto yy486;
			goto yy1075;
		} else {
			if (yych <= '.') goto yy498;
			if (yych <= '/') goto yy496;
			if (yych <= '5') goto yy1090;
			goto yy765;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy507;
			if (yych == 'n') goto yy494;
			goto yy486;
		} else {
			if (yych <= 'r') goto yy495;
			if (yych <= 's') goto yy489;
			if (yych <= 't') goto yy492;
			goto yy486;
		}
	}
yy1121:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1076;
			if (yych <= ',') goto yy1078;
			goto yy1075;
		} else {
			if (yych <= '.') goto yy1088;
			if (yych <= '/') goto yy496;
			if (yych <= '5') goto yy1090;
			goto yy765;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1089;
			if (yych == 'n') goto yy494;
			goto yy1078;
		} else {
			if (yych <= 'r') goto yy495;
			if (yych <= 's') goto yy489;
			if (yych <= 't') goto yy492;
			goto yy1078;
		}
	}
yy1122:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1123;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1123:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy167;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'v') goto yy1124;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1124:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy168;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'i') goto yy1125;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1125:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy169;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'o') goto yy1126;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1126:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1127;
		if (yych != 'u') goto yy3;
	}
yy1127:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1128;
	if (yych != 's') goto yy56;
yy1128:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1129;
	if (yych != ' ') goto yy56;
yy1129:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1130:
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1129;
				if (yych <= 0x1F) goto yy56;
				goto yy1129;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy1136;
				} else {
					if (yych == 'F') goto yy1137;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1135;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy1131;
					if (yych <= 'R') goto yy56;
					goto yy1134;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1140;
					goto yy1133;
				} else {
					if (yych == 'W') goto yy1139;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1138;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy1136;
					if (yych <= 'e') goto yy56;
					goto yy1137;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy1135;
				} else {
					if (yych != 'm') goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1134;
					goto yy1140;
				} else {
					if (yych <= 'u') goto yy1133;
					if (yych <= 'v') goto yy56;
					goto yy1139;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy1138;
				} else {
					if (yych == 0xC2) goto yy1132;
					goto yy56;
				}
			}
		}
	}
yy1131:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy1215;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy1214;
			if (yych <= 'R') goto yy56;
			goto yy1216;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy1215;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy1214;
			if (yych == 's') goto yy1216;
			goto yy56;
		}
	}
yy1132:
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy1211;
	goto yy56;
yy1133:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1209;
	if (yych == 's') goto yy1209;
	goto yy56;
yy1134:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1196;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1197;
			if (yych <= 'T') goto yy56;
			goto yy1195;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1196;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1197;
			if (yych == 'u') goto yy1195;
			goto yy56;
		}
	}
yy1135:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1193;
	if (yych == 'o') goto yy1193;
	goto yy56;
yy1136:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1192;
	if (yych == 'a') goto yy1192;
	goto yy56;
yy1137:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1177;
		if (yych <= 'Q') goto yy56;
		goto yy1176;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1177;
		} else {
			if (yych == 'r') goto yy1176;
			goto yy56;
		}
	}
yy1138:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1173;
	if (yych == 'e') goto yy1173;
	goto yy56;
yy1139:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1159;
	if (yych == 'e') goto yy1159;
	goto yy56;
yy1140:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1141;
		if (yych <= 'T') goto yy56;
		goto yy1142;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1142;
			goto yy56;
		}
	}
yy1141:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1154;
	if (yych == 'u') goto yy1154;
	goto yy56;
yy1142:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1143;
	if (yych != 'e') goto yy56;
yy1143:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych >= ' ') goto yy1145;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1147;
		} else {
			if (yych == 's') goto yy1147;
		}
	}
yy1144:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1145:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych <= 0x1F) goto yy56;
		goto yy1145;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1151;
		} else {
			if (yych == 'o') goto yy1151;
			goto yy56;
		}
	}
yy1147:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1148;
	if (yych != 'd') goto yy56;
yy1148:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1149;
	if (yych != 'a') goto yy56;
yy1149:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych != 'y') goto yy56;
yy1150:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1145;
	if (yych == ' ') goto yy1145;
	goto yy1144;
yy1151:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1152;
	if (yych != 'f') goto yy56;
yy1152:
	++YYCURSOR;
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1154:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych <= 0x1F) goto yy1144;
		goto yy1145;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1144;
		} else {
			if (yych != 'r') goto yy1144;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1156;
	if (yych != 's') goto yy56;
yy1156:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1157;
	if (yych != 'd') goto yy56;
yy1157:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1158;
	if (yych != 'a') goto yy56;
yy1158:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych == 'y') goto yy1150;
	goto yy56;
yy1159:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1161;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1161;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1167;
	if (yych == 'k') goto yy1167;
	goto yy56;
yy1161:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych <= 0x1F) goto yy1144;
		goto yy1145;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1144;
		} else {
			if (yych != 'n') goto yy1144;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1163;
	if (yych != 'e') goto yy56;
yy1163:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1164;
	if (yych != 's') goto yy56;
yy1164:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1165;
	if (yych != 'd') goto yy56;
yy1165:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1166;
	if (yych != 'a') goto yy56;
yy1166:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych == 'y') goto yy1150;
	goto yy56;
yy1167:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1170;
		if (yych >= 'S') goto yy1169;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1170;
		} else {
			if (yych == 's') goto yy1169;
		}
	}
yy1168:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1169:
	yych = *++YYCURSOR;
	goto yy1144;
yy1170:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1171;
	if (yych != 'a') goto yy56;
yy1171:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1172;
	if (yych != 'y') goto yy56;
yy1172:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1169;
	if (yych == 's') goto yy1169;
	goto yy1144;
yy1173:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1174;
	if (yych != 'a') goto yy56;
yy1174:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1175;
	if (yych != 'r') goto yy56;
yy1175:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1169;
	if (yych == 's') goto yy1169;
	goto yy1144;
yy1176:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1189;
	if (yych == 'i') goto yy1189;
	goto yy56;
yy1177:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1178;
	if (yych != 'r') goto yy56;
yy1178:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1179;
	if (yych != 't') goto yy56;
yy1179:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1181;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1181;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1186;
	if (yych == 'i') goto yy1186;
	goto yy56;
yy1181:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1182;
	if (yych != 'n') goto yy56;
yy1182:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1183;
	if (yych != 'i') goto yy56;
yy1183:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1184;
	if (yych != 'g') goto yy56;
yy1184:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1185;
	if (yych != 'h') goto yy56;
yy1185:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1175;
	if (yych == 't') goto yy1175;
	goto yy56;
yy1186:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1187;
	if (yych != 'g') goto yy56;
yy1187:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1188;
	if (yych != 'h') goto yy56;
yy1188:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1175;
	if (yych == 't') goto yy1175;
	goto yy56;
yy1189:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych <= 0x1F) goto yy1144;
		goto yy1145;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1144;
		} else {
			if (yych != 'd') goto yy1144;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1191;
	if (yych != 'a') goto yy56;
yy1191:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych == 'y') goto yy1150;
	goto yy56;
yy1192:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1175;
	if (yych == 'y') goto yy1175;
	goto yy56;
yy1193:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1194;
	if (yych != 'u') goto yy56;
yy1194:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1175;
	if (yych == 'r') goto yy1175;
	goto yy56;
yy1195:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1206;
	if (yych == 'n') goto yy1206;
	goto yy56;
yy1196:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1201;
	if (yych == 't') goto yy1201;
	goto yy56;
yy1197:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1198;
	if (yych != 'c') goto yy56;
yy1198:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1199;
		if (yych <= 'R') goto yy1144;
		goto yy1169;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1144;
		} else {
			if (yych == 's') goto yy1169;
			goto yy1144;
		}
	}
yy1199:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1200;
	if (yych != 'n') goto yy56;
yy1200:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1175;
	if (yych == 'd') goto yy1175;
	goto yy56;
yy1201:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych <= 0x1F) goto yy1144;
		goto yy1145;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1144;
		} else {
			if (yych != 'u') goto yy1144;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1203;
	if (yych != 'r') goto yy56;
yy1203:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1204;
	if (yych != 'd') goto yy56;
yy1204:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1205;
	if (yych != 'a') goto yy56;
yy1205:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych == 'y') goto yy1150;
	goto yy56;
yy1206:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1145;
		if (yych <= 0x1F) goto yy1144;
		goto yy1145;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1144;
		} else {
			if (yych != 'd') goto yy1144;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1208;
	if (yych != 'a') goto yy56;
yy1208:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych == 'y') goto yy1150;
	goto yy56;
yy1209:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1210;
	if (yych != 'e') goto yy56;
yy1210:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1175;
	if (yych == 'c') goto yy1175;
	goto yy56;
yy1211:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1212;
	if (yych != 's') goto yy56;
yy1212:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1213;
	if (yych != 'e') goto yy1144;
yy1213:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1175;
	if (yych == 'c') goto yy1175;
	goto yy56;
yy1214:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1237;
	if (yych == 'n') goto yy1237;
	goto yy56;
yy1215:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1219;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy1218;
			if (yych <= 'M') goto yy56;
			goto yy1220;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1219;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy1218;
			if (yych == 'n') goto yy1220;
			goto yy56;
		}
	}
yy1216:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1217;
	if (yych != 'e') goto yy1144;
yy1217:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1175;
	if (yych == 'c') goto yy1175;
	goto yy56;
yy1218:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1230;
	if (yych == 'l') goto yy1230;
	goto yy56;
yy1219:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1223;
	if (yych == 'r') goto yy1223;
	goto yy56;
yy1220:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1169;
		if (yych <= 'T') goto yy1144;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1144;
			goto yy1169;
		} else {
			if (yych != 'u') goto yy1144;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1222;
	if (yych != 't') goto yy56;
yy1222:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1175;
	if (yych == 'e') goto yy1175;
	goto yy56;
yy1223:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1224;
	if (yych != 'o') goto yy56;
yy1224:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1225;
	if (yych != 's') goto yy56;
yy1225:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1226;
	if (yych != 'e') goto yy56;
yy1226:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1227;
	if (yych != 'c') goto yy56;
yy1227:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1228;
	if (yych != 'o') goto yy56;
yy1228:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1229;
	if (yych != 'n') goto yy56;
yy1229:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1175;
	if (yych == 'd') goto yy1175;
	goto yy56;
yy1230:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1231;
	if (yych != 'i') goto yy56;
yy1231:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1232;
	if (yych != 's') goto yy56;
yy1232:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1233;
	if (yych != 'e') goto yy56;
yy1233:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1234;
	if (yych != 'c') goto yy56;
yy1234:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1235;
	if (yych != 'o') goto yy56;
yy1235:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1236;
	if (yych != 'n') goto yy56;
yy1236:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1175;
	if (yych == 'd') goto yy1175;
	goto yy56;
yy1237:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1145;
			goto yy1144;
		} else {
			if (yych <= ' ') goto yy1145;
			if (yych <= 'C') goto yy1144;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1239;
			goto yy1144;
		} else {
			if (yych <= 'd') goto yy1238;
			if (yych == 't') goto yy1239;
			goto yy1144;
		}
	}
yy1238:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1240;
	if (yych == 'a') goto yy1240;
	goto yy56;
yy1239:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1175;
	if (yych == 'h') goto yy1175;
	goto yy56;
yy1240:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1150;
	if (yych == 'y') goto yy1150;
	goto yy56;
yy1241:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1123;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1242;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1242:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1124;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'v') goto yy1243;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1243:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1125;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'i') goto yy1244;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1244:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1126;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'o') goto yy1245;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1245:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1127;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1246;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1246:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1128;
	if (yych != 's') goto yy179;
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1129;
		} else {
			if (yych == ' ') goto yy1129;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy56;
		}
	}
yy1248:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy166;
			goto yy1262;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'g') goto yy1262;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1249:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1250;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1250:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy167;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'v') goto yy1251;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1251:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy1252;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1252:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy169;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'n') goto yy1253;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1253:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1254;
		if (yych != 't') goto yy3;
	}
yy1254:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1255;
	if (yych != 'h') goto yy56;
yy1255:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1256;
	if (yych != ' ') goto yy56;
yy1256:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1257:
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1256;
				if (yych <= 0x1F) goto yy56;
				goto yy1256;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy1136;
				} else {
					if (yych == 'F') goto yy1137;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1135;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy1131;
					if (yych <= 'R') goto yy56;
					goto yy1134;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1140;
					goto yy1133;
				} else {
					if (yych != 'W') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1138;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy1136;
					if (yych <= 'e') goto yy56;
					goto yy1137;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy1135;
				} else {
					if (yych == 'm') goto yy1131;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1134;
					goto yy1140;
				} else {
					if (yych <= 'u') goto yy1133;
					if (yych <= 'v') goto yy56;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy1138;
				} else {
					if (yych == 0xC2) goto yy1132;
					goto yy56;
				}
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1259;
	if (yych != 'e') goto yy56;
yy1259:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1161;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1161;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1261;
	if (yych != 'k') goto yy56;
yy1261:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1170;
		if (yych <= 'R') goto yy56;
		goto yy1169;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1170;
		} else {
			if (yych == 's') goto yy1169;
			goto yy56;
		}
	}
yy1262:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy167;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'h') goto yy1263;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1263:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1264;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1264:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1256;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1256;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1265;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1265;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1265:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1256;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1256;
		if (yych == ')') goto yy164;
		goto yy3;
	}
yy1266:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1262;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'g') goto yy1274;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1267:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1250;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1268;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1268:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1251;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'v') goto yy1269;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1269:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1252;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1270;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1270:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1253;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'n') goto yy1271;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1271:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1254;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 't') goto yy1272;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1272:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1255;
	if (yych != 'h') goto yy179;
yy1273:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1256;
		} else {
			if (yych == ' ') goto yy1256;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy56;
		}
	}
yy1274:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1263;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'h') goto yy1275;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1275:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1264;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1276;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1276:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1256;
			} else {
				if (yych == ' ') goto yy1256;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy172;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy169;
			} else {
				if (yych <= 'H') goto yy1265;
				if (yych <= 'Z') goto yy169;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'h') goto yy1277;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1277:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1256;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1256;
			if (yych <= '(') goto yy3;
			goto yy164;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy172;
			goto yy3;
		} else {
			if (yych <= '/') goto yy172;
			if (yych == '_') goto yy172;
			goto yy3;
		}
	}
yy1278:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1294;
				goto yy166;
			} else {
				if (yych <= 'P') goto yy1296;
				if (yych <= 'U') goto yy166;
				goto yy1295;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1294;
				goto yy166;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1296;
				goto yy166;
			} else {
				if (yych <= 'v') goto yy1295;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy1279:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy166;
			goto yy1289;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 't') goto yy1289;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1280:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy166;
			goto yy1286;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'x') goto yy1286;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1281:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1282;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1282:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1283;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1283:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1284;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1284:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1285;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1285:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy164;
	goto yy191;
yy1286:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1287;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1287:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1288;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1288:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1256;
		} else {
			if (yych == ' ') goto yy1256;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1289:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'T') goto yy167;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'u') goto yy1290;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1290:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'r') goto yy1291;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1291:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1292;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1292:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1293;
		if (yych != 'a') goto yy3;
	}
yy1293:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy1294:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy167;
			goto yy1305;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'o') goto yy1305;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1295:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy167;
			goto yy1302;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'e') goto yy1302;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1296:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'T') goto yy167;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 't') goto yy1297;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1297:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'E') goto yy168;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy168;
			} else {
				if (yych <= 'e') goto yy1298;
				if (yych <= 'z') goto yy168;
				goto yy218;
			}
		}
	}
yy1298:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy169;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'm') goto yy1299;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1299:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1300;
		if (yych != 'b') goto yy3;
	}
yy1300:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1301;
	if (yych != 'e') goto yy56;
yy1301:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy230;
	if (yych == 'r') goto yy230;
	goto yy56;
yy1302:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy168;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'n') goto yy1303;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1303:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy1304;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1304:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1255;
		if (yych == 'h') goto yy1255;
		goto yy3;
	}
yy1305:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy168;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'n') goto yy1306;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1306:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
			goto yy1265;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1265;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1307:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy172;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy166;
				goto yy1294;
			} else {
				if (yych == 'P') goto yy1296;
				goto yy166;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1295;
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy171;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1323;
				if (yych <= 'o') goto yy171;
				goto yy1325;
			} else {
				if (yych == 'v') goto yy1324;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1308:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1289;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 't') goto yy1318;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1309:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1286;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'x') goto yy1315;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1310:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1282;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1311;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1311:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1283;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1312;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1312:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1284;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1313;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1313:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1285;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1314;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1314:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy164;
		if (yych <= ',') goto yy191;
		goto yy172;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy191;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy191;
		}
	}
yy1315:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1287;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1316;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1316:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1288;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1317;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1317:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1256;
			if (yych <= 0x1F) goto yy3;
			goto yy1256;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1318:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1290;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy1319;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1319:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1291;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'r') goto yy1320;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1320:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1292;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1321;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1321:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1293;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1322;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1322:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy1323:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1305;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1334;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1324:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1302;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1331;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1325:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'T') goto yy1297;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1326;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1326:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy168;
			} else {
				if (yych <= 'E') goto yy1298;
				if (yych <= 'Z') goto yy168;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1327;
				if (yych <= 'z') goto yy176;
				goto yy218;
			}
		}
	}
yy1327:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1299;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'm') goto yy1328;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1328:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1300;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1329;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1329:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1301;
	if (yych != 'e') goto yy179;
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy230;
	if (yych == 'r') goto yy401;
	goto yy179;
yy1331:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1303;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'n') goto yy1332;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1332:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1304;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1333;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1333:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1255;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1273;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1334:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1306;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'n') goto yy1335;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1335:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1265;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1277;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1336:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'c') goto yy1337;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1337:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy167;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'k') goto yy1338;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1338:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1339;
		if (yych <= '(') goto yy3;
		goto yy164;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1339:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1340;
	if (yych != 'o') goto yy56;
yy1340:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1341;
	if (yych != 'f') goto yy56;
yy1341:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1343;
	if (yych <= '2') goto yy1345;
	if (yych <= '9') goto yy1346;
	goto yy56;
yy1343:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1347;
	if (yych <= '9') goto yy1346;
	goto yy1347;
yy1344:
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1345:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1347;
	if (yych >= '5') goto yy1347;
yy1346:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1347:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1346;
			goto yy1344;
		} else {
			if (yych <= ' ') goto yy1346;
			if (yych <= '@') goto yy1344;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1344;
		} else {
			if (yych <= 'a') goto yy1348;
			if (yych != 'p') goto yy1344;
		}
	}
yy1348:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1350;
		if (yych == 'm') goto yy1350;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1350;
	if (yych != 'm') goto yy56;
yy1350:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1352;
		if (yych == '\t') goto yy1352;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1352;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1352;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1352:
	yych = *++YYCURSOR;
	goto yy1344;
yy1353:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1337;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'c') goto yy1354;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1354:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1338;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'k') goto yy1355;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1355:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1339;
			goto yy3;
		} else {
			if (yych <= ')') goto yy164;
			if (yych == '-') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy172;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1356:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy166;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 's') goto yy1357;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1357:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1358;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1358:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1129;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1359:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1360;
	if (yych != 'd') goto yy1130;
yy1360:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1361;
	if (yych != 'a') goto yy56;
yy1361:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1362;
	if (yych != 'y') goto yy56;
yy1362:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1144;
	} else {
		if (yych <= 'S') goto yy1169;
		if (yych == 's') goto yy1169;
		goto yy1144;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1364;
	if (yych != 'o') goto yy56;
yy1364:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1365;
	if (yych != 'f') goto yy56;
yy1365:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1367:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1357;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 's') goto yy1368;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1368:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1358;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1369;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1369:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1129;
			if (yych <= 0x1F) goto yy3;
			goto yy1359;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1370:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy166;
			goto yy1406;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'b') goto yy1406;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1371:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1396;
			if (yych <= 'Q') goto yy166;
			goto yy1395;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy166;
			goto yy1396;
		} else {
			if (yych == 'r') goto yy1395;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1372:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy166;
			goto yy1392;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'u') goto yy1392;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1373:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1375;
			if (yych <= 'N') goto yy166;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy166;
			goto yy1375;
		} else {
			if (yych == 'o') goto yy1374;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1374:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
			goto yy1378;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1378;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1375:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1376;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1376:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1377;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1377:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
			goto yy1285;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1285;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1378:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1379;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1379:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1380;
		if (yych <= '(') goto yy3;
		goto yy164;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1380:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1381;
	if (yych != 'o') goto yy56;
yy1381:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1382;
	if (yych != 'f') goto yy56;
yy1382:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1384;
	if (yych <= '2') goto yy1385;
	if (yych <= '9') goto yy1386;
	goto yy56;
yy1384:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1387;
	if (yych <= '9') goto yy1386;
	goto yy1387;
yy1385:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1387;
	if (yych >= '5') goto yy1387;
yy1386:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1387:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1386;
			goto yy1344;
		} else {
			if (yych <= ' ') goto yy1386;
			if (yych <= '@') goto yy1344;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1344;
		} else {
			if (yych <= 'a') goto yy1388;
			if (yych != 'p') goto yy1344;
		}
	}
yy1388:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1390;
		if (yych == 'm') goto yy1390;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1390;
	if (yych != 'm') goto yy56;
yy1390:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1352;
		if (yych == '\t') goto yy1352;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1352;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1352;
		if (yych <= 0x08) goto yy56;
		goto yy1352;
	} else {
		if (yych == ' ') goto yy1352;
		goto yy56;
	}
yy1392:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy167;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1393;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1393:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1394;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1394:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy169;
			goto yy1265;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'h') goto yy1265;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1395:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy167;
			goto yy1398;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 's') goto yy1398;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1396:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1397;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1397:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1288;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1288;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1398:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1399;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1399:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1256;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1400:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1401;
	if (yych != 'd') goto yy1257;
yy1401:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1402;
	if (yych != 'a') goto yy56;
yy1402:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1403;
	if (yych != 'y') goto yy56;
yy1403:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1144;
	} else {
		if (yych <= 'S') goto yy1169;
		if (yych == 's') goto yy1169;
		goto yy1144;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1405;
	if (yych != 'o') goto yy56;
yy1405:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1365;
	if (yych == 'f') goto yy1365;
	goto yy56;
yy1406:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'R') goto yy167;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'r') goto yy1407;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1407:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy168;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'u') goto yy1408;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1408:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1409;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1409:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1410;
		if (yych != 'r') goto yy3;
	}
yy1410:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy230;
	if (yych == 'y') goto yy230;
	goto yy56;
yy1411:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1406;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'b') goto yy1429;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1412:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1396;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1395;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1425;
				goto yy171;
			} else {
				if (yych <= 'r') goto yy1424;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1413:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1392;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'u') goto yy1421;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1414:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1375;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1374;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1416;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy1415;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1415:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1378;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1419;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1416:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1376;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1417;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1417:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1377;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1418;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1418:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1285;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1314;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1419:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1379;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1420;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1420:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1380;
			goto yy3;
		} else {
			if (yych <= ')') goto yy164;
			if (yych == '-') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy172;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1421:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1393;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1422;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1422:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1394;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1423;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1423:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1265;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'h') goto yy1277;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1424:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1398;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 's') goto yy1427;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1397;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1426;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1426:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1288;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1317;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1427:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1399;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1428;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1428:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1256;
			if (yych <= 0x1F) goto yy3;
			goto yy1400;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1429:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'R') goto yy1407;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1430;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1430:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1408;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'u') goto yy1431;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1431:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1409;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1432;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1432:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1410;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1433;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1433:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy230;
	if (yych == 'y') goto yy401;
	goto yy179;
yy1434:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1435:
	yyaccept = 29;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '.') goto yy1438;
	if (yych <= '/') goto yy1437;
	if (yych <= '9') goto yy1435;
yy1437:
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1438:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		timelib_ull i, ms;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		ms = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->relative.f = ((double) ms) / 1000000.0;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1446:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
			goto yy1487;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1487;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1447:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1479;
			if (yych <= 'T') goto yy166;
			goto yy1480;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy166;
			goto yy1479;
		} else {
			if (yych == 'u') goto yy1480;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1448:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1468;
			if (yych <= 'L') goto yy166;
			goto yy1469;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy166;
			goto yy1468;
		} else {
			if (yych == 'm') goto yy1469;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1449:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
			goto yy1464;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1464;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1450:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
			goto yy1460;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1460;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1451:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1089;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1454;
		if (yych <= ':') goto yy1089;
		goto yy56;
	}
yy1452:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1089;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1454;
		if (yych == ':') goto yy1089;
		goto yy56;
	}
yy1453:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1089;
	if (yych == ':') goto yy1089;
	goto yy56;
yy1454:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1089;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1455;
		if (yych == ':') goto yy1089;
		goto yy56;
	}
yy1455:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1092;
	if (yych <= '5') goto yy1457;
	if (yych <= '6') goto yy1458;
	goto yy1092;
yy1457:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1459;
	goto yy56;
yy1458:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1459:
	yych = *++YYCURSOR;
	goto yy1100;
yy1460:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy167;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'l') goto yy1461;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1461:
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy168;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'f') goto yy1462;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1462:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy1463;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1463:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1255;
		if (yych == 'h') goto yy1255;
		goto yy3;
	}
yy1464:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'R') goto yy167;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 's') goto yy1465;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1465:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy1466;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1466:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1467;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1467:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy197;
		if (yych == 'y') goto yy197;
		goto yy3;
	}
yy1468:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1476;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy167;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1476;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1469:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy167;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'o') goto yy1470;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1470:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'r') goto yy1471;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1471:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy1472;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1472:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1473;
		if (yych != 'o') goto yy3;
	}
yy1473:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1474;
	if (yych != 'w') goto yy56;
yy1474:
	++YYCURSOR;
yy1475:
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1476:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy168;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'y') goto yy1477;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1477:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy169;
		if (yych <= '`') goto yy1478;
		if (yych <= 'z') goto yy169;
	}
yy1478:
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1479:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy167;
			if (yych <= 'R') goto yy1485;
			goto yy1486;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1485;
			if (yych <= 's') goto yy1486;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1480:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'Q') goto yy167;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1481;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1481:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 's') goto yy1482;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1482:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1483;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1483:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1484;
		if (yych != 'a') goto yy3;
	}
yy1484:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy1485:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
			goto yy1288;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy1288;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1486:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1129;
		} else {
			if (yych == ' ') goto yy1129;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1487:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1488;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1488:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1288;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1288;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1489:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1487;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1519;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1490:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1479;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1480;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1511;
				goto yy171;
			} else {
				if (yych <= 'u') goto yy1512;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1491:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1468;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1469;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1502;
				goto yy171;
			} else {
				if (yych <= 'm') goto yy1503;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1492:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1464;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1498;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1493:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1460;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1494;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1494:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1461;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'l') goto yy1495;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1495:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1462;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'f') goto yy1496;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1496:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1463;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1497;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1497:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1255;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1273;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1498:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1465;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 's') goto yy1499;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1499:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1466;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy1500;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1500:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1467;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1501;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1501:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy197;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy210;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1502:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1476;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1509;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy1503:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1470;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1504;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1504:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1471;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'r') goto yy1505;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1505:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1472;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1506;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1506:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1473;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1507;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1507:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1474;
	if (yych != 'w') goto yy179;
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1475;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1475;
	}
yy1509:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1477;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'y') goto yy1510;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1510:
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1478;
		} else {
			if (yych == '.') goto yy1478;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1478;
			if (yych <= 'Z') goto yy169;
			goto yy1478;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1478;
			if (yych <= 'z') goto yy177;
			goto yy1478;
		}
	}
yy1511:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy172;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy167;
				goto yy1485;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1486;
				goto yy167;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy175;
				goto yy1517;
			} else {
				if (yych <= 's') goto yy1518;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1512:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1481;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1513;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1513:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1482;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 's') goto yy1514;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1514:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1483;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1515;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1515:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1484;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1516;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1516:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy1517:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1288;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy1317;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1518:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1129;
			if (yych <= 0x1F) goto yy3;
			goto yy1129;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1519:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1488;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1520;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1520:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1288;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1317;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1521:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1533;
			if (yych <= 'X') goto yy166;
			goto yy1534;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy166;
			goto yy1533;
		} else {
			if (yych == 'y') goto yy1534;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1522:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy166;
			goto yy1527;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'd') goto yy1527;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1523:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1524;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1524:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1525;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1525:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1526;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1526:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
			goto yy1285;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1285;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1527:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1528;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1528:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy168;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'i') goto yy1529;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1529:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy169;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'g') goto yy1530;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1530:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1531;
		if (yych != 'h') goto yy3;
	}
yy1531:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1532;
	if (yych != 't') goto yy56;
yy1532:
	yych = *++YYCURSOR;
	goto yy1478;
yy1533:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych == 'C') goto yy1535;
				goto yy167;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'c') goto yy1535;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1534:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy218;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy167;
			goto yy218;
		}
	}
yy1535:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy420;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy420;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1536:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1533;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1534;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1548;
				goto yy171;
			} else {
				if (yych <= 'y') goto yy1549;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1537:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1527;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'd') goto yy1542;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1538:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1524;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1539;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1539:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1525;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1540;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1540:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1526;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1541;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1541:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1285;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1314;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1542:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1528;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1543;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1543:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1529;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'i') goto yy1544;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1544:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1530;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'g') goto yy1545;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1545:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1531;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1546;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1546:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1532;
	if (yych != 't') goto yy179;
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1478;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1478;
	}
yy1548:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'C') goto yy1535;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'c') goto yy1550;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1549:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy396;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy167;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1550:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy420;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy431;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1551:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'O') goto yy1559;
			if (yych <= 'U') goto yy166;
			if (yych <= 'V') goto yy1560;
			goto yy1557;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy166;
			goto yy1559;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy166;
				goto yy1560;
			} else {
				if (yych <= 'w') goto yy1557;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy1552:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy166;
			goto yy1556;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'x') goto yy1556;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1553:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1554;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1554:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1555;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1555:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1288;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1288;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1556:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
			goto yy1486;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1486;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1557:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy1558;
		if (yych <= 'z') goto yy167;
	}
yy1558:
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1559:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
			goto yy1565;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1565;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1560:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'E') goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'e') goto yy1561;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1561:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'm') goto yy1562;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1562:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'b') goto yy1563;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1563:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1564;
		if (yych != 'e') goto yy3;
	}
yy1564:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy230;
	if (yych == 'r') goto yy230;
	goto yy56;
yy1565:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy168;
		if (yych <= '`') goto yy1566;
		if (yych <= 'z') goto yy168;
	}
yy1566:
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1567:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy172;
				if (yych <= '@') goto yy3;
				goto yy166;
			} else {
				if (yych <= 'O') goto yy1559;
				if (yych <= 'U') goto yy166;
				goto yy1560;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1557;
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy171;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1574;
				if (yych <= 'u') goto yy171;
				goto yy1575;
			} else {
				if (yych <= 'w') goto yy1573;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1568:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1556;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'x') goto yy1572;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1569:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1554;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1570;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1570:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1555;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1571;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1571:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1288;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1317;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1572:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1486;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1518;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1573:
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1558;
		} else {
			if (yych == '.') goto yy1558;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1558;
			if (yych <= 'Z') goto yy167;
			goto yy1558;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1558;
			if (yych <= 'z') goto yy175;
			goto yy1558;
		}
	}
yy1574:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1565;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1580;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1575:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy396;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy1561;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1576;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1576:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1562;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'm') goto yy1577;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1577:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1563;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'b') goto yy1578;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1578:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1564;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1579;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1579:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy230;
	if (yych == 'r') goto yy401;
	goto yy179;
yy1580:
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1566;
		} else {
			if (yych == '.') goto yy1566;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1566;
			if (yych <= 'Z') goto yy168;
			goto yy1566;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1566;
			if (yych <= 'z') goto yy176;
			goto yy1566;
		}
	}
yy1581:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy166;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 's') goto yy1582;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1582:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1583;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1583:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy1584;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1584:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy1585;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1585:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1586;
		if (yych != 'd') goto yy3;
	}
yy1586:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1587;
	if (yych != 'a') goto yy56;
yy1587:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1588;
	if (yych != 'y') goto yy56;
yy1588:
	++YYCURSOR;
yy1589:
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1590:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1582;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 's') goto yy1591;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1591:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1583;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1592;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1592:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1584;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1593;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1593:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1585;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1594;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1594:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1586;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1595;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1595:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1587;
	if (yych != 'a') goto yy179;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1588;
	if (yych != 'y') goto yy179;
	yyaccept = 34;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1589;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1589;
	}
}

}

#define YYMAXFILL 31

timelib_time* timelib_strtotime(char *s, size_t len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->f == TIMELIB_UNSET) parsed->f = 0;
	} else {
		if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
