.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_sendquery n "26 September 2016" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_sendquery \- send a query string to the backend connection without waiting for a result
.SH SYNOPSIS
.nf

pg_sendquery [\*(T<\-paramarray\*(T> arrayVar] \*(T<conn\*(T> \*(T<commandString\*(T> [\*(T<args\*(T>]
.fi
.SH DESCRIPTION
\*(T<\fBpg_sendquery\fR\*(T> submits a command to the
PostgreSQL server.
This function works like \*(T<\fBpg_exec\fR\*(T>, except that
it does not return a result. Rather, the command is issued
to the backend asynchronously.
.PP
The result is either an error message or nothing. An empty
return indicates that the command was dispatched to the
backend.
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear. See pg_select for more info.
.SH ARGUMENTS
.TP 
\*(T<conn\*(T>
The handle of the connection on which to execute the command.
.TP 
\*(T<commandString\*(T>
The SQL command to execute.
.TP 
\*(T<args\*(T>
For PostgreSQL versions greater than 7.4, \*(T<args\*(T>
consists of zero or more optional values that can be inserted,
unquoted, into the SQL statement using $-style substitution. Nulls are represented by the string "NULL".
.SH "RETURN VALUE"
A Tcl error will be returned if
pgtcl was unable to issue the command.
Otherwise, an empty string will be return. It is up to the
developer to use \*(T<\fBpg_getresult\fR\*(T> to obtain
results from commands issued with \*(T<\fBpg_sendquery\fR\*(T>.
