.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_select n "26 September 2016" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_select \- loop over the result of a query
.SH SYNOPSIS
.nf

pg_select [\*(T<\-rowbyrow\*(T>] [\*(T<\-nodotfields\*(T>] [\*(T<\-withoutnulls\*(T>] [\*(T<\-paramarray var\*(T>] [\*(T<\-params\*(T> paramList] \*(T<conn\*(T> \*(T<commandString\*(T> \*(T<arrayVar\*(T> \*(T<procedure\*(T>
.fi
.SH DESCRIPTION
\*(T<\fBpg_select\fR\*(T> submits a query
(\fBSELECT\fR statement) to the
PostgreSQL server and executes a given
chunk of code for each row in the result. The
\*(T<commandString\*(T> must be a
\fBSELECT\fR statement; anything else returns an
error. The \*(T<arrayVar\*(T> variable is an array
name used in the loop. For each row,
\*(T<arrayVar\*(T> is filled in with the row values,
using the column names as the array indices. Then the
\*(T<procedure\*(T> is executed.
.PP
In addition to the column values, the following special entries are
made in the array (unless the [-nodotfields] flag is provided):
.TP 
\*(T<\&.headers\*(T>
A list of the column names returned by the query.
.TP 
\*(T<\&.numcols\*(T>
The number of columns returned by the query.
.TP 
\*(T<\&.tupno\*(T>
The current row number, starting at zero and incrementing for
each iteration of the loop body.
.PP
If the [-param] flag is provided, then it contains a list of parameters that will replace "$1", "$2" and so
on in the query string, as if it were a prepared statement. Be sure to properly escape or quote the "$" in the query. :)
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear.
.PP
Notes: This substitution is performed by generating a positional parameter list and calling PQExecParams with a modified query containing
$1, $2, ... where the original `names` appeared. This is a straight substitution, so if this mechanism is used the back-quote
character (`) can not appear elsewhere in the query, even in a quoted string. There are a maximum of 99,999 names.
.SH ARGUMENTS
.TP 
[-rowbyrow]
Perform the select in row-by-row mode. This means that the code block is called immediately results
become available, rather than waiting for the query to complete. 
.TP 
[-nodotfields]
Suppress generation of the pseudo-fields .headers, .numcols, and .tupno.
.TP 
[-withoutnulls]
If specified null columns will be unset from the array rather than being defined and containing the null string, typically an empty string.
.TP 
\*(T<conn\*(T>
The handle of the connection on which to execute the query.
.TP 
\*(T<commandString\*(T>
The SQL query to execute.
.TP 
\*(T<arrayVar\*(T>
An array variable for returned rows.
.TP 
\*(T<procedure\*(T>
The procedure to run for each returned row.
.SH "RETURN VALUE"
None
.SH EXAMPLES
This examples assumes that the table \*(T<table1\*(T> has
columns \*(T<control\*(T> and \*(T<name\*(T> (and
perhaps others):

.nf
\*(T<
pg_select $pgconn "SELECT * FROM table1;" array {
    puts [format "%5d %s" $array(control) $array(name)]
}
\*(T>
.fi
