.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_null_value_string n "26 September 2016" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_null_value_string \- define a value to be returned for NULL fields distinct from the default value of an empty string. 
.SH SYNOPSIS
.nf

pg_null_value_string [\*(T<string\*(T>]
.fi
.SH DESCRIPTION
\*(T<\fBpg_null_value_string\fR\*(T> sets or retrieves a string to
be returned in query results for fields whose value is NULL, making it
possible to distinguish between NULL values an values that are not null
but are comprised of an empty string. Without setting an alternative
null value with this or with pg_result's -null_value_string, it is
impossible to tell the difference between a NULL field value and one that
is not null but empty.
.SH ARGUMENTS
.TP 
\*(T<string\*(T>
The string to be set that will be returned for null fields.
.SH "RETURN VALUE"
Returns the string that is currently being returned for null fields.
It will be the passed string value if one was passed, or, otherwise,
the value currently being used.
