static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2017 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (wavelength, _(\"wavelength\"), 142.0)                        \n"
"                 value_range (0.0, 200.0)                                     \n"
"                                                                              \n"
"property_double (turbulence, _(\"turbulence\"), 0.0)                          \n"
"                 value_range (0.0, 1.0)  // rename to wave-pinch?             \n"
"                                                                              \n"
"property_double (blocksize, _(\"blocksize\"), -1.0)                           \n"
"                 value_range (-1.0, 64.0)                                     \n"
"                 description (_(\"number of wavelengths per local period\"))  \n"
"                                                                              \n"
"property_double (twist, _(\"black and green angle\"), 0.5)                    \n"
"                 value_range (-10.0, 10.0)                                    \n"
"              description (_(\"angle offset for patterns\"))                  \n"
"                                                                              \n"
"property_double (twist2, _(\"red and cyan angle\"), 0.166766661)              \n"
"                 value_range (-10.0, 10.0)                                    \n"
"property_double (twist3, _(\"blue and magenta angle\"), 0.84351)              \n"
"                 value_range (-10.0, 10.0)                                    \n"
"property_double (twist4, _(\"yellow angle\"), 0.0)                            \n"
"                 value_range (-10.0, 10.0)                                    \n"
"                                                                              \n"
"property_int (inks, _(\"inks\"), 1)                                           \n"
"              value_range (1, 4)                                              \n"
"              description (_(\"How many inks to use just black, rg, rgb(additive) or cmyk\"))\n"
"                                                                              \n"
"property_double (angleboost, _(\"angleboost\"), 0.0)                          \n"
"                 value_range (0.0, 4.0)                                       \n"
"              description (_(\"angle offset for patterns\"))                  \n"
"                                                                              \n"
"property_int (pattern, _(\"pattern\"), 3)                                     \n"
"              value_range (0, 16)                                             \n"
"              description (_(\"halftoning pattern\"))                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     spachromyzer                                         \n"
"#define GEGL_OP_C_SOURCE spachromyzer.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"CIE LCH(ab) float\"));\n"
"  //gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static inline float dmodf(float x, float y)                                   \n"
"{                                                                             \n"
"  return x - y * floorf(x/y);                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"#define fmodf dmodf                                                           \n"
"                                                                              \n"
"static                                                                        \n"
"float spachromyze (                                                           \n"
"    float x,                                                                  \n"
"    float y,                                                                  \n"
"    float l,                                                                  \n"
"    float c,                                                                  \n"
"    float h,                                                                  \n"
"    int   pattern,                                                            \n"
"    float wavelength,                                                         \n"
"    float turbulence,                                                         \n"
"    float blocksize,                                                          \n"
"    float angleboost,                                                         \n"
"    float twist)                                                              \n"
"{                                                                             \n"
"  float aa  = 3.0;                                                            \n"
"  float acc = 0.0;                                                            \n"
"  float luminance  = l;                                                       \n"
"  float chroma     = c;                                                       \n"
"  float hue        = h;                                                       \n"
"                                                                              \n"
"  float part_white = luminance;                                               \n"
"  float offset     = chroma;                                                  \n"
"  float angle      = (1.0-(hue * angleboost) + twist);                        \n"
"                                                                              \n"
"  float width      = (wavelength * (1.0 - turbulence) +                       \n"
"                     (wavelength * offset) * turbulence);                     \n"
"                                                                              \n"
"  float vec0 = cosf (-angle * 3.14151 / 2.0);                                 \n"
"  float vec1 = sinf (-angle * 3.14151 / 2.0);                                 \n"
"  float aa_sq = aa * aa;                                                      \n"
"                                                                              \n"
"  x += wavelength;                                                            \n"
"  y += wavelength;                                                            \n"
"                                                                              \n"
"  for (float xi = 0.0; xi < aa; xi += 1.0)                                    \n"
"  {                                                                           \n"
"    float u = fmodf (x + xi/aa + 0.5 * width, blocksize * width);             \n"
"    for (float yi = 0.0; yi < aa; yi += 1.0)                                  \n"
"    {                                                                         \n"
"      float v = fmodf (y + yi/aa + 0.5 * width, blocksize * width);           \n"
"      float w = vec0 * u + vec1 * v;                                          \n"
"      float q = vec1 * u - vec0 * v;                                          \n"
"                                                                              \n"
"      float wperiod = fmodf (w, width);                                       \n"
"      float wphase  = (wperiod / width) * 2.0 - 1.0;                          \n"
"                                                                              \n"
"      float qperiod = fmodf (q, width);                                       \n"
"      float qphase  = (qperiod / width) * 2.0 - 1.0;                          \n"
"                                                                              \n"
"      if (pattern == 0) {      /* line */                                     \n"
"        if (fabsf (wphase) < part_white)                                      \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"      else if (pattern == 1) { /* dot */                                      \n"
"        if (qphase * qphase + wphase * wphase <                               \n"
"          part_white * part_white * 2.0)                                      \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"      else if (pattern == 2) { /* diamond */                                  \n"
"        if (fabsf(wphase) + fabsf(qphase) < (part_white * 2) )                \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"      else if (pattern == 3) { /* dot-to-diamond-to-dot */                    \n"
"          float ax = fabsf (wphase ) ;                                        \n"
"          float ay = fabsf (qphase ) ;                                        \n"
"          float v = 0.0;                                                      \n"
"                                                                              \n"
"          if  (ax + ay > 1.0)                                                 \n"
"          {                                                                   \n"
"            v = 2.0-(((ay - 1.0) * (ay - 1.0) + (ax - 1.0) * (ax - 1.0)));    \n"
"          }                                                                   \n"
"          else                                                                \n"
"          {                                                                   \n"
"            v = (ay * ay + ax * ax);                                          \n"
"          }                                                                   \n"
"          v/=2.0;                                                             \n"
"          if (v < part_white)                                                 \n"
"            acc = acc + 1.0 / aa_sq;                                          \n"
"      } else if (pattern == 4)                                                \n"
"      {                                                                       \n"
"        if (fabsf (wphase) < part_white)                                      \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"        else if (fabsf (qphase) < part_white)                                 \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"    }                                                                         \n"
"  }                                                                           \n"
"  return acc;                                                                 \n"
"}                                                                             \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *in_pixel = in_buf;                                              \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"                                                                              \n"
"  gint        x = roi->x; /* initial x         */                             \n"
"  gint        y = roi->y; /* and y coordinates */                             \n"
"  gfloat blocksize = o->blocksize;                                            \n"
"  if (blocksize < 0.0)                                                        \n"
"    blocksize = 819200.0;                                                     \n"
"                                                                              \n"
"  switch (o->inks)                                                            \n"
"  {                                                                           \n"
"    case 0:                                                                   \n"
"    case 1:                                                                   \n"
"    case 2:                                                                   \n"
"       while (n_pixels--)                                                     \n"
"         {                                                                    \n"
"           float luminance  = in_pixel[0] / 100.0;                            \n"
"           float chroma     = in_pixel[1] / 100.0;//fabs(in_pixel[1]-in_pixel[0]);\n"
"           float hue        = in_pixel[2] / 360.0;                            \n"
"  //         luminance = x / 2848.0;                                          \n"
"           float acc = spachromyze(x, y,                                      \n"
"                                   luminance, chroma, hue,                    \n"
"                                   o->pattern,                                \n"
"                                   o->wavelength / (1.0*(1<<level)),          \n"
"                                   o->turbulence,                             \n"
"                                   blocksize,                                 \n"
"                                   o->angleboost,                             \n"
"                                   o->twist);                                 \n"
"           for (int c = 0; c < 3; c++)                                        \n"
"             out_pixel[c] = acc;                                              \n"
"                                                                              \n"
"           out_pixel[3] = 1.0;                                                \n"
"           out_pixel += 4;                                                    \n"
"           in_pixel  += 4;                                                    \n"
"                                                                              \n"
"           /* update x and y coordinates */                                   \n"
"           x++; if (x>=roi->x + roi->width) { x=roi->x; y++; }                \n"
"         }                                                                    \n"
"       break;                                                                 \n"
"    case 3:                                                                   \n"
"       while (n_pixels--)                                                     \n"
"         {                                                                    \n"
"           out_pixel[0] = spachromyze(x, y,                                   \n"
"                                   in_pixel[0], 0.0, 0.0,                     \n"
"                                   o->pattern,                                \n"
"                                   o->wavelength / (1.0*(1<<level)),          \n"
"                                   o->turbulence,                             \n"
"                                   blocksize,                                 \n"
"                                   o->angleboost,                             \n"
"                                   o->twist2);                                \n"
"           out_pixel[1] = spachromyze(x, y,                                   \n"
"                                   in_pixel[1], 0.0, 0.0,                     \n"
"                                   o->pattern,                                \n"
"                                   o->wavelength / (1.0*(1<<level)),          \n"
"                                   o->turbulence,                             \n"
"                                   blocksize,                                 \n"
"                                   o->angleboost,                             \n"
"                                   o->twist);                                 \n"
"           out_pixel[2] = spachromyze(x, y,                                   \n"
"                                   in_pixel[2], 0.0, 0.0,                     \n"
"                                   o->pattern,                                \n"
"                                   o->wavelength / (1.0*(1<<level)),          \n"
"                                   o->turbulence,                             \n"
"                                   blocksize,                                 \n"
"                                   o->angleboost,                             \n"
"                                   o->twist3);                                \n"
"           out_pixel[3] = 1.0;                                                \n"
"           out_pixel += 4;                                                    \n"
"           in_pixel  += 4;                                                    \n"
"                                                                              \n"
"           /* update x and y coordinates */                                   \n"
"           x++; if (x>=roi->x + roi->width) { x=roi->x; y++; }                \n"
"         }                                                                    \n"
"       break;                                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/spachromyzer.cl.h\"                                         \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"/* OpenCL processing function */                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            int                  level)                                       \n"
"{                                                                             \n"
"  const size_t  gbl_size[2] = {roi->width, roi->height};                      \n"
"  const size_t  gbl_offs[2] = {roi->x, roi->y};                               \n"
"                                                                              \n"
"  GeglProperties   *o  = GEGL_PROPERTIES (op);                                \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"gegl_spachromyzer\", NULL};              \n"
"      cl_data = gegl_cl_compile_and_build (spachromyzer_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"  {                                                                           \n"
"    g_warning (\"cl fail\\n\");                                               \n"
"    CL_CHECK;                                                                 \n"
"    return 1;                                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_int),   (void*)&o->pattern);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float), (void*)&o->wavelength);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_float), (void*)&o->turbulence);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_float), (void*)&o->blocksize);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 6, sizeof(cl_float), (void*)&o->angleboost);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 7, sizeof(cl_float), (void*)&o->twist);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        gbl_offs, gbl_size, NULL,             \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  operation_class->prepare = prepare;                                         \n"
"#if 0                                                                         \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"#endif                                                                        \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:spachromyzer\",                            \n"
"    \"title\",              _(\"spachromyzer\"),                              \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\" ,        \"render\",                                       \n"
"    \"reference-hash\",     \"cc9c401d7c8bcea7147499ecbeda9986\",             \n"
"    \"description\",        _(\"Spatial Chroma Pattern Synteheziser, turns colors into pattern\"),\n"
"    \"position-dependent\", \"true\",                                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
