static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2008 James Legg                                                  \n"
" */                                                                           \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER                                                \n"
"#define GEGL_OP_C_SOURCE weighted-blend.c                                     \n"
"#define GEGL_OP_NAME     weighted_blend                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"aux\", format);                     \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/weighted-blend.cl.h\"                                       \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *self,                                        \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               aux_tex,                                     \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  gint cl_err = 0;                                                            \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"cl_copy_weigthed_blend\",                \n"
"                                   \"cl_weighted_blend\",                     \n"
"                                   NULL};                                     \n"
"      cl_data = gegl_cl_compile_and_build (weighted_blend_cl_source,          \n"
"                                           kernel_name);                      \n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"                                                                              \n"
"  if (!aux_tex)                                                               \n"
"    {                                                                         \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem), (void*)&in_tex);\n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem), (void*)&out_tex);\n"
"      CL_CHECK;                                                               \n"
"                                                                              \n"
"      cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),      \n"
"                                           cl_data->kernel[0], 1,             \n"
"                                           NULL, &global_worksize, NULL,      \n"
"                                           0, NULL, NULL);                    \n"
"      CL_CHECK;                                                               \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 0, sizeof(cl_mem), (void*)&in_tex);\n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 1, sizeof(cl_mem), (void*)&aux_tex);\n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clSetKernelArg(cl_data->kernel[1], 2, sizeof(cl_mem), (void*)&out_tex);\n"
"      CL_CHECK;                                                               \n"
"                                                                              \n"
"      cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),      \n"
"                                           cl_data->kernel[1], 1,             \n"
"                                           NULL, &global_worksize, NULL,      \n"
"                                           0, NULL, NULL);                    \n"
"      CL_CHECK;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *aux_buf,                                        \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  gfloat *in  = in_buf;                                                       \n"
"  gfloat *out = out_buf;                                                      \n"
"  gfloat *aux = aux_buf;                                                      \n"
"  gint    i;                                                                  \n"
"                                                                              \n"
"  if (aux == NULL)                                                            \n"
"    {                                                                         \n"
"      /* there is no auxilary buffer.                                         \n"
"       * output the input buffer.                                             \n"
"       */                                                                     \n"
"      for (i = 0; i < n_pixels; i++)                                          \n"
"        {                                                                     \n"
"          gint j;                                                             \n"
"          for (j = 0; j < 4; j++)                                             \n"
"            {                                                                 \n"
"              out[j] = in[j];                                                 \n"
"            }                                                                 \n"
"          in  += 4;                                                           \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      for (i=0; i<n_pixels; i++)                                              \n"
"        {                                                                     \n"
"          gint   j;                                                           \n"
"          gfloat total_alpha;                                                 \n"
"          /* find the proportion between alpha values */                      \n"
"          total_alpha = in[3] + aux[3];                                       \n"
"          if (!total_alpha)                                                   \n"
"            {                                                                 \n"
"              /* no coverage from any source pixel */                         \n"
"              for (j = 0; j < 4; j++)                                         \n"
"                {                                                             \n"
"                  out[j] = 0.0;                                               \n"
"                }                                                             \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              /* the total alpha is non-zero, therefore we may find a colour from a weighted blend */\n"
"              gfloat in_weight = in[3] / total_alpha;                         \n"
"              gfloat aux_weight = 1.0 - in_weight;                            \n"
"              for (j = 0; j < 3; j++)                                         \n"
"                {                                                             \n"
"                  out[j] = in_weight * in[j] + aux_weight * aux[j];           \n"
"                }                                                             \n"
"              out[3] = total_alpha;                                           \n"
"            }                                                                 \n"
"          in  += 4;                                                           \n"
"          aux += 4;                                                           \n"
"          out += 4;                                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass              *operation_class;                           \n"
"  GeglOperationPointComposerClass *point_composer_class;                      \n"
"                                                                              \n"
"  operation_class      = GEGL_OPERATION_CLASS (klass);                        \n"
"  point_composer_class = GEGL_OPERATION_POINT_COMPOSER_CLASS (klass);         \n"
"                                                                              \n"
"  point_composer_class->process    = process;                                 \n"
"  point_composer_class->cl_process = cl_process;                              \n"
"  operation_class->prepare         = prepare;                                 \n"
"  operation_class->opencl_support  = TRUE;                                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\" ,       \"gegl:weighted-blend\",                                 \n"
"    \"title\",       _(\"Weighted Blend\"),                                   \n"
"    \"categories\" , \"compositors:blend\",                                   \n"
"    \"reference-hash\", \"577a40b1a4c8fbe3e48407bc0c51304d\",                 \n"
"    \"description\",                                                          \n"
"      _(\"blend two images using alpha values as weights\"),                  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
