we're proud to announce the second release candidate for the upcoming 2.4 series of darktable, 2.4.0rc1!

as always, please don't use the autogenerated tarball provided by github, but only our tar.xz. the checksum is:

```
$ sha256sum darktable-2.4.0rc1.tar.xz
??? darktable-2.4.0rc1.tar.xz
$ sha256sum darktable-2.4.0rc1.dmg
??? darktable-2.4.0rc1.dmg
$ sha256sum darktable-2.4.0rc1.exe
??? darktable-2.4.0rc1.exe
```

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

## changes since rc0
* noise profile for Nikon D4
* Phase One IQ140 support
* macintosh packaging fixes
* lightroom import fixes


and the changelog as compared to 2.2.0 can be found below. Some of the fixes might have been backported to the stable 2.2.x series already.
- The maintainership of the RawSpeed library was transferred to the darktable project. The work on code cleanup, hardening, modernization, simplification and testing is ongoing.
- Well over 2 thousand commits to darktable+rawspeed since 2.2.0
- 244 pull requests handled
- 320+ issues closed
- Updated user manual is coming soon™

## Hell Froze Over
- As you might have read on our [news post](https://www.darktable.org/2017/08/darktable-for-windows/) we finally ported darktable to Windows and intend to support it in the future. At the moment it's still lacking a few features (for example there is not printing support), has a few limitations (tethering requires special drivers to be installed) and comes with its own set of bugs. But overall we are confident that it's quite usable already and hope you will enjoy it. A very special thanks goes to Peter Budai who finally convinced us to agree to the port and who did most of the work.

## The Big Ones
- A new module for haze removal
- The local contrast module can now be pushed much further, it also got a new local laplacian mode
- Add undo support for masks and more intelligent grouping of undo steps
- Blending now allows to display individual channels using false colors
- darktable now supports loading Fujifilm compressed RAFs
- darktable now supports loading floating point HDR DNGs as written by HDRMERGE
- We also added channel specific blend modes for Lab and RGB color spaces
- The base curve module allows for more control of the exposure fusion feature using the newly added bias slider
- The tonecurve module now supports auto colour adjustment in RGB
- Add absolute color input as an option to the color look up table module
- A new X-Trans demosaicing algorithm, Frequency Domain Chroma, was implemented.
- You can now choose from pre-defined scheduling profiles for OpenCL
- Speaking of OpenCL, darktable now allows to force-use OpenCL for a specific pixelpipe
- Xmp sidecar files are no longer written to disk when the content didn't actually change. That mostly helps with network storage and backup systems that use files' time stamps

## New Features And Changes
- Show a dialog window that tells when locking the database/library failed
- Don't shade the whole region on the map when searching for a location. Instead just draw a border around it.
- Also in map mode: Clear the search list and map indicators when resetting the search module.
- With OsmGPSMap newer than version 1.1.0 (i.e., anything released after that OsmGPSMap version) the map will show copyright info.
- Running jobs with a progressbar (mostly import and export) will show that progress bar ontop the window entry in your task bar – if the system supports it. It should work on GNOME, KDE and Windows at least.
- Add bash like string replacement for variables (export, watermark, session settings).
- Add a preferences option to ask before removing empty dirs
- The "colorbalance" module got a lot faster, thanks to SSE optimized code
- Make gradient sliders a little more colorful and use them in the white balance module
- Make PNG compression level used for exporting configurable
- On OSX, load single images from command line or via drag&drop in darkroom mode
- Add an option to omit the intermediate tag hierarchy in exported files and only add the last level
- In the watermark module, sort the list of SVG files and omit the file extension
- Support XYZ as a proofing profile
- Local contrast now got a new slider to set the midtone range
- darktable got two new helper scripts (those are not installed by default, grab them from the sources): One to purge thumbnails that no longer have an associated image in the database, and a second script that uses inotify to watch a folder for new files to open them in a running darktable instance.
- In the curve editors of base curve and tone curve you can now delete nodes with a right click and see coordinates of nodes while editing. Note that you can use keyboard modifiers ctrl and shift to change the precision of your changes
- Creating a new instance of a module can now be done with a quick click of the middle mouse button on the multi-instance icon
- New darktable installations on computers with more than 8 Gb of memory will now by default use half of that per module
- Several background colors and the brush color are now configurable in the CSS
- Some new cameras can bump the ISO level to insane highs. We try to follow as good as we can by no longer limiting it to 51200 in the GUI
- Base curve and the highlights module now support multiple instances and use blending and masks
- Having the `1` key toggle between 1 and 0 stars wasn't very popular with many people. You can disable that extra feature and have it behave like the other rating shortcuts now
- You can decide if you want to be asked before resetting the history stacks of images from the lighttable
- The grain module was slightly changed to have a more pleasing, photographic-paper like appearance
- Using the color look up table module you can now convert your images to monochrome, honoring the Helmholtz-Kohlrausch effect
- Some more small improvements were made

## Bugfixes
- Fix the problem with rating images by accident when moving the mouse while typing an image size in the export module
- Fix several oddities in folder and tag mode of the collect module.
- Print mode's color profile settings no longer interact with the export module
- Update the style lists when importing a style
- Fix some bugs with multiple module instances used in a style
- On OSX only the main window should be fullscreen, not the popups
- Some speedups with VERY big libraries or having A LOT OF tags
- Significantly speed up tagging many images
- Fix searching locations using OpenStreetMap
- Fix partial copies of large files in "import from camera"
- Fix a crash in the import dialog when using Lua to add widgets there
- Fix some false-positive warnings about another running darktable instance and it having locked the databases
- No longer switch to the favourite modules group when duplicating one of its modules
- Fix loading of XYZ files
- Fix Lab export when the profile was set from the lighttable
- Create tmp snapshot files with mode 0600 to stop other people looking at them
- Fix several bugs with Wayland. However, there are still issues, so darktable will prefer XWayland
- Google deprecated the Picasa Web API so it's no longer possible to create G+ albums
- Fix the default for sliders with target not being "red" in the channel mixer
- Fix the removing of directories
- Make the escape key cancel history dialogs
- Block keyboard accels when editing camera controls
- Properly delete XMP sidecars
- Make sure that the rating set in darktable is used for the exported file, not something set inside the raw file
- Don't re-write all XMP files when detaching a tag
- Sync XMPs when a tag is removed from the database
- Sync XMPs after a tag is attached/detached via the Lua API
- Many more bugs got fixed

## Lua
- darktable now uses Lua 5.3. The bundled copy got updated accordingly
- Add dt.print_log. It's like print_error but without the ERROR prefix
- Reorder callback parameters for intermediate export image: add the actual image to the parameters of the event
- Call lua post-import-image event synchronously
- Add darktable.configuration.running_os to detect the OS darktable is running on
- New widget type: section_label, adds a label which looks like a section change

## Changed Dependencies
- CMake 3.1 is now required.
- In order to compile darktable you now need at least gcc-4.9+/clang-3.4+, and gcc-5.0+ is *highly* recommended.
- ZLIB is now required for the DNG Deflate compressed raw support.
- darktable now uses Lua 5.3

### Camera support, compared to 2.2.0

#### Warning: support for Nikon NEF 'lossy after split' raws was unintentionally broken due to the lack of such samples. Please see [this post](https://discuss.pixls.us/t/nikon-a-specific-raw-sample-wanted/5483?u=lebedevri) for more details. If you have affected raws, please contribute samples!

## Base Support:

- Canon EOS 200D
- Canon EOS Kiss X9
- Canon EOS Rebel SL2
- Canon EOS 6D Mark II (sRaw1, sRaw2)
- Canon EOS 77D
- Canon EOS 9000D
- Canon EOS 800D
- Canon EOS Kiss X9i
- Canon EOS Rebel T7i
- Canon EOS M100
- Canon EOS M5
- Canon EOS M6
- Canon PowerShot G9 X Mark II
- Canon PowerShot SX40 HS (dng)
- Fujifilm GFX 50S (compressed)
- Fujifilm X-A3
- Fujifilm X-E2S
- Fujifilm X-E3 (compressed)
- Fujifilm X-Pro2 (compressed)
- Fujifilm X-T2 (compressed)
- Fujifilm X-T20 (compressed)
- Fujifilm X100F (compressed)
- GITUP GIT2P (chdk-a, chdk-b)
- Kodak EasyShare Z980
- LG D855 (dng)
- LG H815 (dng)
- LG Nexus 5X (dng)
- LG US996 (dng)
- LG VS995 (dng)
- Leica D-LUX (Typ 109) (4:3, 3:2, 16:9, 1:1)
- Leica X2 (dng)
- Nikon COOLPIX B700 (12bit-uncompressed)
- Nikon D500 (14bit-uncompressed, 12bit-uncompressed)
- Nikon D5600 (12bit-compressed, 12bit-uncompressed, 14bit-compressed, 14bit-uncompressed)
- Nikon D7500 (12bit-compressed, 14bit-compressed)
- Nikon D850 (12bit-compressed, 12bit-uncompressed, 14bit-compressed, 14bit-uncompressed)
- Nikon LS-5000 (dng)
- Nokia Lumia 1020 (dng)
- Olympus E-M10 Mark III
- Olympus E-M1MarkII
- Olympus TG-5
- Panasonic DC-FZ82 (4:3)
- Panasonic DMC-FZ80 (4:3)
- Panasonic DMC-FZ85 (4:3)
- Panasonic DC-GH5 (4:3)
- Panasonic DC-FZ91 (4:3)
- Panasonic DC-FZ92 (4:3)
- Panasonic DC-FZ93 (4:3)
- Panasonic DC-TZ90 (4:3)
- Panasonic DC-ZS70 (4:3)
- Panasonic DMC-FZ330 (4:3)
- Panasonic DMC-GF6 (16:9, 3:2, 1:1)
- Panasonic DMC-TZ61 (4:3, 3:2, 1:1, 16:9)
- Panasonic DMC-ZS40 (4:3, 3:2, 1:1, 16:9)
- Panasonic DMC-TZ80 (4:3)
- Panasonic DMC-TZ81 (4:3)
- Panasonic DMC-TZ85 (4:3)
- Panasonic DMC-ZS60 (4:3)
- Pentax K-5 (dng)
- Pentax K-r (dng)
- Pentax K10D (dng)
- Phase One IQ140
- Samsung G920F
- Samsung G935F
- Samsung GX10
- Sony ILCE-6500
- Sony ILCE-9

## White Balance Presets:

- Canon EOS 6D Mark II
- Fujifilm X-T20
- Fujifilm X100F
- Nikon 1 AW1
- Nikon Coolpix A
- Panasonic DMC-GX80
- Panasonic DMC-GX85
- Panasonic DMC-TZ100
- Panasonic DMC-TZ101
- Panasonic DMC-TZ110
- Panasonic DMC-ZS110
- Pentax K-3 II

## Noise Profiles:

- Canon EOS 1300D
- Canon EOS Kiss X80
- Canon EOS Rebel T6
- Canon EOS 5D Mark IV
- Canon EOS 6D Mark II
- Canon EOS M5
- Canon PowerShot G16
- Canon PowerShot G3 X
- Canon PowerShot G7 X Mark II
- Canon PowerShot G9 X Mark II
- Fujifilm X-M1
- Fujifilm X-Pro1
- Fujifilm X-T20
- Leica X2
- Nikon Coolpix A
- Nikon D2X
- Nikon D3000
- Nikon D3400
- Nikon D4
- Nikon D500
- Olympus E-M1MarkII
- Olympus E-P5
- Panasonic DMC-FZ200
- Panasonic DMC-FZ300
- Panasonic DMC-G7
- Panasonic DMC-G70
- Panasonic DMC-G8
- Panasonic DMC-G80
- Panasonic DMC-G81
- Panasonic DMC-G85
- Panasonic DMC-GX80
- Panasonic DMC-GX85
- Panasonic DMC-LX100
- Panasonic DMC-TZ100
- Panasonic DMC-TZ101
- Panasonic DMC-TZ110
- Panasonic DMC-ZS110
- Pentax K-70
- Sony DSC-RX100M5
- Sony ILCA-68
- Sony ILCE-5000
- Sony ILCE-6500

## Updated Translations
- Dutch
- French
- German
- Hebrew
- Russian
- Spanish
