/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/SchemaTypesXml/ClassIdentifierXml.h"

#include "Doc/SchemaTypesDoc/CClassIdentifierDoc.h"
#include "Doc/SchemaTypesDoc/CClassInstancePropertyDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/ClassInstancePropertyXml.h"

using namespace Caf;

void ClassInstancePropertyXml::add(
	const SmartPtrCClassInstancePropertyDoc classInstancePropertyDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassInstancePropertyXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(classInstancePropertyDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameVal = classInstancePropertyDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::deque<SmartPtrCClassIdentifierDoc> typeVal =
			classInstancePropertyDoc->getType();
		CAF_CM_VALIDATE_STL(typeVal);

		if (! typeVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCClassIdentifierDoc> > typeIter(typeVal);
				typeIter; typeIter++) {
				const SmartPtrCXmlElement typeXml =
					thisXml->createAndAddElement("type");
				ClassIdentifierXml::add(*typeIter, typeXml);
			}
		}

		const std::string requiredVal = classInstancePropertyDoc->getRequired() ? "true" : "false";
		if (! requiredVal.empty()) {
			thisXml->addAttribute("required", requiredVal);
		}

		const std::string transientValVal = classInstancePropertyDoc->getTransientVal() ? "true" : "false";
		if (! transientValVal.empty()) {
			thisXml->addAttribute("transient", transientValVal);
		}

		const std::string listVal = classInstancePropertyDoc->getList() ? "true" : "false";
		if (! listVal.empty()) {
			thisXml->addAttribute("list", listVal);
		}

		const std::string displayNameVal = classInstancePropertyDoc->getDisplayName();
		if (! displayNameVal.empty()) {
			thisXml->addAttribute("displayName", displayNameVal);
		}

		const std::string descriptionVal = classInstancePropertyDoc->getDescription();
		if (! descriptionVal.empty()) {
			thisXml->addAttribute("description", descriptionVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCClassInstancePropertyDoc ClassInstancePropertyXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassInstancePropertyXml", "parse");

	SmartPtrCClassInstancePropertyDoc classInstancePropertyDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const CXmlElement::SmartPtrCElementCollection typeChildrenXml =
			thisXml->findRequiredChildren("type");

		std::deque<SmartPtrCClassIdentifierDoc> typeVal;
		if (! typeChildrenXml.IsNull() && ! typeChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> typeXmlIter(*typeChildrenXml);
				typeXmlIter; typeXmlIter++) {
				const SmartPtrCXmlElement typeXml = typeXmlIter->second;
				const SmartPtrCClassIdentifierDoc typeDoc =
					ClassIdentifierXml::parse(typeXml);
				typeVal.push_back(typeDoc);
			}
		}

		const std::string requiredStrVal =
			thisXml->findOptionalAttribute("required");
		bool requiredVal = false;
		if (! requiredStrVal.empty()) {
			requiredVal = (requiredStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string transientValStrVal =
			thisXml->findOptionalAttribute("transient");
		bool transientValVal = false;
		if (! transientValStrVal.empty()) {
			transientValVal = (transientValStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string listStrVal =
			thisXml->findOptionalAttribute("list");
		bool listVal = false;
		if (! listStrVal.empty()) {
			listVal = (listStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string displayNameStrVal =
			thisXml->findOptionalAttribute("displayName");
		const std::string displayNameVal = displayNameStrVal;

		const std::string descriptionStrVal =
			thisXml->findOptionalAttribute("description");
		const std::string descriptionVal = descriptionStrVal;

		classInstancePropertyDoc.CreateInstance();
		classInstancePropertyDoc->initialize(
			nameVal,
			typeVal,
			requiredVal,
			transientValVal,
			listVal,
			displayNameVal,
			descriptionVal);
	}
	CAF_CM_EXIT;

	return classInstancePropertyDoc;
}

