/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CAddInsDoc.h"
#include "Doc/CafCoreTypesDoc/CLoggingLevelCollectionDoc.h"
#include "Doc/CafCoreTypesDoc/CRequestConfigDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/RequestConfigXml.h"
#include "Doc/DocXml/CafCoreTypesXml/AddInsXml.h"
#include "Doc/DocXml/CafCoreTypesXml/LoggingLevelCollectionXml.h"

using namespace Caf;

void RequestConfigXml::add(
	const SmartPtrCRequestConfigDoc requestConfigDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("RequestConfigXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(requestConfigDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string responseFormatTypeVal = requestConfigDoc->getResponseFormatType();
		CAF_CM_VALIDATE_STRING(responseFormatTypeVal);
		thisXml->addAttribute("responseFormatType", responseFormatTypeVal);

		const SmartPtrCAddInsDoc requestProcessorAddInsVal =
			requestConfigDoc->getRequestProcessorAddIns();
		if (! requestProcessorAddInsVal.IsNull()) {
			const SmartPtrCXmlElement requestProcessorAddInsXml =
				thisXml->createAndAddElement("requestProcessorAddIns");
			AddInsXml::add(requestProcessorAddInsVal, requestProcessorAddInsXml);
		}

		const SmartPtrCAddInsDoc responseProcessorAddInsVal =
			requestConfigDoc->getResponseProcessorAddIns();
		if (! responseProcessorAddInsVal.IsNull()) {
			const SmartPtrCXmlElement responseProcessorAddInsXml =
				thisXml->createAndAddElement("responseProcessorAddIns");
			AddInsXml::add(responseProcessorAddInsVal, responseProcessorAddInsXml);
		}

		const SmartPtrCLoggingLevelCollectionDoc loggingLevelCollectionVal =
			requestConfigDoc->getLoggingLevelCollection();
		if (! loggingLevelCollectionVal.IsNull()) {
			const SmartPtrCXmlElement loggingLevelCollectionXml =
				thisXml->createAndAddElement("loggingLevelCollection");
			LoggingLevelCollectionXml::add(loggingLevelCollectionVal, loggingLevelCollectionXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCRequestConfigDoc RequestConfigXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("RequestConfigXml", "parse");

	SmartPtrCRequestConfigDoc requestConfigDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string responseFormatTypeStrVal =
			thisXml->findRequiredAttribute("responseFormatType");
		const std::string responseFormatTypeVal = responseFormatTypeStrVal;

		const SmartPtrCXmlElement requestProcessorAddInsXml =
			thisXml->findOptionalChild("requestProcessorAddIns");

		SmartPtrCAddInsDoc requestProcessorAddInsVal;
		if (! requestProcessorAddInsXml.IsNull()) {
			requestProcessorAddInsVal = AddInsXml::parse(requestProcessorAddInsXml);
		}

		const SmartPtrCXmlElement responseProcessorAddInsXml =
			thisXml->findOptionalChild("responseProcessorAddIns");

		SmartPtrCAddInsDoc responseProcessorAddInsVal;
		if (! responseProcessorAddInsXml.IsNull()) {
			responseProcessorAddInsVal = AddInsXml::parse(responseProcessorAddInsXml);
		}

		const SmartPtrCXmlElement loggingLevelCollectionXml =
			thisXml->findOptionalChild("loggingLevelCollection");

		SmartPtrCLoggingLevelCollectionDoc loggingLevelCollectionVal;
		if (! loggingLevelCollectionXml.IsNull()) {
			loggingLevelCollectionVal = LoggingLevelCollectionXml::parse(loggingLevelCollectionXml);
		}

		requestConfigDoc.CreateInstance();
		requestConfigDoc->initialize(
			responseFormatTypeVal,
			requestProcessorAddInsVal,
			responseProcessorAddInsVal,
			loggingLevelCollectionVal);
	}
	CAF_CM_EXIT;

	return requestConfigDoc;
}

