# Node Foundation CTC Meeting 2015-11-11

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2015-11-11
* **GitHub Issue**: https://github.com/nodejs/node/issues/3777
* **Minutes Google Doc**: <https://docs.google.com/document/d/1tkZ4BV9h7jbbbVBU8hLoLHw9cEgAOt3gtgKXxU8AUh0>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1BlgxBLqnoK6slwAkGXUcIy7CFh1m9ZyLo_D_ABcw6vc>_

## Present

* Rod Vagg (CTC)
* James Snell (CTC)
* Ben Noordhuis (CTC)
* Jeremiah Senkpiel (CTC)
* Trevor Norris (CTC)
* Mikeal Rogers (observer)
* Fedor Indutny (CTC)
* Ben Noordhuis (CTC)
* Colin Ihrig (CTC)
* Steven R Loomis (observer?)
* Brian White (CTC)
* Michael Dawson (observer)

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

* Rediscuss if error message changes are semver-major [#3776](https://github.com/nodejs/node/issues/3776)
* V8 working group [#3741](https://github.com/nodejs/node/issues/3741)

### Standup

* Rod Vagg: Way too busy, tz lagged. Nodefest JP (with translation)- good community event, large turnout. Ripe for node expansion. Hung out with Shigeki and Yosuke. 0.12 build stuff, Jenkins down but coming back up. Good changes, but put behind with 0.10/0.12 stuff
* James Snell: triaging issues, not a whole lot more beyond 4.2.2. CITGM with Myles, landing PRs.
* Ben Noordhuis: Fixed bug in cluster module, libuv minor work, reviewed lots of PRs/issues. Looking into node-gyp - lots of confusion around python requirement on Windows. Idea: embed in python interpreter, but complicated adventure.
* Jeremiah Senkpiel: Issue/PR work. 5.1.0 release work (delayed). Helping potential new collaborators get involved.
* Trevor Norris: Submitted patch for microbenchmark improvements, removing `Object::Set()` in C++. Helping community members get involved.
* Mikeal Rogers: Rewriting policies. Last-month contributors script, metrics.
* Fedor Indutny: v8 stuff. Tool for postmortem inspection of nodejs process using lldb on linux and osx. Review, requests.
* Colin Ihrig: Reviews, PRs. Opened a very popular PR on cluster suicide.
* Steven R Loomis: Unicode conferences and meetings for the last few weeks, not a lot to report other than moving the iojs language groups to node.js versions. (#2525)
* Brian White: reviewing PRs, triaging, commenting on issues
* Michael Dawson: PR for AIX based on comments, test issues, ppc release machines added to CI, work with Stefan on FIPS PR (unique value - equivalent coverage with FIPS enabled/disabled, and better error message).

### Rediscuss if error message changes are semver-major [#3776](https://github.com/nodejs/node/issues/3776)

Mikeal: do not guarantee that error messages don’t change.  v8 changes error messages. don’t [shouldn’t] check message text.

Rod: Don’t think we can make an assumption that this is not done.

Mikeal: this is a lot of messages changing all at once

Rod: What about localized messages? (when they change)

Jeremiah: Localized messages have an ID so that shouldn’t be an issue

Trevor: if v8 doesn’t internationalize, we shouldn’t internationalize ours

James: Looking at i18n [l10n] of v8’s messages… comes down to whether ICU will be there by default

Mikeal: should we be attaaching IDs to messages now?

_: Error code (such as in Visual Studio) makes it very googleable which is a great help

Steven: that’s one of the benefits..

Trevor: how do you guarantee uniqueness?

Mikeal: attach a unique code..

Rod: Have 2 files that collect the codes.

Trevor: Pass a function name and string..?

Rod: … consider this for our API

Mikeal: don’t know how we can keep these from changing in the context of internationalization

Rod: But they are not internationalized yet. Can say now, don’t depend on these saying a certain thing.

Mikeal: we haven’t been aware of libuv’s changes , would need to keep track of libuv’s changes.

Michael: will this make it hard to fix typos in messages? Would be nice to correct instead of leave the message as is.

Jeremiah: If people need to check the text for something other than tests, not assigning a unique enough type of error. Seems like bad practice.

Rod: people do bad things already…

Jeremiah: make sure people don’t *need* to do these things for legitimate reasons

Rod: Not fine with semver-major if we decide it’s not a change in general.

Steven: make it major to put people on notice… ? ids may be good and helpful in general?

Mikeal: semver-major could make people think they can depend on message text …… hold off on any text changes until ID in place?

Mikeal: would not accept this in LTS. Question is, would we accept it for 5?

Rod: policy could say: “will accept changes as semver-patch, but don’t put them into LTS”

Mikeal: make it semver-minor, consider it a feature. … get this out as Canary (master) … leave tagged

### V8 working group [#3741](https://github.com/nodejs/node/issues/3741)

Ben: place to put v8 documentation

Jeremiah: make sure that some v8 knowledge stays among the core collaborators

Rod: Julien’s concern is around reducing exposure to v8

Michael: Want to involve more people in v8

Rod: The other way, a separate WG allows people to find the right people

Jeremiah: Documentation  (of v8)

Rod: no firm objections

Steven: Have WG charter include disseminating knowledge/processes around v8?

Rod: WG allows a good place to do this.


### ICU data - ±1 on approach?
[#3460](https://github.com/nodejs/node/issues/3460) ? srl

…  “move ahead, open PR, people can discuss.. mark as experimental so that people don’t depend on it”

[Chris is taking over note-taking.]

Rod: Take this to GitHub so we can have a proper discussion

## Next Meeting

November 18th, 2015
