/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteServiceCallable;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SDeadlockException;
import com.sleepycat.client.SHeapFullException;
import com.sleepycat.client.SLockNotGrantedException;
import com.sleepycat.client.SMetaCheckSumFailException;
import com.sleepycat.client.SResourceInUseException;
import com.sleepycat.client.SRunRecoveryException;
import com.sleepycat.client.SVersionMismatchException;
import com.sleepycat.thrift.TDatabaseException;
import com.sleepycat.thrift.TFileNotFoundException;
import com.sleepycat.thrift.TIOException;
import com.sleepycat.thrift.TResourceInUseException;
import com.sleepycat.thrift.TRuntimeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.thrift.TException;

interface RemoteCallHelper {
    default public <V> V remoteCallWithIOException(RemoteServiceCallable<V> remoteServiceCallable) throws IOException {
        try {
            return this.handleRuntimeExceptions(remoteServiceCallable);
        }
        catch (TFileNotFoundException tFileNotFoundException) {
            throw new FileNotFoundException(tFileNotFoundException.message);
        }
        catch (TIOException tIOException) {
            throw new IOException(tIOException.message);
        }
        catch (TException tException) {
            throw new RuntimeException(tException);
        }
    }

    default public <V> V remoteCall(RemoteServiceCallable<V> remoteServiceCallable) {
        try {
            return this.handleRuntimeExceptions(remoteServiceCallable);
        }
        catch (TException tException) {
            throw new RuntimeException(tException);
        }
    }

    default public <V> V handleRuntimeExceptions(RemoteServiceCallable<V> remoteServiceCallable) throws TException {
        try {
            return remoteServiceCallable.call();
        }
        catch (TResourceInUseException tResourceInUseException) {
            throw new SResourceInUseException(tResourceInUseException.message);
        }
        catch (TDatabaseException tDatabaseException) {
            switch (tDatabaseException.type) {
                case DEADLOCK: {
                    throw new SDeadlockException(tDatabaseException.message, tDatabaseException.errorNumber);
                }
                case HEAP_FULL: {
                    throw new SHeapFullException(tDatabaseException.message, tDatabaseException.errorNumber);
                }
                case LOCK_NOT_GRANTED: {
                    throw new SLockNotGrantedException(tDatabaseException.message, tDatabaseException.errorNumber);
                }
                case META_CHECKSUM_FAIL: {
                    throw new SMetaCheckSumFailException(tDatabaseException.message, tDatabaseException.errorNumber);
                }
                case RUN_RECOVERY: {
                    throw new SRunRecoveryException(tDatabaseException.message, tDatabaseException.errorNumber);
                }
                case VERSION_MISMATCH: {
                    throw new SVersionMismatchException(tDatabaseException.message, tDatabaseException.errorNumber);
                }
            }
            throw new SDatabaseException(tDatabaseException.message, tDatabaseException.errorNumber);
        }
        catch (TRuntimeException tRuntimeException) {
            try {
                Class<?> clazz = Class.forName(tRuntimeException.getFullClassName());
                Constructor<?> constructor = clazz.getConstructor(String.class);
                throw (RuntimeException)constructor.newInstance(tRuntimeException.message);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(tRuntimeException.message, tRuntimeException);
            }
        }
    }
}

