/*
 * Copyright (C) 2014, 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef JSGlobalObjectConsoleAgent_h
#define JSGlobalObjectConsoleAgent_h

#include "InspectorConsoleAgent.h"
#include "JSGlobalObjectScriptDebugServer.h"

namespace Inspector {

class JSGlobalObjectConsoleAgent final : public InspectorConsoleAgent {
    WTF_MAKE_NONCOPYABLE(JSGlobalObjectConsoleAgent);
    WTF_MAKE_FAST_ALLOCATED;
public:
    JSGlobalObjectConsoleAgent(AgentContext&, InspectorHeapAgent*);
    virtual ~JSGlobalObjectConsoleAgent() { }

    // FIXME: XHRs and Nodes only makes sense debugging a Web context. Can this be moved to a different agent?
    void setMonitoringXHREnabled(ErrorString&, bool enabled) override;
    void addInspectedNode(ErrorString&, int nodeId) override;
};

} // namespace Inspector

#endif // !defined(JSGlobalObjectConsoleAgent_h)
