/* SortedList.c generated by valac 0.32.1, the Vala compiler
 * generated from SortedList.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
typedef struct _SortedListPrivate SortedListPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
struct _SortedList {
	GObject parent_instance;
	SortedListPrivate * priv;
};

struct _SortedListClass {
	GObjectClass parent_class;
};

struct _SortedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayList* list;
	Comparator cmp;
	gpointer cmp_target;
};


static gpointer sorted_list_parent_class = NULL;
static GeeTraversableIface* sorted_list_gee_traversable_parent_iface = NULL;
static GeeIterableIface* sorted_list_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* sorted_list_gee_collection_parent_iface = NULL;

gchar* g_utf8_collate_key_for_filename (const gchar* str, gssize len);
gint64 file_comparator (void* a, void* b);
GType sorted_list_get_type (void) G_GNUC_CONST;
#define SORTED_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SORTED_LIST, SortedListPrivate))
enum  {
	SORTED_LIST_DUMMY_PROPERTY,
	SORTED_LIST_G_TYPE,
	SORTED_LIST_G_DUP_FUNC,
	SORTED_LIST_G_DESTROY_FUNC,
	SORTED_LIST_ELEMENT_TYPE,
	SORTED_LIST_READ_ONLY,
	SORTED_LIST_IS_EMPTY,
	SORTED_LIST_SIZE,
	SORTED_LIST_READ_ONLY_VIEW,
	SORTED_LIST_READ_ONLY_VIEW_AS_LIST
};
SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
static GeeIterator* sorted_list_real_iterator (GeeIterable* base);
static gboolean sorted_list_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static gboolean sorted_list_real_add (GeeCollection* base, gconstpointer item);
static gint sorted_list_get_sorted_insert_pos (SortedList* self, gconstpointer item);
static gboolean sorted_list_real_add_all (GeeCollection* base, GeeCollection* collection);
gboolean sorted_list_add_list (SortedList* self, GeeList* items);
static gboolean sorted_list_merge_sort (SortedList* self, GeeList* add);
static void sorted_list_real_clear (GeeCollection* base);
static gboolean sorted_list_real_contains (GeeCollection* base, gconstpointer item);
static gboolean sorted_list_real_contains_all (GeeCollection* base, GeeCollection* collection);
static gboolean sorted_list_real_remove (GeeCollection* base, gconstpointer item);
static gboolean sorted_list_real_remove_all (GeeCollection* base, GeeCollection* collection);
static gboolean sorted_list_real_retain_all (GeeCollection* base, GeeCollection* collection);
gint sorted_list_get_count (SortedList* self);
gpointer sorted_list_get_at (SortedList* self, gint index);
static gint sorted_list_binary_search (SortedList* self, gconstpointer search, GEqualFunc equal_func);
gint sorted_list_index_of (SortedList* self, gconstpointer search);
gint sorted_list_locate (SortedList* self, gconstpointer search, gboolean altered, GEqualFunc equal_func);
gpointer sorted_list_remove_at (SortedList* self, gint index);
static gpointer* sorted_list_real_to_array (GeeCollection* base, int* result_length1);
void sorted_list_resort (SortedList* self, Comparator new_cmp, void* new_cmp_target);
gboolean sorted_list_resort_item (SortedList* self, gconstpointer item);
SortedList* sorted_list_copy (SortedList* self);
static void _sorted_list_merge_sort (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint end_index);
static void sorted_list_merge (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint middle_index, gint end_index);
GeeList* sorted_list_get_read_only_view_as_list (SortedList* self);
static void sorted_list_finalize (GObject* obj);
static void _vala_sorted_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sorted_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gint64 file_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gchar* path_a = NULL;
	void* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path_b = NULL;
	void* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp7_ = NULL;
	GCompareFunc _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint64 _tmp16_ = 0LL;
#line 12 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = a;
#line 12 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = g_file_get_path (G_TYPE_CHECK_INSTANCE_CAST ((GFile*) _tmp0_, G_TYPE_FILE, GFile));
#line 12 "/home/jens/Source/shotwell/src/SortedList.vala"
	path_a = _tmp1_;
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = b;
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = g_file_get_path (G_TYPE_CHECK_INSTANCE_CAST ((GFile*) _tmp2_, G_TYPE_FILE, GFile));
#line 13 "/home/jens/Source/shotwell/src/SortedList.vala"
	path_b = _tmp3_;
#line 16 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = path_a;
#line 16 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp4_ == NULL) {
#line 147 "SortedList.c"
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = path_b;
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp6_ == NULL) {
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = 0;
#line 156 "SortedList.c"
		} else {
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = 1;
#line 160 "SortedList.c"
		}
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = (gint64) _tmp5_;
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_free0 (path_b);
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_free0 (path_a);
#line 17 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 170 "SortedList.c"
	}
#line 19 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = path_b;
#line 19 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp7_ == NULL) {
#line 20 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = (gint64) -1;
#line 20 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_free0 (path_b);
#line 20 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_free0 (path_a);
#line 20 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 184 "SortedList.c"
	}
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = g_strcmp0;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = path_a;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp10_ = g_utf8_collate_key_for_filename (_tmp9_, (gssize) -1);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11_ = _tmp10_;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = path_b;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = g_utf8_collate_key_for_filename (_tmp12_, (gssize) -1);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp14_ = _tmp13_;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp15_ = _tmp8_ (_tmp11_, _tmp14_);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp16_ = (gint64) _tmp15_;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_free0 (_tmp14_);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_free0 (_tmp11_);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp16_;
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_free0 (path_b);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_free0 (path_a);
#line 22 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 216 "SortedList.c"
}


SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target) {
	SortedList * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	Comparator _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 29 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = (SortedList*) g_object_new (object_type, NULL);
#line 29 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->g_type = g_type;
#line 29 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->g_dup_func = g_dup_func;
#line 29 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 30 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = gee_array_list_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, NULL, NULL, NULL);
#line 30 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_object_unref0 (self->priv->list);
#line 30 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->list = _tmp0_;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = cmp;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = cmp_target;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp = _tmp1_;
#line 31 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp_target = _tmp1__target;
#line 29 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self;
#line 249 "SortedList.c"
}


SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target) {
#line 29 "/home/jens/Source/shotwell/src/SortedList.vala"
	return sorted_list_construct (TYPE_SORTED_LIST, g_type, g_dup_func, g_destroy_func, cmp, cmp_target);
#line 256 "SortedList.c"
}


static GeeIterator* sorted_list_real_iterator (GeeIterable* base) {
	SortedList * self;
	GeeIterator* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 42 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 43 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 43 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 43 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp1_;
#line 43 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 275 "SortedList.c"
}


static gboolean sorted_list_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	GeeForallFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	gboolean _tmp2_ = FALSE;
#line 46 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = f;
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = f_target;
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_, _tmp1__target);
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 47 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 300 "SortedList.c"
}


static gboolean sorted_list_real_add (GeeCollection* base, gconstpointer item) {
	SortedList * self;
	gboolean result = FALSE;
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 50 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 51 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp0_ == NULL) {
#line 317 "SortedList.c"
		GeeArrayList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
#line 52 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp1_ = self->priv->list;
#line 52 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp2_ = item;
#line 52 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
#line 326 "SortedList.c"
	} else {
		GeeArrayList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gconstpointer _tmp6_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = self->priv->list;
#line 54 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = item;
#line 54 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp5_ = sorted_list_get_sorted_insert_pos (self, _tmp4_);
#line 54 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = item;
#line 54 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp5_, _tmp6_);
#line 342 "SortedList.c"
	}
#line 60 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = TRUE;
#line 60 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 348 "SortedList.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 67 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self ? g_object_ref (self) : NULL;
#line 355 "SortedList.c"
}


static gboolean sorted_list_real_add_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeList* as_list = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	GeeList* _tmp5_ = NULL;
	Comparator _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	gboolean changed = FALSE;
	GeeCollection* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
#line 63 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 63 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = collection;
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 64 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp2_ == 0) {
#line 65 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = FALSE;
#line 65 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 391 "SortedList.c"
	}
#line 67 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = collection;
#line 67 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GEE_TYPE_LIST) ? ((GeeList*) _tmp3_) : NULL);
#line 67 "/home/jens/Source/shotwell/src/SortedList.vala"
	as_list = _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = as_list;
#line 68 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp5_ != NULL) {
#line 403 "SortedList.c"
		GeeList* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 69 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = as_list;
#line 69 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp7_ = sorted_list_add_list (self, _tmp6_);
#line 69 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = _tmp7_;
#line 69 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (as_list);
#line 69 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 416 "SortedList.c"
	}
#line 71 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = self->priv->cmp;
#line 71 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8__target = self->priv->cmp_target;
#line 71 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp8_ == NULL) {
#line 424 "SortedList.c"
		GeeArrayList* _tmp9_ = NULL;
		GeeCollection* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 72 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp9_ = self->priv->list;
#line 72 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp10_ = collection;
#line 72 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp11_ = gee_array_list_add_all (_tmp9_, _tmp10_);
#line 72 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = _tmp11_;
#line 72 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (as_list);
#line 72 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 440 "SortedList.c"
	}
#line 74 "/home/jens/Source/shotwell/src/SortedList.vala"
	changed = FALSE;
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = collection;
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = gee_collection_get_size (_tmp12_);
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp14_ = _tmp13_;
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp14_ == 1) {
#line 452 "SortedList.c"
		GeeIterator* iter = NULL;
		GeeCollection* _tmp15_ = NULL;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_ = NULL;
		gpointer item = NULL;
		GeeIterator* _tmp18_ = NULL;
		gpointer _tmp19_ = NULL;
		GeeArrayList* _tmp20_ = NULL;
		gconstpointer _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gconstpointer _tmp23_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = collection;
#line 76 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
#line 76 "/home/jens/Source/shotwell/src/SortedList.vala"
		iter = _tmp16_;
#line 77 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = iter;
#line 77 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_iterator_next (_tmp17_);
#line 78 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = iter;
#line 78 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = gee_iterator_get (_tmp18_);
#line 78 "/home/jens/Source/shotwell/src/SortedList.vala"
		item = _tmp19_;
#line 80 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = self->priv->list;
#line 80 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = item;
#line 80 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = sorted_list_get_sorted_insert_pos (self, _tmp21_);
#line 80 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = item;
#line 80 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp22_, _tmp23_);
#line 81 "/home/jens/Source/shotwell/src/SortedList.vala"
		changed = TRUE;
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (iter);
#line 496 "SortedList.c"
	} else {
		GeeList* items = NULL;
		GeeArrayList* _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		GeeCollection* _tmp26_ = NULL;
		GeeList* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
#line 83 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, NULL, NULL, NULL);
#line 83 "/home/jens/Source/shotwell/src/SortedList.vala"
		items = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_LIST, GeeList);
#line 84 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = items;
#line 84 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp26_ = collection;
#line 84 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), _tmp26_);
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp27_ = items;
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp28_ = sorted_list_merge_sort (self, _tmp27_);
#line 86 "/home/jens/Source/shotwell/src/SortedList.vala"
		changed = _tmp28_;
#line 75 "/home/jens/Source/shotwell/src/SortedList.vala"
		_g_object_unref0 (items);
#line 522 "SortedList.c"
	}
#line 92 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = changed;
#line 92 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_object_unref0 (as_list);
#line 92 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 530 "SortedList.c"
}


gboolean sorted_list_add_list (SortedList* self, GeeList* items) {
	gboolean result = FALSE;
	gboolean added = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 95 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
#line 95 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_LIST (items), FALSE);
#line 96 "/home/jens/Source/shotwell/src/SortedList.vala"
	added = FALSE;
#line 97 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = items;
#line 97 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 97 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 97 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp2_ == 0) {
#line 554 "SortedList.c"
	} else {
		Comparator _tmp3_ = NULL;
		void* _tmp3__target = NULL;
#line 99 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = self->priv->cmp;
#line 99 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3__target = self->priv->cmp_target;
#line 99 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp3_ != NULL) {
#line 564 "SortedList.c"
			GeeList* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
#line 102 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp4_ = items;
#line 102 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 102 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp6_ = _tmp5_;
#line 102 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp6_ == 1) {
#line 576 "SortedList.c"
				GeeArrayList* _tmp7_ = NULL;
				GeeList* _tmp8_ = NULL;
				gpointer _tmp9_ = NULL;
				gpointer _tmp10_ = NULL;
				gint _tmp11_ = 0;
				GeeList* _tmp12_ = NULL;
				gpointer _tmp13_ = NULL;
				gpointer _tmp14_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp7_ = self->priv->list;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp8_ = items;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp9_ = gee_list_get (_tmp8_, 0);
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp10_ = _tmp9_;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp11_ = sorted_list_get_sorted_insert_pos (self, _tmp10_);
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp12_ = items;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp13_ = gee_list_get (_tmp12_, 0);
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp14_ = _tmp13_;
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_, _tmp14_);
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				((_tmp14_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp14_ = (self->priv->g_destroy_func (_tmp14_), NULL));
#line 103 "/home/jens/Source/shotwell/src/SortedList.vala"
				((_tmp10_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp10_ = (self->priv->g_destroy_func (_tmp10_), NULL));
#line 104 "/home/jens/Source/shotwell/src/SortedList.vala"
				added = TRUE;
#line 609 "SortedList.c"
			} else {
				GeeList* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp15_ = items;
#line 106 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp16_ = sorted_list_merge_sort (self, _tmp15_);
#line 106 "/home/jens/Source/shotwell/src/SortedList.vala"
				added = _tmp16_;
#line 619 "SortedList.c"
			}
		} else {
			GeeArrayList* _tmp17_ = NULL;
			GeeList* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
#line 109 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp17_ = self->priv->list;
#line 109 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp18_ = items;
#line 109 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp19_ = gee_array_list_add_all (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 109 "/home/jens/Source/shotwell/src/SortedList.vala"
			added = _tmp19_;
#line 633 "SortedList.c"
		}
	}
#line 116 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = added;
#line 116 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 640 "SortedList.c"
}


static void sorted_list_real_clear (GeeCollection* base) {
	SortedList * self;
	GeeArrayList* _tmp0_ = NULL;
#line 119 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 120 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 120 "/home/jens/Source/shotwell/src/SortedList.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 653 "SortedList.c"
}


static gboolean sorted_list_real_contains (GeeCollection* base, gconstpointer item) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 123 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 124 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 124 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = item;
#line 124 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 124 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 124 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 675 "SortedList.c"
}


static gboolean sorted_list_real_contains_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 127 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 127 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 128 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 128 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = collection;
#line 128 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 128 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 128 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 699 "SortedList.c"
}


static gboolean sorted_list_real_remove (GeeCollection* base, gconstpointer item) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 137 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = item;
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 138 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 721 "SortedList.c"
}


static gboolean sorted_list_real_remove_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 141 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 141 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = collection;
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 142 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 745 "SortedList.c"
}


static gboolean sorted_list_real_retain_all (GeeCollection* base, GeeCollection* collection) {
	SortedList * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 145 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 145 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (collection), FALSE);
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = collection;
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_retain_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 146 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 769 "SortedList.c"
}


inline gint sorted_list_get_count (SortedList* self) {
	gint result = 0;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 153 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 154 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 790 "SortedList.c"
}


gpointer sorted_list_get_at (SortedList* self, gint index) {
	gpointer result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = index;
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp1_);
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 158 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 811 "SortedList.c"
}


static gint sorted_list_binary_search (SortedList* self, gconstpointer search, GEqualFunc equal_func) {
	gint result = 0;
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gint min = 0;
	gint max = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 161 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 162 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 162 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 162 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ != NULL, "cmp != null");
#line 164 "/home/jens/Source/shotwell/src/SortedList.vala"
	min = 0;
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->list;
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = _tmp2_;
#line 165 "/home/jens/Source/shotwell/src/SortedList.vala"
	max = _tmp3_;
#line 842 "SortedList.c"
	{
		gboolean _tmp4_ = FALSE;
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = TRUE;
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
		while (TRUE) {
#line 849 "SortedList.c"
			gint mid = 0;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gpointer item = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GEqualFunc _tmp12_ = NULL;
			gint64 compare = 0LL;
			Comparator _tmp17_ = NULL;
			void* _tmp17__target = NULL;
			gconstpointer _tmp18_ = NULL;
			gconstpointer _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			gint64 _tmp21_ = 0LL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (!_tmp4_) {
#line 871 "SortedList.c"
			}
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp4_ = FALSE;
#line 167 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = min;
#line 167 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp6_ = max;
#line 167 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp7_ = min;
#line 167 "/home/jens/Source/shotwell/src/SortedList.vala"
			mid = _tmp5_ + ((_tmp6_ - _tmp7_) / 2);
#line 168 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp8_ = self->priv->list;
#line 168 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp9_ = mid;
#line 168 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
#line 168 "/home/jens/Source/shotwell/src/SortedList.vala"
			item = _tmp10_;
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp12_ = equal_func;
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp12_ != NULL) {
#line 895 "SortedList.c"
				GEqualFunc _tmp13_ = NULL;
				gconstpointer _tmp14_ = NULL;
				gconstpointer _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp13_ = equal_func;
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp14_ = item;
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp15_ = search;
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp16_ = _tmp13_ (_tmp14_, _tmp15_);
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp11_ = _tmp16_;
#line 910 "SortedList.c"
			} else {
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp11_ = FALSE;
#line 914 "SortedList.c"
			}
#line 170 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp11_) {
#line 171 "/home/jens/Source/shotwell/src/SortedList.vala"
				result = mid;
#line 171 "/home/jens/Source/shotwell/src/SortedList.vala"
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 171 "/home/jens/Source/shotwell/src/SortedList.vala"
				return result;
#line 924 "SortedList.c"
			}
#line 173 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp17_ = self->priv->cmp;
#line 173 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp17__target = self->priv->cmp_target;
#line 173 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp18_ = item;
#line 173 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp19_ = search;
#line 173 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp20_ = _tmp17_ (_tmp18_, _tmp19_, _tmp17__target);
#line 173 "/home/jens/Source/shotwell/src/SortedList.vala"
			compare = _tmp20_;
#line 174 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp21_ = compare;
#line 174 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp21_ == ((gint64) 0)) {
#line 175 "/home/jens/Source/shotwell/src/SortedList.vala"
				result = mid;
#line 175 "/home/jens/Source/shotwell/src/SortedList.vala"
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 175 "/home/jens/Source/shotwell/src/SortedList.vala"
				return result;
#line 948 "SortedList.c"
			} else {
				gint64 _tmp22_ = 0LL;
#line 176 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp22_ = compare;
#line 176 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (_tmp22_ > ((gint64) 0)) {
#line 955 "SortedList.c"
					gint _tmp23_ = 0;
#line 177 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp23_ = mid;
#line 177 "/home/jens/Source/shotwell/src/SortedList.vala"
					max = _tmp23_ - 1;
#line 961 "SortedList.c"
				} else {
					gint _tmp24_ = 0;
#line 179 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp24_ = mid;
#line 179 "/home/jens/Source/shotwell/src/SortedList.vala"
					min = _tmp24_ + 1;
#line 968 "SortedList.c"
				}
			}
#line 181 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp25_ = min;
#line 181 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_ = max;
#line 181 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp25_ > _tmp26_) {
#line 182 "/home/jens/Source/shotwell/src/SortedList.vala"
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 182 "/home/jens/Source/shotwell/src/SortedList.vala"
				break;
#line 981 "SortedList.c"
			}
#line 166 "/home/jens/Source/shotwell/src/SortedList.vala"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 985 "SortedList.c"
		}
	}
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = -1;
#line 185 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 992 "SortedList.c"
}


gint sorted_list_index_of (SortedList* self, gconstpointer search) {
	gint result = 0;
	gint _tmp0_ = 0;
	Comparator _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 195 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->cmp;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = self->priv->cmp_target;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp1_ != NULL) {
#line 1009 "SortedList.c"
		gconstpointer _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp2_ = search;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = sorted_list_binary_search (self, _tmp2_, NULL);
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = _tmp3_;
#line 1018 "SortedList.c"
	} else {
		gconstpointer _tmp4_ = NULL;
		GEqualFunc _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = search;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp5_ = g_direct_equal;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = sorted_list_locate (self, _tmp4_, FALSE, _tmp5_);
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = _tmp6_;
#line 1031 "SortedList.c"
	}
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1037 "SortedList.c"
}


gint sorted_list_locate (SortedList* self, gconstpointer search, gboolean altered, GEqualFunc equal_func) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	Comparator _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	gconstpointer _tmp18_ = NULL;
	GEqualFunc _tmp19_ = NULL;
	gint _tmp20_ = 0;
#line 200 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->cmp;
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1__target = self->priv->cmp_target;
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp1_ == NULL) {
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = TRUE;
#line 1059 "SortedList.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp2_ = altered;
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp0_ = _tmp2_;
#line 1066 "SortedList.c"
	}
#line 201 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp0_) {
#line 1070 "SortedList.c"
		gint count = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 202 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = self->priv->list;
#line 202 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 202 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp5_ = _tmp4_;
#line 202 "/home/jens/Source/shotwell/src/SortedList.vala"
		count = _tmp5_;
#line 1083 "SortedList.c"
		{
			gint ctr = 0;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
			ctr = 0;
#line 1088 "SortedList.c"
			{
				gboolean _tmp6_ = FALSE;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp6_ = TRUE;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
				while (TRUE) {
#line 1095 "SortedList.c"
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					GEqualFunc _tmp10_ = NULL;
					GeeArrayList* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gpointer _tmp13_ = NULL;
					gpointer _tmp14_ = NULL;
					gconstpointer _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
					if (!_tmp6_) {
#line 1108 "SortedList.c"
						gint _tmp7_ = 0;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
						_tmp7_ = ctr;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
						ctr = _tmp7_ + 1;
#line 1114 "SortedList.c"
					}
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp6_ = FALSE;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp8_ = ctr;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp9_ = count;
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
					if (!(_tmp8_ < _tmp9_)) {
#line 203 "/home/jens/Source/shotwell/src/SortedList.vala"
						break;
#line 1126 "SortedList.c"
					}
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp10_ = equal_func;
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp11_ = self->priv->list;
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp12_ = ctr;
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp13_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp12_);
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp14_ = _tmp13_;
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp15_ = search;
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp16_ = _tmp10_ (_tmp14_, _tmp15_);
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp17_ = _tmp16_;
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					((_tmp14_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp14_ = (self->priv->g_destroy_func (_tmp14_), NULL));
#line 204 "/home/jens/Source/shotwell/src/SortedList.vala"
					if (_tmp17_) {
#line 205 "/home/jens/Source/shotwell/src/SortedList.vala"
						result = ctr;
#line 205 "/home/jens/Source/shotwell/src/SortedList.vala"
						return result;
#line 1152 "SortedList.c"
					}
				}
			}
		}
#line 208 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = -1;
#line 208 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 1161 "SortedList.c"
	}
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp18_ = search;
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp19_ = equal_func;
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp20_ = sorted_list_binary_search (self, _tmp18_, _tmp19_);
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp20_;
#line 211 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1173 "SortedList.c"
}


gpointer sorted_list_remove_at (SortedList* self, gint index) {
	gpointer result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
#line 226 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 227 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 227 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = index;
#line 227 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp1_);
#line 227 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 227 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1194 "SortedList.c"
}


static gpointer* sorted_list_real_to_array (GeeCollection* base, int* result_length1) {
	SortedList * self;
	gpointer* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer* _tmp2_ = NULL;
	gpointer* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 230 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp1_);
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = _tmp2_;
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3__length1 = _tmp1_;
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (result_length1) {
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
		*result_length1 = _tmp3__length1;
#line 1220 "SortedList.c"
	}
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp3_;
#line 231 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1226 "SortedList.c"
}


void sorted_list_resort (SortedList* self, Comparator new_cmp, void* new_cmp_target) {
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 234 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_if_fail (IS_SORTED_LIST (self));
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = new_cmp;
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = new_cmp_target;
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp = _tmp0_;
#line 235 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv->cmp_target = _tmp0__target;
#line 237 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_merge_sort (self, NULL);
#line 1245 "SortedList.c"
}


gboolean sorted_list_resort_item (SortedList* self, gconstpointer item) {
	gboolean result = FALSE;
	gint index = 0;
	gconstpointer _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint new_index = 0;
	gconstpointer _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 245 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = item;
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = g_direct_equal;
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = sorted_list_locate (self, _tmp0_, TRUE, _tmp1_);
#line 246 "/home/jens/Source/shotwell/src/SortedList.vala"
	index = _tmp2_;
#line 247 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = index;
#line 247 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp3_ >= 0, "index >= 0");
#line 249 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = item;
#line 249 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = sorted_list_get_sorted_insert_pos (self, _tmp4_);
#line 249 "/home/jens/Source/shotwell/src/SortedList.vala"
	new_index = _tmp5_;
#line 251 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp6_ = index;
#line 251 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = new_index;
#line 251 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp6_ == _tmp7_) {
#line 252 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = FALSE;
#line 252 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 1293 "SortedList.c"
	}
#line 256 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = new_index;
#line 256 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = index;
#line 256 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp8_ > _tmp9_) {
#line 1301 "SortedList.c"
		GeeArrayList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gconstpointer _tmp12_ = NULL;
		gpointer removed_item = NULL;
		GeeArrayList* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gpointer _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp10_ = self->priv->list;
#line 257 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp11_ = new_index;
#line 257 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp12_ = item;
#line 257 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_, _tmp12_);
#line 258 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp13_ = self->priv->list;
#line 258 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp14_ = index;
#line 258 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp14_);
#line 258 "/home/jens/Source/shotwell/src/SortedList.vala"
		removed_item = _tmp15_;
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = item;
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = removed_item;
#line 259 "/home/jens/Source/shotwell/src/SortedList.vala"
		_vala_assert (_tmp16_ == _tmp17_, "item == removed_item");
#line 256 "/home/jens/Source/shotwell/src/SortedList.vala"
		((removed_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (removed_item = (self->priv->g_destroy_func (removed_item), NULL));
#line 1335 "SortedList.c"
	} else {
		gpointer removed_item = NULL;
		GeeArrayList* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gpointer _tmp20_ = NULL;
		gconstpointer _tmp21_ = NULL;
		gconstpointer _tmp22_ = NULL;
		GeeArrayList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gconstpointer _tmp25_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = self->priv->list;
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = index;
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp19_);
#line 261 "/home/jens/Source/shotwell/src/SortedList.vala"
		removed_item = _tmp20_;
#line 262 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = item;
#line 262 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = removed_item;
#line 262 "/home/jens/Source/shotwell/src/SortedList.vala"
		_vala_assert (_tmp21_ == _tmp22_, "item == removed_item");
#line 263 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = self->priv->list;
#line 263 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = new_index;
#line 263 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = item;
#line 263 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp24_, _tmp25_);
#line 256 "/home/jens/Source/shotwell/src/SortedList.vala"
		((removed_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (removed_item = (self->priv->g_destroy_func (removed_item), NULL));
#line 1370 "SortedList.c"
	}
#line 270 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = TRUE;
#line 270 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1376 "SortedList.c"
}


static gint sorted_list_get_sorted_insert_pos (SortedList* self, gconstpointer item) {
	gint result = 0;
	gint low = 0;
	gint high = 0;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 273 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
#line 274 "/home/jens/Source/shotwell/src/SortedList.vala"
	low = 0;
#line 275 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 275 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 275 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 275 "/home/jens/Source/shotwell/src/SortedList.vala"
	high = _tmp2_;
#line 1399 "SortedList.c"
	{
		gboolean _tmp3_ = FALSE;
#line 276 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp3_ = TRUE;
#line 276 "/home/jens/Source/shotwell/src/SortedList.vala"
		while (TRUE) {
#line 1406 "SortedList.c"
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint mid = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gpointer cmp_item = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			gconstpointer _tmp12_ = NULL;
			gconstpointer _tmp13_ = NULL;
			gint64 _result_ = 0LL;
			Comparator _tmp24_ = NULL;
			void* _tmp24__target = NULL;
			gconstpointer _tmp25_ = NULL;
			gconstpointer _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			gint64 _tmp28_ = 0LL;
#line 276 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (!_tmp3_) {
#line 1428 "SortedList.c"
			}
#line 276 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp3_ = FALSE;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp4_ = low;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp5_ = high;
#line 277 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp4_ == _tmp5_) {
#line 278 "/home/jens/Source/shotwell/src/SortedList.vala"
				result = low;
#line 278 "/home/jens/Source/shotwell/src/SortedList.vala"
				return result;
#line 1442 "SortedList.c"
			}
#line 280 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp6_ = low;
#line 280 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp7_ = high;
#line 280 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp8_ = low;
#line 280 "/home/jens/Source/shotwell/src/SortedList.vala"
			mid = _tmp6_ + ((_tmp7_ - _tmp8_) / 2);
#line 284 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp9_ = self->priv->list;
#line 284 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = mid;
#line 284 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp11_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp10_);
#line 284 "/home/jens/Source/shotwell/src/SortedList.vala"
			cmp_item = _tmp11_;
#line 285 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp12_ = item;
#line 285 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp13_ = cmp_item;
#line 285 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp12_ == _tmp13_) {
#line 1466 "SortedList.c"
				gint _tmp14_ = 0;
				GeeArrayList* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				GeeArrayList* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gpointer _tmp23_ = NULL;
#line 287 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp14_ = mid;
#line 287 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp15_ = self->priv->list;
#line 287 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp16_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
#line 287 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp17_ = _tmp16_;
#line 287 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (_tmp14_ >= (_tmp17_ - 1)) {
#line 1484 "SortedList.c"
					GeeArrayList* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp18_ = self->priv->list;
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp19_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp20_ = _tmp19_;
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
					result = _tmp20_;
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
					((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 288 "/home/jens/Source/shotwell/src/SortedList.vala"
					return result;
#line 1500 "SortedList.c"
				}
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp21_ = self->priv->list;
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp22_ = mid;
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp23_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp22_ + 1);
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
				((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 290 "/home/jens/Source/shotwell/src/SortedList.vala"
				cmp_item = _tmp23_;
#line 1512 "SortedList.c"
			}
#line 293 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp24_ = self->priv->cmp;
#line 293 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp24__target = self->priv->cmp_target;
#line 293 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp25_ = item;
#line 293 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_ = cmp_item;
#line 293 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_ = _tmp24_ (_tmp25_, _tmp26_, _tmp24__target);
#line 293 "/home/jens/Source/shotwell/src/SortedList.vala"
			_result_ = _tmp27_;
#line 294 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp28_ = _result_;
#line 294 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (_tmp28_ < ((gint64) 0)) {
#line 1530 "SortedList.c"
				gint _tmp29_ = 0;
#line 295 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp29_ = mid;
#line 295 "/home/jens/Source/shotwell/src/SortedList.vala"
				high = _tmp29_;
#line 1536 "SortedList.c"
			} else {
				gint64 _tmp30_ = 0LL;
#line 296 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp30_ = _result_;
#line 296 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (_tmp30_ > ((gint64) 0)) {
#line 1543 "SortedList.c"
					gint _tmp31_ = 0;
#line 297 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp31_ = mid;
#line 297 "/home/jens/Source/shotwell/src/SortedList.vala"
					low = _tmp31_ + 1;
#line 1549 "SortedList.c"
				} else {
#line 299 "/home/jens/Source/shotwell/src/SortedList.vala"
					result = mid;
#line 299 "/home/jens/Source/shotwell/src/SortedList.vala"
					((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 299 "/home/jens/Source/shotwell/src/SortedList.vala"
					return result;
#line 1557 "SortedList.c"
				}
			}
#line 276 "/home/jens/Source/shotwell/src/SortedList.vala"
			((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
#line 1562 "SortedList.c"
		}
	}
}


SortedList* sorted_list_copy (SortedList* self) {
	SortedList* result = NULL;
	SortedList* copy = NULL;
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	SortedList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
#line 303 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 304 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 304 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 304 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = sorted_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp0_, _tmp0__target);
#line 304 "/home/jens/Source/shotwell/src/SortedList.vala"
	copy = _tmp1_;
#line 306 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = copy->priv->list;
#line 306 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = self->priv->list;
#line 306 "/home/jens/Source/shotwell/src/SortedList.vala"
	gee_array_list_add_all (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 308 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = copy;
#line 308 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1596 "SortedList.c"
}


static gboolean sorted_list_merge_sort (SortedList* self, GeeList* add) {
	gboolean result = FALSE;
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gint list_count = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GeeList* _tmp5_ = NULL;
	gint add_count = 0;
	gint count = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gpointer* array = NULL;
	gint _tmp12_ = 0;
	gpointer* _tmp13_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint offset = 0;
	GeeList* _tmp23_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gpointer* _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint _tmp36_ = 0;
	gpointer* _tmp37_ = NULL;
	gpointer* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp39_ = 0;
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
#line 329 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail ((add == NULL) || GEE_IS_LIST (add), FALSE);
#line 330 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->cmp;
#line 330 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0__target = self->priv->cmp_target;
#line 330 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ != NULL, "cmp != null");
#line 332 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = self->priv->list;
#line 332 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 332 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = _tmp2_;
#line 332 "/home/jens/Source/shotwell/src/SortedList.vala"
	list_count = _tmp3_;
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = add;
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp5_ != NULL) {
#line 1653 "SortedList.c"
		GeeList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp6_ = add;
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp8_ = _tmp7_;
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = _tmp8_;
#line 1665 "SortedList.c"
	} else {
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp4_ = 0;
#line 1669 "SortedList.c"
	}
#line 333 "/home/jens/Source/shotwell/src/SortedList.vala"
	add_count = _tmp4_;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = list_count;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp10_ = add_count;
#line 335 "/home/jens/Source/shotwell/src/SortedList.vala"
	count = _tmp9_ + _tmp10_;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11_ = count;
#line 336 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp11_ == 0) {
#line 337 "/home/jens/Source/shotwell/src/SortedList.vala"
		result = FALSE;
#line 337 "/home/jens/Source/shotwell/src/SortedList.vala"
		return result;
#line 1687 "SortedList.c"
	}
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = count;
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = g_new0 (gpointer, _tmp12_);
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	array = _tmp13_;
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	array_length1 = _tmp12_;
#line 341 "/home/jens/Source/shotwell/src/SortedList.vala"
	_array_size_ = array_length1;
#line 342 "/home/jens/Source/shotwell/src/SortedList.vala"
	offset = 0;
#line 344 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 1703 "SortedList.c"
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gpointer* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gint _tmp17_ = 0;
		GeeArrayList* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gpointer _tmp20_ = NULL;
		gpointer _tmp21_ = NULL;
		gint _tmp22_ = 0;
#line 344 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp14_ = offset;
#line 344 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = list_count;
#line 344 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp14_ < _tmp15_)) {
#line 344 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 1722 "SortedList.c"
		}
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = array;
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16__length1 = array_length1;
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = offset;
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = self->priv->list;
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = offset;
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp19_);
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		((_tmp16_[_tmp17_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp16_[_tmp17_] = (self->priv->g_destroy_func (_tmp16_[_tmp17_]), NULL));
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_[_tmp17_] = _tmp20_;
#line 345 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = _tmp16_[_tmp17_];
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = offset;
#line 346 "/home/jens/Source/shotwell/src/SortedList.vala"
		offset = _tmp22_ + 1;
#line 1746 "SortedList.c"
	}
#line 349 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp23_ = add;
#line 349 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp23_ != NULL) {
#line 1752 "SortedList.c"
		gint add_ctr = 0;
#line 350 "/home/jens/Source/shotwell/src/SortedList.vala"
		add_ctr = 0;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
		while (TRUE) {
#line 1758 "SortedList.c"
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gpointer* _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gint _tmp27_ = 0;
			GeeList* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gpointer _tmp30_ = NULL;
			gpointer _tmp31_ = NULL;
			gint _tmp32_ = 0;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp24_ = offset;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp25_ = count;
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
			if (!(_tmp24_ < _tmp25_)) {
#line 351 "/home/jens/Source/shotwell/src/SortedList.vala"
				break;
#line 1777 "SortedList.c"
			}
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_ = array;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26__length1 = array_length1;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_ = offset;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp28_ = add;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp29_ = add_ctr;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			add_ctr = _tmp29_ + 1;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			((_tmp26_[_tmp27_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp26_[_tmp27_] = (self->priv->g_destroy_func (_tmp26_[_tmp27_]), NULL));
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp26_[_tmp27_] = _tmp30_;
#line 352 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp31_ = _tmp26_[_tmp27_];
#line 353 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp32_ = offset;
#line 353 "/home/jens/Source/shotwell/src/SortedList.vala"
			offset = _tmp32_ + 1;
#line 1803 "SortedList.c"
		}
	}
#line 357 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp33_ = offset;
#line 357 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp34_ = count;
#line 357 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp33_ == _tmp34_, "offset == count");
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp35_ = array;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp35__length1 = array_length1;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp36_ = count;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp37_ = g_new0 (gpointer, _tmp36_);
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp38_ = _tmp37_;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp38__length1 = _tmp36_;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp39_ = count;
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_sorted_list_merge_sort (self, _tmp35_, _tmp35__length1, _tmp38_, _tmp36_, 0, _tmp39_ - 1);
#line 359 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 361 "/home/jens/Source/shotwell/src/SortedList.vala"
	offset = 0;
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 1834 "SortedList.c"
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		GeeArrayList* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gpointer* _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
		gint _tmp45_ = 0;
		gconstpointer _tmp46_ = NULL;
		gint _tmp47_ = 0;
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp40_ = offset;
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41_ = list_count;
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp40_ < _tmp41_)) {
#line 362 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 1852 "SortedList.c"
		}
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp42_ = self->priv->list;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp43_ = offset;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp44_ = array;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp44__length1 = array_length1;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp45_ = offset;
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp46_ = _tmp44_[_tmp45_];
#line 363 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp43_, _tmp46_);
#line 364 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp47_ = offset;
#line 364 "/home/jens/Source/shotwell/src/SortedList.vala"
		offset = _tmp47_ + 1;
#line 1872 "SortedList.c"
	}
#line 367 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 1876 "SortedList.c"
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		GeeArrayList* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gpointer* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		gint _tmp53_ = 0;
		gconstpointer _tmp54_ = NULL;
		gint _tmp55_ = 0;
#line 367 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp48_ = offset;
#line 367 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp49_ = count;
#line 367 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp48_ < _tmp49_)) {
#line 367 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 1894 "SortedList.c"
		}
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50_ = self->priv->list;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp51_ = offset;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52_ = array;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52__length1 = array_length1;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp53_ = offset;
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp54_ = _tmp52_[_tmp53_];
#line 368 "/home/jens/Source/shotwell/src/SortedList.vala"
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp51_, _tmp54_);
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp55_ = offset;
#line 369 "/home/jens/Source/shotwell/src/SortedList.vala"
		offset = _tmp55_ + 1;
#line 1914 "SortedList.c"
	}
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = TRUE;
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 372 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 1922 "SortedList.c"
}


static void _sorted_list_merge_sort (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint end_index) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint count = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint middle_index = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gpointer* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gpointer* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gpointer* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gpointer* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	Comparator _tmp15_ = NULL;
	void* _tmp15__target = NULL;
	gpointer* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	gconstpointer _tmp18_ = NULL;
	gpointer* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp20_ = 0;
	gconstpointer _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
#line 375 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_if_fail (IS_SORTED_LIST (self));
#line 376 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = start_index;
#line 376 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = end_index;
#line 376 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ <= _tmp1_, "start_index <= end_index");
#line 378 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = end_index;
#line 378 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = start_index;
#line 378 "/home/jens/Source/shotwell/src/SortedList.vala"
	count = (_tmp2_ - _tmp3_) + 1;
#line 379 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = count;
#line 379 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp4_ <= 1) {
#line 380 "/home/jens/Source/shotwell/src/SortedList.vala"
		return;
#line 1979 "SortedList.c"
	}
#line 382 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = start_index;
#line 382 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp6_ = count;
#line 382 "/home/jens/Source/shotwell/src/SortedList.vala"
	middle_index = _tmp5_ + (_tmp6_ / 2);
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = array;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7__length1 = array_length1;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = scratch;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8__length1 = scratch_length1;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = start_index;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp10_ = middle_index;
#line 384 "/home/jens/Source/shotwell/src/SortedList.vala"
	_sorted_list_merge_sort (self, _tmp7_, _tmp7__length1, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_ - 1);
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11_ = array;
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp11__length1 = array_length1;
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12_ = scratch;
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp12__length1 = scratch_length1;
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp13_ = middle_index;
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp14_ = end_index;
#line 385 "/home/jens/Source/shotwell/src/SortedList.vala"
	_sorted_list_merge_sort (self, _tmp11_, _tmp11__length1, _tmp12_, _tmp12__length1, _tmp13_, _tmp14_);
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp15_ = self->priv->cmp;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp15__target = self->priv->cmp_target;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp16_ = array;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp16__length1 = array_length1;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp17_ = middle_index;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp18_ = _tmp16_[_tmp17_ - 1];
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp19_ = array;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp19__length1 = array_length1;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp20_ = middle_index;
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp21_ = _tmp19_[_tmp20_];
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp22_ = _tmp15_ (_tmp18_, _tmp21_, _tmp15__target);
#line 387 "/home/jens/Source/shotwell/src/SortedList.vala"
	if (_tmp22_ > ((gint64) 0)) {
#line 2039 "SortedList.c"
		gpointer* _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gpointer* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = array;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23__length1 = array_length1;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = scratch;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24__length1 = scratch_length1;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = start_index;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp26_ = middle_index;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp27_ = end_index;
#line 388 "/home/jens/Source/shotwell/src/SortedList.vala"
		sorted_list_merge (self, _tmp23_, _tmp23__length1, _tmp24_, _tmp24__length1, _tmp25_, _tmp26_, _tmp27_);
#line 2063 "SortedList.c"
	}
}


static void sorted_list_merge (SortedList* self, gpointer* array, int array_length1, gpointer* scratch, int scratch_length1, gint start_index, gint middle_index, gint end_index) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint count = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint left_start = 0;
	gint _tmp4_ = 0;
	gint left_end = 0;
	gint _tmp5_ = 0;
	gint right_start = 0;
	gint _tmp6_ = 0;
	gint right_end = 0;
	gint _tmp7_ = 0;
	gpointer* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	gint scratch_index = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
#line 391 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_if_fail (IS_SORTED_LIST (self));
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = start_index;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = end_index;
#line 392 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp0_ < _tmp1_, "start_index < end_index");
#line 394 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = end_index;
#line 394 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp3_ = start_index;
#line 394 "/home/jens/Source/shotwell/src/SortedList.vala"
	count = (_tmp2_ - _tmp3_) + 1;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp4_ = start_index;
#line 395 "/home/jens/Source/shotwell/src/SortedList.vala"
	left_start = _tmp4_;
#line 396 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp5_ = middle_index;
#line 396 "/home/jens/Source/shotwell/src/SortedList.vala"
	left_end = _tmp5_ - 1;
#line 397 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp6_ = middle_index;
#line 397 "/home/jens/Source/shotwell/src/SortedList.vala"
	right_start = _tmp6_;
#line 398 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp7_ = end_index;
#line 398 "/home/jens/Source/shotwell/src/SortedList.vala"
	right_end = _tmp7_;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8_ = scratch;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp8__length1 = scratch_length1;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp9_ = count;
#line 400 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp8__length1 >= _tmp9_, "scratch.length >= count");
#line 401 "/home/jens/Source/shotwell/src/SortedList.vala"
	scratch_index = 0;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 2130 "SortedList.c"
		gboolean _tmp10_ = FALSE;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gpointer left = NULL;
		gpointer* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp16_ = 0;
		gconstpointer _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		gpointer right = NULL;
		gpointer* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gint _tmp20_ = 0;
		gconstpointer _tmp21_ = NULL;
		gpointer _tmp22_ = NULL;
		Comparator _tmp23_ = NULL;
		void* _tmp23__target = NULL;
		gconstpointer _tmp24_ = NULL;
		gconstpointer _tmp25_ = NULL;
		gint64 _tmp26_ = 0LL;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp11_ = left_start;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp12_ = left_end;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp11_ <= _tmp12_) {
#line 2157 "SortedList.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp13_ = right_start;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp14_ = right_end;
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = _tmp13_ <= _tmp14_;
#line 2166 "SortedList.c"
		} else {
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp10_ = FALSE;
#line 2170 "SortedList.c"
		}
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!_tmp10_) {
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 2176 "SortedList.c"
		}
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15_ = array;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp15__length1 = array_length1;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp16_ = left_start;
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp17_ = _tmp15_[_tmp16_];
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp18_ = ((_tmp17_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp17_) : ((gpointer) _tmp17_);
#line 404 "/home/jens/Source/shotwell/src/SortedList.vala"
		left = _tmp18_;
#line 405 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19_ = array;
#line 405 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp19__length1 = array_length1;
#line 405 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp20_ = right_start;
#line 405 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp21_ = _tmp19_[_tmp20_];
#line 405 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp22_ = ((_tmp21_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp21_) : ((gpointer) _tmp21_);
#line 405 "/home/jens/Source/shotwell/src/SortedList.vala"
		right = _tmp22_;
#line 407 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23_ = self->priv->cmp;
#line 407 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp23__target = self->priv->cmp_target;
#line 407 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp24_ = left;
#line 407 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp25_ = right;
#line 407 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp26_ = _tmp23_ (_tmp24_, _tmp25_, _tmp23__target);
#line 407 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (_tmp26_ <= ((gint64) 0)) {
#line 2214 "SortedList.c"
			gpointer* _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			gint _tmp28_ = 0;
			gconstpointer _tmp29_ = NULL;
			gpointer _tmp30_ = NULL;
			gpointer _tmp31_ = NULL;
			gint _tmp32_ = 0;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_ = scratch;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27__length1 = scratch_length1;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp28_ = scratch_index;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			scratch_index = _tmp28_ + 1;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp29_ = left;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp30_ = ((_tmp29_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp29_) : ((gpointer) _tmp29_);
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			((_tmp27_[_tmp28_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp27_[_tmp28_] = (self->priv->g_destroy_func (_tmp27_[_tmp28_]), NULL));
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp27_[_tmp28_] = _tmp30_;
#line 408 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp31_ = _tmp27_[_tmp28_];
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp32_ = left_start;
#line 409 "/home/jens/Source/shotwell/src/SortedList.vala"
			left_start = _tmp32_ + 1;
#line 2244 "SortedList.c"
		} else {
			gpointer* _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint _tmp34_ = 0;
			gconstpointer _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			gpointer _tmp37_ = NULL;
			gint _tmp38_ = 0;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp33_ = scratch;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp33__length1 = scratch_length1;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp34_ = scratch_index;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			scratch_index = _tmp34_ + 1;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp35_ = right;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp36_ = ((_tmp35_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp35_) : ((gpointer) _tmp35_);
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			((_tmp33_[_tmp34_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp33_[_tmp34_] = (self->priv->g_destroy_func (_tmp33_[_tmp34_]), NULL));
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp33_[_tmp34_] = _tmp36_;
#line 411 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp37_ = _tmp33_[_tmp34_];
#line 412 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp38_ = right_start;
#line 412 "/home/jens/Source/shotwell/src/SortedList.vala"
			right_start = _tmp38_ + 1;
#line 2275 "SortedList.c"
		}
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		((right == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (right = (self->priv->g_destroy_func (right), NULL));
#line 403 "/home/jens/Source/shotwell/src/SortedList.vala"
		((left == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (left = (self->priv->g_destroy_func (left), NULL));
#line 2281 "SortedList.c"
	}
#line 416 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 2285 "SortedList.c"
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gpointer* _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gint _tmp42_ = 0;
		gpointer* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gint _tmp44_ = 0;
		gconstpointer _tmp45_ = NULL;
		gpointer _tmp46_ = NULL;
		gpointer _tmp47_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp39_ = left_start;
#line 416 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp40_ = left_end;
#line 416 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp39_ <= _tmp40_)) {
#line 416 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 2305 "SortedList.c"
		}
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41_ = scratch;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41__length1 = scratch_length1;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp42_ = scratch_index;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		scratch_index = _tmp42_ + 1;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp43_ = array;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp43__length1 = array_length1;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp44_ = left_start;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		left_start = _tmp44_ + 1;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp45_ = _tmp43_[_tmp44_];
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp46_ = ((_tmp45_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp45_) : ((gpointer) _tmp45_);
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		((_tmp41_[_tmp42_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp41_[_tmp42_] = (self->priv->g_destroy_func (_tmp41_[_tmp42_]), NULL));
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp41_[_tmp42_] = _tmp46_;
#line 417 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp47_ = _tmp41_[_tmp42_];
#line 2333 "SortedList.c"
	}
#line 419 "/home/jens/Source/shotwell/src/SortedList.vala"
	while (TRUE) {
#line 2337 "SortedList.c"
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gpointer* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		gint _tmp51_ = 0;
		gpointer* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		gint _tmp53_ = 0;
		gconstpointer _tmp54_ = NULL;
		gpointer _tmp55_ = NULL;
		gpointer _tmp56_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp48_ = right_start;
#line 419 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp49_ = right_end;
#line 419 "/home/jens/Source/shotwell/src/SortedList.vala"
		if (!(_tmp48_ <= _tmp49_)) {
#line 419 "/home/jens/Source/shotwell/src/SortedList.vala"
			break;
#line 2357 "SortedList.c"
		}
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50_ = scratch;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50__length1 = scratch_length1;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp51_ = scratch_index;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		scratch_index = _tmp51_ + 1;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52_ = array;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp52__length1 = array_length1;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp53_ = right_start;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		right_start = _tmp53_ + 1;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp54_ = _tmp52_[_tmp53_];
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp55_ = ((_tmp54_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp54_) : ((gpointer) _tmp54_);
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		((_tmp50_[_tmp51_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp50_[_tmp51_] = (self->priv->g_destroy_func (_tmp50_[_tmp51_]), NULL));
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp50_[_tmp51_] = _tmp55_;
#line 420 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp56_ = _tmp50_[_tmp51_];
#line 2385 "SortedList.c"
	}
#line 422 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp57_ = scratch_index;
#line 422 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp58_ = count;
#line 422 "/home/jens/Source/shotwell/src/SortedList.vala"
	_vala_assert (_tmp57_ == _tmp58_, "scratch_index == count");
#line 424 "/home/jens/Source/shotwell/src/SortedList.vala"
	scratch_index = 0;
#line 2395 "SortedList.c"
	{
		gint list_index = 0;
		gint _tmp59_ = 0;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
		_tmp59_ = start_index;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
		list_index = _tmp59_;
#line 2403 "SortedList.c"
		{
			gboolean _tmp60_ = FALSE;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
			_tmp60_ = TRUE;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
			while (TRUE) {
#line 2410 "SortedList.c"
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
				gpointer* _tmp64_ = NULL;
				gint _tmp64__length1 = 0;
				gint _tmp65_ = 0;
				gpointer* _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				gint _tmp67_ = 0;
				gconstpointer _tmp68_ = NULL;
				gpointer _tmp69_ = NULL;
				gpointer _tmp70_ = NULL;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (!_tmp60_) {
#line 2424 "SortedList.c"
					gint _tmp61_ = 0;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
					_tmp61_ = list_index;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
					list_index = _tmp61_ + 1;
#line 2430 "SortedList.c"
				}
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp60_ = FALSE;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp62_ = list_index;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp63_ = end_index;
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
				if (!(_tmp62_ <= _tmp63_)) {
#line 425 "/home/jens/Source/shotwell/src/SortedList.vala"
					break;
#line 2442 "SortedList.c"
				}
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp64_ = array;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp64__length1 = array_length1;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp65_ = list_index;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp66_ = scratch;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp66__length1 = scratch_length1;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp67_ = scratch_index;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				scratch_index = _tmp67_ + 1;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp68_ = _tmp66_[_tmp67_];
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp69_ = ((_tmp68_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp68_) : ((gpointer) _tmp68_);
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				((_tmp64_[_tmp65_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp64_[_tmp65_] = (self->priv->g_destroy_func (_tmp64_[_tmp65_]), NULL));
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp64_[_tmp65_] = _tmp69_;
#line 426 "/home/jens/Source/shotwell/src/SortedList.vala"
				_tmp70_ = _tmp64_[_tmp65_];
#line 2468 "SortedList.c"
			}
		}
	}
}


static GType sorted_list_real_get_element_type (GeeTraversable* base) {
	GType result;
	SortedList* self;
#line 35 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 35 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = self->priv->g_type;
#line 35 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2484 "SortedList.c"
}


static gboolean sorted_list_real_get_read_only (GeeCollection* base) {
	gboolean result;
	SortedList* self;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 39 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 39 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 39 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 39 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 39 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 39 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2506 "SortedList.c"
}


static gboolean sorted_list_real_get_is_empty (GeeCollection* base) {
	gboolean result;
	SortedList* self;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 132 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 133 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 133 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 133 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 133 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 133 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2528 "SortedList.c"
}


static gint sorted_list_real_get_size (GeeCollection* base) {
	gint result;
	SortedList* self;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = _tmp2_;
#line 150 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2550 "SortedList.c"
}


static GeeCollection* sorted_list_real_get_read_only_view (GeeCollection* base) {
	GeeCollection* result;
	SortedList* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeBidirList* _tmp1_ = NULL;
	GeeBidirList* _tmp2_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
#line 216 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 216 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
#line 216 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 216 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 216 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2572 "SortedList.c"
}


GeeList* sorted_list_get_read_only_view_as_list (SortedList* self) {
	GeeList* result;
	GeeArrayList* _tmp0_ = NULL;
	GeeBidirList* _tmp1_ = NULL;
	GeeBidirList* _tmp2_ = NULL;
#line 221 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
#line 222 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp0_ = self->priv->list;
#line 222 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
#line 222 "/home/jens/Source/shotwell/src/SortedList.vala"
	_tmp2_ = _tmp1_;
#line 222 "/home/jens/Source/shotwell/src/SortedList.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
#line 222 "/home/jens/Source/shotwell/src/SortedList.vala"
	return result;
#line 2593 "SortedList.c"
}


static void sorted_list_class_init (SortedListClass * klass) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_type_class_add_private (klass, sizeof (SortedListPrivate));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sorted_list_get_property;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sorted_list_set_property;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (klass)->finalize = sorted_list_finalize;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_ELEMENT_TYPE, g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_VIEW, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_VIEW_AS_LIST, g_param_spec_object ("read-only-view-as-list", "read-only-view-as-list", "read-only-view-as-list", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2626 "SortedList.c"
}


static GType sorted_list_gee_traversable_get_g_type (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_type;
#line 2633 "SortedList.c"
}


static GBoxedCopyFunc sorted_list_gee_traversable_get_g_dup_func (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_dup_func;
#line 2640 "SortedList.c"
}


static GDestroyNotify sorted_list_gee_traversable_get_g_destroy_func (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_destroy_func;
#line 2647 "SortedList.c"
}


static void sorted_list_gee_traversable_interface_init (GeeTraversableIface * iface) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) sorted_list_real_foreach;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_type = (GType(*)(GeeTraversable*)) sorted_list_gee_traversable_get_g_type;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) sorted_list_gee_traversable_get_g_dup_func;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) sorted_list_gee_traversable_get_g_destroy_func;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_element_type = sorted_list_real_get_element_type;
#line 2664 "SortedList.c"
}


static GType sorted_list_gee_iterable_get_g_type (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_type;
#line 2671 "SortedList.c"
}


static GBoxedCopyFunc sorted_list_gee_iterable_get_g_dup_func (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_dup_func;
#line 2678 "SortedList.c"
}


static GDestroyNotify sorted_list_gee_iterable_get_g_destroy_func (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_destroy_func;
#line 2685 "SortedList.c"
}


static void sorted_list_gee_iterable_interface_init (GeeIterableIface * iface) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) sorted_list_real_iterator;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_type = (GType(*)(GeeIterable*)) sorted_list_gee_iterable_get_g_type;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeIterable*)) sorted_list_gee_iterable_get_g_dup_func;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeIterable*)) sorted_list_gee_iterable_get_g_destroy_func;
#line 2700 "SortedList.c"
}


static GType sorted_list_gee_collection_get_g_type (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_type;
#line 2707 "SortedList.c"
}


static GBoxedCopyFunc sorted_list_gee_collection_get_g_dup_func (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_dup_func;
#line 2714 "SortedList.c"
}


static GDestroyNotify sorted_list_gee_collection_get_g_destroy_func (SortedList* self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	return self->priv->g_destroy_func;
#line 2721 "SortedList.c"
}


static void sorted_list_gee_collection_interface_init (GeeCollectionIface * iface) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	sorted_list_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->add = (gboolean (*)(GeeCollection*, gconstpointer)) sorted_list_real_add;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->add_all = (gboolean (*)(GeeCollection*, GeeCollection*)) sorted_list_real_add_all;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->clear = (void (*)(GeeCollection*)) sorted_list_real_clear;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->contains = (gboolean (*)(GeeCollection*, gconstpointer)) sorted_list_real_contains;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->contains_all = (gboolean (*)(GeeCollection*, GeeCollection*)) sorted_list_real_contains_all;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->remove = (gboolean (*)(GeeCollection*, gconstpointer)) sorted_list_real_remove;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->remove_all = (gboolean (*)(GeeCollection*, GeeCollection*)) sorted_list_real_remove_all;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->retain_all = (gboolean (*)(GeeCollection*, GeeCollection*)) sorted_list_real_retain_all;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->to_array = (gpointer* (*)(GeeCollection*, int*)) sorted_list_real_to_array;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_type = (GType(*)(GeeCollection*)) sorted_list_gee_collection_get_g_type;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeCollection*)) sorted_list_gee_collection_get_g_dup_func;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeCollection*)) sorted_list_gee_collection_get_g_destroy_func;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_read_only = sorted_list_real_get_read_only;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_is_empty = sorted_list_real_get_is_empty;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_size = sorted_list_real_get_size;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	iface->get_read_only_view = sorted_list_real_get_read_only_view;
#line 2760 "SortedList.c"
}


static void sorted_list_instance_init (SortedList * self) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	self->priv = SORTED_LIST_GET_PRIVATE (self);
#line 2767 "SortedList.c"
}


static void sorted_list_finalize (GObject* obj) {
	SortedList * self;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SORTED_LIST, SortedList);
#line 26 "/home/jens/Source/shotwell/src/SortedList.vala"
	_g_object_unref0 (self->priv->list);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	G_OBJECT_CLASS (sorted_list_parent_class)->finalize (obj);
#line 2779 "SortedList.c"
}


GType sorted_list_get_type (void) {
	static volatile gsize sorted_list_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedList), 0, (GInstanceInitFunc) sorted_list_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) sorted_list_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) sorted_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) sorted_list_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sorted_list_type_id;
		sorted_list_type_id = g_type_register_static (G_TYPE_OBJECT, "SortedList", &g_define_type_info, 0);
		g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_once_init_leave (&sorted_list_type_id__volatile, sorted_list_type_id);
	}
	return sorted_list_type_id__volatile;
}


static void _vala_sorted_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTED_LIST, SortedList);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_ELEMENT_TYPE:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_gtype (value, gee_traversable_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_TRAVERSABLE, GeeTraversable)));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_READ_ONLY:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_boolean (value, gee_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_IS_EMPTY:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_boolean (value, gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_SIZE:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_set_int (value, gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_READ_ONLY_VIEW:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_take_object (value, gee_collection_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_READ_ONLY_VIEW_AS_LIST:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		g_value_take_object (value, sorted_list_get_read_only_view_as_list (self));
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2842 "SortedList.c"
		default:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2848 "SortedList.c"
	}
}


static void _vala_sorted_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTED_LIST, SortedList);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_G_TYPE:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_G_DUP_FUNC:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		case SORTED_LIST_G_DESTROY_FUNC:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2876 "SortedList.c"
		default:
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/shotwell/src/SortedList.vala"
		break;
#line 2882 "SortedList.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



