#include "config.h"
#include "rsyslog.h"
#include "srUtils.h"

#line 6 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 115
#define YY_END_OF_BUFFER 116
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[591] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    9,    9,    0,    0,  116,  114,  113,  113,
      114,  114,  114,   54,   86,  114,  114,  114,  114,   91,
      114,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   55,   56,   85,  113,   86,
      114,  114,  114,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,  106,  105,
      105,  106,  106,   92,   94,  106,   97,   93,   95,   96,
      103,  103,  103,   68,   68,   67,   66,   65,   52,   51,
       51,   52,   10,    9,    9,   10,   10,    4,    8,    7,

       50,   48,   48,   50,   50,   50,   22,   24,   50,   11,
       29,   20,   23,   19,   25,   21,   44,   44,   14,   35,
       18,   36,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   26,   27,    0,    0,  112,    0,    0,   90,   90,
       90,   88,   99,   91,    0,   91,   91,   91,   91,   91,
       91,   91,    1,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,    0,    0,    0,    0,
        0,    0,    0,    0,   90,    0,    0,    0,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,    1,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,

       91,   91,    0,   98,    0,    0,  104,  100,   93,  103,
      103,  102,   69,   65,   53,    9,    0,    6,    0,    0,
        5,    0,   33,    0,   47,    0,    0,   45,    0,   46,
        0,  101,   42,    0,   44,   31,   34,   30,   32,   49,
       49,   49,   13,   38,   49,   15,   49,   49,    0,  108,
        0,  107,    0,    0,  110,    0,   90,   90,   87,   87,
       88,   89,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   60,
       91,   91,   91,   91,   84,    0,  111,   90,    0,    0,
       84,   91,   91,   91,   91,   91,   91,   91,   91,   91,

       91,   91,   91,   91,   91,   91,   91,   91,   60,   91,
       91,   91,   91,    0,    0,    0,    0,    0,    0,    0,
       45,    0,    0,   43,   16,   49,   17,   49,   49,    0,
      109,   90,   87,   87,   89,   91,   59,   91,   91,   91,
       58,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   57,   91,   91,   91,    0,    0,    0,
       91,   59,   91,   91,   58,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   57,   91,   91,
       91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       49,   49,   12,   91,   91,   91,   91,   91,   91,   91,

       91,   91,   91,   91,   91,   91,   91,   61,   91,   91,
       91,   62,    0,    0,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   61,   91,   91,   91,
       62,    0,   49,   49,   91,   91,   91,   91,   91,   91,
        0,   78,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,    0,    0,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   49,   49,
        0,   82,   91,   91,   91,    2,    0,   73,   91,   91,
        0,   79,    0,   72,   91,   91,   91,   91,   91,   91,
        0,   83,    0,   91,   91,    2,   91,   91,   91,   91,

       91,   49,   49,   91,   63,   91,   91,   91,   91,   91,
       91,    0,   75,   91,   91,   83,   91,   63,   91,   91,
       91,   91,   37,   49,    0,   77,   91,   91,   91,   91,
        0,   76,   91,    0,   74,    0,   71,   91,   49,   49,
        0,   81,   91,   91,   91,   91,   91,   39,   40,   91,
        0,   70,   91,   91,   91,   49,   91,   91,   91,   91,
       41,    0,   80,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,    3,   91,   91,   91,   91,   91,   64,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
       36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
       46,   47,   48,   49,   50,   51,   52,   53,   54,   55,
       56,   57,   58,   59,   60,    1,   61,   62,   63,   64,

       65,   66,   67,   68,   69,   39,   70,   71,   72,   73,
       74,   75,   76,   77,   78,   79,   80,   51,   81,   82,
       83,   84,   85,   59,   86,   87,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[88] =
    {   0,
        1,    2,    3,    4,    5,    6,    1,    7,    1,    1,
        6,    1,    1,    8,    9,   10,   11,   12,   13,   14,
       14,   15,   16,   17,    1,   18,    1,   19,   20,   21,
       22,   23,   23,   23,   21,   24,   24,   24,   24,   24,
       24,   24,   25,   24,   24,   24,   25,   24,   25,   24,
       26,   24,   27,   24,   24,   28,    6,   28,    1,   29,
       21,   22,   23,   23,   23,   21,   24,   24,   24,   24,
       24,   24,   25,   24,   24,   24,   25,   24,   25,   24,
       24,   27,   24,   24,    1,    1,    1
    } ;

static yyconst flex_uint16_t yy_base[681] =
    {   0,
        0,   87,  174,    0,  259,  260,  262,  265,  257,  262,
      284,    0,  370,  385,  401,    0, 1143, 4184, 4184, 4184,
        0, 1136,    0, 4184, 4184, 1114,  257,    0, 1103,    0,
        0,  457,  460,  439,  453,  451,  455,  457,  453,  468,
      471,  481,  468,  471,  464, 4184, 4184,    0,  537,  359,
     1100,  561,  536,  577,  590,  637,  595,  601,  552,  630,
      633,  635,  656,  658,  678,  680,  704,  683, 4184, 4184,
     4184,  493, 1059, 4184, 4184, 1037, 4184,    0, 4184, 4184,
     1046, 1024, 1006,    0, 4184, 4184, 4184,  372, 4184, 4184,
     4184,    0, 4184,  620,  625,  502,  492, 4184, 4184, 4184,

     4184, 4184, 4184,  965,  507,  625, 4184, 4184,  524, 4184,
     4184, 4184, 4184, 4184, 4184,  971,  582,  662, 4184,  254,
      954,  951,  593,    0,  629,  641,  647,  649,  648,  667,
      477, 4184, 4184,  747,  965, 4184,  778,  759,    0,  768,
      381,    0, 4184,    0,  933,  688,  706,  823,  824,  820,
      822,  826,    0,  826,  828,  546,  654,  826,  840,  835,
      836,  829,  835,  838,  839,  834,  913,  869,    0,  867,
      900,    0,  906,  889,  936,  766,  760,  950,  964,  913,
      983,  995,  935,  910,  959,  909,  971,  982,  846,  984,
      986,  998, 1004,  992, 1008, 1031, 1005,  979,  996, 1036,

     1039, 1041,  522, 4184,  379,  757, 4184, 4184,    0,  737,
      733, 4184,    0, 1071,    0, 1092,  577, 4184, 1077,  875,
     4184, 1079, 4184,  632, 4184, 1083,    0,    0, 1055, 4184,
     1085, 4184,  490,    0, 1101, 4184, 4184, 4184, 4184,    0,
      855,  991,    0,    0, 1037,    0,  874, 1079, 1122, 4184,
      677, 4184, 1167, 1138, 1144,  629, 1150,  613,    0,    0,
        0,    0, 1089, 1060, 1085,  540, 1095, 1101, 1224, 1057,
     1217, 1215, 1209, 1212, 1216, 1217, 1219, 1230, 1231,    0,
     1222, 1223, 1235, 1236,    0, 1269, 4184, 1272,  374,  970,
     1289, 1302, 1313, 1297, 1239, 1243, 1271, 1310, 1298, 1312,

     1314, 1306, 1317, 1238, 1318, 1320, 1309, 1356, 1261, 1325,
     1357, 1358, 1369, 1395, 1129,    0, 1135,    0, 1261,    0,
        0, 1384,    0,    0,    0, 1330,    0, 1359, 1364,  575,
     4184,  548,    0,    0,    0, 1364,    0, 1362, 1374, 1366,
        0, 1387, 1388, 1371, 1374,  478, 1384, 1388, 1379, 1396,
     1401, 1384, 1387,    0, 1398,  586, 1393, 1441, 1453, 1455,
     1423, 1406, 1425, 1432, 1410, 1438, 1445, 1439, 1437, 1442,
     1441, 1450, 1448, 1459, 1481, 1449, 1466, 1464, 1482, 1485,
     1492, 1525, 1518,    0, 1527,    0, 1529,    0, 1534,    0,
     1497, 1480,    0, 1489, 1504, 1493, 1494, 1525, 1510, 1572,

     1515, 1515, 1530, 1520, 1524, 1523, 1539,    0, 1543, 1548,
     1536,    0,  539,  727, 1542, 1563, 1546, 1560, 1545, 1618,
     1561, 1573, 1558, 1584, 1571, 1600, 1555, 1605, 1613, 1606,
     1586, 1588, 1599, 1601, 1649, 1613, 1610, 1632, 1626, 1663,
     1679, 4184,  459, 1619, 1693, 1698, 1640, 1629,  456, 1636,
     1638, 1645,  749, 1667, 1709, 1663, 1657, 1685, 1727, 1673,
     1743, 1755, 1691, 1694, 1678, 1699, 1711, 1720, 1698,  640,
     1773, 4184, 1693, 1686, 1715,    0, 1785, 4184, 1720, 1740,
     1798, 4184, 1804, 4184, 1746,  840, 1738, 1815, 1758, 1769,
     1780, 4184, 1789, 1772, 1770, 1774, 1787, 1779, 1827, 1806,

     1808, 1776, 1787, 1857,    0, 1788, 1802, 1794, 1814, 1878,
     1804, 1882, 4184, 1885, 1889, 1849, 1900, 1824, 1858, 1905,
     1911, 1916,  446, 1821, 1922, 4184, 1928, 1874, 1877, 1880,
     1935, 4184, 1889, 1941, 4184, 1946, 4184, 1894, 1916, 1918,
     1957, 4184, 1921, 1971, 1930, 1926, 1936,    0,  431, 1933,
     1976, 4184, 1931, 1931, 1943, 1930, 2001, 1951, 1946, 1956,
        0, 2006, 4184, 1950,  325, 1974, 1966, 1957, 1978, 1973,
     1992, 1983, 1978, 1998, 1991, 1991, 1993, 1996, 1999, 2001,
     2011, 2005,    0, 2010, 2001, 2018,  260, 2028, 4184, 4184,
     2099, 2128, 2157, 2186, 2215, 2244, 2253, 2280, 2309, 2330,

     2346, 2372, 2392, 2412, 2439, 2462, 2482, 2511, 2540, 2558,
     2587, 2616, 2635, 2664, 2693, 2722, 2747, 2776, 2792, 2821,
     2850, 2879, 2908, 2937, 2958, 2974, 3000, 3020, 3037, 3058,
     3081, 3108, 3134, 3157, 3179, 3208, 3232, 3258, 3276, 3305,
     3334, 3353, 3382, 3406, 3433, 3457, 3484, 3508, 3516, 3541,
     3570, 3594, 3608, 3618, 3647, 3676, 3705, 3734, 3763, 3792,
     3821, 3850, 3871, 3896, 3920, 3943, 3965, 3994, 4010, 4020,
     4030, 4049, 4065, 4075, 4085, 4101, 4111, 4121, 4131, 4154
    } ;

static yyconst flex_int16_t yy_def[681] =
    {   0,
      590,  590,  590,    3,  591,  591,  592,  592,  593,  593,
      590,   11,  594,  594,  590,   15,  590,  590,  590,  590,
      595,  596,  597,  590,  590,  590,  598,  598,  599,  600,
      601,  600,  600,  600,  600,  600,  600,  600,  600,  600,
      600,  600,  600,  600,  600,  590,  590,  598,  602,  603,
      604,  605,  606,  607,  607,  607,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,  590,  590,
      590,  608,  609,  590,  590,  590,  590,  610,  590,  590,
      611,  611,  590,  612,  590,  590,  590,  590,  590,  590,
      590,  613,  590,  590,  590,  614,  615,  590,  590,  590,

      590,  590,  590,  590,  616,  617,  590,  590,  618,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  619,  619,  619,  619,  619,  619,  619,  619,
      619,  590,  590,  620,  621,  590,  590,  590,  622,  622,
      623,  624,  590,  625,  626,  625,  625,  625,  625,  625,
      625,  625,  625,  625,  625,  625,  625,  625,  625,  625,
      625,  625,  625,  625,  625,  625,  627,  628,  629,  630,
      628,  631,  590,  629,  632,  630,  630,  633,  634,  625,
      635,  635,  182,  182,  182,  182,  182,  182,  182,  182,
      182,  182,  182,  182,  182,  182,  182,  182,  182,  182,

      182,  182,  636,  590,  637,  638,  590,  590,  639,  640,
      640,  590,  641,  590,  642,  590,  643,  590,  644,  645,
      590,  646,  590,  647,  590,  648,  649,  650,  651,  590,
      652,  590,  590,  653,  590,  590,  590,  590,  590,  654,
      654,  654,  654,  654,  654,  654,  654,  654,  590,  590,
      655,  590,  590,  590,  590,  656,  657,  658,  659,  660,
      661,  662,  663,  663,  663,  663,  663,  663,  663,  663,
      663,  663,  663,  663,  663,  663,  663,  663,  663,  663,
      663,  663,  663,  663,  664,  590,  590,  657,  590,  665,
      666,  667,  667,  293,  293,  293,  293,  293,  293,  293,

      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  668,  590,  669,  590,  670,  590,  671,
      672,  590,  673,  674,  675,  675,  675,  675,  675,  656,
      590,  658,  659,  660,  662,  663,  663,  663,  663,  663,
      663,  663,  663,  663,  663,  663,  663,  663,  663,  663,
      663,  663,  663,  663,  663,  663,  663,  665,  665,  665,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  668,  590,  676,  590,  677,  590,  678,  590,  679,
      675,  675,  675,  663,  663,  663,  663,  663,  663,  663,

      663,  663,  663,  663,  663,  663,  663,  663,  663,  663,
      663,  663,  590,  590,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  668,  675,  675,  663,  663,  663,  663,  663,  663,
      590,  590,  663,  663,  663,  663,  663,  663,  663,  663,
      663,  663,  590,  680,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  675,  675,
      590,  590,  663,  663,  663,  663,  590,  590,  663,  663,
      590,  590,  590,  590,  663,  663,  663,  663,  663,  663,
      680,  590,  680,  293,  293,  293,  293,  293,  293,  293,

      293,  675,  675,  663,  663,  663,  663,  663,  663,  663,
      663,  590,  590,  663,  663,  680,  293,  293,  293,  293,
      293,  293,  675,  675,  590,  590,  663,  663,  663,  663,
      590,  590,  663,  590,  590,  590,  590,  293,  675,  675,
      590,  590,  663,  663,  663,  663,  293,  675,  675,  663,
      590,  590,  663,  663,  293,  675,  663,  663,  663,  293,
      675,  590,  590,  663,  663,  293,  663,  663,  293,  663,
      663,  293,  663,  663,  293,  663,  663,  293,  663,  663,
      293,  663,  663,  293,  663,  293,  663,  293,  590,    0,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,

      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590
    } ;

static yyconst flex_uint16_t yy_nxt[4272] =
    {   0,
       18,   19,   20,   19,   21,   18,   22,   23,   18,   24,
       18,   18,   18,   25,   26,   18,   27,   28,   29,   30,
       30,   30,   31,   18,   18,   18,   28,   28,   28,   32,
       30,   33,   34,   35,   36,   37,   30,   38,   30,   30,
       39,   40,   30,   30,   41,   30,   42,   43,   44,   45,
       30,   30,   30,   30,   30,   18,   18,   18,   28,   30,
       32,   30,   33,   34,   35,   36,   37,   30,   38,   30,
       39,   40,   30,   30,   41,   30,   42,   43,   44,   45,
       30,   30,   30,   30,   46,   47,   48,   18,   49,   20,
       49,   21,   18,   22,   23,   18,   24,   18,   18,   18,

       50,   51,   18,   52,   28,   29,   30,   30,   30,   53,
       18,   18,   18,   28,   28,   28,   54,   55,   56,   57,
       58,   59,   60,   55,   61,   55,   55,   62,   63,   55,
       55,   64,   55,   65,   66,   67,   68,   55,   55,   55,
       55,   55,   18,   18,   18,   28,   30,   54,   55,   56,
       57,   58,   59,   60,   55,   61,   55,   62,   63,   55,
       55,   64,   55,   65,   66,   67,   68,   55,   55,   55,
       55,   46,   47,   48,   69,   70,   71,   70,   69,   72,
       73,   69,   69,   69,   69,   69,   74,   69,   69,   75,
       69,   69,   76,   69,   69,   69,   69,   69,   69,   77,

       69,   69,   69,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   79,
       69,   80,   69,   69,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   69,   69,
       69,   82,   82,   85,   85,   85,   85,   85,   85,   87,
      140,  589,   83,   83,   87,  141,   88,   88,   88,  236,
      237,   88,   88,   88,   89,   90,   91,   90,   89,   89,
       89,   89,   89,   89,   89,   89,   89,   89,   89,   89,

       89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
       89,   89,   89,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   89,
       89,   89,   89,   89,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   89,   89,
       89,   94,   95,   94,  172,   96,  172,  289,  173,  173,
       97,   98,   99,  260,  568,  100,   94,   95,   94,  290,
       96,  214,  214,  214,  139,   97,   98,   99,  314,  314,

      100,  101,  102,  103,  102,  104,  105,  101,  106,  107,
      108,  109,  110,  111,  112,  113,  114,  115,  101,  116,
      117,  118,  118,  101,  119,  120,  121,  122,  101,  101,
      123,  124,  125,  126,  124,  124,  124,  124,  127,  124,
      124,  124,  124,  128,  129,  124,  124,  124,  130,  131,
      124,  124,  124,  124,  124,  124,  132,  101,  133,  101,
      101,  123,  124,  125,  126,  124,  124,  124,  124,  127,
      124,  124,  124,  128,  129,  124,  124,  124,  130,  131,
      124,  124,  124,  124,  124,  101,  101,  101,  146,  147,
      556,  153,  149,  150,  151,  152,  155,  156,  204,  154,

      158,  162,  221,  148,  164,  539,  166,  218,  165,  233,
      233,  157,  225,  248,  160,  487,  163,  159,  479,  146,
      147,  149,  153,  150,  151,  152,  155,  204,  156,  154,
      161,  158,  162,  148,  230,  164,  166,  402,  167,  165,
      167,  157,  413,  176,  248,  160,  163,  159,  222,  205,
      331,  169,  177,  169,  414,  145,  145,  145,  219,  170,
      161,  139,  139,  226,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  140,  139,  139,  331,  205,  141,
      231,  181,  218,  272,  139,  139,  139,  139,  139,  139,
      171,  144,  179,  144,  172,  187,  180,  180,  144,  340,

      144,  233,  233,  171,  144,  179,  144,  172,  182,  180,
      180,  144,  181,  144,  272,  331,  139,  139,  139,  139,
      139,  216,  216,  216,  181,  187,  216,  216,  216,  227,
      181,  331,  227,  219,  234,  241,  144,  225,  181,  182,
      411,  186,  227,  227,  181,  139,  139,  139,  185,  144,
      171,  144,  179,  144,  172,  181,  180,  180,  144,  181,
      144,  181,  181,  234,  181,  241,  183,  189,  181,  411,
      188,  186,  242,  181,  181,  190,  181,  185,  191,  252,
      184,  235,  235,  235,  243,  192,  273,  194,  226,  244,
      181,  503,  245,  181,  246,  181,  144,  183,  189,  193,

      188,  181,  242,  181,  195,  190,  181,  181,  191,  181,
      184,  196,  181,  198,  243,  247,  192,  273,  194,  244,
      503,  181,  245,  181,  246,  202,  181,  197,  199,  193,
      453,  181,  454,  181,  195,  211,  263,  200,  181,  211,
      181,  201,  196,  181,  198,  247,  264,  181,  249,  250,
      249,  181,  453,  181,  454,  202,  181,  197,  199,  207,
      254,  255,  254,  289,  181,  256,  263,  590,  200,  257,
      255,  257,  201,  590,  258,  290,  264,  181,  251,  251,
      252,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,

      251,  251,  251,  251,  251,  251,  251,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  251,  251,  251,  251,  251,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  251,  251,  251,  265,  266,  267,  268,  269,
      270,  271,  274,  275,  176,  277,  279,  280,  281,  282,
      283,  284,  278,  276,  172,  221,  172,  325,  173,  173,
      286,  287,  286,  510,  181,  265,  266,  267,  268,  269,

      270,  271,  274,  328,  275,  277,  279,  280,  281,  282,
      283,  284,  278,  276,  167,  172,  167,  172,  325,  173,
      173,  172,  510,  172,  181,  173,  173,  169,  179,  169,
      172,  222,  180,  180,  328,  170,  139,  288,  287,  288,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  294,  289,  139,  262,  296,  181,  181,  139,
      139,  139,  139,  139,  139,  290,  177,  136,  285,  145,
      145,  145,  262,  358,  359,  293,  239,  285,  144,  238,
      144,  285,  294,  181,  232,  144,  296,  181,  181,  285,
      223,  139,  139,  139,  139,  139,  171,  144,  179,  144,

      172,  295,  180,  180,  144,  293,  144,  181,  171,  144,
      179,  144,  172,  181,  180,  180,  144,  297,  144,  181,
      139,  139,  139,  144,  212,  298,  211,  309,  299,  300,
      181,  295,  181,  326,  181,  301,  302,  181,  303,  310,
      181,  304,  144,  292,  181,  308,  181,  297,  211,  181,
      208,  305,  181,  181,  144,  298,  181,  309,  299,  300,
      181,  207,  181,  326,  181,  230,  301,  302,  303,  310,
      181,  306,  304,  292,  181,  308,  181,  311,  307,  181,
      312,  305,  181,  181,  181,  327,  181,  181,  313,  181,
      214,  214,  214,  216,  216,  216,  315,  315,  317,  317,

      337,  306,  319,  319,  322,  322,  344,  311,  307,  181,
      312,  231,  329,  138,  181,  327,  143,  181,  313,  181,
      235,  235,  235,  249,  250,  249,  336,  138,  341,  316,
      337,  318,  338,  339,  342,  320,  344,  323,  136,  254,
      255,  254,  590,  329,  256,  254,  255,  254,  383,  383,
      256,  257,  255,  257,  385,  385,  258,  336,  316,  341,
      318,  590,  338,  339,  320,  342,  323,  251,  251,  252,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  253,  253,  253,  253,

      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  251,  251,  251,  251,  251,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  251,  251,  251,  343,  590,  345,  346,  347,  348,
      349,  350,  351,  352,  353,  590,  354,  355,  356,  357,
      286,  287,  286,  288,  287,  288,  365,  590,  181,  181,
      387,  387,  373,  181,  590,  343,  345,  346,  347,  348,
      349,  350,  351,  285,  352,  353,  354,  355,  340,  356,

      357,  181,  285,  144,  366,  144,  285,  365,  181,  181,
      144,  181,  373,  181,  285,  171,  144,  179,  144,  172,
      590,  180,  180,  144,  590,  144,  171,  144,  179,  144,
      172,  181,  180,  180,  144,  366,  144,  181,  181,  361,
      367,  181,  376,  590,  363,  364,  181,  368,  144,  181,
      181,  369,  181,  362,  181,  371,  370,  181,  181,  590,
      181,  144,  374,  375,  372,  181,  590,  181,  181,  378,
      361,  367,  144,  376,  363,  364,  181,  368,  391,  181,
      181,  369,  181,  362,  181,  371,  370,  181,  181,  377,
      181,  380,  374,  375,  372,  181,  181,  181,  181,  378,

      204,  379,  381,  389,  389,  392,  393,  394,  391,  181,
      395,  396,  590,  397,  382,  382,  398,  399,  590,  400,
      377,  404,  380,  401,  403,  405,  181,  181,  181,  406,
      407,  379,  408,  381,  409,  392,  393,  394,  410,  181,
      395,  412,  396,  397,  358,  359,  181,  398,  399,  400,
      181,  205,  404,  401,  403,  405,  590,  590,  413,  590,
      406,  407,  408,  181,  409,  181,  415,  418,  410,  417,
      414,  412,  181,  416,  419,  590,  181,  181,  181,  181,
      181,  422,  181,  423,  590,  181,  421,  420,  181,  181,
      181,  590,  425,  181,  424,  181,  415,  427,  418,  181,

      417,  402,  181,  416,  181,  419,  181,  181,  181,  181,
      426,  422,  181,  428,  423,  181,  421,  420,  181,  181,
      181,  181,  429,  425,  424,  181,  433,  427,  434,  181,
      204,  435,  181,  436,  181,  437,  181,  217,  217,  430,
      431,  426,  438,  428,  432,  432,  220,  220,  224,  224,
      440,  181,  429,  229,  229,  181,  439,  433,  434,  443,
      444,  435,  181,  445,  436,  437,  446,  447,  430,  448,
      431,  449,  438,  441,  441,  441,  450,  451,  590,  452,
      440,  205,  181,  442,  455,  459,  181,  439,  457,  443,
      444,  458,  456,  204,  445,  181,  446,  447,  181,  448,

      181,  181,  449,  181,  462,  460,  461,  450,  451,  452,
      590,  181,  181,  181,  455,  459,  181,  464,  457,  441,
      441,  441,  458,  456,  181,  181,  181,  463,  181,  442,
      181,  181,  465,  181,  462,  460,  469,  461,  466,  590,
      181,  181,  467,  181,  205,  181,  181,  464,  470,  468,
      471,  471,  471,  181,  181,  473,  181,  463,  181,  474,
      472,  475,  476,  465,  477,  477,  477,  469,  480,  466,
      181,  485,  492,  467,  478,  181,  181,  486,  470,  468,
      441,  441,  441,  181,  488,  473,  489,  490,  181,  474,
      442,  590,  475,  476,  481,  481,  481,  181,  480,  483,

      483,  483,  485,  181,  482,  494,  495,  486,  590,  484,
      471,  471,  471,  181,  488,  590,  489,  490,  181,  505,
      472,  496,  497,  493,  590,  181,  590,  181,  477,  477,
      477,  181,  479,  181,  181,  494,  495,  487,  478,  181,
      502,  504,  498,  181,  481,  481,  481,  499,  181,  181,
      505,  181,  496,  497,  482,  181,  483,  483,  483,  500,
      181,  181,  501,  506,  181,  590,  484,  181,  507,  181,
      502,  504,  498,  508,  471,  471,  471,  499,  511,  181,
      509,  181,  590,  181,  472,  492,  477,  477,  477,  500,
      181,  514,  501,  506,  516,  181,  478,  181,  507,  481,

      481,  481,  515,  518,  508,  483,  483,  483,  511,  482,
      181,  509,  181,  181,  181,  484,  512,  512,  512,  181,
      517,  519,  514,  523,  524,  181,  513,  181,  512,  512,
      512,  528,  520,  515,  518,  527,  493,  590,  513,  521,
      181,  522,  181,  529,  181,  493,  181,  533,  181,  181,
      517,  530,  519,  523,  492,  524,  590,  181,  525,  525,
      525,  520,  528,  590,  181,  527,  590,  181,  526,  540,
      521,  590,  522,  529,  590,  590,  181,  533,  181,  531,
      531,  531,  530,  512,  512,  512,  534,  534,  534,  532,
      536,  536,  536,  513,  181,  538,  535,  181,  181,  540,

      537,  525,  525,  525,  543,  493,  531,  531,  531,  590,
      544,  526,  534,  534,  534,  590,  532,  536,  536,  536,
      545,  590,  535,  525,  525,  525,  538,  537,  181,  541,
      541,  541,  546,  526,  547,  543,  531,  531,  531,  542,
      181,  544,  534,  534,  534,  181,  532,  536,  536,  536,
      545,  181,  535,  548,  549,  590,  181,  537,  541,  541,
      541,  550,  546,  553,  547,  554,  557,  561,  542,  555,
      181,  558,  551,  551,  551,  181,  181,  551,  551,  551,
      559,  181,  552,  560,  548,  549,  181,  552,  564,  590,
      565,  550,  567,  566,  553,  554,  181,  557,  561,  570,

      555,  558,  562,  562,  562,  571,  181,  562,  562,  562,
      559,  572,  563,  560,  181,  573,  569,  563,  181,  564,
      565,  574,  567,  181,  566,  575,  181,  576,  577,  582,
      570,  181,  579,  580,  583,  571,  181,  581,  585,  589,
      578,  584,  572,  586,  181,  573,  569,  587,  181,  590,
      181,  181,  574,  181,  590,  575,  590,  576,  181,  577,
      582,  181,  579,  580,  588,  583,  181,  581,  181,  585,
      578,  590,  584,  590,  586,  590,  590,  587,  590,  590,
      181,  181,  590,  590,  590,  590,  590,  590,  181,  590,
      590,  590,  590,  590,  588,  590,  590,  590,  181,   81,

       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   86,   86,   86,
       86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
       86,   86,   86,   86,   86,   86,   86,   86,   86,   86,
       86,   86,   86,   86,   86,   86,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,

       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,  134,  590,  590,  590,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  137,  137,  137,  137,  137,  137,  137,
      139,  139,  590,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,

      139,  139,  139,  139,  139,  139,  139,  139,  139,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  144,  144,
      144,  590,  590,  144,  144,  590,  144,  590,  590,  590,
      144,  144,  144,  144,  144,  144,  144,  590,  144,  145,
      145,  590,  590,  590,  590,  590,  145,  145,  145,  145,
      145,  145,  145,  168,  590,  168,  590,  590,  590,  168,
      168,  590,  168,  590,  590,  590,  590,  168,  590,  590,
      590,  590,  168,  168,  168,  168,  168,  168,  168,  171,

      590,  171,  590,  171,  590,  171,  590,  590,  590,  590,
      590,  590,  171,  171,  171,  171,  171,  171,  171,  174,
      590,  590,  174,  174,  590,  174,  174,  174,  590,  590,
      590,  590,  174,  174,  174,  174,  174,  174,  174,  175,
      175,  590,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  178,  590,
      590,  590,  178,  590,  590,  178,  178,  590,  590,  590,
      590,  590,  178,  178,  178,  178,  178,  178,  178,  181,
      181,  181,  181,  181,  590,  181,  181,  590,  181,  590,

      590,  590,  181,  181,  181,  181,  181,  181,  181,  590,
      181,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
      206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
      206,  206,  206,  206,  206,  206,  206,  206,  206,  209,
      590,  209,  209,  590,  590,  590,  590,  590,  209,  209,
      209,  209,  209,  209,  209,  590,  209,  210,  210,  210,
      210,  210,  210,  210,  590,  210,  210,  210,  210,  210,

      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  213,  590,  590,  590,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  213,  213,  215,  215,  590,  215,  215,
      590,  590,  590,  590,  590,  215,  215,  215,  215,  215,
      215,  215,  590,  215,  217,  217,  217,  217,  217,  217,
      590,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  220,  220,  220,  220,  220,  220,  220,

      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  224,  224,  224,  224,  224,  224,  590,  224,
      224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
      224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
      224,  228,  590,  228,  590,  590,  590,  590,  228,  228,
      590,  590,  590,  590,  590,  590,  228,  228,  228,  228,
      228,  228,  228,  228,  590,  228,  229,  229,  229,  229,
      229,  229,  229,  229,  229,  229,  229,  229,  229,  229,
      229,  229,  229,  229,  229,  229,  229,  229,  229,  229,

      229,  229,  229,  229,  229,  240,  240,  590,  590,  590,
      590,  590,  240,  240,  240,  240,  240,  240,  240,  590,
      240,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  139,
      139,  590,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,

      139,  139,  139,  139,  139,  139,  139,  139,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  261,  261,  590,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  144,  144,  144,  590,
      590,  144,  144,  590,  144,  590,  590,  590,  144,  144,
      144,  144,  144,  144,  144,  590,  144,  145,  145,  145,
      590,  590,  590,  590,  145,  145,  145,  145,  145,  145,

      145,  168,  590,  168,  590,  590,  590,  168,  168,  590,
      168,  590,  590,  590,  590,  168,  590,  590,  590,  590,
      168,  168,  168,  168,  168,  168,  168,  171,  590,  171,
      590,  171,  590,  171,  590,  590,  590,  590,  590,  590,
      171,  171,  171,  171,  171,  171,  171,  174,  174,  590,
      174,  174,  174,  590,  590,  590,  590,  174,  174,  174,
      174,  174,  174,  174,  177,  590,  590,  590,  177,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  177,  177,
      177,  177,  177,  177,  177,  285,  590,  590,  285,  590,
      285,  590,  285,  590,  285,  590,  590,  285,  285,  590,

      590,  285,  285,  285,  285,  285,  285,  285,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  178,  590,  590,
      590,  590,  590,  178,  178,  590,  590,  178,  178,  178,
      590,  590,  590,  590,  178,  178,  178,  178,  178,  178,
      178,  291,  590,  590,  291,  291,  291,  291,  291,  590,
      291,  291,  590,  291,  291,  590,  590,  291,  291,  291,
      291,  291,  291,  291,  590,  291,  181,  181,  181,  181,
      181,  590,  181,  181,  590,  181,  590,  590,  590,  181,

      181,  181,  181,  181,  181,  181,  590,  181,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  590,  590,
      590,  590,  590,  590,  590,  203,  590,  590,  590,  590,
      203,  590,  203,  203,  590,  590,  203,  203,  206,  206,
      206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
      206,  206,  206,  206,  206,  206,  206,  206,  206,  206,
      206,  206,  206,  206,  206,  206,  206,  209,  590,  209,
      209,  590,  590,  590,  590,  590,  209,  209,  209,  209,

      209,  209,  209,  590,  209,  210,  210,  210,  210,  210,
      210,  210,  590,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
      210,  210,  210,  210,  213,  590,  590,  590,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
      213,  213,  213,  215,  215,  590,  215,  215,  590,  590,
      590,  590,  590,  215,  215,  215,  215,  215,  215,  215,
      590,  215,  217,  217,  217,  217,  217,  217,  590,  217,
      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,

      217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
      217,  217,  217,  590,  590,  590,  590,  590,  590,  217,
      590,  590,  590,  590,  590,  590,  590,  217,  590,  590,
      217,  590,  217,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  220,  220,  220,  220,  220,  220,
      220,  220,  220,  220,  590,  590,  590,  590,  590,  590,
      220,  590,  590,  590,  590,  590,  590,  590,  220,  590,
      590,  220,  590,  220,  224,  224,  224,  224,  224,  224,
      590,  224,  224,  224,  224,  224,  224,  224,  224,  224,

      224,  224,  224,  224,  224,  224,  224,  224,  224,  224,
      224,  224,  224,  224,  224,  590,  590,  590,  590,  590,
      590,  224,  590,  590,  590,  590,  590,  590,  590,  224,
      590,  590,  224,  590,  224,  228,  228,  228,  228,  228,
      228,  228,  228,  590,  228,  321,  590,  590,  590,  590,
      590,  321,  321,  590,  321,  321,  590,  590,  590,  590,
      321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
      229,  229,  229,  229,  229,  229,  229,  229,  229,  229,
      229,  229,  229,  229,  229,  229,  229,  229,  229,  229,
      229,  229,  229,  229,  229,  229,  229,  229,  229,  229,

      229,  590,  590,  590,  590,  590,  590,  229,  590,  590,
      590,  590,  590,  590,  590,  229,  590,  590,  229,  590,
      229,  324,  324,  590,  590,  590,  590,  590,  324,  324,
      324,  240,  240,  590,  590,  590,  590,  590,  240,  240,
      240,  240,  240,  240,  240,  590,  240,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
      251,  251,  251,  251,  251,  251,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,

      330,  330,  330,  330,  330,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  332,  332,  332,  332,  332,  332,
      332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
      332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
      332,  332,  332,  333,  333,  590,  333,  333,  333,  333,
      333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
      333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
      333,  333,  334,  334,  590,  334,  334,  334,  334,  334,

      334,  334,  334,  334,  334,  334,  334,  334,  334,  334,
      334,  334,  334,  334,  334,  334,  334,  334,  334,  334,
      334,  261,  261,  590,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      261,  261,  261,  261,  261,  261,  261,  261,  261,  261,
      335,  335,  590,  335,  335,  335,  335,  335,  335,  335,
      335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
      335,  335,  335,  335,  335,  335,  335,  335,  335,  144,
      144,  144,  590,  590,  144,  144,  590,  144,  590,  590,
      590,  144,  144,  144,  144,  144,  144,  144,  590,  144,

      285,  590,  590,  285,  590,  285,  590,  285,  590,  285,
      590,  590,  285,  285,  590,  590,  285,  285,  285,  285,
      285,  285,  285,  360,  360,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      360,  360,  360,  360,  360,  360,  360,  291,  590,  590,
      291,  291,  291,  291,  291,  590,  291,  291,  590,  291,
      291,  590,  590,  291,  291,  291,  291,  291,  291,  291,
      590,  291,  181,  181,  181,  181,  181,  590,  181,  181,
      590,  181,  590,  590,  590,  181,  181,  181,  181,  181,
      181,  181,  590,  181,  203,  203,  203,  203,  203,  203,

      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
      203,  203,  203,  384,  384,  590,  590,  590,  590,  590,
      384,  384,  384,  386,  386,  590,  590,  590,  590,  590,
      386,  386,  386,  388,  388,  590,  590,  590,  590,  590,
      388,  388,  388,  321,  590,  590,  590,  590,  590,  321,
      321,  590,  321,  321,  590,  590,  590,  590,  321,  321,
      321,  321,  321,  321,  321,  321,  321,  321,  390,  390,
      590,  590,  590,  590,  590,  390,  390,  390,  324,  324,
      590,  590,  590,  590,  590,  324,  324,  324,  240,  240,

      590,  590,  590,  590,  590,  240,  240,  240,  240,  240,
      240,  240,  590,  240,  217,  217,  590,  590,  590,  590,
      590,  217,  217,  217,  220,  220,  590,  590,  590,  590,
      590,  220,  220,  220,  224,  224,  590,  590,  590,  590,
      590,  224,  224,  224,  229,  229,  590,  590,  590,  590,
      590,  229,  229,  229,  491,  491,  491,  491,  491,  491,
      491,  491,  491,  491,  491,  491,  491,  491,  491,  491,
      491,  491,  491,  491,  491,  491,  491,  491,  491,  491,
      491,  491,  491,   17,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,

      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590
    } ;

static yyconst flex_int16_t yy_chk[4272] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,

        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,

        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    5,    6,    7,    7,    7,    8,    8,    8,    9,
       27,  587,    5,    6,   10,   27,    9,    9,    9,  120,
      120,   10,   10,   10,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,

       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   13,   13,   13,   50,   13,   50,  289,   50,   50,
       13,   13,   13,  141,  565,   13,   14,   14,   14,  289,
       14,   88,   88,   88,  141,   14,   14,   14,  205,  205,

       14,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   32,   33,
      549,   38,   34,   35,   36,   37,   39,   40,   72,   38,

       41,   43,   97,   33,   44,  523,   45,   96,   44,  233,
      233,   40,  105,  131,   42,  449,   43,   41,  443,   32,
       33,   34,   38,   35,   36,   37,   39,  203,   40,   38,
       42,   41,   43,   33,  109,   44,   45,  346,   49,   44,
       49,   40,  413,   53,  131,   42,   43,   41,   97,   72,
      332,   49,   53,   49,  413,   53,   53,   53,   96,   49,
       42,   52,   52,  105,   52,   52,   52,   52,   52,   52,
       52,   52,   52,   52,   52,   52,   52,  330,  203,   52,
      109,   59,  217,  156,   52,   52,   52,   52,   52,   52,
       54,   54,   54,   54,   54,   59,   54,   54,   54,  266,

       54,  117,  117,   55,   55,   55,   55,   55,   54,   55,
       55,   55,   59,   55,  156,  258,   52,   52,   52,   52,
       52,   94,   94,   94,   57,   59,   95,   95,   95,  106,
       58,  256,  106,  217,  117,  123,   54,  224,   57,   54,
      356,   58,  106,  106,   58,   52,   52,   52,   57,   55,
       56,   56,   56,   56,   56,   57,   56,   56,   56,   60,
       56,   58,   61,  117,   62,  123,   56,   61,   57,  356,
       60,   58,  125,   60,   58,   61,   61,   57,   62,  251,
       56,  118,  118,  118,  126,   63,  157,   64,  224,  127,
       60,  470,  128,   61,  129,   62,   56,   56,   61,   63,

       60,   64,  125,   60,   64,   61,   61,   65,   62,   66,
       56,   65,   68,   66,  126,  130,   63,  157,   64,  127,
      470,   65,  128,   66,  129,   68,   68,   65,   66,   63,
      414,   64,  414,   67,   64,  211,  146,   67,   65,  210,
       66,   67,   65,   68,   66,  130,  147,   67,  134,  134,
      134,   65,  453,   66,  453,   68,   68,   65,   66,  206,
      138,  138,  138,  177,   67,  138,  146,  177,   67,  140,
      140,  140,   67,  176,  140,  177,  147,   67,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,

      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  148,  149,  150,  151,  152,
      154,  155,  158,  159,  170,  160,  161,  162,  163,  164,
      165,  166,  160,  159,  168,  220,  168,  241,  168,  168,
      174,  174,  174,  486,  189,  148,  149,  150,  151,  152,

      154,  155,  158,  247,  159,  160,  161,  162,  163,  164,
      165,  166,  160,  159,  167,  171,  167,  171,  241,  171,
      171,  173,  486,  173,  189,  173,  173,  167,  180,  167,
      180,  220,  180,  180,  247,  167,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  184,  178,  175,  145,  186,  186,  184,  175,
      175,  175,  175,  175,  175,  178,  178,  135,  179,  178,
      178,  178,  178,  290,  290,  183,  122,  179,  179,  121,
      179,  179,  184,  183,  116,  179,  186,  186,  184,  179,
      104,  175,  175,  175,  175,  175,  181,  181,  181,  181,

      181,  185,  181,  181,  181,  183,  181,  185,  182,  182,
      182,  182,  182,  183,  182,  182,  182,  187,  182,  187,
      175,  175,  175,  179,   83,  188,   82,  198,  190,  191,
      188,  185,  190,  242,  191,  192,  193,  185,  194,  199,
      194,  195,  181,  182,  199,  197,  192,  187,   81,  187,
       76,  195,  193,  197,  182,  188,  195,  198,  190,  191,
      188,   73,  190,  242,  191,  229,  192,  193,  194,  199,
      194,  196,  195,  182,  199,  197,  192,  200,  196,  196,
      201,  195,  193,  197,  200,  245,  195,  201,  202,  202,
      214,  214,  214,  216,  216,  216,  219,  219,  222,  222,

      264,  196,  226,  226,  231,  231,  270,  200,  196,  196,
      201,  229,  248,   51,  200,  245,   29,  201,  202,  202,
      235,  235,  235,  249,  249,  249,  263,   26,  267,  219,
      264,  222,  265,  265,  268,  226,  270,  231,   22,  254,
      254,  254,   17,  248,  254,  255,  255,  255,  315,  315,
      255,  257,  257,  257,  317,  317,  257,  263,  219,  267,
      222,    0,  265,  265,  226,  268,  231,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,

      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  253,  253,
      253,  253,  253,  253,  269,    0,  271,  272,  273,  274,
      275,  276,  277,  278,  279,    0,  281,  282,  283,  284,
      286,  286,  286,  288,  288,  288,  296,    0,  304,  295,
      319,  319,  304,  296,    0,  269,  271,  272,  273,  274,
      275,  276,  277,  291,  278,  279,  281,  282,  295,  283,

      284,  309,  291,  291,  297,  291,  291,  296,  304,  295,
      291,  297,  304,  296,  291,  292,  292,  292,  292,  292,
        0,  292,  292,  292,    0,  292,  293,  293,  293,  293,
      293,  309,  293,  293,  293,  297,  293,  294,  299,  292,
      298,  297,  307,    0,  294,  294,  302,  299,  291,  307,
      298,  300,  300,  293,  301,  302,  301,  303,  305,    0,
      306,  292,  305,  306,  303,  310,    0,  294,  299,  310,
      292,  298,  293,  307,  294,  294,  302,  299,  326,  307,
      298,  300,  300,  293,  301,  302,  301,  303,  305,  308,
      306,  312,  305,  306,  303,  310,  308,  311,  312,  310,

      314,  311,  313,  322,  322,  328,  329,  336,  326,  313,
      338,  339,    0,  340,  314,  314,  342,  343,    0,  344,
      308,  348,  312,  345,  347,  349,  308,  311,  312,  350,
      351,  311,  352,  313,  353,  328,  329,  336,  355,  313,
      338,  357,  339,  340,  358,  358,  362,  342,  343,  344,
      365,  314,  348,  345,  347,  349,  359,  359,  360,  360,
      350,  351,  352,  361,  353,  363,  361,  366,  355,  364,
      360,  357,  364,  363,  367,    0,  362,  369,  366,  368,
      365,  371,  370,  372,    0,  367,  369,  368,  373,  376,
      372,    0,  374,  361,  373,  363,  361,  376,  366,  374,

      364,  370,  364,  363,  378,  367,  377,  369,  366,  368,
      375,  371,  370,  377,  372,  367,  369,  368,  373,  376,
      372,  375,  379,  374,  373,  380,  391,  376,  392,  374,
      382,  394,  381,  395,  378,  396,  377,  383,  383,  380,
      381,  375,  397,  377,  382,  382,  385,  385,  387,  387,
      399,  375,  379,  389,  389,  380,  398,  391,  392,  401,
      402,  394,  381,  403,  395,  396,  404,  405,  380,  406,
      381,  407,  397,  400,  400,  400,  409,  410,    0,  411,
      399,  382,  415,  400,  415,  419,  417,  398,  417,  401,
      402,  418,  416,  432,  403,  427,  404,  405,  423,  406,

      418,  421,  407,  416,  423,  421,  422,  409,  410,  411,
        0,  425,  415,  422,  415,  419,  417,  425,  417,  420,
      420,  420,  418,  416,  424,  427,  431,  424,  423,  420,
      418,  421,  426,  416,  423,  421,  433,  422,  428,    0,
      426,  425,  429,  422,  432,  428,  430,  425,  434,  430,
      435,  435,  435,  429,  424,  436,  431,  424,  420,  437,
      435,  438,  439,  426,  440,  440,  440,  433,  444,  428,
      426,  447,  454,  429,  440,  428,  430,  448,  434,  430,
      441,  441,  441,  429,  450,  436,  451,  452,  420,  437,
      441,    0,  438,  439,  445,  445,  445,  457,  444,  446,

      446,  446,  447,  456,  445,  456,  457,  448,    0,  446,
      455,  455,  455,  460,  450,    0,  451,  452,  465,  474,
      455,  458,  463,  454,    0,  458,    0,  457,  459,  459,
      459,  463,  460,  456,  464,  456,  457,  465,  459,  466,
      469,  473,  464,  460,  461,  461,  461,  466,  465,  455,
      474,  467,  458,  463,  461,  458,  462,  462,  462,  467,
      468,  463,  468,  475,  464,    0,  462,  459,  479,  466,
      469,  473,  464,  480,  471,  471,  471,  466,  487,  455,
      485,  467,    0,  461,  471,  491,  477,  477,  477,  467,
      468,  489,  468,  475,  493,  462,  477,  459,  479,  481,

      481,  481,  490,  495,  480,  483,  483,  483,  487,  481,
      495,  485,  494,  461,  496,  483,  488,  488,  488,  498,
      494,  497,  489,  502,  503,  462,  488,  497,  499,  499,
      499,  507,  498,  490,  495,  506,  491,    0,  499,  500,
      495,  501,  494,  508,  496,  493,  500,  511,  501,  498,
      494,  509,  497,  502,  516,  503,    0,  497,  504,  504,
      504,  498,  507,    0,  518,  506,    0,  499,  504,  524,
      500,    0,  501,  508,    0,    0,  500,  511,  501,  510,
      510,  510,  509,  512,  512,  512,  514,  514,  514,  510,
      515,  515,  515,  512,  518,  519,  514,  499,  519,  524,

      515,  517,  517,  517,  528,  516,  520,  520,  520,    0,
      529,  517,  521,  521,  521,    0,  520,  522,  522,  522,
      530,    0,  521,  525,  525,  525,  519,  522,  519,  527,
      527,  527,  533,  525,  538,  528,  531,  531,  531,  527,
      517,  529,  534,  534,  534,  520,  531,  536,  536,  536,
      530,  521,  534,  539,  540,    0,  522,  536,  541,  541,
      541,  543,  533,  545,  538,  546,  550,  556,  541,  547,
      517,  553,  544,  544,  544,  520,  547,  551,  551,  551,
      554,  521,  544,  555,  539,  540,  522,  551,  558,    0,
      559,  543,  564,  560,  545,  546,  560,  550,  556,  567,

      547,  553,  557,  557,  557,  568,  547,  562,  562,  562,
      554,  569,  557,  555,  566,  570,  566,  562,  569,  558,
      559,  571,  564,  572,  560,  572,  560,  573,  574,  579,
      567,  575,  576,  577,  580,  568,  578,  578,  582,  588,
      575,  581,  569,  584,  566,  570,  566,  585,  569,    0,
      584,  581,  571,  572,    0,  572,    0,  573,  586,  574,
      579,  575,  576,  577,  586,  580,  578,  578,  588,  582,
      575,    0,  581,    0,  584,    0,    0,  585,    0,    0,
      584,  581,    0,    0,    0,    0,    0,    0,  586,    0,
        0,    0,    0,    0,  586,    0,    0,    0,  588,  591,

      591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
      591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
      591,  591,  591,  591,  591,  591,  591,  591,  592,  592,
      592,  592,  592,  592,  592,  592,  592,  592,  592,  592,
      592,  592,  592,  592,  592,  592,  592,  592,  592,  592,
      592,  592,  592,  592,  592,  592,  592,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
      593,  593,  593,  593,  593,  593,  594,  594,  594,  594,
      594,  594,  594,  594,  594,  594,  594,  594,  594,  594,

      594,  594,  594,  594,  594,  594,  594,  594,  594,  594,
      594,  594,  594,  594,  594,  595,    0,    0,    0,  595,
      595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  595,  596,  596,  596,  596,  596,  596,
      596,  596,  596,  596,  596,  596,  596,  596,  596,  596,
      596,  596,  596,  596,  596,  596,  596,  596,  596,  596,
      596,  596,  596,  597,  597,  597,  597,  597,  597,  597,
      598,  598,    0,  598,  598,  598,  598,  598,  598,  598,
      598,  598,  598,  598,  598,  598,  598,  598,  598,  598,

      598,  598,  598,  598,  598,  598,  598,  598,  598,  599,
      599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
      599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
      599,  599,  599,  599,  599,  599,  599,  599,  600,  600,
      600,    0,    0,  600,  600,    0,  600,    0,    0,    0,
      600,  600,  600,  600,  600,  600,  600,    0,  600,  601,
      601,    0,    0,    0,    0,    0,  601,  601,  601,  601,
      601,  601,  601,  602,    0,  602,    0,    0,    0,  602,
      602,    0,  602,    0,    0,    0,    0,  602,    0,    0,
        0,    0,  602,  602,  602,  602,  602,  602,  602,  603,

        0,  603,    0,  603,    0,  603,    0,    0,    0,    0,
        0,    0,  603,  603,  603,  603,  603,  603,  603,  604,
        0,    0,  604,  604,    0,  604,  604,  604,    0,    0,
        0,    0,  604,  604,  604,  604,  604,  604,  604,  605,
      605,    0,  605,  605,  605,  605,  605,  605,  605,  605,
      605,  605,  605,  605,  605,  605,  605,  605,  605,  605,
      605,  605,  605,  605,  605,  605,  605,  605,  606,    0,
        0,    0,  606,    0,    0,  606,  606,    0,    0,    0,
        0,    0,  606,  606,  606,  606,  606,  606,  606,  607,
      607,  607,  607,  607,    0,  607,  607,    0,  607,    0,

        0,    0,  607,  607,  607,  607,  607,  607,  607,    0,
      607,  608,  608,  608,  608,  608,  608,  608,  608,  608,
      608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
      608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
      609,  609,  609,  609,  609,  609,  609,  609,  609,  609,
      609,  609,  609,  609,  609,  609,  609,  609,  609,  609,
      609,  609,  609,  609,  609,  609,  609,  609,  609,  610,
        0,  610,  610,    0,    0,    0,    0,    0,  610,  610,
      610,  610,  610,  610,  610,    0,  610,  611,  611,  611,
      611,  611,  611,  611,    0,  611,  611,  611,  611,  611,

      611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
      611,  611,  611,  611,  611,  611,  612,    0,    0,    0,
      612,  612,  612,  612,  612,  612,  612,  612,  612,  612,
      612,  612,  612,  612,  612,  612,  612,  612,  612,  612,
      612,  612,  612,  612,  612,  613,  613,    0,  613,  613,
        0,    0,    0,    0,    0,  613,  613,  613,  613,  613,
      613,  613,    0,  613,  614,  614,  614,  614,  614,  614,
        0,  614,  614,  614,  614,  614,  614,  614,  614,  614,
      614,  614,  614,  614,  614,  614,  614,  614,  614,  614,
      614,  614,  614,  615,  615,  615,  615,  615,  615,  615,

      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  616,  616,  616,  616,  616,  616,    0,  616,
      616,  616,  616,  616,  616,  616,  616,  616,  616,  616,
      616,  616,  616,  616,  616,  616,  616,  616,  616,  616,
      616,  617,    0,  617,    0,    0,    0,    0,  617,  617,
        0,    0,    0,    0,    0,    0,  617,  617,  617,  617,
      617,  617,  617,  617,    0,  617,  618,  618,  618,  618,
      618,  618,  618,  618,  618,  618,  618,  618,  618,  618,
      618,  618,  618,  618,  618,  618,  618,  618,  618,  618,

      618,  618,  618,  618,  618,  619,  619,    0,    0,    0,
        0,    0,  619,  619,  619,  619,  619,  619,  619,    0,
      619,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      621,  621,  621,  621,  621,  621,  621,  621,  621,  621,
      621,  621,  621,  621,  621,  621,  621,  621,  621,  621,
      621,  621,  621,  621,  621,  621,  621,  621,  621,  622,
      622,    0,  622,  622,  622,  622,  622,  622,  622,  622,
      622,  622,  622,  622,  622,  622,  622,  622,  622,  622,

      622,  622,  622,  622,  622,  622,  622,  622,  623,  623,
      623,  623,  623,  623,  623,  623,  623,  623,  623,  623,
      623,  623,  623,  623,  623,  623,  623,  623,  623,  623,
      623,  623,  623,  623,  623,  623,  623,  624,  624,    0,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  625,  625,  625,    0,
        0,  625,  625,    0,  625,    0,    0,    0,  625,  625,
      625,  625,  625,  625,  625,    0,  625,  626,  626,  626,
        0,    0,    0,    0,  626,  626,  626,  626,  626,  626,

      626,  627,    0,  627,    0,    0,    0,  627,  627,    0,
      627,    0,    0,    0,    0,  627,    0,    0,    0,    0,
      627,  627,  627,  627,  627,  627,  627,  628,    0,  628,
        0,  628,    0,  628,    0,    0,    0,    0,    0,    0,
      628,  628,  628,  628,  628,  628,  628,  629,  629,    0,
      629,  629,  629,    0,    0,    0,    0,  629,  629,  629,
      629,  629,  629,  629,  630,    0,    0,    0,  630,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  630,  630,
      630,  630,  630,  630,  630,  631,    0,    0,  631,    0,
      631,    0,  631,    0,  631,    0,    0,  631,  631,    0,

        0,  631,  631,  631,  631,  631,  631,  631,  632,  632,
      632,  632,  632,  632,  632,  632,  632,  632,  632,  632,
      632,  632,  632,  632,  632,  632,  632,  632,  632,  632,
      632,  632,  632,  632,  632,  632,  632,  633,    0,    0,
        0,    0,    0,  633,  633,    0,    0,  633,  633,  633,
        0,    0,    0,    0,  633,  633,  633,  633,  633,  633,
      633,  634,    0,    0,  634,  634,  634,  634,  634,    0,
      634,  634,    0,  634,  634,    0,    0,  634,  634,  634,
      634,  634,  634,  634,    0,  634,  635,  635,  635,  635,
      635,    0,  635,  635,    0,  635,    0,    0,    0,  635,

      635,  635,  635,  635,  635,  635,    0,  635,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  636,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  636,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  637,    0,    0,
        0,    0,    0,    0,    0,  637,    0,    0,    0,    0,
      637,    0,  637,  637,    0,    0,  637,  637,  638,  638,
      638,  638,  638,  638,  638,  638,  638,  638,  638,  638,
      638,  638,  638,  638,  638,  638,  638,  638,  638,  638,
      638,  638,  638,  638,  638,  638,  638,  639,    0,  639,
      639,    0,    0,    0,    0,    0,  639,  639,  639,  639,

      639,  639,  639,    0,  639,  640,  640,  640,  640,  640,
      640,  640,    0,  640,  640,  640,  640,  640,  640,  640,
      640,  640,  640,  640,  640,  640,  640,  640,  640,  640,
      640,  640,  640,  640,  641,    0,    0,    0,  641,  641,
      641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
      641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
      641,  641,  641,  642,  642,    0,  642,  642,    0,    0,
        0,    0,    0,  642,  642,  642,  642,  642,  642,  642,
        0,  642,  643,  643,  643,  643,  643,  643,    0,  643,
      643,  643,  643,  643,  643,  643,  643,  643,  643,  643,

      643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
      643,  644,  644,    0,    0,    0,    0,    0,    0,  644,
        0,    0,    0,    0,    0,    0,    0,  644,    0,    0,
      644,    0,  644,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  645,  645,  645,  645,  645,  645,  645,  645,
      645,  645,  646,  646,    0,    0,    0,    0,    0,    0,
      646,    0,    0,    0,    0,    0,    0,    0,  646,    0,
        0,  646,    0,  646,  647,  647,  647,  647,  647,  647,
        0,  647,  647,  647,  647,  647,  647,  647,  647,  647,

      647,  647,  647,  647,  647,  647,  647,  647,  647,  647,
      647,  647,  647,  648,  648,    0,    0,    0,    0,    0,
        0,  648,    0,    0,    0,    0,    0,    0,    0,  648,
        0,    0,  648,    0,  648,  649,  649,  649,  649,  649,
      649,  649,  649,    0,  649,  650,    0,    0,    0,    0,
        0,  650,  650,    0,  650,  650,    0,    0,    0,    0,
      650,  650,  650,  650,  650,  650,  650,  650,  650,  650,
      651,  651,  651,  651,  651,  651,  651,  651,  651,  651,
      651,  651,  651,  651,  651,  651,  651,  651,  651,  651,
      651,  651,  651,  651,  651,  651,  651,  651,  651,  652,

      652,    0,    0,    0,    0,    0,    0,  652,    0,    0,
        0,    0,    0,    0,    0,  652,    0,    0,  652,    0,
      652,  653,  653,    0,    0,    0,    0,    0,  653,  653,
      653,  654,  654,    0,    0,    0,    0,    0,  654,  654,
      654,  654,  654,  654,  654,    0,  654,  655,  655,  655,
      655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
      655,  655,  655,  655,  655,  655,  655,  655,  655,  655,
      655,  655,  655,  655,  655,  655,  656,  656,  656,  656,
      656,  656,  656,  656,  656,  656,  656,  656,  656,  656,
      656,  656,  656,  656,  656,  656,  656,  656,  656,  656,

      656,  656,  656,  656,  656,  657,  657,  657,  657,  657,
      657,  657,  657,  657,  657,  657,  657,  657,  657,  657,
      657,  657,  657,  657,  657,  657,  657,  657,  657,  657,
      657,  657,  657,  657,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  658,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  658,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  659,  659,    0,  659,  659,  659,  659,
      659,  659,  659,  659,  659,  659,  659,  659,  659,  659,
      659,  659,  659,  659,  659,  659,  659,  659,  659,  659,
      659,  659,  660,  660,    0,  660,  660,  660,  660,  660,

      660,  660,  660,  660,  660,  660,  660,  660,  660,  660,
      660,  660,  660,  660,  660,  660,  660,  660,  660,  660,
      660,  661,  661,    0,  661,  661,  661,  661,  661,  661,
      661,  661,  661,  661,  661,  661,  661,  661,  661,  661,
      661,  661,  661,  661,  661,  661,  661,  661,  661,  661,
      662,  662,    0,  662,  662,  662,  662,  662,  662,  662,
      662,  662,  662,  662,  662,  662,  662,  662,  662,  662,
      662,  662,  662,  662,  662,  662,  662,  662,  662,  663,
      663,  663,    0,    0,  663,  663,    0,  663,    0,    0,
        0,  663,  663,  663,  663,  663,  663,  663,    0,  663,

      664,    0,    0,  664,    0,  664,    0,  664,    0,  664,
        0,    0,  664,  664,    0,    0,  664,  664,  664,  664,
      664,  664,  664,  665,  665,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      665,  665,  665,  665,  665,  665,  665,  666,    0,    0,
      666,  666,  666,  666,  666,    0,  666,  666,    0,  666,
      666,    0,    0,  666,  666,  666,  666,  666,  666,  666,
        0,  666,  667,  667,  667,  667,  667,    0,  667,  667,
        0,  667,    0,    0,    0,  667,  667,  667,  667,  667,
      667,  667,    0,  667,  668,  668,  668,  668,  668,  668,

      668,  668,  668,  668,  668,  668,  668,  668,  668,  668,
      668,  668,  668,  668,  668,  668,  668,  668,  668,  668,
      668,  668,  668,  669,  669,    0,    0,    0,    0,    0,
      669,  669,  669,  670,  670,    0,    0,    0,    0,    0,
      670,  670,  670,  671,  671,    0,    0,    0,    0,    0,
      671,  671,  671,  672,    0,    0,    0,    0,    0,  672,
      672,    0,  672,  672,    0,    0,    0,    0,  672,  672,
      672,  672,  672,  672,  672,  672,  672,  672,  673,  673,
        0,    0,    0,    0,    0,  673,  673,  673,  674,  674,
        0,    0,    0,    0,    0,  674,  674,  674,  675,  675,

        0,    0,    0,    0,    0,  675,  675,  675,  675,  675,
      675,  675,    0,  675,  676,  676,    0,    0,    0,    0,
        0,  676,  676,  676,  677,  677,    0,    0,    0,    0,
        0,  677,  677,  677,  678,  678,    0,    0,    0,    0,
        0,  678,  678,  678,  679,  679,    0,    0,    0,    0,
        0,  679,  679,  679,  680,  680,  680,  680,  680,  680,
      680,  680,  680,  680,  680,  680,  680,  680,  680,  680,
      680,  680,  680,  680,  680,  680,  680,  680,  680,  680,
      680,  680,  680,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,

      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590,  590,  590,  590,  590,  590,  590,  590,  590,  590,
      590
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[116] =
    {   0,
0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 
    0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.l"
/* Lex file for rsyslog config format v2 (RainerScript).
* Please note: this file introduces the new config format, but maintains
* backward compatibility. In order to do so, the grammar is not 100% clean,
* but IMHO still sufficiently easy both to understand for programmers
* maitaining the code as well as users writing the config file. Users are,
* of course, encouraged to use new constructs only. But it needs to be noted
* that some of the legacy constructs (specifically the in-front-of-action
* PRI filter) are very hard to beat in ease of use, at least for simpler
* cases. So while we hope that cfsysline support can be dropped some time in
* the future, we will probably keep these useful constructs.
*
* Copyright 2011-2014 Rainer Gerhards and Adiscon GmbH.
*
* This file is part of the rsyslog runtime library.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* 
*       http://www.apache.org/licenses/LICENSE-2.0
*       -or-
*       see COPYING.ASL20 in the source distribution
* 
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#line 38 "lexer.l"
#include "parserif.h"
/*%option noyywrap nodefault case-insensitive */
/* avoid compiler warning: `yyunput' defined but not used */
#define YY_NO_INPUT 1

/* INOBJ is selected if we are inside an object (name/value pairs!) */

/* COMMENT is "the usual trick" to handle C-style comments */

/* INCL is in $IncludeConfig processing (skip to include file) */

/* LINENO: support for setting the linenumber */

/* INCALL: support for the call statement */

/* IN_PROCEDURE_CALL: support for the call statement */	

/* EXPR is a bit ugly, but we need it to support pre v6-syntax. The problem
* is that cfsysline statement start with $..., the same like variables in
* an expression. However, cfsysline statements can never appear inside an
* expression. So we create a specific expr mode, which is turned on after 
* we lexed a keyword that needs to be followed by an expression (using 
* knowledge from the upper layer...). In expr mode, we strictly do
* expression-based parsing. Expr mode is stopped when we reach a token
* that can not be part of an expression (currently only "then"). As I
* wrote this ugly, but the price needed to pay in order to remain
* compatible to the previous format.
*/
#line 73 "lexer.l"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <libestr.h>
#include "rainerscript.h"
#include "parserif.h"
#include "grammar.h"
static int preCommentState;	/* save for lex state before a comment */

struct bufstack {
	struct bufstack *prev;
	YY_BUFFER_STATE bs;
	int lineno;
	char *fn;
	es_str_t *estr;
} *currbs = NULL;

char *cnfcurrfn;			/* name of currently processed file */

int popfile(void);
int cnfSetLexFile(char *fname);

extern int yydebug;

/* somehow, I need these prototype even though the headers are 
 * included. I guess that's some autotools magic I don't understand...
 */
#if !defined(__FreeBSD__)
int fileno(FILE *stream);
#endif

#line 1748 "lexer.c"

#define INITIAL 0
#define INOBJ 1
#define COMMENT 2
#define INCL 3
#define LINENO 4
#define INCALL 5
#define IN_PROCEDURE_CALL 6
#define EXPR 7

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 108 "lexer.l"


 /* keywords */
#line 1978 "lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 591 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 4184 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			yy_size_t yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					   
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 111 "lexer.l"
{ BEGIN EXPR; return IF; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 112 "lexer.l"
{ BEGIN EXPR; return FOREACH; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 113 "lexer.l"
{ BEGIN IN_PROCEDURE_CALL; return RELOAD_LOOKUP_TABLE_PROCEDURE; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 114 "lexer.l"
{ return yytext[0]; }
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 115 "lexer.l"
{
				   yytext[yyleng-1] = '\0';
				   unescapeStr((uchar*)yytext+1, yyleng-2);
				   yylval.estr = es_newStrFromBuf(yytext+1, strlen(yytext)-1);
				   return STRING; }
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 120 "lexer.l"
{
				   yytext[yyleng-1] = '\0';
				   unescapeStr((uchar*)yytext+1, yyleng-2);
				   yylval.estr = es_newStrFromBuf(yytext+1, strlen(yytext)-1);
				   return STRING; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 125 "lexer.l"
{ return yytext[0]; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 126 "lexer.l"
{ BEGIN INITIAL; return yytext[0]; }
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 127 "lexer.l"
{  }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 128 "lexer.l"
{ parser_errmsg("invalid character '%s' in expression "
					        "- is there an invalid escape sequence somewhere?",
						yytext); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 131 "lexer.l"
{ BEGIN EXPR; return yytext[0]; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 132 "lexer.l"
{ BEGIN INITIAL; return THEN; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 133 "lexer.l"
{ BEGIN INITIAL; return DO; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 134 "lexer.l"
{ BEGIN INITIAL; return ';'; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 135 "lexer.l"
{ return OR; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 136 "lexer.l"
{ return AND; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 137 "lexer.l"
{ return NOT; }
	YY_BREAK
case 18:
#line 139 "lexer.l"
case 19:
#line 140 "lexer.l"
case 20:
#line 141 "lexer.l"
case 21:
#line 142 "lexer.l"
case 22:
#line 143 "lexer.l"
case 23:
#line 144 "lexer.l"
case 24:
#line 145 "lexer.l"
case 25:
#line 146 "lexer.l"
case 26:
#line 147 "lexer.l"
case 27:
#line 148 "lexer.l"
case 28:
#line 149 "lexer.l"
case 29:
YY_RULE_SETUP
#line 149 "lexer.l"
{ return yytext[0]; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 150 "lexer.l"
{ return CMP_EQ; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 151 "lexer.l"
{ return CMP_LE; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 152 "lexer.l"
{ return CMP_GE; }
	YY_BREAK
case 33:
#line 154 "lexer.l"
case 34:
YY_RULE_SETUP
#line 154 "lexer.l"
{ return CMP_NE; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 155 "lexer.l"
{ return CMP_LT; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 156 "lexer.l"
{ return CMP_GT; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 157 "lexer.l"
{ return CMP_CONTAINS; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 158 "lexer.l"
{ return ITERATOR_ASSIGNMENT; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 159 "lexer.l"
{ return CMP_CONTAINSI; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 160 "lexer.l"
{ return CMP_STARTSWITH; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 161 "lexer.l"
{ return CMP_STARTSWITHI; }
	YY_BREAK
case 42:
#line 163 "lexer.l"
case 43:
#line 164 "lexer.l"
case 44:
YY_RULE_SETUP
#line 164 "lexer.l"
{ yylval.n = strtoll(yytext, NULL, 0); return NUMBER; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 165 "lexer.l"
{ yylval.s = strdup(yytext+1); return VAR; }
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 166 "lexer.l"
{
				   yytext[yyleng-1] = '\0';
				   unescapeStr((uchar*)yytext+1, yyleng-2);
				   yylval.estr = es_newStrFromBuf(yytext+1, strlen(yytext)-1);
				   return STRING; }
	YY_BREAK
case 47:
/* rule 47 can match eol */
YY_RULE_SETUP
#line 171 "lexer.l"
{
				   yytext[yyleng-1] = '\0';
				   unescapeStr((uchar*)yytext+1, yyleng-2);
				   yylval.estr = es_newStrFromBuf(yytext+1, strlen(yytext)-1);
				   return STRING; }
	YY_BREAK
case 48:
/* rule 48 can match eol */
YY_RULE_SETUP
#line 176 "lexer.l"

	YY_BREAK
case 49:
YY_RULE_SETUP
#line 177 "lexer.l"
{ yylval.estr = es_newStrFromCStr(yytext, yyleng);
				  return FUNC; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 179 "lexer.l"
{ parser_errmsg("invalid character '%s' in expression "
					        "- is there an invalid escape sequence somewhere?",
						yytext); }
	YY_BREAK
case 51:
/* rule 51 can match eol */
YY_RULE_SETUP
#line 182 "lexer.l"

	YY_BREAK
case 52:
YY_RULE_SETUP
#line 183 "lexer.l"
{ parser_errmsg("invalid character '%s' in 'call' statement"
					        "- is there an invalid escape sequence somewhere?",
						yytext); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 186 "lexer.l"
{ yylval.estr = es_newStrFromCStr(yytext, yyleng);
				  BEGIN INITIAL;
				  return NAME; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 189 "lexer.l"
{ return '&'; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 190 "lexer.l"
{ return '{'; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 191 "lexer.l"
{ return '}'; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 192 "lexer.l"
{ return STOP; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 193 "lexer.l"
{ return ELSE; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 194 "lexer.l"
{ BEGIN INCALL; return CALL; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 195 "lexer.l"
{ BEGIN EXPR; return SET; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 196 "lexer.l"
{ BEGIN EXPR; return RESET; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 197 "lexer.l"
{ BEGIN EXPR; return UNSET; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 198 "lexer.l"
{ return CONTINUE; }
	YY_BREAK
/* line number support because the "preprocessor" combines lines and so needs
  * to tell us the real source line.
  */
case 64:
YY_RULE_SETUP
#line 202 "lexer.l"
{ BEGIN LINENO; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 203 "lexer.l"
{ yylineno = atoi(yytext) - 1; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 204 "lexer.l"
{ BEGIN INITIAL; }
	YY_BREAK
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 205 "lexer.l"

	YY_BREAK
/* $IncludeConfig must be detected as part of CFSYSLINE, because this is
  * always the longest match :-(
  */
case 68:
/* rule 68 can match eol */
YY_RULE_SETUP
#line 209 "lexer.l"

	YY_BREAK
case 69:
YY_RULE_SETUP
#line 210 "lexer.l"
{ if(cnfDoInclude(yytext) != 0)
					yyterminate();
				  BEGIN INITIAL; }
	YY_BREAK
case 70:
/* rule 70 can match eol */
YY_RULE_SETUP
#line 213 "lexer.l"
{ yylval.objType = CNFOBJ_MAINQ;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 71:
/* rule 71 can match eol */
YY_RULE_SETUP
#line 215 "lexer.l"
{ yylval.objType = CNFOBJ_TIMEZONE;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 72:
/* rule 72 can match eol */
YY_RULE_SETUP
#line 217 "lexer.l"
{ yylval.objType = CNFOBJ_PARSER;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 73:
/* rule 73 can match eol */
YY_RULE_SETUP
#line 219 "lexer.l"
{ yylval.objType = CNFOBJ_GLOBAL;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 74:
/* rule 74 can match eol */
YY_RULE_SETUP
#line 221 "lexer.l"
{ yylval.objType = CNFOBJ_TPL;
				  BEGIN INOBJ; return BEGIN_TPL; }
	YY_BREAK
case 75:
/* rule 75 can match eol */
YY_RULE_SETUP
#line 223 "lexer.l"
{ yylval.objType = CNFOBJ_RULESET;
				  BEGIN INOBJ; return BEGIN_RULESET; }
	YY_BREAK
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 225 "lexer.l"
{ yylval.objType = CNFOBJ_PROPERTY;
				  BEGIN INOBJ; return BEGIN_PROPERTY; }
	YY_BREAK
case 77:
/* rule 77 can match eol */
YY_RULE_SETUP
#line 227 "lexer.l"
{ yylval.objType = CNFOBJ_CONSTANT;
				  BEGIN INOBJ; return BEGIN_CONSTANT; }
	YY_BREAK
case 78:
/* rule 78 can match eol */
YY_RULE_SETUP
#line 229 "lexer.l"
{ yylval.objType = CNFOBJ_INPUT;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 79:
/* rule 79 can match eol */
YY_RULE_SETUP
#line 231 "lexer.l"
{ yylval.objType = CNFOBJ_MODULE;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 80:
/* rule 80 can match eol */
YY_RULE_SETUP
#line 233 "lexer.l"
{ yylval.objType = CNFOBJ_LOOKUP_TABLE;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 81:
/* rule 81 can match eol */
YY_RULE_SETUP
#line 235 "lexer.l"
{ yylval.objType = CNFOBJ_DYN_STATS;
				  BEGIN INOBJ; return BEGINOBJ; }
	YY_BREAK
case 82:
/* rule 82 can match eol */
YY_RULE_SETUP
#line 237 "lexer.l"
{ BEGIN INOBJ; return BEGIN_ACTION; }
	YY_BREAK
case 83:
/* rule 83 can match eol */
YY_RULE_SETUP
#line 238 "lexer.l"
{
				  yylval.s = strdup(rmLeadingSpace(yytext));
				  dbgprintf("lexer: propfilt is '%s'\n", yylval.s);
				  return PROPFILT;
				  }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 243 "lexer.l"
{ yylval.s = strdup(rmLeadingSpace(yytext)); return PRIFILT; }
	YY_BREAK
case 85:
#line 245 "lexer.l"
case 86:
#line 246 "lexer.l"
case 87:
/* rule 87 can match eol */
#line 247 "lexer.l"
case 88:
/* rule 88 can match eol */
#line 248 "lexer.l"
case 89:
/* rule 89 can match eol */
#line 249 "lexer.l"
case 90:
/* rule 90 can match eol */
#line 250 "lexer.l"
case 91:
/* rule 91 can match eol */
YY_RULE_SETUP
#line 250 "lexer.l"
{ yylval.s = yytext; return LEGACY_ACTION; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 251 "lexer.l"
{ BEGIN INITIAL; return ENDOBJ; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 252 "lexer.l"
{ yylval.estr = es_newStrFromCStr(yytext, yyleng);
				  return NAME; }
	YY_BREAK
case 94:
#line 255 "lexer.l"
case 95:
#line 256 "lexer.l"
case 96:
#line 257 "lexer.l"
case 97:
YY_RULE_SETUP
#line 257 "lexer.l"
{ return(yytext[0]); }
	YY_BREAK
case 98:
/* rule 98 can match eol */
YY_RULE_SETUP
#line 258 "lexer.l"
{
				   yytext[yyleng-1] = '\0';
				   unescapeStr((uchar*)yytext+1, yyleng-2);
				   yylval.estr = es_newStrFromBuf(yytext+1, strlen(yytext)-1);
				   return STRING; }
	YY_BREAK
/*yylval.estr = es_newStrFromBuf(yytext+1, yyleng-2);
				  return VALUE; }*/
case 99:
YY_RULE_SETUP
#line 265 "lexer.l"
{ preCommentState = YY_START; BEGIN COMMENT; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 266 "lexer.l"
{ preCommentState = YY_START; BEGIN COMMENT; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 267 "lexer.l"
{ preCommentState = YY_START; BEGIN COMMENT; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 268 "lexer.l"
{ BEGIN preCommentState; }
	YY_BREAK
case 103:
/* rule 103 can match eol */
YY_RULE_SETUP
#line 269 "lexer.l"

	YY_BREAK
case 104:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 270 "lexer.l"
/* skip comments in input */
	YY_BREAK
case 105:
/* rule 105 can match eol */
YY_RULE_SETUP
#line 271 "lexer.l"

	YY_BREAK
case 106:
YY_RULE_SETUP
#line 272 "lexer.l"
{ parser_errmsg("invalid character '%s' in object definition "
					        "- is there an invalid escape sequence somewhere?",
						yytext); }
	YY_BREAK
case 107:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 275 "lexer.l"
{ /* see comment on $IncludeConfig above */
				  if(!strncasecmp(yytext, "$includeconfig ", 14)) {
					yyless(14);
				  	BEGIN INCL;
				  } else if(!strncasecmp(yytext, "$ruleset ", 9)) {
					yylval.s = strdup(yytext);
					return LEGACY_RULESET;
				  } else {
					  cnfDoCfsysline(strdup(yytext)); 
				  }
				}
	YY_BREAK
case 108:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 286 "lexer.l"
{ yylval.s = strdup(yytext); return BSD_TAG_SELECTOR; }
	YY_BREAK
case 109:
/* rule 109 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 287 "lexer.l"
{ yylval.s = strdup(yytext); return BSD_HOST_SELECTOR; }
	YY_BREAK
case 110:
/* rule 110 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 288 "lexer.l"
{ yylval.s = strdup(yytext); return BSD_HOST_SELECTOR; }
	YY_BREAK
case 111:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 289 "lexer.l"
{ yylval.s = strdup(yytext); return BSD_HOST_SELECTOR; }
	YY_BREAK
case 112:
/* rule 112 can match eol */
YY_RULE_SETUP
#line 290 "lexer.l"
/* skip comments in input */
	YY_BREAK
case 113:
/* rule 113 can match eol */
YY_RULE_SETUP
#line 291 "lexer.l"
/* drop whitespace */
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 292 "lexer.l"
{ parser_errmsg("invalid character '%s' "
					        "- is there an invalid escape sequence somewhere?",
						yytext); }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(INOBJ):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(INCL):
case YY_STATE_EOF(LINENO):
case YY_STATE_EOF(INCALL):
case YY_STATE_EOF(IN_PROCEDURE_CALL):
case YY_STATE_EOF(EXPR):
#line 295 "lexer.l"
{ if(popfile() != 0) yyterminate(); }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 297 "lexer.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 2688 "lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	yy_size_t number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((int) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 591 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 591 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 590);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');
	if ( YY_CURRENT_BUFFER_LVALUE->yy_at_bol )
		   
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 297 "lexer.l"


int
cnfParseBuffer(char *buf, unsigned lenBuf)
{
	struct bufstack *bs;
	int r = 0;
	yydebug = 1;
	BEGIN INITIAL;
	/* maintain stack */
	if((bs = malloc(sizeof(struct bufstack))) == NULL) {
		r = 1;
		goto done;
	}

	if(currbs != NULL)
		currbs->lineno = yylineno;
	bs->prev = currbs;
	bs->fn = strdup("*buffer*");
	bs->bs = yy_scan_buffer(buf,lenBuf);
	bs->estr = NULL;
	currbs = bs;
	cnfcurrfn = bs->fn;
	yylineno = 1;
done:	return r;
}

/* set a new buffers. Returns 0 on success, 1 on error, 2 on file not exists.
 * note: in case of error, errno must be kept valid!
 */
int
cnfSetLexFile(char *fname)
{
	es_str_t *str = NULL;
	FILE *fp;
	int r = 0;
	struct bufstack *bs;

	if(fname == NULL) {
		fp = stdin;
	} else {
		if((fp = fopen(fname, "r")) == NULL) {
			r = 2;
			goto done;
		}
	}
	readConfFile(fp, &str);
	if(fp != stdin)
		fclose(fp);
	
	/* maintain stack */
	if((bs = malloc(sizeof(struct bufstack))) == NULL) {
		r = 1;
		goto done;
	}

	if(currbs != NULL)
		currbs->lineno = yylineno;
	bs->prev = currbs;
	bs->fn = strdup(fname == NULL ? "stdin" : fname);
	yy_size_t lll = es_strlen(str);
	//bs->bs = yy_scan_buffer((char*)es_getBufAddr(str),(yy_size_t) es_strlen(str));
	bs->bs = yy_scan_buffer((char*)es_getBufAddr(str),lll);
	bs->estr = str; /* needed so we can free it later */
	currbs = bs;
	cnfcurrfn = bs->fn;
	yylineno = 1;
	dbgprintf("config parser: pushed file %s on top of stack\n", fname);

done:
	if(r != 0) {
		if(str != NULL)
			es_deleteStr(str);
	}
	return r;
}


/* returns 0 on success, something else otherwise */
int
popfile(void)
{
	struct bufstack *bs = currbs;

	if(bs == NULL)
		return 1;
	
	/* delete current entry. But we must not free the file name if
	 * this is the top-level file, because then it may still be used
	 * in error messages for other processing steps.
	 * TODO: change this to another method which stores the file
	 * name inside the config objects. In the longer term, this is
	 * necessary, as otherwise we may provide wrong file name information
	 * at the end of include files as well. -- rgerhards, 2011-07-22
	 */
	dbgprintf("config parser: reached end of file %s\n", bs->fn);
	yy_delete_buffer(bs->bs);
	if(bs->prev != NULL)
		free(bs->fn);
	free(bs->estr);

	/* switch back to previous */
	currbs = bs->prev;
	free(bs);

	if(currbs == NULL) {
		dbgprintf("config parser: parsing completed\n");
		return 1; /* all processed */
	}
	
	yy_switch_to_buffer(currbs->bs);
	yylineno = currbs->lineno;
	cnfcurrfn = currbs->fn;
	dbgprintf("config parser: resume parsing of file %s at line %d\n",
		  cnfcurrfn, yylineno);
	return 0;
}

void
tellLexEndParsing(void)
{
	free(cnfcurrfn);
	cnfcurrfn= NULL;
}

