/* main.c generated by valac 0.30.0, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <config.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ENGINE_LIST (engine_list_get_type ())
#define ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENGINE_LIST, EngineList))
#define ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENGINE_LIST, EngineListClass))
#define IS_ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENGINE_LIST))
#define IS_ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENGINE_LIST))
#define ENGINE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENGINE_LIST, EngineListClass))

typedef struct _EngineList EngineList;
typedef struct _EngineListClass EngineListClass;
typedef struct _EngineListPrivate EngineListPrivate;
typedef struct _ParamSpecEngineList ParamSpecEngineList;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _engine_list_unref0(var) ((var == NULL) ? NULL : (var = (engine_list_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_COMMAND_ENTRY (command_entry_get_type ())
typedef struct _CommandEntry CommandEntry;

struct _EngineList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EngineListPrivate * priv;
	IBusEngineDesc** data;
	gint data_length1;
	gint _data_size_;
};

struct _EngineListClass {
	GTypeClass parent_class;
	void (*finalize) (EngineList *self);
};

struct _ParamSpecEngineList {
	GParamSpec parent_instance;
};

typedef gint (*EntryFunc) (gchar** argv, int argv_length1, void* user_data);
struct _CommandEntry {
	const gchar* name;
	const gchar* description;
	EntryFunc entry;
	gpointer entry_target;
};


extern gboolean name_only;
gboolean name_only = FALSE;
extern gboolean is_system;
gboolean is_system = FALSE;
extern gchar* cache_file;
gchar* cache_file = NULL;
static gpointer engine_list_parent_class = NULL;
extern gchar* program_name;
gchar* program_name = NULL;

gpointer engine_list_ref (gpointer instance);
void engine_list_unref (gpointer instance);
GParamSpec* param_spec_engine_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_engine_list (GValue* value, gpointer v_object);
void value_take_engine_list (GValue* value, gpointer v_object);
gpointer value_get_engine_list (const GValue* value);
GType engine_list_get_type (void) G_GNUC_CONST;
enum  {
	ENGINE_LIST_DUMMY_PROPERTY
};
EngineList* engine_list_new (void);
EngineList* engine_list_construct (GType object_type);
static void engine_list_finalize (EngineList* obj);
IBusBus* get_bus (void);
gint list_engine (gchar** argv, int argv_length1);
static void _g_free0_ (gpointer var);
static void _engine_list_unref0_ (gpointer var);
static void _vala_array_add1 (IBusEngineDesc*** array, int* length, int* size, IBusEngineDesc* value);
gint exec_setxkbmap (IBusEngineDesc* engine);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
gint get_set_engine (gchar** argv, int argv_length1);
gint message_watch (gchar** argv, int argv_length1);
gint restart_daemon (gchar** argv, int argv_length1);
gint exit_daemon (gchar** argv, int argv_length1);
gint print_version (gchar** argv, int argv_length1);
gint read_cache (gchar** argv, int argv_length1);
gint write_cache (gchar** argv, int argv_length1);
gint print_address (gchar** argv, int argv_length1);
gint read_config (gchar** argv, int argv_length1);
gint reset_config (gchar** argv, int argv_length1);
gint print_help (gchar** argv, int argv_length1);
void print_usage (FILE* stream);
GType command_entry_get_type (void) G_GNUC_CONST;
CommandEntry* command_entry_dup (const CommandEntry* self);
void command_entry_free (CommandEntry* self);
static gint _get_set_engine_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _exit_daemon_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _list_engine_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _message_watch_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _restart_daemon_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_version_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _read_cache_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _write_cache_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_address_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _read_config_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _reset_config_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_help_entry_func (gchar** argv, int argv_length1, gpointer self);
gint _vala_main (gchar** argv, int argv_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* IBUS_SCHEMAS[3] = {"org.freedesktop.ibus.general", "org.freedesktop.ibus.general.hotkey", "org.freedesktop.ibus.panel"};
const CommandEntry commands[12] = {{"engine", "Set or get engine", _get_set_engine_entry_func}, {"exit", "Exit ibus-daemon", _exit_daemon_entry_func}, {"list-engine", "Show available engines", _list_engine_entry_func}, {"watch", "(Not implemented)", _message_watch_entry_func}, {"restart", "Restart ibus-daemon", _restart_daemon_entry_func}, {"version", "Show version", _print_version_entry_func}, {"read-cache", "Show the content of registry cache", _read_cache_entry_func}, {"write-cache", "Create registry cache", _write_cache_entry_func}, {"address", "Print the D-Bus address of ibus-daemon", _print_address_entry_func}, {"read-config", "Show the configuration values", _read_config_entry_func}, {"reset-config", "Reset the configuration values", _reset_config_entry_func}, {"help", "Show this information", _print_help_entry_func}};

EngineList* engine_list_construct (GType object_type) {
	EngineList* self = NULL;
	self = (EngineList*) g_type_create_instance (object_type);
	return self;
}


EngineList* engine_list_new (void) {
	return engine_list_construct (TYPE_ENGINE_LIST);
}


static void value_engine_list_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_engine_list_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		engine_list_unref (value->data[0].v_pointer);
	}
}


static void value_engine_list_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = engine_list_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_engine_list_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_engine_list_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EngineList* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = engine_list_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_engine_list_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EngineList** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = engine_list_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_engine_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEngineList* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENGINE_LIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_engine_list (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST), NULL);
	return value->data[0].v_pointer;
}


void value_set_engine_list (GValue* value, gpointer v_object) {
	EngineList* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		engine_list_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}


void value_take_engine_list (GValue* value, gpointer v_object) {
	EngineList* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}


static void engine_list_class_init (EngineListClass * klass) {
	engine_list_parent_class = g_type_class_peek_parent (klass);
	((EngineListClass *) klass)->finalize = engine_list_finalize;
}


static void engine_list_instance_init (EngineList * self) {
	IBusEngineDesc** _tmp0_ = NULL;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->data = _tmp0_;
	self->data_length1 = 0;
	self->_data_size_ = self->data_length1;
	self->ref_count = 1;
}


static void engine_list_finalize (EngineList* obj) {
	EngineList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENGINE_LIST, EngineList);
	g_signal_handlers_destroy (self);
	self->data = (_vala_array_free (self->data, self->data_length1, (GDestroyNotify) g_object_unref), NULL);
}


GType engine_list_get_type (void) {
	static volatile gsize engine_list_type_id__volatile = 0;
	if (g_once_init_enter (&engine_list_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_engine_list_init, value_engine_list_free_value, value_engine_list_copy_value, value_engine_list_peek_pointer, "p", value_engine_list_collect_value, "p", value_engine_list_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EngineListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) engine_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EngineList), 0, (GInstanceInitFunc) engine_list_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType engine_list_type_id;
		engine_list_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EngineList", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&engine_list_type_id__volatile, engine_list_type_id);
	}
	return engine_list_type_id__volatile;
}


gpointer engine_list_ref (gpointer instance) {
	EngineList* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void engine_list_unref (gpointer instance) {
	EngineList* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ENGINE_LIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


IBusBus* get_bus (void) {
	IBusBus* result = NULL;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_ = NULL;
	IBusBus* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	bus = _tmp0_;
	_tmp1_ = bus;
	_tmp2_ = ibus_bus_is_connected (_tmp1_);
	if (!_tmp2_) {
		result = NULL;
		_g_object_unref0 (bus);
		return result;
	}
	result = bus;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _engine_list_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (engine_list_unref (var), NULL));
}


static gpointer _engine_list_ref0 (gpointer self) {
	return self ? engine_list_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (IBusEngineDesc*** array, int* length, int* size, IBusEngineDesc* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusEngineDesc*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint list_engine (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"name-only", (gchar) 0, 0, G_OPTION_ARG_NONE, &name_only, "List engine name only", NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	IBusBus* bus = NULL;
	IBusBus* _tmp6_ = NULL;
	IBusBus* _tmp7_ = NULL;
	GList* engines = NULL;
	IBusBus* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GHashTable* map = NULL;
	GHashFunc _tmp16_ = NULL;
	GEqualFunc _tmp17_ = NULL;
	GHashTable* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
	GHashTable* _tmp38_ = NULL;
	GList* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_ = NULL;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = get_bus ();
	bus = _tmp6_;
	_tmp7_ = bus;
	if (_tmp7_ == NULL) {
		FILE* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = _ ("Can't connect to IBus.\n");
		fprintf (_tmp8_, "%s", _tmp9_);
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp10_ = bus;
	_tmp11_ = ibus_bus_list_engines (_tmp10_);
	engines = _tmp11_;
	_tmp12_ = name_only;
	if (_tmp12_) {
		GList* _tmp13_ = NULL;
		_tmp13_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp13_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					IBusEngineDesc* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					_tmp14_ = engine;
					_tmp15_ = ibus_engine_desc_get_name (_tmp14_);
					g_print ("%s\n", _tmp15_);
				}
			}
		}
		result = EXIT_SUCCESS;
		_g_list_free0 (engines);
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _engine_list_unref0_);
	map = _tmp18_;
	_tmp19_ = engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp19_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				EngineList* list = NULL;
				GHashTable* _tmp20_ = NULL;
				IBusEngineDesc* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gconstpointer _tmp23_ = NULL;
				EngineList* _tmp24_ = NULL;
				EngineList* _tmp25_ = NULL;
				EngineList* _tmp33_ = NULL;
				EngineList* _tmp34_ = NULL;
				IBusEngineDesc** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				IBusEngineDesc* _tmp36_ = NULL;
				IBusEngineDesc* _tmp37_ = NULL;
				_tmp20_ = map;
				_tmp21_ = engine;
				_tmp22_ = ibus_engine_desc_get_language (_tmp21_);
				_tmp23_ = g_hash_table_lookup (_tmp20_, _tmp22_);
				_tmp24_ = _engine_list_ref0 ((EngineList*) _tmp23_);
				list = _tmp24_;
				_tmp25_ = list;
				if (_tmp25_ == NULL) {
					EngineList* _tmp26_ = NULL;
					GHashTable* _tmp27_ = NULL;
					IBusEngineDesc* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					EngineList* _tmp31_ = NULL;
					EngineList* _tmp32_ = NULL;
					_tmp26_ = engine_list_new ();
					_engine_list_unref0 (list);
					list = _tmp26_;
					_tmp27_ = map;
					_tmp28_ = engine;
					_tmp29_ = ibus_engine_desc_get_language (_tmp28_);
					_tmp30_ = g_strdup (_tmp29_);
					_tmp31_ = list;
					_tmp32_ = _engine_list_ref0 (_tmp31_);
					g_hash_table_insert (_tmp27_, _tmp30_, _tmp32_);
				}
				_tmp33_ = list;
				_tmp34_ = list;
				_tmp35_ = _tmp34_->data;
				_tmp35__length1 = _tmp34_->data_length1;
				_tmp36_ = engine;
				_tmp37_ = _g_object_ref0 (_tmp36_);
				_vala_array_add1 (&_tmp33_->data, &_tmp33_->data_length1, &_tmp33_->_data_size_, _tmp37_);
				_engine_list_unref0 (list);
			}
		}
	}
	_tmp38_ = map;
	_tmp39_ = g_hash_table_get_keys (_tmp38_);
	{
		GList* language_collection = NULL;
		GList* language_it = NULL;
		language_collection = _tmp39_;
		for (language_it = language_collection; language_it != NULL; language_it = language_it->next) {
			const gchar* language = NULL;
			language = (const gchar*) language_it->data;
			{
				EngineList* list = NULL;
				GHashTable* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gconstpointer _tmp42_ = NULL;
				EngineList* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				EngineList* _tmp47_ = NULL;
				IBusEngineDesc** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				_tmp40_ = map;
				_tmp41_ = language;
				_tmp42_ = g_hash_table_lookup (_tmp40_, _tmp41_);
				_tmp43_ = _engine_list_ref0 ((EngineList*) _tmp42_);
				list = _tmp43_;
				_tmp44_ = _ ("language: %s\n");
				_tmp45_ = language;
				_tmp46_ = ibus_get_language_name (_tmp45_);
				g_print (_tmp44_, _tmp46_);
				_tmp47_ = list;
				_tmp48_ = _tmp47_->data;
				_tmp48__length1 = _tmp47_->data_length1;
				{
					IBusEngineDesc** engine_collection = NULL;
					gint engine_collection_length1 = 0;
					gint _engine_collection_size_ = 0;
					gint engine_it = 0;
					engine_collection = _tmp48_;
					engine_collection_length1 = _tmp48__length1;
					for (engine_it = 0; engine_it < _tmp48__length1; engine_it = engine_it + 1) {
						IBusEngineDesc* _tmp49_ = NULL;
						IBusEngineDesc* engine = NULL;
						_tmp49_ = _g_object_ref0 (engine_collection[engine_it]);
						engine = _tmp49_;
						{
							IBusEngineDesc* _tmp50_ = NULL;
							const gchar* _tmp51_ = NULL;
							IBusEngineDesc* _tmp52_ = NULL;
							const gchar* _tmp53_ = NULL;
							_tmp50_ = engine;
							_tmp51_ = ibus_engine_desc_get_name (_tmp50_);
							_tmp52_ = engine;
							_tmp53_ = ibus_engine_desc_get_longname (_tmp52_);
							g_print ("  %s - %s\n", _tmp51_, _tmp53_);
							_g_object_unref0 (engine);
						}
					}
				}
				_engine_list_unref0 (list);
			}
		}
		_g_list_free0 (language_collection);
	}
	result = EXIT_SUCCESS;
	_g_hash_table_unref0 (map);
	_g_list_free0 (engines);
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint exec_setxkbmap (IBusEngineDesc* engine) {
	gint result = 0;
	gchar* layout = NULL;
	IBusEngineDesc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* variant = NULL;
	IBusEngineDesc* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* option = NULL;
	IBusEngineDesc* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar** args = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_ = NULL;
	gchar** _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	gint _tmp53_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (engine != NULL, 0);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	standard_error = NULL;
	exit_status = 0;
	_tmp9_ = g_strdup ("setxkbmap");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	args = _tmp10_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp13_ = layout;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = layout;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = layout;
		_tmp11_ = g_strcmp0 (_tmp15_, "default") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gchar* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp16_ = args;
		_tmp16__length1 = args_length1;
		_tmp17_ = g_strdup ("-layout");
		_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp17_);
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = layout;
		_tmp20_ = g_strdup (_tmp19_);
		_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp20_);
	}
	_tmp23_ = variant;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = variant;
		_tmp22_ = g_strcmp0 (_tmp24_, "") != 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp25_ = NULL;
		_tmp25_ = variant;
		_tmp21_ = g_strcmp0 (_tmp25_, "default") != 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gchar* _tmp27_ = NULL;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp26_ = args;
		_tmp26__length1 = args_length1;
		_tmp27_ = g_strdup ("-variant");
		_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp27_);
		_tmp28_ = args;
		_tmp28__length1 = args_length1;
		_tmp29_ = variant;
		_tmp30_ = g_strdup (_tmp29_);
		_vala_array_add5 (&args, &args_length1, &_args_size_, _tmp30_);
	}
	_tmp33_ = option;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_ = NULL;
		_tmp34_ = option;
		_tmp32_ = g_strcmp0 (_tmp34_, "") != 0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		const gchar* _tmp35_ = NULL;
		_tmp35_ = option;
		_tmp31_ = g_strcmp0 (_tmp35_, "default") != 0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gchar* _tmp37_ = NULL;
		gchar** _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		gchar* _tmp39_ = NULL;
		gchar** _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		_tmp36_ = args;
		_tmp36__length1 = args_length1;
		_tmp37_ = g_strdup ("-option");
		_vala_array_add6 (&args, &args_length1, &_args_size_, _tmp37_);
		_tmp38_ = args;
		_tmp38__length1 = args_length1;
		_tmp39_ = g_strdup ("-option");
		_vala_array_add7 (&args, &args_length1, &_args_size_, _tmp39_);
		_tmp40_ = args;
		_tmp40__length1 = args_length1;
		_tmp41_ = option;
		_tmp42_ = g_strdup (_tmp41_);
		_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp42_);
	}
	_tmp43_ = args;
	_tmp43__length1 = args_length1;
	if (_tmp43__length1 == 1) {
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	{
		gboolean _tmp44_ = FALSE;
		gchar** _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		gchar* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gboolean _tmp48_ = FALSE;
		_tmp45_ = args;
		_tmp45__length1 = args_length1;
		_tmp48_ = g_spawn_sync (NULL, _tmp45_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp46_, &_tmp47_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp46_;
		exit_status = _tmp47_;
		_tmp44_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		if (!_tmp44_) {
			IBusEngineDesc* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			_tmp49_ = engine;
			_tmp50_ = ibus_engine_desc_get_layout (_tmp49_);
			g_warning ("main.vala:132: Switch xkb layout to %s failed.", _tmp50_);
			result = EXIT_FAILURE;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			return result;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		g_warning ("main.vala:137: Execute setxkbmap failed: %s", _tmp52_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp53_ = exit_status;
	if (_tmp53_ != 0) {
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		_tmp55_ = standard_error;
		_tmp54_ = _tmp55_;
		if (_tmp54_ == NULL) {
			_tmp54_ = "(null)";
		}
		g_warning ("main.vala:142: Execute setxkbmap failed: %s", _tmp54_);
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	result = EXIT_SUCCESS;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
	return result;
}


gint get_set_engine (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_ = NULL;
	gchar* engine = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp5_ = NULL;
	IBusBus* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	IBusEngineDesc* desc = NULL;
	IBusBus* _tmp19_ = NULL;
	IBusEngineDesc* _tmp20_ = NULL;
	IBusEngineDesc* _tmp21_ = NULL;
	IBusEngineDesc* _tmp22_ = NULL;
	IBusEngineDesc* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	engine = NULL;
	_tmp1_ = argv;
	_tmp1__length1 = argv_length1;
	if (_tmp1__length1 > 1) {
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = argv;
		_tmp2__length1 = argv_length1;
		_tmp3_ = _tmp2_[1];
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (engine);
		engine = _tmp4_;
	}
	_tmp5_ = engine;
	if (_tmp5_ == NULL) {
		IBusEngineDesc* desc = NULL;
		IBusBus* _tmp6_ = NULL;
		IBusEngineDesc* _tmp7_ = NULL;
		IBusEngineDesc* _tmp8_ = NULL;
		IBusEngineDesc* _tmp9_ = NULL;
		IBusEngineDesc* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp6_ = bus;
		_tmp7_ = ibus_bus_get_global_engine (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		desc = _tmp8_;
		_tmp9_ = desc;
		if (_tmp9_ == NULL) {
			FILE* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = stderr;
			_tmp11_ = _ ("No engine is set.\n");
			fprintf (_tmp10_, "%s", _tmp11_);
			result = EXIT_FAILURE;
			_g_object_unref0 (desc);
			_g_free0 (engine);
			_g_object_unref0 (bus);
			return result;
		}
		_tmp12_ = desc;
		_tmp13_ = ibus_engine_desc_get_name (_tmp12_);
		g_print ("%s\n", _tmp13_);
		result = EXIT_SUCCESS;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp14_ = bus;
	_tmp15_ = engine;
	_tmp16_ = ibus_bus_set_global_engine (_tmp14_, _tmp15_);
	if (!_tmp16_) {
		FILE* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = _ ("Set global engine failed.\n");
		fprintf (_tmp17_, "%s", _tmp18_);
		result = EXIT_FAILURE;
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp19_ = bus;
	_tmp20_ = ibus_bus_get_global_engine (_tmp19_);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	desc = _tmp21_;
	_tmp22_ = desc;
	if (_tmp22_ == NULL) {
		FILE* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = _ ("Get global engine failed.\n");
		fprintf (_tmp23_, "%s", _tmp24_);
		result = EXIT_FAILURE;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp25_ = desc;
	_tmp26_ = exec_setxkbmap (_tmp25_);
	result = _tmp26_;
	_g_object_unref0 (desc);
	_g_free0 (engine);
	_g_object_unref0 (bus);
	return result;
}


gint message_watch (gchar** argv, int argv_length1) {
	gint result = 0;
	result = EXIT_SUCCESS;
	return result;
}


gint restart_daemon (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_ = NULL;
	IBusBus* _tmp1_ = NULL;
	IBusBus* _tmp4_ = NULL;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _ ("Can't connect to IBus.\n");
		fprintf (_tmp2_, "%s", _tmp3_);
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp4_ = bus;
	ibus_bus_exit (_tmp4_, TRUE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}


gint exit_daemon (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_ = NULL;
	IBusBus* _tmp1_ = NULL;
	IBusBus* _tmp4_ = NULL;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _ ("Can't connect to IBus.\n");
		fprintf (_tmp2_, "%s", _tmp3_);
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp4_ = bus;
	ibus_bus_exit (_tmp4_, FALSE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}


gint print_version (gchar** argv, int argv_length1) {
	gint result = 0;
	g_print ("IBus %s\n", PACKAGE_VERSION);
	result = EXIT_SUCCESS;
	return result;
}


gint read_cache (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, "Read the system registry cache.", NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, "Read the registry cache FILE.", "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GString* output = NULL;
	GString* _tmp18_ = NULL;
	IBusRegistry* _tmp19_ = NULL;
	GString* _tmp20_ = NULL;
	GString* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_ = NULL;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_registry_new ();
	g_object_ref_sink (_tmp6_);
	registry = _tmp6_;
	_tmp7_ = cache_file;
	if (_tmp7_ != NULL) {
		IBusRegistry* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = registry;
		_tmp9_ = cache_file;
		_tmp10_ = ibus_registry_load_cache_file (_tmp8_, _tmp9_);
		if (!_tmp10_) {
			FILE* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp11_ = stderr;
			_tmp12_ = _ ("The registry cache is invalid.\n");
			fprintf (_tmp11_, "%s", _tmp12_);
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	} else {
		IBusRegistry* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = registry;
		_tmp14_ = is_system;
		_tmp15_ = ibus_registry_load_cache (_tmp13_, !_tmp14_);
		if (!_tmp15_) {
			FILE* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = stderr;
			_tmp17_ = _ ("The registry cache is invalid.\n");
			fprintf (_tmp16_, "%s", _tmp17_);
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp18_ = g_string_new ("");
	output = _tmp18_;
	_tmp19_ = registry;
	_tmp20_ = output;
	ibus_registry_output (_tmp19_, _tmp20_, 1);
	_tmp21_ = output;
	_tmp22_ = _tmp21_->str;
	g_print ("%s\n", _tmp22_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}


gint write_cache (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, "Write the system registry cache.", NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, "Write the registry cache FILE.", "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp6_ = NULL;
	IBusRegistry* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp13_ = 0;
	IBusRegistry* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_ = NULL;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_registry_new ();
	g_object_ref_sink (_tmp6_);
	registry = _tmp6_;
	_tmp7_ = registry;
	ibus_registry_load (_tmp7_);
	_tmp8_ = cache_file;
	if (_tmp8_ != NULL) {
		gint _tmp9_ = 0;
		IBusRegistry* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp10_ = registry;
		_tmp11_ = cache_file;
		_tmp12_ = ibus_registry_save_cache_file (_tmp10_, _tmp11_);
		if (_tmp12_) {
			_tmp9_ = EXIT_SUCCESS;
		} else {
			_tmp9_ = EXIT_FAILURE;
		}
		result = _tmp9_;
		_g_object_unref0 (registry);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp14_ = registry;
	_tmp15_ = is_system;
	_tmp16_ = ibus_registry_save_cache (_tmp14_, !_tmp15_);
	if (_tmp16_) {
		_tmp13_ = EXIT_SUCCESS;
	} else {
		_tmp13_ = EXIT_FAILURE;
	}
	result = _tmp13_;
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}


gint print_address (gchar** argv, int argv_length1) {
	gint result = 0;
	gchar* address = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = ibus_get_address ();
	_tmp1_ = g_strdup (_tmp0_);
	address = _tmp1_;
	_tmp3_ = address;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = address;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = "(null)";
	}
	g_print ("%s\n", _tmp2_);
	result = EXIT_SUCCESS;
	_g_free0 (address);
	return result;
}


gint read_config (gchar** argv, int argv_length1) {
	gint result = 0;
	GString* output = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	{
		const gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = IBUS_SCHEMAS;
		schema_collection_length1 = G_N_ELEMENTS (IBUS_SCHEMAS);
		for (schema_it = 0; schema_it < G_N_ELEMENTS (IBUS_SCHEMAS); schema_it = schema_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* schema = NULL;
			_tmp1_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp1_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp2_ = NULL;
				GSettings* _tmp3_ = NULL;
				GString* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				GSettings* _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				gchar** _tmp8_ = NULL;
				_tmp2_ = schema;
				_tmp3_ = g_settings_new (_tmp2_);
				settings = _tmp3_;
				_tmp4_ = output;
				_tmp5_ = schema;
				g_string_append_printf (_tmp4_, "SCHEMA: %s\n", _tmp5_);
				_tmp6_ = settings;
				_tmp8_ = _tmp7_ = g_settings_list_keys (_tmp6_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp8_;
					key_collection_length1 = _vala_array_length (_tmp7_);
					for (key_it = 0; key_it < _vala_array_length (_tmp7_); key_it = key_it + 1) {
						gchar* _tmp9_ = NULL;
						gchar* key = NULL;
						_tmp9_ = g_strdup (key_collection[key_it]);
						key = _tmp9_;
						{
							GVariant* variant = NULL;
							GSettings* _tmp10_ = NULL;
							const gchar* _tmp11_ = NULL;
							GVariant* _tmp12_ = NULL;
							GString* _tmp13_ = NULL;
							const gchar* _tmp14_ = NULL;
							GVariant* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							_tmp10_ = settings;
							_tmp11_ = key;
							_tmp12_ = g_settings_get_value (_tmp10_, _tmp11_);
							variant = _tmp12_;
							_tmp13_ = output;
							_tmp14_ = key;
							_tmp15_ = variant;
							_tmp16_ = g_variant_print (_tmp15_, TRUE);
							_tmp17_ = _tmp16_;
							g_string_append_printf (_tmp13_, "  %s: %s\n", _tmp14_, _tmp17_);
							_g_free0 (_tmp17_);
							_g_variant_unref0 (variant);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_free0 (schema);
			}
		}
	}
	_tmp18_ = output;
	_tmp19_ = _tmp18_->str;
	g_print ("%s", _tmp19_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	return result;
}


gint reset_config (gchar** argv, int argv_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp12_ = NULL;
	_tmp0_ = _ ("Resetting…");
	g_print ("%s\n", _tmp0_);
	{
		const gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = IBUS_SCHEMAS;
		schema_collection_length1 = G_N_ELEMENTS (IBUS_SCHEMAS);
		for (schema_it = 0; schema_it < G_N_ELEMENTS (IBUS_SCHEMAS); schema_it = schema_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* schema = NULL;
			_tmp1_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp1_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp2_ = NULL;
				GSettings* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				GSettings* _tmp5_ = NULL;
				gchar** _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				_tmp2_ = schema;
				_tmp3_ = g_settings_new (_tmp2_);
				settings = _tmp3_;
				_tmp4_ = schema;
				g_print ("SCHEMA: %s\n", _tmp4_);
				_tmp5_ = settings;
				_tmp7_ = _tmp6_ = g_settings_list_keys (_tmp5_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp7_;
					key_collection_length1 = _vala_array_length (_tmp6_);
					for (key_it = 0; key_it < _vala_array_length (_tmp6_); key_it = key_it + 1) {
						gchar* _tmp8_ = NULL;
						gchar* key = NULL;
						_tmp8_ = g_strdup (key_collection[key_it]);
						key = _tmp8_;
						{
							const gchar* _tmp9_ = NULL;
							GSettings* _tmp10_ = NULL;
							const gchar* _tmp11_ = NULL;
							_tmp9_ = key;
							g_print ("  %s\n", _tmp9_);
							_tmp10_ = settings;
							_tmp11_ = key;
							g_settings_reset (_tmp10_, _tmp11_);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_free0 (schema);
			}
		}
	}
	g_settings_sync ();
	_tmp12_ = _ ("Done");
	g_print ("%s\n", _tmp12_);
	result = EXIT_SUCCESS;
	return result;
}


gint print_help (gchar** argv, int argv_length1) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	_tmp0_ = stdout;
	print_usage (_tmp0_);
	result = EXIT_SUCCESS;
	return result;
}


CommandEntry* command_entry_dup (const CommandEntry* self) {
	CommandEntry* dup;
	dup = g_new0 (CommandEntry, 1);
	memcpy (dup, self, sizeof (CommandEntry));
	return dup;
}


void command_entry_free (CommandEntry* self) {
	g_free (self);
}


GType command_entry_get_type (void) {
	static volatile gsize command_entry_type_id__volatile = 0;
	if (g_once_init_enter (&command_entry_type_id__volatile)) {
		GType command_entry_type_id;
		command_entry_type_id = g_boxed_type_register_static ("CommandEntry", (GBoxedCopyFunc) command_entry_dup, (GBoxedFreeFunc) command_entry_free);
		g_once_init_leave (&command_entry_type_id__volatile, command_entry_type_id);
	}
	return command_entry_type_id__volatile;
}


static gint _get_set_engine_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = get_set_engine (argv, argv_length1);
	return result;
}


static gint _exit_daemon_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = exit_daemon (argv, argv_length1);
	return result;
}


static gint _list_engine_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = list_engine (argv, argv_length1);
	return result;
}


static gint _message_watch_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = message_watch (argv, argv_length1);
	return result;
}


static gint _restart_daemon_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = restart_daemon (argv, argv_length1);
	return result;
}


static gint _print_version_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_version (argv, argv_length1);
	return result;
}


static gint _read_cache_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = read_cache (argv, argv_length1);
	return result;
}


static gint _write_cache_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = write_cache (argv, argv_length1);
	return result;
}


static gint _print_address_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_address (argv, argv_length1);
	return result;
}


static gint _read_config_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = read_config (argv, argv_length1);
	return result;
}


static gint _reset_config_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = reset_config (argv, argv_length1);
	return result;
}


static gint _print_help_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_help (argv, argv_length1);
	return result;
}


void print_usage (FILE* stream) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (stream != NULL);
	_tmp0_ = stream;
	_tmp1_ = _ ("Usage: %s COMMAND [OPTION...]\n\n");
	_tmp2_ = program_name;
	fprintf (_tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = stream;
	_tmp4_ = _ ("Commands:\n");
	fprintf (_tmp3_, "%s", _tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				FILE* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				CommandEntry _tmp10_ = {0};
				const gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				CommandEntry _tmp13_ = {0};
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp8_ = stream;
				_tmp9_ = i;
				_tmp10_ = commands[_tmp9_];
				_tmp11_ = _tmp10_.name;
				_tmp12_ = i;
				_tmp13_ = commands[_tmp12_];
				_tmp14_ = _tmp13_.description;
				_tmp15_ = g_dgettext (NULL, _tmp14_);
				fprintf (_tmp8_, "  %-12s    %s\n", _tmp11_, _tmp15_);
			}
		}
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint _vala_main (gchar** argv, int argv_length1) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** new_argv = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint new_argv_length1 = 0;
	gint _new_argv_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	FILE* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	const gchar* _tmp30_ = NULL;
	FILE* _tmp31_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, GLIB_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_g_free0 (program_name);
	program_name = _tmp2_;
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	if (_tmp3__length1 < 2) {
		FILE* _tmp4_ = NULL;
		_tmp4_ = stderr;
		print_usage (_tmp4_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp5_ = argv;
	_tmp5__length1 = argv_length1;
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = ((_tmp5_ + 1) != NULL) ? _vala_array_dup1 (_tmp5_ + 1, _tmp6__length1 - 1) : ((gpointer) (_tmp5_ + 1));
	_tmp7__length1 = _tmp6__length1 - 1;
	new_argv = _tmp7_;
	new_argv_length1 = _tmp7__length1;
	_new_argv_size_ = new_argv_length1;
	_tmp8_ = new_argv;
	_tmp8__length1 = new_argv_length1;
	_tmp9_ = program_name;
	_tmp10_ = new_argv;
	_tmp10__length1 = new_argv_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_strdup_printf ("%s %s", _tmp9_, _tmp11_);
	_g_free0 (_tmp8_[0]);
	_tmp8_[0] = _tmp12_;
	_tmp13_ = _tmp8_[0];
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				CommandEntry _tmp18_ = {0};
				const gchar* _tmp19_ = NULL;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				const gchar* _tmp21_ = NULL;
				if (!_tmp14_) {
					gint _tmp15_ = 0;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp17_ = i;
				_tmp18_ = commands[_tmp17_];
				_tmp19_ = _tmp18_.name;
				_tmp20_ = argv;
				_tmp20__length1 = argv_length1;
				_tmp21_ = _tmp20_[1];
				if (g_strcmp0 (_tmp19_, _tmp21_) == 0) {
					gint _tmp22_ = 0;
					CommandEntry _tmp23_ = {0};
					EntryFunc _tmp24_ = NULL;
					void* _tmp24__target = NULL;
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					_tmp22_ = i;
					_tmp23_ = commands[_tmp22_];
					_tmp24_ = _tmp23_.entry;
					_tmp24__target = _tmp23_.entry_target;
					_tmp25_ = new_argv;
					_tmp25__length1 = new_argv_length1;
					_tmp26_ = _tmp24_ (_tmp25_, _tmp25__length1, _tmp24__target);
					result = _tmp26_;
					new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp27_ = stderr;
	_tmp28_ = _ ("%s is unknown command!\n");
	_tmp29_ = argv;
	_tmp29__length1 = argv_length1;
	_tmp30_ = _tmp29_[1];
	fprintf (_tmp27_, _tmp28_, _tmp30_);
	_tmp31_ = stderr;
	print_usage (_tmp31_);
	result = EXIT_FAILURE;
	new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



