<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Formats de mots de passe - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Documentations diverses</a></div><div id="page-content"><div id="preamble"><h1>Formats de mots de passe</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/misc/password_encryptions.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/misc/password_encryptions.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

    <p>Notes  propos des formats de chiffrement des mots de passe
    gnrs et compris par Apache.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#basic">Authentification de base</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#digest">Authentification  base de condenss</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="basic" id="basic">Authentification de base</a></h2>

    <p>Voici les cinq formats de mots de passe qu'Apache reconnat
    pour l'authentification de base. Notez que tous les formats ne sont
    pas supports par toutes les plates-formes :</p>

    <dl>
         
       <dt>bcrypt</dt>
       <dd>"$2y$" + the result of the crypt_blowfish algorithm. Driv
       de l'algorythme de chiffrement crypt_blowfish. Voir le fichier
       source APR <a href="http://svn.apache.org/viewvc/apr/apr/trunk/crypto/crypt_blowfish.c?view=markup">crypt_blowfish.c</a>
       pour plus de dtails  propos de cet algorithme.</dd>

       <dt>MD5</dt>
       <dd>"$apr1$" + le rsultat d'un algorithme spcifique  Apache
       utilisant un condens MD5 ritr (1000 fois) de combinaisons
       varies du mot de passe et d'une source d'entropie sur 32 bits.
       Voir le fichier source APR <a href="http://svn.apache.org/viewvc/apr/apr/trunk/crypto/apr_md5.c?view=markup">apr_md5.c</a>
       pour les dtails de l'algorithme.</dd>
    

    <dt>SHA1</dt>
       <dd>"{SHA}" + un condens SHA-1 du mot de passe cod en
       Base64. Non sr.</dd>

    <dt>CRYPT</dt>
       <dd>Unix seulement. Utilise la fonction Unix traditionnelle
       <code>crypt(3)</code> avec une source d'entropie sur 32 bits
       (seuls 12 bits sont utiliss), et seulement les 8 premiers
       caractres du mot de passe. Non sr.</dd>

    <dt>PLAIN TEXT (autrement dit <em>non chiffr</em>)</dt>
      <dd>Windows &amp; Netware seulement. Non sr.</dd>
    </dl>
    <h3>Gnrer des mots de passe avec htpasswd</h3>

      <div class="example"><h3>bcrypt</h3><p><code>
      $ htpasswd -nbB monNom monMot-de-passe<br />
      monNom:$2y$05$c4WoMPo3SXsafkva.HHa6uXQZWr7oboPiC2bT/r7q1BB8I2s0BRqC
      </code></p></div>    

      <div class="example"><h3>MD5</h3><p><code>
      $ htpasswd -nbm monNom monMot-de-passe<br />
      monNom:$apr1$r31.....$HqJZimcKQFAMYayBlzkrA/
      </code></p></div>

      <div class="example"><h3>SHA1</h3><p><code>
      $ htpasswd -nbs monNom monMot-de-passe<br />
      monNom:{SHA}VBPuJHI7uixaa6LQGWx4s+5GKNE=
      </code></p></div>

      <div class="example"><h3>CRYPT</h3><p><code>
      $ htpasswd -nbd monNom monMot-de-passe<br />
      monNom:rqXexS6ZhobKA
      </code></p></div>

    

    <h3>Gnrer des mots de passe CRYPT and MD5 avec le programme
      OpenSSL en ligne de commande</h3>
      

      <p>OpenSSL connat l'algorithme MD5 spcifique  Apache.</p>

      <div class="example"><h3>MD5</h3><p><code>
      $ openssl passwd -apr1 monMot-de-passe<br />
      $apr1$qHDFfhPC$nITSVHgYbDAK1Y0acGRnY0
      </code></p></div>

      <div class="example"><h3>CRYPT</h3><p><code>
      openssl passwd -crypt monMot-de-passe<br />
      qQ5vTYO3c8dsU
      </code></p></div>
    

    <h3>Valider des mots de passe CRYPT and MD5 avec le programme
      OpenSSL en ligne de commande</h3>
      
      <p>La source d'entropie pour un mot de passe CRYPT est constitue
      des deux premiers caractres (convertis en valeur binaire). Pour
      valider <code>monMot-de-passe</code> par rapport 
      <code>rqXexS6ZhobKA</code></p>

      <div class="example"><h3>CRYPT</h3><p><code>
      $ openssl passwd -crypt -salt rq monMot-de-passe<br />
      Warning: truncating password to 8 characters<br />
      rqXexS6ZhobKA
      </code></p></div>

      <p>Notez que spcifier <code>monMot-d</code> au lieu de
      <code>monMot-de-passe</code> produira le mme rsultat car seuls
      les 8 premiers caractres des mots de passe CRYPT sont pris en
      compte.</p>

      <p>La source d'entropie pour un mot de passe MD5 se situe entre
      <code>$apr1$</code> et le caractre <code>$</code> suivant (sous
      la forme d'une valeur binaire code en Base64 - au maximum 8
      caractres). Pour valider <code>monMot-de-passe</code> par rapport
       <code>$apr1$r31.....$HqJZimcKQFAMYayBlzkrA/</code></p>

      <div class="example"><h3>MD5</h3><p><code>
      $ openssl passwd -apr1 -salt r31..... monMot-de-passe<br />
      $apr1$r31.....$HqJZimcKQFAMYayBlzkrA/
      </code></p></div>
    

    <h3>Champs mot de passe de base de donnes pour
    mod_dbd</h3>
      <p>La variante SHA1 constitue probablement le format le mieux
      appropri pour l'authentification DBD. Comme les fonctions SHA1 et
      Base64 sont en gnral disponibles, d'autres logiciels peuvent
      renseigner une base de donnes avec des mots de passe chiffrs
      utilisables par l'authentification basique d'Apache.</p>

      <p>Pour crer des mots de passe au format SHA1 pour
      l'authentification de base d'Apache dans divers langages :</p>

      <div class="example"><h3>PHP</h3><p><code>
      '{SHA}' . base64_encode(sha1($password, TRUE))
      </code></p></div>

      <div class="example"><h3>Java</h3><p><code>
      "{SHA}" + new sun.misc.BASE64Encoder().encode(java.security.MessageDigest.getInstance("SHA1").digest(password.getBytes()))
      </code></p></div>

      <div class="example"><h3>ColdFusion</h3><p><code>
      "{SHA}" &amp; ToBase64(BinaryDecode(Hash(password, "SHA1"), "Hex"))
      </code></p></div>

      <div class="example"><h3>Ruby</h3><p><code>
      require 'digest/sha1'<br />
      require 'base64'<br />
      '{SHA}' + Base64.encode64(Digest::SHA1.digest(password))
      </code></p></div>

      <div class="example"><h3>C ou C++</h3><p><code>
      Utilisez la fonction APR : apr_sha1_base64
      </code></p></div>

      <div class="example"><h3>PostgreSQL (avec les fonctions contrib/pgcrypto
               installes)</h3><p><code>
        
        '{SHA}'||encode(digest(password,'sha1'),'base64')
      </code></p></div>
    

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="digest" id="digest">Authentification  base de condenss</a></h2>
    <p>Apache ne reconnat qu'un format pour les mots de passe
    d'authentification  base de condenss - le condens MD5 de la
    chane <code>utilisateur:domaine-de-protection:mot-de-passe</code>
    sous la forme d'une chane de 32 caractres au format hexadcimal.
    <code>domaine-de-protection</code> est l'identifiant du domaine de
    protection de l'autorisation pass en argument  la directive
    <code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code> dans
    httpd.conf.</p>

    <h3>Champs de mot de passe de base de donnes pour
    mod_dbd</h3>

      <p>Comme la fonction MD5 est en gnral disponible, d'autres
      logiciels peuvent renseigner une base de donnes avec des mots de
      passe chiffrs utilisables par l'authentification  base de
      condenss d'Apache.</p>

      <p>Pour crer des mots de passe pour l'authentification  base de
      condenss d'Apache dans divers langages :</p>

      <div class="example"><h3>PHP</h3><p><code>
      md5($user . ':' . $realm . ':' .$password)
      </code></p></div>

      <div class="example"><h3>Java</h3><p><code>
      byte b[] = java.security.MessageDigest.getInstance("MD5").digest( (user + ":" + realm + ":" + password ).getBytes());<br />
      java.math.BigInteger bi = new java.math.BigInteger(1, b);<br />
      String s = bi.toString(16);<br />
      while (s.length() &lt; 32)<br />
      <span class="indent">
        s = "0" + s;
      </span>
      // La chane s contient le mot de passe chiffr
      </code></p></div>

      <div class="example"><h3>ColdFusion</h3><p><code>
      LCase(Hash( (user &amp; ":" &amp; realm &amp; ":" &amp; password) , "MD5"))
      </code></p></div>

      <div class="example"><h3>Ruby</h3><p><code>
      require 'digest/md5'<br />
      Digest::MD5.hexdigest(user + ':' + realm + ':' + password)
      </code></p></div>

      <div class="example"><h3>PostgreSQL (avec les fonctions contrib/pgcrypto
	installes)</h3><p><code>
        
        encode(digest( user || ':' || realm || ':' || password , 'md5'), 'hex')
      </code></p></div>

    
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/misc/password_encryptions.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/misc/password_encryptions.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/misc/password_encryptions.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>