/* DO NOT EDIT - This file generated automatically by gl_gentable.py (from Mesa) script */

/*
 * Copyright (C) 1999-2001  Brian Paul   All Rights Reserved.
 * (C) Copyright IBM Corporation 2004, 2005
 * (C) Copyright Apple Inc 2011
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL, IBM,
 * AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* GLXEXT is the define used in the xserver when the GLX extension is being
 * built.  Hijack this to determine whether this file is being built for the
 * server or the client.
 */
#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#if (defined(GLXEXT) && defined(HAVE_BACKTRACE)) \
	|| (!defined(GLXEXT) && defined(DEBUG) && !defined(__CYGWIN__) && !defined(__MINGW32__) && !defined(__OpenBSD__) && !defined(__NetBSD__) && !defined(__DragonFly__))
#define USE_BACKTRACE
#endif

#ifdef USE_BACKTRACE
#include <execinfo.h>
#endif

#ifndef _WIN32
#include <dlfcn.h>
#endif
#include <stdlib.h>
#include <stdio.h>

#include "main/glheader.h"

#include "glapi.h"
#include "glapitable.h"

#ifdef GLXEXT
#include "os.h"
#endif

static void
__glapi_gentable_NoOp(void) {
    const char *fstr = "Unknown";

    /* Silence potential GCC warning for some #ifdef paths.
     */
    (void) fstr;
#if defined(USE_BACKTRACE)
#if !defined(GLXEXT)
    if (getenv("MESA_DEBUG") || getenv("LIBGL_DEBUG"))
#endif
    {
        void *frames[2];

        if(backtrace(frames, 2) == 2) {
            Dl_info info;
            dladdr(frames[1], &info);
            if(info.dli_sname)
                fstr = info.dli_sname;
        }

#if !defined(GLXEXT)
        fprintf(stderr, "Call to unimplemented API: %s\n", fstr);
#endif
    }
#endif
#if defined(GLXEXT)
    LogMessage(X_ERROR, "GLX: Call to unimplemented API: %s\n", fstr);
#endif
}

static void
__glapi_gentable_set_remaining_noop(struct _glapi_table *disp) {
    GLuint entries = _glapi_get_dispatch_table_size();
    void **dispatch = (void **) disp;
    unsigned i;

    /* ISO C is annoying sometimes */
    union {_glapi_proc p; void *v;} p;
    p.p = __glapi_gentable_NoOp;

    for(i=0; i < entries; i++)
        if(dispatch[i] == NULL)
            dispatch[i] = p.v;
}


#define GLAPI_TABLE_COUNT 1324
static const char * const _glapi_table_func_names[GLAPI_TABLE_COUNT] = {
    /*     0 */ "NewList",
    /*     1 */ "EndList",
    /*     2 */ "CallList",
    /*     3 */ "CallLists",
    /*     4 */ "DeleteLists",
    /*     5 */ "GenLists",
    /*     6 */ "ListBase",
    /*     7 */ "Begin",
    /*     8 */ "Bitmap",
    /*     9 */ "Color3b",
    /*    10 */ "Color3bv",
    /*    11 */ "Color3d",
    /*    12 */ "Color3dv",
    /*    13 */ "Color3f",
    /*    14 */ "Color3fv",
    /*    15 */ "Color3i",
    /*    16 */ "Color3iv",
    /*    17 */ "Color3s",
    /*    18 */ "Color3sv",
    /*    19 */ "Color3ub",
    /*    20 */ "Color3ubv",
    /*    21 */ "Color3ui",
    /*    22 */ "Color3uiv",
    /*    23 */ "Color3us",
    /*    24 */ "Color3usv",
    /*    25 */ "Color4b",
    /*    26 */ "Color4bv",
    /*    27 */ "Color4d",
    /*    28 */ "Color4dv",
    /*    29 */ "Color4f",
    /*    30 */ "Color4fv",
    /*    31 */ "Color4i",
    /*    32 */ "Color4iv",
    /*    33 */ "Color4s",
    /*    34 */ "Color4sv",
    /*    35 */ "Color4ub",
    /*    36 */ "Color4ubv",
    /*    37 */ "Color4ui",
    /*    38 */ "Color4uiv",
    /*    39 */ "Color4us",
    /*    40 */ "Color4usv",
    /*    41 */ "EdgeFlag",
    /*    42 */ "EdgeFlagv",
    /*    43 */ "End",
    /*    44 */ "Indexd",
    /*    45 */ "Indexdv",
    /*    46 */ "Indexf",
    /*    47 */ "Indexfv",
    /*    48 */ "Indexi",
    /*    49 */ "Indexiv",
    /*    50 */ "Indexs",
    /*    51 */ "Indexsv",
    /*    52 */ "Normal3b",
    /*    53 */ "Normal3bv",
    /*    54 */ "Normal3d",
    /*    55 */ "Normal3dv",
    /*    56 */ "Normal3f",
    /*    57 */ "Normal3fv",
    /*    58 */ "Normal3i",
    /*    59 */ "Normal3iv",
    /*    60 */ "Normal3s",
    /*    61 */ "Normal3sv",
    /*    62 */ "RasterPos2d",
    /*    63 */ "RasterPos2dv",
    /*    64 */ "RasterPos2f",
    /*    65 */ "RasterPos2fv",
    /*    66 */ "RasterPos2i",
    /*    67 */ "RasterPos2iv",
    /*    68 */ "RasterPos2s",
    /*    69 */ "RasterPos2sv",
    /*    70 */ "RasterPos3d",
    /*    71 */ "RasterPos3dv",
    /*    72 */ "RasterPos3f",
    /*    73 */ "RasterPos3fv",
    /*    74 */ "RasterPos3i",
    /*    75 */ "RasterPos3iv",
    /*    76 */ "RasterPos3s",
    /*    77 */ "RasterPos3sv",
    /*    78 */ "RasterPos4d",
    /*    79 */ "RasterPos4dv",
    /*    80 */ "RasterPos4f",
    /*    81 */ "RasterPos4fv",
    /*    82 */ "RasterPos4i",
    /*    83 */ "RasterPos4iv",
    /*    84 */ "RasterPos4s",
    /*    85 */ "RasterPos4sv",
    /*    86 */ "Rectd",
    /*    87 */ "Rectdv",
    /*    88 */ "Rectf",
    /*    89 */ "Rectfv",
    /*    90 */ "Recti",
    /*    91 */ "Rectiv",
    /*    92 */ "Rects",
    /*    93 */ "Rectsv",
    /*    94 */ "TexCoord1d",
    /*    95 */ "TexCoord1dv",
    /*    96 */ "TexCoord1f",
    /*    97 */ "TexCoord1fv",
    /*    98 */ "TexCoord1i",
    /*    99 */ "TexCoord1iv",
    /*   100 */ "TexCoord1s",
    /*   101 */ "TexCoord1sv",
    /*   102 */ "TexCoord2d",
    /*   103 */ "TexCoord2dv",
    /*   104 */ "TexCoord2f",
    /*   105 */ "TexCoord2fv",
    /*   106 */ "TexCoord2i",
    /*   107 */ "TexCoord2iv",
    /*   108 */ "TexCoord2s",
    /*   109 */ "TexCoord2sv",
    /*   110 */ "TexCoord3d",
    /*   111 */ "TexCoord3dv",
    /*   112 */ "TexCoord3f",
    /*   113 */ "TexCoord3fv",
    /*   114 */ "TexCoord3i",
    /*   115 */ "TexCoord3iv",
    /*   116 */ "TexCoord3s",
    /*   117 */ "TexCoord3sv",
    /*   118 */ "TexCoord4d",
    /*   119 */ "TexCoord4dv",
    /*   120 */ "TexCoord4f",
    /*   121 */ "TexCoord4fv",
    /*   122 */ "TexCoord4i",
    /*   123 */ "TexCoord4iv",
    /*   124 */ "TexCoord4s",
    /*   125 */ "TexCoord4sv",
    /*   126 */ "Vertex2d",
    /*   127 */ "Vertex2dv",
    /*   128 */ "Vertex2f",
    /*   129 */ "Vertex2fv",
    /*   130 */ "Vertex2i",
    /*   131 */ "Vertex2iv",
    /*   132 */ "Vertex2s",
    /*   133 */ "Vertex2sv",
    /*   134 */ "Vertex3d",
    /*   135 */ "Vertex3dv",
    /*   136 */ "Vertex3f",
    /*   137 */ "Vertex3fv",
    /*   138 */ "Vertex3i",
    /*   139 */ "Vertex3iv",
    /*   140 */ "Vertex3s",
    /*   141 */ "Vertex3sv",
    /*   142 */ "Vertex4d",
    /*   143 */ "Vertex4dv",
    /*   144 */ "Vertex4f",
    /*   145 */ "Vertex4fv",
    /*   146 */ "Vertex4i",
    /*   147 */ "Vertex4iv",
    /*   148 */ "Vertex4s",
    /*   149 */ "Vertex4sv",
    /*   150 */ "ClipPlane",
    /*   151 */ "ColorMaterial",
    /*   152 */ "CullFace",
    /*   153 */ "Fogf",
    /*   154 */ "Fogfv",
    /*   155 */ "Fogi",
    /*   156 */ "Fogiv",
    /*   157 */ "FrontFace",
    /*   158 */ "Hint",
    /*   159 */ "Lightf",
    /*   160 */ "Lightfv",
    /*   161 */ "Lighti",
    /*   162 */ "Lightiv",
    /*   163 */ "LightModelf",
    /*   164 */ "LightModelfv",
    /*   165 */ "LightModeli",
    /*   166 */ "LightModeliv",
    /*   167 */ "LineStipple",
    /*   168 */ "LineWidth",
    /*   169 */ "Materialf",
    /*   170 */ "Materialfv",
    /*   171 */ "Materiali",
    /*   172 */ "Materialiv",
    /*   173 */ "PointSize",
    /*   174 */ "PolygonMode",
    /*   175 */ "PolygonStipple",
    /*   176 */ "Scissor",
    /*   177 */ "ShadeModel",
    /*   178 */ "TexParameterf",
    /*   179 */ "TexParameterfv",
    /*   180 */ "TexParameteri",
    /*   181 */ "TexParameteriv",
    /*   182 */ "TexImage1D",
    /*   183 */ "TexImage2D",
    /*   184 */ "TexEnvf",
    /*   185 */ "TexEnvfv",
    /*   186 */ "TexEnvi",
    /*   187 */ "TexEnviv",
    /*   188 */ "TexGend",
    /*   189 */ "TexGendv",
    /*   190 */ "TexGenf",
    /*   191 */ "TexGenfv",
    /*   192 */ "TexGeni",
    /*   193 */ "TexGeniv",
    /*   194 */ "FeedbackBuffer",
    /*   195 */ "SelectBuffer",
    /*   196 */ "RenderMode",
    /*   197 */ "InitNames",
    /*   198 */ "LoadName",
    /*   199 */ "PassThrough",
    /*   200 */ "PopName",
    /*   201 */ "PushName",
    /*   202 */ "DrawBuffer",
    /*   203 */ "Clear",
    /*   204 */ "ClearAccum",
    /*   205 */ "ClearIndex",
    /*   206 */ "ClearColor",
    /*   207 */ "ClearStencil",
    /*   208 */ "ClearDepth",
    /*   209 */ "StencilMask",
    /*   210 */ "ColorMask",
    /*   211 */ "DepthMask",
    /*   212 */ "IndexMask",
    /*   213 */ "Accum",
    /*   214 */ "Disable",
    /*   215 */ "Enable",
    /*   216 */ "Finish",
    /*   217 */ "Flush",
    /*   218 */ "PopAttrib",
    /*   219 */ "PushAttrib",
    /*   220 */ "Map1d",
    /*   221 */ "Map1f",
    /*   222 */ "Map2d",
    /*   223 */ "Map2f",
    /*   224 */ "MapGrid1d",
    /*   225 */ "MapGrid1f",
    /*   226 */ "MapGrid2d",
    /*   227 */ "MapGrid2f",
    /*   228 */ "EvalCoord1d",
    /*   229 */ "EvalCoord1dv",
    /*   230 */ "EvalCoord1f",
    /*   231 */ "EvalCoord1fv",
    /*   232 */ "EvalCoord2d",
    /*   233 */ "EvalCoord2dv",
    /*   234 */ "EvalCoord2f",
    /*   235 */ "EvalCoord2fv",
    /*   236 */ "EvalMesh1",
    /*   237 */ "EvalPoint1",
    /*   238 */ "EvalMesh2",
    /*   239 */ "EvalPoint2",
    /*   240 */ "AlphaFunc",
    /*   241 */ "BlendFunc",
    /*   242 */ "LogicOp",
    /*   243 */ "StencilFunc",
    /*   244 */ "StencilOp",
    /*   245 */ "DepthFunc",
    /*   246 */ "PixelZoom",
    /*   247 */ "PixelTransferf",
    /*   248 */ "PixelTransferi",
    /*   249 */ "PixelStoref",
    /*   250 */ "PixelStorei",
    /*   251 */ "PixelMapfv",
    /*   252 */ "PixelMapuiv",
    /*   253 */ "PixelMapusv",
    /*   254 */ "ReadBuffer",
    /*   255 */ "CopyPixels",
    /*   256 */ "ReadPixels",
    /*   257 */ "DrawPixels",
    /*   258 */ "GetBooleanv",
    /*   259 */ "GetClipPlane",
    /*   260 */ "GetDoublev",
    /*   261 */ "GetError",
    /*   262 */ "GetFloatv",
    /*   263 */ "GetIntegerv",
    /*   264 */ "GetLightfv",
    /*   265 */ "GetLightiv",
    /*   266 */ "GetMapdv",
    /*   267 */ "GetMapfv",
    /*   268 */ "GetMapiv",
    /*   269 */ "GetMaterialfv",
    /*   270 */ "GetMaterialiv",
    /*   271 */ "GetPixelMapfv",
    /*   272 */ "GetPixelMapuiv",
    /*   273 */ "GetPixelMapusv",
    /*   274 */ "GetPolygonStipple",
    /*   275 */ "GetString",
    /*   276 */ "GetTexEnvfv",
    /*   277 */ "GetTexEnviv",
    /*   278 */ "GetTexGendv",
    /*   279 */ "GetTexGenfv",
    /*   280 */ "GetTexGeniv",
    /*   281 */ "GetTexImage",
    /*   282 */ "GetTexParameterfv",
    /*   283 */ "GetTexParameteriv",
    /*   284 */ "GetTexLevelParameterfv",
    /*   285 */ "GetTexLevelParameteriv",
    /*   286 */ "IsEnabled",
    /*   287 */ "IsList",
    /*   288 */ "DepthRange",
    /*   289 */ "Frustum",
    /*   290 */ "LoadIdentity",
    /*   291 */ "LoadMatrixf",
    /*   292 */ "LoadMatrixd",
    /*   293 */ "MatrixMode",
    /*   294 */ "MultMatrixf",
    /*   295 */ "MultMatrixd",
    /*   296 */ "Ortho",
    /*   297 */ "PopMatrix",
    /*   298 */ "PushMatrix",
    /*   299 */ "Rotated",
    /*   300 */ "Rotatef",
    /*   301 */ "Scaled",
    /*   302 */ "Scalef",
    /*   303 */ "Translated",
    /*   304 */ "Translatef",
    /*   305 */ "Viewport",
    /*   306 */ "ArrayElement",
    /*   307 */ "BindTexture",
    /*   308 */ "ColorPointer",
    /*   309 */ "DisableClientState",
    /*   310 */ "DrawArrays",
    /*   311 */ "DrawElements",
    /*   312 */ "EdgeFlagPointer",
    /*   313 */ "EnableClientState",
    /*   314 */ "IndexPointer",
    /*   315 */ "Indexub",
    /*   316 */ "Indexubv",
    /*   317 */ "InterleavedArrays",
    /*   318 */ "NormalPointer",
    /*   319 */ "PolygonOffset",
    /*   320 */ "TexCoordPointer",
    /*   321 */ "VertexPointer",
    /*   322 */ "AreTexturesResident",
    /*   323 */ "CopyTexImage1D",
    /*   324 */ "CopyTexImage2D",
    /*   325 */ "CopyTexSubImage1D",
    /*   326 */ "CopyTexSubImage2D",
    /*   327 */ "DeleteTextures",
    /*   328 */ "GenTextures",
    /*   329 */ "GetPointerv",
    /*   330 */ "IsTexture",
    /*   331 */ "PrioritizeTextures",
    /*   332 */ "TexSubImage1D",
    /*   333 */ "TexSubImage2D",
    /*   334 */ "PopClientAttrib",
    /*   335 */ "PushClientAttrib",
    /*   336 */ "BlendColor",
    /*   337 */ "BlendEquation",
    /*   338 */ "DrawRangeElements",
    /*   339 */ "ColorTable",
    /*   340 */ "ColorTableParameterfv",
    /*   341 */ "ColorTableParameteriv",
    /*   342 */ "CopyColorTable",
    /*   343 */ "GetColorTable",
    /*   344 */ "GetColorTableParameterfv",
    /*   345 */ "GetColorTableParameteriv",
    /*   346 */ "ColorSubTable",
    /*   347 */ "CopyColorSubTable",
    /*   348 */ "ConvolutionFilter1D",
    /*   349 */ "ConvolutionFilter2D",
    /*   350 */ "ConvolutionParameterf",
    /*   351 */ "ConvolutionParameterfv",
    /*   352 */ "ConvolutionParameteri",
    /*   353 */ "ConvolutionParameteriv",
    /*   354 */ "CopyConvolutionFilter1D",
    /*   355 */ "CopyConvolutionFilter2D",
    /*   356 */ "GetConvolutionFilter",
    /*   357 */ "GetConvolutionParameterfv",
    /*   358 */ "GetConvolutionParameteriv",
    /*   359 */ "GetSeparableFilter",
    /*   360 */ "SeparableFilter2D",
    /*   361 */ "GetHistogram",
    /*   362 */ "GetHistogramParameterfv",
    /*   363 */ "GetHistogramParameteriv",
    /*   364 */ "GetMinmax",
    /*   365 */ "GetMinmaxParameterfv",
    /*   366 */ "GetMinmaxParameteriv",
    /*   367 */ "Histogram",
    /*   368 */ "Minmax",
    /*   369 */ "ResetHistogram",
    /*   370 */ "ResetMinmax",
    /*   371 */ "TexImage3D",
    /*   372 */ "TexSubImage3D",
    /*   373 */ "CopyTexSubImage3D",
    /*   374 */ "ActiveTexture",
    /*   375 */ "ClientActiveTexture",
    /*   376 */ "MultiTexCoord1d",
    /*   377 */ "MultiTexCoord1dv",
    /*   378 */ "MultiTexCoord1fARB",
    /*   379 */ "MultiTexCoord1fvARB",
    /*   380 */ "MultiTexCoord1i",
    /*   381 */ "MultiTexCoord1iv",
    /*   382 */ "MultiTexCoord1s",
    /*   383 */ "MultiTexCoord1sv",
    /*   384 */ "MultiTexCoord2d",
    /*   385 */ "MultiTexCoord2dv",
    /*   386 */ "MultiTexCoord2fARB",
    /*   387 */ "MultiTexCoord2fvARB",
    /*   388 */ "MultiTexCoord2i",
    /*   389 */ "MultiTexCoord2iv",
    /*   390 */ "MultiTexCoord2s",
    /*   391 */ "MultiTexCoord2sv",
    /*   392 */ "MultiTexCoord3d",
    /*   393 */ "MultiTexCoord3dv",
    /*   394 */ "MultiTexCoord3fARB",
    /*   395 */ "MultiTexCoord3fvARB",
    /*   396 */ "MultiTexCoord3i",
    /*   397 */ "MultiTexCoord3iv",
    /*   398 */ "MultiTexCoord3s",
    /*   399 */ "MultiTexCoord3sv",
    /*   400 */ "MultiTexCoord4d",
    /*   401 */ "MultiTexCoord4dv",
    /*   402 */ "MultiTexCoord4fARB",
    /*   403 */ "MultiTexCoord4fvARB",
    /*   404 */ "MultiTexCoord4i",
    /*   405 */ "MultiTexCoord4iv",
    /*   406 */ "MultiTexCoord4s",
    /*   407 */ "MultiTexCoord4sv",
    /*   408 */ "CompressedTexImage1D",
    /*   409 */ "CompressedTexImage2D",
    /*   410 */ "CompressedTexImage3D",
    /*   411 */ "CompressedTexSubImage1D",
    /*   412 */ "CompressedTexSubImage2D",
    /*   413 */ "CompressedTexSubImage3D",
    /*   414 */ "GetCompressedTexImage",
    /*   415 */ "LoadTransposeMatrixd",
    /*   416 */ "LoadTransposeMatrixf",
    /*   417 */ "MultTransposeMatrixd",
    /*   418 */ "MultTransposeMatrixf",
    /*   419 */ "SampleCoverage",
    /*   420 */ "BlendFuncSeparate",
    /*   421 */ "FogCoordPointer",
    /*   422 */ "FogCoordd",
    /*   423 */ "FogCoorddv",
    /*   424 */ "MultiDrawArrays",
    /*   425 */ "PointParameterf",
    /*   426 */ "PointParameterfv",
    /*   427 */ "PointParameteri",
    /*   428 */ "PointParameteriv",
    /*   429 */ "SecondaryColor3b",
    /*   430 */ "SecondaryColor3bv",
    /*   431 */ "SecondaryColor3d",
    /*   432 */ "SecondaryColor3dv",
    /*   433 */ "SecondaryColor3i",
    /*   434 */ "SecondaryColor3iv",
    /*   435 */ "SecondaryColor3s",
    /*   436 */ "SecondaryColor3sv",
    /*   437 */ "SecondaryColor3ub",
    /*   438 */ "SecondaryColor3ubv",
    /*   439 */ "SecondaryColor3ui",
    /*   440 */ "SecondaryColor3uiv",
    /*   441 */ "SecondaryColor3us",
    /*   442 */ "SecondaryColor3usv",
    /*   443 */ "SecondaryColorPointer",
    /*   444 */ "WindowPos2d",
    /*   445 */ "WindowPos2dv",
    /*   446 */ "WindowPos2f",
    /*   447 */ "WindowPos2fv",
    /*   448 */ "WindowPos2i",
    /*   449 */ "WindowPos2iv",
    /*   450 */ "WindowPos2s",
    /*   451 */ "WindowPos2sv",
    /*   452 */ "WindowPos3d",
    /*   453 */ "WindowPos3dv",
    /*   454 */ "WindowPos3f",
    /*   455 */ "WindowPos3fv",
    /*   456 */ "WindowPos3i",
    /*   457 */ "WindowPos3iv",
    /*   458 */ "WindowPos3s",
    /*   459 */ "WindowPos3sv",
    /*   460 */ "BeginQuery",
    /*   461 */ "BindBuffer",
    /*   462 */ "BufferData",
    /*   463 */ "BufferSubData",
    /*   464 */ "DeleteBuffers",
    /*   465 */ "DeleteQueries",
    /*   466 */ "EndQuery",
    /*   467 */ "GenBuffers",
    /*   468 */ "GenQueries",
    /*   469 */ "GetBufferParameteriv",
    /*   470 */ "GetBufferPointerv",
    /*   471 */ "GetBufferSubData",
    /*   472 */ "GetQueryObjectiv",
    /*   473 */ "GetQueryObjectuiv",
    /*   474 */ "GetQueryiv",
    /*   475 */ "IsBuffer",
    /*   476 */ "IsQuery",
    /*   477 */ "MapBuffer",
    /*   478 */ "UnmapBuffer",
    /*   479 */ "AttachShader",
    /*   480 */ "BindAttribLocation",
    /*   481 */ "BlendEquationSeparate",
    /*   482 */ "CompileShader",
    /*   483 */ "CreateProgram",
    /*   484 */ "CreateShader",
    /*   485 */ "DeleteProgram",
    /*   486 */ "DeleteShader",
    /*   487 */ "DetachShader",
    /*   488 */ "DisableVertexAttribArray",
    /*   489 */ "DrawBuffers",
    /*   490 */ "EnableVertexAttribArray",
    /*   491 */ "GetActiveAttrib",
    /*   492 */ "GetActiveUniform",
    /*   493 */ "GetAttachedShaders",
    /*   494 */ "GetAttribLocation",
    /*   495 */ "GetProgramInfoLog",
    /*   496 */ "GetProgramiv",
    /*   497 */ "GetShaderInfoLog",
    /*   498 */ "GetShaderSource",
    /*   499 */ "GetShaderiv",
    /*   500 */ "GetUniformLocation",
    /*   501 */ "GetUniformfv",
    /*   502 */ "GetUniformiv",
    /*   503 */ "GetVertexAttribPointerv",
    /*   504 */ "GetVertexAttribdv",
    /*   505 */ "GetVertexAttribfv",
    /*   506 */ "GetVertexAttribiv",
    /*   507 */ "IsProgram",
    /*   508 */ "IsShader",
    /*   509 */ "LinkProgram",
    /*   510 */ "ShaderSource",
    /*   511 */ "StencilFuncSeparate",
    /*   512 */ "StencilMaskSeparate",
    /*   513 */ "StencilOpSeparate",
    /*   514 */ "Uniform1f",
    /*   515 */ "Uniform1fv",
    /*   516 */ "Uniform1i",
    /*   517 */ "Uniform1iv",
    /*   518 */ "Uniform2f",
    /*   519 */ "Uniform2fv",
    /*   520 */ "Uniform2i",
    /*   521 */ "Uniform2iv",
    /*   522 */ "Uniform3f",
    /*   523 */ "Uniform3fv",
    /*   524 */ "Uniform3i",
    /*   525 */ "Uniform3iv",
    /*   526 */ "Uniform4f",
    /*   527 */ "Uniform4fv",
    /*   528 */ "Uniform4i",
    /*   529 */ "Uniform4iv",
    /*   530 */ "UniformMatrix2fv",
    /*   531 */ "UniformMatrix3fv",
    /*   532 */ "UniformMatrix4fv",
    /*   533 */ "UseProgram",
    /*   534 */ "ValidateProgram",
    /*   535 */ "VertexAttrib1d",
    /*   536 */ "VertexAttrib1dv",
    /*   537 */ "VertexAttrib1s",
    /*   538 */ "VertexAttrib1sv",
    /*   539 */ "VertexAttrib2d",
    /*   540 */ "VertexAttrib2dv",
    /*   541 */ "VertexAttrib2s",
    /*   542 */ "VertexAttrib2sv",
    /*   543 */ "VertexAttrib3d",
    /*   544 */ "VertexAttrib3dv",
    /*   545 */ "VertexAttrib3s",
    /*   546 */ "VertexAttrib3sv",
    /*   547 */ "VertexAttrib4Nbv",
    /*   548 */ "VertexAttrib4Niv",
    /*   549 */ "VertexAttrib4Nsv",
    /*   550 */ "VertexAttrib4Nub",
    /*   551 */ "VertexAttrib4Nubv",
    /*   552 */ "VertexAttrib4Nuiv",
    /*   553 */ "VertexAttrib4Nusv",
    /*   554 */ "VertexAttrib4bv",
    /*   555 */ "VertexAttrib4d",
    /*   556 */ "VertexAttrib4dv",
    /*   557 */ "VertexAttrib4iv",
    /*   558 */ "VertexAttrib4s",
    /*   559 */ "VertexAttrib4sv",
    /*   560 */ "VertexAttrib4ubv",
    /*   561 */ "VertexAttrib4uiv",
    /*   562 */ "VertexAttrib4usv",
    /*   563 */ "VertexAttribPointer",
    /*   564 */ "UniformMatrix2x3fv",
    /*   565 */ "UniformMatrix2x4fv",
    /*   566 */ "UniformMatrix3x2fv",
    /*   567 */ "UniformMatrix3x4fv",
    /*   568 */ "UniformMatrix4x2fv",
    /*   569 */ "UniformMatrix4x3fv",
    /*   570 */ "BeginConditionalRender",
    /*   571 */ "BeginTransformFeedback",
    /*   572 */ "BindBufferBase",
    /*   573 */ "BindBufferRange",
    /*   574 */ "BindFragDataLocation",
    /*   575 */ "ClampColor",
    /*   576 */ "ClearBufferfi",
    /*   577 */ "ClearBufferfv",
    /*   578 */ "ClearBufferiv",
    /*   579 */ "ClearBufferuiv",
    /*   580 */ "ColorMaski",
    /*   581 */ "Disablei",
    /*   582 */ "Enablei",
    /*   583 */ "EndConditionalRender",
    /*   584 */ "EndTransformFeedback",
    /*   585 */ "GetBooleani_v",
    /*   586 */ "GetFragDataLocation",
    /*   587 */ "GetIntegeri_v",
    /*   588 */ "GetStringi",
    /*   589 */ "GetTexParameterIiv",
    /*   590 */ "GetTexParameterIuiv",
    /*   591 */ "GetTransformFeedbackVarying",
    /*   592 */ "GetUniformuiv",
    /*   593 */ "GetVertexAttribIiv",
    /*   594 */ "GetVertexAttribIuiv",
    /*   595 */ "IsEnabledi",
    /*   596 */ "TexParameterIiv",
    /*   597 */ "TexParameterIuiv",
    /*   598 */ "TransformFeedbackVaryings",
    /*   599 */ "Uniform1ui",
    /*   600 */ "Uniform1uiv",
    /*   601 */ "Uniform2ui",
    /*   602 */ "Uniform2uiv",
    /*   603 */ "Uniform3ui",
    /*   604 */ "Uniform3uiv",
    /*   605 */ "Uniform4ui",
    /*   606 */ "Uniform4uiv",
    /*   607 */ "VertexAttribI1iv",
    /*   608 */ "VertexAttribI1uiv",
    /*   609 */ "VertexAttribI4bv",
    /*   610 */ "VertexAttribI4sv",
    /*   611 */ "VertexAttribI4ubv",
    /*   612 */ "VertexAttribI4usv",
    /*   613 */ "VertexAttribIPointer",
    /*   614 */ "PrimitiveRestartIndex",
    /*   615 */ "TexBuffer",
    /*   616 */ "FramebufferTexture",
    /*   617 */ "GetBufferParameteri64v",
    /*   618 */ "GetInteger64i_v",
    /*   619 */ "VertexAttribDivisor",
    /*   620 */ "MinSampleShading",
    /*   621 */ "MemoryBarrierByRegion",
    /*   622 */ "BindProgramARB",
    /*   623 */ "DeleteProgramsARB",
    /*   624 */ "GenProgramsARB",
    /*   625 */ "GetProgramEnvParameterdvARB",
    /*   626 */ "GetProgramEnvParameterfvARB",
    /*   627 */ "GetProgramLocalParameterdvARB",
    /*   628 */ "GetProgramLocalParameterfvARB",
    /*   629 */ "GetProgramStringARB",
    /*   630 */ "GetProgramivARB",
    /*   631 */ "IsProgramARB",
    /*   632 */ "ProgramEnvParameter4dARB",
    /*   633 */ "ProgramEnvParameter4dvARB",
    /*   634 */ "ProgramEnvParameter4fARB",
    /*   635 */ "ProgramEnvParameter4fvARB",
    /*   636 */ "ProgramLocalParameter4dARB",
    /*   637 */ "ProgramLocalParameter4dvARB",
    /*   638 */ "ProgramLocalParameter4fARB",
    /*   639 */ "ProgramLocalParameter4fvARB",
    /*   640 */ "ProgramStringARB",
    /*   641 */ "VertexAttrib1fARB",
    /*   642 */ "VertexAttrib1fvARB",
    /*   643 */ "VertexAttrib2fARB",
    /*   644 */ "VertexAttrib2fvARB",
    /*   645 */ "VertexAttrib3fARB",
    /*   646 */ "VertexAttrib3fvARB",
    /*   647 */ "VertexAttrib4fARB",
    /*   648 */ "VertexAttrib4fvARB",
    /*   649 */ "AttachObjectARB",
    /*   650 */ "CreateProgramObjectARB",
    /*   651 */ "CreateShaderObjectARB",
    /*   652 */ "DeleteObjectARB",
    /*   653 */ "DetachObjectARB",
    /*   654 */ "GetAttachedObjectsARB",
    /*   655 */ "GetHandleARB",
    /*   656 */ "GetInfoLogARB",
    /*   657 */ "GetObjectParameterfvARB",
    /*   658 */ "GetObjectParameterivARB",
    /*   659 */ "DrawArraysInstancedARB",
    /*   660 */ "DrawElementsInstancedARB",
    /*   661 */ "BindFramebuffer",
    /*   662 */ "BindRenderbuffer",
    /*   663 */ "BlitFramebuffer",
    /*   664 */ "CheckFramebufferStatus",
    /*   665 */ "DeleteFramebuffers",
    /*   666 */ "DeleteRenderbuffers",
    /*   667 */ "FramebufferRenderbuffer",
    /*   668 */ "FramebufferTexture1D",
    /*   669 */ "FramebufferTexture2D",
    /*   670 */ "FramebufferTexture3D",
    /*   671 */ "FramebufferTextureLayer",
    /*   672 */ "GenFramebuffers",
    /*   673 */ "GenRenderbuffers",
    /*   674 */ "GenerateMipmap",
    /*   675 */ "GetFramebufferAttachmentParameteriv",
    /*   676 */ "GetRenderbufferParameteriv",
    /*   677 */ "IsFramebuffer",
    /*   678 */ "IsRenderbuffer",
    /*   679 */ "RenderbufferStorage",
    /*   680 */ "RenderbufferStorageMultisample",
    /*   681 */ "FlushMappedBufferRange",
    /*   682 */ "MapBufferRange",
    /*   683 */ "BindVertexArray",
    /*   684 */ "DeleteVertexArrays",
    /*   685 */ "GenVertexArrays",
    /*   686 */ "IsVertexArray",
    /*   687 */ "GetActiveUniformBlockName",
    /*   688 */ "GetActiveUniformBlockiv",
    /*   689 */ "GetActiveUniformName",
    /*   690 */ "GetActiveUniformsiv",
    /*   691 */ "GetUniformBlockIndex",
    /*   692 */ "GetUniformIndices",
    /*   693 */ "UniformBlockBinding",
    /*   694 */ "CopyBufferSubData",
    /*   695 */ "ClientWaitSync",
    /*   696 */ "DeleteSync",
    /*   697 */ "FenceSync",
    /*   698 */ "GetInteger64v",
    /*   699 */ "GetSynciv",
    /*   700 */ "IsSync",
    /*   701 */ "WaitSync",
    /*   702 */ "DrawElementsBaseVertex",
    /*   703 */ "DrawElementsInstancedBaseVertex",
    /*   704 */ "DrawRangeElementsBaseVertex",
    /*   705 */ "MultiDrawElementsBaseVertex",
    /*   706 */ "ProvokingVertex",
    /*   707 */ "GetMultisamplefv",
    /*   708 */ "SampleMaski",
    /*   709 */ "TexImage2DMultisample",
    /*   710 */ "TexImage3DMultisample",
    /*   711 */ "BlendEquationSeparateiARB",
    /*   712 */ "BlendEquationiARB",
    /*   713 */ "BlendFuncSeparateiARB",
    /*   714 */ "BlendFunciARB",
    /*   715 */ "BindFragDataLocationIndexed",
    /*   716 */ "GetFragDataIndex",
    /*   717 */ "BindSampler",
    /*   718 */ "DeleteSamplers",
    /*   719 */ "GenSamplers",
    /*   720 */ "GetSamplerParameterIiv",
    /*   721 */ "GetSamplerParameterIuiv",
    /*   722 */ "GetSamplerParameterfv",
    /*   723 */ "GetSamplerParameteriv",
    /*   724 */ "IsSampler",
    /*   725 */ "SamplerParameterIiv",
    /*   726 */ "SamplerParameterIuiv",
    /*   727 */ "SamplerParameterf",
    /*   728 */ "SamplerParameterfv",
    /*   729 */ "SamplerParameteri",
    /*   730 */ "SamplerParameteriv",
    /*   731 */ "GetQueryObjecti64v",
    /*   732 */ "GetQueryObjectui64v",
    /*   733 */ "QueryCounter",
    /*   734 */ "ColorP3ui",
    /*   735 */ "ColorP3uiv",
    /*   736 */ "ColorP4ui",
    /*   737 */ "ColorP4uiv",
    /*   738 */ "MultiTexCoordP1ui",
    /*   739 */ "MultiTexCoordP1uiv",
    /*   740 */ "MultiTexCoordP2ui",
    /*   741 */ "MultiTexCoordP2uiv",
    /*   742 */ "MultiTexCoordP3ui",
    /*   743 */ "MultiTexCoordP3uiv",
    /*   744 */ "MultiTexCoordP4ui",
    /*   745 */ "MultiTexCoordP4uiv",
    /*   746 */ "NormalP3ui",
    /*   747 */ "NormalP3uiv",
    /*   748 */ "SecondaryColorP3ui",
    /*   749 */ "SecondaryColorP3uiv",
    /*   750 */ "TexCoordP1ui",
    /*   751 */ "TexCoordP1uiv",
    /*   752 */ "TexCoordP2ui",
    /*   753 */ "TexCoordP2uiv",
    /*   754 */ "TexCoordP3ui",
    /*   755 */ "TexCoordP3uiv",
    /*   756 */ "TexCoordP4ui",
    /*   757 */ "TexCoordP4uiv",
    /*   758 */ "VertexAttribP1ui",
    /*   759 */ "VertexAttribP1uiv",
    /*   760 */ "VertexAttribP2ui",
    /*   761 */ "VertexAttribP2uiv",
    /*   762 */ "VertexAttribP3ui",
    /*   763 */ "VertexAttribP3uiv",
    /*   764 */ "VertexAttribP4ui",
    /*   765 */ "VertexAttribP4uiv",
    /*   766 */ "VertexP2ui",
    /*   767 */ "VertexP2uiv",
    /*   768 */ "VertexP3ui",
    /*   769 */ "VertexP3uiv",
    /*   770 */ "VertexP4ui",
    /*   771 */ "VertexP4uiv",
    /*   772 */ "DrawArraysIndirect",
    /*   773 */ "DrawElementsIndirect",
    /*   774 */ "GetUniformdv",
    /*   775 */ "Uniform1d",
    /*   776 */ "Uniform1dv",
    /*   777 */ "Uniform2d",
    /*   778 */ "Uniform2dv",
    /*   779 */ "Uniform3d",
    /*   780 */ "Uniform3dv",
    /*   781 */ "Uniform4d",
    /*   782 */ "Uniform4dv",
    /*   783 */ "UniformMatrix2dv",
    /*   784 */ "UniformMatrix2x3dv",
    /*   785 */ "UniformMatrix2x4dv",
    /*   786 */ "UniformMatrix3dv",
    /*   787 */ "UniformMatrix3x2dv",
    /*   788 */ "UniformMatrix3x4dv",
    /*   789 */ "UniformMatrix4dv",
    /*   790 */ "UniformMatrix4x2dv",
    /*   791 */ "UniformMatrix4x3dv",
    /*   792 */ "GetActiveSubroutineName",
    /*   793 */ "GetActiveSubroutineUniformName",
    /*   794 */ "GetActiveSubroutineUniformiv",
    /*   795 */ "GetProgramStageiv",
    /*   796 */ "GetSubroutineIndex",
    /*   797 */ "GetSubroutineUniformLocation",
    /*   798 */ "GetUniformSubroutineuiv",
    /*   799 */ "UniformSubroutinesuiv",
    /*   800 */ "PatchParameterfv",
    /*   801 */ "PatchParameteri",
    /*   802 */ "BindTransformFeedback",
    /*   803 */ "DeleteTransformFeedbacks",
    /*   804 */ "DrawTransformFeedback",
    /*   805 */ "GenTransformFeedbacks",
    /*   806 */ "IsTransformFeedback",
    /*   807 */ "PauseTransformFeedback",
    /*   808 */ "ResumeTransformFeedback",
    /*   809 */ "BeginQueryIndexed",
    /*   810 */ "DrawTransformFeedbackStream",
    /*   811 */ "EndQueryIndexed",
    /*   812 */ "GetQueryIndexediv",
    /*   813 */ "ClearDepthf",
    /*   814 */ "DepthRangef",
    /*   815 */ "GetShaderPrecisionFormat",
    /*   816 */ "ReleaseShaderCompiler",
    /*   817 */ "ShaderBinary",
    /*   818 */ "GetProgramBinary",
    /*   819 */ "ProgramBinary",
    /*   820 */ "ProgramParameteri",
    /*   821 */ "GetVertexAttribLdv",
    /*   822 */ "VertexAttribL1d",
    /*   823 */ "VertexAttribL1dv",
    /*   824 */ "VertexAttribL2d",
    /*   825 */ "VertexAttribL2dv",
    /*   826 */ "VertexAttribL3d",
    /*   827 */ "VertexAttribL3dv",
    /*   828 */ "VertexAttribL4d",
    /*   829 */ "VertexAttribL4dv",
    /*   830 */ "VertexAttribLPointer",
    /*   831 */ "DepthRangeArrayv",
    /*   832 */ "DepthRangeIndexed",
    /*   833 */ "GetDoublei_v",
    /*   834 */ "GetFloati_v",
    /*   835 */ "ScissorArrayv",
    /*   836 */ "ScissorIndexed",
    /*   837 */ "ScissorIndexedv",
    /*   838 */ "ViewportArrayv",
    /*   839 */ "ViewportIndexedf",
    /*   840 */ "ViewportIndexedfv",
    /*   841 */ "GetGraphicsResetStatusARB",
    /*   842 */ "GetnColorTableARB",
    /*   843 */ "GetnCompressedTexImageARB",
    /*   844 */ "GetnConvolutionFilterARB",
    /*   845 */ "GetnHistogramARB",
    /*   846 */ "GetnMapdvARB",
    /*   847 */ "GetnMapfvARB",
    /*   848 */ "GetnMapivARB",
    /*   849 */ "GetnMinmaxARB",
    /*   850 */ "GetnPixelMapfvARB",
    /*   851 */ "GetnPixelMapuivARB",
    /*   852 */ "GetnPixelMapusvARB",
    /*   853 */ "GetnPolygonStippleARB",
    /*   854 */ "GetnSeparableFilterARB",
    /*   855 */ "GetnTexImageARB",
    /*   856 */ "GetnUniformdvARB",
    /*   857 */ "GetnUniformfvARB",
    /*   858 */ "GetnUniformivARB",
    /*   859 */ "GetnUniformuivARB",
    /*   860 */ "ReadnPixelsARB",
    /*   861 */ "DrawArraysInstancedBaseInstance",
    /*   862 */ "DrawElementsInstancedBaseInstance",
    /*   863 */ "DrawElementsInstancedBaseVertexBaseInstance",
    /*   864 */ "DrawTransformFeedbackInstanced",
    /*   865 */ "DrawTransformFeedbackStreamInstanced",
    /*   866 */ "GetInternalformativ",
    /*   867 */ "GetActiveAtomicCounterBufferiv",
    /*   868 */ "BindImageTexture",
    /*   869 */ "MemoryBarrier",
    /*   870 */ "TexStorage1D",
    /*   871 */ "TexStorage2D",
    /*   872 */ "TexStorage3D",
    /*   873 */ "TextureStorage1DEXT",
    /*   874 */ "TextureStorage2DEXT",
    /*   875 */ "TextureStorage3DEXT",
    /*   876 */ "ClearBufferData",
    /*   877 */ "ClearBufferSubData",
    /*   878 */ "DispatchCompute",
    /*   879 */ "DispatchComputeIndirect",
    /*   880 */ "CopyImageSubData",
    /*   881 */ "TextureView",
    /*   882 */ "BindVertexBuffer",
    /*   883 */ "VertexAttribBinding",
    /*   884 */ "VertexAttribFormat",
    /*   885 */ "VertexAttribIFormat",
    /*   886 */ "VertexAttribLFormat",
    /*   887 */ "VertexBindingDivisor",
    /*   888 */ "FramebufferParameteri",
    /*   889 */ "GetFramebufferParameteriv",
    /*   890 */ "GetInternalformati64v",
    /*   891 */ "MultiDrawArraysIndirect",
    /*   892 */ "MultiDrawElementsIndirect",
    /*   893 */ "GetProgramInterfaceiv",
    /*   894 */ "GetProgramResourceIndex",
    /*   895 */ "GetProgramResourceLocation",
    /*   896 */ "GetProgramResourceLocationIndex",
    /*   897 */ "GetProgramResourceName",
    /*   898 */ "GetProgramResourceiv",
    /*   899 */ "ShaderStorageBlockBinding",
    /*   900 */ "TexBufferRange",
    /*   901 */ "TexStorage2DMultisample",
    /*   902 */ "TexStorage3DMultisample",
    /*   903 */ "BufferStorage",
    /*   904 */ "ClearTexImage",
    /*   905 */ "ClearTexSubImage",
    /*   906 */ "BindBuffersBase",
    /*   907 */ "BindBuffersRange",
    /*   908 */ "BindImageTextures",
    /*   909 */ "BindSamplers",
    /*   910 */ "BindTextures",
    /*   911 */ "BindVertexBuffers",
    /*   912 */ "MultiDrawArraysIndirectCountARB",
    /*   913 */ "MultiDrawElementsIndirectCountARB",
    /*   914 */ "ClipControl",
    /*   915 */ "BindTextureUnit",
    /*   916 */ "BlitNamedFramebuffer",
    /*   917 */ "CheckNamedFramebufferStatus",
    /*   918 */ "ClearNamedBufferData",
    /*   919 */ "ClearNamedBufferSubData",
    /*   920 */ "ClearNamedFramebufferfi",
    /*   921 */ "ClearNamedFramebufferfv",
    /*   922 */ "ClearNamedFramebufferiv",
    /*   923 */ "ClearNamedFramebufferuiv",
    /*   924 */ "CompressedTextureSubImage1D",
    /*   925 */ "CompressedTextureSubImage2D",
    /*   926 */ "CompressedTextureSubImage3D",
    /*   927 */ "CopyNamedBufferSubData",
    /*   928 */ "CopyTextureSubImage1D",
    /*   929 */ "CopyTextureSubImage2D",
    /*   930 */ "CopyTextureSubImage3D",
    /*   931 */ "CreateBuffers",
    /*   932 */ "CreateFramebuffers",
    /*   933 */ "CreateProgramPipelines",
    /*   934 */ "CreateQueries",
    /*   935 */ "CreateRenderbuffers",
    /*   936 */ "CreateSamplers",
    /*   937 */ "CreateTextures",
    /*   938 */ "CreateTransformFeedbacks",
    /*   939 */ "CreateVertexArrays",
    /*   940 */ "DisableVertexArrayAttrib",
    /*   941 */ "EnableVertexArrayAttrib",
    /*   942 */ "FlushMappedNamedBufferRange",
    /*   943 */ "GenerateTextureMipmap",
    /*   944 */ "GetCompressedTextureImage",
    /*   945 */ "GetNamedBufferParameteri64v",
    /*   946 */ "GetNamedBufferParameteriv",
    /*   947 */ "GetNamedBufferPointerv",
    /*   948 */ "GetNamedBufferSubData",
    /*   949 */ "GetNamedFramebufferAttachmentParameteriv",
    /*   950 */ "GetNamedFramebufferParameteriv",
    /*   951 */ "GetNamedRenderbufferParameteriv",
    /*   952 */ "GetQueryBufferObjecti64v",
    /*   953 */ "GetQueryBufferObjectiv",
    /*   954 */ "GetQueryBufferObjectui64v",
    /*   955 */ "GetQueryBufferObjectuiv",
    /*   956 */ "GetTextureImage",
    /*   957 */ "GetTextureLevelParameterfv",
    /*   958 */ "GetTextureLevelParameteriv",
    /*   959 */ "GetTextureParameterIiv",
    /*   960 */ "GetTextureParameterIuiv",
    /*   961 */ "GetTextureParameterfv",
    /*   962 */ "GetTextureParameteriv",
    /*   963 */ "GetTransformFeedbacki64_v",
    /*   964 */ "GetTransformFeedbacki_v",
    /*   965 */ "GetTransformFeedbackiv",
    /*   966 */ "GetVertexArrayIndexed64iv",
    /*   967 */ "GetVertexArrayIndexediv",
    /*   968 */ "GetVertexArrayiv",
    /*   969 */ "InvalidateNamedFramebufferData",
    /*   970 */ "InvalidateNamedFramebufferSubData",
    /*   971 */ "MapNamedBuffer",
    /*   972 */ "MapNamedBufferRange",
    /*   973 */ "NamedBufferData",
    /*   974 */ "NamedBufferStorage",
    /*   975 */ "NamedBufferSubData",
    /*   976 */ "NamedFramebufferDrawBuffer",
    /*   977 */ "NamedFramebufferDrawBuffers",
    /*   978 */ "NamedFramebufferParameteri",
    /*   979 */ "NamedFramebufferReadBuffer",
    /*   980 */ "NamedFramebufferRenderbuffer",
    /*   981 */ "NamedFramebufferTexture",
    /*   982 */ "NamedFramebufferTextureLayer",
    /*   983 */ "NamedRenderbufferStorage",
    /*   984 */ "NamedRenderbufferStorageMultisample",
    /*   985 */ "TextureBuffer",
    /*   986 */ "TextureBufferRange",
    /*   987 */ "TextureParameterIiv",
    /*   988 */ "TextureParameterIuiv",
    /*   989 */ "TextureParameterf",
    /*   990 */ "TextureParameterfv",
    /*   991 */ "TextureParameteri",
    /*   992 */ "TextureParameteriv",
    /*   993 */ "TextureStorage1D",
    /*   994 */ "TextureStorage2D",
    /*   995 */ "TextureStorage2DMultisample",
    /*   996 */ "TextureStorage3D",
    /*   997 */ "TextureStorage3DMultisample",
    /*   998 */ "TextureSubImage1D",
    /*   999 */ "TextureSubImage2D",
    /*  1000 */ "TextureSubImage3D",
    /*  1001 */ "TransformFeedbackBufferBase",
    /*  1002 */ "TransformFeedbackBufferRange",
    /*  1003 */ "UnmapNamedBuffer",
    /*  1004 */ "VertexArrayAttribBinding",
    /*  1005 */ "VertexArrayAttribFormat",
    /*  1006 */ "VertexArrayAttribIFormat",
    /*  1007 */ "VertexArrayAttribLFormat",
    /*  1008 */ "VertexArrayBindingDivisor",
    /*  1009 */ "VertexArrayElementBuffer",
    /*  1010 */ "VertexArrayVertexBuffer",
    /*  1011 */ "VertexArrayVertexBuffers",
    /*  1012 */ "GetCompressedTextureSubImage",
    /*  1013 */ "GetTextureSubImage",
    /*  1014 */ "InvalidateBufferData",
    /*  1015 */ "InvalidateBufferSubData",
    /*  1016 */ "InvalidateFramebuffer",
    /*  1017 */ "InvalidateSubFramebuffer",
    /*  1018 */ "InvalidateTexImage",
    /*  1019 */ "InvalidateTexSubImage",
    /*  1020 */ "PolygonOffsetEXT",
    /*  1021 */ "DrawTexfOES",
    /*  1022 */ "DrawTexfvOES",
    /*  1023 */ "DrawTexiOES",
    /*  1024 */ "DrawTexivOES",
    /*  1025 */ "DrawTexsOES",
    /*  1026 */ "DrawTexsvOES",
    /*  1027 */ "DrawTexxOES",
    /*  1028 */ "DrawTexxvOES",
    /*  1029 */ "PointSizePointerOES",
    /*  1030 */ "QueryMatrixxOES",
    /*  1031 */ "SampleMaskSGIS",
    /*  1032 */ "SamplePatternSGIS",
    /*  1033 */ "ColorPointerEXT",
    /*  1034 */ "EdgeFlagPointerEXT",
    /*  1035 */ "IndexPointerEXT",
    /*  1036 */ "NormalPointerEXT",
    /*  1037 */ "TexCoordPointerEXT",
    /*  1038 */ "VertexPointerEXT",
    /*  1039 */ "DiscardFramebufferEXT",
    /*  1040 */ "ActiveShaderProgram",
    /*  1041 */ "BindProgramPipeline",
    /*  1042 */ "CreateShaderProgramv",
    /*  1043 */ "DeleteProgramPipelines",
    /*  1044 */ "GenProgramPipelines",
    /*  1045 */ "GetProgramPipelineInfoLog",
    /*  1046 */ "GetProgramPipelineiv",
    /*  1047 */ "IsProgramPipeline",
    /*  1048 */ "LockArraysEXT",
    /*  1049 */ "ProgramUniform1d",
    /*  1050 */ "ProgramUniform1dv",
    /*  1051 */ "ProgramUniform1f",
    /*  1052 */ "ProgramUniform1fv",
    /*  1053 */ "ProgramUniform1i",
    /*  1054 */ "ProgramUniform1iv",
    /*  1055 */ "ProgramUniform1ui",
    /*  1056 */ "ProgramUniform1uiv",
    /*  1057 */ "ProgramUniform2d",
    /*  1058 */ "ProgramUniform2dv",
    /*  1059 */ "ProgramUniform2f",
    /*  1060 */ "ProgramUniform2fv",
    /*  1061 */ "ProgramUniform2i",
    /*  1062 */ "ProgramUniform2iv",
    /*  1063 */ "ProgramUniform2ui",
    /*  1064 */ "ProgramUniform2uiv",
    /*  1065 */ "ProgramUniform3d",
    /*  1066 */ "ProgramUniform3dv",
    /*  1067 */ "ProgramUniform3f",
    /*  1068 */ "ProgramUniform3fv",
    /*  1069 */ "ProgramUniform3i",
    /*  1070 */ "ProgramUniform3iv",
    /*  1071 */ "ProgramUniform3ui",
    /*  1072 */ "ProgramUniform3uiv",
    /*  1073 */ "ProgramUniform4d",
    /*  1074 */ "ProgramUniform4dv",
    /*  1075 */ "ProgramUniform4f",
    /*  1076 */ "ProgramUniform4fv",
    /*  1077 */ "ProgramUniform4i",
    /*  1078 */ "ProgramUniform4iv",
    /*  1079 */ "ProgramUniform4ui",
    /*  1080 */ "ProgramUniform4uiv",
    /*  1081 */ "ProgramUniformMatrix2dv",
    /*  1082 */ "ProgramUniformMatrix2fv",
    /*  1083 */ "ProgramUniformMatrix2x3dv",
    /*  1084 */ "ProgramUniformMatrix2x3fv",
    /*  1085 */ "ProgramUniformMatrix2x4dv",
    /*  1086 */ "ProgramUniformMatrix2x4fv",
    /*  1087 */ "ProgramUniformMatrix3dv",
    /*  1088 */ "ProgramUniformMatrix3fv",
    /*  1089 */ "ProgramUniformMatrix3x2dv",
    /*  1090 */ "ProgramUniformMatrix3x2fv",
    /*  1091 */ "ProgramUniformMatrix3x4dv",
    /*  1092 */ "ProgramUniformMatrix3x4fv",
    /*  1093 */ "ProgramUniformMatrix4dv",
    /*  1094 */ "ProgramUniformMatrix4fv",
    /*  1095 */ "ProgramUniformMatrix4x2dv",
    /*  1096 */ "ProgramUniformMatrix4x2fv",
    /*  1097 */ "ProgramUniformMatrix4x3dv",
    /*  1098 */ "ProgramUniformMatrix4x3fv",
    /*  1099 */ "UnlockArraysEXT",
    /*  1100 */ "UseProgramStages",
    /*  1101 */ "ValidateProgramPipeline",
    /*  1102 */ "DebugMessageCallback",
    /*  1103 */ "DebugMessageControl",
    /*  1104 */ "DebugMessageInsert",
    /*  1105 */ "GetDebugMessageLog",
    /*  1106 */ "GetObjectLabel",
    /*  1107 */ "GetObjectPtrLabel",
    /*  1108 */ "ObjectLabel",
    /*  1109 */ "ObjectPtrLabel",
    /*  1110 */ "PopDebugGroup",
    /*  1111 */ "PushDebugGroup",
    /*  1112 */ "SecondaryColor3fEXT",
    /*  1113 */ "SecondaryColor3fvEXT",
    /*  1114 */ "MultiDrawElementsEXT",
    /*  1115 */ "FogCoordfEXT",
    /*  1116 */ "FogCoordfvEXT",
    /*  1117 */ "ResizeBuffersMESA",
    /*  1118 */ "WindowPos4dMESA",
    /*  1119 */ "WindowPos4dvMESA",
    /*  1120 */ "WindowPos4fMESA",
    /*  1121 */ "WindowPos4fvMESA",
    /*  1122 */ "WindowPos4iMESA",
    /*  1123 */ "WindowPos4ivMESA",
    /*  1124 */ "WindowPos4sMESA",
    /*  1125 */ "WindowPos4svMESA",
    /*  1126 */ "MultiModeDrawArraysIBM",
    /*  1127 */ "MultiModeDrawElementsIBM",
    /*  1128 */ "AreProgramsResidentNV",
    /*  1129 */ "ExecuteProgramNV",
    /*  1130 */ "GetProgramParameterdvNV",
    /*  1131 */ "GetProgramParameterfvNV",
    /*  1132 */ "GetProgramStringNV",
    /*  1133 */ "GetProgramivNV",
    /*  1134 */ "GetTrackMatrixivNV",
    /*  1135 */ "GetVertexAttribdvNV",
    /*  1136 */ "GetVertexAttribfvNV",
    /*  1137 */ "GetVertexAttribivNV",
    /*  1138 */ "LoadProgramNV",
    /*  1139 */ "ProgramParameters4dvNV",
    /*  1140 */ "ProgramParameters4fvNV",
    /*  1141 */ "RequestResidentProgramsNV",
    /*  1142 */ "TrackMatrixNV",
    /*  1143 */ "VertexAttrib1dNV",
    /*  1144 */ "VertexAttrib1dvNV",
    /*  1145 */ "VertexAttrib1fNV",
    /*  1146 */ "VertexAttrib1fvNV",
    /*  1147 */ "VertexAttrib1sNV",
    /*  1148 */ "VertexAttrib1svNV",
    /*  1149 */ "VertexAttrib2dNV",
    /*  1150 */ "VertexAttrib2dvNV",
    /*  1151 */ "VertexAttrib2fNV",
    /*  1152 */ "VertexAttrib2fvNV",
    /*  1153 */ "VertexAttrib2sNV",
    /*  1154 */ "VertexAttrib2svNV",
    /*  1155 */ "VertexAttrib3dNV",
    /*  1156 */ "VertexAttrib3dvNV",
    /*  1157 */ "VertexAttrib3fNV",
    /*  1158 */ "VertexAttrib3fvNV",
    /*  1159 */ "VertexAttrib3sNV",
    /*  1160 */ "VertexAttrib3svNV",
    /*  1161 */ "VertexAttrib4dNV",
    /*  1162 */ "VertexAttrib4dvNV",
    /*  1163 */ "VertexAttrib4fNV",
    /*  1164 */ "VertexAttrib4fvNV",
    /*  1165 */ "VertexAttrib4sNV",
    /*  1166 */ "VertexAttrib4svNV",
    /*  1167 */ "VertexAttrib4ubNV",
    /*  1168 */ "VertexAttrib4ubvNV",
    /*  1169 */ "VertexAttribPointerNV",
    /*  1170 */ "VertexAttribs1dvNV",
    /*  1171 */ "VertexAttribs1fvNV",
    /*  1172 */ "VertexAttribs1svNV",
    /*  1173 */ "VertexAttribs2dvNV",
    /*  1174 */ "VertexAttribs2fvNV",
    /*  1175 */ "VertexAttribs2svNV",
    /*  1176 */ "VertexAttribs3dvNV",
    /*  1177 */ "VertexAttribs3fvNV",
    /*  1178 */ "VertexAttribs3svNV",
    /*  1179 */ "VertexAttribs4dvNV",
    /*  1180 */ "VertexAttribs4fvNV",
    /*  1181 */ "VertexAttribs4svNV",
    /*  1182 */ "VertexAttribs4ubvNV",
    /*  1183 */ "GetTexBumpParameterfvATI",
    /*  1184 */ "GetTexBumpParameterivATI",
    /*  1185 */ "TexBumpParameterfvATI",
    /*  1186 */ "TexBumpParameterivATI",
    /*  1187 */ "AlphaFragmentOp1ATI",
    /*  1188 */ "AlphaFragmentOp2ATI",
    /*  1189 */ "AlphaFragmentOp3ATI",
    /*  1190 */ "BeginFragmentShaderATI",
    /*  1191 */ "BindFragmentShaderATI",
    /*  1192 */ "ColorFragmentOp1ATI",
    /*  1193 */ "ColorFragmentOp2ATI",
    /*  1194 */ "ColorFragmentOp3ATI",
    /*  1195 */ "DeleteFragmentShaderATI",
    /*  1196 */ "EndFragmentShaderATI",
    /*  1197 */ "GenFragmentShadersATI",
    /*  1198 */ "PassTexCoordATI",
    /*  1199 */ "SampleMapATI",
    /*  1200 */ "SetFragmentShaderConstantATI",
    /*  1201 */ "ActiveStencilFaceEXT",
    /*  1202 */ "BindVertexArrayAPPLE",
    /*  1203 */ "GenVertexArraysAPPLE",
    /*  1204 */ "GetProgramNamedParameterdvNV",
    /*  1205 */ "GetProgramNamedParameterfvNV",
    /*  1206 */ "ProgramNamedParameter4dNV",
    /*  1207 */ "ProgramNamedParameter4dvNV",
    /*  1208 */ "ProgramNamedParameter4fNV",
    /*  1209 */ "ProgramNamedParameter4fvNV",
    /*  1210 */ "PrimitiveRestartNV",
    /*  1211 */ "GetTexGenxvOES",
    /*  1212 */ "TexGenxOES",
    /*  1213 */ "TexGenxvOES",
    /*  1214 */ "DepthBoundsEXT",
    /*  1215 */ "BindFramebufferEXT",
    /*  1216 */ "BindRenderbufferEXT",
    /*  1217 */ "StringMarkerGREMEDY",
    /*  1218 */ "BufferParameteriAPPLE",
    /*  1219 */ "FlushMappedBufferRangeAPPLE",
    /*  1220 */ "VertexAttribI1iEXT",
    /*  1221 */ "VertexAttribI1uiEXT",
    /*  1222 */ "VertexAttribI2iEXT",
    /*  1223 */ "VertexAttribI2ivEXT",
    /*  1224 */ "VertexAttribI2uiEXT",
    /*  1225 */ "VertexAttribI2uivEXT",
    /*  1226 */ "VertexAttribI3iEXT",
    /*  1227 */ "VertexAttribI3ivEXT",
    /*  1228 */ "VertexAttribI3uiEXT",
    /*  1229 */ "VertexAttribI3uivEXT",
    /*  1230 */ "VertexAttribI4iEXT",
    /*  1231 */ "VertexAttribI4ivEXT",
    /*  1232 */ "VertexAttribI4uiEXT",
    /*  1233 */ "VertexAttribI4uivEXT",
    /*  1234 */ "ClearColorIiEXT",
    /*  1235 */ "ClearColorIuiEXT",
    /*  1236 */ "BindBufferOffsetEXT",
    /*  1237 */ "BeginPerfMonitorAMD",
    /*  1238 */ "DeletePerfMonitorsAMD",
    /*  1239 */ "EndPerfMonitorAMD",
    /*  1240 */ "GenPerfMonitorsAMD",
    /*  1241 */ "GetPerfMonitorCounterDataAMD",
    /*  1242 */ "GetPerfMonitorCounterInfoAMD",
    /*  1243 */ "GetPerfMonitorCounterStringAMD",
    /*  1244 */ "GetPerfMonitorCountersAMD",
    /*  1245 */ "GetPerfMonitorGroupStringAMD",
    /*  1246 */ "GetPerfMonitorGroupsAMD",
    /*  1247 */ "SelectPerfMonitorCountersAMD",
    /*  1248 */ "GetObjectParameterivAPPLE",
    /*  1249 */ "ObjectPurgeableAPPLE",
    /*  1250 */ "ObjectUnpurgeableAPPLE",
    /*  1251 */ "ActiveProgramEXT",
    /*  1252 */ "CreateShaderProgramEXT",
    /*  1253 */ "UseShaderProgramEXT",
    /*  1254 */ "TextureBarrierNV",
    /*  1255 */ "VDPAUFiniNV",
    /*  1256 */ "VDPAUGetSurfaceivNV",
    /*  1257 */ "VDPAUInitNV",
    /*  1258 */ "VDPAUIsSurfaceNV",
    /*  1259 */ "VDPAUMapSurfacesNV",
    /*  1260 */ "VDPAURegisterOutputSurfaceNV",
    /*  1261 */ "VDPAURegisterVideoSurfaceNV",
    /*  1262 */ "VDPAUSurfaceAccessNV",
    /*  1263 */ "VDPAUUnmapSurfacesNV",
    /*  1264 */ "VDPAUUnregisterSurfaceNV",
    /*  1265 */ "BeginPerfQueryINTEL",
    /*  1266 */ "CreatePerfQueryINTEL",
    /*  1267 */ "DeletePerfQueryINTEL",
    /*  1268 */ "EndPerfQueryINTEL",
    /*  1269 */ "GetFirstPerfQueryIdINTEL",
    /*  1270 */ "GetNextPerfQueryIdINTEL",
    /*  1271 */ "GetPerfCounterInfoINTEL",
    /*  1272 */ "GetPerfQueryDataINTEL",
    /*  1273 */ "GetPerfQueryIdByNameINTEL",
    /*  1274 */ "GetPerfQueryInfoINTEL",
    /*  1275 */ "PolygonOffsetClampEXT",
    /*  1276 */ "StencilFuncSeparateATI",
    /*  1277 */ "ProgramEnvParameters4fvEXT",
    /*  1278 */ "ProgramLocalParameters4fvEXT",
    /*  1279 */ "EGLImageTargetRenderbufferStorageOES",
    /*  1280 */ "EGLImageTargetTexture2DOES",
    /*  1281 */ "AlphaFuncx",
    /*  1282 */ "ClearColorx",
    /*  1283 */ "ClearDepthx",
    /*  1284 */ "Color4x",
    /*  1285 */ "DepthRangex",
    /*  1286 */ "Fogx",
    /*  1287 */ "Fogxv",
    /*  1288 */ "Frustumf",
    /*  1289 */ "Frustumx",
    /*  1290 */ "LightModelx",
    /*  1291 */ "LightModelxv",
    /*  1292 */ "Lightx",
    /*  1293 */ "Lightxv",
    /*  1294 */ "LineWidthx",
    /*  1295 */ "LoadMatrixx",
    /*  1296 */ "Materialx",
    /*  1297 */ "Materialxv",
    /*  1298 */ "MultMatrixx",
    /*  1299 */ "MultiTexCoord4x",
    /*  1300 */ "Normal3x",
    /*  1301 */ "Orthof",
    /*  1302 */ "Orthox",
    /*  1303 */ "PointSizex",
    /*  1304 */ "PolygonOffsetx",
    /*  1305 */ "Rotatex",
    /*  1306 */ "SampleCoveragex",
    /*  1307 */ "Scalex",
    /*  1308 */ "TexEnvx",
    /*  1309 */ "TexEnvxv",
    /*  1310 */ "TexParameterx",
    /*  1311 */ "Translatex",
    /*  1312 */ "ClipPlanef",
    /*  1313 */ "ClipPlanex",
    /*  1314 */ "GetClipPlanef",
    /*  1315 */ "GetClipPlanex",
    /*  1316 */ "GetFixedv",
    /*  1317 */ "GetLightxv",
    /*  1318 */ "GetMaterialxv",
    /*  1319 */ "GetTexEnvxv",
    /*  1320 */ "GetTexParameterxv",
    /*  1321 */ "PointParameterx",
    /*  1322 */ "PointParameterxv",
    /*  1323 */ "TexParameterxv",
};

struct _glapi_table *
_glapi_create_table_from_handle(void *handle, const char *symbol_prefix) {
    struct _glapi_table *disp = calloc(_glapi_get_dispatch_table_size(), sizeof(_glapi_proc));
    char symboln[512];

    if(!disp)
        return NULL;

    if(symbol_prefix == NULL)
        symbol_prefix = "";

    /* Note: This code relies on _glapi_table_func_names being sorted by the
     * entry point index of each function.
     */
    for (int func_index = 0; func_index < GLAPI_TABLE_COUNT; ++func_index) {
        const char *name = _glapi_table_func_names[func_index];
        void ** procp = &((void **)disp)[func_index];

        snprintf(symboln, sizeof(symboln), "%s%s", symbol_prefix, name);
#ifdef _WIN32
        *procp = GetProcAddress(handle, symboln);
#else
        *procp = dlsym(handle, symboln);
#endif
    }
    __glapi_gentable_set_remaining_noop(disp);

    return disp;
}

