'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/*
  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
 * A Variable represents a locally scoped identifier. These include arguments to
 * functions.
 * @class Variable
 */

var Variable = function Variable(name, scope) {
  _classCallCheck(this, Variable);

  /**
   * The variable name, as given in the source code.
   * @member {String} Variable#name
   */
  this.name = name;
  /**
   * List of defining occurrences of this variable (like in 'var ...'
   * statements or as parameter), as AST nodes.
   * @member {esprima.Identifier[]} Variable#identifiers
   */
  this.identifiers = [];
  /**
   * List of {@link Reference|references} of this variable (excluding parameter entries)
   * in its defining scope and all nested scopes. For defining
   * occurrences only see {@link Variable#defs}.
   * @member {Reference[]} Variable#references
   */
  this.references = [];

  /**
   * List of defining occurrences of this variable (like in 'var ...'
   * statements or as parameter), as custom objects.
   * @member {Definition[]} Variable#defs
   */
  this.defs = [];

  this.tainted = false;
  /**
   * Whether this is a stack variable.
   * @member {boolean} Variable#stack
   */
  this.stack = true;
  /**
   * Reference to the enclosing Scope.
   * @member {Scope} Variable#scope
   */
  this.scope = scope;
};

exports.default = Variable;

Variable.CatchClause = 'CatchClause';
Variable.Parameter = 'Parameter';
Variable.FunctionName = 'FunctionName';
Variable.ClassName = 'ClassName';
Variable.Variable = 'Variable';
Variable.ImportBinding = 'ImportBinding';
Variable.TDZ = 'TDZ';
Variable.ImplicitGlobalVariable = 'ImplicitGlobalVariable';

/* vim: set sw=4 ts=4 et tw=80 : */
//# sourceMappingURL=data:application/json;base64,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
